/*
 * Decompiled with CFR 0.152.
 */
package javajs.async;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.plaf.UIResource;

public class AsyncDialog
implements PropertyChangeListener {
    private ActionListener actionListener;
    private Object choice;
    private Object[] options;
    private Object value;
    private boolean wantsInput;
    private boolean processed;

    @Deprecated
    public static String showInputDialog(Component frame, String msg) {
        return JOptionPane.showInputDialog(frame, (Object)msg);
    }

    public void showInputDialog(Component frame, Object message, ActionListener a) {
        this.setListener(a);
        this.wantsInput = true;
        this.process(JOptionPane.showInputDialog(frame, message));
        this.unsetListener();
    }

    public void showInputDialog(Component frame, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue, ActionListener a) {
        this.setListener(a);
        this.wantsInput = true;
        this.process(JOptionPane.showInputDialog(frame, message, title, messageType, icon, selectionValues, initialSelectionValue));
        this.unsetListener();
    }

    public void showMessageDialog(Component frame, Object message, ActionListener a) {
        this.setListener(a);
        JOptionPane.showMessageDialog(frame, message);
        this.unsetListener();
        this.process("" + message);
    }

    public void showMessageDialog(Component frame, Object message, String title, ActionListener a) {
        this.showMessageDialog(frame, message, title, 1, a);
    }

    public void showMessageDialog(Component frame, Object message, String title, int messageType, ActionListener a) {
        this.setListener(a);
        JOptionPane.showMessageDialog(frame, message, title, messageType);
        this.unsetListener();
        this.process("" + message);
    }

    public void showOptionDialog(Component frame, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue, ActionListener a) {
        this.actionListener = a;
        this.options = options;
        this.setListener(a);
        this.process(JOptionPane.showOptionDialog(frame, message, title, optionType, messageType, icon, options, initialValue));
        this.unsetListener();
    }

    public void showConfirmDialog(Component frame, Object message, String title, ActionListener a) {
        this.showConfirmDialog(frame, message, title, 1, 3, a);
    }

    public void showConfirmDialog(Component frame, Object message, String title, int optionType, ActionListener a) {
        this.showConfirmDialog(frame, message, title, optionType, 3, a);
    }

    public void showConfirmDialog(Component frame, Object message, String title, int optionType, int messageType, ActionListener a) {
        this.setListener(a);
        this.process(JOptionPane.showConfirmDialog(frame, message, title, optionType, messageType));
        this.unsetListener();
    }

    public Object getChoice() {
        return this.choice;
    }

    public int getOption() {
        if (!(this.choice instanceof Integer)) {
            throw new IllegalArgumentException("AsyncDialog.getOption called for non-Integer choice");
        }
        return (Integer)this.choice;
    }

    public static void showYesNoAsync(Component parent, Object message, String title, ActionListener listener) {
        new AsyncDialog().showConfirmDialog(parent, message, title == null ? "Question" : title, 0, listener);
    }

    public static void showYesAsync(Component parent, Object message, String title, final Runnable yes) {
        AsyncDialog.showYesNoAsync(parent, message, title, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 0) {
                    yes.run();
                }
            }
        });
    }

    public static void showOKAsync(Component parent, Object message, String title, final Runnable ok) {
        new AsyncDialog().showConfirmDialog(parent, message, title, 2, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getID() == 0) {
                    ok.run();
                }
            }
        });
    }

    private void setListener(ActionListener a) {
        this.actionListener = a;
        Class<JOptionPane> c = JOptionPane.class;
    }

    private void unsetListener() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.value = evt.getNewValue();
        switch (evt.getPropertyName()) {
            case "inputValue": {
                this.process(this.value);
                break;
            }
            case "value": {
                if (this.value != null && this.options == null && !(this.value instanceof Integer)) {
                    this.process(this.getOptionIndex(((JOptionPane)evt.getSource()).getOptions(), this.value));
                    return;
                }
                if (this.options != null) {
                    int i = this.getOptionIndex(this.options, this.value);
                    this.value = i >= 0 ? i : -1;
                }
                this.process(this.value);
            }
        }
    }

    private int getOptionIndex(Object[] options, Object val) {
        if (options != null) {
            int i = 0;
            while (i < options.length) {
                if (options[i] == val) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object getValue() {
        if (this.wantsInput || this.options == null) {
            return this.value;
        }
        int val = (Integer)this.value;
        return val < 0 ? null : this.options[val];
    }

    private void process(int ret) {
        if (ret != -(-ret) || this.processed) {
            return;
        }
        this.processed = true;
        this.choice = ret;
        this.actionListener.actionPerformed(new ActionEvent(this, ret, "SelectedOption"));
    }

    private void process(Object ret) {
        if (ret instanceof UIResource || this.processed) {
            return;
        }
        this.processed = true;
        this.choice = ret;
        this.actionListener.actionPerformed(new ActionEvent(this, ret == null ? 2 : 0, ret == null ? null : ret.toString()));
    }
}

