/*
 * Decompiled with CFR 0.152.
 */
package javajs.async;

import java.awt.Component;
import javajs.async.SwingJSUtils;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public abstract class AsyncSwingWorker
extends SwingWorker<Void, Void>
implements SwingJSUtils.StateMachine {
    private static final String PROPERTY_STATE = "state";
    private static final String PROPERTY_PAUSE = "pause";
    public static final String STARTED_ASYNC = "STARTED_ASYNC";
    public static final String STARTED_SYNC = "STARTED_SYNC";
    public static final String DONE_ASYNC = "DONE_ASYNC";
    public static final String CANCELED_ASYNC = "CANCELED_ASYNC";
    public static final String PAUSED = "PAUSED";
    public static final String RESUMED = "RESUMED";
    protected int progressAsync;
    protected ProgressMonitor progressMonitor;
    protected int delayMillis;
    protected String note;
    protected int min;
    protected int max;
    protected int progressPercent;
    protected boolean isAsync;
    private Exception exception;
    private static final int STATE_INIT = 0;
    private static final int STATE_LOOP = 1;
    private static final int STATE_WAIT = 2;
    private static final int STATE_DONE = 99;
    private SwingJSUtils.StateHelper helper;
    private boolean isPaused;
    private Runnable doneRunnable = new Runnable(){

        @Override
        public void run() {
            AsyncSwingWorker.this.doneAsync();
            AsyncSwingWorker.this.firePropertyChange(AsyncSwingWorker.PROPERTY_STATE, null, AsyncSwingWorker.DONE_ASYNC);
        }
    };

    public abstract void initAsync();

    public abstract int doInBackgroundAsync(int var1);

    public abstract void doneAsync();

    public AsyncSwingWorker(Component owner, String title, int delayMillis, int min, int max) {
        if (title != null && delayMillis > 0) {
            this.progressMonitor = new ProgressMonitor(owner, title, "", Math.min(min, max), Math.max(min, max));
            this.progressMonitor.setProgress(Math.min(min, max));
        }
        this.delayMillis = Math.max(0, delayMillis);
        this.isAsync = delayMillis > 0;
        this.min = min;
        this.max = max;
    }

    public void executeAsync() {
        this.firePropertyChange(PROPERTY_STATE, null, STARTED_ASYNC);
        super.execute();
    }

    public void executeSynchronously() {
        this.firePropertyChange(PROPERTY_STATE, null, STARTED_SYNC);
        this.isAsync = false;
        this.delayMillis = 0;
        try {
            this.doInBackground();
        }
        catch (Exception e) {
            this.exception = e;
            e.printStackTrace();
            this.cancelAsync();
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int min) {
        this.min = min;
        if (this.progressMonitor != null) {
            this.progressMonitor.setMinimum(min);
        }
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int max) {
        if (this.progressMonitor != null) {
            this.progressMonitor.setMaximum(max);
        }
        this.max = max;
    }

    public int getProgressPercent() {
        return this.progressPercent;
    }

    public void setNote(String note) {
        this.note = note;
        if (this.progressMonitor != null) {
            this.progressMonitor.setNote(note);
        }
    }

    public void cancelAsync() {
        this.helper.interrupt();
        this.firePropertyChange(PROPERTY_STATE, null, CANCELED_ASYNC);
    }

    public boolean isCanceledAsync() {
        return !this.helper.isAlive();
    }

    public boolean isDoneAsync() {
        return this.helper.getState() == 99;
    }

    public String getNote(int progress) {
        return String.format("Completed %d%%.\n", progress);
    }

    public String getNote() {
        return this.note;
    }

    public int getProgressAsync() {
        return this.progressAsync;
    }

    public void setProgressAsync(int n) {
        this.progressAsync = n = this.max > this.min ? Math.max(this.min, Math.min(n, this.max)) : Math.max(this.max, Math.min(n, this.min));
        this.progressPercent = n = (n = (n - this.min) * 100 / (this.max - this.min)) < 0 ? 0 : (n > 100 ? 100 : n);
    }

    protected SwingJSUtils.StateHelper getHelper() {
        return this.helper;
    }

    protected void setPaused(boolean tf) {
        if (this.isPaused == tf) {
            return;
        }
        this.isPaused = tf;
        this.firePropertyChange(PROPERTY_PAUSE, null, tf ? PAUSED : RESUMED);
        if (!tf) {
            this.stateLoop();
        }
    }

    protected boolean isPaused() {
        return this.isPaused;
    }

    @Override
    public boolean stateLoop() {
        block5: while (this.helper.isAlive() && !this.isPaused) {
            switch (this.helper.getState()) {
                case 0: {
                    this.setProgressAsync(this.min);
                    this.initAsync();
                    this.helper.setState(2);
                    break;
                }
                case 1: {
                    if (this.checkCanceled()) {
                        this.helper.setState(99);
                        this.cancelAsync();
                        break;
                    }
                    int ret = this.doInBackgroundAsync(this.progressAsync);
                    if (!this.helper.isAlive() || this.isPaused) continue block5;
                    this.progressAsync = ret;
                    this.setProgressAsync(this.progressAsync);
                    this.setNote(this.getNote(this.progressAsync));
                    this.setProgress(this.progressPercent);
                    if (this.progressMonitor != null) {
                        this.progressMonitor.setProgress(this.max > this.min ? this.progressAsync : this.max + this.min - this.progressAsync);
                    }
                    this.helper.setState(this.progressAsync == this.max ? 99 : 2);
                    break;
                }
                case 2: {
                    this.helper.setState(1);
                    this.helper.sleep(this.delayMillis);
                    return true;
                }
                default: {
                    this.stopProgressMonitor();
                    if (this.isAsync) {
                        SwingUtilities.invokeLater(this.doneRunnable);
                    } else {
                        this.doneRunnable.run();
                    }
                    return false;
                }
            }
        }
        if (!this.helper.isAlive()) {
            this.stopProgressMonitor();
        }
        return false;
    }

    private void stopProgressMonitor() {
        if (this.progressMonitor != null) {
            this.progressMonitor.close();
            this.progressMonitor = null;
        }
    }

    private boolean checkCanceled() {
        if (this.isMonitorCanceled() || this.isCancelled()) {
            this.helper.interrupt();
            return true;
        }
        return false;
    }

    private boolean isMonitorCanceled() {
        return this.progressMonitor != null && this.progressMonitor.isCanceled();
    }

    @Override
    protected final Void doInBackground() throws Exception {
        this.helper = new SwingJSUtils.StateHelper(this);
        this.setProgressAsync(this.min);
        this.helper.next(0);
        return null;
    }

    @Override
    public final void done() {
    }

    public class AsyncSubtask {
        private int nextProgress;

        public AsyncSubtask(int nextProgress) {
            this.nextProgress = nextProgress;
        }

        public void start(Runnable r) {
            AsyncSwingWorker.this.setPaused(true);
            new Thread(r).start();
        }

        public void done() {
            AsyncSwingWorker.this.setProgressAsync(this.nextProgress);
            AsyncSwingWorker.this.setPaused(false);
        }
    }
}

