/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class VideoReader {
    int pt = 0;
    String blockType;
    int blockLen;
    byte[] buf = new byte[10];
    protected DataInputStream is;
    protected String codec;
    protected boolean verbose;
    protected String fileType;
    private List<Map<String, Object>> contents;
    private int timeScale;
    private Map<String, Object> thisTrackMap;

    public String getCodec() {
        return this.codec;
    }

    public String getFileType() {
        return this.fileType;
    }

    public VideoReader(File f) throws FileNotFoundException {
        this(new FileInputStream(f));
    }

    public VideoReader(String path) throws IOException {
        this.getStream(path.indexOf("://") > 0 || path.indexOf("file:/") >= 0 ? new URL(path).openStream() : new FileInputStream(path));
    }

    public VideoReader(InputStream stream) {
        this.getStream(stream);
    }

    private void getStream(InputStream stream) {
        this.is = stream instanceof DataInputStream ? (DataInputStream)stream : new DataInputStream(stream);
    }

    public List<Map<String, Object>> getContents(boolean verbose) {
        this.contents = new ArrayList<Map<String, Object>>();
        this.verbose = true;
        while (this.isAvail()) {
            try {
                this.readBlock(this.contents);
            }
            catch (IOException e) {
                break;
            }
        }
        try {
            this.is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.contents;
    }

    protected void readBlock(List<Map<String, Object>> contents) throws IOException {
        int remaining;
        int pt = this.pt;
        this.blockLen = this.readInt();
        this.blockType = this.readString(4);
        if (this.blockLen == 1) {
            this.blockLen = (int)this.is.readLong();
        }
        if (this.verbose) {
            System.out.println(String.valueOf(this.blockType) + "\t" + pt + "\t0x" + Long.toHexString(pt) + "\t" + this.blockLen);
        }
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.put("_pt", pt);
        map.put("_type", this.blockType);
        map.put("_len", this.blockLen);
        contents.add(map);
        if (this.verbose) {
            System.out.println(map);
        }
        if ((remaining = this.readBlock(this.blockType, this.blockLen - 8, map)) < 0) {
            pt = -1;
            return;
        }
        this.skip(remaining);
    }

    protected int readBlock(String blockType, int len, Map<String, Object> map) throws IOException {
        switch (blockType) {
            case "ftyp": {
                len = this.readFTYP(len, map);
                break;
            }
            case "trak": {
                len = this.readInner(len, map);
                if (this.verbose) {
                    this.dumpMap(this.thisTrackMap, "tkhd");
                }
                this.thisTrackMap = null;
                break;
            }
            case "mdia": 
            case "minf": 
            case "moov": 
            case "stbl": {
                len = this.readInner(len, map);
                break;
            }
            case "mvhd": {
                len = this.readMVHD(len, map);
                break;
            }
            case "tkhd": {
                this.thisTrackMap = map;
                len = this.readTKHD(len, map);
                break;
            }
            case "stsd": {
                len = this.readSTSD(len, map);
                break;
            }
            case "smhd": 
            case "vmhd": {
                this.thisTrackMap.put("_trackType", blockType.equals("smhd") ? "sound" : "video");
            }
            default: {
                this.skip(len);
                len = 0;
            }
        }
        return len;
    }

    protected int readInner(int len, Map<String, Object> map) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        map.put("blocks", list);
        while (len > 0) {
            int p = this.pt;
            this.readBlock(list);
            len -= this.pt - p;
        }
        return 0;
    }

    protected int readFTYP(int len, Map<String, Object> map) throws IOException {
        String info = "";
        while (len > 0) {
            String s = this.readString(4);
            len -= 4;
            if (s.charAt(0) == '\u0000') continue;
            info = String.valueOf(info) + s + " ";
        }
        info = info.trim();
        if (this.verbose) {
            System.out.println("filetype=" + info);
        }
        this.fileType = info;
        return len;
    }

    protected int readMVHD(int len, Map<String, Object> map) throws IOException {
        map.put("version_flags", this.readInt());
        map.put("creationTime", this.readUIntLong());
        map.put("modificationTime", this.readUIntLong());
        this.timeScale = this.readInt();
        int dur = this.readInt();
        map.put("timeScale", this.timeScale);
        map.put("duration", dur);
        map.put("_duration(sec)", 1.0 * (double)dur / (double)this.timeScale);
        float rate = this.readInt();
        map.put("preferredRate", Float.valueOf(rate));
        map.put("preferredVolume", this.readShort());
        if (this.verbose) {
            this.dumpMap(map, "mvhd");
        }
        this.skip(len - 26);
        return 0;
    }

    private void dumpMap(Map<String, Object> map, String name) {
        for (Map.Entry<String, Object> e : map.entrySet()) {
            System.out.println(String.valueOf(name) + "." + e.getKey() + ": " + e.getValue());
        }
    }

    protected int readTKHD(int len, Map<String, Object> map) throws IOException {
        map.put("version_flags", this.readInt());
        map.put("creationTime", this.readUIntLong());
        map.put("modificationTime", this.readUIntLong());
        map.put("trackID", this.readInt());
        this.readInt();
        int dur = this.readInt();
        map.put("duration", dur);
        map.put("_duration(sec)", 1.0 * (double)dur / (double)this.timeScale);
        this.skip(len - 24);
        return 0;
    }

    protected int readSTSD(int len, Map<String, Object> map) throws IOException {
        map.put("version_flags", this.readInt());
        map.put("entryCount", this.readInt());
        map.put("size", this.readInt());
        this.codec = this.codec == null ? "" : String.valueOf(this.codec) + ",";
        this.codec = String.valueOf(this.codec) + this.readString(4);
        if (this.verbose) {
            System.out.println("codec=" + this.codec);
        }
        this.skip(len - 16);
        map.put("codec", this.codec);
        return 0;
    }

    protected void skip(int n) throws IOException {
        if (n <= 0) {
            return;
        }
        this.pt += n;
        this.is.skipBytes(n);
    }

    protected byte[] readBytes(int n) throws IOException {
        this.pt += n;
        if (n > this.buf.length) {
            this.buf = new byte[n << 1];
        }
        this.is.read(this.buf, 0, n);
        return this.buf;
    }

    protected long readUIntLong() throws IOException {
        this.pt += 4;
        return (long)this.is.readInt() & 0xFFFFFFFFL;
    }

    protected boolean isAvail() {
        try {
            return this.pt != -1 && this.is.available() > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected int readInt() throws IOException {
        this.pt += 4;
        return this.is.readInt();
    }

    protected int readShort() throws IOException {
        this.pt += 2;
        return this.is.readShort();
    }

    protected String readString(int n) throws IOException {
        return new String(this.readBytes(n), 0, n);
    }
}

