/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.analysis;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.numerics.FFT;

public class FourierAnalysis
implements Data {
    static final double PI2 = Math.PI * 2;
    FFT fft = new FFT();
    double[] fftData;
    double[] omega;
    double[] freqs;
    double[] cosVec;
    double[] sinVec;
    double[] gutterVec;
    ComplexDataset[] complexDatasets = new ComplexDataset[1];
    Dataset[] realDatasets = new Dataset[2];
    boolean radians = false;
    private String name = "Fourier Analysis Complex Data";
    protected int datasetID = this.hashCode();

    public double[] doAnalysis(double[] x, double[] z, int gutter) {
        this.fftData = new double[z.length + 4 * gutter];
        this.gutterVec = new double[2 * gutter];
        System.arraycopy(z, 0, this.fftData, 2 * gutter, z.length);
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        double dx = x[1] - x[0];
        double xmin = x[0] - (double)gutter * dx;
        double xmax = x[x.length - 1] + (double)(gutter + 1) * dx;
        this.omega = this.fft.getNaturalOmega(xmin, xmax);
        this.freqs = this.fft.getNaturalFreq(xmin, xmax);
        this.cosVec = new double[this.omega.length];
        this.sinVec = new double[this.omega.length];
        double norm = this.fftData.length / z.length;
        int i = 0;
        int nOmega = this.omega.length;
        while (i < nOmega) {
            this.cosVec[i] = norm * Math.cos(this.omega[i] * xmin);
            this.sinVec[i] = norm * Math.sin(this.omega[i] * xmin);
            ++i;
        }
        i = 0;
        nOmega = this.omega.length;
        while (i < nOmega) {
            double re = this.fftData[2 * i];
            double im = this.fftData[2 * i + 1];
            this.fftData[2 * i] = re * this.cosVec[i] + im * this.sinVec[i];
            this.fftData[2 * i + 1] = im * this.cosVec[i] - re * this.sinVec[i];
            ++i;
        }
        return this.fftData;
    }

    public double[] repeatAnalysis(double[] z) {
        if (this.fftData == null) {
            int n = z.length;
            double[] x = new double[n];
            double x0 = 0.0;
            double dx = 1.0 / (double)n;
            int i = 0;
            while (i < n) {
                x[i] = x0;
                x0 += dx;
                ++i;
            }
            return this.doAnalysis(x, z, 0);
        }
        System.arraycopy(this.gutterVec, 0, this.fftData, 0, this.gutterVec.length);
        System.arraycopy(this.gutterVec, 0, this.fftData, this.fftData.length - 1 - this.gutterVec.length, this.gutterVec.length);
        System.arraycopy(z, 0, this.fftData, this.gutterVec.length, z.length);
        this.fft.transform(this.fftData);
        this.fft.toNaturalOrder(this.fftData);
        int i = 0;
        int nOmega = this.omega.length;
        while (i < nOmega) {
            double re = this.fftData[2 * i];
            double im = this.fftData[2 * i + 1];
            this.fftData[2 * i] = re * this.cosVec[i] + im * this.sinVec[i];
            this.fftData[2 * i + 1] = im * this.cosVec[i] - re * this.sinVec[i];
            ++i;
        }
        return this.fftData;
    }

    public double[] getNaturalOmega() {
        return this.omega;
    }

    public double[] getNaturalFreq() {
        return this.freqs;
    }

    public void useRadians(boolean radians) {
        this.radians = radians;
    }

    public boolean isRadians() {
        return this.radians;
    }

    @Override
    public List<Data> getDataList() {
        ArrayList<Data> list = new ArrayList<Data>();
        if (this.fftData == null) {
            return list;
        }
        if (this.complexDatasets[0] == null) {
            this.complexDatasets[0] = new ComplexDataset();
            this.complexDatasets[0].setXYColumnNames(DisplayRes.getString("FourierAnalysis.Column.Frequency"), DisplayRes.getString("FourierAnalysis.Column.Real"), DisplayRes.getString("FourierAnalysis.Column.Imaginary"));
        } else {
            this.complexDatasets[0].clear();
        }
        if (this.radians) {
            this.complexDatasets[0].append(this.omega, this.fftData);
        } else {
            this.complexDatasets[0].append(this.freqs, this.fftData);
        }
        list.add(this.complexDatasets[0]);
        return list;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        if (this.fftData == null) {
            return list;
        }
        if (this.realDatasets[0] == null) {
            this.realDatasets[0] = new Dataset();
            this.realDatasets[0].setXYColumnNames(DisplayRes.getString("FourierAnalysis.Column.Frequency"), DisplayRes.getString("FourierAnalysis.Column.Real"), DisplayRes.getString("FourierAnalysis.RealCoefficients"));
            this.realDatasets[0].setLineColor(Color.RED);
            this.realDatasets[1] = new Dataset();
            this.realDatasets[1].setXYColumnNames(DisplayRes.getString("FourierAnalysis.Column.Frequency"), DisplayRes.getString("FourierAnalysis.Column.Imaginary"), DisplayRes.getString("FourierAnalysis.ImaginaryCoefficients"));
            this.realDatasets[1].setLineColor(Color.BLUE);
        } else {
            this.realDatasets[0].clear();
            this.realDatasets[1].clear();
        }
        int n = this.radians ? this.omega.length : this.freqs.length;
        double[] re = new double[n];
        double[] im = new double[n];
        int i = 0;
        while (i < n) {
            re[i] = this.fftData[2 * i];
            im[i] = this.fftData[2 * i + 1];
            ++i;
        }
        double[] x = this.radians ? this.omega : this.freqs;
        this.realDatasets[0].append(x, re);
        this.realDatasets[1].append(x, im);
        list.add(this.realDatasets[0]);
        list.add(this.realDatasets[1]);
        return list;
    }

    @Override
    public double[][] getData2D() {
        if (this.fftData == null) {
            return null;
        }
        double[][] data = new double[3][];
        int n = this.fftData.length / 2;
        data[1] = new double[n];
        data[2] = new double[n];
        int i = 0;
        while (i < n) {
            double re = this.fftData[2 * i];
            double im = this.fftData[2 * i + 1];
            data[1][i] = re;
            data[2][i] = im;
            ++i;
        }
        data[0] = this.radians ? this.omega : this.freqs;
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{this.name};
    }

    @Override
    public Color[] getLineColors() {
        return null;
    }

    @Override
    public Color[] getFillColors() {
        return null;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }
}

