/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.analysis;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.ComplexDataset;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.numerics.FFTReal;

public class FourierSinCosAnalysis
implements Data {
    static final double PI2 = Math.PI * 2;
    FFTReal fft = new FFTReal();
    double[] fftData;
    double[] omega;
    double[] freqs;
    private double[] cosVec;
    private double[] sinVec;
    private double[] gutterVec;
    ComplexDataset[] complexDatasets = new ComplexDataset[1];
    Dataset[] realDatasets = new Dataset[3];
    boolean radians = false;
    private String name = "Fourier Analysis Sin/Cos Data";
    protected int datasetID = this.hashCode();

    public double[] doAnalysis(double[] x, double[] y, int gutter) {
        int offset = y.length % 2;
        this.fftData = new double[y.length + 2 * gutter - offset];
        this.gutterVec = new double[gutter];
        System.arraycopy(y, 0, this.fftData, gutter, y.length - offset);
        this.fft.transform(this.fftData);
        double dx = x[1] - x[0];
        double xmin = x[0] - (double)gutter * dx;
        double xmax = x[x.length - 1 - offset] + (double)(gutter + 1) * dx;
        this.omega = this.fft.getNaturalOmega(xmin, xmax);
        this.freqs = this.fft.getNaturalFreq(xmin, xmax);
        this.cosVec = new double[this.omega.length];
        this.sinVec = new double[this.omega.length];
        double norm = 2.0 / (double)y.length;
        int i = 0;
        int nOmega = this.omega.length;
        while (i < nOmega) {
            this.cosVec[i] = norm * Math.cos(this.omega[i] * xmin);
            this.sinVec[i] = norm * Math.sin(this.omega[i] * xmin);
            ++i;
        }
        this.cosVec[0] = this.cosVec[0] * 0.5;
        this.sinVec[0] = this.sinVec[0] * 0.5;
        i = 0;
        nOmega = this.omega.length;
        while (i < nOmega) {
            double re = this.fftData[2 * i];
            double im = this.fftData[2 * i + 1];
            this.fftData[2 * i] = re * this.cosVec[i] + im * this.sinVec[i];
            this.fftData[2 * i + 1] = -im * this.cosVec[i] + re * this.sinVec[i];
            ++i;
        }
        return this.fftData;
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    public double[] repeatAnalysis(double[] y) {
        int offset = y.length % 2;
        if (this.fftData == null) {
            int n = y.length - offset;
            double[] x = new double[n];
            double x0 = 0.0;
            double dx = 1.0 / (double)n;
            int i = 0;
            while (i < n) {
                x[i] = x0;
                x0 += dx;
                ++i;
            }
            this.doAnalysis(x, y, 0);
        }
        System.arraycopy(this.gutterVec, 0, this.fftData, 0, this.gutterVec.length);
        System.arraycopy(this.gutterVec, 0, this.fftData, this.fftData.length - 1 - this.gutterVec.length, this.gutterVec.length);
        System.arraycopy(y, 0, this.fftData, this.gutterVec.length, y.length - offset);
        this.fft.transform(this.fftData);
        int i = 0;
        int nOmega = this.omega.length;
        while (i < nOmega) {
            double re = this.fftData[2 * i];
            double im = this.fftData[2 * i + 1];
            this.fftData[2 * i] = re * this.cosVec[i] + im * this.sinVec[i];
            this.fftData[2 * i + 1] = im * this.cosVec[i] - re * this.sinVec[i];
            ++i;
        }
        return this.fftData;
    }

    public double[] getNaturalOmega() {
        return this.omega;
    }

    public double[] getNaturalFreq() {
        return this.freqs;
    }

    public void useRadians(boolean radians) {
        this.radians = radians;
    }

    public boolean isRadians() {
        return this.radians;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        if (this.fftData == null) {
            return list;
        }
        if (this.realDatasets[0] == null) {
            this.realDatasets[0] = new Dataset();
            this.realDatasets[0].setXYColumnNames(DisplayRes.getString("FourierAnalysis.Column.Frequency"), DisplayRes.getString("FourierSinCosAnalysis.Column.Power"), DisplayRes.getString("FourierSinCosAnalysis.PowerSpectrum"));
            this.realDatasets[0].setLineColor(Color.GREEN.darker());
            this.realDatasets[0].setMarkerColor(Color.GREEN.darker());
            this.realDatasets[0].setMarkerShape(7);
            this.realDatasets[0].setMarkerSize(4);
            this.realDatasets[1] = new Dataset();
            this.realDatasets[1].setXYColumnNames(DisplayRes.getString("FourierAnalysis.Column.Frequency"), DisplayRes.getString("FourierSinCosAnalysis.Column.Cosine"), DisplayRes.getString("FourierSinCosAnalysis.CosineCoefficients"));
            this.realDatasets[1].setLineColor(Color.CYAN.darker());
            this.realDatasets[1].setMarkerColor(Color.CYAN.darker());
            this.realDatasets[1].setMarkerShape(7);
            this.realDatasets[1].setMarkerSize(4);
            this.realDatasets[2] = new Dataset();
            this.realDatasets[2].setXYColumnNames(DisplayRes.getString("FourierAnalysis.Column.Frequency"), DisplayRes.getString("FourierSinCosAnalysis.Column.Sine"), DisplayRes.getString("FourierSinCosAnalysis.SineCoefficients"));
            this.realDatasets[2].setLineColor(Color.BLUE.darker());
            this.realDatasets[2].setMarkerColor(Color.BLUE.darker());
            this.realDatasets[2].setMarkerShape(7);
            this.realDatasets[2].setMarkerSize(4);
        } else {
            this.realDatasets[0].clear();
            this.realDatasets[1].clear();
            this.realDatasets[2].clear();
        }
        int n = this.radians ? this.omega.length : this.freqs.length;
        double[] re = new double[n];
        double[] im = new double[n];
        double[] cs2 = new double[n];
        int i = 0;
        while (i < n) {
            re[i] = this.fftData[2 * i];
            im[i] = this.fftData[2 * i + 1];
            cs2[i] = re[i] * re[i] + im[i] * im[i];
            ++i;
        }
        double[] x = this.radians ? this.omega : this.freqs;
        this.realDatasets[0].append(x, cs2);
        this.realDatasets[1].append(x, this.radians ? im : re);
        this.realDatasets[2].append(x, this.radians ? re : im);
        list.add(this.realDatasets[0]);
        list.add(this.realDatasets[1]);
        list.add(this.realDatasets[2]);
        return list;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{this.name};
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Color[] getLineColors() {
        return null;
    }

    @Override
    public Color[] getFillColors() {
        return null;
    }

    @Override
    public double[][] getData2D() {
        if (this.fftData == null) {
            return null;
        }
        double[][] data = new double[4][];
        int n = this.fftData.length / 2;
        data[1] = new double[n];
        data[2] = new double[n];
        data[3] = new double[n];
        int i = 0;
        while (i < n) {
            double cos = this.fftData[2 * i];
            double sin = this.fftData[2 * i + 1];
            data[1][i] = sin * sin + cos * cos;
            data[2][i] = cos;
            data[3][i] = sin;
            ++i;
        }
        data[0] = this.radians ? this.omega : this.freqs;
        return data;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }
}

