/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.opensourcephysics.cabrillo.tracker.AnalyticFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class AnalyticParticle
extends ParticleModel {
    UserFunction[] functions;

    public AnalyticParticle() {
        this.points = new Point2D.Double[]{new Point2D.Double()};
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionEditor = new UserFunctionEditor();
        this.functionPanel = new AnalyticFunctionPanel(this.functionEditor, this);
        this.createMassAndTimeParameters();
        String[] t = new String[]{"t"};
        UserFunction[] ff = new UserFunction[]{new UserFunction("x", t, TrackerRes.getString("AnalyticParticle.PositionFunction.X.Description")), new UserFunction("y", t, TrackerRes.getString("AnalyticParticle.PositionFunction.Y.Description"))};
        this.functionEditor.setMainFunctions(ff);
    }

    @Override
    protected boolean getNextTracePositions() {
        double x = this.functions[0].evaluate(this.time);
        double y = this.functions[1].evaluate(this.time);
        this.points[this.myPoint].setLocation(x, y);
        return true;
    }

    @Override
    protected void reset() {
        this.t0 = this.getInitialValues()[0];
        this.functions = this.getFunctionEditor().getMainFunctions();
        if (this.tp != null) {
            this.erase();
            this.dt = this.tp.getPlayer().getMeanStepDuration() / (double)(1000 * tracePtsPerStep);
            VideoClip clip = this.tp.getPlayer().getVideoClip();
            int end = Math.min(this.getEndFrame(), clip.getLastFrameNumber());
            while (end > this.getStartFrame() && !clip.includesFrame(end)) {
                --end;
            }
            if (end == this.getStartFrame() && !clip.includesFrame(this.getStartFrame())) {
                this.steps.setLength(1);
                this.steps.setStep(0, null);
                int i = 0;
                while (i < this.tp.andWorld.size()) {
                    Integer panelID = this.tp.andWorld.get(i);
                    this.getVArray(panelID).setLength(0);
                    this.getAArray(panelID).setLength(0);
                    ++i;
                }
                this.traceX = new double[0];
                this.traceY = new double[0];
                this.fireStepsChanged();
                return;
            }
            int firstFrameInClip = this.getStartFrame();
            while (firstFrameInClip < end && !clip.includesFrame(firstFrameInClip)) {
                ++firstFrameInClip;
            }
            this.steps.setLength(firstFrameInClip + 1);
            PositionStep step = (PositionStep)this.getStep(firstFrameInClip);
            int i = 0;
            while (i < this.steps.array.length) {
                if (i < firstFrameInClip) {
                    this.steps.setStep(i, null);
                } else if (step == null) {
                    step = new PositionStep(this, firstFrameInClip, 0.0, 0.0);
                    step.setFootprint(this.getFootprint());
                    this.steps.setStep(firstFrameInClip, step);
                }
                ++i;
            }
            this.getVArray(this.tp.getID()).setLength(0);
            this.getAArray(this.tp.getID()).setLength(0);
            ImageCoordSystem coords = this.tp.getCoords();
            boolean useDefault = this.isUseDefaultReferenceFrame();
            while (useDefault && coords instanceof ReferenceFrame) {
                coords = ((ReferenceFrame)coords).getCoords();
            }
            AffineTransform transform = coords.getToImageTransform(firstFrameInClip);
            UserFunction[] functions = this.getFunctionEditor().getMainFunctions();
            this.time = this.tp.getPlayer().getFrameTime(firstFrameInClip) / 1000.0;
            double x = functions[0].evaluate(this.time);
            double y = functions[1].evaluate(this.time);
            Point2D.Double point = this.points[this.myPoint];
            point.setLocation(x, y);
            transform.transform(point, point);
            this.traceX = new double[]{point.x};
            this.traceY = new double[]{point.y};
            step.getPosition().setPosition(point);
            this.setLastValidFrame(firstFrameInClip);
            this.firePropertyChange("step", null, firstFrameInClip);
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    extends ParticleModel.Loader {
        Loader() {
        }

        @Override
        public Object createObject(XMLControl control) {
            return new AnalyticParticle();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            try {
                XML.getLoader(ParticleModel.class).loadObject(control, obj);
            }
            catch (Exception ex) {
                AnalyticParticle p = (AnalyticParticle)obj;
                String t = control.getString("t0");
                p.getInitEditor().setExpression("t", t, false);
                String x = control.getString("x");
                p.getFunctionEditor().setExpression("x", x, false);
                String y = control.getString("y");
                p.getFunctionEditor().setExpression("y", y, false);
                p.reset();
            }
            return obj;
        }
    }
}

