/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.ProtractorStep;
import org.opensourcephysics.cabrillo.tracker.Ruler;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public class AngleRuler
extends Ruler {
    public AngleRuler(Protractor protractor) {
        super(protractor);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel, int n) {
        if (trackerPanel.isWorldPanel()) {
            return null;
        }
        this.refreshStrokes();
        this.format.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        TPoint vertex = this.track.getStep(n).getPoints()[0];
        TPoint baseEnd = this.track.getStep(n).getPoints()[1];
        Point screenVertex = vertex.getScreenPosition(trackerPanel);
        double screenRadius = screenVertex.distance(baseEnd.getScreenPosition(trackerPanel));
        double baseAngle = -vertex.angle(baseEnd);
        this.transform.setToRotation(-baseAngle, screenVertex.x, screenVertex.y);
        boolean isDegrees = !this.track.tframe.isAnglesInRadians();
        double delta = this.rulerLineSpacing / screenRadius;
        if (isDegrees) {
            delta *= 57.29577951308232;
        }
        int majorSpacing = 0;
        int halfSpacing = 0;
        if (isDegrees && delta > 0.5) {
            int spacing = delta <= 1.0 ? 1 : (delta <= 2.0 ? 2 : (delta <= 5.0 ? 5 : (delta <= 10.0 ? 10 : (delta <= 15.0 ? 15 : 30))));
            switch (spacing) {
                case 1: {
                    majorSpacing = 10;
                    halfSpacing = 5;
                    break;
                }
                case 2: {
                    majorSpacing = 15;
                    halfSpacing = 5;
                    break;
                }
                case 5: {
                    majorSpacing = 18;
                    halfSpacing = 2;
                    break;
                }
                case 10: {
                    majorSpacing = 9;
                    halfSpacing = 1;
                    break;
                }
                case 15: {
                    majorSpacing = 3;
                    halfSpacing = 1;
                    break;
                }
                case 30: {
                    majorSpacing = 3;
                    halfSpacing = 1;
                }
            }
            delta = spacing;
        } else {
            double power = 1.0;
            while (power * 10.0 < delta) {
                power *= 10.0;
            }
            while (power > delta) {
                power /= 10.0;
            }
            double significand = delta / power;
            int spacing = significand <= 2.0 ? 2 : (significand <= 5.0 ? 5 : 10);
            majorSpacing = spacing == 2 ? 25 : 10;
            halfSpacing = spacing == 5 ? 2 : 5;
            delta = (double)spacing * power;
        }
        Line2D.Double armLine = null;
        ProtractorStep step = (ProtractorStep)this.track.getStep(n);
        TPoint armEnd = step.getPoints()[2];
        double armRadius = screenVertex.distance(armEnd.getScreenPosition(trackerPanel));
        double armAngle = step.getProtractorAngle(false);
        double cos = Math.cos(armAngle);
        double sin = Math.sin(armAngle);
        if (armRadius < screenRadius) {
            armLine = new Line2D.Double((double)screenVertex.x + armRadius * cos, (double)screenVertex.y - armRadius * sin, (double)screenVertex.x + screenRadius * cos, (double)screenVertex.y - screenRadius * sin);
        }
        int i = 0;
        while (i < this.lines.size()) {
            ((ArrayList)this.lines.get(i)).clear();
            ++i;
        }
        this.labelMarks.clear();
        int inset = this.rulerSize > 0.0 ? this.insetPerLevel : -this.insetPerLevel;
        double factor = FontSizer.getFactor();
        double formatMinValue = (double)majorSpacing * delta;
        double labelRadius = screenRadius + factor * (double)this.labelGap;
        double ang = isDegrees ? 180.0 : Math.PI;
        int lineCount = (int)Math.ceil(ang / delta);
        int i2 = 1;
        while (i2 < lineCount) {
            int level = i2 % majorSpacing == 0 ? 0 : (i2 % halfSpacing == 0 ? 1 : 2);
            double angleInRadians = isDegrees ? (double)i2 * delta * Math.PI / 180.0 : (double)i2 * delta;
            ArrayList drawLines = (ArrayList)this.lines.get(level);
            double lineLength = this.rulerSize - (double)(inset * level);
            double inside = screenRadius - lineLength;
            cos = Math.cos(angleInRadians);
            sin = Math.sin(angleInRadians);
            Line2D.Double line = new Line2D.Double();
            drawLines.add(line);
            ((Line2D)line).setLine((double)screenVertex.x + inside * cos, (double)screenVertex.y - inside * sin, (double)screenVertex.x + screenRadius * cos, (double)screenVertex.y - screenRadius * sin);
            line = new Line2D.Double();
            drawLines.add(line);
            ((Line2D)line).setLine((double)screenVertex.x + inside * cos, (double)screenVertex.y + inside * sin, (double)screenVertex.x + screenRadius * cos, (double)screenVertex.y + screenRadius * sin);
            if (level == 0) {
                String s = this.getFormattedValue((double)i2 * delta, formatMinValue);
                if (isDegrees) {
                    s = String.valueOf(s) + "\u00b0";
                }
                Ruler.Label label = new Ruler.Label(this, s, (double)screenVertex.x + labelRadius * cos, (double)screenVertex.y - labelRadius * sin);
                label.rotation = 1.5707963267948966 - angleInRadians + (this.isLabelFlipped(baseAngle + angleInRadians) ? Math.PI : 0.0);
                this.labelMarks.add(label);
                s = this.getFormattedValue((double)(-i2) * delta, formatMinValue);
                if (isDegrees) {
                    s = String.valueOf(s) + "\u00b0";
                }
                label = new Ruler.Label(this, s, (double)screenVertex.x + labelRadius * cos, (double)screenVertex.y + labelRadius * sin);
                label.rotation = angleInRadians + 1.5707963267948966 + (this.isLabelFlipped(baseAngle - angleInRadians) ? Math.PI : 0.0);
                this.labelMarks.add(label);
            }
            ++i2;
        }
        String s = this.getFormattedValue(0.0, formatMinValue);
        if (isDegrees) {
            s = String.valueOf(s) + "\u00b0";
        }
        Ruler.Label label = new Ruler.Label(this, s, (double)screenVertex.x + labelRadius, screenVertex.y);
        label.rotation = this.isLabelFlipped(baseAngle) ? -1.5707963267948966 : 1.5707963267948966;
        this.labelMarks.add(label);
        if (isDegrees) {
            s = this.getFormattedValue(180.0, formatMinValue);
            s = String.valueOf(s) + "\u00b0";
            label = new Ruler.Label(this, s, (double)screenVertex.x - labelRadius, screenVertex.y);
            label.rotation = this.isLabelFlipped(baseAngle - Math.PI) ? 1.5707963267948966 : -1.5707963267948966;
            this.labelMarks.add(label);
        }
        Line2D.Double vertexLine = new Line2D.Double(screenVertex.x, screenVertex.y - this.insetPerLevel / 2, screenVertex.x, screenVertex.y + this.insetPerLevel / 2);
        Line2D.Double base = new Line2D.Double(screenVertex.x, screenVertex.y, (double)screenVertex.x - screenRadius, screenVertex.y);
        Arc2D.Double arc = new Arc2D.Double();
        arc.setArcByCenter(screenVertex.x, screenVertex.y, screenRadius, 0.0, 360.0, 0);
        BasicStroke str = this.strokes[0];
        final MultiShape arcMultiShape = armLine != null ? new MultiShape(arc, base, vertexLine, armLine).andStroke(str, str, str, this.dashedStroke).transform(this.transform) : new MultiShape(arc, base, vertexLine).andStroke(str, str, str).transform(this.transform);
        int i3 = 0;
        while (i3 < this.lines.size()) {
            ArrayList drawLines = (ArrayList)this.lines.get(i3);
            Shape[] lineArray = drawLines.toArray(new Line2D[drawLines.size()]);
            Object[] lineStrokes = new Stroke[lineArray.length];
            Arrays.fill(lineStrokes, this.strokes[i3]);
            this.multiShapes[i3] = new MultiShape(lineArray).andStroke((Stroke[])lineStrokes).transform(this.transform);
            ++i3;
        }
        final MultiShape[] myShapes = Arrays.copyOf(this.multiShapes, this.multiShapes.length);
        final AffineTransform myTransform = new AffineTransform(this.transform);
        final Ruler.Label[] myLabels = this.labelMarks.toArray(new Ruler.Label[this.labelMarks.size()]);
        return new Mark(){

            @Override
            public void draw(Graphics2D g, boolean highlighted) {
                Graphics2D g2 = (Graphics2D)g.create();
                if (OSPRuntime.setRenderingHints) {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                int i = 0;
                while (i < myShapes.length) {
                    g2.setPaint(AngleRuler.this.colors[i]);
                    myShapes[i].draw(g2);
                    ++i;
                }
                g2.setPaint(AngleRuler.this.colors[0]);
                arcMultiShape.draw(g2);
                AffineTransform t = g2.getTransform();
                t.concatenate(myTransform);
                g2.setTransform(t);
                int i2 = 0;
                while (i2 < myLabels.length) {
                    myLabels[i2].draw(g2);
                    ++i2;
                }
                g2.dispose();
            }
        };
    }

    private boolean isLabelFlipped(double angle) {
        double offset;
        return (angle = angle < -Math.PI ? angle + Math.PI * 2 : (angle > Math.PI ? angle - Math.PI * 2 : angle)) < -(offset = 0.1) && angle > -Math.PI + offset;
    }
}

