/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.display.ResizableIcon;

public class ArrowFootprint
extends LineFootprint {
    protected double stretch = 1.0;
    protected int tipLength = 16;
    protected int tipWidth = 4;
    boolean openHead = true;
    protected BasicStroke headStroke = new BasicStroke();
    protected BasicStroke tipStroke;

    public ArrowFootprint(String name) {
        super(name);
    }

    public void setStretch(double stretch) {
        this.stretch = stretch;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setTipLength(int tipLength) {
        tipLength = Math.max(32, tipLength);
        this.tipWidth = tipLength / 4;
        this.tipLength = 4 * this.tipWidth;
    }

    public void setSolidHead(boolean solid) {
        this.openHead = !solid;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke == null) {
            return;
        }
        super.setStroke(stroke);
        this.headStroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, null, stroke.getDashPhase());
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        Point[] points = new Point[]{new Point(), new Point(w - 2, 2 - h)};
        MultiShape shape = this.getShape(points, 1);
        ShapeIcon icon = new ShapeIcon(shape, w, h);
        icon.setColor(this.color);
        icon.setStroke(this.stroke);
        return new ResizableIcon(icon);
    }

    @Override
    public synchronized MultiShape getShape(Point[] points, int scale) {
        float lineWidth;
        this.highlight = null;
        Point p1 = points[0];
        Point p2 = points[1];
        if (points.length > 3) {
            p1 = points[3];
        }
        double theta = Math.atan2(p1.y - p2.y, p1.x - p2.x);
        this.transform.setToRotation(theta, p1.x, p1.y);
        this.transform.translate(p1.x, p1.y);
        if (scale > 1) {
            this.transform.scale(scale, scale);
        }
        this.transform.setToRotation(theta, p2.x, p2.y);
        this.transform.translate(p2.x, p2.y);
        float d = (float)p1.distance(p2);
        int tiplen = this.tipLength * scale;
        int tipL = Math.min(tiplen, Math.round(d - 4.0f));
        tipL = Math.max(8, tipL);
        int tipW = Math.max(tipL / 4, 2);
        float f = (float)scale * this.baseStroke.getLineWidth();
        float f2 = lineWidth = f < (float)(tipL / 4) ? f : Math.max((float)(tipL / 4), 0.8f);
        if (this.stroke == null || this.stroke.getLineWidth() != lineWidth) {
            this.stroke = new BasicStroke(lineWidth, 0, 0, 8.0f, this.baseStroke.getDashArray(), this.baseStroke.getDashPhase());
            this.headStroke = new BasicStroke(lineWidth, 0, 0, 8.0f, null, this.stroke.getDashPhase());
        }
        try {
            this.path.reset();
            this.path.moveTo(d - 4.0f, 0.0f);
            this.path.lineTo(d - 6.0f, -2.0f);
            this.path.lineTo(d, 0.0f);
            this.path.lineTo(d - 6.0f, 2.0f);
            this.path.closePath();
            this.hitShapes[0] = this.transform.createTransformedShape(this.path);
            d = d - (float)((double)this.stroke.getLineWidth() * 1.58) + 1.0f;
            this.path.reset();
            this.path.moveTo(0.0f, 0.0f);
            this.path.lineTo(d - (float)tipL, 0.0f);
            this.hitShapes[2] = this.transform.createTransformedShape(this.path);
            this.hitShapes[1] = new Rectangle(p2.x - 1, p2.y - 1, 2, 2);
            this.path.reset();
            this.path.moveTo(0.0f, 0.0f);
            this.path.lineTo(d - (float)tipL + (float)tipW, 0.0f);
            Shape shaft = this.transform.createTransformedShape(this.path);
            this.path.reset();
            this.path.moveTo(d - (float)tipL + (float)tipW, 0.0f);
            this.path.lineTo(d - (float)tipL, -tipW);
            this.path.lineTo(d, 0.0f);
            this.path.lineTo(d - (float)tipL, tipW);
            this.path.closePath();
            Shape head = this.transform.createTransformedShape(this.path);
            this.highlight = new MultiShape(head).andFill(true);
            return new MultiShape(shaft, head).andFill(false, !this.openHead);
        }
        catch (Exception e) {
            d = (float)p1.distance(p2);
            Line2D.Double line = new Line2D.Double(0.0, 0.0, d, 0.0);
            return new MultiShape(this.transform.createTransformedShape(line));
        }
    }
}

