/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.cabrillo.tracker.CircleFitter;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.tools.FontSizer;

public class AttachmentDialog
extends JDialog
implements PropertyChangeListener {
    protected int trackID;
    protected TFrame frame;
    protected Integer panelID;
    protected boolean isVisible;
    protected JButton closeButton;
    protected JButton helpButton;
    protected ArrayList<TTrack> attachableTracks;
    protected JTable table;
    protected int cellheight = 28;
    protected JComboBox<Object> rendererDropdown;
    protected JComboBox<Object> editorDropdown;
    protected JComboBox<TTrack> measuringToolDropdown;
    protected TTrack dummyMass;
    protected Icon dummyIcon = new ShapeIcon(null, 21, 16);
    protected JScrollPane scrollPane;
    protected AttachmentCellRenderer attachmentCellRenderer = new AttachmentCellRenderer();
    protected TTrackRenderer trackCellRenderer = new TTrackRenderer();
    protected TTrackRenderer trackEditorRenderer = new TTrackRenderer();
    protected TTrackRenderer toolRenderer = new TTrackRenderer();
    protected JPanel attachmentsPanel;
    protected JPanel circleFitterPanel;
    protected JPanel circleFitterStartStopPanel;
    protected JRadioButton stepsButton;
    protected JRadioButton tracksButton;
    protected JCheckBox relativeCheckbox;
    protected IntegerField startField;
    protected IntegerField countField;
    protected JLabel startLabel;
    protected JLabel countLabel;
    protected boolean refreshing;
    private ComponentListener myFollower;
    private static final String[] panelProps = new String[]{"track", "selectedtrack", "clear"};

    public AttachmentDialog(TTrack track) {
        super(JOptionPane.getFrameForComponent(track.tp), false);
        this.panelID = track.tp.getID();
        this.frame = track.tframe;
        this.createGUI();
        this.setMeasuringTool(track);
        this.refreshDropdowns();
        track.tp.addListeners(panelProps, this);
        this.myFollower = this.frame.addFollower(this, null);
        this.frame.addPropertyChangeListener("tab", this);
        this.refreshGUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block7 : switch (e.getPropertyName()) {
            case "tab": {
                TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
                if (!this.frame.isRemovingAll() && this.panelID != null && e.getNewValue() == trackerPanel) {
                    this.setVisible(this.isVisible);
                    break;
                }
                boolean vis = this.isVisible;
                this.setVisible(false);
                this.isVisible = vis;
                break;
            }
            case "track": {
                TTrack deleted = (TTrack)e.getOldValue();
                if (deleted != null) {
                    deleted.removeListenerNCF(this);
                    TTrack measuringTool = TTrack.getTrack(this.trackID);
                    if (measuringTool != null) {
                        if (measuringTool != deleted) {
                            TTrack[] attachments = measuringTool.getAttachments();
                            int i = 0;
                            while (i < attachments.length) {
                                if (deleted == attachments[i] || deleted == measuringTool) {
                                    attachments[i] = null;
                                }
                                ++i;
                            }
                            measuringTool.refreshAttachments();
                        } else {
                            this.trackID = 0;
                        }
                    }
                }
                this.refreshDropdowns();
                this.refreshGUI();
                break;
            }
            case "selectedtrack": {
                if (e.getNewValue() == null) break;
                TTrack track = (TTrack)e.getNewValue();
                int i = 0;
                while (i < this.measuringToolDropdown.getItemCount()) {
                    if (track == this.measuringToolDropdown.getItemAt(i)) {
                        this.measuringToolDropdown.setSelectedIndex(i);
                        break block7;
                    }
                    ++i;
                }
                break;
            }
            case "clear": {
                for (TTrack t : TTrack.getValues()) {
                    t.removeListenerNCF(this);
                }
                this.refreshDropdowns();
                this.refreshGUI();
                break;
            }
            case "dataPoint": {
                TTrack measuringTool = TTrack.getTrack(this.trackID);
                measuringTool.refreshAttachments();
                DefaultTableModel dm = (DefaultTableModel)this.table.getModel();
                dm.fireTableDataChanged();
                break;
            }
            default: {
                this.refreshGUI();
            }
        }
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        this.isVisible = vis;
    }

    @Override
    public void dispose() {
        if (this.panelID != null) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            trackerPanel.removeListeners(panelProps, this);
            for (TTrack p : this.attachableTracks) {
                p.removeListenerNCF(this);
            }
            this.attachableTracks.clear();
            this.dummyMass.delete();
            this.dummyMass = null;
            TTrack measuringTool = TTrack.getTrack(this.trackID);
            if (measuringTool.ttype == 1) {
                measuringTool.removePropertyChangeListener("dataPoint", this);
            }
            if (this.frame != null) {
                this.frame.removePropertyChangeListener("tab", this);
                this.frame.removeComponentListener(this.myFollower);
                this.myFollower = null;
            }
            trackerPanel.attachmentDialog = null;
            this.panelID = null;
            this.frame = null;
        }
        super.dispose();
    }

    private void createGUI() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        this.attachmentsPanel = new JPanel(new BorderLayout());
        contentPane.add((Component)this.attachmentsPanel, "Center");
        JPanel north = new JPanel();
        north.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.measuringToolDropdown = new JComboBox();
        this.measuringToolDropdown.setRenderer(this.toolRenderer);
        this.measuringToolDropdown.addActionListener(e -> {
            TTrack measuringTool;
            TTrack tool = (TTrack)this.measuringToolDropdown.getSelectedItem();
            if (tool == (measuringTool = TTrack.getTrack(this.trackID))) {
                return;
            }
            this.setMeasuringTool(tool);
        });
        north.add(this.measuringToolDropdown);
        this.attachmentsPanel.add((Component)north, "North");
        this.dummyMass = new PointMass();
        this.rendererDropdown = new JComboBox<Object>(new AttachmentComboBoxModel());
        this.rendererDropdown.setRenderer(this.trackCellRenderer);
        this.editorDropdown = new JComboBox<Object>(new AttachmentComboBoxModel());
        this.editorDropdown.setRenderer(this.trackCellRenderer);
        this.table = new JTable(new AttachmentTableModel()){

            @Override
            public void setFont(Font font) {
                super.setFont(font);
                AttachmentDialog.this.cellheight = font.getSize() + 16;
                this.setRowHeight(AttachmentDialog.this.cellheight);
                int w = (int)(60.0 * (1.0 + (double)FontSizer.getLevel() * 0.3));
                this.getColumnModel().getColumn(0).setPreferredWidth(w);
                this.getColumnModel().getColumn(1).setPreferredWidth(2 * w);
                this.getTableHeader().setPreferredSize(new Dimension(w, AttachmentDialog.this.cellheight));
            }
        };
        this.attachmentCellRenderer = new AttachmentCellRenderer();
        this.table.setDefaultRenderer(TTrack.class, this.attachmentCellRenderer);
        this.table.setDefaultRenderer(String.class, this.attachmentCellRenderer);
        this.table.setRowHeight(this.cellheight);
        AttachmentCellEditor editor = new AttachmentCellEditor();
        this.table.getColumnModel().getColumn(1).setCellEditor(editor);
        this.scrollPane = new JScrollPane(this.table){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                int cellCount = Math.max(4, AttachmentDialog.this.table.getRowCount() + 1);
                cellCount = Math.min(10, cellCount);
                dim.height = cellCount * AttachmentDialog.this.cellheight + 8;
                dim.width = AttachmentDialog.this.table.getPreferredSize().width + 20;
                return dim;
            }
        };
        JPanel center = new JPanel(new GridLayout(1, 1));
        this.attachmentsPanel.add((Component)center, "Center");
        center.add(this.scrollPane);
        center.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.stepsButton = new JRadioButton();
        this.tracksButton = new JRadioButton();
        AbstractAction tracksOrStepsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AttachmentDialog.this.refreshing) {
                    return;
                }
                CircleFitter fitter = (CircleFitter)TTrack.getTrack(AttachmentDialog.this.trackID);
                fitter.attachToSteps = !AttachmentDialog.this.tracksButton.isSelected();
                fitter.refreshAttachments();
                AttachmentDialog.this.refreshGUI();
                DefaultTableModel dm = (DefaultTableModel)AttachmentDialog.this.table.getModel();
                dm.fireTableDataChanged();
            }
        };
        this.stepsButton.addActionListener(tracksOrStepsAction);
        this.tracksButton.addActionListener(tracksOrStepsAction);
        ButtonGroup group = new ButtonGroup();
        group.add(this.stepsButton);
        group.add(this.tracksButton);
        this.tracksButton.setSelected(true);
        this.relativeCheckbox = new JCheckBox();
        this.relativeCheckbox.setSelected(false);
        this.relativeCheckbox.addActionListener(e -> {
            if (this.refreshing) {
                return;
            }
            CircleFitter fitter = (CircleFitter)TTrack.getTrack(this.trackID);
            fitter.isRelativeFrameNumbers = this.relativeCheckbox.isSelected();
            this.refreshFieldsAndButtons(fitter);
            fitter.refreshAttachments();
            this.refreshGUI();
        });
        final AbstractAction frameRangeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircleFitter fitter = (CircleFitter)TTrack.getTrack(AttachmentDialog.this.trackID);
                fitter.setAttachmentStartFrame(AttachmentDialog.this.startField.getIntValue());
                fitter.setAttachmentFrameCount(AttachmentDialog.this.countField.getIntValue());
                AttachmentDialog.this.refreshFieldsAndButtons(fitter);
                fitter.refreshAttachments();
                DefaultTableModel dm = (DefaultTableModel)AttachmentDialog.this.table.getModel();
                dm.fireTableDataChanged();
                TFrame.repaintT(fitter.tp);
            }
        };
        FocusAdapter frameRangeFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == AttachmentDialog.this.startField && AttachmentDialog.this.startField.getBackground() != Color.yellow) {
                    return;
                }
                if (e.getSource() == AttachmentDialog.this.countField && AttachmentDialog.this.countField.getBackground() != Color.yellow) {
                    return;
                }
                frameRangeAction.actionPerformed(null);
            }
        };
        this.startField = new IntegerField(3);
        this.startField.addActionListener(frameRangeAction);
        this.startField.addFocusListener(frameRangeFocusListener);
        this.countField = new IntegerField(2);
        this.countField.addActionListener(frameRangeAction);
        this.countField.addFocusListener(frameRangeFocusListener);
        this.startLabel = new JLabel();
        this.startLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.countLabel = new JLabel();
        this.countLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.circleFitterPanel = new JPanel(new BorderLayout());
        this.circleFitterPanel.setBorder(BorderFactory.createTitledBorder(""));
        JPanel buttonbar = new JPanel();
        this.circleFitterPanel.add((Component)buttonbar, "North");
        buttonbar.add(this.stepsButton);
        buttonbar.add(this.tracksButton);
        this.circleFitterStartStopPanel = new JPanel(new BorderLayout());
        Border empty = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        Border etched = BorderFactory.createEtchedBorder();
        this.circleFitterStartStopPanel.setBorder(BorderFactory.createCompoundBorder(empty, etched));
        buttonbar = new JPanel();
        buttonbar.add(this.startLabel);
        buttonbar.add(this.startField);
        buttonbar.add(this.countLabel);
        buttonbar.add(this.countField);
        this.circleFitterStartStopPanel.add((Component)buttonbar, "Center");
        buttonbar = new JPanel();
        this.circleFitterStartStopPanel.add((Component)buttonbar, "South");
        buttonbar.add(this.relativeCheckbox);
        this.helpButton = new JButton();
        this.helpButton.setForeground(new Color(0, 0, 102));
        this.helpButton.addActionListener(e -> {
            TTrack measuringTool = TTrack.getTrack(this.trackID);
            String keyword = measuringTool == null ? "circle" : (measuringTool.ttype == 6 ? "protractor" : (measuringTool.ttype == 8 ? "tape" : "circle"));
            this.frame.showHelp(String.valueOf(keyword) + "#attach", 0);
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(e -> this.setVisible(false));
        buttonbar = new JPanel();
        contentPane.add((Component)buttonbar, "South");
        buttonbar.add(this.helpButton);
        buttonbar.add(this.closeButton);
    }

    protected void setMeasuringTool(TTrack tool) {
        TTrack measuringTool = TTrack.getTrack(this.trackID);
        if (measuringTool != null && measuringTool.ttype == 1) {
            measuringTool.removePropertyChangeListener("dataPoint", this);
        }
        measuringTool = tool;
        this.trackID = measuringTool.getID();
        if (tool.ttype == 1) {
            measuringTool.addPropertyChangeListener("dataPoint", this);
        }
        measuringTool.refreshAttachments();
        this.refreshDropdowns();
        if (measuringTool.ttype == 1) {
            CircleFitter fitter = (CircleFitter)measuringTool;
            this.refreshFieldsAndButtons(fitter);
        }
        DefaultTableModel dm = (DefaultTableModel)this.table.getModel();
        dm.fireTableDataChanged();
        this.refreshGUI();
    }

    protected void refreshDropdowns() {
        TapeMeasure tape;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (this.attachableTracks == null) {
            this.attachableTracks = new ArrayList();
        } else {
            this.attachableTracks.clear();
        }
        this.attachableTracks.addAll(trackerPanel.getDrawables(PointMass.class));
        this.attachableTracks.addAll(trackerPanel.getDrawables(RGBRegion.class));
        for (TTrack p : this.attachableTracks) {
            p.removeListenerNCF(this);
        }
        TTrack measuringTool = TTrack.getTrack(this.trackID);
        if (measuringTool != null && measuringTool.ttype == 8 && (tape = (TapeMeasure)measuringTool).isStickMode()) {
            this.attachableTracks.removeAll(trackerPanel.getDrawablesTemp(ParticleModel.class));
        }
        for (TTrack p : this.attachableTracks) {
            p.addListenerNCF(this);
        }
        FontSizer.setFonts(this.rendererDropdown, FontSizer.getLevel());
        this.rendererDropdown.setModel(new AttachmentComboBoxModel());
        FontSizer.setFonts(this.editorDropdown, FontSizer.getLevel());
        this.editorDropdown.setModel(new AttachmentComboBoxModel());
        FontSizer.setFonts(this.measuringToolDropdown, FontSizer.getLevel());
        Vector<TTrack> tools2 = new Vector<TTrack>();
        for (TTrack track : trackerPanel.getTracksTemp()) {
            switch (track.ttype) {
                case 1: 
                case 6: 
                case 8: {
                    tools2.add(track);
                }
            }
        }
        trackerPanel.clearTemp();
        for (TTrack p : tools2) {
            p.removeListenerNCF(this);
            p.addListenerNCF(this);
        }
        this.measuringToolDropdown.setModel(new DefaultComboBoxModel(tools2));
        if (!tools2.isEmpty() && measuringTool != null) {
            this.measuringToolDropdown.setSelectedItem(measuringTool);
        } else {
            Iterator<TTrack> iterator = tools2.iterator();
            if (iterator.hasNext()) {
                TTrack next = iterator.next();
                this.setMeasuringTool(next);
            }
        }
    }

    protected void refreshFieldsAndButtons(CircleFitter fitter) {
        if (fitter.attachToSteps && fitter.isRelativeFrameNumbers) {
            this.startField.applyPattern("+#;-#");
        } else {
            this.startField.applyPattern("#;-#");
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        int min = fitter.isRelativeFrameNumbers ? 1 - trackerPanel.getPlayer().getVideoClip().getFrameCount() : trackerPanel.getPlayer().getVideoClip().getFirstFrameNumber();
        int max = trackerPanel.getPlayer().getVideoClip().getLastFrameNumber();
        this.startField.setMaxValue(max);
        this.startField.setMinValue(min);
        this.startField.setIntValue(fitter.isRelativeFrameNumbers ? fitter.relativeStart : fitter.absoluteStart);
        this.countField.setMaxValue(50.0);
        this.countField.setMinValue(1.0);
        this.countField.setIntValue(fitter.getAttachmentFrameCount());
        this.refreshing = true;
        this.stepsButton.setSelected(fitter.attachToSteps);
        this.relativeCheckbox.setSelected(fitter.isRelativeFrameNumbers);
        this.refreshing = false;
    }

    protected void refreshGUI() {
        this.setTitle(TrackerRes.getString("AttachmentInspector.Title"));
        this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        this.dummyMass.setName(TrackerRes.getString("DynamicSystemInspector.ParticleName.None"));
        this.startLabel.setText(TrackerRes.getString("AttachmentInspector.Label.StartFrame"));
        this.countLabel.setText(TrackerRes.getString("AttachmentInspector.Label.FrameCount"));
        this.stepsButton.setText(TrackerRes.getString("AttachmentInspector.Button.Steps"));
        this.tracksButton.setText(TrackerRes.getString("AttachmentInspector.Button.Tracks"));
        this.relativeCheckbox.setText(TrackerRes.getString("AttachmentInspector.Checkbox.Relative"));
        this.stepsButton.setToolTipText(TrackerRes.getString("AttachmentInspector.Button.Steps.Tooltip"));
        this.tracksButton.setToolTipText(TrackerRes.getString("AttachmentInspector.Button.Tracks.Tooltip"));
        this.relativeCheckbox.setToolTipText(TrackerRes.getString("AttachmentInspector.Checkbox.Relative.Tooltip"));
        TitledBorder border = (TitledBorder)this.circleFitterPanel.getBorder();
        border.setTitle(TrackerRes.getString("AttachmentInspector.Border.Title.AttachTo"));
        boolean hasCircleFitterPanel = this.attachmentsPanel.getComponentCount() > 2;
        boolean hasStartStopPanel = this.circleFitterPanel.getComponentCount() > 1;
        boolean changedLayout = false;
        TTrack measuringTool = TTrack.getTrack(this.trackID);
        if (measuringTool.ttype == 1) {
            changedLayout = !hasCircleFitterPanel;
            this.attachmentsPanel.add((Component)this.circleFitterPanel, "South");
            CircleFitter fitter = (CircleFitter)measuringTool;
            if (!fitter.attachToSteps) {
                changedLayout = changedLayout || hasStartStopPanel;
                this.circleFitterPanel.remove(this.circleFitterStartStopPanel);
            } else {
                boolean cfr_ignored_0 = fitter.isRelativeFrameNumbers;
                changedLayout = changedLayout || !hasStartStopPanel;
                this.circleFitterPanel.add((Component)this.circleFitterStartStopPanel, "Center");
            }
        } else {
            this.attachmentsPanel.remove(this.circleFitterPanel);
            changedLayout = hasCircleFitterPanel;
        }
        if (changedLayout) {
            this.pack();
        }
        TFrame.repaintT(this);
    }

    public void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        FontSizer.setFonts(this.attachmentCellRenderer, level);
        FontSizer.setFonts(this.table, level);
        FontSizer.setFonts(this.circleFitterPanel, level);
        FontSizer.setFonts(this.circleFitterStartStopPanel, level);
        this.refreshDropdowns();
        this.pack();
    }

    class AttachmentCellEditor
    extends DefaultCellEditor {
        AttachmentCellEditor() {
            super(AttachmentDialog.this.editorDropdown);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            AttachmentDialog.this.editorDropdown.setSelectedItem(value == null ? AttachmentDialog.this.dummyMass : value);
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            Object obj = super.getCellEditorValue();
            int row = AttachmentDialog.this.table.getSelectedRow();
            if (row < 0) {
                return null;
            }
            TTrack measuringTool = TTrack.getTrack(AttachmentDialog.this.trackID);
            TTrack[] attachments = measuringTool.getAttachments();
            if (attachments[row] != null) {
                attachments[row].removeStepListener(measuringTool);
            }
            attachments[row] = obj == AttachmentDialog.this.dummyMass ? null : (TTrack)obj;
            measuringTool.refreshAttachments();
            AttachmentDialog.this.refreshGUI();
            DefaultTableModel dm = (DefaultTableModel)AttachmentDialog.this.table.getModel();
            dm.fireTableDataChanged();
            return obj;
        }
    }

    class AttachmentCellRenderer
    extends JLabel
    implements TableCellRenderer {
        AttachmentCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBackground(Color.white);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object val, boolean selected, boolean hasFocus, int row, int col) {
            if (col == 0) {
                this.setText((String)val);
                this.validate();
                return this;
            }
            if (val == null) {
                val = AttachmentDialog.this.dummyMass;
            }
            AttachmentDialog.this.rendererDropdown.setSelectedItem(val == null ? AttachmentDialog.this.dummyMass : val);
            if (OSPRuntime.isJS) {
                return AttachmentDialog.this.trackCellRenderer.getListCellRendererComponent((JList)null, val, -1, selected, hasFocus);
            }
            return AttachmentDialog.this.rendererDropdown;
        }
    }

    class AttachmentComboBoxModel
    extends DefaultComboBoxModel<Object>
    implements ComboBoxModel<Object> {
        Object selected;

        AttachmentComboBoxModel() {
            this.selected = AttachmentDialog.this.dummyMass;
        }

        @Override
        public int getSize() {
            return AttachmentDialog.this.attachableTracks == null ? 1 : AttachmentDialog.this.attachableTracks.size() + 1;
        }

        @Override
        public Object getElementAt(int index) {
            return index == 0 ? AttachmentDialog.this.dummyMass : AttachmentDialog.this.attachableTracks.get(index - 1);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selected = anItem;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected == null ? AttachmentDialog.this.dummyMass : this.selected;
        }
    }

    class AttachmentTableModel
    extends DefaultTableModel {
        AttachmentTableModel() {
        }

        @Override
        public int getRowCount() {
            TTrack[] attachments;
            TTrack measuringTool = TTrack.getTrack(AttachmentDialog.this.trackID);
            if (measuringTool == null) {
                return 0;
            }
            if (measuringTool.ttype == 1) {
                CircleFitter fitter = (CircleFitter)measuringTool;
                if (fitter.attachToSteps) {
                    return 1;
                }
            }
            return (attachments = measuringTool.getAttachments()) == null ? 0 : attachments.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            TTrack measuringTool = TTrack.getTrack(AttachmentDialog.this.trackID);
            if (col == 0) {
                return measuringTool.getAttachmentDescription(row);
            }
            return measuringTool.getAttachments()[row];
        }

        @Override
        public String getColumnName(int col) {
            return col == 0 ? TrackerRes.getString("AttachmentInspector.Header.PointName") : TrackerRes.getString("AttachmentInspector.Header.AttachedTo");
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return col == 0 ? String.class : TTrack.class;
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
        }
    }

    class TTrackRenderer
    implements ListCellRenderer<Object> {
        TTrackRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object val, int index, boolean selected, boolean hasFocus) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 0));
            if (list != null) {
                if (selected) {
                    label.setBackground(list.getSelectionBackground());
                    label.setForeground(list.getSelectionForeground());
                } else {
                    label.setBackground(list.getBackground());
                    label.setForeground(list.getForeground());
                }
            }
            if (val != null) {
                TTrack track = (TTrack)val;
                label.setText(track.getName());
                label.setIcon(track == AttachmentDialog.this.dummyMass ? new ResizableIcon(AttachmentDialog.this.dummyIcon) : track.getFootprint().getIcon(21, 16));
            }
            return label;
        }
    }
}

