/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackRenderer;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.TemplateMatcher;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class AutoTracker
implements Interactive,
Trackable,
PropertyChangeListener {
    private static final float[] DOTTED_LINE = new float[]{2.0f, 2.0f};
    private static final float[] DASHED_LINE = new float[]{2.0f, 8.0f};
    private static final String[] panelProps = new String[]{"selectedpoint", "selectedtrack", "track", "clear", "video", "stepnumber"};
    private static final Rectangle hitRect = new Rectangle(-4, -4, 8, 8);
    private static final AffineTransform transform = new AffineTransform();
    private static final Footprint target_footprint = PointShapeFootprint.getFootprint("Footprint.BoldCrosshair");
    private static final Footprint inactive_target_footprint = PointShapeFootprint.getFootprint("Footprint.Crosshair");
    private static final Footprint corner_footprint = PointShapeFootprint.getFootprint("Footprint.SolidSquare");
    private static final NumberFormat format = NumberFormat.getNumberInstance();
    private static final BasicStroke solidBold = new BasicStroke(2.0f);
    private static final BasicStroke solid = new BasicStroke();
    private static final BasicStroke dotted = new BasicStroke(2.0f, 0, 0, 8.0f, DOTTED_LINE, 0.0f);
    private static final BasicStroke dashed = new BasicStroke(2.0f, 0, 0, 8.0f, DASHED_LINE, 0.0f);
    private static final int maxEvolve = 100;
    private static final int maxTether = 100;
    private static final int defaultEvolve = 20;
    private static final int defaultTether = 5;
    private static final int maxMaskSize = 99;
    private static final Icon searchIcon = Tracker.getResourceIcon("green_light.gif", true);
    private static final Icon stopIcon = Tracker.getResourceIcon("red_light.gif", true);
    private static final Icon graySearchIcon = Tracker.getResourceIcon("gray_light.gif", true);
    private static final Icon circleIcon = Tracker.getResourceIcon("circle.gif", true);
    private static final Icon squareIcon = Tracker.getResourceIcon("square.gif", true);
    private static final Icon circleDisabledIcon = Tracker.getResourceIcon("circle_disabled.gif", true);
    private static final Icon squareDisabledIcon = Tracker.getResourceIcon("square_disabled.gif", true);
    private static final int[] defaultMaskSize = new int[]{9, 9};
    private static final int[] defaultSearchSize = new int[]{40, 40};
    private static final int templateIconMagnification = 2;
    private static final int predictionLookback = 4;
    private static final Color RUST = new Color(100, 20, 20);
    private static final int ALWAYS_STOP = 0;
    private static final int STOP_NO_MATCH = 1;
    private static final int NEVER_STOP = 2;
    protected static int stopPolicy = 0;
    private static final int LOOK_AHEAD = 0;
    private static final int FOLLOW = 1;
    private static final int FIXED = 2;
    protected static int searchAreaPolicy = 0;
    private TFrame frame;
    private Integer panelID;
    private int trackID;
    private Wizard wizard;
    private RectangularShape ellipseMatch = new Ellipse2D.Double();
    private RectangularShape rectangleMatch = new Rectangle2D.Double();
    private int minMaskRadius = 4;
    private Handle maskHandle = new Handle("mask");
    private Corner maskCorner = new Corner("mask");
    private TPoint maskCenter = new TPoint();
    private Handle searchHandle = new Handle("search");
    private Corner searchCorner = new Corner("search");
    private TPoint searchCenter = new TPoint();
    private TPoint predictedTarget = new TPoint();
    private Rectangle2D searchRect2D = new Rectangle2D.Double();
    private Shape searchShape;
    private Shape maskShape;
    private Shape matchShape;
    private Shape searchHitShape;
    private Shape maskHitShape;
    private Mark mark;
    private Point[] screenPoints = new Point[]{new Point()};
    private boolean maskVisible;
    private boolean targetVisible;
    private boolean searchVisible;
    private Runnable stepper;
    private boolean stepping;
    private boolean active;
    private boolean paused;
    private boolean marking;
    private int goodMatch = 4;
    private int possibleMatch = 1;
    private int evolveAlpha;
    private int tetherAlpha;
    private TPoint hitPt = new TPoint();
    private long currentms = 0L;
    private Robot robot;
    private boolean odd = true;
    private Map<TTrack, Map<Integer, Map<Integer, FrameData>>> trackDataMap = new HashMap<TTrack, Map<Integer, Map<Integer, FrameData>>>();
    private Map<Integer, KeyFrameData> keyFrameMap = new TreeMap<Integer, KeyFrameData>();
    private int lineSpread = -1;
    private boolean isInteracting;
    private double[][] derivatives1 = new double[3][];
    private double[][] derivatives2 = new double[3][];
    private double[][] derivatives3 = new double[3][];
    int test = 0;
    static final int STATUS_KEY_FRAME = 0;
    static final int STATUS_AUTO_MARKED_GOOD = 1;
    static final int STATUS_POSSIBLE_MATCH_NOT_MARKED = 2;
    static final int STATUS_NO_MATCH_FOUND_UNMARKED = 3;
    static final int STATUS_TRIED_UNABLE_TO_SEARCH = 4;
    static final int STATUS_MANUALLY_MARKED = 5;
    static final int STATUS_ACCEPTED_BY_USER = 6;
    static final int STATUS_NEVER_SEARCHED = 7;
    static final int STATUS_POSSIBLE_MATCH = 8;
    static final int STATUS_NO_MATCH_FOUND_SEARCHED = 9;
    static final int STATUS_CALIB_TOOL_POSSIBLE_MATCH = 10;

    static {
        format.setMinimumIntegerDigits(1);
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(1);
    }

    public AutoTracker(final TrackerPanel panel) {
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        panel.addDrawable(this);
        panel.addListeners(panelProps, this);
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.stepper = new Runnable(){

            @Override
            public void run() {
                boolean keepGoing;
                TTrack track = AutoTracker.this.getTrack();
                if (!AutoTracker.this.active || track == null) {
                    return;
                }
                boolean moveSearchArea = searchAreaPolicy != 2;
                boolean bl = keepGoing = stopPolicy == 2;
                if (AutoTracker.this.markCurrentFrame(moveSearchArea) || keepGoing) {
                    if (!AutoTracker.this.canStep()) {
                        AutoTracker.this.stop(true, true);
                        return;
                    }
                    if (AutoTracker.this.stepping) {
                        AutoTracker.this.wizard.refreshInfo();
                        AutoTracker.this.repaint();
                        panel.getPlayer().step();
                        return;
                    }
                    AutoTracker.this.stop(true, true);
                } else if (!AutoTracker.this.stepping) {
                    AutoTracker.this.stop(true, false);
                } else {
                    AutoTracker.this.paused = true;
                    if (track.ttype == 5) {
                        PointMass pointMass = (PointMass)track;
                        pointMass.updateDerivatives();
                    }
                    track.fireStepsChanged();
                    AutoTracker.this.wizard.refreshGUI();
                }
                AutoTracker.this.repaint();
            }
        };
        this.wizard = new Wizard();
    }

    protected TTrack getTrack() {
        return TTrack.getTrack(this.trackID);
    }

    protected void setTrack(TTrack newTrack) {
        TTrack track;
        if (newTrack != null && !newTrack.isAutoTrackable()) {
            newTrack = null;
        }
        if ((track = this.getTrack()) == newTrack) {
            return;
        }
        if (track != null) {
            track.removePropertyChangeListener("step", this);
            track.removeListenerNCF(this);
        }
        if ((track = newTrack) != null) {
            this.trackID = track.getID();
            this.frame.getTrackerPanelForID(this.panelID).setSelectedTrack(track);
            track.addPropertyChangeListener("step", this);
            track.addListenerNCF(this);
            track.setVisible(true);
            TPoint[] searchPts = this.getCurrentFrameData().getSearchPoints(true);
            if (searchPts != null) {
                this.setSearchPoints(searchPts[0], searchPts[1]);
            }
        } else {
            this.trackID = -1;
        }
        this.wizard.refreshGUI();
    }

    protected void addKeyFrame(TPoint p, double x, double y) {
        TrackerPanel trackerPanel = this.trackerPanel();
        int n = trackerPanel.getFrameNumber();
        Target target = new Target();
        RectangularShape mask = this.getWizard().ellipseButton.isSelected() ? new Ellipse2D.Double() : new Rectangle2D.Double();
        this.maskCenter.setLocation(x, y);
        this.maskCorner.setLocation(x + (double)defaultMaskSize[0], y + (double)defaultMaskSize[1]);
        this.searchCenter.setLocation(x, y);
        this.searchCorner.setLocation(x + (double)defaultSearchSize[0], y + (double)defaultSearchSize[1]);
        KeyFrameData keyFrameData = new KeyFrameData(p, mask, target);
        this.getFrameNumberToFrameDataMap().put(n, keyFrameData);
        this.keyFrameMap.put(n, keyFrameData);
        this.clearSearchPointsDownstream();
        this.refreshSearchRect();
        this.refreshKeyFrame(keyFrameData, true);
        this.getWizard().setVisible(true);
        if (this.wizard.oneDCheckbox.isSelected()) {
            this.moveOriginToFirstKeyFrame();
        }
        TFrame.repaintT(trackerPanel);
    }

    private TrackerPanel trackerPanel() {
        return this.frame.getTrackerPanelForID(this.panelID);
    }

    protected void search(boolean startWithThis, boolean keepGoing) {
        this.getCurrentFrameData().setEvolvedImage(null);
        this.stepping = this.stepping || keepGoing;
        this.wizard.changed = false;
        this.active = true;
        this.paused = false;
        if (!startWithThis || this.markCurrentFrame(false) || stopPolicy == 2) {
            if (this.canStep() && (!startWithThis || this.stepping)) {
                this.frame.getTrackerPanelForID(this.panelID).getPlayer().step();
                return;
            }
            if (startWithThis && !this.stepping) {
                this.active = false;
            } else {
                this.stop(true, true);
            }
        } else {
            this.paused = true;
        }
        this.getWizard().refreshGUI();
        this.getWizard().helpButton.requestFocusInWindow();
        this.repaint();
    }

    protected void stop(boolean now, boolean update) {
        boolean b = Boolean.parseBoolean(this.wizard.startButton.getName());
        TrackerPanel tp = this.frame.getTrackerPanelForID(this.panelID);
        tp.setAutoRefresh(b);
        this.stepping = false;
        this.active = !now && !this.paused;
        this.paused = false;
        this.wizard.refreshGUI();
        if (update) {
            TTrack track = this.getTrack();
            if (track == null) {
                return;
            }
            if (track.ttype == 5) {
                PointMass pointMass = (PointMass)track;
                pointMass.updateDerivatives();
            }
            track.fireStepsChanged();
        }
    }

    public boolean markCurrentFrame(boolean lookahead) {
        TTrack track = this.getTrack();
        if (track == null) {
            return false;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.setSelectedTrack(track);
        int n = trackerPanel.getFrameNumber();
        FrameData frameData = this.getOrCreateFrameData(n);
        KeyFrameData keyFrameData = frameData.getKeyFrameData();
        if (keyFrameData != null && !track.isStepComplete(n)) {
            TPoint p = this.findMatchTarget(lookahead);
            double[] peakWidthAndHeight = frameData.getMatchWidthAndHeight();
            if (p != null && (Double.isInfinite(peakWidthAndHeight[1]) || peakWidthAndHeight[1] >= (double)this.goodMatch)) {
                this.marking = true;
                track.autoTrackerMarking = track.isAutoAdvance();
                if (keyFrameData != frameData) {
                    p = track.autoMarkAt(n, p.x, p.y);
                }
                frameData.setAutoMarkPoint(p);
                track.autoTrackerMarking = false;
                return true;
            }
            if (p == null) {
                if (peakWidthAndHeight[1] < (double)this.possibleMatch) {
                    frameData.setMatchIcon(null);
                } else if (stopPolicy == 1) {
                    return true;
                }
            }
        }
        return false;
    }

    public TPoint getPredictedMatchTarget(int frameNumber) {
        boolean success = false;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        VideoClip clip = trackerPanel.getPlayer().getVideoClip();
        int stepNumber = clip.frameToStep(frameNumber);
        TPoint[] prevPoints = new TPoint[4];
        TTrack track = this.getTrack();
        if (stepNumber > 0 && track != null) {
            int j = 0;
            while (j < 4) {
                if (stepNumber - j - 1 >= 0) {
                    FrameData frameData = this.getOrCreateFrameData(clip.stepToFrame(stepNumber - j - 1));
                    if (track.steps.isAutofill() && !frameData.searched) {
                        prevPoints[j] = null;
                    } else {
                        prevPoints[j] = frameData.getMarkedPoint();
                        if (prevPoints[j] == null) {
                            TPoint[] matchPts = frameData.getMatchPoints();
                            prevPoints[j] = matchPts == null ? null : matchPts[0];
                        }
                    }
                }
                ++j;
            }
        }
        if (prevPoints[0] == null) {
            return null;
        }
        this.predictedTarget.setLocation(prevPoints[0].getX(), prevPoints[0].getY());
        if (searchAreaPolicy != 0 || prevPoints[1] == null) {
            success = true;
        }
        if (!success) {
            TPoint loc2;
            TPoint loc1;
            TPoint loc0;
            boolean yAccelValid;
            double[][] veloc = this.getDerivatives(prevPoints, 1);
            double[][] accel = this.getDerivatives(prevPoints, 2);
            double[][] jerk = this.getDerivatives(prevPoints, 3);
            double vxmax = 0.0;
            double vxmean = 0.0;
            double vymax = 0.0;
            double vymean = 0.0;
            int n = 0;
            int i = 0;
            while (i < veloc.length) {
                if (veloc[i] != null) {
                    ++n;
                    vxmax = Math.max(vxmax, Math.abs(veloc[i][0]));
                    vxmean += veloc[i][0];
                    vymax = Math.max(vymax, Math.abs(veloc[i][1]));
                    vymean += veloc[i][1];
                }
                ++i;
            }
            vxmean = Math.abs(vxmean / (double)n);
            vymean = Math.abs(vymean / (double)n);
            double axmax = 0.0;
            double axmean = 0.0;
            double aymax = 0.0;
            double aymean = 0.0;
            n = 0;
            int i2 = 0;
            while (i2 < accel.length) {
                if (accel[i2] != null) {
                    ++n;
                    axmax = Math.max(axmax, Math.abs(accel[i2][0]));
                    axmean += accel[i2][0];
                    aymax = Math.max(aymax, Math.abs(accel[i2][1]));
                    aymean += accel[i2][1];
                }
                ++i2;
            }
            axmean = Math.abs(axmean / (double)n);
            aymean = Math.abs(aymean / (double)n);
            double jxmax = 0.0;
            double jxmean = 0.0;
            double jymax = 0.0;
            double jymean = 0.0;
            n = 0;
            int i3 = 0;
            while (i3 < jerk.length) {
                if (jerk[i3] != null) {
                    ++n;
                    jxmax = Math.max(jxmax, Math.abs(jerk[i3][0]));
                    jxmean += jerk[i3][0];
                    jymax = Math.max(jymax, Math.abs(jerk[i3][1]));
                    jymean += jerk[i3][1];
                }
                ++i3;
            }
            jxmean = Math.abs(jxmean / (double)n);
            jymean = Math.abs(jymean / (double)n);
            boolean xVelocValid = prevPoints[2] == null || Math.abs(accel[0][0]) < vxmean;
            boolean yVelocValid = prevPoints[2] == null || Math.abs(accel[0][1]) < vymean;
            boolean xAccelValid = prevPoints[2] != null && (prevPoints[3] == null || Math.abs(jerk[0][0]) < axmean);
            boolean bl = yAccelValid = prevPoints[2] != null && (prevPoints[3] == null || Math.abs(jerk[0][1]) < aymean);
            if (xAccelValid) {
                loc0 = prevPoints[2];
                loc1 = prevPoints[1];
                loc2 = prevPoints[0];
                double x = 3.0 * loc2.getX() - 3.0 * loc1.getX() + loc0.getX();
                this.predictedTarget.setLocation(x, this.predictedTarget.y);
                success = true;
            } else if (xVelocValid) {
                loc0 = prevPoints[1];
                loc1 = prevPoints[0];
                double x = 2.0 * loc1.getX() - loc0.getX();
                this.predictedTarget.setLocation(x, this.predictedTarget.y);
                success = true;
            }
            if (yAccelValid) {
                loc0 = prevPoints[2];
                loc1 = prevPoints[1];
                loc2 = prevPoints[0];
                double y = 3.0 * loc2.getY() - 3.0 * loc1.getY() + loc0.getY();
                this.predictedTarget.setLocation(this.predictedTarget.x, y);
                success = true;
            } else if (yVelocValid) {
                loc0 = prevPoints[1];
                loc1 = prevPoints[0];
                double y = 2.0 * loc1.getY() - loc0.getY();
                this.predictedTarget.setLocation(this.predictedTarget.x, y);
                success = true;
            }
        }
        if (success) {
            Dimension d = this.getVideo().getImageSize(true);
            this.predictedTarget.x = Math.max(this.predictedTarget.x, 0.0);
            this.predictedTarget.x = Math.min(this.predictedTarget.x, (double)d.width);
            this.predictedTarget.y = Math.max(this.predictedTarget.y, 0.0);
            this.predictedTarget.y = Math.min(this.predictedTarget.y, (double)d.height);
            return this.predictedTarget;
        }
        return null;
    }

    public TPoint findMatchTarget(boolean predict) {
        TPoint prediction;
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        int n = trackerPanel.getFrameNumber();
        FrameData frameData = this.getOrCreateFrameData(n);
        if (predict && (prediction = this.getPredictedMatchTarget(n)) != null) {
            TPoint p = this.getMatchCenter(prediction);
            this.setSearchPoints(p, null);
        }
        TPoint[] pts = new TPoint[]{new TPoint(this.searchCenter), new TPoint(this.searchCorner)};
        frameData.setSearchPoints(pts);
        return this.findMatchTarget(this.getSearchRect());
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics g) {
        TTrack track = this.getTrack();
        if (track == null || this.wizard == null || !this.wizard.isVisible() || this.getVideo() == null) {
            this.searchVisible = false;
            this.targetVisible = false;
            this.maskVisible = false;
            return;
        }
        if (this.wizard != null && this.wizard.isVisible() && !this.maskVisible && !this.targetVisible && !this.searchVisible) {
            this.wizard.refreshGUI();
            this.searchVisible = true;
            this.targetVisible = true;
            this.maskVisible = true;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.getMark() != null) {
            this.mark.draw(g2, false);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive ia = this.findInteractiveImp(panel, xpix, ypix);
        return ia;
    }

    private Interactive findInteractiveImp(DrawingPanel panel, int xpix, int ypix) {
        Target target;
        this.isInteracting = false;
        KeyFrameData keyFrameData = this.getCurrentKeyFrameData();
        if (keyFrameData == null || !this.wizard.isVisible() || this.getVideo() == null) {
            return null;
        }
        hitRect.setLocation(xpix - AutoTracker.hitRect.width / 2, ypix - AutoTracker.hitRect.height / 2);
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (this.targetVisible && hitRect.contains((target = keyFrameData.getTarget()).getScreenPosition(trackerPanel))) {
            this.isInteracting = true;
            return target;
        }
        this.hitPt.setLocation(xpix, ypix);
        if (this.searchVisible && hitRect.contains(this.searchCorner.getScreenPosition(trackerPanel))) {
            return this.searchCorner;
        }
        if (this.maskVisible && hitRect.contains(this.maskCorner.getScreenPosition(trackerPanel))) {
            return this.maskCorner;
        }
        if (this.maskVisible && this.maskHitShape.intersects(hitRect)) {
            return this.maskHandle;
        }
        if (this.searchVisible && this.searchHitShape.intersects(hitRect)) {
            return this.searchHandle;
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isInteracting() {
        return this.isInteracting;
    }

    public boolean isInteracting(TTrack track) {
        if (this.getTrack() == track) {
            FrameData frameData = this.getOrCreateFrameData(track.tp.getFrameNumber());
            return frameData != null && frameData == frameData.getKeyFrameData() && this.isInteracting();
        }
        return false;
    }

    public TemplateMatcher getTemplateMatcher() {
        if (this.panelID == null) {
            return null;
        }
        KeyFrameData keyFrameData = this.getCurrentKeyFrameData();
        if (keyFrameData == null) {
            return null;
        }
        if (keyFrameData.getTemplateMatcher() == null) {
            TemplateMatcher matcher = this.createTemplateMatcher();
            keyFrameData.setTemplateMatcher(matcher);
        }
        return keyFrameData.getTemplateMatcher();
    }

    public Rectangle getSearchRect() {
        return this.searchRect2D.getBounds();
    }

    public void refreshSearchRect() {
        this.searchRect2D.setFrameFromCenter(this.searchCenter, this.searchCorner);
        if (this.moveRectIntoImage(this.searchRect2D)) {
            this.searchCenter.setLocation(this.searchRect2D.getCenterX(), this.searchRect2D.getCenterY());
            this.searchCorner.setLocation(this.searchRect2D.getMaxX(), this.searchRect2D.getMaxY());
        }
        this.getCurrentFrameData().setSearchPoints(new TPoint[]{new TPoint(this.searchCenter), new TPoint(this.searchCorner)});
        this.repaint();
    }

    protected void setSearchPoints(TPoint center, TPoint corner) {
        if (corner == null) {
            Dimension d = this.getVideo().getImageSize(true);
            int w = d.width;
            int h = d.height;
            int setbackX = this.searchRect2D.getBounds().width / 2;
            int setbackY = this.searchRect2D.getBounds().height / 2;
            center.x = Math.max(center.x, (double)setbackX);
            center.x = Math.min(center.x, (double)(w - setbackX));
            center.y = Math.max(center.y, (double)setbackY);
            center.y = Math.min(center.y, (double)(h - setbackY));
            double dx = center.x - this.searchCenter.x;
            double dy = center.y - this.searchCenter.y;
            this.searchCenter.x += dx;
            this.searchCenter.y += dy;
            this.searchCorner.x += dx;
            this.searchCorner.y += dy;
        } else {
            this.searchCenter.setLocation(center);
            this.searchCorner.setLocation(corner);
        }
        this.refreshSearchRect();
    }

    protected Video getVideo() {
        return this.frame.getTrackerPanelForID(this.panelID).getVideo();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        TTrack track = this.getTrack();
        int n = this.frame.getTrackerPanelForID(this.panelID).getFrameNumber();
        FrameData frameData = this.getOrCreateFrameData(n);
        KeyFrameData keyFrameData = frameData.getKeyFrameData();
        boolean haveWizard = this.wizard != null && this.wizard.isVisible();
        boolean haveVideo = track != null && this.getVideo() != null;
        switch (e.getPropertyName()) {
            case "selectedpoint": {
                this.selectedPointChanged((TPoint)e.getOldValue(), (TPoint)e.getNewValue(), track, keyFrameData, frameData);
                break;
            }
            case "selectedtrack": {
                if (this.wizard == null) break;
                this.wizard.refreshGUI();
                break;
            }
            case "track": {
                if (e.getOldValue() == null) break;
                TTrack deletedTrack = (TTrack)e.getOldValue();
                this.trackDataMap.remove(deletedTrack);
                if (deletedTrack != track) break;
                this.setTrack(null);
                break;
            }
            case "clear": {
                this.trackDataMap.clear();
                this.setTrack(null);
                break;
            }
            case "footprint": 
            case "name": 
            case "color": 
            case "video": {
                if (!haveWizard) break;
                this.wizard.refreshGUI();
                break;
            }
            case "stepnumber": {
                if (track == null && haveWizard) {
                    this.wizard.refreshGUI();
                }
                if (!haveVideo || !haveWizard) break;
                TPoint[] searchPts = frameData.getSearchPoints(true);
                if (searchPts != null) {
                    this.setSearchPoints(searchPts[0], searchPts[1]);
                } else if (searchAreaPolicy == 0 && keyFrameData != null) {
                    TPoint prediction = this.getPredictedMatchTarget(n);
                    if (prediction != null) {
                        this.setSearchPoints(this.getMatchCenter(prediction), null);
                        TPoint[] pts = new TPoint[]{new TPoint(this.searchCenter), new TPoint(this.searchCorner)};
                        frameData.setSearchPoints(pts);
                    } else {
                        this.repaint();
                    }
                }
                if (this.active && !this.paused) {
                    long ms = System.currentTimeMillis();
                    if (this.robot != null && ms - this.currentms > 30000L) {
                        this.currentms = ms;
                        this.odd = !this.odd;
                        Point p = MouseInfo.getPointerInfo().getLocation();
                        int x = this.odd ? p.x + 1 : p.x - 1;
                        int y = this.odd ? p.y + 1 : p.y - 1;
                        this.robot.mouseMove(x, y);
                    }
                    SwingUtilities.invokeLater(this.stepper);
                    break;
                }
                if (this.stepping) {
                    this.stop(true, false);
                    break;
                }
                this.wizard.refreshGUI();
                break;
            }
            case "step": {
                if (!haveVideo || !haveWizard || track == null) break;
                if (!this.marking) {
                    n = (Integer)e.getNewValue();
                    frameData = this.getOrCreateFrameData(n);
                    frameData.decided = true;
                    if (track.getStep(n) == null) {
                        frameData.clear();
                    } else if (!frameData.isKeyFrameData()) {
                        frameData.setMatchIcon(null);
                        this.paused = false;
                    }
                }
                this.wizard.refreshGUI();
                this.marking = false;
            }
        }
    }

    private void selectedPointChanged(TPoint prev, TPoint next, TTrack track, KeyFrameData keyFrameData, FrameData frameData) {
        int i;
        boolean needsRepaint = false;
        if (this.wizard.isVisible()) {
            if (prev instanceof Corner && keyFrameData != null) {
                needsRepaint = true;
                RectangularShape mask = keyFrameData.getMask();
                if (mask instanceof RectangularShape) {
                    RectangularShape maskShape = mask;
                    this.maskCorner.x = this.maskCenter.x + maskShape.getWidth() / 2.0;
                    this.maskCorner.y = this.maskCenter.y + maskShape.getHeight() / 2.0;
                }
                this.searchCorner.x = this.searchRect2D.getMaxX();
                this.searchCorner.y = this.searchRect2D.getMaxY();
            } else if (prev instanceof Handle || prev instanceof Target) {
                needsRepaint = true;
            }
        }
        TrackerPanel trackerPanel = this.trackerPanel();
        Step step = trackerPanel.getSelectedStep();
        if (next == this.maskHandle || next == this.maskCorner || next == this.searchHandle || next == this.searchCorner || keyFrameData != null && next == keyFrameData.getTarget()) {
            trackerPanel.setSelectedTrack(track);
            needsRepaint = true;
        } else if (next != null && step != null && step.getTrack() == track && (i = step.getPointIndex(next)) >= 0 && i != track.getTargetIndex()) {
            track.setTargetIndex(i);
            TPoint[] searchPts = frameData.getSearchPoints(true);
            if (searchPts != null) {
                this.setSearchPoints(searchPts[0], searchPts[1]);
            }
            if ((keyFrameData = frameData.getKeyFrameData()) != null) {
                this.maskCenter.setLocation(keyFrameData.getMaskPoints()[0]);
                this.maskCorner.setLocation(keyFrameData.getMaskPoints()[1]);
            }
            this.wizard.refreshGUI();
            needsRepaint = true;
        }
        if (needsRepaint) {
            this.repaint();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setXY(double x, double y) {
    }

    @Override
    public void setX(double x) {
    }

    @Override
    public void setY(double y) {
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    @Override
    public double getXMin() {
        return 0.0;
    }

    @Override
    public double getXMax() {
        return 0.0;
    }

    @Override
    public double getYMin() {
        return 0.0;
    }

    @Override
    public double getYMax() {
        return 0.0;
    }

    @Override
    public boolean isMeasured() {
        return false;
    }

    protected TPoint findMatchTarget(Rectangle searchRect) {
        TPoint center;
        Video video2 = this.getVideo();
        if (video2 == null) {
            return null;
        }
        TemplateMatcher matcher = this.getTemplateMatcher();
        if (matcher == null) {
            return null;
        }
        int n = this.trackerPanel().getFrameNumber();
        FrameData frameData = this.getOrCreateFrameData(n);
        frameData.decided = false;
        matcher.setTemplate(frameData.getTemplateToMatch());
        TPoint p = null;
        BufferedImage image = this.getImage(video2);
        ImageCoordSystem coords = this.frame.getTrackerPanelForID(this.panelID).getCoords();
        double theta = coords.getAngle(n);
        double x0 = coords.getOriginX(n);
        double y0 = coords.getOriginY(n);
        if (this.lineSpread >= 0) {
            int[][] searchPts = matcher.getSearchPoints(searchRect, x0, y0, theta, this.lineSpread);
            p = matcher.getMatchLocation(image, searchRect, searchPts, x0, y0, theta);
        } else {
            p = matcher.getMatchLocation(image, searchRect, null, 0.0, 0.0, 0.0);
        }
        double[] matchWidthAndHeight = matcher.getMatchWidthAndHeight();
        if (matchWidthAndHeight[1] < (double)this.goodMatch && frameData.isAutoMarked()) {
            frameData.trackPoint = null;
        }
        frameData.setMatchWidthAndHeight(matchWidthAndHeight);
        frameData.searched = true;
        if (p == null || matchWidthAndHeight[1] < (double)this.possibleMatch) {
            frameData.setMatchPoints(null);
            return null;
        }
        BufferedImage match = matcher.getMatchImage();
        BufferedImage img = this.createMagnifiedImage(match);
        frameData.setMatchIcon(new ImageIcon(img));
        Rectangle rect = frameData.getKeyFrameData().getMask().getBounds();
        TPoint tPoint = center = frameData.isKeyFrameData() ? new TPoint(this.maskCenter) : new TPoint(p.x + this.maskCenter.x - rect.getX(), p.y + this.maskCenter.y - rect.getY());
        if (this.lineSpread >= 0) {
            double x1 = x0 + Math.cos(theta);
            double y1 = y0 - Math.sin(theta);
            double d = ((y1 - y0) * center.x - (x1 - x0) * center.y + x1 * y0 - x0 * y1) / Math.sqrt((y1 - y0) * (y1 - y0) + (x1 - x0) * (x1 - x0));
            center.x += d * Math.sin(theta);
            center.y += d * Math.cos(theta);
        }
        TPoint corner = new TPoint(center.x + (this.maskCorner.x - this.maskCenter.x), center.y + (this.maskCorner.y - this.maskCenter.y));
        frameData.setMatchPoints(new TPoint[]{center, corner, p});
        if (matchWidthAndHeight[1] >= (double)this.goodMatch) {
            this.buildEvolvedTemplateImage(frameData);
            return this.getMatchTarget(center);
        }
        return null;
    }

    private BufferedImage getImage(Video video2) {
        return video2.getImage();
    }

    protected BufferedImage buildEvolvedTemplateImage(FrameData frameData) {
        TPoint[] matchPts = frameData.getMatchPoints();
        if (matchPts == null) {
            return null;
        }
        TemplateMatcher matcher = this.getTemplateMatcher();
        matcher.setTemplate(frameData.getTemplateImage());
        matcher.setWorkingPixels(frameData.getWorkingPixels());
        Rectangle rect = frameData.getKeyFrameData().getMask().getBounds();
        rect.x = (int)Math.round(matchPts[2].getX());
        rect.y = (int)Math.round(matchPts[2].getY());
        BufferedImage image = matcher.buildTemplate(this.newVideoImage(rect), this.evolveAlpha, this.tetherAlpha);
        matcher.setIndex(frameData.getFrameNumber());
        return image;
    }

    protected TemplateMatcher createTemplateMatcher() {
        KeyFrameData keyFrameData = this.getCurrentKeyFrameData();
        if (this.getVideo() != null && keyFrameData != null) {
            RectangularShape mask = keyFrameData.getMask();
            Rectangle rect = mask.getBounds();
            transform.setToTranslation(-rect.x, -rect.y);
            return new TemplateMatcher(this.newVideoImage(rect), transform.createTransformedShape(mask));
        }
        return null;
    }

    private BufferedImage newVideoImage(Rectangle rect) {
        BufferedImage image = new BufferedImage(rect.width, rect.height, 1);
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)this.getVideo().getImage(), -rect.x, -rect.y, null);
        g.dispose();
        return image;
    }

    protected Map<Integer, Map<Integer, FrameData>> getMapOfIndexToMapofFrameNumberToFrameData() {
        TTrack track = this.getTrack();
        Map<Integer, Map<Integer, FrameData>> map = this.trackDataMap.get(track);
        if (map == null) {
            map = new TreeMap<Integer, Map<Integer, FrameData>>();
            this.trackDataMap.put(track, map);
        }
        return map;
    }

    protected Map<Integer, FrameData> getFrameNumberToFrameDataMap(int index) {
        Map<Integer, FrameData> map = this.getMapOfIndexToMapofFrameNumberToFrameData().get(index);
        if (map == null) {
            map = new TreeMap<Integer, FrameData>();
            this.getMapOfIndexToMapofFrameNumberToFrameData().put(index, map);
        }
        return map;
    }

    protected Map<Integer, FrameData> getFrameNumberToFrameDataMap() {
        TTrack track = this.getTrack();
        return this.getFrameNumberToFrameDataMap(track == null ? 0 : track.getTargetIndex());
    }

    protected FrameData getCurrentFrameData() {
        return this.getOrCreateFrameData(this.frame.getTrackerPanelForID(this.panelID).getFrameNumber());
    }

    protected KeyFrameData getCurrentKeyFrameData() {
        return this.getCurrentFrameData().getKeyFrameData();
    }

    public boolean isOnKeyFrame(TrackerPanel panel) {
        return this.isOnKeyFrame(panel.getFrameNumber());
    }

    public boolean isOnKeyFrame(int n) {
        FrameData frameData = this.getOrCreateFrameData(n);
        return frameData == frameData.getKeyFrameData();
    }

    protected static boolean isAutoTrackTrigger(InputEvent e) {
        return e.isControlDown() || OSPRuntime.isMac() && e.isMetaDown();
    }

    protected FrameData getOrCreateFrameData(int frameNumber) {
        Map<Integer, FrameData> map = this.getFrameNumberToFrameDataMap();
        FrameData frameData = map.get(frameNumber);
        if (frameData == null) {
            TTrack track = this.getTrack();
            int index = track == null ? 0 : track.getTargetIndex();
            frameData = new FrameData(index, frameNumber);
            map.put(frameNumber, frameData);
        }
        return frameData;
    }

    protected void moveOriginToFirstKeyFrame() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        Map<Integer, FrameData> map = this.getFrameNumberToFrameDataMap();
        int n = -1;
        for (Integer key : map.keySet()) {
            if (!map.get(key).isKeyFrameData()) continue;
            n = key;
            break;
        }
        if (n < 0) {
            return;
        }
        CoordAxes axes = trackerPanel.getAxes();
        KeyFrameData keyFrameData = this.getOrCreateFrameData(n).getKeyFrameData();
        if (keyFrameData != null) {
            double x0 = trackerPanel.getCoords().getOriginX(n);
            double y0 = trackerPanel.getCoords().getOriginY(n);
            TPoint[] maskPts = keyFrameData.getMaskPoints();
            if (Math.abs(x0 - maskPts[0].x) > 0.1 || Math.abs(y0 - maskPts[0].y) > 0.1) {
                XMLControlElement control = new XMLControlElement(trackerPanel.getCoords());
                axes.getOrigin().setXY(maskPts[0].x, maskPts[0].y);
                Undo.postCoordsEdit(trackerPanel, control);
                axes.setVisible(true);
            }
        }
    }

    protected FrameData getOrCreatePreviousFrameData(int frameNumber) {
        int i = frameNumber;
        while (--i >= 0) {
            FrameData frameData = this.getFrameNumberToFrameDataMap().get(i);
            if (frameData == null) continue;
            return frameData;
        }
        return this.getOrCreateFrameData(frameNumber);
    }

    protected int getStepPointIndex(TPoint p) {
        Step step = this.getTrack().getStep(p.getFrameNumber(this.frame.getTrackerPanelForID(this.panelID)));
        if (step != null) {
            int i = 0;
            while (i < step.points.length) {
                if (p.equals(step.points[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void erase() {
        if (this.mark != null) {
            this.frame.getTrackerPanelForID(this.panelID).addDirtyRegion(null);
        }
        this.mark = null;
    }

    protected void repaint() {
        this.erase();
        TrackerPanel trackerPanel = this.trackerPanel();
        if (this.getMark() != null) {
            trackerPanel.addDirtyRegion(null);
        }
        trackerPanel.repaintDirtyRegion();
    }

    protected void dispose() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.removeDrawable(this);
        trackerPanel.removeListeners(panelProps, this);
        this.setTrack(null);
        this.trackDataMap.clear();
        trackerPanel.autoTracker = null;
        this.wizard.dispose();
        trackerPanel = null;
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    protected Mark getMark() {
        final TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        int n = trackerPanel.getFrameNumber();
        FrameData frameData = this.getOrCreateFrameData(n);
        KeyFrameData keyFrameData = frameData.getKeyFrameData();
        final TTrack track = this.getTrack();
        if (track == null || keyFrameData == null) {
            return null;
        }
        if (this.mark == null) {
            int k = this.getStatusCode(n);
            Color c = track.getFootprint().getColor();
            target_footprint.setColor(c);
            inactive_target_footprint.setColor(c);
            corner_footprint.setColor(c);
            Mark searchCornerMark = null;
            Mark maskCornerMark = null;
            Mark targetMark = null;
            Mark selectionMark = null;
            AffineTransform toScreen = trackerPanel.getPixelTransform();
            if (!trackerPanel.isDrawingInImageSpace()) {
                toScreen.concatenate(trackerPanel.getCoords().getToWorldTransform(n));
            }
            TPoint selection = trackerPanel.getSelectedPoint();
            Point selectionPt = null;
            try {
                this.searchShape = toScreen.createTransformedShape(this.searchRect2D);
                this.searchHitShape = solid.createStrokedShape(this.searchShape);
                this.maskShape = toScreen.createTransformedShape(keyFrameData.getMask());
                this.maskHitShape = solid.createStrokedShape(this.maskShape);
            }
            catch (Exception e) {
                return null;
            }
            if (selection == this.maskHandle) {
                selectionPt = this.maskVisible ? this.maskHandle.getScreenPosition(trackerPanel) : null;
            } else if (selection == this.searchHandle) {
                Point point = selectionPt = this.searchVisible ? this.searchHandle.getScreenPosition(trackerPanel) : null;
            }
            if (frameData.isKeyFrameData()) {
                this.maskCenter.setLocation(keyFrameData.getMaskPoints()[0]);
                this.maskCorner.setLocation(keyFrameData.getMaskPoints()[1]);
            }
            this.screenPoints[0] = this.maskCorner.getScreenPosition(trackerPanel);
            if (selection == this.maskCorner) {
                selectionPt = this.maskVisible ? this.screenPoints[0] : null;
            } else {
                maskCornerMark = corner_footprint.getMark(this.screenPoints);
            }
            this.screenPoints[0] = this.searchCorner.getScreenPosition(trackerPanel);
            if (selection == this.searchCorner) {
                selectionPt = this.searchVisible ? this.screenPoints[0] : null;
            } else {
                searchCornerMark = corner_footprint.getMark(this.screenPoints);
            }
            this.screenPoints[0] = keyFrameData.getTarget().getScreenPosition(trackerPanel);
            if (selection == keyFrameData.getTarget()) {
                selectionPt = this.targetVisible ? this.screenPoints[0] : null;
            } else {
                targetMark = target_footprint.getMark(this.screenPoints);
            }
            TPoint[] matchPts = frameData.getMatchPoints();
            if (matchPts == null || frameData.isKeyFrameData() || k == 5) {
                this.matchShape = null;
            } else {
                Point p1 = matchPts[0].getScreenPosition(trackerPanel);
                Point p2 = this.maskCenter.getScreenPosition(trackerPanel);
                transform.setToTranslation(p1.x - p2.x, p1.y - p2.y);
                this.matchShape = toScreen.createTransformedShape(this.getMatchShape(matchPts));
                this.screenPoints[0] = this.getMatchTarget(matchPts[0]).getScreenPosition(trackerPanel);
            }
            if (selectionPt != null) {
                transform.setToTranslation(selectionPt.x, selectionPt.y);
                int scale = FontSizer.getIntegerFactor();
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                final Shape selectedShape = transform.createTransformedShape(Step.selectionShape);
                selectionMark = new Mark(){

                    @Override
                    public void draw(Graphics2D g, boolean highlighted) {
                        if (OSPRuntime.setRenderingHints) {
                            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        }
                        Stroke gstroke = g.getStroke();
                        g.setStroke(solidBold);
                        g.draw(selectedShape);
                        g.setStroke(gstroke);
                    }
                };
            }
            final Mark markMaskCorner = maskCornerMark;
            final Mark markSearchCorner = searchCornerMark;
            final Mark markTarget = targetMark;
            final Mark markSelection = selectionMark;
            this.mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    boolean isKeyFrame;
                    Paint gpaint = g.getPaint();
                    Color c = track.getFootprint().getColor();
                    g.setPaint(c);
                    if (OSPRuntime.setRenderingHints) {
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    BasicStroke stroke = (BasicStroke)g.getStroke();
                    int n = trackerPanel.getFrameNumber();
                    FrameData frameData = AutoTracker.this.getOrCreateFrameData(n);
                    boolean bl = isKeyFrame = frameData != null && frameData.isKeyFrameData();
                    if (AutoTracker.this.targetVisible && isKeyFrame && markTarget != null) {
                        markTarget.draw(g, false);
                    }
                    if (AutoTracker.this.matchShape != null && !isKeyFrame) {
                        g.setStroke(dotted);
                        g.draw(AutoTracker.this.matchShape);
                    }
                    if (AutoTracker.this.maskVisible && isKeyFrame) {
                        g.setStroke(stroke);
                        g.draw(AutoTracker.this.maskShape);
                        if (markMaskCorner != null) {
                            markMaskCorner.draw(g, false);
                        }
                    }
                    if (AutoTracker.this.searchVisible || !isKeyFrame) {
                        g.setStroke(dashed);
                        g.draw(AutoTracker.this.searchShape);
                        if (markSearchCorner != null) {
                            markSearchCorner.draw(g, false);
                        }
                    }
                    if (markSelection != null) {
                        markSelection.draw(g, false);
                    }
                    g.setStroke(stroke);
                    g.setPaint(gpaint);
                }
            };
        }
        return this.mark;
    }

    protected TPoint getMatchTarget(TPoint center) {
        double[] offset = this.getCurrentFrameData().getTargetOffset();
        return new TPoint(center.x + offset[0], center.y + offset[1]);
    }

    protected TPoint getMatchCenter(TPoint target) {
        double[] offset = this.getCurrentFrameData().getTargetOffset();
        return new TPoint(target.x - offset[0], target.y - offset[1]);
    }

    protected void delete(int n) {
        TFrame.repaintT(this.frame.getTrackerPanelForID(this.panelID));
        this.getOrCreateFrameData(n).clear();
    }

    protected void reset() {
        boolean isAlwaysMarked;
        this.mark = null;
        Map<Integer, FrameData> map = this.getFrameNumberToFrameDataMap();
        KeyFrameData keyFrameData = null;
        for (Map.Entry<Integer, FrameData> e : map.entrySet()) {
            FrameData frameData = e.getValue();
            frameData.clear();
            if (keyFrameData != null || !frameData.isKeyFrameData()) continue;
            keyFrameData = (KeyFrameData)frameData;
        }
        map.clear();
        this.keyFrameMap.clear();
        TTrack track = this.getTrack();
        boolean bl = isAlwaysMarked = track.steps.isAutofill() || track.ttype == 2;
        if (!isAlwaysMarked) {
            int n = 0;
            while (n < track.getSteps().length) {
                track.steps.setStep(n, null);
                ++n;
            }
        }
        this.stop(true, true);
        if (keyFrameData != null) {
            int n = keyFrameData.getFrameNumber();
            VideoPlayer player = this.trackerPanel().getPlayer();
            player.setStepNumber(player.getVideoClip().frameToStep(n));
        }
        this.repaint();
    }

    protected void refreshKeyFrame(KeyFrameData keyFrame, boolean checkSize) {
        RectangularShape mask = keyFrame.getMask();
        keyFrame.getMaskPoints()[0].setLocation(this.maskCenter);
        keyFrame.getMaskPoints()[1].setLocation(this.maskCorner);
        if (checkSize) {
            double sin = this.maskCenter.sin(this.maskCorner);
            double cos = this.maskCenter.cos(this.maskCorner);
            if (Double.isNaN(sin)) {
                sin = -0.707;
                cos = 0.707;
            }
            double d = Math.max((double)this.minMaskRadius, this.maskCenter.distance(this.maskCorner));
            double dx = d * cos;
            double dy = -d * sin;
            if (Math.abs(dx) < 1.0) {
                dx = dx > 0.0 ? 1.0 : -1.0;
            }
            if (Math.abs(dy) < 1.0) {
                dy = dy > 0.0 ? 1.0 : -1.0;
            }
            mask.setFrameFromCenter(this.maskCenter.x, this.maskCenter.y, this.maskCenter.x + dx, this.maskCenter.y + dy);
        } else {
            mask.setFrameFromCenter(this.maskCenter.x, this.maskCenter.y, this.maskCorner.x, this.maskCorner.y);
        }
        int w = Math.round(Math.round(mask.getWidth()));
        int h = Math.round(Math.round(mask.getHeight()));
        this.getWizard().ignoreChanges = true;
        this.getWizard().widthSpinner.setValue(w);
        this.getWizard().heightSpinner.setValue(h);
        this.getWizard().ignoreChanges = false;
        this.wizard.replaceIcons(keyFrame);
        TPoint p = keyFrame.getMarkedPoint();
        if (p != null) {
            keyFrame.getTarget().setXY(p.getX(), p.getY());
        }
        this.search(true, false);
        this.repaint();
        this.wizard.repaint();
    }

    protected BufferedImage createMagnifiedImage(BufferedImage source) {
        BufferedImage image = new BufferedImage(2 * source.getWidth(), 2 * source.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        g.drawImage(source, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        return image;
    }

    protected RectangularShape getMatchShape(TPoint[] pts) {
        RectangularShape mask = this.getCurrentKeyFrameData().getMask();
        RectangularShape match = mask instanceof Ellipse2D ? this.ellipseMatch : this.rectangleMatch;
        match.setFrameFromCenter(pts[0], pts[1]);
        return match;
    }

    protected int getStatusCode(int n) {
        FrameData frameData = this.getOrCreateFrameData(n);
        if (frameData.isKeyFrameData()) {
            return 0;
        }
        double[] widthAndHeight = frameData.getMatchWidthAndHeight();
        if (frameData.isMarked()) {
            boolean isCalibrationTool;
            if (frameData.isAutoMarked()) {
                if (widthAndHeight[1] > (double)this.goodMatch) {
                    return 1;
                }
                return 6;
            }
            TTrack track = this.getTrack();
            switch (track.ttype) {
                case 0: 
                case 2: 
                case 4: {
                    isCalibrationTool = true;
                    break;
                }
                case 8: {
                    isCalibrationTool = !((TapeMeasure)track).isReadOnly();
                    break;
                }
                default: {
                    isCalibrationTool = false;
                }
            }
            if (frameData.searched) {
                if (isCalibrationTool) {
                    if (widthAndHeight[1] > (double)this.possibleMatch) {
                        return 8;
                    }
                    return 9;
                }
                if (frameData.decided) {
                    return 5;
                }
                if (widthAndHeight[1] > (double)this.possibleMatch) {
                    return 8;
                }
                return 9;
            }
            return 7;
        }
        if (frameData.searched) {
            if (widthAndHeight[1] < (double)this.possibleMatch) {
                return 3;
            }
            return 2;
        }
        if (widthAndHeight == null) {
            return 7;
        }
        return 4;
    }

    protected boolean canStep() {
        int endStepNumber;
        VideoPlayer player = this.trackerPanel().getPlayer();
        int stepNumber = player.getStepNumber();
        return stepNumber < (endStepNumber = player.getVideoClip().getStepCount() - 1);
    }

    protected static boolean mayLeaveGaps() {
        return stopPolicy != 0;
    }

    protected boolean isDrawingKeyFrameFor(TTrack track, int index) {
        FrameData frameData;
        return this.getTrack() == track && this.wizard.isVisible() && (frameData = this.getCurrentFrameData()).isKeyFrameData() && frameData.getIndex() == index;
    }

    protected void clearSearchPointsDownstream() {
        int n = this.trackerPanel().getFrameNumber();
        for (Map.Entry<Integer, FrameData> e : this.getFrameNumberToFrameDataMap().entrySet()) {
            if (e.getKey() <= n) continue;
            FrameData frameData = e.getValue();
            if (frameData.isKeyFrameData()) break;
            frameData.setSearchPoints(null);
        }
    }

    protected boolean moveRectIntoImage(Rectangle2D searchRect) {
        Dimension d = this.getVideo().getImageSize(true);
        int w = d.width;
        int h = d.height;
        Point2D.Double corner = new Point2D.Double(searchRect.getX(), searchRect.getY());
        Dimension dim = new Dimension((int)searchRect.getWidth(), (int)searchRect.getHeight());
        boolean changed = false;
        if (w < dim.width || h < dim.height) {
            changed = true;
            dim.setSize(Math.min(w, dim.width), Math.min(h, dim.height));
            searchRect.setFrame(corner, dim);
        }
        double x = Math.max(0.0, ((Point2D)corner).getX());
        x = Math.min(x, (double)(w - dim.width));
        double y = Math.max(0.0, ((Point2D)corner).getY());
        y = Math.min(y, (double)(h - dim.height));
        if (x != ((Point2D)corner).getX() || y != ((Point2D)corner).getY()) {
            changed = true;
            ((Point2D)corner).setLocation(x, y);
            searchRect.setFrame(corner, dim);
        }
        return changed;
    }

    protected double[][] getDerivatives(TPoint[] positions, int order) {
        if (positions.length < order + 1) {
            return null;
        }
        if (order == 1) {
            int i = 0;
            while (i < this.derivatives1.length) {
                if (i >= positions.length - 1) {
                    this.derivatives1[i] = null;
                } else {
                    TPoint loc0 = positions[i + 1];
                    TPoint loc1 = positions[i];
                    if (loc0 == null || loc1 == null) {
                        this.derivatives1[i] = null;
                    } else {
                        double x = loc1.getX() - loc0.getX();
                        double y = loc1.getY() - loc0.getY();
                        if (this.derivatives1[i] == null) {
                            this.derivatives1[i] = new double[]{x, y};
                        } else {
                            this.derivatives1[i][0] = x;
                            this.derivatives1[i][1] = y;
                        }
                    }
                }
                ++i;
            }
            return this.derivatives1;
        }
        if (order == 2) {
            int i = 0;
            while (i < this.derivatives2.length) {
                if (i >= positions.length - 2) {
                    this.derivatives2[i] = null;
                } else {
                    TPoint loc0 = positions[i + 2];
                    TPoint loc1 = positions[i + 1];
                    TPoint loc2 = positions[i];
                    if (loc0 == null || loc1 == null || loc2 == null) {
                        this.derivatives2[i] = null;
                    } else {
                        double x = loc2.getX() - 2.0 * loc1.getX() + loc0.getX();
                        double y = loc2.getY() - 2.0 * loc1.getY() + loc0.getY();
                        if (this.derivatives2[i] == null) {
                            this.derivatives2[i] = new double[]{x, y};
                        } else {
                            this.derivatives2[i][0] = x;
                            this.derivatives2[i][1] = y;
                        }
                    }
                }
                ++i;
            }
            return this.derivatives2;
        }
        if (order == 3) {
            int i = 0;
            while (i < this.derivatives3.length) {
                if (i >= positions.length - 3) {
                    this.derivatives3[i] = null;
                } else {
                    TPoint loc0 = positions[i + 3];
                    TPoint loc1 = positions[i + 2];
                    TPoint loc2 = positions[i + 1];
                    TPoint loc3 = positions[i];
                    if (loc0 == null || loc1 == null || loc2 == null || loc3 == null) {
                        this.derivatives3[i] = null;
                    } else {
                        double x = loc3.getX() - 3.0 * loc2.getX() + 3.0 * loc1.getX() - loc0.getX();
                        double y = loc3.getY() - 3.0 * loc2.getY() + 3.0 * loc1.getY() - loc0.getY();
                        if (this.derivatives3[i] == null) {
                            this.derivatives3[i] = new double[]{x, y};
                        } else {
                            this.derivatives3[i][0] = x;
                            this.derivatives3[i][1] = y;
                        }
                    }
                }
                ++i;
            }
            return this.derivatives3;
        }
        return null;
    }

    protected abstract class ATObject
    extends TPoint {
        final String name;

        public ATObject(String name) {
            this.name = name;
        }
    }

    protected class Corner
    extends ATObject {
        public Corner(String name) {
            super(name);
        }

        @Override
        public void setXY(double x, double y) {
            super.setXY(x, y);
            if (this == AutoTracker.this.searchCorner) {
                AutoTracker.this.refreshSearchRect();
                AutoTracker.this.wizard.setChanged();
            } else {
                AutoTracker.this.refreshKeyFrame(AutoTracker.this.getCurrentKeyFrameData(), true);
            }
            AutoTracker.this.clearSearchPointsDownstream();
        }
    }

    protected class FrameData {
        private int index;
        private int frameNum;
        private int matcherHashCode;
        private int[] templateAlphas = new int[2];
        private double[] targetOffset = new double[]{0.0, 0.0};
        private double[] matchWidthAndHeight;
        private TPoint[] matchPoints;
        private TPoint[] searchPoints;
        TPoint trackPoint;
        private double[] autoMarkLoc;
        private BufferedImage templateImage;
        private Icon templateIcon;
        private Icon matchIcon;
        private Icon evolvedIcon;
        boolean searched;
        boolean decided;
        int[] workingPixels;

        FrameData(int pointIndex, int frameNumber) {
            this.index = pointIndex;
            this.frameNum = frameNumber;
        }

        FrameData(KeyFrameData keyFrame) {
            this.index = keyFrame.getIndex();
            this.frameNum = keyFrame.getFrameNumber();
            this.matchWidthAndHeight = keyFrame.getMatchWidthAndHeight();
            this.matchPoints = keyFrame.getMatchPoints();
            this.searchPoints = keyFrame.getSearchPoints(false);
            this.targetOffset = keyFrame.getTargetOffset();
            this.matchIcon = keyFrame.getMatchIcon();
            this.templateIcon = keyFrame.getTemplateIcon();
            this.evolvedIcon = keyFrame.getEvolvedIcon();
            this.autoMarkLoc = keyFrame.getAutoMarkLoc();
            this.trackPoint = keyFrame.trackPoint;
            this.searched = keyFrame.searched;
        }

        int getFrameNumber() {
            return this.frameNum;
        }

        Icon getTemplateIcon() {
            return this.templateIcon;
        }

        void setTemplateIcon(Icon icon) {
            this.templateIcon = icon;
        }

        Icon getMatchIcon() {
            return this.matchIcon;
        }

        void setMatchIcon(Icon icon) {
            this.matchIcon = icon;
        }

        Icon getEvolvedIcon() {
            return this.evolvedIcon;
        }

        void setEvolvedIcon(Icon icon) {
        }

        void setTemplate(TemplateMatcher matcher) {
            this.templateImage = matcher.getTemplate();
            this.templateAlphas[0] = matcher.getAlphas()[0];
            this.templateAlphas[1] = matcher.getAlphas()[1];
            this.workingPixels = matcher.getWorkingPixels();
            this.matcherHashCode = matcher.hashCode();
            this.setMatchIcon(null);
            BufferedImage img = AutoTracker.this.createMagnifiedImage(this.templateImage);
            this.setTemplateIcon(new ImageIcon(img));
        }

        void setEvolvedImage(BufferedImage image) {
            if (image == null) {
                this.setEvolvedIcon(null);
                return;
            }
            BufferedImage img = AutoTracker.this.createMagnifiedImage(image);
            this.setEvolvedIcon(new ImageIcon(img));
        }

        BufferedImage getTemplateToMatch() {
            if (this.templateImage == null || this.newTemplateExists()) {
                this.setTemplate(this.getTemplateMatcher());
            }
            return this.templateImage;
        }

        boolean newTemplateExists() {
            boolean appropriate;
            if (this.isKeyFrameData()) {
                return false;
            }
            TemplateMatcher matcher = this.getTemplateMatcher();
            if (matcher == null) {
                return false;
            }
            boolean different = matcher.getAlphas()[0] != this.templateAlphas[0] || matcher.getAlphas()[1] != this.templateAlphas[1] || matcher.hashCode() != this.matcherHashCode;
            boolean bl = appropriate = matcher.getIndex() < this.frameNum;
            return different && appropriate;
        }

        protected BufferedImage getTemplateImage() {
            return this.templateImage;
        }

        protected int[] getWorkingPixels() {
            return this.workingPixels;
        }

        TemplateMatcher getTemplateMatcher() {
            KeyFrameData keyFrameData = this.getKeyFrameData();
            return keyFrameData == null ? null : keyFrameData.matcher;
        }

        void setTargetOffset(double dx, double dy) {
            this.targetOffset = new double[]{dx, dy};
        }

        double[] getTargetOffset() {
            if (this.isKeyFrameData()) {
                return this.targetOffset;
            }
            return this.getKeyFrameData().getTargetOffset();
        }

        void setSearchPoints(TPoint[] points) {
            this.searchPoints = points;
        }

        TPoint[] getSearchPoints(boolean inherit) {
            if (!inherit || this.searchPoints != null || this.isKeyFrameData()) {
                return this.searchPoints;
            }
            Map<Integer, FrameData> map = this.getMyFrameDataMap();
            int i = this.frameNum + 1;
            while (--i >= 0) {
                FrameData frameData = map.get(i);
                if (frameData == null || frameData.searchPoints == null && !frameData.isKeyFrameData()) continue;
                return frameData.searchPoints;
            }
            return null;
        }

        void setMatchPoints(TPoint[] points) {
            this.matchPoints = points;
        }

        TPoint[] getMatchPoints() {
            return this.matchPoints;
        }

        void setMatchWidthAndHeight(double[] matchData) {
            this.matchWidthAndHeight = matchData;
        }

        double[] getMatchWidthAndHeight() {
            return this.matchWidthAndHeight;
        }

        protected Map<Integer, FrameData> getMyFrameDataMap() {
            return AutoTracker.this.getFrameNumberToFrameDataMap(this.index);
        }

        KeyFrameData getKeyFrameData() {
            if (this.isKeyFrameData()) {
                return (KeyFrameData)this;
            }
            int n = -1;
            Iterator it = AutoTracker.this.keyFrameMap.keySet().iterator();
            while (it.hasNext()) {
                int i = (Integer)it.next();
                if (i > this.frameNum) continue;
                n = i;
            }
            return n > -1 ? (KeyFrameData)AutoTracker.this.keyFrameMap.get(n) : null;
        }

        boolean hasKeyFrames() {
            for (Map.Entry<Integer, FrameData> e : AutoTracker.this.getFrameNumberToFrameDataMap().entrySet()) {
                if (!e.getValue().isKeyFrameData()) continue;
                return true;
            }
            return false;
        }

        int getIndex() {
            return this.index;
        }

        boolean isMarked() {
            TTrack track = AutoTracker.this.getTrack();
            return track != null && track.getStep(this.frameNum) != null;
        }

        boolean isAutoMarked() {
            if (this.autoMarkLoc == null || this.trackPoint == null) {
                return false;
            }
            if (this.trackPoint instanceof CoordAxes.AnglePoint) {
                CoordAxes.AnglePoint p;
                ImageCoordSystem coords = AutoTracker.this.frame.getTrackerPanelForID(AutoTracker.this.panelID).getCoords();
                double theta = coords.getAngle(this.frameNum);
                return Math.abs(theta - (p = (CoordAxes.AnglePoint)this.trackPoint).getAngle()) < 0.001;
            }
            return Math.abs(this.autoMarkLoc[0] - this.trackPoint.getX()) < 0.01 && Math.abs(this.autoMarkLoc[1] - this.trackPoint.getY()) < 0.01;
        }

        void setAutoMarkPoint(TPoint point) {
            double[] dArray;
            this.trackPoint = point;
            if (point == null) {
                dArray = null;
            } else {
                double[] dArray2 = new double[2];
                dArray2[0] = point.getX();
                dArray = dArray2;
                dArray2[1] = point.getY();
            }
            this.autoMarkLoc = dArray;
        }

        double[] getAutoMarkLoc() {
            return this.autoMarkLoc;
        }

        boolean isKeyFrameData() {
            return false;
        }

        TPoint getMarkedPoint() {
            if (!this.isMarked()) {
                return null;
            }
            if (this.trackPoint != null) {
                return this.trackPoint;
            }
            TTrack track = AutoTracker.this.getTrack();
            return track.getMarkedPoint(this.frameNum, this.index);
        }

        void clear() {
            this.matchPoints = null;
            this.matchWidthAndHeight = null;
            this.matchIcon = null;
            this.autoMarkLoc = null;
            this.searched = false;
            this.decided = false;
            this.trackPoint = null;
            this.workingPixels = null;
            this.matcherHashCode = 0;
            if (!this.isKeyFrameData()) {
                this.searchPoints = null;
                this.templateIcon = null;
                this.evolvedIcon = null;
                this.templateAlphas = new int[2];
                this.templateImage = null;
            }
        }
    }

    protected class Handle
    extends ATObject {
        public Handle(String name) {
            super(name);
        }

        @Override
        public void setXY(double x, double y) {
            double dx = x - this.getX();
            double dy = y - this.getY();
            super.setXY(x, y);
            if (this == AutoTracker.this.searchHandle) {
                ((AutoTracker)AutoTracker.this).searchCenter.x += dx;
                ((AutoTracker)AutoTracker.this).searchCenter.y += dy;
                ((AutoTracker)AutoTracker.this).searchCorner.x += dx;
                ((AutoTracker)AutoTracker.this).searchCorner.y += dy;
                AutoTracker.this.refreshSearchRect();
                AutoTracker.this.wizard.setChanged();
            } else {
                ((AutoTracker)AutoTracker.this).maskCenter.x += dx;
                ((AutoTracker)AutoTracker.this).maskCenter.y += dy;
                ((AutoTracker)AutoTracker.this).maskCorner.x += dx;
                ((AutoTracker)AutoTracker.this).maskCorner.y += dy;
                KeyFrameData keyFrameData = AutoTracker.this.getCurrentKeyFrameData();
                keyFrameData.getMaskPoints()[0].setLocation(AutoTracker.this.maskCenter);
                keyFrameData.getMaskPoints()[1].setLocation(AutoTracker.this.maskCorner);
                Target target = keyFrameData.getTarget();
                keyFrameData.setTargetOffset(target.x - ((AutoTracker)AutoTracker.this).maskCenter.x, target.y - ((AutoTracker)AutoTracker.this).maskCenter.y);
                AutoTracker.this.refreshKeyFrame(keyFrameData, true);
            }
            AutoTracker.this.clearSearchPointsDownstream();
        }

        public void setScreenLocation(int x, int y, VideoPanel vidPanel) {
            if (this.screenPt == null) {
                this.screenPt = new Point();
                this.toScreen = new AffineTransform();
            }
            if (this.worldPt == null) {
                this.worldPt = new Point2D.Double();
            }
            this.screenPt.setLocation(x, y);
            vidPanel.getPixelTransform(this.toScreen);
            try {
                this.toScreen.inverseTransform(this.screenPt, this.worldPt);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
            this.setLocation(this.worldPt);
            AutoTracker.this.repaint();
        }
    }

    protected class KeyFrameData
    extends FrameData {
        private RectangularShape mask;
        private Target target;
        private TPoint[] maskPoints;
        private TemplateMatcher matcher;

        KeyFrameData(TPoint keyPt, RectangularShape mask, Target target) {
            super(AutoTracker.this.getStepPointIndex(keyPt), keyPt.getFrameNumber(AutoTracker.this.trackerPanel()));
            this.maskPoints = new TPoint[]{new TPoint(), new TPoint()};
            this.mask = mask;
            this.target = target;
            this.maskPoints[0].setLocation(AutoTracker.this.maskCenter);
            this.maskPoints[1].setLocation(AutoTracker.this.maskCorner);
        }

        @Override
        boolean isKeyFrameData() {
            return true;
        }

        RectangularShape getMask() {
            return this.mask;
        }

        Target getTarget() {
            return this.target;
        }

        TPoint[] getMaskPoints() {
            return this.maskPoints;
        }

        void setTemplateMatcher(TemplateMatcher matcher) {
            this.matcher = matcher;
        }

        boolean isFirstKeyFrameData() {
            Map<Integer, FrameData> map = this.getMyFrameDataMap();
            int i = this.getFrameNumber();
            while (--i >= 0) {
                FrameData frameData = map.get(i);
                if (frameData == null || !frameData.isKeyFrameData()) continue;
                return false;
            }
            return true;
        }
    }

    static class SpinnerTumbleModel
    extends SpinnerListModel {
        SpinnerTumbleModel(ArrayList<String> values) {
            super(values);
        }

        @Override
        public Object getNextValue() {
            Object value = super.getNextValue();
            if (value == null && this.getList().size() > 0) {
                value = this.getList().get(0);
            }
            return value;
        }

        @Override
        public Object getPreviousValue() {
            Object value = super.getPreviousValue();
            int n = this.getList().size();
            if (value == null && n > 0) {
                value = this.getList().get(n - 1);
            }
            return value;
        }
    }

    class TallSpinner
    extends JSpinner {
        Component comp;

        TallSpinner(SpinnerModel model, Component heightComponent) {
            super(model);
            this.comp = heightComponent;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.height = this.comp.getPreferredSize().height;
            return dim;
        }
    }

    protected class Target
    extends TPoint {
        protected Target() {
        }

        @Override
        public void setXY(double x, double y) {
            super.setXY(x, y);
            int n = AutoTracker.this.frame.getTrackerPanelForID(AutoTracker.this.panelID).getFrameNumber();
            FrameData frameData = AutoTracker.this.getOrCreateFrameData(n);
            KeyFrameData keyFrameData = frameData.getKeyFrameData();
            keyFrameData.setTargetOffset(x - ((AutoTracker)AutoTracker.this).maskCenter.x, y - ((AutoTracker)AutoTracker.this).maskCenter.y);
            TTrack track = AutoTracker.this.getTrack();
            track.autoTrackerMarking = track.isAutoAdvance();
            track.undoEnabled = false;
            TPoint p = track.autoMarkAt(n, this.getX(), this.getY());
            track.undoEnabled = true;
            frameData.setAutoMarkPoint(p);
            track.autoTrackerMarking = false;
            AutoTracker.this.repaint();
            track.repaint();
        }
    }

    protected class Wizard
    extends JDialog
    implements PropertyChangeListener {
        private JButton startButton;
        private JButton searchNextButton;
        private JButton searchThisButton;
        private JButton closeButton;
        private JButton helpButton;
        private JButton deleteButton;
        private JButton keyFrameButton;
        private JButton copyDataButton;
        private JButton acceptButton;
        private JButton skipButton;
        private JSpinner evolveSpinner;
        private JSpinner acceptSpinner;
        private JSpinner tetherSpinner;
        private JSpinner widthSpinner;
        private JSpinner heightSpinner;
        private JComboBox<Object> trackDropdown;
        private JComboBox<Object> pointDropdown;
        private boolean isVisible;
        private boolean changed;
        private JTextArea textPane;
        protected JToolBar templateToolbar;
        protected JToolBar searchToolbar;
        protected JToolBar targetToolbar;
        protected JToolBar imageToolbar;
        protected JToolBar stopToolbar;
        protected JToolBar templateShapeToolbar;
        private JPanel startPanel;
        private JPanel followupPanel;
        private JPanel infoPanel;
        private JPanel northPanel;
        private JPanel targetPanel;
        private JLabel templateImageLabel;
        private JLabel matchImageLabel;
        private JLabel evolvedImageLabel;
        private JLabel keyImageLabel;
        private JLabel acceptLabel;
        private JLabel templateLabel;
        private JLabel ellipseLabel;
        private JLabel rectLabel;
        private JLabel widthLabel;
        private JLabel heightLabel;
        private JLabel frameLabel;
        private JLabel evolveLabel;
        private JLabel tetherLabel;
        private JLabel searchLabel;
        private JLabel targetLabel;
        private JLabel pointLabel;
        private JLabel trackLabel;
        private JLabel stopLabel;
        private JLabel templateShapeLabel;
        protected Dimension textPaneSize;
        private JRadioButton ellipseButton;
        private JRadioButton rectButton;
        private JCheckBox oneDCheckbox;
        private JRadioButton poorMatchButton;
        private JRadioButton noMatchButton;
        private JRadioButton neverStopButton;
        private JRadioButton lookAheadButton;
        private JRadioButton followButton;
        private JRadioButton fixedButton;
        private Object mouseOverObj;
        private MouseAdapter mouseOverListener;
        private Timer mouseOverTimer;
        private Timer evolveTemplateTimer;
        private boolean ignoreChanges;
        private boolean refreshPosted;
        protected boolean isPositioned;
        private ComponentListener myFollower;
        Action keyAction;

        public void clearTextPaneSize() {
            this.textPaneSize = null;
        }

        public Wizard() {
            super((Frame)AutoTracker.this.trackerPanel().getTFrame(), false);
            this.keyAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = Integer.parseInt(e.getActionCommand());
                    VideoPlayer player = AutoTracker.this.trackerPanel().getPlayer();
                    VideoClip clip = player.getVideoClip();
                    player.setStepNumber(clip.frameToStep(i));
                }
            };
            this.createGUI();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("tab")) {
                if (!AutoTracker.this.frame.isRemovingAll() && AutoTracker.this.panelID != null && e.getNewValue() == AutoTracker.this.trackerPanel()) {
                    this.setVisible(this.isVisible);
                } else {
                    boolean vis = this.isVisible;
                    this.setVisible(false);
                    this.isVisible = vis;
                }
            }
        }

        public void setChanged() {
            if (!this.changed) {
                this.changed = true;
                this.refreshGUI();
            }
        }

        @Override
        public void setVisible(boolean vis) {
            if (vis && !this.isPositioned) {
                OSPRuntime.trigger(100, e -> SwingUtilities.invokeLater(() -> {
                    this.clearTextPaneSize();
                    this.refreshGUIAsync();
                    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                    Point frameLoc = AutoTracker.this.frame.getLocationOnScreen();
                    int w = AutoTracker.this.wizard.getWidth() + 8;
                    int x = Math.min(screen.width - w, frameLoc.x + AutoTracker.this.frame.getWidth() - w);
                    int y = frameLoc.y + 90;
                    this.setLocation(x, y);
                    this.isPositioned = true;
                    this.setVisible(vis);
                }));
                return;
            }
            super.setVisible(vis);
            TrackerPanel panel = AutoTracker.this.frame.getTrackerPanelForID(AutoTracker.this.panelID);
            TToolBar toolbar = panel.getToolBar(true);
            toolbar.autotrackerButton.setSelected(vis);
            this.isVisible = vis;
            if (!vis) {
                AutoTracker.this.erase();
                panel.repaintDirtyRegion();
            } else {
                TTrack track = panel.getSelectedTrack();
                if (track != null) {
                    AutoTracker.this.setTrack(track);
                }
                this.refreshGUI();
            }
        }

        public void setFontLevel(int level) {
            FontSizer.setFonts(this, FontSizer.getLevel());
            Object[] buttons = new Object[]{this.acceptButton, this.skipButton};
            FontSizer.setFonts(buttons, FontSizer.getLevel());
            this.setFontLevel(this.trackDropdown);
            this.setFontLevel(this.pointDropdown);
            if (AutoTracker.this.panelID == null) {
                return;
            }
            this.clearTextPaneSize();
            this.refreshGUI();
        }

        private void setFontLevel(JComboBox<Object> next) {
            Object o = next.getSelectedItem();
            Object[] items = new Object[next.getItemCount()];
            int i = 0;
            while (i < items.length) {
                items[i] = next.getItemAt(i);
                ++i;
            }
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(items);
            next.setModel(model);
            if (next == this.pointDropdown) {
                next.setName("refresh");
                next.setSelectedItem(o);
                next.setName("");
            } else {
                next.setSelectedItem(o);
            }
        }

        @Override
        public void dispose() {
            AutoTracker.this.frame.removePropertyChangeListener("tab", this);
            AutoTracker.this.frame.removeComponentListener(this.myFollower);
            this.myFollower = null;
            this.mouseOverTimer.stop();
            this.mouseOverTimer = null;
            AutoTracker.this.panelID = null;
            AutoTracker.this.frame = null;
            super.dispose();
        }

        protected void setMaskDimensions(double width, double height) {
            if (((AutoTracker)AutoTracker.this).maskCorner.x - ((AutoTracker)AutoTracker.this).maskCenter.x == width / 2.0 && ((AutoTracker)AutoTracker.this).maskCorner.y - ((AutoTracker)AutoTracker.this).maskCenter.y == height / 2.0) {
                return;
            }
            ((AutoTracker)AutoTracker.this).maskCorner.x = ((AutoTracker)AutoTracker.this).maskCenter.x + width / 2.0;
            ((AutoTracker)AutoTracker.this).maskCorner.y = ((AutoTracker)AutoTracker.this).maskCenter.y + height / 2.0;
            KeyFrameData keyFrameData = AutoTracker.this.getCurrentKeyFrameData();
            AutoTracker.this.refreshKeyFrame(keyFrameData, false);
        }

        protected void setShapeToEllipse(boolean ellipse) {
            KeyFrameData keyFrameData = AutoTracker.this.getCurrentKeyFrameData();
            if (keyFrameData == null) {
                return;
            }
            RectangularShape s = keyFrameData.getMask();
            keyFrameData.mask = ellipse ? new Ellipse2D.Double(s.getX(), s.getY(), s.getWidth(), s.getHeight()) : new Rectangle2D.Double(s.getX(), s.getY(), s.getWidth(), s.getHeight());
            AutoTracker.this.search(true, false);
            this.replaceIcons(keyFrameData);
        }

        protected int getAlphaFromPercent(int percent) {
            int alpha = (int)(2.55 * (double)percent);
            return Math.max(0, Math.min(alpha, 255));
        }

        protected void createGUI() {
            Icon icon = TToolBar.autotrackerOffIcon;
            if (icon instanceof ResizableIcon && (icon = ((ResizableIcon)icon).getBaseIcon()) instanceof ImageIcon) {
                this.setIconImage(((ImageIcon)icon).getImage());
            }
            if (AutoTracker.this.frame != null) {
                AutoTracker.this.frame.addPropertyChangeListener("tab", this);
            }
            KeyAdapter kl = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    TrackerPanel trackerPanel = AutoTracker.this.frame.getTrackerPanelForID(AutoTracker.this.panelID);
                    if (!trackerPanel.getPlayer().isEnabled()) {
                        return;
                    }
                    switch (e.getKeyCode()) {
                        case 33: {
                            if (e.isShiftDown()) {
                                int n = trackerPanel.getPlayer().getStepNumber() - 5;
                                trackerPanel.getPlayer().setStepNumber(n);
                                break;
                            }
                            trackerPanel.getPlayer().back();
                            break;
                        }
                        case 34: {
                            if (e.isShiftDown()) {
                                int n = trackerPanel.getPlayer().getStepNumber() + 5;
                                trackerPanel.getPlayer().setStepNumber(n);
                                break;
                            }
                            trackerPanel.getPlayer().step();
                            break;
                        }
                        case 36: {
                            trackerPanel.getPlayer().setStepNumber(0);
                            break;
                        }
                        case 35: {
                            VideoClip clip = trackerPanel.getPlayer().getVideoClip();
                            trackerPanel.getPlayer().setStepNumber(clip.getStepCount() - 1);
                        }
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 16) {
                        TrackerPanel trackerPanel = AutoTracker.this.frame.getTrackerPanelForID(AutoTracker.this.panelID);
                        trackerPanel.isShiftKeyDown = false;
                        Wizard.this.startButton.setText(AutoTracker.this.stepping ? TrackerRes.getString("AutoTracker.Wizard.Button.Stop") : TrackerRes.getString("AutoTracker.Wizard.Button.Search"));
                    }
                }
            };
            int delay = 100;
            this.mouseOverTimer = new Timer(delay, e -> this.refreshNow());
            this.mouseOverTimer.setInitialDelay(delay);
            this.mouseOverTimer.setRepeats(false);
            delay = 100;
            this.evolveTemplateTimer = new Timer(delay, e -> {
                int n = AutoTracker.this.trackerPanel().getFrameNumber();
                FrameData framedata = AutoTracker.this.getOrCreateFrameData(n);
                if (framedata.isKeyFrameData()) {
                    AutoTracker.this.refreshKeyFrame((KeyFrameData)framedata, true);
                }
                AutoTracker.this.stop(true, false);
            });
            this.evolveTemplateTimer.setInitialDelay(delay);
            this.evolveTemplateTimer.setRepeats(false);
            this.mouseOverListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    JToolBar c = GUIUtils.getParentOrSelfToolBar((Container)e.getSource());
                    if (c != null) {
                        Wizard.this.mouseOverObj = c;
                        AutoTracker.this.isInteracting = true;
                    }
                    if (Wizard.this.mouseOverObj == null) {
                        Wizard.this.refreshNow();
                    } else {
                        Wizard.this.mouseOverTimer.restart();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Wizard.this.mouseOverTimer.restart();
                    Wizard.this.mouseOverObj = null;
                    AutoTracker.this.isInteracting = false;
                }
            };
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    TTrack track = AutoTracker.this.getTrack();
                    if (track != null) {
                        AutoTracker.this.trackerPanel().setSelectedTrack(track);
                    }
                }
            });
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            this.trackDropdown = new JComboBox<Object>(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    --dim.height;
                    return dim;
                }
            };
            this.trackDropdown.addMouseListener(this.mouseOverListener);
            int i = 0;
            while (i < this.trackDropdown.getComponentCount()) {
                this.trackDropdown.getComponent(i).addMouseListener(this.mouseOverListener);
                ++i;
            }
            this.trackDropdown.setRenderer(new TrackRenderer());
            this.trackDropdown.addActionListener(e -> {
                TTrack t;
                if ("refresh".equals(this.trackDropdown.getName())) {
                    return;
                }
                Object[] item = (Object[])this.trackDropdown.getSelectedItem();
                if (item != null && (t = AutoTracker.this.trackerPanel().getTrackByName(TTrack.class, (String)item[1])) != null) {
                    AutoTracker.this.stop(true, false);
                    AutoTracker.this.setTrack(t);
                    this.refreshGUI();
                }
            });
            this.startPanel = new JPanel();
            this.startButton = new JButton();
            this.startButton.setDisabledIcon(graySearchIcon);
            ActionListener searchAction = e -> {
                TrackerPanel tp = AutoTracker.this.trackerPanel();
                if (AutoTracker.this.stepping) {
                    AutoTracker.this.stop(false, false);
                } else {
                    this.startButton.setName(String.valueOf(tp.isAutoRefresh()));
                    tp.setAutoRefresh(false);
                    AutoTracker.this.search(true, true);
                }
            };
            this.startButton.addActionListener(e -> searchAction.actionPerformed(e));
            this.startButton.addKeyListener(kl);
            this.startButton.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Wizard.this.startButton.setText(AutoTracker.this.stepping ? TrackerRes.getString("AutoTracker.Wizard.Button.Stop") : TrackerRes.getString("AutoTracker.Wizard.Button.Search"));
                }
            });
            this.startPanel.add(this.startButton);
            this.searchThisButton = new JButton();
            this.searchThisButton.addActionListener(e -> {
                if (this.searchThisButton.getName() != null) {
                    AutoTracker.this.trackerPanel().getPlayer().back();
                    return;
                }
                AutoTracker.this.search(true, false);
            });
            this.searchThisButton.addKeyListener(kl);
            this.startPanel.add(this.searchThisButton);
            this.searchNextButton = new JButton();
            this.searchNextButton.addActionListener(e -> AutoTracker.this.search(false, false));
            this.searchNextButton.addKeyListener(kl);
            this.startPanel.add(this.searchNextButton);
            this.followupPanel = new JPanel();
            this.followupPanel.setBorder(BorderFactory.createEmptyBorder());
            this.followupPanel.setOpaque(false);
            this.imageToolbar = new JToolBar();
            this.imageToolbar.setFloatable(false);
            this.frameLabel = new JLabel();
            this.frameLabel.setOpaque(false);
            this.frameLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.frameLabel.addMouseListener(this.mouseOverListener);
            this.templateImageLabel = new JLabel();
            this.templateImageLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.templateImageLabel.setIconTextGap(3);
            this.templateImageLabel.setHorizontalTextPosition(2);
            this.templateImageLabel.addMouseListener(this.mouseOverListener);
            this.matchImageLabel = new JLabel();
            this.matchImageLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.matchImageLabel.setIconTextGap(3);
            this.matchImageLabel.setHorizontalTextPosition(2);
            this.matchImageLabel.addMouseListener(this.mouseOverListener);
            this.evolvedImageLabel = new JLabel();
            this.evolvedImageLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.evolvedImageLabel.setIconTextGap(3);
            this.evolvedImageLabel.setHorizontalTextPosition(2);
            this.evolvedImageLabel.addMouseListener(this.mouseOverListener);
            this.keyImageLabel = new JLabel();
            this.keyImageLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.keyImageLabel.setIconTextGap(3);
            this.keyImageLabel.setHorizontalTextPosition(2);
            this.keyImageLabel.addMouseListener(this.mouseOverListener);
            JPanel flowpanel = new JPanel();
            flowpanel.setOpaque(false);
            flowpanel.setBorder(BorderFactory.createEmptyBorder());
            flowpanel.add(this.templateImageLabel);
            flowpanel.add(this.matchImageLabel);
            flowpanel.add(this.keyImageLabel);
            flowpanel.add(this.evolvedImageLabel);
            this.imageToolbar.add(this.frameLabel);
            this.imageToolbar.add(flowpanel);
            this.imageToolbar.addMouseListener(this.mouseOverListener);
            this.templateToolbar = new JToolBar();
            this.templateToolbar.setFloatable(false);
            this.templateToolbar.addMouseListener(this.mouseOverListener);
            this.templateLabel = new JLabel();
            this.templateLabel.setOpaque(false);
            this.templateLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.evolveLabel = new JLabel();
            this.evolveLabel.setOpaque(false);
            this.evolveLabel.addMouseListener(this.mouseOverListener);
            this.evolveLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.tetherLabel = new JLabel();
            this.tetherLabel.setOpaque(false);
            this.tetherLabel.addMouseListener(this.mouseOverListener);
            this.tetherLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.acceptLabel = new JLabel();
            this.acceptLabel.setOpaque(false);
            this.acceptLabel.addMouseListener(this.mouseOverListener);
            this.acceptLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.evolveSpinner = new TallSpinner(new SpinnerNumberModel(20, 0, 100, 1), this.trackDropdown);
            this.tetherSpinner = new TallSpinner(new SpinnerNumberModel(5, 0, 100, 1), this.trackDropdown);
            this.acceptSpinner = new TallSpinner(new SpinnerNumberModel(AutoTracker.this.goodMatch, AutoTracker.this.possibleMatch, 10, 1), this.trackDropdown);
            JFormattedTextField.AbstractFormatterFactory percentFormat = new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    JFormattedTextField.AbstractFormatter formatter = new JFormattedTextField.AbstractFormatter(){

                        @Override
                        public String valueToString(Object value) throws ParseException {
                            return String.valueOf(value.toString()) + "%";
                        }

                        @Override
                        public Object stringToValue(String text) throws ParseException {
                            return Integer.parseInt(text.substring(0, text.length() - 1));
                        }
                    };
                    return formatter;
                }
            };
            ChangeListener spinnerListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (Wizard.this.ignoreChanges) {
                        return;
                    }
                    JSpinner spinner = (JSpinner)e.getSource();
                    Integer i = (Integer)spinner.getValue();
                    if (spinner == Wizard.this.evolveSpinner) {
                        AutoTracker.this.evolveAlpha = Wizard.this.getAlphaFromPercent(i);
                    } else {
                        AutoTracker.this.tetherAlpha = Wizard.this.getAlphaFromPercent(i);
                    }
                    Wizard.this.evolveTemplateTimer.restart();
                }
            };
            JSpinner[] spinners = new JSpinner[]{this.evolveSpinner, this.tetherSpinner, this.acceptSpinner};
            int i2 = 0;
            while (i2 < spinners.length) {
                JSpinner spinner = spinners[i2];
                int j = 0;
                while (j < spinner.getComponentCount()) {
                    spinner.getComponent(j).addMouseListener(this.mouseOverListener);
                    ++j;
                }
                JFormattedTextField tf = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
                tf.addMouseListener(this.mouseOverListener);
                tf.setEnabled(false);
                tf.setDisabledTextColor(Color.BLACK);
                switch (i2) {
                    case 0: 
                    case 1: {
                        tf.setFormatterFactory(percentFormat);
                        spinner.addChangeListener(spinnerListener);
                        break;
                    }
                    case 2: {
                        spinner.addChangeListener(e -> {
                            AutoTracker.this.goodMatch = (Integer)this.acceptSpinner.getValue();
                            this.setChanged();
                        });
                    }
                }
                ++i2;
            }
            flowpanel = new JPanel();
            flowpanel.setOpaque(false);
            flowpanel.add(this.evolveLabel);
            flowpanel.add(this.evolveSpinner);
            flowpanel.add(this.tetherLabel);
            flowpanel.add(this.tetherSpinner);
            flowpanel.add(this.acceptLabel);
            flowpanel.add(this.acceptSpinner);
            this.templateToolbar.add(this.templateLabel);
            this.templateToolbar.add(flowpanel);
            this.templateShapeToolbar = new JToolBar();
            this.templateShapeToolbar.setFloatable(false);
            this.templateShapeToolbar.addMouseListener(this.mouseOverListener);
            this.templateShapeLabel = new JLabel();
            this.templateShapeLabel.setOpaque(false);
            this.templateShapeLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.ellipseLabel = new JLabel();
            this.ellipseLabel.setOpaque(false);
            this.ellipseLabel.addMouseListener(this.mouseOverListener);
            this.ellipseLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Wizard.this.ellipseButton.doClick(0);
                }
            });
            this.ellipseLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
            this.ellipseLabel.setIcon(circleIcon);
            this.ellipseLabel.setDisabledIcon(circleDisabledIcon);
            this.rectLabel = new JLabel();
            this.rectLabel.setOpaque(false);
            this.rectLabel.addMouseListener(this.mouseOverListener);
            this.rectLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Wizard.this.rectButton.doClick(0);
                }
            });
            this.rectLabel.setIcon(squareIcon);
            this.rectLabel.setDisabledIcon(squareDisabledIcon);
            this.rectLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
            TrackerPanel trackerPanel = AutoTracker.this.frame.getTrackerPanelForID(AutoTracker.this.panelID);
            this.ellipseButton = new JRadioButton();
            this.ellipseButton.addMouseListener(this.mouseOverListener);
            this.ellipseButton.setBorder(BorderFactory.createEmptyBorder());
            this.ellipseButton.setOpaque(false);
            this.ellipseButton.addActionListener(e -> {
                this.setShapeToEllipse(true);
                TFrame.repaintT(trackerPanel);
            });
            this.rectButton = new JRadioButton();
            this.rectButton.addMouseListener(this.mouseOverListener);
            this.rectButton.setOpaque(false);
            this.rectButton.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.rectButton.addActionListener(e -> {
                this.setShapeToEllipse(false);
                TFrame.repaintT(trackerPanel);
            });
            ButtonGroup group = new ButtonGroup();
            group.add(this.ellipseButton);
            group.add(this.rectButton);
            this.ellipseButton.setSelected(true);
            this.widthLabel = new JLabel();
            this.widthLabel.setOpaque(false);
            this.widthLabel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
            this.widthLabel.addMouseListener(this.mouseOverListener);
            this.heightLabel = new JLabel();
            this.heightLabel.setOpaque(false);
            this.heightLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
            this.heightLabel.addMouseListener(this.mouseOverListener);
            this.widthSpinner = new TallSpinner(new SpinnerNumberModel(defaultMaskSize[0], 2 * AutoTracker.this.minMaskRadius, 99, 1), this.trackDropdown);
            this.heightSpinner = new TallSpinner(new SpinnerNumberModel(defaultMaskSize[0], 2 * AutoTracker.this.minMaskRadius, 99, 1), this.trackDropdown);
            spinners = new JSpinner[]{this.widthSpinner, this.heightSpinner};
            int i3 = 0;
            while (i3 < spinners.length) {
                JSpinner spinner = spinners[i3];
                int j = 0;
                while (j < spinner.getComponentCount()) {
                    spinner.getComponent(j).addMouseListener(this.mouseOverListener);
                    ++j;
                }
                JFormattedTextField tf = ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField();
                tf.addMouseListener(this.mouseOverListener);
                tf.setDisabledTextColor(Color.BLACK);
                ++i3;
            }
            ChangeListener dimensionsListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (Wizard.this.ignoreChanges) {
                        return;
                    }
                    Integer w = (Integer)Wizard.this.widthSpinner.getValue();
                    Integer h = (Integer)Wizard.this.heightSpinner.getValue();
                    int n = AutoTracker.this.frame.getTrackerPanelForID(AutoTracker.this.panelID).getFrameNumber();
                    KeyFrameData keyFrameData = AutoTracker.this.getOrCreateFrameData(n).getKeyFrameData();
                    RectangularShape mask = keyFrameData.getMask();
                    if (e.getSource() == Wizard.this.widthSpinner) {
                        Wizard.this.setMaskDimensions(w.intValue(), mask.getHeight());
                    } else {
                        Wizard.this.setMaskDimensions(mask.getWidth(), h.intValue());
                    }
                }
            };
            this.widthSpinner.addChangeListener(dimensionsListener);
            this.heightSpinner.addChangeListener(dimensionsListener);
            flowpanel = new JPanel();
            flowpanel.setOpaque(false);
            flowpanel.add(this.ellipseButton);
            flowpanel.add(this.ellipseLabel);
            flowpanel.add(this.rectButton);
            flowpanel.add(this.rectLabel);
            JButton separator = TToolBar.getSeparator();
            separator.addMouseListener(this.mouseOverListener);
            flowpanel.add(separator);
            flowpanel.add(this.widthLabel);
            flowpanel.add(this.widthSpinner);
            flowpanel.add(this.heightLabel);
            flowpanel.add(this.heightSpinner);
            this.templateShapeToolbar.add(this.templateShapeLabel);
            this.templateShapeToolbar.add(flowpanel);
            this.searchToolbar = new JToolBar();
            this.searchToolbar.setFloatable(false);
            this.searchToolbar.addMouseListener(this.mouseOverListener);
            this.searchLabel = new JLabel();
            this.searchLabel.setOpaque(false);
            this.searchLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.oneDCheckbox = new JCheckBox();
            this.oneDCheckbox.addMouseListener(this.mouseOverListener);
            this.oneDCheckbox.setOpaque(false);
            this.oneDCheckbox.setSelected(AutoTracker.this.lineSpread >= 0);
            this.oneDCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 6));
            this.oneDCheckbox.addActionListener(e -> {
                AutoTracker.this.lineSpread = this.oneDCheckbox.isSelected() ? 0 : -1;
                this.setChanged();
                if (this.oneDCheckbox.isSelected()) {
                    AutoTracker.this.moveOriginToFirstKeyFrame();
                    trackerPanel.getAxes().setVisible(true);
                }
                TFrame.repaintT(trackerPanel);
            });
            this.lookAheadButton = new JRadioButton();
            this.lookAheadButton.addMouseListener(this.mouseOverListener);
            this.lookAheadButton.setOpaque(false);
            this.lookAheadButton.setSelected(true);
            this.lookAheadButton.addActionListener(e -> {
                searchAreaPolicy = 0;
                this.setChanged();
            });
            this.followButton = new JRadioButton();
            this.followButton.addMouseListener(this.mouseOverListener);
            this.followButton.setOpaque(false);
            this.followButton.setSelected(true);
            this.followButton.addActionListener(e -> {
                searchAreaPolicy = 1;
                this.setChanged();
            });
            this.fixedButton = new JRadioButton();
            this.fixedButton.addMouseListener(this.mouseOverListener);
            this.fixedButton.setOpaque(false);
            this.fixedButton.setSelected(true);
            this.fixedButton.addActionListener(e -> {
                searchAreaPolicy = 2;
                this.setChanged();
            });
            this.fixedButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 12));
            group = new ButtonGroup();
            group.add(this.lookAheadButton);
            group.add(this.followButton);
            group.add(this.fixedButton);
            flowpanel = new JPanel();
            flowpanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            flowpanel.setOpaque(false);
            flowpanel.add(this.lookAheadButton);
            flowpanel.add(this.followButton);
            flowpanel.add(this.fixedButton);
            separator = TToolBar.getSeparator();
            separator.addMouseListener(this.mouseOverListener);
            flowpanel.add(separator);
            flowpanel.add(this.oneDCheckbox);
            this.searchToolbar.add(this.searchLabel);
            this.searchToolbar.add(flowpanel);
            this.stopToolbar = new JToolBar();
            this.stopToolbar.setFloatable(false);
            this.stopToolbar.addMouseListener(this.mouseOverListener);
            this.stopLabel = new JLabel();
            this.stopLabel.setOpaque(false);
            this.stopLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.poorMatchButton = new JRadioButton();
            this.poorMatchButton.addMouseListener(this.mouseOverListener);
            this.poorMatchButton.setOpaque(false);
            this.poorMatchButton.setSelected(true);
            this.poorMatchButton.addActionListener(e -> {
                stopPolicy = 0;
            });
            this.noMatchButton = new JRadioButton();
            this.noMatchButton.addMouseListener(this.mouseOverListener);
            this.noMatchButton.setOpaque(false);
            this.noMatchButton.setSelected(false);
            this.noMatchButton.addActionListener(e -> {
                stopPolicy = 1;
            });
            this.neverStopButton = new JRadioButton();
            this.neverStopButton.addMouseListener(this.mouseOverListener);
            this.neverStopButton.setOpaque(false);
            this.neverStopButton.setSelected(false);
            this.neverStopButton.addActionListener(e -> {
                stopPolicy = 2;
            });
            group = new ButtonGroup();
            group.add(this.poorMatchButton);
            group.add(this.noMatchButton);
            group.add(this.neverStopButton);
            flowpanel = new JPanel();
            flowpanel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            flowpanel.setOpaque(false);
            flowpanel.add(this.poorMatchButton);
            flowpanel.add(this.noMatchButton);
            flowpanel.add(this.neverStopButton);
            this.stopToolbar.add(this.stopLabel);
            this.stopToolbar.add(flowpanel);
            this.targetToolbar = new JToolBar();
            this.targetToolbar.setFloatable(false);
            this.targetToolbar.addMouseListener(this.mouseOverListener);
            this.targetLabel = new JLabel();
            this.targetLabel.setOpaque(false);
            this.targetLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
            this.trackLabel = new JLabel();
            this.trackLabel.setOpaque(false);
            this.pointLabel = new JLabel();
            this.pointLabel.setOpaque(false);
            this.pointLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.pointDropdown = new JComboBox<Object>(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.height = ((Wizard)Wizard.this).trackDropdown.getPreferredSize().height;
                    return dim;
                }

                @Override
                public void setSelectedItem(Object o) {
                    super.setSelectedItem(o);
                }
            };
            this.pointDropdown.addMouseListener(this.mouseOverListener);
            int i4 = 0;
            while (i4 < this.pointDropdown.getComponentCount()) {
                this.pointDropdown.getComponent(i4).addMouseListener(this.mouseOverListener);
                ++i4;
            }
            this.pointDropdown.addActionListener(e -> {
                if ("refresh".equals(this.pointDropdown.getName())) {
                    return;
                }
                String item = (String)this.pointDropdown.getSelectedItem();
                if (item != null) {
                    AutoTracker.this.stop(true, false);
                    TTrack track = AutoTracker.this.getTrack();
                    if (track == null) {
                        return;
                    }
                    track.setTargetIndex(item);
                    TPoint[] searchPts = AutoTracker.this.getCurrentFrameData().getSearchPoints(true);
                    if (searchPts != null) {
                        AutoTracker.this.setSearchPoints(searchPts[0], searchPts[1]);
                    }
                    this.refreshGUI();
                }
            });
            this.targetPanel = new JPanel();
            this.targetPanel.setOpaque(false);
            this.targetPanel.add(this.trackLabel);
            this.targetPanel.add(this.trackDropdown);
            this.targetPanel.add(this.pointLabel);
            this.targetPanel.add(this.pointDropdown);
            this.targetToolbar.add(this.targetLabel);
            this.targetToolbar.add(this.targetPanel);
            this.textPane = new JTextArea();
            this.textPane.setEditable(false);
            this.textPane.setLineWrap(true);
            this.textPane.setWrapStyleWord(true);
            this.textPane.setBorder(BorderFactory.createEmptyBorder());
            this.textPane.setForeground(Color.blue);
            this.textPane.addKeyListener(kl);
            this.textPane.addMouseListener(this.mouseOverListener);
            this.closeButton = new JButton();
            this.closeButton.addActionListener(e -> {
                AutoTracker.this.stop(true, true);
                this.setVisible(false);
            });
            this.closeButton.addKeyListener(kl);
            this.helpButton = new JButton();
            this.helpButton.addActionListener(e -> trackerPanel.getTFrame().showHelp("autotracker", 0));
            this.helpButton.addKeyListener(kl);
            this.acceptButton = new JButton();
            this.acceptButton.addActionListener(e -> this.acceptAction());
            this.acceptButton.addKeyListener(kl);
            this.skipButton = new JButton();
            this.skipButton.addActionListener(e -> this.skipAction());
            this.skipButton.addKeyListener(kl);
            this.deleteButton = new JButton();
            this.deleteButton.addActionListener(e -> this.deleteButtonAction());
            this.deleteButton.addKeyListener(kl);
            this.keyFrameButton = new JButton();
            this.keyFrameButton.addActionListener(e -> this.keyFrameButtonAction());
            this.keyFrameButton.addKeyListener(kl);
            this.copyDataButton = new JButton();
            this.copyDataButton.addActionListener(e -> {
                String matchScore = this.getMatchDataString();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(matchScore);
                clipboard.setContents(stringSelection, stringSelection);
            });
            this.copyDataButton.addKeyListener(kl);
            this.infoPanel = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    if (Wizard.this.textPaneSize != null) {
                        return Wizard.this.textPaneSize;
                    }
                    return super.getPreferredSize();
                }
            };
            Border empty = BorderFactory.createEmptyBorder(4, 6, 4, 6);
            Border etch = BorderFactory.createEtchedBorder();
            this.infoPanel.setBorder(BorderFactory.createCompoundBorder(etch, empty));
            this.infoPanel.setBackground(this.textPane.getBackground());
            this.infoPanel.add((Component)this.textPane, "Center");
            this.infoPanel.add((Component)this.followupPanel, "South");
            JPanel controlPanel = new JPanel(new GridLayout(0, 1));
            controlPanel.add(this.templateToolbar);
            controlPanel.add(this.templateShapeToolbar);
            controlPanel.add(this.searchToolbar);
            controlPanel.add(this.stopToolbar);
            controlPanel.add(this.targetToolbar);
            this.northPanel = new JPanel(new BorderLayout());
            this.northPanel.add((Component)this.startPanel, "North");
            this.northPanel.add((Component)this.imageToolbar, "South");
            JPanel center = new JPanel(new BorderLayout());
            center.add((Component)controlPanel, "North");
            center.add((Component)this.infoPanel, "Center");
            JPanel south = new JPanel(new FlowLayout());
            south.add(this.helpButton);
            south.add(this.keyFrameButton);
            south.add(this.deleteButton);
            south.add(this.copyDataButton);
            south.add(this.closeButton);
            contentPane.add((Component)this.northPanel, "North");
            contentPane.add((Component)center, "Center");
            contentPane.add((Component)south, "South");
            AutoTracker.this.evolveAlpha = this.getAlphaFromPercent(20);
            AutoTracker.this.tetherAlpha = this.getAlphaFromPercent(5);
            this.myFollower = AutoTracker.this.frame.addFollower(this, null);
        }

        protected void refreshNow() {
            this.refreshInfo();
            this.refreshDrawingFlags();
            AutoTracker.this.erase();
            TFrame.repaintT(AutoTracker.this.trackerPanel());
        }

        protected void acceptAction() {
            int n = AutoTracker.this.trackerPanel().getFrameNumber();
            FrameData frameData = AutoTracker.this.getOrCreateFrameData(n);
            TemplateMatcher matcher = AutoTracker.this.getTemplateMatcher();
            matcher.setTemplate(frameData.getTemplateImage());
            matcher.setWorkingPixels(frameData.getWorkingPixels());
            AutoTracker.this.buildEvolvedTemplateImage(frameData);
            AutoTracker.this.marking = true;
            TPoint p = AutoTracker.this.getMatchTarget(frameData.getMatchPoints()[0]);
            TTrack track = AutoTracker.this.getTrack();
            TPoint target = track.autoMarkAt(n, p.x, p.y);
            frameData.setAutoMarkPoint(target);
            frameData.decided = true;
            if (AutoTracker.this.stepping && AutoTracker.this.canStep()) {
                AutoTracker.this.paused = false;
                AutoTracker.this.trackerPanel().getPlayer().step();
            } else {
                AutoTracker.this.stop(true, true);
            }
        }

        protected void skipAction() {
            AutoTracker.this.getCurrentFrameData().decided = true;
            if (AutoTracker.this.canStep()) {
                AutoTracker.this.paused = false;
                AutoTracker.this.trackerPanel().getPlayer().step();
            } else {
                AutoTracker.this.stop(true, false);
            }
        }

        protected void startAction(ActionEvent e, ActionListener searchAction) {
            searchAction.actionPerformed(e);
        }

        protected void deleteLaterAction() {
            boolean isAlwaysMarked;
            Integer n = AutoTracker.this.trackerPanel().getFrameNumber();
            Map<Integer, FrameData> map = AutoTracker.this.getFrameNumberToFrameDataMap();
            Iterator<Map.Entry<Integer, FrameData>> iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Integer, FrameData> e = iter.next();
                if (e.getKey().compareTo(n) != 1) continue;
                e.getValue().clear();
                iter.remove();
            }
            TTrack track = AutoTracker.this.getTrack();
            boolean bl = isAlwaysMarked = track.steps.isAutofill() || track.ttype == 2;
            if (!isAlwaysMarked) {
                Step[] steps = track.getSteps();
                int i = n + 1;
                while (i < steps.length) {
                    steps[i] = null;
                    ++i;
                }
            }
            this.refreshGUI();
            AutoTracker.this.repaint();
            track.invalidateData(track);
            track.fireStepsChanged();
        }

        protected void deleteThisAction() {
            boolean isAlwaysMarked;
            int n = AutoTracker.this.trackerPanel().getFrameNumber();
            Map<Integer, FrameData> map = AutoTracker.this.getFrameNumberToFrameDataMap();
            FrameData frameData = map.get(n);
            if (!frameData.isKeyFrameData()) {
                map.remove(n);
            }
            frameData.clear();
            TTrack track = AutoTracker.this.getTrack();
            boolean bl = isAlwaysMarked = track.steps.isAutofill() || track.ttype == 2;
            if (!isAlwaysMarked && track.getSteps().length > n) {
                track.getSteps()[n] = null;
            }
            this.refreshGUI();
            AutoTracker.this.repaint();
            track.invalidateData(track);
            track.fireStepsChanged();
        }

        protected void deleteButtonAction() {
            JMenuItem item;
            TTrack track = AutoTracker.this.getTrack();
            boolean isAlwaysMarked = track.steps.isAutofill() || track.ttype == 2;
            boolean hasThis = false;
            int n = AutoTracker.this.trackerPanel().getFrameNumber();
            boolean isKeyFrame = AutoTracker.this.getOrCreateFrameData(n).isKeyFrameData();
            int stepCount = 0;
            boolean hasLater = false;
            if (isAlwaysMarked) {
                Map<Integer, FrameData> map = AutoTracker.this.getFrameNumberToFrameDataMap();
                for (Map.Entry<Integer, FrameData> e2 : map.entrySet()) {
                    FrameData frameData = e2.getValue();
                    if (frameData.trackPoint == null) continue;
                    int i = e2.getKey();
                    hasLater = hasLater || i > n;
                    hasThis = hasThis || i == n;
                    ++stepCount;
                }
            } else {
                hasThis = track.getStep(n) != null;
                Step[] steps = track.getSteps();
                int i = 0;
                while (i < steps.length) {
                    if (steps[i] != null) {
                        hasLater = hasLater || i > n;
                        ++stepCount;
                    }
                    ++i;
                }
            }
            JPopupMenu popup = new JPopupMenu();
            if (isKeyFrame) {
                item = new JMenuItem(TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteThisKeyFrame"));
                popup.add(item);
                item.addActionListener(e -> this.deleteKeyFrameAction());
            }
            if (hasThis) {
                item = new JMenuItem(isAlwaysMarked ? TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteThisMatch") : TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteThis"));
                popup.add(item);
                item.addActionListener(e -> this.deleteThisAction());
            }
            if (hasLater) {
                item = new JMenuItem(isAlwaysMarked ? TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteLaterMatches") : TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteLater"));
                popup.add(item);
                item.addActionListener(e -> this.deleteLaterAction());
            }
            if (!(stepCount <= 0 || stepCount == 1 && hasThis)) {
                item = new JMenuItem(TrackerRes.getString("AutoTracker.Wizard.Menuitem.DeleteAll"));
                popup.add(item);
                item.addActionListener(e -> AutoTracker.this.reset());
            }
            FontSizer.setFonts(popup, FontSizer.getLevel());
            popup.show(this.deleteButton, 0, this.deleteButton.getHeight());
        }

        protected void keyFrameButtonAction() {
            ArrayList<Integer> keyFrames = new ArrayList<Integer>();
            Map<Integer, FrameData> map = AutoTracker.this.getFrameNumberToFrameDataMap();
            for (Map.Entry<Integer, FrameData> e : map.entrySet()) {
                if (!e.getValue().isKeyFrameData()) continue;
                keyFrames.add(e.getKey());
            }
            JPopupMenu popup = new JPopupMenu();
            for (Integer i : keyFrames) {
                String si = i.toString();
                String s = TrackerRes.getString("AutoTracker.Label.Frame");
                JMenuItem item = new JMenuItem(String.valueOf(s) + " " + si);
                item.addActionListener(this.keyAction);
                item.setActionCommand(si);
                popup.add(item);
            }
            FontSizer.setFonts(popup, FontSizer.getLevel());
            popup.show(this.keyFrameButton, 0, this.keyFrameButton.getHeight());
        }

        protected void deleteKeyFrameAction() {
            int n = AutoTracker.this.trackerPanel().getFrameNumber();
            KeyFrameData keyFrameData = AutoTracker.this.getOrCreateFrameData(n).getKeyFrameData();
            Map<Integer, FrameData> map = AutoTracker.this.getFrameNumberToFrameDataMap();
            Integer nextKey = null;
            block0: for (Map.Entry<Integer, FrameData> e : map.entrySet()) {
                FrameData frameData = e.getValue();
                Integer i = e.getKey();
                if (!frameData.isKeyFrameData() || frameData != keyFrameData) continue;
                for (Map.Entry<Integer, FrameData> e2 : map.entrySet()) {
                    FrameData next;
                    Integer j = e2.getKey();
                    if (j.compareTo(i) <= 0 || !(next = e2.getValue()).isKeyFrameData()) continue;
                    nextKey = j;
                    break block0;
                }
            }
            map.put(n, new FrameData(keyFrameData));
            AutoTracker.this.keyFrameMap.remove(n);
            keyFrameData = AutoTracker.this.getOrCreateFrameData(n).getKeyFrameData();
            if (keyFrameData != null) {
                AutoTracker.this.maskCenter.setLocation(keyFrameData.getMaskPoints()[0]);
                AutoTracker.this.maskCorner.setLocation(keyFrameData.getMaskPoints()[1]);
            } else {
                Iterator<Map.Entry<Integer, FrameData>> iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Integer, FrameData> e = iter.next();
                    if (nextKey != null && e.getKey().compareTo(nextKey) >= 0) break;
                    e.getValue().clear();
                    iter.remove();
                }
            }
            TTrack track = AutoTracker.this.getTrack();
            if (track.getStep(n) == null) {
                FrameData frameData = AutoTracker.this.getOrCreateFrameData(n);
                if (frameData != null) {
                    frameData.setTemplateIcon(null);
                    frameData.setSearchPoints(null);
                }
                for (Map.Entry<Integer, FrameData> e : map.entrySet()) {
                    Integer i = e.getKey();
                    int iv = i;
                    if (iv <= n || (frameData = map.get(i)).isKeyFrameData() || track.getStep(iv) != null) continue;
                    frameData.clear();
                }
            }
            this.refreshGUI();
            AutoTracker.this.repaint();
            TFrame.repaintT(AutoTracker.this.trackerPanel());
        }

        protected void refreshTextPaneSize() {
            this.clearTextPaneSize();
            this.followupPanel.removeAll();
            this.followupPanel.add(this.acceptButton);
            this.textPane.setText(this.getTemplateInstructions());
            Dimension dim = this.infoPanel.getPreferredSize();
            this.textPane.setText(this.getTargetInstructions());
            dim.height = Math.max(dim.height, this.infoPanel.getPreferredSize().height);
            this.textPane.setText(this.getSearchInstructions());
            dim.height = Math.max(dim.height, this.infoPanel.getPreferredSize().height);
            this.textPaneSize = dim;
            this.refreshButtons();
            this.refreshInfo();
        }

        protected void refreshStrings() {
            SwingUtilities.invokeLater(() -> this.refreshStringsAsync());
        }

        protected void refreshStringsAsync() {
            if (AutoTracker.this.panelID == null) {
                return;
            }
            int n = AutoTracker.this.trackerPanel().getFrameNumber();
            FrameData frameData = AutoTracker.this.getOrCreateFrameData(n);
            KeyFrameData keyFrameData = frameData.getKeyFrameData();
            TTrack track = AutoTracker.this.getTrack();
            boolean initialized = keyFrameData != null && track != null;
            String title = TrackerRes.getString("AutoTracker.Wizard.Title");
            if (track != null) {
                int index = track.getTargetIndex();
                title = String.valueOf(title) + ": " + track.getName() + " " + track.getTargetDescription(index);
            }
            this.setTitle(title);
            this.frameLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Frame")) + " " + n + ":");
            this.searchLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Search")) + ":");
            this.stopLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Autostop")) + ":");
            this.targetLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Target")) + ":");
            this.templateLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Template")) + ":");
            this.acceptLabel.setText(TrackerRes.getString("AutoTracker.Label.Automark"));
            this.acceptLabel.setToolTipText(TrackerRes.getString("AutoTracker.Label.Automark.Tooltip"));
            this.acceptSpinner.setToolTipText(TrackerRes.getString("AutoTracker.Label.Automark.Tooltip"));
            this.trackLabel.setText(TrackerRes.getString("AutoTracker.Label.Track"));
            this.pointLabel.setText(TrackerRes.getString("AutoTracker.Label.Point"));
            this.evolveLabel.setText(TrackerRes.getString("AutoTracker.Label.EvolutionRate"));
            this.evolveLabel.setToolTipText(TrackerRes.getString("AutoTracker.Label.EvolutionRate.Tooltip"));
            this.evolveSpinner.setToolTipText(TrackerRes.getString("AutoTracker.Label.EvolutionRate.Tooltip"));
            this.tetherLabel.setText(TrackerRes.getString("AutoTracker.Label.Tether"));
            this.tetherLabel.setToolTipText(TrackerRes.getString("AutoTracker.Label.Tether.Tooltip"));
            this.tetherSpinner.setToolTipText(TrackerRes.getString("AutoTracker.Label.Tether.Tooltip"));
            this.widthLabel.setText(TrackerRes.getString("AutoTracker.Label.Width"));
            this.widthLabel.setToolTipText(TrackerRes.getString("AutoTracker.Label.Width.Tooltip"));
            this.heightLabel.setText(TrackerRes.getString("AutoTracker.Label.Height"));
            this.heightLabel.setToolTipText(TrackerRes.getString("AutoTracker.Label.Height.Tooltip"));
            this.templateShapeLabel.setText(String.valueOf(TrackerRes.getString("AutoTracker.Label.Shape")) + ":");
            this.ellipseButton.setToolTipText(TrackerRes.getString("AutoTracker.Label.Ellipse.Tooltip"));
            this.ellipseLabel.setToolTipText(TrackerRes.getString("AutoTracker.Label.Ellipse.Tooltip"));
            this.rectButton.setToolTipText(TrackerRes.getString("AutoTracker.Label.Rectangle.Tooltip"));
            this.rectLabel.setToolTipText(TrackerRes.getString("AutoTracker.Label.Rectangle.Tooltip"));
            this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
            this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
            this.copyDataButton.setText(TrackerRes.getString("AutoTracker.Wizard.Menuitem.CopyMatchScores"));
            this.copyDataButton.setToolTipText(TrackerRes.getString("AutoTracker.Wizard.MenuItem.CopyMatchScores.Tooltip"));
            this.copyDataButton.setEnabled(initialized);
            this.acceptButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.Accept"));
            this.keyFrameButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.ShowKeyFrame"));
            this.deleteButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.Delete"));
            this.oneDCheckbox.setText(TrackerRes.getString("AutoTracker.Wizard.Checkbox.XAxis"));
            this.oneDCheckbox.setToolTipText(TrackerRes.getString("AutoTracker.Wizard.Checkbox.XAxis.Tooltip"));
            this.lookAheadButton.setText(TrackerRes.getString("AutoTracker.RadioButton.LookAhead"));
            this.lookAheadButton.setToolTipText(TrackerRes.getString("AutoTracker.Wizard.Checkbox.LookAhead.Tooltip"));
            this.followButton.setText(TrackerRes.getString("AutoTracker.RadioButton.Follow"));
            this.followButton.setToolTipText(TrackerRes.getString("AutoTracker.RadioButton.Follow.Tooltip"));
            this.fixedButton.setText(TrackerRes.getString("AutoTracker.RadioButton.Fixed"));
            this.fixedButton.setToolTipText(TrackerRes.getString("AutoTracker.RadioButton.Fixed.Tooltip"));
            this.poorMatchButton.setText(TrackerRes.getString("AutoTracker.RadioButton.PoorMatch"));
            this.poorMatchButton.setToolTipText(TrackerRes.getString("AutoTracker.RadioButton.PoorMatch.Tooltip"));
            this.noMatchButton.setText(TrackerRes.getString("AutoTracker.RadioButton.NoMatch"));
            this.noMatchButton.setToolTipText(TrackerRes.getString("AutoTracker.RadioButton.NoMatch.Tooltip"));
            this.neverStopButton.setText(TrackerRes.getString("AutoTracker.RadioButton.NeverStop"));
            this.neverStopButton.setToolTipText(TrackerRes.getString("AutoTracker.RadioButton.NeverStop.Tooltip"));
            this.matchImageLabel.setText(frameData.getMatchIcon() == null ? null : TrackerRes.getString("AutoTracker.Label.Match"));
            this.templateImageLabel.setText(keyFrameData == null ? null : TrackerRes.getString("AutoTracker.Label.Template"));
            this.evolvedImageLabel.setText(frameData.getEvolvedIcon() == null ? null : "=");
            this.keyImageLabel.setText(frameData.getEvolvedIcon() == null ? null : TrackerRes.getString("AutoTracker.Label.KeyFrame"));
            boolean running = AutoTracker.this.stepping && !AutoTracker.this.paused;
            this.startButton.setIcon(AutoTracker.this.stepping ? stopIcon : searchIcon);
            this.startButton.setText(AutoTracker.this.stepping ? TrackerRes.getString("AutoTracker.Wizard.Button.Stop") : TrackerRes.getString("AutoTracker.Wizard.Button.Search"));
            this.startButton.setToolTipText(TrackerRes.getString("AutoTracker.Wizard.Button.Search.Tooltip"));
            FontSizer.setFont(this.startButton);
            boolean back = this.searchThisButton.getName() != null;
            this.searchThisButton.setText(back ? TrackerRes.getString("AutoTracker.Wizard.Button.StepBack") : TrackerRes.getString("AutoTracker.Wizard.Button.SearchThis"));
            this.searchThisButton.setEnabled(this.searchThisButton.isEnabled() && !running);
            this.searchThisButton.setToolTipText(back ? TrackerRes.getString("VideoPlayer.Back.Hint") : TrackerRes.getString("AutoTracker.Wizard.Button.SearchThis.Tooltip"));
            this.searchNextButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.SearchNext"));
            this.searchNextButton.setToolTipText(TrackerRes.getString("AutoTracker.Wizard.Button.SearchNext.Tooltip"));
            FontRenderContext frc = OSPRuntime.frc;
            Font font = this.frameLabel.getFont();
            int w = 0;
            Rectangle2D rect = font.getStringBounds(String.valueOf(this.searchLabel.getText()) + "   ", frc);
            w = Math.max(w, (int)rect.getWidth() + 4);
            rect = font.getStringBounds(String.valueOf(this.frameLabel.getText()) + "   ", frc);
            w = Math.max(w, (int)rect.getWidth() + 4);
            rect = font.getStringBounds(String.valueOf(this.templateLabel.getText()) + "   ", frc);
            w = Math.max(w, (int)rect.getWidth() + 4);
            rect = font.getStringBounds(String.valueOf(this.targetLabel.getText()) + "   ", frc);
            w = Math.max(w, (int)rect.getWidth() + 4);
            Dimension labelSize = new Dimension(w, 20);
            this.frameLabel.setPreferredSize(labelSize);
            this.templateLabel.setPreferredSize(labelSize);
            this.searchLabel.setPreferredSize(labelSize);
            this.targetLabel.setPreferredSize(labelSize);
        }

        protected void refreshButtons() {
            SwingUtilities.invokeLater(() -> this.refreshButtonsAsync());
        }

        protected void refreshButtonsAsync() {
            boolean deleteButtonEnabled;
            int n = AutoTracker.this.trackerPanel().getFrameNumber();
            FrameData frameData = AutoTracker.this.getOrCreateFrameData(n);
            TTrack track = AutoTracker.this.getTrack();
            int code = AutoTracker.this.getStatusCode(n);
            KeyFrameData keyFrameData = frameData.getKeyFrameData();
            boolean initialized = keyFrameData != null && track != null;
            boolean notStepping = AutoTracker.this.paused || !AutoTracker.this.stepping;
            boolean stable = frameData.searched && !frameData.newTemplateExists();
            boolean canSearchThis = !stable || code == 5 || this.changed && code != 0 || frameData == keyFrameData && frameData.getMarkedPoint() == null;
            boolean lastStep = n == AutoTracker.this.trackerPanel().getPlayer().getVideoClip().getLastFrameNumber();
            this.startButton.setEnabled(initialized && !lastStep);
            this.searchThisButton.setName((String)(initialized && notStepping && canSearchThis ? null : "back"));
            this.searchThisButton.setEnabled(AutoTracker.this.trackerPanel().getStepNumber() > 0);
            this.searchNextButton.setEnabled(initialized && AutoTracker.this.canStep() && notStepping && !lastStep);
            boolean isKeyFrame = AutoTracker.this.isOnKeyFrame(n) || !initialized;
            this.ellipseButton.setEnabled(isKeyFrame);
            this.ellipseLabel.setEnabled(isKeyFrame);
            this.rectButton.setEnabled(isKeyFrame);
            this.rectLabel.setEnabled(isKeyFrame);
            if (keyFrameData != null) {
                if (keyFrameData.getMask() instanceof Ellipse2D.Double) {
                    this.ellipseButton.setSelected(true);
                } else {
                    this.rectButton.setSelected(true);
                }
            }
            this.widthSpinner.setEnabled(isKeyFrame);
            this.widthLabel.setEnabled(isKeyFrame);
            this.heightSpinner.setEnabled(isKeyFrame);
            this.heightLabel.setEnabled(isKeyFrame);
            if (this.templateImageLabel.getIcon() == null && this.matchImageLabel.getIcon() == null) {
                this.templateImageLabel.setText(TrackerRes.getString("AutoTracker.Label.NoTemplate"));
                this.matchImageLabel.setText(null);
                this.imageToolbar.setPreferredSize(this.templateToolbar.getPreferredSize());
                this.templateImageLabel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            } else {
                this.imageToolbar.setPreferredSize(null);
                this.templateImageLabel.setBorder(null);
            }
            boolean bl = deleteButtonEnabled = track != null;
            if (track != null) {
                boolean isAlwaysMarked;
                boolean bl2 = isAlwaysMarked = track.steps.isAutofill() || track.ttype == 2;
                if (isAlwaysMarked) {
                    boolean hasFrameData = false;
                    Map<Integer, FrameData> map = AutoTracker.this.getFrameNumberToFrameDataMap();
                    for (Integer i : map.keySet()) {
                        FrameData next = map.get(i);
                        if (next.trackPoint == null) continue;
                        hasFrameData = true;
                        break;
                    }
                    deleteButtonEnabled = hasFrameData || frameData == keyFrameData;
                } else {
                    deleteButtonEnabled = frameData == keyFrameData || !track.isEmpty();
                }
            }
            this.deleteButton.setEnabled(deleteButtonEnabled);
            this.keyFrameButton.setEnabled(frameData.hasKeyFrames());
            this.followupPanel.removeAll();
            if (code == 2 || code == 8) {
                this.acceptButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.Accept"));
                this.followupPanel.add(this.acceptButton);
            }
            if (code == 2 || code == 3 || code == 4 || code == 8 || code == 9) {
                this.skipButton.setText(TrackerRes.getString("AutoTracker.Wizard.Button.Skip"));
                this.followupPanel.add(this.skipButton);
            }
            this.repaint();
        }

        protected void refreshDrawingFlags() {
            if (this.mouseOverObj == this.templateToolbar || this.mouseOverObj == this.templateShapeToolbar || this.mouseOverObj == this.imageToolbar) {
                AutoTracker.this.maskVisible = true;
                AutoTracker.this.searchVisible = false;
                AutoTracker.this.targetVisible = false;
            } else if (this.mouseOverObj == this.targetToolbar) {
                AutoTracker.this.targetVisible = true;
                AutoTracker.this.maskVisible = false;
                AutoTracker.this.searchVisible = false;
            } else if (this.mouseOverObj == this.searchToolbar || this.mouseOverObj == this.stopToolbar) {
                AutoTracker.this.searchVisible = true;
                AutoTracker.this.maskVisible = false;
                AutoTracker.this.targetVisible = false;
            } else {
                AutoTracker.this.maskVisible = true;
                AutoTracker.this.targetVisible = true;
                AutoTracker.this.searchVisible = true;
            }
        }

        protected void refreshGUI() {
            TTrack track = AutoTracker.this.getTrack();
            if (track != null && this.isVisible()) {
                track.setMarkByDefault(false);
            }
            SwingUtilities.invokeLater(() -> this.refreshGUIAsync());
        }

        protected void refreshGUIAsync() {
            if (AutoTracker.this.panelID == null) {
                return;
            }
            this.refreshDropdowns();
            this.refreshButtons();
            this.refreshStrings();
            this.refreshIcons();
            this.refreshInfo();
            this.refreshDrawingFlags();
            this.pack();
            if (this.textPaneSize == null) {
                this.refreshTextPaneSize();
                this.pack();
            }
        }

        protected void refreshDropdowns() {
            Object toSelect = null;
            this.trackDropdown.setName("refresh");
            this.trackDropdown.removeAllItems();
            TTrack track = AutoTracker.this.getTrack();
            for (TTrack next : AutoTracker.this.trackerPanel().getTracksTemp()) {
                if (!next.isAutoTrackable()) continue;
                ResizableIcon icon = next.getFootprint().getIcon(21, 16);
                Object[] item = new Object[]{icon, next.getName()};
                this.trackDropdown.addItem(item);
                if (next != track) continue;
                toSelect = item;
            }
            AutoTracker.this.trackerPanel().clearTemp();
            if (track == null) {
                Object[] objectArray = new Object[2];
                objectArray[1] = "           ";
                Object[] emptyItem = objectArray;
                this.trackDropdown.insertItemAt(emptyItem, 0);
                toSelect = emptyItem;
            }
            if (toSelect != null) {
                this.trackDropdown.setSelectedItem(toSelect);
            }
            this.trackDropdown.setName(null);
            toSelect = null;
            this.pointDropdown.setName("refresh");
            this.pointDropdown.removeAllItems();
            if (track != null) {
                int target = track.getTargetIndex();
                toSelect = track.getTargetDescription(target);
                int i = 0;
                while (i < track.getStepLength()) {
                    String s = track.getTargetDescription(i);
                    if (track.isAutoTrackable(i) && s != null) {
                        this.pointDropdown.addItem(s);
                    }
                    ++i;
                }
            } else {
                this.pointDropdown.addItem("         ");
            }
            if (toSelect != null) {
                this.pointDropdown.setSelectedItem(toSelect);
            }
            this.pointDropdown.setName("");
            SwingUtilities.invokeLater(() -> this.startButton.requestFocusInWindow());
        }

        protected void refreshIcons() {
            if (this.refreshPosted) {
                return;
            }
            this.refreshPosted = true;
            SwingUtilities.invokeLater(() -> this.refreshIconsPosted());
        }

        protected void refreshIconsPosted() {
            this.refreshPosted = false;
            TTrack track = AutoTracker.this.getTrack();
            if (AutoTracker.this.getTemplateMatcher() == null || track == null) {
                this.templateImageLabel.setIcon(null);
                this.matchImageLabel.setIcon(null);
                this.evolvedImageLabel.setIcon(null);
                return;
            }
            int n = AutoTracker.this.trackerPanel().getFrameNumber();
            FrameData frameData = AutoTracker.this.getOrCreateFrameData(n);
            this.matchImageLabel.setIcon(frameData.getMatchIcon());
            Icon icon = frameData.getTemplateIcon();
            if (icon == null) {
                frameData.getTemplateToMatch();
                icon = frameData.getTemplateIcon();
            }
            this.templateImageLabel.setIcon(icon);
            icon = frameData.getEvolvedIcon();
            this.evolvedImageLabel.setIcon(icon);
            this.keyImageLabel.setIcon(icon == null ? null : frameData.getKeyFrameData().getTemplateIcon());
            this.keyImageLabel.setText(icon == null ? null : TrackerRes.getString("AutoTracker.Label.KeyFrame"));
        }

        protected void replaceIcons(KeyFrameData keyFrame) {
            SwingUtilities.invokeLater(() -> {
                TTrack track = AutoTracker.this.getTrack();
                if (AutoTracker.this.getVideo() == null || track == null) {
                    this.templateImageLabel.setIcon(null);
                    this.matchImageLabel.setIcon(null);
                    this.evolvedImageLabel.setIcon(null);
                    this.keyImageLabel.setIcon(null);
                    return;
                }
                keyFrame.setTemplateMatcher(null);
                TemplateMatcher matcher = AutoTracker.this.getTemplateMatcher();
                if (matcher != null) {
                    keyFrame.setTemplate(matcher);
                    Icon icon = keyFrame.getTemplateIcon();
                    keyFrame.setMatchIcon(icon);
                    this.matchImageLabel.setIcon(icon);
                    this.templateImageLabel.setIcon(icon);
                    this.pack();
                }
            });
        }

        protected void refreshInfo() {
            if (AutoTracker.this.getVideo() == null) {
                this.textPane.setForeground(Color.red);
                this.textPane.setText(TrackerRes.getString("AutoTracker.Info.NoVideo"));
                return;
            }
            this.textPane.setForeground(Color.blue);
            TTrack track = AutoTracker.this.getTrack();
            if (track == null) {
                this.textPane.setText(TrackerRes.getString("AutoTracker.Info.SelectTrack"));
                return;
            }
            int n = AutoTracker.this.trackerPanel().getFrameNumber();
            FrameData frameData = AutoTracker.this.getOrCreateFrameData(n);
            KeyFrameData keyFrameData = frameData.getKeyFrameData();
            if (keyFrameData == null) {
                String s = String.valueOf(TrackerRes.getString("AutoTracker.Info.GetStarted")) + " " + TrackerRes.getString("AutoTracker.Info.MouseOver.Instructions");
                this.textPane.setText(s);
                if (this.mouseOverObj == null) {
                    return;
                }
            }
            this.textPane.setForeground(Color.DARK_GRAY);
            if (this.mouseOverObj == this.templateToolbar || this.mouseOverObj == this.templateShapeToolbar || this.mouseOverObj == this.imageToolbar) {
                this.textPane.setText(this.getTemplateInstructions());
                return;
            }
            if (this.mouseOverObj == this.targetToolbar) {
                this.textPane.setText(this.getTargetInstructions());
                return;
            }
            if (this.mouseOverObj == this.searchToolbar) {
                this.textPane.setText(this.getSearchInstructions());
                return;
            }
            if (this.mouseOverObj == this.stopToolbar) {
                this.textPane.setText(this.getStopInstructions());
                return;
            }
            this.textPane.setForeground(Color.blue);
            int code = AutoTracker.this.getStatusCode(n);
            double[] peakWidthAndHeight = frameData.getMatchWidthAndHeight();
            this.textPane.setText(this.getStatusInfo(code, n, peakWidthAndHeight));
        }

        protected String getTemplateInstructions() {
            StringBuffer buf = new StringBuffer();
            buf.append(TrackerRes.getString("AutoTracker.Info.Template"));
            buf.append(" ");
            buf.append(TrackerRes.getString("AutoTracker.Info.GetStarted"));
            buf.append("\n\n");
            buf.append(TrackerRes.getString("AutoTracker.Info.Title.Settings"));
            buf.append(": ");
            buf.append(TrackerRes.getString("AutoTracker.Info.Template.Instructions1"));
            buf.append(" ");
            buf.append(TrackerRes.getString("AutoTracker.Info.Template.Instructions2"));
            buf.append("\n\n");
            buf.append(TrackerRes.getString("AutoTracker.Info.Title.Tip"));
            buf.append(": ");
            buf.append(TrackerRes.getString("AutoTracker.Info.Mask.Tip"));
            return buf.toString();
        }

        protected String getSearchInstructions() {
            StringBuffer buf = new StringBuffer();
            if (AutoTracker.this.lineSpread >= 0) {
                buf.append(TrackerRes.getString("AutoTracker.Info.SearchOnAxis"));
            } else {
                buf.append(TrackerRes.getString("AutoTracker.Info.Search"));
            }
            buf.append("\n\n");
            buf.append(TrackerRes.getString("AutoTracker.Info.Title.Settings"));
            buf.append(": ");
            buf.append(TrackerRes.getString("AutoTracker.Info.Search.Instructions"));
            buf.append("\n\n");
            buf.append(TrackerRes.getString("AutoTracker.Info.Title.Tip"));
            buf.append(": ");
            buf.append(TrackerRes.getString("AutoTracker.Info.Search.Tip"));
            return buf.toString();
        }

        protected String getTargetInstructions() {
            StringBuffer buf = new StringBuffer();
            buf.append(TrackerRes.getString("AutoTracker.Info.Target"));
            buf.append("\n\n");
            buf.append(TrackerRes.getString("AutoTracker.Info.Title.Settings"));
            buf.append(": ");
            buf.append(TrackerRes.getString("AutoTracker.Info.Target.Instructions"));
            return buf.toString();
        }

        protected String getStopInstructions() {
            StringBuffer buf = new StringBuffer();
            buf.append(TrackerRes.getString("AutoTracker.Info.Stop"));
            buf.append("\n\n");
            buf.append(TrackerRes.getString("AutoTracker.Info.Title.Settings"));
            buf.append(": ");
            buf.append(TrackerRes.getString("AutoTracker.Info.Stop.Instructions"));
            return buf.toString();
        }

        protected String getStatusInfo(int code, int n, double[] peakWidthAndHeight) {
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.Frame")) + " " + n);
            switch (code) {
                case 0: {
                    this.textPane.setForeground(Color.blue);
                    buf.append(" (");
                    buf.append(TrackerRes.getString("AutoTracker.Info.KeyFrame").toLowerCase());
                    buf.append("): ");
                    buf.append(TrackerRes.getString("AutoTracker.Info.KeyFrame.Instructions1"));
                    buf.append("\n\n");
                    buf.append(TrackerRes.getString("AutoTracker.Info.KeyFrame.Instructions2"));
                    buf.append(" ");
                    buf.append(TrackerRes.getString("AutoTracker.Info.MouseOver.Instructions"));
                    break;
                }
                case 1: {
                    this.textPane.setForeground(Color.green.darker());
                    buf.append(" (" + TrackerRes.getString("AutoTracker.Info.MatchScore"));
                    buf.append(" " + format.format(peakWidthAndHeight[1]) + "): ");
                    buf.append(TrackerRes.getString("AutoTracker.Info.Match"));
                    break;
                }
                case 2: {
                    this.textPane.setForeground(RUST);
                    buf.append(" (" + TrackerRes.getString("AutoTracker.Info.MatchScore"));
                    buf.append(" " + format.format(peakWidthAndHeight[1]) + "): ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.PossibleOnAxis")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Accept"));
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.Possible")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Accept"));
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Mark"));
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                    if (!AutoTracker.this.canStep()) break;
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Skip"));
                    break;
                }
                case 3: {
                    this.textPane.setForeground(Color.red);
                    buf.append(": ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatchOnAxis")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatch")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Mark"));
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                    if (!AutoTracker.this.canStep()) break;
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Skip"));
                    break;
                }
                case 4: {
                    this.textPane.setForeground(Color.red);
                    buf.append(": ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.OutsideXAxis")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.Outside")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Mark"));
                    if (!AutoTracker.this.canStep()) break;
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Skip"));
                    break;
                }
                case 5: {
                    this.textPane.setForeground(Color.blue);
                    buf.append(": ");
                    buf.append(TrackerRes.getString("AutoTracker.Info.MarkedByUser"));
                    break;
                }
                case 6: {
                    this.textPane.setForeground(Color.green.darker());
                    buf.append(" (" + TrackerRes.getString("AutoTracker.Info.MatchScore"));
                    buf.append(" " + format.format(peakWidthAndHeight[1]) + "): ");
                    buf.append(TrackerRes.getString("AutoTracker.Info.Accepted"));
                    break;
                }
                case 7: {
                    this.textPane.setForeground(Color.blue);
                    buf.append(" (");
                    buf.append(TrackerRes.getString("AutoTracker.Info.Unsearched"));
                    buf.append("): ");
                    buf.append(TrackerRes.getString("AutoTracker.Info.Instructions"));
                    buf.append(" ");
                    buf.append(TrackerRes.getString("AutoTracker.Info.GetStarted"));
                    buf.append("\n\n");
                    buf.append(TrackerRes.getString("AutoTracker.Info.MouseOver.Instructions"));
                    break;
                }
                case 8: {
                    this.textPane.setForeground(Color.blue);
                    buf.append(" (" + TrackerRes.getString("AutoTracker.Info.MatchScore"));
                    buf.append(" " + format.format(peakWidthAndHeight[1]) + "): ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.PossibleReplace")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Replace"));
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Keep"));
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.PossibleReplace")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Replace"));
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Keep"));
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                    break;
                }
                case 9: {
                    this.textPane.setForeground(Color.red);
                    buf.append(": ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatchOnAxis")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatch")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    if (AutoTracker.this.canStep()) {
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Keep"));
                    }
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                    break;
                }
                case 10: {
                    this.textPane.setForeground(Color.red);
                    buf.append(": ");
                    if (AutoTracker.this.lineSpread >= 0) {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatchOnAxis")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.RetryOnAxis"));
                    } else {
                        buf.append(String.valueOf(TrackerRes.getString("AutoTracker.Info.NoMatch")) + "\n");
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Retry"));
                    }
                    if (AutoTracker.this.canStep()) {
                        buf.append("\n" + TrackerRes.getString("AutoTracker.Info.Keep"));
                    }
                    buf.append("\n" + TrackerRes.getString("AutoTracker.Info.NewKeyFrame"));
                }
            }
            return buf.toString();
        }

        protected String getMatchDataString() {
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(AutoTracker.this.getTrack().getName()) + "_" + ((AutoTracker)AutoTracker.this).wizard.pointDropdown.getSelectedItem());
            buf.append(XML.NEW_LINE);
            buf.append(String.valueOf(TrackerRes.getString("ThumbnailDialog.Label.FrameNumber")) + TrackerIO.getDelimiter() + TrackerRes.getString("AutoTracker.Match.Score"));
            String tar = "_" + TrackerRes.getString("AutoTracker.Label.Target").toLowerCase();
            buf.append(String.valueOf(TrackerIO.getDelimiter()) + "x" + tar + TrackerIO.getDelimiter() + "y" + tar);
            buf.append(XML.NEW_LINE);
            Map<Integer, FrameData> frameData = AutoTracker.this.getFrameNumberToFrameDataMap();
            NumberFormat scoreFormat = NumberFormat.getInstance();
            scoreFormat.setMaximumFractionDigits(1);
            scoreFormat.setMinimumFractionDigits(1);
            DecimalFormat xFormat = (DecimalFormat)NumberFormat.getInstance();
            DecimalFormat yFormat = (DecimalFormat)NumberFormat.getInstance();
            TableTrackView.TrackDataTable table = null;
            TableCellRenderer xRenderer = null;
            TableCellRenderer yRenderer = null;
            TMenuBar menubar = AutoTracker.this.frame.getMenuBar(AutoTracker.this.panelID, true);
            TreeMap<Integer, TableTrackView> dataViews = menubar.getDataViews();
            for (int key : dataViews.keySet()) {
                TableTrackView view = dataViews.get(key);
                if (view.getTrack() != AutoTracker.this.getTrack()) continue;
                table = view.getDataTable();
                String pattern = table.getFormatPattern("x");
                if (pattern == null || pattern.equals("")) {
                    xRenderer = ((JTable)table).getDefaultRenderer(Double.class);
                    if (xRenderer instanceof TableTrackView.NumberRenderer) {
                        TableTrackView.NumberRenderer xnRenderer = (TableTrackView.NumberRenderer)xRenderer;
                        xnRenderer.nf.setFixedPattern("0.00", 0.0);
                    }
                } else {
                    xFormat.applyPattern(pattern);
                }
                if ((pattern = table.getFormatPattern("y")) == null || pattern.equals("")) {
                    yRenderer = ((JTable)table).getDefaultRenderer(Double.class);
                    if (!(yRenderer instanceof TableTrackView.NumberRenderer)) break;
                    TableTrackView.NumberRenderer ynRenderer = (TableTrackView.NumberRenderer)yRenderer;
                    ynRenderer.nf.setFixedPattern("0.00", 0.0);
                    break;
                }
                yFormat.applyPattern(pattern);
                break;
            }
            for (Integer i : frameData.keySet()) {
                FrameData next = frameData.get(i);
                if (next == null || next.getMatchWidthAndHeight() == null) continue;
                double score = next.getMatchWidthAndHeight()[1];
                String value = Double.isInfinite(score) ? String.valueOf(score) : scoreFormat.format(score);
                buf.append(String.valueOf(next.getFrameNumber()) + TrackerIO.getDelimiter() + value);
                TPoint[] pts = next.getMatchPoints();
                if (pts != null) {
                    Component c;
                    TPoint p = pts[0];
                    p = AutoTracker.this.getMatchTarget(p);
                    Point2D pt = p.getWorldPosition(AutoTracker.this.trackerPanel());
                    String xval = xFormat.format(pt.getX());
                    String yval = yFormat.format(pt.getY());
                    if (xRenderer != null && (c = xRenderer.getTableCellRendererComponent(table, pt.getX(), false, false, 0, 0)) instanceof JLabel) {
                        xval = ((JLabel)c).getText().trim();
                    }
                    if (yRenderer != null && (c = yRenderer.getTableCellRendererComponent(table, pt.getY(), false, false, 0, 0)) instanceof JLabel) {
                        yval = ((JLabel)c).getText().trim();
                    }
                    buf.append(String.valueOf(TrackerIO.getDelimiter()) + xval + TrackerIO.getDelimiter() + yval);
                }
                buf.append(XML.NEW_LINE);
            }
            return buf.toString();
        }
    }
}

