/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.util.Arrays;
import java.util.Comparator;
import org.opensourcephysics.cabrillo.tracker.BounceModel;
import org.opensourcephysics.cabrillo.tracker.BounceParameters;
import org.opensourcephysics.cabrillo.tracker.Derivative;

public class BounceDerivatives
implements Derivative {
    private int window_size;
    private final int degree = 2;
    private BounceModel poly_model;
    private BounceModel step_model;

    @Override
    public Object[] evaluate(Object[] data) {
        int i;
        int[] params = (int[])data[0];
        this.window_size = 1 + params[0] * 2;
        int start = params[1];
        int index_step = params[2];
        int count = params[3];
        double[] x = (double[])data[1];
        double[] y = (double[])data[2];
        boolean[] validData = (boolean[])data[3];
        int length = x.length;
        assert (x.length == y.length);
        double[][] result = new double[4][];
        double[] xDeriv1 = new double[length];
        result[0] = xDeriv1;
        double[] yDeriv1 = new double[length];
        result[1] = yDeriv1;
        double[] xDeriv2 = new double[length];
        result[2] = xDeriv2;
        double[] yDeriv2 = new double[length];
        result[3] = yDeriv2;
        int n = 0;
        while (n < length) {
            yDeriv1[n] = Double.NaN;
            xDeriv1[n] = Double.NaN;
            yDeriv2[n] = Double.NaN;
            xDeriv2[n] = Double.NaN;
            if (!validData[n]) {
                y[n] = Double.NaN;
                x[n] = Double.NaN;
            }
            ++n;
        }
        if (start >= length) {
            return result;
        }
        count = Math.min(count, (length - start) / index_step);
        assert (start >= 0);
        assert (start < length);
        assert (index_step > 0);
        this.poly_model = new BounceModel(this.window_size, 2, 0.0);
        BounceParameters[] poly_fit = new BounceParameters[count];
        this.step_model = new BounceModel(this.window_size, 2, Double.NaN);
        BounceParameters[] step_fit = new BounceParameters[count];
        int[] c_at = new int[count];
        int c = 0;
        while (c < count) {
            int i2 = start + index_step * c;
            c_at[c] = this.window_size / 2;
            int highest_bad_index = -1;
            int in_w = this.window_size - 1;
            while (in_w >= 0) {
                int index = i2 + index_step * (in_w - c_at[c]);
                if (index < 0 || index >= length || Double.isNaN(x[index]) || Double.isNaN(y[index])) {
                    highest_bad_index = in_w;
                    break;
                }
                --in_w;
            }
            if (highest_bad_index >= 0) {
                int lowest_bad_index = this.window_size;
                int in_w2 = 0;
                while (in_w2 < this.window_size) {
                    int index = i2 + index_step * (in_w2 - c_at[c]);
                    if (index < 0 || index >= length || Double.isNaN(x[index]) || Double.isNaN(y[index])) {
                        lowest_bad_index = in_w2;
                        break;
                    }
                    ++in_w2;
                }
                int move_up = highest_bad_index + 1;
                int move_down = this.window_size - lowest_bad_index;
                int n2 = c;
                c_at[n2] = c_at[n2] - (move_up <= move_down ? move_up : 0 - move_down);
                int in_w3 = this.window_size - 1;
                while (in_w3 >= 0) {
                    int index = i2 + index_step * (in_w3 - c_at[c]);
                    if (index >= 0 && index < length && !Double.isNaN(x[index]) && !Double.isNaN(y[index])) {
                        --in_w3;
                        continue;
                    }
                    break;
                }
            } else {
                poly_fit[c] = this.poly_model.fit_xy(x, y, i2 - c_at[c] * index_step, index_step);
                step_fit[c] = this.step_model.fit_xy(x, y, i2 - c_at[c] * index_step, index_step);
            }
            ++c;
        }
        final double[] step_value = new double[count];
        int c2 = 0;
        while (c2 < count) {
            double possible_step_time;
            if (step_fit[c2] != null && (possible_step_time = step_fit[c2].getStepAt()) != 0.0) {
                i = start + index_step * c2;
                double i_step_time = (double)i + (double)index_step * (possible_step_time - (double)c_at[c2]);
                double[] step_size = step_fit[c2].getStepSize();
                int i_wind = Math.max(start, (int)(i_step_time - 0.5 * (double)(this.window_size - 1) + 0.999));
                while (i_wind <= Math.min(length - 1, (int)(i_step_time + 0.5 * (double)(this.window_size - 1) + 0.001))) {
                    int c_wind = (i_wind - start) / index_step;
                    if (c_wind < count) {
                        if (c_wind < 0 || c_wind >= count) {
                            System.out.format("ERROR: c_wind=%d, i_wind=%d, start=%d, i_step_time=%.3f\n", c_wind, i_wind, start, i_step_time);
                        }
                        if (poly_fit[c_wind] != null) {
                            double poly_err = poly_fit[c_wind].getError();
                            BounceParameters refit = this.poly_model.fit_xy(x, y, i_wind - c_at[c_wind] * index_step, index_step, (i_step_time - (double)i_wind) / (double)index_step + (double)c_at[c_wind], step_size);
                            double step_err = refit.getError();
                            int n3 = c2;
                            step_value[n3] = step_value[n3] + (poly_err - step_err);
                        }
                    }
                    ++i_wind;
                }
            }
            ++c2;
        }
        Integer[] best_step_locs = new Integer[count];
        int c3 = 0;
        while (c3 < count) {
            best_step_locs[c3] = c3;
            ++c3;
        }
        Arrays.sort(best_step_locs, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Double.compare(step_value[o2], step_value[o1]);
            }
        });
        BounceParameters[] use_model = new BounceParameters[count];
        int k = 0;
        while (k < count) {
            double possible_step_time;
            double poly_error;
            double what_is_large;
            int c4 = best_step_locs[k];
            if (use_model[c4] == null && step_fit[c4] != null && !(step_value[c4] < (what_is_large = 0.6 * (double)this.window_size) * (poly_error = poly_fit[c4].getError())) && (possible_step_time = step_fit[c4].getStepAt()) != 0.0) {
                double c_step_time = (double)c4 + possible_step_time - (double)c_at[c4];
                double[] step_size = step_fit[c4].getStepSize();
                int c_below_step = (int)c_step_time;
                int c_wind = Math.max(0, c_below_step - this.window_size + 2);
                while (c_wind < c_below_step + this.window_size && c_wind < count) {
                    int i_wind = start + index_step * c_wind;
                    if (i_wind >= start && i_wind < length && !(c_step_time <= (double)(c_wind - c_at[c_wind])) && !(c_step_time >= (double)(c_wind - c_at[c_wind] + this.window_size - 1)) && use_model[c_wind] == null && poly_fit[c_wind] != null) {
                        BounceParameters refit;
                        use_model[c_wind] = refit = this.poly_model.fit_xy(x, y, i_wind - c_at[c_wind] * index_step, index_step, c_step_time - (double)c_wind + (double)c_at[c_wind], step_size);
                    }
                    ++c_wind;
                }
            }
            ++k;
        }
        int c5 = 0;
        while (c5 < count) {
            i = start + index_step * c5;
            if (poly_fit[c5] != null) {
                BounceParameters use_this_model = use_model[c5];
                if (use_this_model == null) {
                    use_this_model = poly_fit[c5];
                }
                double[] deriv1 = use_this_model.first_deriv(c_at[c5]);
                xDeriv1[i] = deriv1[0];
                yDeriv1[i] = deriv1[1];
                double[] deriv2 = use_this_model.second_deriv(c_at[c5]);
                xDeriv2[i] = deriv2[0];
                yDeriv2[i] = deriv2[1];
            }
            ++c5;
        }
        return result;
    }
}

