/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

public class BounceMatrix {
    private double[][] A;
    private int m;
    private int n;

    public BounceMatrix(int m, int n) {
        this.m = m;
        this.n = n;
        this.A = new double[m][n];
    }

    public BounceMatrix(double[][] A) {
        this.m = A.length;
        this.n = A[0].length;
        int i = 0;
        while (i < this.m) {
            if (A[i].length != this.n) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            ++i;
        }
        this.A = A;
    }

    public BounceMatrix(double[][] A, int m, int n) {
        this.A = A;
        this.m = m;
        this.n = n;
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] C = new double[this.m][this.n];
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j];
                ++j;
            }
            ++i;
        }
        return C;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int i, int j) {
        return this.A[i][j];
    }

    public BounceMatrix getMatrix(int i0, int i1, int j0, int j1) {
        BounceMatrix X = new BounceMatrix(i1 - i0 + 1, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            int i = i0;
            while (i <= i1) {
                int j = j0;
                while (j <= j1) {
                    B[i - i0][j - j0] = this.A[i][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public BounceMatrix getMatrix(int[] r, int j0, int j1) {
        BounceMatrix X = new BounceMatrix(r.length, j1 - j0 + 1);
        double[][] B = X.getArray();
        try {
            int i = 0;
            while (i < r.length) {
                int j = j0;
                while (j <= j1) {
                    B[i][j - j0] = this.A[r[i]][j];
                    ++j;
                }
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return X;
    }

    public BounceMatrix minus(BounceMatrix B) {
        if (B.m != this.m || B.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
        BounceMatrix X = new BounceMatrix(this.m, this.n);
        double[][] C = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                C[i][j] = this.A[i][j] - B.A[i][j];
                ++j;
            }
            ++i;
        }
        return X;
    }

    public BounceMatrix times(BounceMatrix B) {
        if (B.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        BounceMatrix X = new BounceMatrix(this.m, B.n);
        double[][] C = X.getArray();
        double[] Bcolj = new double[this.n];
        int j = 0;
        while (j < B.n) {
            int k = 0;
            while (k < this.n) {
                Bcolj[k] = B.A[k][j];
                ++k;
            }
            int i = 0;
            while (i < this.m) {
                double[] Arowi = this.A[i];
                double s = 0.0;
                int k2 = 0;
                while (k2 < this.n) {
                    s += Arowi[k2] * Bcolj[k2];
                    ++k2;
                }
                C[i][j] = s;
                ++i;
            }
            ++j;
        }
        return X;
    }

    public BounceMatrix solve(BounceMatrix B) {
        return this.m == this.n ? new LUDecomposition(this).solve(B) : new QRDecomposition(this).solve(B);
    }

    public BounceMatrix inverse() {
        return this.solve(BounceMatrix.identity(this.m, this.m));
    }

    public static BounceMatrix identity(int m, int n) {
        BounceMatrix A = new BounceMatrix(m, n);
        double[][] X = A.getArray();
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                X[i][j] = i == j ? 1.0 : 0.0;
                ++j;
            }
            ++i;
        }
        return A;
    }

    static class LUDecomposition {
        private double[][] LU;
        private int m;
        private int n;
        private int pivsign;
        private int[] piv;

        public LUDecomposition(BounceMatrix A) {
            this.LU = A.getArrayCopy();
            this.m = A.getRowDimension();
            this.n = A.getColumnDimension();
            this.piv = new int[this.m];
            int i = 0;
            while (i < this.m) {
                this.piv[i] = i;
                ++i;
            }
            this.pivsign = 1;
            double[] LUcolj = new double[this.m];
            int j = 0;
            while (j < this.n) {
                int i2 = 0;
                while (i2 < this.m) {
                    LUcolj[i2] = this.LU[i2][j];
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.m) {
                    double[] LUrowi = this.LU[i2];
                    int kmax = Math.min(i2, j);
                    double s = 0.0;
                    int k = 0;
                    while (k < kmax) {
                        s += LUrowi[k] * LUcolj[k];
                        ++k;
                    }
                    int n = i2++;
                    double d = LUcolj[n] - s;
                    LUcolj[n] = d;
                    LUrowi[j] = d;
                }
                int p = j;
                int i3 = j + 1;
                while (i3 < this.m) {
                    if (Math.abs(LUcolj[i3]) > Math.abs(LUcolj[p])) {
                        p = i3;
                    }
                    ++i3;
                }
                if (p != j) {
                    int k = 0;
                    while (k < this.n) {
                        double t = this.LU[p][k];
                        this.LU[p][k] = this.LU[j][k];
                        this.LU[j][k] = t;
                        ++k;
                    }
                    k = this.piv[p];
                    this.piv[p] = this.piv[j];
                    this.piv[j] = k;
                    this.pivsign = -this.pivsign;
                }
                if (j < this.m & this.LU[j][j] != 0.0) {
                    i3 = j + 1;
                    while (i3 < this.m) {
                        double[] dArray = this.LU[i3];
                        int n = j;
                        dArray[n] = dArray[n] / this.LU[j][j];
                        ++i3;
                    }
                }
                ++j;
            }
        }

        public boolean isNonsingular() {
            int j = 0;
            while (j < this.n) {
                if (this.LU[j][j] == 0.0) {
                    return false;
                }
                ++j;
            }
            return true;
        }

        public BounceMatrix solve(BounceMatrix B) {
            int j;
            int i;
            if (B.getRowDimension() != this.m) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isNonsingular()) {
                throw new RuntimeException("Matrix is singular.");
            }
            int nx = B.getColumnDimension();
            BounceMatrix Xmat = B.getMatrix(this.piv, 0, nx - 1);
            double[][] X = Xmat.getArray();
            int k = 0;
            while (k < this.n) {
                i = k + 1;
                while (i < this.n) {
                    j = 0;
                    while (j < nx) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                        ++j;
                    }
                    ++i;
                }
                ++k;
            }
            k = this.n - 1;
            while (k >= 0) {
                int j2 = 0;
                while (j2 < nx) {
                    double[] dArray = X[k];
                    int n = j2++;
                    dArray[n] = dArray[n] / this.LU[k][k];
                }
                i = 0;
                while (i < k) {
                    j = 0;
                    while (j < nx) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] - X[k][j] * this.LU[i][k];
                        ++j;
                    }
                    ++i;
                }
                --k;
            }
            return Xmat;
        }
    }

    static class QRDecomposition {
        private double[][] QR;
        private int m;
        private int n;
        private double[] Rdiag;

        public QRDecomposition(BounceMatrix A) {
            this.QR = A.getArrayCopy();
            this.m = A.getRowDimension();
            this.n = A.getColumnDimension();
            this.Rdiag = new double[this.n];
            int k = 0;
            while (k < this.n) {
                double nrm = 0.0;
                int i = k;
                while (i < this.m) {
                    nrm = this.hypot(nrm, this.QR[i][k]);
                    ++i;
                }
                if (nrm != 0.0) {
                    if (this.QR[k][k] < 0.0) {
                        nrm = -nrm;
                    }
                    i = k;
                    while (i < this.m) {
                        double[] dArray = this.QR[i];
                        int n = k;
                        dArray[n] = dArray[n] / nrm;
                        ++i;
                    }
                    double[] dArray = this.QR[k];
                    int n = k;
                    dArray[n] = dArray[n] + 1.0;
                    int j = k + 1;
                    while (j < this.n) {
                        double s = 0.0;
                        int i2 = k;
                        while (i2 < this.m) {
                            s += this.QR[i2][k] * this.QR[i2][j];
                            ++i2;
                        }
                        s = -s / this.QR[k][k];
                        i2 = k;
                        while (i2 < this.m) {
                            double[] dArray2 = this.QR[i2];
                            int n2 = j;
                            dArray2[n2] = dArray2[n2] + s * this.QR[i2][k];
                            ++i2;
                        }
                        ++j;
                    }
                }
                this.Rdiag[k] = -nrm;
                ++k;
            }
        }

        public boolean isFullRank() {
            int j = 0;
            while (j < this.n) {
                if (this.Rdiag[j] == 0.0) {
                    return false;
                }
                ++j;
            }
            return true;
        }

        public BounceMatrix solve(BounceMatrix B) {
            int j;
            if (B.getRowDimension() != this.m) {
                throw new IllegalArgumentException("Matrix row dimensions must agree.");
            }
            if (!this.isFullRank()) {
                throw new RuntimeException("Matrix is rank deficient.");
            }
            int nx = B.getColumnDimension();
            double[][] X = B.getArrayCopy();
            int k = 0;
            while (k < this.n) {
                j = 0;
                while (j < nx) {
                    double s = 0.0;
                    int i = k;
                    while (i < this.m) {
                        s += this.QR[i][k] * X[i][j];
                        ++i;
                    }
                    s = -s / this.QR[k][k];
                    i = k;
                    while (i < this.m) {
                        double[] dArray = X[i];
                        int n = j;
                        dArray[n] = dArray[n] + s * this.QR[i][k];
                        ++i;
                    }
                    ++j;
                }
                ++k;
            }
            k = this.n - 1;
            while (k >= 0) {
                j = 0;
                while (j < nx) {
                    double[] dArray = X[k];
                    int n = j++;
                    dArray[n] = dArray[n] / this.Rdiag[k];
                }
                int i = 0;
                while (i < k) {
                    int j2 = 0;
                    while (j2 < nx) {
                        double[] dArray = X[i];
                        int n = j2;
                        dArray[n] = dArray[n] - X[k][j2] * this.QR[i][k];
                        ++j2;
                    }
                    ++i;
                }
                --k;
            }
            return new BounceMatrix(X, this.n, nx).getMatrix(0, this.n - 1, 0, nx - 1);
        }

        public double hypot(double a, double b) {
            double r;
            if (Math.abs(a) > Math.abs(b)) {
                r = b / a;
                r = Math.abs(a) * Math.sqrt(1.0 + r * r);
            } else if (b != 0.0) {
                r = a / b;
                r = Math.abs(b) * Math.sqrt(1.0 + r * r);
            } else {
                r = 0.0;
            }
            return r;
        }
    }
}

