/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import org.opensourcephysics.cabrillo.tracker.BounceMatrix;
import org.opensourcephysics.cabrillo.tracker.BounceParameters;

public class BounceModel {
    private final BounceMatrix model;
    private final BounceMatrix inverse_model;
    private final double step_at;
    private final boolean use_step;
    private final boolean use_unknown_step;
    private final int degree;
    private final int num_params;

    public BounceModel(int num_data, int deg, double when_step) {
        this.degree = deg;
        this.use_unknown_step = Double.isNaN(when_step);
        if (this.use_unknown_step) {
            this.use_step = false;
            this.step_at = (num_data + 1) / 2;
        } else {
            this.use_step = when_step > 0.0 && when_step < (double)(num_data - 1);
            double d = this.step_at = this.use_step ? when_step : 0.0;
        }
        this.num_params = this.degree + 1 + (this.use_unknown_step ? 2 : (this.use_step ? 1 : 0));
        double[][] mapping1D = new double[num_data][this.num_params];
        int t = 0;
        while (t < num_data) {
            int power = 1;
            int d = 0;
            while (d <= this.degree) {
                mapping1D[t][d] = power;
                power *= t;
                ++d;
            }
            if (this.usesStep()) {
                double d2 = mapping1D[t][this.degree + 1] = (double)t >= this.step_at ? (double)t - this.step_at : 0.0;
            }
            if (this.use_unknown_step) {
                mapping1D[t][this.degree + 2] = (double)t >= this.step_at ? 1 : 0;
            }
            ++t;
        }
        this.model = new BounceMatrix(mapping1D);
        this.inverse_model = this.model.inverse();
    }

    public double getStepAt() {
        if (this.use_unknown_step) {
            return Double.NaN;
        }
        return this.step_at;
    }

    public double getStepAt(BounceMatrix model_param) {
        if (!this.use_unknown_step) {
            return this.step_at;
        }
        double[][] param_array = model_param.getArray();
        int dimension = model_param.getColumnDimension();
        double guess_step = 0.0;
        double weight = 0.0;
        int dim = 0;
        while (dim < dimension) {
            double dv = param_array[this.degree + 1][dim];
            double x = param_array[this.degree + 2][dim];
            if (dv != 0.0) {
                guess_step += dv * x;
                weight += dv * dv;
            }
            ++dim;
        }
        if (weight > 0.0) {
            guess_step /= weight;
        }
        return this.step_at - guess_step;
    }

    public BounceParameters fit_xy(double[] xData, double[] yData, int start, int index_step) {
        int num_data = this.model.getRowDimension();
        int last_index = start + (num_data - 1) * index_step;
        if (start < 0 || last_index >= xData.length || last_index >= yData.length) {
            return null;
        }
        BounceMatrix data_matrix = new BounceMatrix(num_data, 2);
        double[][] data = data_matrix.getArray();
        int t = 0;
        while (t < num_data) {
            data[t][0] = xData[start + index_step * t];
            data[t][1] = yData[start + index_step * t];
            if (Double.isNaN(data[t][0]) || Double.isNaN(data[t][1])) {
                return null;
            }
            ++t;
        }
        BounceMatrix params = this.inverse_model.times(data_matrix);
        double[][] error_array = this.model.times(params).minus(data_matrix).getArray();
        double square_error = 0.0;
        int t2 = 0;
        while (t2 < num_data) {
            square_error += error_array[t2][0] * error_array[t2][0];
            square_error += error_array[t2][1] * error_array[t2][1];
            ++t2;
        }
        if (!this.use_unknown_step) {
            return new BounceParameters(this, params, square_error);
        }
        BounceParameters best_fit = null;
        double[][] params_array = params.getArray();
        double combined_step = 0.0;
        double weight = 0.0;
        int dim = 0;
        while (dim < 2) {
            double dv = params_array[this.degree + 1][dim];
            double extra = params_array[this.degree + 2][dim];
            if (dv != 0.0) {
                double try_step = this.step_at - extra / dv;
                if (try_step < 0.0) {
                    try_step = 0.001;
                } else if (try_step >= (double)(num_data - 1)) {
                    try_step = (double)num_data - 1.001;
                }
                BounceModel step_model = new BounceModel(num_data, this.degree, try_step);
                BounceParameters fit_step = step_model.fit_xy(xData, yData, start, index_step);
                if (best_fit == null || best_fit.getError() > fit_step.getError()) {
                    best_fit = fit_step;
                }
                combined_step += dv * dv * try_step;
                weight += dv * dv;
            }
            ++dim;
        }
        if (weight > 0.0) {
            combined_step /= weight;
        }
        BounceModel step_model = new BounceModel(num_data, this.degree, combined_step);
        BounceParameters fit_step = step_model.fit_xy(xData, yData, start, index_step);
        if (best_fit == null || best_fit.getError() > fit_step.getError()) {
            best_fit = fit_step;
        }
        return best_fit;
    }

    public BounceParameters fit_xy(double[] xData, double[] yData, int start, int index_step, double initial_step_at, double[] initial_step_size) {
        if (this.use_unknown_step || this.use_step && this.step_at != initial_step_at) {
            throw new RuntimeException("Can't fit with an initial step if the model already tries to fit a step");
        }
        int num_data = this.model.getRowDimension();
        int last_index = start + (num_data - 1) * index_step;
        if (start < 0 || last_index >= xData.length || last_index >= yData.length) {
            return null;
        }
        BounceMatrix data_matrix = new BounceMatrix(num_data, 2);
        double[][] data = data_matrix.getArray();
        int t = 0;
        while (t < num_data) {
            data[t][0] = xData[start + index_step * t] - ((double)t > initial_step_at ? initial_step_size[0] * ((double)t - initial_step_at) : 0.0);
            data[t][1] = yData[start + index_step * t] - ((double)t > initial_step_at ? initial_step_size[1] * ((double)t - initial_step_at) : 0.0);
            if (Double.isNaN(data[t][0]) || Double.isNaN(data[t][1])) {
                return null;
            }
            ++t;
        }
        BounceMatrix params = this.inverse_model.times(data_matrix);
        double[][] error_array = this.model.times(params).minus(data_matrix).getArray();
        double square_error = 0.0;
        int t2 = 0;
        while (t2 < num_data) {
            square_error += error_array[t2][0] * error_array[t2][0];
            square_error += error_array[t2][1] * error_array[t2][1];
            ++t2;
        }
        return new BounceParameters(this, params, square_error, initial_step_at, initial_step_size);
    }

    public double[] first_deriv(BounceMatrix model_param, double t) {
        int dimension = model_param.getColumnDimension();
        double[] result = new double[dimension];
        double[][] param_array = model_param.getArray();
        double power = 1.0;
        int d = 1;
        while (d <= this.degree) {
            int dim = 0;
            while (dim < dimension) {
                int n = dim;
                result[n] = result[n] + power * (double)d * param_array[d][dim];
                ++dim;
            }
            power *= t;
            ++d;
        }
        double guess_step = this.getStepAt(model_param);
        if (this.usesStep() && t >= guess_step) {
            int dim = 0;
            while (dim < dimension) {
                int n = dim;
                result[n] = result[n] + param_array[this.degree + 1][dim];
                ++dim;
            }
        }
        return result;
    }

    public double[] second_deriv(BounceMatrix model_param, double t) {
        int dimension = model_param.getColumnDimension();
        double[] result = new double[dimension];
        double[][] param_array = model_param.getArray();
        double power = 1.0;
        int d = 2;
        while (d <= this.degree) {
            int dim = 0;
            while (dim < dimension) {
                int n = dim;
                result[n] = result[n] + power * (double)d * (double)(d - 1) * param_array[d][dim];
                ++dim;
            }
            power *= t;
            ++d;
        }
        double guess_step = this.getStepAt(model_param);
        if (this.usesStep() && guess_step - 0.5 < t && t <= guess_step + 0.5) {
            int dim = 0;
            while (dim < dimension) {
                int n = dim;
                result[n] = result[n] + param_array[this.degree + 1][dim];
                ++dim;
            }
        }
        return result;
    }

    public boolean usesStep() {
        return this.use_step || this.use_unknown_step;
    }

    public double[] getStepSize(BounceMatrix model_param) {
        int dimension = model_param.getColumnDimension();
        double[] result = new double[dimension];
        if (!this.usesStep()) {
            return result;
        }
        double[][] param_array = model_param.getArray();
        int dim = 0;
        while (dim < dimension) {
            result[dim] = param_array[this.degree + 1][dim];
            ++dim;
        }
        return result;
    }
}

