/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import org.opensourcephysics.cabrillo.tracker.BounceMatrix;
import org.opensourcephysics.cabrillo.tracker.BounceModel;

public class BounceParameters {
    private final BounceModel model;
    private final BounceMatrix params;
    private final double square_error;
    private final double initial_step_at;
    private final double[] initial_step_size;

    public BounceParameters(BounceModel m, BounceMatrix p, double e) {
        this.model = m;
        this.params = p;
        this.square_error = e;
        this.initial_step_at = 0.0;
        this.initial_step_size = null;
    }

    public BounceParameters(BounceModel m, BounceMatrix p, double e, double step_at, double[] step_size) {
        this.model = m;
        this.params = p;
        this.square_error = e;
        this.initial_step_at = step_at;
        this.initial_step_size = step_size;
    }

    public final BounceModel getModel() {
        return this.model;
    }

    public final BounceMatrix getParams() {
        return this.params;
    }

    public final double getError() {
        return this.square_error;
    }

    public double getStepAt() {
        double model_stepat = this.model.getStepAt(this.params);
        if (this.initial_step_size == null) {
            return model_stepat;
        }
        if (!this.model.usesStep() || model_stepat == this.initial_step_at) {
            return this.initial_step_at;
        }
        throw new RuntimeException("LinearModelParams with steps at different times");
    }

    public double[] getStepSize() {
        int dimension = this.params.getColumnDimension();
        double[] result = new double[dimension];
        if (this.initial_step_size != null) {
            int i = 0;
            while (i < result.length) {
                result[i] = this.initial_step_size[i];
                ++i;
            }
            if (this.model.usesStep() && this.model.getStepAt() != this.initial_step_at) {
                throw new RuntimeException("LinearModelParams getStepSize with steps at different times");
            }
        }
        if (!this.model.usesStep()) {
            return result;
        }
        int step_index = this.params.getRowDimension() - 1;
        double[][] param_array = this.params.getArray();
        int dim = 0;
        while (dim < dimension) {
            int n = dim;
            result[n] = result[n] + param_array[step_index][dim];
            ++dim;
        }
        return result;
    }

    public double[] first_deriv(double t) {
        double[] result = this.model.first_deriv(this.params, t);
        if (this.initial_step_size != null && this.initial_step_at < t) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] + this.initial_step_size[i];
                ++i;
            }
        }
        return result;
    }

    public double[] second_deriv(double t) {
        double[] result = this.model.second_deriv(this.params, t);
        if (this.initial_step_size != null && Math.round(this.initial_step_at - t) == 0L) {
            int i = 0;
            while (i < result.length) {
                int n = i;
                result[n] = result[n] + this.initial_step_size[i];
                ++i;
            }
        }
        return result;
    }
}

