/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.CalibrationStep;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MarkingRequired;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.FontSizer;

public class Calibration
extends TTrack
implements MarkingRequired {
    protected static final int XY_AXES = 0;
    protected static final int X_AXIS = 1;
    protected static final int Y_AXIS = 2;
    protected static final String[] dataVariables = new String[]{"x_{1}", "y_{1}", "x_{2}", "y_{2}"};
    protected static final String[] formatVariables = new String[]{"xy"};
    protected static final Map<String, String[]> formatMap = new HashMap<String, String[]>();
    protected static final Map<String, String> formatDescriptionMap;
    protected static final ArrayList<String> allVariables;
    protected NumberField x1Field;
    protected NumberField y1Field;
    protected JLabel point1MissingLabel;
    protected JLabel point2MissingLabel;
    protected TTrack.TextLineLabel x1Label;
    protected TTrack.TextLineLabel y1Label;
    private Component[] fieldSeparators = new Component[3];
    private Component axisSeparator;
    protected JComboBox<String> axisDropdown;
    protected ActionListener axisDropdownAction;
    protected JLabel axisLabel = new JLabel();
    protected int axes = 0;
    protected boolean[] isWorldDataValid = new boolean[2];
    protected boolean fixedCoordinates = true;

    static {
        formatMap.put("xy", dataVariables);
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("CircleFitter.Description.Positions"));
        allVariables = Calibration.createAllVariables(dataVariables, null);
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getVarDimsImpl(String variable) {
        return "L";
    }

    @Override
    public String getBaseType() {
        return "Calibration";
    }

    public Calibration() {
        super(0);
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.BoldCrosshair"), PointShapeFootprint.getFootprint("Footprint.Crosshair")});
        this.setName(TrackerRes.getString("Calibration.New.Name"));
        this.setColor(this.defaultColors[0]);
        this.viewable = false;
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("Calibration.Unmarked.Hint");
        this.keyFrames.add(0);
        this.createGUI();
    }

    public void setAxisType(int axis) {
        if (axis == 1 || axis == 2 || axis == 0) {
            this.axes = axis;
        }
    }

    @Override
    public Step createStep(int n, double x, double y) {
        if (this.isLocked()) {
            return null;
        }
        boolean success = true;
        CalibrationStep step = (CalibrationStep)this.getStep(n);
        if (step == null) {
            step = new CalibrationStep(this, n, x, y);
            step.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, step);
        } else if (step.getPoints()[1] == null) {
            if (this.tp != null && this.tp.getSelectedPoint() == step.getPoints()[0]) {
                this.tp.setSelectedPoint(null);
                this.tp.selectedSteps.clear();
            }
            CalibrationStep.Position p = step.addSecondPoint(x, y);
            if (this.isFixedCoordinates()) {
                this.steps = new TTrack.StepArray(this, step);
            } else if (p != null) {
                Step[] stepArray = this.getSteps();
                int n2 = stepArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Step next = stepArray[n3];
                    if (next != null && next.getPoints()[1] == null) {
                        CalibrationStep nextStep = (CalibrationStep)next;
                        TPoint[] tPointArray = next.getPoints();
                        CalibrationStep calibrationStep = nextStep;
                        calibrationStep.getClass();
                        tPointArray[1] = new CalibrationStep.Position(calibrationStep, p.x, p.y);
                    }
                    ++n3;
                }
            }
        } else if (this.tp != null) {
            TPoint p = this.tp.getSelectedPoint();
            if (p == null) {
                p = step.getPosition(1);
            }
            if (p instanceof CalibrationStep.Position) {
                XMLControlElement state = new XMLControlElement(step);
                p.setLocation(x, y);
                Point2D pt = p.getWorldPosition(this.tp);
                success = step.points[0] == p ? step.setWorldCoordinates(pt.getX(), pt.getY(), step.worldX1, step.worldY1) : step.setWorldCoordinates(step.worldX0, step.worldY0, pt.getX(), pt.getY());
                if (success) {
                    Undo.postStepEdit(step, state);
                } else {
                    state.loadObject(step);
                }
            }
        }
        if (success) {
            this.firePropertyChange("step", null, n);
        }
        return step;
    }

    public Step createStep(int n, double x1, double y1, double x2, double y2) {
        this.createStep(n, x1, y1);
        Step step = this.createStep(n, x2, y2);
        return step;
    }

    @Override
    public TPoint autoMarkAt(int n, double x, double y) {
        CalibrationStep step = (CalibrationStep)this.getStep(n);
        int index = this.getTargetIndex();
        ImageCoordSystem coords = this.tp.getCoords();
        coords.setFixedOrigin(false);
        coords.setFixedAngle(false);
        coords.setFixedScale(false);
        if (step == null) {
            step = (CalibrationStep)this.createStep(n, x, y);
            return step == null ? null : step.getPoints()[index];
        }
        TPoint p = step.getPoints()[index];
        if (p == null) {
            if (this.tp != null && this.tp.getSelectedPoint() == step.getPoints()[0]) {
                this.tp.setSelectedPoint(null);
                this.tp.selectedSteps.clear();
            }
            p = step.addSecondPoint(x, y);
            if (this.isFixedCoordinates()) {
                this.steps = new TTrack.StepArray(this, step);
            } else if (p != null) {
                Step[] stepArray = this.getSteps();
                int n2 = stepArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Step next = stepArray[n3];
                    if (next != null && next.getPoints()[1] == null) {
                        CalibrationStep nextStep = (CalibrationStep)next;
                        TPoint[] tPointArray = next.getPoints();
                        CalibrationStep calibrationStep = nextStep;
                        calibrationStep.getClass();
                        tPointArray[1] = new CalibrationStep.Position(calibrationStep, p.x, p.y);
                    }
                    ++n3;
                }
            }
            return step.getPoints()[index];
        }
        Mark mark = (Mark)step.panelMarks.get(this.tp.getID());
        if (mark == null) {
            double worldX = index == 0 ? step.worldX0 : step.worldX1;
            double worldY = index == 0 ? step.worldY0 : step.worldY1;
            double xx = coords.worldToImageX(n, worldX, worldY);
            double yy = coords.worldToImageY(n, worldX, worldY);
            p.setLocation(xx, yy);
        }
        p.setAdjusting(true, null);
        p.setXY(x, y);
        p.setAdjusting(false, null);
        return p;
    }

    @Override
    public Step getStep(int n) {
        if (this.tp != null) {
            int frameCount = this.tp.getPlayer().getVideoClip().getFrameCount();
            if (this.getSteps().length < frameCount) {
                this.steps.setLength(frameCount);
            }
        }
        CalibrationStep step = (CalibrationStep)this.steps.getStep(n);
        this.refreshStep(step);
        return step;
    }

    @Override
    public boolean isLocked() {
        boolean locked = super.isLocked();
        if (this.tp != null) {
            locked = locked || this.tp.getCoords().isLocked();
        }
        return locked;
    }

    @Override
    public void setTrailVisible(boolean visible) {
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    public int getStepLength() {
        return CalibrationStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    public boolean isFixedCoordinates() {
        return this.fixedCoordinates;
    }

    public void setFixedCoordinates(boolean fixed) {
        if (this.fixedCoordinates == fixed) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        if (this.tp != null) {
            this.tp.changed = true;
            int n = this.tp.getFrameNumber();
            Step step = this.getStep(n);
            if (step != null) {
                this.steps = new TTrack.StepArray(this, this.getStep(n));
            }
            TFrame.repaintT(this.tp);
        }
        if (fixed) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
        }
        this.fixedCoordinates = fixed;
        Undo.postTrackEdit(this, control);
    }

    @Override
    public void setFootprint(String name) {
        super.setFootprint(name);
        this.setAxisType(this.axes);
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof TrackerPanel && this.isVisible() && this.isEnabled())) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Interactive ia = null;
        int n = trackerPanel.getFrameNumber();
        Step step = this.getStep(n);
        if (step == null) {
            this.partName = null;
            this.hint = String.valueOf(TrackerRes.getString("Calibration.Unmarked.Hint")) + " 1";
            return null;
        }
        if (trackerPanel.getPlayer().getVideoClip().includesFrame(n)) {
            ia = step.findInteractive(trackerPanel, xpix, ypix);
        }
        if (step.getPoints()[1] == null) {
            this.partName = null;
            this.hint = String.valueOf(TrackerRes.getString("Calibration.Unmarked.Hint")) + " 2";
        } else if (ia != null) {
            this.partName = TrackerRes.getString("Calibration.Point.Name");
            this.hint = TrackerRes.getString("Calibration.Point.Hint");
        } else {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = TrackerRes.getString("Calibration.Halfmarked.Hint");
        }
        return ia;
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        boolean enabled = !this.isLocked();
        this.xField.setEnabled(enabled);
        this.yField.setEnabled(enabled);
        this.x1Field.setEnabled(enabled);
        this.y1Field.setEnabled(enabled);
        if (this.axisDropdown != null) {
            this.axisDropdown.setEnabled(enabled);
        }
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.lockedItem.setEnabled(!trackerPanel.getCoords().isLocked());
        this.removeDeleteTrackItem(menu);
        final JCheckBoxMenuItem fixedCoordinatesItem = new JCheckBoxMenuItem(TrackerRes.getString("OffsetOrigin.MenuItem.Fixed"));
        FontSizer.setFont(fixedCoordinatesItem);
        fixedCoordinatesItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Calibration.this.setFixedCoordinates(fixedCoordinatesItem.isSelected());
            }
        });
        fixedCoordinatesItem.setText(TrackerRes.getString("OffsetOrigin.MenuItem.Fixed"));
        fixedCoordinatesItem.setSelected(this.isFixedCoordinates());
        menu.add(fixedCoordinatesItem);
        menu.addSeparator();
        menu.add(this.deleteTrackItem);
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        this.axisDropdown = new JComboBox();
        this.axisDropdown.setEditable(false);
        this.axisDropdown.addItem(TrackerRes.getString("Calibration.Axes.XY"));
        this.axisDropdown.addItem(TrackerRes.getString("Calibration.Axes.XOnly"));
        this.axisDropdown.addItem(TrackerRes.getString("Calibration.Axes.YOnly"));
        this.axisDropdown.setSelectedIndex(this.axes);
        this.axisDropdown.addActionListener(this.axisDropdownAction);
        FontSizer.setFonts(this.axisDropdown, FontSizer.getLevel());
        this.xLabel.setText(dataVariables[0]);
        this.yLabel.setText(dataVariables[1]);
        this.x1Label.setText(dataVariables[2]);
        this.y1Label.setText(dataVariables[3]);
        this.xField.setUnits(trackerPanel.getUnits(this, dataVariables[0]));
        this.yField.setUnits(trackerPanel.getUnits(this, dataVariables[1]));
        this.x1Field.setUnits(trackerPanel.getUnits(this, dataVariables[2]));
        this.y1Field.setUnits(trackerPanel.getUnits(this, dataVariables[3]));
        this.axisLabel.setText(TrackerRes.getString("Calibration.Label.Axes"));
        Border empty = BorderFactory.createEmptyBorder(0, 4, 0, 4);
        this.axisLabel.setBorder(empty);
        list.add(this.axisLabel);
        list.add(this.axisDropdown);
        list.add(this.axisSeparator);
        int n = trackerPanel.getFrameNumber();
        Step step = this.getStep(n);
        boolean exists = step != null;
        boolean complete = step != null && step.getPoints()[1] != null;
        String s = TrackerRes.getString("Calibration.Label.Point");
        String unmarked = TrackerRes.getString("TTrack.Label.Unmarked");
        if (!exists) {
            this.point1MissingLabel.setText(String.valueOf(s) + " 1: " + unmarked);
            this.point1MissingLabel.setForeground(Color.red.darker());
            list.add(this.point1MissingLabel);
        } else if (!complete) {
            this.point2MissingLabel.setText(String.valueOf(s) + " 2: " + unmarked);
            this.point2MissingLabel.setForeground(Color.red.darker());
        }
        if (exists) {
            this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
            VideoClip clip = trackerPanel.getPlayer().getVideoClip();
            n = clip.frameToStep(n);
            this.stepValueLabel.setText(String.valueOf(n) + ":");
            list.add(this.stepLabel);
            list.add(this.stepValueLabel);
            list.add(this.tSeparator);
        }
        if (this.axes == 2) {
            if (exists) {
                list.add(this.yLabel);
                list.add(this.yField);
                list.add(this.fieldSeparators[1]);
                if (complete) {
                    list.add(this.y1Label);
                    list.add(this.y1Field);
                } else {
                    list.add(this.point2MissingLabel);
                }
            }
        } else if (this.axes == 1) {
            if (exists) {
                list.add(this.xLabel);
                list.add(this.xField);
                list.add(this.fieldSeparators[1]);
                if (complete) {
                    list.add(this.x1Label);
                    list.add(this.x1Field);
                } else {
                    list.add(this.point2MissingLabel);
                }
            }
        } else if (exists) {
            list.add(this.xLabel);
            list.add(this.xField);
            list.add(this.fieldSeparators[0]);
            list.add(this.yLabel);
            list.add(this.yField);
            list.add(this.fieldSeparators[1]);
            if (complete) {
                list.add(this.x1Label);
                list.add(this.x1Field);
                list.add(this.fieldSeparators[2]);
                list.add(this.y1Label);
                list.add(this.y1Field);
            } else {
                list.add(this.point2MissingLabel);
            }
        }
        boolean locked = trackerPanel.getCoords().isLocked() || super.isLocked();
        this.xField.setEnabled(!locked);
        this.yField.setEnabled(!locked);
        this.x1Field.setEnabled(!locked);
        this.y1Field.setEnabled(!locked);
        this.axisDropdown.setEnabled(!locked);
        this.displayWorldCoordinates();
        return list;
    }

    protected void refreshStep(CalibrationStep step) {
        boolean different;
        if (step == null) {
            return;
        }
        int key = 0;
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i > step.n) continue;
            key = i;
        }
        CalibrationStep keyStep = (CalibrationStep)this.steps.getStep(key);
        boolean bl = different = keyStep.worldX0 != step.worldX0 || keyStep.worldY0 != step.worldY0 || keyStep.worldX1 != step.worldX1 || keyStep.worldY1 != step.worldY1;
        if (different) {
            step.worldX0 = keyStep.worldX0;
            step.worldY0 = keyStep.worldY0;
            step.worldX1 = keyStep.worldX1;
            step.worldY1 = keyStep.worldY1;
        }
        step.erase();
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        Object[] objectsToSize = new Object[]{this.point1MissingLabel, this.point2MissingLabel, this.x1Label, this.y1Label, this.x1Field, this.y1Field, this.axisLabel};
        FontSizer.setFonts(objectsToSize, level);
    }

    @Override
    public String toString() {
        return TrackerRes.getString("Calibration.Name");
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        this.numberFields.clear();
        this.numberFields.put(dataVariables[0], new NumberField[]{this.xField});
        this.numberFields.put(dataVariables[1], new NumberField[]{this.yField});
        this.numberFields.put(dataVariables[2], new NumberField[]{this.x1Field});
        this.numberFields.put(dataVariables[3], new NumberField[]{this.y1Field});
        return this.numberFields;
    }

    @Override
    public boolean isMarkByDefault() {
        return this.requiresMarking() || super.isMarkByDefault();
    }

    @Override
    public boolean requiresMarking() {
        Step step = this.getStep(0);
        return step == null || step.getPoints()[1] == null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "stepnumber": {
                if (this.tp.getSelectedTrack() != this) break;
                this.displayWorldCoordinates();
                this.stepValueLabel.setText(e.getNewValue() + ":");
                break;
            }
            case "locked": {
                boolean enabled = !this.isLocked();
                this.xField.setEnabled(enabled);
                this.yField.setEnabled(enabled);
                this.x1Field.setEnabled(enabled);
                this.y1Field.setEnabled(enabled);
                this.axisDropdown.setEnabled(enabled);
                break;
            }
            default: {
                super.propertyChange(e);
            }
        }
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("locked", this);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("locked", this);
        }
    }

    @Override
    protected int getTargetIndex() {
        return super.getTargetIndex();
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        String s = TrackerRes.getString("Calibration.Point.Name");
        int n = this.tp.getFrameNumber();
        CalibrationStep step = (CalibrationStep)this.getStep(n);
        if (step == null && pointIndex == 1) {
            return null;
        }
        return String.valueOf(s) + " " + (pointIndex + 1);
    }

    private void setWorldCoordinatesFromFields() {
        boolean different;
        if (this.tp == null) {
            return;
        }
        double x1 = this.xField.getValue();
        double y1 = this.yField.getValue();
        double x2 = this.x1Field.getValue();
        double y2 = this.y1Field.getValue();
        int n = this.tp.getFrameNumber();
        CalibrationStep step = (CalibrationStep)this.getStep(n);
        boolean bl = different = step.worldX0 != x1 || step.worldY0 != y1 || step.worldX1 != x2 || step.worldY1 != y2;
        if (different) {
            XMLControlElement trackControl = new XMLControlElement(this);
            XMLControlElement coordsControl = new XMLControlElement(this.tp.getCoords());
            boolean success = step.setWorldCoordinates(x1, y1, x2, y2);
            if (success) {
                Undo.postTrackAndCoordsEdit(this, trackControl, coordsControl);
            } else {
                this.displayWorldCoordinates();
            }
        }
    }

    protected void displayWorldCoordinates() {
        int n = this.tp == null ? 0 : this.tp.getFrameNumber();
        CalibrationStep step = (CalibrationStep)this.getStep(n);
        if (step == null) {
            this.xField.setText(null);
            this.yField.setText(null);
            this.x1Field.setText(null);
            this.y1Field.setText(null);
        } else if (step.getPoints()[1] == null) {
            this.xField.setValue(step.worldX0);
            this.yField.setValue(step.worldY0);
            this.x1Field.setText(null);
            this.y1Field.setText(null);
        } else {
            this.xField.setValue(step.worldX0);
            this.yField.setValue(step.worldY0);
            this.x1Field.setValue(step.worldX1);
            this.y1Field.setValue(step.worldY1);
        }
    }

    private void createGUI() {
        ActionListener xyAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberField field = (NumberField)e.getSource();
                if (field.getBackground().equals(Color.YELLOW)) {
                    Calibration.this.setWorldCoordinatesFromFields();
                }
                field.requestFocusInWindow();
            }
        };
        FocusAdapter xyFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NumberField field = (NumberField)e.getSource();
                if (field.getBackground().equals(Color.YELLOW)) {
                    Calibration.this.setWorldCoordinatesFromFields();
                }
            }
        };
        this.x1Label = new TTrack.TextLineLabel();
        this.y1Label = new TTrack.TextLineLabel();
        this.x1Field = new TTrack.TrackNumberField(this);
        this.x1Field.setBorder(this.fieldBorder);
        this.y1Field = new TTrack.TrackNumberField(this);
        this.y1Field.setBorder(this.fieldBorder);
        this.x1Field.addMouseListener(this.formatMouseListener);
        this.y1Field.addMouseListener(this.formatMouseListener);
        this.xField.addActionListener(xyAction);
        this.xField.addFocusListener(xyFocusListener);
        this.yField.addActionListener(xyAction);
        this.yField.addFocusListener(xyFocusListener);
        this.x1Field.addActionListener(xyAction);
        this.x1Field.addFocusListener(xyFocusListener);
        this.y1Field.addActionListener(xyAction);
        this.y1Field.addFocusListener(xyFocusListener);
        this.point1MissingLabel = new JLabel();
        this.point2MissingLabel = new JLabel();
        this.point1MissingLabel.setBorder(this.xLabel.getBorder());
        this.point2MissingLabel.setBorder(this.yLabel.getBorder());
        this.x1Label.setBorder(this.xLabel.getBorder());
        this.y1Label.setBorder(this.yLabel.getBorder());
        this.fieldSeparators[0] = Box.createRigidArea(new Dimension(4, 4));
        this.fieldSeparators[1] = Box.createRigidArea(new Dimension(8, 4));
        this.fieldSeparators[2] = Box.createRigidArea(new Dimension(4, 4));
        this.axisSeparator = Box.createRigidArea(new Dimension(8, 4));
        this.axisDropdownAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = Calibration.this.axisDropdown.getSelectedIndex();
                if (Calibration.this.axes == i) {
                    return;
                }
                if (Calibration.this.tp != null) {
                    boolean isComplete;
                    int n = Calibration.this.tp.getFrameNumber();
                    CalibrationStep step = (CalibrationStep)Calibration.this.getStep(n);
                    boolean bl = isComplete = step != null && step.getPoints()[1] != null;
                    if (isComplete && step != null) {
                        if (i == 1 && step.worldX0 == step.worldX1) {
                            JOptionPane.showMessageDialog(Calibration.this.tp, TrackerRes.getString("Calibration.Dialog.InvalidXCoordinates.Message"), TrackerRes.getString("Calibration.Dialog.InvalidCoordinates.Title"), 2);
                            Calibration.this.axisDropdown.setSelectedIndex(Calibration.this.axes);
                            return;
                        }
                        if (i == 2 && step.worldY0 == step.worldY1) {
                            JOptionPane.showMessageDialog(Calibration.this.tp, TrackerRes.getString("Calibration.Dialog.InvalidYCoordinates.Message"), TrackerRes.getString("Calibration.Dialog.InvalidCoordinates.Title"), 2);
                            Calibration.this.axisDropdown.setSelectedIndex(Calibration.this.axes);
                            return;
                        }
                    }
                }
                Calibration.this.setAxisType(i);
                if (Calibration.this.tp != null) {
                    Calibration.this.tp.refreshTrackBar();
                }
            }
        };
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            Calibration cal = (Calibration)obj;
            XML.getLoader(TTrack.class).saveObject(control, obj);
            control.setValue("fixed_coordinates", cal.isFixedCoordinates());
            if (!cal.steps.isEmpty()) {
                Step[] steps = cal.getSteps();
                double[][] stepData = new double[steps.length][];
                int i = 0;
                while (i < steps.length) {
                    if (steps[i] != null && cal.keyFrames.contains(i)) {
                        CalibrationStep step = (CalibrationStep)steps[i];
                        stepData[i] = new double[]{step.worldX0, step.worldY0, step.worldX1, step.worldY1};
                        if (!control.getPropertyNamesRaw().contains("worldX0")) {
                            control.setValue("worldX0", step.worldX0);
                            control.setValue("worldY0", step.worldY0);
                            control.setValue("worldX1", step.worldX1);
                            control.setValue("worldY1", step.worldY1);
                        }
                    }
                    ++i;
                }
                control.setValue("world_coordinates", stepData);
            }
            String type = cal.axes == 1 ? "X" : (cal.axes == 2 ? "Y" : "XY");
            control.setValue("axes", type);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new Calibration();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            double[][] stepData;
            Calibration cal = (Calibration)obj;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            boolean locked = cal.isLocked();
            cal.setLocked(false);
            String type = control.getString("axes");
            if (type != null) {
                cal.setAxisType(type.equals("X") ? 1 : (type.equals("Y") ? 2 : 0));
            }
            if (control.getPropertyNamesRaw().contains("fixed_coordinates")) {
                cal.fixedCoordinates = control.getBoolean("fixed_coordinates");
            }
            cal.keyFrames.clear();
            if (cal.steps.isEmpty()) {
                cal.createStep(0, 0.0, 0.0, 1.0, 0.0);
            }
            if ((stepData = (double[][])control.getObject("world_coordinates")) != null) {
                int i = 0;
                while (i < stepData.length) {
                    if (stepData[i] != null) {
                        CalibrationStep step = (CalibrationStep)cal.getStep(i);
                        step.worldX0 = stepData[i][0];
                        step.worldY0 = stepData[i][1];
                        step.worldX1 = stepData[i][2];
                        step.worldY1 = stepData[i][3];
                        cal.keyFrames.add(i);
                    }
                    ++i;
                }
            } else {
                CalibrationStep step = (CalibrationStep)cal.getStep(0);
                step.worldX0 = control.getDouble("worldX0");
                step.worldY0 = control.getDouble("worldY0");
                step.worldX1 = control.getDouble("worldX1");
                step.worldY1 = control.getDouble("worldY1");
                cal.keyFrames.add(0);
            }
            cal.setLocked(locked);
            cal.displayWorldCoordinates();
            return obj;
        }
    }
}

