/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class CalibrationStep
extends Step {
    private Calibration cal;
    protected double worldX0;
    protected double worldY0;
    protected double worldX1 = 1.0;
    protected double worldY1;

    public CalibrationStep(Calibration track, int n, double x, double y) {
        super(track, n);
        this.cal = track;
        this.screenPoints = new Point[CalibrationStep.getLength()];
        this.points = new TPoint[CalibrationStep.getLength()];
        Position p = new Position(x, y);
        this.points[0] = p;
    }

    public Position addSecondPoint(double x, double y) {
        Position p = new Position(x, y);
        this.points[1] = p;
        TTrack track = this.getTrack();
        if (track == null) {
            return p;
        }
        boolean success = this.setWorldCoordinates(this.worldX0, this.worldY0, this.worldX1, this.worldY1);
        if (success) {
            return p;
        }
        this.points[1] = null;
        return null;
    }

    public Position getPosition(int n) {
        return (Position)this.points[n];
    }

    @Override
    public TPoint getDefaultPoint() {
        if (this.points[1] == null) {
            return this.points[0];
        }
        if (this.cal.tp.getSelectedPoint() == this.points[0]) {
            return this.points[0];
        }
        return this.points[1];
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        TPoint selection = null;
        if (mark == null) {
            ImageCoordSystem coords = trackerPanel.getCoords();
            int n = trackerPanel.getFrameNumber();
            int i = 0;
            while (i < this.points.length) {
                Position pt = (Position)this.points[i];
                if (pt != null) {
                    double worldX = i == 0 ? this.worldX0 : this.worldX1;
                    double worldY = i == 0 ? this.worldY0 : this.worldY1;
                    double x = coords.worldToImageX(n, worldX, worldY);
                    double y = coords.worldToImageY(n, worldX, worldY);
                    pt.setLocation(x, y);
                }
                ++i;
            }
            selection = trackerPanel.getSelectedPoint();
            final MultiShape[] shapes = new MultiShape[this.points.length];
            int i2 = 0;
            while (i2 < this.points.length) {
                if (this.points[i2] != null) {
                    Point p = this.points[i2].getScreenPosition(trackerPanel);
                    if (selection == this.points[i2]) {
                        transform.setToTranslation(p.x, p.y);
                        int scale = FontSizer.getIntegerFactor();
                        if (scale > 1) {
                            transform.scale(scale, scale);
                        }
                        shapes[i2] = new MultiShape(transform.createTransformedShape(selectionShape)).andStroke(selectionStroke);
                    } else {
                        shapes[i2] = this.footprint.getShape(new Point[]{p}, FontSizer.getIntegerFactor());
                    }
                }
                ++i2;
            }
            final Color color = this.footprint.getColor();
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    Paint gpaint = g.getPaint();
                    g.setPaint(color);
                    if (OSPRuntime.setRenderingHints) {
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    int i = 0;
                    while (i < CalibrationStep.this.points.length) {
                        if (shapes[i] != null) {
                            shapes[i].draw(g);
                        }
                        ++i;
                    }
                    g.setPaint(gpaint);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
        }
        return mark;
    }

    @Override
    public Object clone() {
        CalibrationStep step = (CalibrationStep)super.clone();
        TPoint[] tPointArray = step.points;
        CalibrationStep calibrationStep = step;
        calibrationStep.getClass();
        tPointArray[0] = calibrationStep.new Position(this.points[0].x, this.points[0].y);
        if (this.points[1] != null) {
            TPoint[] tPointArray2 = step.points;
            CalibrationStep calibrationStep2 = step;
            calibrationStep2.getClass();
            tPointArray2[1] = calibrationStep2.new Position(this.points[1].x, this.points[1].y);
        }
        return step;
    }

    public boolean setWorldCoordinates(double x1, double y1, double x2, double y2) {
        boolean sameY;
        TTrack track = this.getTrack();
        if (track == null || track.isLocked()) {
            return false;
        }
        boolean sameX = x2 == x1;
        boolean bl = sameY = y2 == y1;
        if (sameX && this.cal.axes == 1 || sameY && this.cal.axes == 2 || sameX && sameY && this.cal.axes == 0) {
            JOptionPane.showMessageDialog(track.tp, TrackerRes.getString("Calibration.Dialog.InvalidCoordinates.Message"), TrackerRes.getString("Calibration.Dialog.InvalidCoordinates.Title"), 2);
            return false;
        }
        if (this.cal.isFixedCoordinates()) {
            CalibrationStep step = (CalibrationStep)this.cal.steps.getStep(0);
            step.worldX0 = x1;
            step.worldY0 = y1;
            step.worldX1 = x2;
            step.worldY1 = y2;
            step.erase();
            this.cal.refreshStep(this);
        } else {
            this.worldX0 = x1;
            this.worldY0 = y1;
            this.worldX1 = x2;
            this.worldY1 = y2;
            this.cal.keyFrames.add(this.n);
        }
        if (this.points[1] != null) {
            this.updateCoords();
        } else if (this.cal.tp != null) {
            ImageCoordSystem coords = this.cal.tp.getCoords();
            int n = this.cal.tp.getFrameNumber();
            double x0 = coords.getOriginX(n);
            double y0 = coords.getOriginY(n);
            double x = coords.worldToImageX(n, this.worldX0, this.worldY0);
            double y = coords.worldToImageY(n, this.worldX0, this.worldY0);
            coords.setOriginXY(n, x0 + this.points[0].x - x, y0 + this.points[0].y - y);
        }
        return true;
    }

    @Override
    public String toString() {
        String s = "Calibration Points Step " + this.n + " [" + format.format(this.worldX0) + ", " + format.format(this.worldY0);
        s = this.points[1] != null ? String.valueOf(s) + ", " + format.format(this.worldX1) + ", " + format.format(this.worldY1) + "]" : String.valueOf(s) + "]";
        return s;
    }

    private void updateCoords() {
        if (this.points[1] == null || this.cal.tp == null) {
            return;
        }
        if (this.cal.axes == 1) {
            this.updateCoordsXOnly();
            return;
        }
        if (this.cal.axes == 2) {
            this.updateCoordsYOnly();
            return;
        }
        ImageCoordSystem coords = this.cal.tp.getCoords();
        int n = this.cal.tp.getFrameNumber();
        double wx0 = this.worldX0;
        double wy0 = this.worldY0;
        double wx1 = this.worldX1;
        double wy1 = this.worldY1;
        double x0 = this.points[0].getX();
        double y0 = this.points[0].getY();
        double id = this.points[0].distance(this.points[1]);
        double itheta = this.points[0].angle(this.points[1]);
        double dwx = wx1 - wx0;
        double dwy = wy1 - wy0;
        double wd = Math.sqrt(dwx * dwx + dwy * dwy);
        double wtheta = -Math.atan2(dwy, dwx);
        double factor = id / wd;
        coords.setScaleXY(n, factor, factor);
        double dtheta = wtheta - itheta;
        coords.setAngle(n, dtheta);
        double xOrigin = coords.getOriginX(n);
        double yOrigin = coords.getOriginY(n);
        double dx = coords.worldToImageX(n, wx0, wy0) - x0;
        double dy = coords.worldToImageY(n, wx0, wy0) - y0;
        coords.setOriginXY(n, xOrigin - dx, yOrigin - dy);
    }

    private void updateCoordsXOnly() {
        double dxW;
        double thetaC;
        double thetaI;
        double dTheta;
        ImageCoordSystem coords = this.cal.tp.getCoords();
        int n = this.cal.tp.getFrameNumber();
        double wx0 = this.worldX0;
        double wy0 = this.worldY0;
        double wx1 = this.worldX1;
        double x0 = this.points[0].getX();
        double y0 = this.points[0].getY();
        double x1 = this.points[1].getX();
        double y1 = this.points[1].getY();
        double dI = this.points[0].distance(this.points[1]);
        double dxI = dI * Math.cos(dTheta = (thetaI = -this.points[0].angle(this.points[1])) - (thetaC = coords.getAngle(n)));
        double factor = dxI / (dxW = wx1 - wx0);
        if (factor > 0.0) {
            coords.setScaleXY(n, factor, factor);
        } else {
            coords.setScaleXY(n, -factor, -factor);
            coords.setAngle(n, thetaC + Math.PI);
        }
        double xOriginI = coords.getOriginX(n);
        double yOriginI = coords.getOriginY(n);
        double dx = coords.worldToImageX(n, wx0, wy0) - x0;
        double dy = coords.worldToImageY(n, wx0, wy0) - y0;
        double theta = thetaC + Math.atan2(dy, dx);
        double dOrigin = Math.sqrt(dx * dx + dy * dy) * Math.cos(theta);
        double dxOrigin = dOrigin * Math.cos(thetaC);
        double dyOrigin = -dOrigin * Math.sin(thetaC);
        coords.setOriginXY(n, xOriginI - dxOrigin, yOriginI - dyOrigin);
        this.worldY0 = coords.imageToWorldY(n, x0, y0);
        this.worldY1 = coords.imageToWorldY(n, x1, y1);
    }

    private void updateCoordsYOnly() {
        double dyW;
        double thetaC;
        double thetaI;
        double dTheta;
        ImageCoordSystem coords = this.cal.tp.getCoords();
        int n = this.cal.tp.getFrameNumber();
        double wx0 = this.worldX0;
        double wy0 = this.worldY0;
        double wy1 = this.worldY1;
        double x0 = this.points[0].getX();
        double y0 = this.points[0].getY();
        double x1 = this.points[1].getX();
        double y1 = this.points[1].getY();
        double dI = this.points[0].distance(this.points[1]);
        double dyI = dI * Math.sin(dTheta = (thetaI = -this.points[0].angle(this.points[1])) - (thetaC = coords.getAngle(n)));
        double factor = dyI / (dyW = wy1 - wy0);
        if (factor > 0.0) {
            coords.setScaleXY(n, factor, factor);
        } else {
            coords.setScaleXY(n, -factor, -factor);
            coords.setAngle(n, thetaC + Math.PI);
        }
        double xOriginI = coords.getOriginX(n);
        double yOriginI = coords.getOriginY(n);
        double dx = coords.worldToImageX(n, wx0, wy0) - x0;
        double dy = coords.worldToImageY(n, wx0, wy0) - y0;
        double theta = thetaC + Math.atan2(dy, dx);
        double dOrigin = Math.sqrt(dx * dx + dy * dy) * Math.sin(theta);
        double dxOrigin = dOrigin * Math.sin(thetaC);
        double dyOrigin = dOrigin * Math.cos(thetaC);
        coords.setOriginXY(n, xOriginI - dxOrigin, yOriginI - dyOrigin);
        this.worldX0 = coords.imageToWorldX(n, x0, y0);
        this.worldX1 = coords.imageToWorldX(n, x1, y1);
    }

    public static int getLength() {
        return 2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            CalibrationStep step = (CalibrationStep)obj;
            double[] data = new double[]{step.worldX0, step.worldY0, step.worldX1, step.worldY1};
            control.setValue("world_coordinates", data);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            CalibrationStep step = (CalibrationStep)obj;
            double[] data = (double[])control.getObject("world_coordinates");
            if (data != null) {
                step.worldX0 = data[0];
                step.worldY0 = data[1];
                step.worldX1 = data[2];
                step.worldY1 = data[3];
            }
            if (step.cal != null) {
                step.cal.displayWorldCoordinates();
            }
            return obj;
        }
    }

    public class Position
    extends TPoint {
        public Position(double x, double y) {
            super.setXY(x, y);
            this.setCoordsEditTrigger(true);
            if (((CalibrationStep)CalibrationStep.this).cal.tp != null) {
                ImageCoordSystem coords = ((CalibrationStep)CalibrationStep.this).cal.tp.getCoords();
                int n = ((CalibrationStep)CalibrationStep.this).cal.tp.getFrameNumber();
                if (CalibrationStep.this.points[0] == null) {
                    CalibrationStep.this.worldX0 = coords.imageToWorldX(n, x, y);
                    CalibrationStep.this.worldY0 = coords.imageToWorldY(n, x, y);
                } else {
                    CalibrationStep.this.worldX1 = coords.imageToWorldX(n, x, y);
                    CalibrationStep.this.worldY1 = coords.imageToWorldY(n, x, y);
                }
            }
        }

        @Override
        public void setXY(double x, double y) {
            int i;
            if (CalibrationStep.this.getTrack().isLocked()) {
                return;
            }
            int n = i = this == CalibrationStep.this.points[0] ? 1 : 0;
            if (CalibrationStep.this.points[i] != null && CalibrationStep.this.points[i].getX() == x && CalibrationStep.this.points[i].getY() == y) {
                Toolkit.getDefaultToolkit().beep();
                OSPLog.finer("calibration points cannot be identical");
                return;
            }
            if (this.isAdjusting()) {
                this.prevX = x;
                this.prevY = y;
            }
            double dx = x - this.getX();
            double dy = y - this.getY();
            super.setXY(x, y);
            ImageCoordSystem coords = ((CalibrationStep)CalibrationStep.this).cal.tp.getCoords();
            coords.setAdjusting(this.isAdjusting());
            if (CalibrationStep.this.points[1] != null) {
                CalibrationStep.this.updateCoords();
            } else if (((CalibrationStep)CalibrationStep.this).cal.tp != null) {
                int n2 = ((CalibrationStep)CalibrationStep.this).cal.tp.getFrameNumber();
                double x0 = coords.getOriginX(n2);
                double y0 = coords.getOriginY(n2);
                if (((CalibrationStep)CalibrationStep.this).cal.axes == 0) {
                    coords.setOriginXY(n2, x0 + dx, y0 + dy);
                } else if (((CalibrationStep)CalibrationStep.this).cal.axes == 1) {
                    coords.setOriginXY(n2, x0 + dx, y0);
                } else {
                    coords.setOriginXY(n2, x0, y0 + dy);
                }
            }
            if (this.isAdjusting()) {
                CalibrationStep.this.repaint();
            }
        }

        @Override
        public void showCoordinates(VideoPanel vidPanel) {
            if (this == CalibrationStep.this.points[0]) {
                ((CalibrationStep)CalibrationStep.this).cal.xField.setValue(CalibrationStep.this.worldX0);
                ((CalibrationStep)CalibrationStep.this).cal.yField.setValue(CalibrationStep.this.worldY0);
            } else {
                ((CalibrationStep)CalibrationStep.this).cal.x1Field.setValue(CalibrationStep.this.worldX1);
                ((CalibrationStep)CalibrationStep.this).cal.y1Field.setValue(CalibrationStep.this.worldY1);
            }
            super.showCoordinates(vidPanel);
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            boolean wasAdjusting = this.isAdjusting();
            super.setAdjusting(adjusting, e);
            if (wasAdjusting && !adjusting && !Double.isNaN(this.prevX)) {
                this.setXY(this.prevX, this.prevY);
                CalibrationStep.this.getTrack().firePropertyChange("step", null, CalibrationStep.this.n);
            }
        }
    }
}

