/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.cabrillo.tracker.CenterOfMassInspector;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;

public class CenterOfMass
extends PointMass {
    protected PointMass[] masses;
    private ArrayList<String> massNames = new ArrayList();
    protected JMenuItem inspectorItem;
    protected CenterOfMassInspector inspector;

    public CenterOfMass() {
        this(new PointMass[0]);
    }

    public CenterOfMass(PointMass[] masses) {
        this.defaultColors = new Color[]{new Color(51, 204, 51)};
        this.massField.setMinValue(0.0);
        this.setName(TrackerRes.getString("CenterOfMass.New.Name"));
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.Spot"), PointShapeFootprint.getFootprint("Footprint.SolidDiamond"), PointShapeFootprint.getFootprint("Footprint.SolidTriangle"), PointShapeFootprint.getFootprint("Footprint.SolidCircle"), PointShapeFootprint.getFootprint("Footprint.BoldVerticalLine"), PointShapeFootprint.getFootprint("Footprint.BoldHorizontalLine"), PointShapeFootprint.getFootprint("Footprint.BoldPositionVector")});
        this.defaultFootprint = this.getFootprint();
        this.masses = masses;
        this.setColor(this.defaultColors[0]);
        int i = 0;
        while (i < masses.length) {
            masses[i].addPropertyChangeListener("mass", this);
            masses[i].addStepListener(this);
            ++i;
        }
        this.locked = true;
        if (masses.length == 0) {
            this.hint = TrackerRes.getString("CenterOfMass.Empty.Hint");
        }
        this.update();
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        if (!this.initialized && panel instanceof TrackerPanel) {
            this.initialize((TrackerPanel)panel);
        }
        super.draw(panel, _g);
    }

    @Override
    public void initialize(TrackerPanel panel) {
        if (this.initialized) {
            return;
        }
        panel = panel.getMainPanel();
        boolean isChanged = panel.changed;
        ArrayList<PointMass> masses = panel.getDrawablesTemp(PointMass.class);
        int i = 0;
        int n = this.massNames.size();
        while (i < n) {
            String name = this.massNames.get(i);
            int m = 0;
            int nm = masses.size();
            while (m < nm) {
                PointMass mass = masses.get(m);
                if (mass.getName().equals(name)) {
                    this.addMass(mass);
                }
                ++m;
            }
            ++i;
        }
        masses.clear();
        this.massNames.clear();
        panel.changed = isChanged;
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMass(PointMass m) {
        PointMass[] pointMassArray = this.masses;
        synchronized (this.masses) {
            int i = 0;
            while (i < this.masses.length) {
                if (this.masses[i] == m) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            PointMass[] newMasses = new PointMass[this.masses.length + 1];
            System.arraycopy(this.masses, 0, newMasses, 0, this.masses.length);
            newMasses[this.masses.length] = m;
            this.masses = newMasses;
            m.addPropertyChangeListener("mass", this);
            m.addStepListener(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.update();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMass(PointMass m) {
        PointMass[] pointMassArray = this.masses;
        synchronized (this.masses) {
            int i = 0;
            while (i < this.masses.length) {
                if (this.masses[i] == m) {
                    m.removePropertyChangeListener("mass", this);
                    m.removeStepListener(this);
                    PointMass[] newMasses = new PointMass[this.masses.length - 1];
                    System.arraycopy(this.masses, 0, newMasses, 0, i);
                    System.arraycopy(this.masses, i + 1, newMasses, i, newMasses.length - i);
                    this.masses = newMasses;
                    break;
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.update();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointMass[] getMasses() {
        PointMass[] pointMassArray = this.masses;
        synchronized (this.masses) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (PointMass[])this.masses.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsMass(PointMass m) {
        PointMass[] pointMassArray = this.masses;
        synchronized (this.masses) {
            int i = 0;
            while (true) {
                if (i >= this.masses.length) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                if (this.masses[i] == m) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                ++i;
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Interactive ia = super.findInteractive(panel, xpix, ypix);
        this.hint = ia instanceof PositionStep.Position ? TrackerRes.getString("PointMass.Position.Locked.Hint") : (this.masses.length == 0 ? TrackerRes.getString("CenterOfMass.Empty.Hint") : null);
        return ia;
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        if (this.inspector != null && this.inspector.isVisible()) {
            this.inspector.setVisible(true);
        }
    }

    @Override
    public void setLocked(boolean locked) {
    }

    @Override
    public void setMass(double mass) {
    }

    @Override
    public boolean isStepComplete(int n) {
        return true;
    }

    @Override
    public boolean isDependent() {
        return true;
    }

    @Override
    protected boolean isAutoTrackable() {
        return false;
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("track", this);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("track", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "track": {
                if (e.getOldValue() == null) break;
                TTrack track = (TTrack)e.getOldValue();
                if (track.ttype != 5) break;
                this.removeMass((PointMass)track);
                break;
            }
            default: {
                if (!(e.getSource() instanceof PointMass)) break;
                switch (e.getPropertyName()) {
                    case "mass": {
                        this.update();
                        break;
                    }
                    case "step": {
                        int n = (Integer)e.getNewValue();
                        this.update(n, true);
                        break;
                    }
                    case "steps": {
                        this.update();
                    }
                }
                return;
            }
        }
        super.propertyChange(e);
    }

    @Override
    public void dispose() {
        super.dispose();
        int i = 0;
        int n = this.masses.length;
        while (i < n) {
            PointMass m = this.masses[i];
            if (m != null) {
                m.removePropertyChangeListener("mass", this);
                m.removeStepListener(this);
            }
            ++i;
        }
        this.masses = new PointMass[0];
        if (this.inspector != null) {
            this.inspector.dispose();
        }
    }

    private void update() {
        this.mass = 0.0;
        int length = this.getSteps().length;
        int i = 0;
        while (i < this.masses.length) {
            this.mass += this.masses[i].getMass();
            length = Math.max(length, this.masses[i].getSteps().length);
            ++i;
        }
        int n = 0;
        while (n < length) {
            this.update(n, false);
            ++n;
        }
        this.updateDerivatives();
        this.fireStepsChanged();
        if (this.inspector != null && this.inspector.isVisible()) {
            this.inspector.updateDisplay();
        }
        this.repaint();
    }

    private void update(int n, boolean firePropertyChange) {
        if (this.mass == 0.0) {
            if (firePropertyChange) {
                this.locked = false;
                this.deleteStep(n);
            } else {
                this.steps.setStep(n, null);
            }
            this.locked = true;
            return;
        }
        double x = 0.0;
        double y = 0.0;
        int i = 0;
        while (i < this.masses.length) {
            PositionStep step = (PositionStep)this.masses[i].getStep(n);
            if (step == null || !step.valid) {
                if (this.getStep(n) != null) {
                    if (firePropertyChange) {
                        this.locked = false;
                        Step deletedStep = this.deleteStep(n);
                        this.repaintStep(deletedStep);
                    } else {
                        this.steps.setStep(n, null);
                    }
                    this.locked = true;
                }
                return;
            }
            double m = this.masses[i].getMass();
            x += m * step.getPosition().getX();
            y += m * step.getPosition().getY();
            ++i;
        }
        x /= this.mass;
        y /= this.mass;
        PositionStep cmStep = (PositionStep)this.getStep(n);
        if (cmStep == null) {
            if (firePropertyChange) {
                this.locked = false;
                cmStep = (PositionStep)this.createStep(n, x, y);
                this.repaintStep(cmStep);
            } else {
                cmStep = new PositionStep(this, n, x, y);
                this.steps.setStep(n, cmStep);
                cmStep.setFootprint(this.getFootprint());
            }
        } else if (firePropertyChange) {
            this.locked = false;
            cmStep.getPosition().setXY(x, y);
        } else {
            this.points[0].setLocation(x, y);
            cmStep.getPosition().setPosition(this.points[0]);
        }
        this.locked = true;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        this.inspectorItem = new JMenuItem(TrackerRes.getString("CenterOfMass.MenuItem.Inspector"));
        this.inspectorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CenterOfMassInspector inspector = CenterOfMass.this.getInspector();
                inspector.updateDisplay();
                inspector.setVisible(true);
            }
        });
        return this.assembleMenu(super.getMenu(trackerPanel, menu0), this.inspectorItem);
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        this.massField.setEnabled(false);
        return list;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint point) {
        ArrayList<Component> list = super.getToolbarPointComponents(trackerPanel, point);
        this.xField.setEnabled(false);
        this.yField.setEnabled(false);
        return list;
    }

    @Override
    public String toString() {
        return TrackerRes.getString("CenterOfMass.Name");
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public CenterOfMassInspector getInspector() {
        if (this.inspector == null) {
            this.inspector = new CenterOfMassInspector(this);
            this.inspector.setLocation(200, 200);
        }
        return this.inspector;
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            CenterOfMass cm = (CenterOfMass)obj;
            ArrayList<String> list = new ArrayList<String>();
            PointMass[] masses = cm.getMasses();
            int i = 0;
            while (i < masses.length) {
                list.add(masses[i].getName());
                ++i;
            }
            control.setValue("masses", list);
            XML.getLoader(PointMass.class).saveObject(control, obj);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new CenterOfMass();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            CenterOfMass cm = (CenterOfMass)obj;
            XML.getLoader(PointMass.class).loadObject(control, obj);
            Collection names = (Collection)Collection.class.cast(control.getObject("masses"));
            Iterator it = names.iterator();
            while (it.hasNext()) {
                cm.massNames.add((String)it.next());
                cm.initialized = false;
            }
            return obj;
        }
    }
}

