/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class CenterOfMassInspector
extends JDialog
implements PropertyChangeListener {
    protected TFrame frame;
    protected Integer panelID;
    protected CenterOfMass cm;
    protected JButton okButton;
    protected JPanel checkboxPanel;
    protected ActionListener listener;
    protected boolean isVisible;

    public CenterOfMassInspector(CenterOfMass track) {
        super(JOptionPane.getFrameForComponent(track.tp), false);
        this.cm = track;
        this.frame = track.tp.getTFrame();
        this.panelID = track.tp.getID();
        track.tp.addPropertyChangeListener("track", this);
        if (this.frame != null) {
            this.frame.addPropertyChangeListener("tab", this);
        }
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CenterOfMassInspector.this.updateCM();
            }
        };
        this.setResizable(false);
        this.createGUI();
        this.initialize();
        this.pack();
    }

    public void initialize() {
        this.updateDisplay();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[4] lbl29 : CaseStatement: default:\u000a, @NONE, blocks:[4] lbl29 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis) {
            FontSizer.setFonts(this, FontSizer.getLevel());
            this.pack();
        }
        super.setVisible(vis);
        this.isVisible = vis;
    }

    @Override
    public void dispose() {
        this.checkboxPanel.removeAll();
        if (this.panelID != null) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            trackerPanel.removePropertyChangeListener("track", this);
            ArrayList<PointMass> masses = trackerPanel.getDrawablesTemp(PointMass.class);
            int i = 0;
            int n = masses.size();
            while (i < n) {
                masses.get(i).removeListenerNCF(this);
                ++i;
            }
            masses.clear();
            if (this.frame != null) {
                this.frame.removePropertyChangeListener("tab", this);
            }
            Object var1_1 = null;
        }
        super.dispose();
    }

    private void createGUI() {
        JPanel inspectorPanel = new JPanel(new BorderLayout());
        this.setContentPane(inspectorPanel);
        this.checkboxPanel = new JPanel(new GridLayout(0, 1));
        Border etched = BorderFactory.createEtchedBorder();
        TitledBorder title = BorderFactory.createTitledBorder(etched, TrackerRes.getString("CenterOfMassInspector.Border.Title"));
        this.checkboxPanel.setBorder(title);
        inspectorPanel.add((Component)this.checkboxPanel, "Center");
        this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CenterOfMassInspector.this.setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel(new GridLayout(1, 3));
        buttonbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        inspectorPanel.add((Component)buttonbar, "South");
        Box box = Box.createHorizontalBox();
        buttonbar.add(box);
        buttonbar.add(this.okButton);
        box = Box.createHorizontalBox();
        buttonbar.add(box);
    }

    private void updateCM() {
        Component[] checkboxes = this.checkboxPanel.getComponents();
        int i = 0;
        while (i < checkboxes.length) {
            JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)checkboxes[i];
            PointMass m = this.getPointMass(checkbox.getActionCommand());
            if (checkbox.isSelected() && !this.cm.containsMass(m)) {
                this.cm.addMass(m);
            }
            if (!checkbox.isSelected() && this.cm.containsMass(m)) {
                this.cm.removeMass(m);
            }
            ++i;
        }
        TFrame.repaintT(this.cm.tp);
    }

    private PointMass getPointMass(String name) {
        return this.frame.getTrackerPanelForID(this.panelID).getTrackByName(PointMass.class, name);
    }

    protected void updateDisplay() {
        this.setTitle(String.valueOf(TrackerRes.getString("CenterOfMassInspector.Title")) + " \"" + this.cm.getName() + "\"");
        this.checkboxPanel.removeAll();
        ArrayList<PointMass> masses = this.frame.getTrackerPanelForID(this.panelID).getDrawablesTemp(PointMass.class);
        int i = 0;
        int n = masses.size();
        while (i < n) {
            PointMass m = masses.get(i);
            m.removeListenerNCF(this);
            m.addListenerNCF(this);
            if (!(m instanceof CenterOfMass)) {
                JCheckBoxMenuItem checkbox = new JCheckBoxMenuItem(m.getName(), m.getFootprint().getIcon(21, 16));
                if (this.cm.containsMass(m)) {
                    checkbox.setSelected(true);
                }
                checkbox.addActionListener(this.listener);
                this.checkboxPanel.add(checkbox);
            }
            ++i;
        }
        masses.clear();
        FontSizer.setFonts(this.checkboxPanel, FontSizer.getLevel());
        this.pack();
        TFrame.repaintT(this);
    }
}

