/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javajs.async.AsyncDialog;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.AttachmentDialog;
import org.opensourcephysics.cabrillo.tracker.CircleFitterFootprint;
import org.opensourcephysics.cabrillo.tracker.CircleFitterStep;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class CircleFitter
extends TTrack {
    protected static final int maxDataPointCount = 50;
    protected static final String[] dataVariables;
    protected static final String[] fieldVariables;
    protected static final String[] formatVariables;
    protected static final Map<String, String[]> formatMap;
    protected static final Map<String, String> formatDescriptionMap;
    protected static final ArrayList<String> allVariables;
    protected boolean fixedPosition = true;
    protected JLabel clickToMarkLabel;
    protected JLabel xDataPointLabel;
    protected JLabel yDataPointLabel;
    protected NumberField xDataField;
    protected NumberField yDataField;
    protected Component xDataPointSeparator;
    protected Component yDataPointSeparator;
    protected JMenuItem clearPointsItem;
    protected JMenuItem setRadiusItem;
    protected JMenuItem setRadiusAllItem;
    protected JMenuItem originToCenterItem;
    protected JMenuItem originToCenterAllItem;
    protected JMenu originToCenterMenu;
    protected JMenu setRadiusMenu;
    protected JMenuItem attachmentItem;
    protected JButton pointCountButton;
    protected boolean attachToSteps = false;
    protected boolean isRelativeFrameNumbers = false;
    protected int absoluteStart = 0;
    protected int relativeStart = -2;
    protected int attachmentFrameCount = 5;
    protected TTrack[] attachmentForSteps;
    protected String stepAttachmentName;
    private boolean refreshingAttachments;
    private boolean abortRefreshAttachments;
    private boolean loadingAttachments;
    public static final String PROPERTY_CIRCLEFITTER_DATAPOINT = "dataPoint";
    private static final String[] panelEventsCircleFitter;

    static {
        String center = String.valueOf(TrackerRes.getString("CircleFitter.Data.Center")) + "}";
        String selected = String.valueOf(TrackerRes.getString("TTrack.Selected.Hint")) + "}";
        String points = TrackerRes.getString("CircleFitter.Data.PointCount");
        dataVariables = new String[]{"t", "x_{" + center, "y_{" + center, "R", "step", "frame", "x_{" + selected, "y_{" + selected, points};
        fieldVariables = new String[]{"t", "x_{" + center, "y_{" + center, "R", "x_{" + selected, "y_{" + selected};
        formatVariables = new String[]{"t", "xy", "R"};
        formatMap = new HashMap<String, String[]>();
        formatMap.put("t", new String[]{"t"});
        formatMap.put("xy", new String[]{"x_{" + center, "y_{" + center, "x_{" + selected, "y_{" + selected});
        formatMap.put("R", new String[]{"R"});
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("PointMass.Data.Description.0"));
        formatDescriptionMap.put(formatVariables[1], TrackerRes.getString("CircleFitter.Description.Positions"));
        formatDescriptionMap.put(formatVariables[2], TrackerRes.getString("CircleFitter.Label.Radius"));
        allVariables = CircleFitter.createAllVariables(dataVariables, null);
        panelEventsCircleFitter = new String[]{"transform", "startframe", "stepcount", "stepsize"};
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "CircleFitter";
    }

    @Override
    public String getVarDimsImpl(String variable) {
        String[] vars = dataVariables;
        String[] names = formatVariables;
        if (names[1].equals(variable) || names[2].equals(variable) || vars[1].equals(variable) || vars[2].equals(variable) || vars[3].equals(variable) || vars[6].equals(variable) || vars[7].equals(variable)) {
            return "L";
        }
        if (vars[4].equals(variable) || vars[5].equals(variable) || vars[8].equals(variable)) {
            return "I";
        }
        return null;
    }

    public CircleFitter() {
        super(1);
        this.defaultColors = new Color[]{new Color(0, 140, 40)};
        this.setName(TrackerRes.getString("CircleFitter.New.Name"));
        this.setFootprints(new Footprint[]{CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle4"), CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle7"), CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle4Bold"), CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle7Bold"), CircleFitterFootprint.getFootprint("CircleFitterFootprint.Circle4.PointsOnly")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.setProperty("tableVar0", "0");
        this.setProperty("tableVar1", "1");
        this.setProperty("tableVar2", "2");
        this.setProperty("xVarPlot0", dataVariables[0]);
        this.setProperty("yVarPlot0", dataVariables[3]);
        this.setProperty("xVarPlot1", dataVariables[0]);
        this.setProperty("yVarPlot1", dataVariables[1]);
        this.setProperty("xVarPlot2", dataVariables[0]);
        this.setProperty("yVarPlot2", dataVariables[2]);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("CircleFitter.Hint.Mark3");
        CircleFitterStep step = new CircleFitterStep(this, 0);
        step.setFootprint(this.getFootprint());
        this.steps = new TTrack.StepArray(this, step);
        this.keyFrames.add(0);
        this.fixedItem = new JCheckBoxMenuItem(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CircleFitter.this.setFixed(CircleFitter.this.fixedItem.isSelected());
            }
        });
        this.attachmentItem = new JMenuItem(TrackerRes.getString("MeasuringTool.MenuItem.Attach"));
        this.attachmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentDialog control = CircleFitter.this.tp.getAttachmentDialog(CircleFitter.this);
                control.setVisible(true);
            }
        });
        this.clickToMarkLabel = new JLabel();
        this.clickToMarkLabel.setForeground(Color.red.darker());
        final AbstractAction dataPointAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CircleFitter.this.tp == null) {
                    return;
                }
                if (e != null && e.getSource() == CircleFitter.this.xDataField && CircleFitter.this.xDataField.getBackground() != Color.yellow) {
                    return;
                }
                if (e != null && e.getSource() == CircleFitter.this.yDataField && CircleFitter.this.yDataField.getBackground() != Color.yellow) {
                    return;
                }
                TPoint p = CircleFitter.this.tp.getSelectedPoint();
                if (!(p instanceof CircleFitterStep.DataPoint)) {
                    return;
                }
                if (p.isAttached()) {
                    return;
                }
                double xValue = CircleFitter.this.xDataField.getValue();
                double yValue = CircleFitter.this.yDataField.getValue();
                int n = CircleFitter.this.tp.getFrameNumber();
                ImageCoordSystem coords = CircleFitter.this.tp.getCoords();
                double x = coords.worldToImageX(n, xValue, yValue);
                double y = coords.worldToImageY(n, xValue, yValue);
                p.setXY(x, y);
                p.showCoordinates(CircleFitter.this.tp);
                if (e != null && e.getSource() instanceof NumberField) {
                    ((NumberField)e.getSource()).requestFocusInWindow();
                }
            }
        };
        FocusAdapter dataFieldFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == CircleFitter.this.xDataField && CircleFitter.this.xDataField.getBackground() != Color.yellow) {
                    return;
                }
                if (e.getSource() == CircleFitter.this.yDataField && CircleFitter.this.yDataField.getBackground() != Color.yellow) {
                    return;
                }
                dataPointAction.actionPerformed(null);
            }
        };
        this.xDataPointLabel = new JLabel();
        this.xDataPointLabel.setBorder(this.tLabel.getBorder());
        this.xDataField = new NumberField(5);
        this.xDataField.setBorder(this.fieldBorder);
        this.xDataField.addActionListener(dataPointAction);
        this.xDataField.addFocusListener(dataFieldFocusListener);
        this.xDataField.addMouseListener(this.formatMouseListener);
        this.yDataPointLabel = new JLabel();
        this.yDataPointLabel.setBorder(this.tLabel.getBorder());
        this.yDataField = new NumberField(5);
        this.yDataField.setBorder(this.fieldBorder);
        this.yDataField.addActionListener(dataPointAction);
        this.yDataField.addFocusListener(dataFieldFocusListener);
        this.yDataField.addMouseListener(this.formatMouseListener);
        this.xDataPointSeparator = Box.createRigidArea(new Dimension(4, 4));
        this.yDataPointSeparator = Box.createRigidArea(new Dimension(4, 4));
        this.xLabel.setText("center x");
        this.xField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.xField.setEnabled(false);
        this.yField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.yField.setEnabled(false);
        this.magField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.magField.setEnabled(false);
        this.xDataField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.yDataField.setPatterns(new String[]{"0.000E0", "0.000", "0.00", "0.0", "0.000E0"});
        this.originToCenterMenu = new JMenu();
        this.originToCenterItem = new JMenuItem();
        this.originToCenterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircleFitter.this.setCoordsOriginToCenter(false);
            }
        });
        this.originToCenterAllItem = new JMenuItem();
        this.originToCenterAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircleFitter.this.setCoordsOriginToCenter(true);
            }
        });
        this.setRadiusMenu = new JMenu();
        this.setRadiusItem = new JMenuItem();
        this.setRadiusItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircleFitter.this.setCoordsScaleFromRadius(false);
            }
        });
        this.setRadiusAllItem = new JMenuItem();
        this.setRadiusAllItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CircleFitter.this.setCoordsScaleFromRadius(true);
            }
        });
        this.clearPointsItem = new JMenuItem();
        this.clearPointsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMLControlElement control = new XMLControlElement(CircleFitter.this);
                boolean changed = false;
                Step[] stepArray = CircleFitter.this.getSteps();
                int n = stepArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Step step = stepArray[n2];
                    CircleFitterStep next = (CircleFitterStep)step;
                    if (next.dataPoints.length != 0) {
                        changed = true;
                        next.dataPoints = new CircleFitterStep.DataPoint[2][0];
                        next.refreshCircle();
                    }
                    ++n2;
                }
                if (changed) {
                    CircleFitter.this.repaint();
                    CircleFitter.this.invalidateData(this);
                    if (CircleFitter.this.tp != null) {
                        CircleFitter.this.tp.changed = true;
                        CircleFitter.this.tp.refreshTrackBar();
                    }
                    Undo.postTrackEdit(CircleFitter.this, control);
                }
            }
        });
        this.pointCountButton = new TButton(){

            @Override
            protected JPopupMenu getPopup() {
                final TPoint selected = CircleFitter.this.tp.getSelectedPoint();
                JPopupMenu popup = new JPopupMenu();
                int n = CircleFitter.this.tp.getFrameNumber();
                CircleFitterStep step = (CircleFitterStep)CircleFitter.this.getStep(n);
                final ArrayList<CircleFitterStep.DataPoint> pts = step.getValidDataPoints();
                VideoClip clip = CircleFitter.this.tp.getPlayer().getVideoClip();
                ActionListener selector = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int i = Integer.parseInt(e.getActionCommand());
                        CircleFitterStep.DataPoint p = (CircleFitterStep.DataPoint)pts.get(i);
                        (this).CircleFitter.this.tp.setSelectedPoint(p);
                    }
                };
                final StringBuffer buf = new StringBuffer();
                buf.append(String.valueOf(step.getTrack().getName()) + "_" + CircleFitter.this.stepLabel.getText() + "_" + CircleFitter.this.tp.getStepNumber());
                buf.append(XML.NEW_LINE);
                buf.append("x" + TrackerIO.getDelimiter() + "y");
                buf.append(XML.NEW_LINE);
                int i = 0;
                while (i < pts.size()) {
                    CircleFitterStep.DataPoint p = pts.get(i);
                    Point2D worldPt = p.getWorldPosition(CircleFitter.this.tp);
                    DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
                    nf.applyPattern("0.000000E0");
                    nf.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
                    String formattedX = nf.format(worldPt.getX());
                    String formattedY = nf.format(worldPt.getY());
                    buf.append(String.valueOf(formattedX) + TrackerIO.getDelimiter() + formattedY);
                    if (i < pts.size() - 1) {
                        buf.append(XML.NEW_LINE);
                    }
                    String s = "";
                    if (i < step.dataPoints[0].length) {
                        s = TrackerRes.getString("CircleFitter.MenuItem.MarkedPoint");
                    } else if (CircleFitter.this.attachments != null) {
                        Step targetStep = p.getAttachedStep();
                        s = String.valueOf(targetStep.getTrack().getName()) + " ";
                        s = String.valueOf(s) + TrackerRes.getString("TTrack.Label.Step") + " ";
                        int frame = targetStep.getFrameNumber();
                        s = String.valueOf(s) + clip.frameToStep(frame);
                    }
                    s = String.valueOf(s) + " (" + CircleFitter.this.xDataField.format(worldPt.getX()) + ", " + CircleFitter.this.yDataField.format(worldPt.getY()) + ")";
                    JMenuItem item = new JMenuItem(s);
                    item.setActionCommand(String.valueOf(i));
                    item.addActionListener(selector);
                    final int index = i++;
                    item.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseEntered(MouseEvent e) {
                            CircleFitterStep.DataPoint p = (CircleFitterStep.DataPoint)pts.get(index);
                            (this).CircleFitter.this.tp.setSelectedPoint(p);
                        }

                        @Override
                        public void mouseExited(MouseEvent e) {
                            (this).CircleFitter.this.tp.setSelectedPoint(selected);
                        }
                    });
                    popup.add(item);
                }
                JMenuItem item = new JMenuItem(TrackerRes.getString("CircleFitter.MenuItem.CopyToClipboard.Text"));
                item.setToolTipText(TrackerRes.getString("CircleFitter.MenuItem.CopyToClipboard.Tooltip"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        StringSelection stringSelection = new StringSelection(buf.toString());
                        clipboard.setContents(stringSelection, stringSelection);
                    }
                });
                popup.addSeparator();
                popup.add(item);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                return popup;
            }
        };
        this.pointCountButton.setOpaque(false);
        Border space = BorderFactory.createEmptyBorder(1, 4, 1, 4);
        Border line = BorderFactory.createLineBorder(Color.GRAY);
        this.pointCountButton.setBorder(BorderFactory.createCompoundBorder(line, space));
    }

    public void setFixed(boolean fixed) {
        if (this.fixedPosition == fixed) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        if (this.tp != null) {
            this.tp.changed = true;
            int n = this.tp.getFrameNumber();
            CircleFitterStep source = (CircleFitterStep)this.getStep(n);
            CircleFitterStep target = (CircleFitterStep)this.getStep(0);
            target.copy(source);
            TFrame.repaintT(this.tp);
        }
        this.fixedPosition = fixed;
        if (fixed) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
            this.invalidateData(null);
            Undo.postTrackEdit(this, control);
        }
    }

    public boolean isFixed() {
        return this.fixedPosition;
    }

    public boolean isValidCircle(int frame) {
        CircleFitterStep step = (CircleFitterStep)this.getStep(frame);
        return step != null && step.isValidCircle();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean isSelectedTrack = this.tp.getSelectedTrack() == this;
        switch (e.getPropertyName()) {
            case "stepnumber": {
                if (!isSelectedTrack) break;
                this.tp.refreshTrackBar();
                break;
            }
            case "transform": {
                if (!isSelectedTrack) break;
                this.refreshFields(this.tp.getFrameNumber());
                break;
            }
            case "startframe": 
            case "step": 
            case "steps": 
            case "stepcount": 
            case "stepsize": {
                if (this.attachments == null) break;
                this.refreshAttachments();
                break;
            }
            case "adjusting": {
                this.refreshDataLater = (Boolean)e.getNewValue();
                if (this.refreshDataLater) break;
                this.firePropertyChange("data", null, null);
            }
        }
        super.propertyChange(e);
    }

    @Override
    public void setTrailVisible(boolean visible) {
    }

    @Override
    public Step createStep(int n, double x, double y) {
        CircleFitterStep step;
        if (!this.isFixed()) {
            CircleFitterStep step2;
            this.keyFrames.add(n);
            CircleFitterStep circleFitterStep = step2 = (CircleFitterStep)this.steps.getStep(n);
            circleFitterStep.getClass();
            step2.addDataPoint(new CircleFitterStep.DataPoint(circleFitterStep, x, y), true);
            return step2;
        }
        this.keyFrames.add(0);
        CircleFitterStep circleFitterStep = step = (CircleFitterStep)this.steps.getStep(0);
        circleFitterStep.getClass();
        step.addDataPoint(new CircleFitterStep.DataPoint(circleFitterStep, x, y), true);
        return this.getStep(n);
    }

    @Override
    public Step deleteStep(int n) {
        if (this.isLocked()) {
            return null;
        }
        TPoint p = this.tp.getSelectedPoint();
        if (p != null && !(p instanceof CircleFitterStep.DataPoint)) {
            return null;
        }
        CircleFitterStep.DataPoint data = (CircleFitterStep.DataPoint)p;
        CircleFitterStep step = (CircleFitterStep)this.steps.getStep(n);
        if (!this.isFixed()) {
            step.removeDataPoint(data, true, true);
        } else {
            int row = -1;
            int column = 0;
            int i = 0;
            while (i < step.dataPoints.length) {
                CircleFitterStep.DataPoint[] points = step.dataPoints[i];
                int j = 0;
                while (j < points.length) {
                    if (data == points[j]) {
                        column = i;
                        row = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (row > -1) {
                step = (CircleFitterStep)this.steps.getStep(0);
                data = step.dataPoints[column][row];
                step.removeDataPoint(data, true, true);
            }
        }
        return null;
    }

    @Override
    public Step getStep(int n) {
        CircleFitterStep step = (CircleFitterStep)this.steps.getStep(n);
        this.refreshStep(step);
        return step;
    }

    @Override
    public Step getStep(TPoint point, TrackerPanel trackerPanel) {
        Step[] stepArray;
        if (point == null) {
            return null;
        }
        Step[] stepArray2 = stepArray = this.steps.array;
        int n = stepArray.length;
        int n2 = 0;
        while (n2 < n) {
            Step step = stepArray2[n2];
            if (step != null) {
                TPoint[] points = step.getPoints();
                int i = 0;
                while (i < points.length) {
                    if (points[i] == point) {
                        return step;
                    }
                    ++i;
                }
                CircleFitterStep circleStep = (CircleFitterStep)step;
                CircleFitterStep.DataPoint[][] dataPointArray = circleStep.dataPoints;
                int n3 = circleStep.dataPoints.length;
                int n4 = 0;
                while (n4 < n3) {
                    CircleFitterStep.DataPoint[] pts;
                    CircleFitterStep.DataPoint[] dataPointArray2 = pts = dataPointArray[n4];
                    int n5 = pts.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        CircleFitterStep.DataPoint p = dataPointArray2[n6];
                        if (p == point) {
                            return step;
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int getStepLength() {
        return CircleFitterStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 3;
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        Object[] objectsToSize = new Object[]{this.clickToMarkLabel, this.xDataPointLabel, this.yDataPointLabel, this.pointCountButton, this.xDataField, this.yDataField};
        FontSizer.setFonts(objectsToSize, level);
    }

    @Override
    public void dispose() {
        Step[] steps;
        for (TTrack t : TTrack.getValues()) {
            t.removeStepListener(this);
        }
        if (this.attachmentForSteps != null) {
            int i = 0;
            while (i < this.attachmentForSteps.length) {
                this.attachmentForSteps[i] = null;
                ++i;
            }
        }
        if (this.attachments != null) {
            int i = 0;
            while (i < this.attachments.length) {
                this.attachments[i] = null;
                ++i;
            }
        }
        Step[] stepArray = steps = this.getSteps();
        int n = steps.length;
        int n2 = 0;
        while (n2 < n) {
            Step next = stepArray[n2];
            if (next != null) {
                CircleFitterStep step = (CircleFitterStep)next;
                int i = 0;
                while (i <= step.dataPoints[1].length) {
                    CircleFitterStep.DataPoint p = step.getDataPoint(1, i);
                    if (p != null) {
                        p.detach();
                    }
                    ++i;
                }
            }
            ++n2;
        }
        this.attachmentNames = null;
        this.properties.clear();
        this.datasetManager = null;
        this.setTrackerPanel(null);
    }

    public boolean isNoPoints(int frameNumber) {
        if (!this.isRelativeFrameNumbers) {
            return false;
        }
        int start = frameNumber + this.relativeStart;
        int end = frameNumber + this.relativeStart + this.attachmentFrameCount - 1;
        return end < 0 || start > this.tp.getPlayer().getVideoClip().getLastFrameNumber();
    }

    public void setAttachmentStartFrame(int n) {
        if (this.isRelativeFrameNumbers) {
            int count = this.tp.getPlayer().getVideoClip().getFrameCount();
            n = Math.max(n, 1 - count);
            this.relativeStart = n = Math.min(n, count - 1);
        } else {
            int min = this.tp.getPlayer().getVideoClip().getFirstFrameNumber();
            int max = this.tp.getPlayer().getVideoClip().getLastFrameNumber();
            n = Math.max(n, min);
            this.absoluteStart = n = Math.min(n, max);
        }
    }

    public int getAttachmentStartFrame(int frameNumber) {
        if (this.isRelativeFrameNumbers) {
            int n = Math.max(0, frameNumber + this.relativeStart);
            n = Math.min(n, this.tp.getPlayer().getVideoClip().getLastFrameNumber());
            return n;
        }
        return this.absoluteStart;
    }

    public void setAttachmentFrameCount(int n) {
        n = Math.min(n, 50);
        this.attachmentFrameCount = n = Math.max(n, 1);
    }

    public int getAttachmentFrameCount() {
        return this.attachmentFrameCount;
    }

    public int getAttachmentEndFrame(int frameNumber) {
        int n = Math.max(0, this.absoluteStart + this.attachmentFrameCount - 1);
        if (this.isRelativeFrameNumbers) {
            n = Math.max(0, frameNumber + this.relativeStart + this.attachmentFrameCount - 1);
        }
        n = Math.min(n, this.tp.getPlayer().getVideoClip().getLastFrameNumber());
        return n;
    }

    @Override
    protected int getAttachmentLength() {
        return this.attachments == null || this.attachments.length == 0 || this.attachToSteps ? 1 : this.attachments.length;
    }

    @Override
    public TTrack[] getAttachments() {
        super.getAttachments();
        if (this.attachToSteps) {
            if (this.attachmentForSteps == null) {
                this.attachmentForSteps = new TTrack[]{this.attachments[0]};
            }
            return this.attachmentForSteps;
        }
        boolean ready = true;
        int i = this.attachments.length;
        int inew = i - 1;
        while (--i >= 0) {
            if (i < inew != (this.attachments[i] == null)) continue;
            ready = false;
            break;
        }
        if (ready) {
            return this.attachments;
        }
        i = this.attachments.length;
        while (--i >= 0) {
            if (this.attachments[i] != null) continue;
            TTrack[] newAttachments = new TTrack[this.attachments.length - 1];
            System.arraycopy(this.attachments, 0, newAttachments, 0, i);
            System.arraycopy(this.attachments, i + 1, newAttachments, i, this.attachments.length - i - 1);
            this.attachments = newAttachments;
        }
        if (this.attachments.length == 0) {
            this.attachments = new TTrack[1];
        } else if (!this.attachToSteps) {
            TTrack[] newAttachments = new TTrack[this.attachments.length + 1];
            System.arraycopy(this.attachments, 0, newAttachments, 0, this.attachments.length);
            this.attachments = newAttachments;
        }
        return this.attachments;
    }

    @Override
    public String getAttachmentDescription(int n) {
        if (this.attachToSteps) {
            return this.attachmentForSteps[0] == null ? TrackerRes.getString("CircleFitter.Label.NewPoint") : TrackerRes.getString("CircleFitter.Label.Points");
        }
        return n == this.attachments.length - 1 ? TrackerRes.getString("CircleFitter.Label.NewPoint") : TrackerRes.getString("CircleFitter.Label.Point");
    }

    @Override
    protected void refreshAttachments() {
        if (this.refreshingAttachments) {
            this.abortRefreshAttachments = true;
            while (this.refreshingAttachments) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                CircleFitter.this.refreshAttachmentsAync();
            }
        };
        new Thread(runner).start();
    }

    protected void refreshAttachmentsAync() {
        int n;
        this.abortRefreshAttachments = false;
        this.refreshingAttachments = true;
        TTrack[] attachments = this.getAttachments();
        boolean hasAttachments = false;
        int i = 0;
        while (i < attachments.length) {
            if (attachments[i] != null) {
                hasAttachments = true;
                attachments[i].removeStepListener(this);
                attachments[i].addStepListener(this);
            }
            ++i;
        }
        if (hasAttachments) {
            boolean change = this.tp.changed;
            this.setFixed(false);
            this.tp.changed = change;
        }
        VideoClip clip = this.tp.getPlayer().getVideoClip();
        CircleFitterStep.doRefresh = false;
        TreeSet<Integer> framesToRefresh = new TreeSet<Integer>();
        if (!this.attachToSteps) {
            int n2 = clip.getStartFrameNumber();
            while (n2 <= clip.getEndFrameNumber()) {
                if (this.abortRefreshAttachments) {
                    this.refreshingAttachments = false;
                    return;
                }
                CircleFitterStep step = (CircleFitterStep)this.steps.getStep(n2);
                if (step.trimAttachedPointsToLength(attachments.length - 1)) {
                    framesToRefresh.add(n2);
                }
                ++n2;
            }
            int i2 = 0;
            while (i2 < attachments.length) {
                TTrack targetTrack = attachments[i2];
                if (targetTrack != null) {
                    n = clip.getStartFrameNumber();
                    while (n <= clip.getEndFrameNumber()) {
                        if (this.abortRefreshAttachments) {
                            this.refreshingAttachments = false;
                            return;
                        }
                        Step targetStep = targetTrack.getStep(n);
                        CircleFitterStep step = (CircleFitterStep)this.steps.getStep(n);
                        CircleFitterStep.DataPoint p = step.getDataPoint(1, i2);
                        if (targetStep == null) {
                            if (p != null) {
                                p.detach();
                                p = null;
                                step.setDataPoint(null, 1, i2, false, false);
                                framesToRefresh.add(n);
                            }
                        } else {
                            TPoint target = targetStep.getPoints()[0];
                            if (p == null) {
                                CircleFitterStep circleFitterStep = step;
                                circleFitterStep.getClass();
                                p = new CircleFitterStep.DataPoint(circleFitterStep, target.x, target.y);
                                step.setDataPoint(p, 1, i2, false, false);
                            }
                            if (p.attachTo(target)) {
                                framesToRefresh.add(n);
                            }
                        }
                        ++n;
                    }
                } else {
                    n = clip.getStartFrameNumber();
                    while (n <= clip.getEndFrameNumber()) {
                        if (this.abortRefreshAttachments) {
                            this.refreshingAttachments = false;
                            return;
                        }
                        CircleFitterStep step = (CircleFitterStep)this.steps.getStep(n);
                        CircleFitterStep.DataPoint p = step.getDataPoint(1, i2);
                        if (p != null) {
                            p.detach();
                            step.setDataPoint(null, 1, i2, false, true);
                            framesToRefresh.add(n);
                        }
                        ++n;
                    }
                }
                ++i2;
            }
        } else {
            TTrack targetTrack = attachments[0];
            if (targetTrack != null) {
                int stepCount = this.isRelativeFrameNumbers ? clip.getStepCount() : 0;
                int stepNum = 0;
                while (stepNum <= stepCount) {
                    int out;
                    if (this.abortRefreshAttachments) {
                        this.refreshingAttachments = false;
                        return;
                    }
                    int n3 = clip.stepToFrame(stepNum);
                    CircleFitterStep circleStep = (CircleFitterStep)this.steps.getStep(n3);
                    int in = this.getAttachmentStartFrame(n3);
                    boolean noPoints = in < (out = this.getAttachmentEndFrame(n3)) ? false : this.isNoPoints(n3);
                    int frame = in;
                    while (frame <= out) {
                        if (this.abortRefreshAttachments) {
                            this.refreshingAttachments = false;
                            return;
                        }
                        Step targetStep = targetTrack.getStep(frame);
                        int dataPointIndex = frame - in;
                        CircleFitterStep.DataPoint p = circleStep.getDataPoint(1, dataPointIndex);
                        if (targetStep == null || noPoints) {
                            if (p != null) {
                                p.detach();
                                p = null;
                                framesToRefresh.add(n3);
                            }
                        } else {
                            TPoint target = targetStep.getPoints()[0];
                            if (p == null) {
                                CircleFitterStep circleFitterStep = circleStep;
                                circleFitterStep.getClass();
                                p = new CircleFitterStep.DataPoint(circleFitterStep, target.x, target.y);
                            }
                            if (p.attachTo(target)) {
                                framesToRefresh.add(n3);
                            }
                        }
                        circleStep.setDataPoint(p, 1, dataPointIndex, false, false);
                        ++frame;
                    }
                    CircleFitterStep.DataPoint[] existingPts = circleStep.dataPoints[1];
                    if (existingPts.length > out - in + 1) {
                        CircleFitterStep.DataPoint[] newPts = new CircleFitterStep.DataPoint[out - in + 1];
                        System.arraycopy(existingPts, 0, newPts, 0, newPts.length);
                        circleStep.dataPoints[1] = newPts;
                        int k = newPts.length;
                        while (k < existingPts.length) {
                            if (existingPts[k] != null) {
                                framesToRefresh.add(n3);
                            }
                            ++k;
                        }
                    }
                    ++stepNum;
                }
            } else {
                int stepNum = 0;
                while (stepNum <= clip.getStepCount()) {
                    if (this.abortRefreshAttachments) {
                        this.refreshingAttachments = false;
                        return;
                    }
                    n = clip.stepToFrame(stepNum);
                    CircleFitterStep step = (CircleFitterStep)this.steps.getStep(n);
                    int i3 = 0;
                    while (i3 <= step.dataPoints[1].length) {
                        CircleFitterStep.DataPoint p = step.getDataPoint(1, i3);
                        if (p != null) {
                            p.detach();
                            framesToRefresh.add(n);
                        }
                        ++i3;
                    }
                    step.dataPoints[1] = new CircleFitterStep.DataPoint[0];
                    ++stepNum;
                }
            }
        }
        CircleFitterStep.doRefresh = true;
        Iterator iterator = framesToRefresh.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            if (this.abortRefreshAttachments) {
                this.refreshingAttachments = false;
                return;
            }
            CircleFitterStep step = (CircleFitterStep)this.steps.getStep(n4);
            step.refreshCircle();
        }
        this.tp.refreshTrackBar();
        this.erase();
        this.invalidateData(this);
        this.refreshingAttachments = false;
        if (this.loadingAttachments) {
            this.tp.changed = false;
            this.loadingAttachments = false;
        }
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        boolean valid;
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.originToCenterItem.setText(TrackerRes.getString("CircleFitter.MenuItem.OriginToCenter"));
        this.originToCenterMenu.setText(TrackerRes.getString("CircleFitter.MenuItem.OriginToCenter"));
        this.originToCenterAllItem.setText(TrackerRes.getString("CircleFitter.MenuItem.AllFrames"));
        this.setRadiusItem.setText(String.valueOf(TrackerRes.getString("CircleFitter.Dialog.SetRadius.Title")) + "...");
        this.setRadiusMenu.setText(TrackerRes.getString("CircleFitter.Dialog.SetRadius.Title"));
        this.setRadiusAllItem.setText(TrackerRes.getString("CircleFitter.MenuItem.AllFrames"));
        this.deleteStepItem.setText(TrackerRes.getString("CircleFitter.MenuItem.DeletePoint"));
        this.clearPointsItem.setText(TrackerRes.getString("CircleFitter.MenuItem.ClearPoints"));
        this.clearPointsItem.setEnabled(!this.isLocked());
        this.fixedItem.setText(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.setSelected(this.isFixed());
        this.fixedItem.setEnabled(this.attachments == null || !this.isAttached());
        menu.insert(this.attachmentItem, 0);
        menu.insertSeparator(1);
        this.addFixedItem(menu);
        this.removeDeleteTrackItem(menu);
        menu.addSeparator();
        boolean fixedOrigin = trackerPanel.getCoords().isFixedOrigin();
        boolean fixedScale = trackerPanel.getCoords().isFixedScale();
        CircleFitterStep step = (CircleFitterStep)this.getStep(trackerPanel.getFrameNumber());
        boolean bl = valid = step != null && step.isValidCircle();
        if (fixedOrigin) {
            this.originToCenterItem.setEnabled(!trackerPanel.getCoords().isLocked() && valid);
            menu.add(this.originToCenterItem);
        } else {
            this.originToCenterMenu.setEnabled(!trackerPanel.getCoords().isLocked() && valid);
            menu.add(this.originToCenterMenu);
            this.originToCenterItem.setText(TrackerRes.getString("CircleFitter.MenuItem.ThisFrame"));
            this.originToCenterMenu.add(this.originToCenterItem);
            this.originToCenterMenu.add(this.originToCenterAllItem);
        }
        if (fixedScale) {
            this.setRadiusItem.setEnabled(!trackerPanel.getCoords().isLocked() && valid);
            menu.add(this.setRadiusItem);
        } else {
            this.setRadiusMenu.setEnabled(!trackerPanel.getCoords().isLocked() && valid);
            menu.add(this.setRadiusMenu);
            this.setRadiusItem.setText(TrackerRes.getString("CircleFitter.MenuItem.ThisFrame"));
            this.setRadiusMenu.add(this.setRadiusItem);
            this.setRadiusMenu.add(this.setRadiusAllItem);
        }
        menu.addSeparator();
        menu.add(this.deleteStepItem);
        menu.add(this.clearPointsItem);
        menu.add(this.deleteTrackItem);
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        int n = trackerPanel.getFrameNumber();
        this.refreshFields(n);
        CircleFitterStep step = (CircleFitterStep)this.getStep(n);
        ArrayList<CircleFitterStep.DataPoint> pts = step.getValidDataPoints();
        int dataCount = pts.size();
        this.pointCountButton.setText(String.valueOf(dataCount) + " " + TrackerRes.getString("CircleFitter.Button.DataPoints"));
        this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
        this.stepValueLabel.setText(String.valueOf(trackerPanel.getStepNumber()) + ":");
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        list.add(this.stepLabel);
        list.add(this.stepValueLabel);
        list.add(this.tSeparator);
        list.add(this.pointCountButton);
        list.add(this.stepSeparator);
        if (dataCount > 2) {
            this.xLabel.setText(dataVariables[1]);
            this.yLabel.setText(dataVariables[2]);
            this.xField.setToolTipText(TrackerRes.getString("CircleFitter.Field.CenterX.Tooltip"));
            this.yField.setToolTipText(TrackerRes.getString("CircleFitter.Field.CenterY.Tooltip"));
            this.magLabel.setText(TrackerRes.getString("CircleFitter.Label.Radius"));
            this.magField.setToolTipText(TrackerRes.getString("CircleFitter.Field.Radius.Tooltip"));
            this.xField.setUnits(trackerPanel.getUnits(this, dataVariables[1]));
            this.yField.setUnits(trackerPanel.getUnits(this, dataVariables[2]));
            this.magField.setUnits(trackerPanel.getUnits(this, dataVariables[3]));
            list.add(this.magLabel);
            list.add(this.magField);
            list.add(this.magSeparator);
            list.add(this.xLabel);
            list.add(this.xField);
            list.add(this.xSeparator);
            list.add(this.yLabel);
            list.add(this.yField);
            list.add(this.ySeparator);
        } else if (trackerPanel.getSelectedPoint() == null) {
            this.clickToMarkLabel.setText(TrackerRes.getString("CircleFitter.Label.MarkPoint"));
            list.add(this.clickToMarkLabel);
        }
        return list;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint point) {
        ArrayList<Component> list = super.getToolbarPointComponents(trackerPanel, point);
        if (!(point instanceof CircleFitterStep.DataPoint)) {
            return list;
        }
        int n = trackerPanel.getFrameNumber();
        this.refreshFields(n);
        this.stepValueLabel.setText(String.valueOf(trackerPanel.getStepNumber()) + ":");
        CircleFitterStep step = (CircleFitterStep)this.getStep(n);
        this.xDataPointLabel.setText("x");
        this.yDataPointLabel.setText("y");
        list.add(this.xDataPointLabel);
        list.add(this.xDataField);
        list.add(this.xDataPointSeparator);
        list.add(this.yDataPointLabel);
        list.add(this.yDataField);
        list.add(this.yDataPointSeparator);
        ArrayList<CircleFitterStep.DataPoint> pts = step.getValidDataPoints();
        int dataCount = pts.size();
        if (dataCount < 3) {
            this.clickToMarkLabel.setText(TrackerRes.getString("CircleFitter.Label.MarkPoint"));
            list.add(this.clickToMarkLabel);
        }
        return list;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof TrackerPanel) || !this.isVisible()) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        int n = trackerPanel.getFrameNumber();
        if (trackerPanel.getPlayer().getVideoClip().includesFrame(n)) {
            CircleFitterStep step = (CircleFitterStep)this.steps.getStep(n);
            Interactive ia = step.findInteractive(trackerPanel, xpix, ypix);
            if (ia == null) {
                this.partName = TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = TrackerRes.getString("CircleFitter.Hint.Mark3");
                return null;
            }
            if (ia instanceof CircleFitterStep.DataPoint) {
                this.partName = TrackerRes.getString("CircleFitter.DataPoint.Name");
                this.hint = TrackerRes.getString("CircleFitter.DataPoint.Hint");
            } else if (ia instanceof CircleFitterStep.CenterPoint) {
                this.partName = TrackerRes.getString("CircleFitter.Center.Name");
                this.hint = TrackerRes.getString("CircleFitter.Center.Hint");
            } else if (ia == step.edge) {
                this.partName = TrackerRes.getString("CircleFitter.Circle.Name");
                this.hint = TrackerRes.getString("CircleFitter.Circle.Hint");
                ia = step.center;
            }
            return ia;
        }
        return null;
    }

    @Override
    public String toString() {
        return TrackerRes.getString("CircleFitter.Name");
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        this.numberFields.clear();
        this.numberFields.put(dataVariables[0], new NumberField[]{this.tField});
        this.numberFields.put(dataVariables[1], new NumberField[]{this.xField});
        this.numberFields.put(dataVariables[2], new NumberField[]{this.yField});
        this.numberFields.put(dataVariables[3], new NumberField[]{this.magField});
        this.numberFields.put(dataVariables[6], new NumberField[]{this.xDataField});
        this.numberFields.put(dataVariables[7], new NumberField[]{this.yDataField});
        return this.numberFields;
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.removePanelEvents(panelEventsCircleFitter);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.addPanelEvents(panelEventsCircleFitter);
            this.setFixed(this.isFixed());
        }
    }

    @Override
    protected void setAnglesInRadians(boolean radians) {
        super.setAnglesInRadians(radians);
        CircleFitterStep step = (CircleFitterStep)this.getStep(this.tp.getFrameNumber());
        step.repaint();
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        if (pointIndex == 0) {
            return TrackerRes.getString("Protractor.Vertex.Name");
        }
        String s = TrackerRes.getString("Protractor.End.Name");
        return String.valueOf(s) + " " + pointIndex;
    }

    @Override
    public DatasetManager getData(TrackerPanel panel) {
        int frameCount = panel.getPlayer().getVideoClip().getFrameCount();
        if (this.getSteps().length < frameCount) {
            this.steps.setLength(frameCount);
            this.dataValid = false;
        }
        return super.getData(panel);
    }

    @Override
    protected void refreshData(DatasetManager data, TrackerPanel trackerPanel) {
        if (this.refreshDataLater || trackerPanel == null || data == null) {
            return;
        }
        int count = 6;
        String time = dataVariables[0];
        if (!data.getDataset(0).getColumnName(0).equals(time)) {
            data.setXYColumnNames(0, time, dataVariables[1]);
            data.setXYColumnNames(1, time, dataVariables[2]);
            data.setXYColumnNames(2, time, dataVariables[3]);
            data.setXYColumnNames(3, time, dataVariables[8]);
            data.setXYColumnNames(4, time, dataVariables[4]);
            data.setXYColumnNames(5, time, dataVariables[5]);
        }
        VideoPlayer player = trackerPanel.getPlayer();
        VideoClip clip = player.getVideoClip();
        int len = clip.getStepCount();
        double[][] validData = new double[count + 1][len];
        this.dataFrames.clear();
        int i = 0;
        while (i < len) {
            int frame = clip.stepToFrame(i);
            CircleFitterStep step = (CircleFitterStep)this.getStep(frame);
            step.dataVisible = true;
            double t = player.getStepTime(i) / 1000.0;
            Point2D center = step.getWorldCenter();
            validData[0][i] = center == null ? Double.NaN : center.getX();
            validData[1][i] = center == null ? Double.NaN : center.getY();
            validData[2][i] = step.getWorldRadius();
            validData[3][i] = step.getValidDataPoints().size();
            validData[4][i] = i;
            validData[5][i] = frame;
            validData[6][i] = t;
            this.dataFrames.add(frame);
            ++i;
        }
        this.clearColumns(data, count, null, "CircleFitter.Data.Description.", validData, len);
    }

    protected void refreshStep(CircleFitterStep step) {
        boolean different;
        CircleFitterStep keyStep;
        int i;
        CircleFitterStep.DataPoint[] pts;
        CircleFitterStep.DataPoint[] keyPts;
        int firstFrame;
        CircleFitterStep keyStep2;
        boolean changed = false;
        if (this.attachToSteps && !this.isRelativeFrameNumbers && this.isAttached() && (keyStep2 = (CircleFitterStep)this.steps.getStep(firstFrame = this.tp.getPlayer().getVideoClip().stepToFrame(0))) != step) {
            keyPts = keyStep2.dataPoints[1];
            pts = step.dataPoints[1];
            if (keyPts.length != pts.length) {
                changed = true;
                pts = new CircleFitterStep.DataPoint[keyPts.length];
                i = 0;
                while (i < pts.length) {
                    CircleFitterStep.DataPoint dataPoint;
                    CircleFitterStep.DataPoint next = keyPts[i];
                    if (next == null) {
                        dataPoint = null;
                    } else {
                        CircleFitterStep circleFitterStep = step;
                        circleFitterStep.getClass();
                        dataPoint = new CircleFitterStep.DataPoint(circleFitterStep, next.x, next.y);
                    }
                    pts[i] = dataPoint;
                    ++i;
                }
                step.dataPoints[1] = pts;
            } else {
                i = 0;
                while (i < pts.length) {
                    if (keyPts[i] == null) {
                        changed = changed || pts[i] != null;
                        pts[i] = null;
                    } else {
                        if (pts[i] == null) {
                            changed = true;
                            CircleFitterStep circleFitterStep = step;
                            circleFitterStep.getClass();
                            pts[i] = new CircleFitterStep.DataPoint(circleFitterStep, 0.0, 0.0);
                        }
                        changed = changed || keyPts[i].x != pts[i].x || keyPts[i].y != pts[i].y;
                        pts[i].setLocation(keyPts[i]);
                    }
                    ++i;
                }
            }
        }
        if ((keyStep = this.getKeyStep(step)) == step) {
            if (changed) {
                step.refreshCircle();
            }
            return;
        }
        boolean bl = different = keyStep.dataPoints.length != step.dataPoints.length;
        if (!different) {
            boolean bl2 = different = keyStep.dataPoints[0].length != step.dataPoints[0].length;
        }
        if (!different) {
            keyPts = keyStep.dataPoints[0];
            pts = step.dataPoints[0];
            i = 0;
            while (i < keyPts.length) {
                CircleFitterStep.DataPoint p1 = keyPts[i];
                CircleFitterStep.DataPoint p2 = pts[i];
                if (p1 != null && p2 != null) {
                    if (p1.x != p2.x || p1.y != p2.y) {
                        different = true;
                        break;
                    }
                } else if (p1 != null || p2 != null) {
                    different = true;
                    break;
                }
                ++i;
            }
        }
        if (different) {
            step.copy(keyStep);
        } else if (changed) {
            step.refreshCircle();
        }
    }

    protected void refreshFields(int frameNumber) {
        if (this.tp == null) {
            return;
        }
        CircleFitterStep step = (CircleFitterStep)this.getStep(frameNumber);
        this.magField.setValue(step.getWorldRadius());
        Point2D worldPt = step.getWorldCenter();
        this.xField.setValue(worldPt == null ? Double.NaN : worldPt.getX());
        this.yField.setValue(worldPt == null ? Double.NaN : worldPt.getY());
        TPoint p = this.tp.getSelectedPoint();
        if (p instanceof CircleFitterStep.DataPoint) {
            worldPt = p.getWorldPosition(this.tp);
            this.xDataField.setValue(worldPt.getX());
            this.yDataField.setValue(worldPt.getY());
            this.xDataField.setEnabled(!p.isAttached() && !this.isLocked());
            this.yDataField.setEnabled(!p.isAttached() && !this.isLocked());
        }
    }

    protected CircleFitterStep getKeyStep(CircleFitterStep step) {
        int key = 0;
        if (!this.isFixed()) {
            Iterator iterator = this.keyFrames.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i > step.n) continue;
                key = i;
            }
        }
        return (CircleFitterStep)this.steps.getStep(key);
    }

    @Override
    protected boolean loadAttachmentsFromNames(boolean refresh) {
        boolean loaded = super.loadAttachmentsFromNames(false);
        if (!loaded && this.stepAttachmentName == null) {
            return false;
        }
        this.loadingAttachments = true;
        TTrack track = this.tp.getTrack(this.stepAttachmentName);
        if (track != null) {
            loaded = true;
            this.attachmentForSteps = new TTrack[]{track};
            this.stepAttachmentName = null;
        }
        if (loaded && refresh) {
            this.refreshAttachmentsLater();
        } else {
            this.loadingAttachments = false;
        }
        return loaded;
    }

    protected void setCoordsOriginToCenter(boolean all) {
        if (this.tp.getCoords().isLocked()) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this.tp.getCoords());
        int n = this.tp.getFrameNumber();
        CircleFitterStep step = (CircleFitterStep)this.getStep(n);
        if (step == null || !step.isValidCircle()) {
            return;
        }
        CircleFitterStep.CenterPoint pt = step.center;
        if (this.tp.getCoords().isFixedOrigin()) {
            this.tp.getCoords().setOriginXY(0, pt.x, pt.y);
        } else if (all) {
            Step[] steps = this.getSteps();
            int i = 0;
            while (i < steps.length) {
                step = (CircleFitterStep)steps[i];
                if (step != null && step.isValidCircle() && (this.keyFrames.contains(i) || this.tp.getCoords().getKeyFrames().contains(i))) {
                    pt = step.center;
                }
                this.tp.getCoords().setOriginXY(i, pt.x, pt.y);
                ++i;
            }
        } else {
            this.tp.getCoords().setOriginXY(n, pt.x, pt.y);
        }
        this.tp.getAxes().setVisible(true);
        Undo.postCoordsEdit(this.tp, control);
    }

    protected void setCoordsScaleFromRadius(boolean all) {
        if (this.tp.getCoords().isLocked()) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this.tp.getCoords());
        int n = this.tp.getFrameNumber();
        CircleFitterStep step = (CircleFitterStep)this.getStep(n);
        if (step == null || !step.isValidCircle()) {
            return;
        }
        double r = step.getWorldRadius();
        String init = this.magField.getText();
        if (init.contains(" ")) {
            init = init.substring(0, init.indexOf(" "));
        }
        double[] targetR = new double[]{r};
        new AsyncDialog().showInputDialog(null, TrackerRes.getString("CircleFitter.Dialog.SetRadius.Message"), TrackerRes.getString("CircleFitter.Dialog.SetRadius.Title"), -1, null, null, init, e -> {
            String s = e.getActionCommand();
            if (s != null) {
                if (s.contains(" ")) {
                    s = s.substring(0, s.indexOf(" "));
                }
                try {
                    dArray[0] = Double.valueOf(s);
                }
                catch (NumberFormatException e1) {
                    this.setCoordsScaleFromRadius(all);
                }
            }
        });
        if (r == targetR[0]) {
            return;
        }
        double scale = this.tp.getCoords().getScaleX(n) * r / targetR[0];
        if (this.tp.getCoords().isFixedScale()) {
            this.tp.getCoords().setScaleXY(0, scale, scale);
        } else if (all) {
            Step[] steps = this.getSteps();
            int i = 0;
            while (i < steps.length) {
                step = (CircleFitterStep)steps[i];
                if (step != null && step.isValidCircle() && (this.keyFrames.contains(i) || this.tp.getCoords().getKeyFrames().contains(i))) {
                    r = step.getWorldRadius();
                    scale = this.tp.getCoords().getScaleX(i) * r / targetR[0];
                }
                this.tp.getCoords().setScaleXY(i, scale, scale);
                ++i;
            }
        } else {
            this.tp.getCoords().setScaleXY(n, scale, scale);
        }
        Undo.postCoordsEdit(this.tp, control);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            CircleFitter circleFitter = (CircleFitter)obj;
            XML.getLoader(TTrack.class).saveObject(control, obj);
            control.setValue("fixed", circleFitter.isFixed());
            Step[] steps = circleFitter.getSteps();
            ArrayList<double[]> dataList = new ArrayList<double[]>();
            int n = 0;
            while (n < steps.length) {
                if (steps[n] != null && circleFitter.keyFrames.contains(n)) {
                    CircleFitterStep step = (CircleFitterStep)steps[n];
                    CircleFitterStep.DataPoint[] pts = step.dataPoints[0];
                    int len = pts.length;
                    if (len == 0) {
                        dataList.add(new double[]{n});
                    } else {
                        double[] stepData = new double[2 * len + 1];
                        stepData[0] = n;
                        int i = 0;
                        while (i < len) {
                            CircleFitterStep.DataPoint p = pts[i];
                            stepData[2 * i + 1] = p.x;
                            stepData[2 * i + 2] = p.y;
                            ++i;
                        }
                        dataList.add(stepData);
                    }
                }
                ++n;
            }
            double[][] data = (double[][])dataList.toArray((T[])new double[dataList.size()][]);
            control.setValue("framedata", data);
            if (circleFitter.attachToSteps) {
                control.setValue("attach_to_steps", true);
            }
            if (circleFitter.isRelativeFrameNumbers) {
                control.setValue("relative_frames", true);
            }
            control.setValue("absolute_start", circleFitter.absoluteStart);
            control.setValue("attachment_framecount", circleFitter.attachmentFrameCount);
            control.setValue("relative_start", circleFitter.relativeStart);
            if (circleFitter.attachmentForSteps != null && circleFitter.attachmentForSteps.length > 0 && circleFitter.attachmentForSteps[0] != null) {
                control.setValue("step_attachment", circleFitter.attachmentForSteps[0].getName());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new CircleFitter();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            String name;
            double version = 4.91;
            XMLProperty parent = control.getParentProperty();
            while (parent != null) {
                if (parent.getPropertyName().equals("TrackerPanel") && parent instanceof XMLControl) {
                    XMLControl trackerControl = (XMLControl)parent;
                    version = trackerControl.getDouble("version");
                }
                parent = parent.getParentProperty();
            }
            CircleFitter circleFitter = (CircleFitter)obj;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            boolean locked = circleFitter.isLocked();
            circleFitter.setLocked(false);
            circleFitter.fixedPosition = control.getBoolean("fixed");
            circleFitter.attachToSteps = control.getBoolean("attach_to_steps");
            circleFitter.isRelativeFrameNumbers = control.getBoolean("relative_frames");
            if (control.getPropertyNamesRaw().contains("absolute_start")) {
                circleFitter.absoluteStart = control.getInt("absolute_start");
            }
            if (control.getPropertyNamesRaw().contains("attachment_framecount")) {
                circleFitter.attachmentFrameCount = control.getInt("attachment_framecount");
            }
            if (control.getPropertyNamesRaw().contains("relative_start")) {
                circleFitter.relativeStart = control.getInt("relative_start");
            }
            if ((name = control.getString("step_attachment")) != null) {
                circleFitter.stepAttachmentName = name;
            }
            circleFitter.keyFrames.clear();
            circleFitter.keyFrames.add(0);
            double[][] data = (double[][])control.getObject("framedata");
            int i = 0;
            while (i < data.length) {
                if (data[i] != null && data[i].length >= 1) {
                    int n = (int)data[i][0];
                    circleFitter.keyFrames.add(n);
                    if (n > 0) {
                        circleFitter.fixedPosition = false;
                    }
                    CircleFitterStep step = (CircleFitterStep)circleFitter.steps.getStep(n);
                    int prevCount = step.dataPoints[0].length;
                    if (data[i].length == 1) {
                        step.dataPoints[0] = new CircleFitterStep.DataPoint[0];
                        if (prevCount > 0) {
                            step.refreshCircle();
                        }
                    } else {
                        int pointCount = version < 4.92 ? (data[i].length - 3) / 2 : (data[i].length - 1) / 2;
                        CircleFitterStep.DataPoint[] loadedPoints = new CircleFitterStep.DataPoint[pointCount];
                        int j = 0;
                        while (j < pointCount) {
                            CircleFitterStep circleFitterStep = step;
                            circleFitterStep.getClass();
                            loadedPoints[j] = new CircleFitterStep.DataPoint(circleFitterStep, data[i][2 * j + 1], data[i][2 * j + 2]);
                            ++j;
                        }
                        step.dataPoints[0] = loadedPoints;
                        step.refreshCircle();
                    }
                }
                ++i;
            }
            circleFitter.setLocked(locked);
            circleFitter.invalidateData(circleFitter);
            return obj;
        }
    }
}

