/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;

public class CircleFitterFootprint
implements Footprint,
Cloneable {
    private static final CircleFitterFootprint CIRCLE_4;
    private static final CircleFitterFootprint CIRCLE_7;
    private static final CircleFitterFootprint CIRCLE_4_BOLD;
    private static final CircleFitterFootprint CIRCLE_7_BOLD;
    private static final CircleFitterFootprint CIRCLE_4_POINTS_ONLY;
    protected static final int MAX_RADIUS = 100000;
    private static Collection<CircleFitterFootprint> footprints;
    private static Shape hitShape;
    private static Shape emptyHitShape;
    private static Line2D line;
    private static AffineTransform transform;
    private static Arc2D.Float iconArc;
    protected String name;
    protected BasicStroke baseStroke;
    protected BasicStroke stroke;
    protected Color color = Color.black;
    protected ArrayList<Shape> hitShapes = new ArrayList();
    protected Ellipse2D circle;
    protected double radius;
    protected Shape marker;
    protected Shape crosshatch;
    protected int markerSize;
    protected Point selectedPoint;
    protected int markedPointCount;
    protected boolean drawCircle = true;

    static {
        footprints = new HashSet<CircleFitterFootprint>();
        hitShape = new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0);
        emptyHitShape = new Rectangle();
        line = new Line2D.Double();
        transform = new AffineTransform();
        iconArc = new Arc2D.Float();
        BasicStroke stroke = new BasicStroke(1.0f);
        CIRCLE_4 = new CircleFitterFootprint("CircleFitterFootprint.Circle4", 4);
        CIRCLE_4.setStroke(stroke);
        footprints.add(CIRCLE_4);
        CIRCLE_7 = new CircleFitterFootprint("CircleFitterFootprint.Circle7", 7);
        CIRCLE_7.setStroke(stroke);
        footprints.add(CIRCLE_7);
        CIRCLE_4_POINTS_ONLY = new CircleFitterFootprint("CircleFitterFootprint.Circle4.PointsOnly", 4);
        CIRCLE_4_POINTS_ONLY.setStroke(stroke);
        CIRCLE_4_POINTS_ONLY.setCircleVisible(false);
        footprints.add(CIRCLE_4_POINTS_ONLY);
        stroke = new BasicStroke(2.0f);
        CIRCLE_4_BOLD = new CircleFitterFootprint("CircleFitterFootprint.Circle4Bold", 4);
        CIRCLE_4_BOLD.setStroke(stroke);
        footprints.add(CIRCLE_4_BOLD);
        CIRCLE_7_BOLD = new CircleFitterFootprint("CircleFitterFootprint.Circle7Bold", 7);
        CIRCLE_7_BOLD.setStroke(stroke);
        footprints.add(CIRCLE_7_BOLD);
    }

    public CircleFitterFootprint(String name, int size) {
        this.name = name;
        this.markerSize = size;
        this.circle = new Ellipse2D.Double();
        this.marker = new Ellipse2D.Double(-size, -size, 2 * size, 2 * size);
        double d = (double)size * 0.707;
        GeneralPath path = new GeneralPath();
        path.moveTo(-d, -d);
        path.lineTo(d, d);
        path.moveTo(-d, d);
        path.lineTo(d, -d);
        this.crosshatch = path;
        this.setStroke(new BasicStroke());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        if (this.stroke == null || this.stroke.getLineWidth() != this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke(this.baseStroke.getLineWidth());
        }
        MultiShape drawShape = new MultiShape(new Shape[0]);
        if (this.drawCircle) {
            iconArc.setArc(0.0, 0.0, 20.0, 20.0, 200.0, 140.0, 0);
            drawShape.addDrawShape((Arc2D)iconArc.clone(), this.stroke);
        }
        int r = this.markerSize / 2;
        this.circle.setFrameFromCenter(10.0, 20.0, 10 + r, 20 + r);
        drawShape.addDrawShape((Ellipse2D)this.circle.clone(), this.stroke);
        transform.setToTranslation(0.0, 10.0);
        drawShape = drawShape.transform(transform);
        ShapeIcon icon = new ShapeIcon(drawShape, w, h);
        icon.setColor(this.color);
        return new ResizableIcon(icon);
    }

    @Override
    public Mark getMark(Point[] points) {
        final MultiShape shape = this.getShape(points, FontSizer.getIntegerFactor());
        final Color color = this.color;
        return new Mark(){

            @Override
            public void draw(Graphics2D g, boolean highlighted) {
                Color gcolor = g.getColor();
                Stroke gstroke = g.getStroke();
                g.setColor(color);
                g.setStroke(CircleFitterFootprint.this.stroke);
                if (OSPRuntime.setRenderingHints) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                shape.draw(g);
                g.setColor(gcolor);
                g.setStroke(gstroke);
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes.toArray(new Shape[this.hitShapes.size()]);
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke == null) {
            return;
        }
        this.baseStroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, stroke.getDashArray(), stroke.getDashPhase());
    }

    @Override
    public BasicStroke getStroke() {
        return this.baseStroke;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    protected void setPixelRadius(double r) {
        this.radius = r;
    }

    protected void setCircleVisible(boolean vis) {
        this.drawCircle = vis;
    }

    protected void setSelectedPoint(Point p) {
        this.selectedPoint = p;
    }

    protected void setMarkedPointCount(int n) {
        this.markedPointCount = n;
    }

    @Override
    public MultiShape getShape(Point[] points, int scale) {
        Point center = points[0];
        Point edge = points[1];
        this.hitShapes.clear();
        if (this.stroke == null || this.stroke.getLineWidth() != (float)scale * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)scale * this.baseStroke.getLineWidth());
        }
        MultiShape drawMe = new MultiShape(new Shape[0]);
        if (this.drawCircle && points.length >= 5) {
            if (Double.isInfinite(this.radius) || this.radius > 100000.0) {
                double x = edge.getX();
                double y = edge.getY();
                double dx = points[3].getX() - points[2].getX();
                double dy = points[3].getY() - points[2].getY();
                double slope = dy / dx;
                double len = 10000.0;
                if (dx == 0.0) {
                    line.setLine(x, y - len, x, y + len);
                } else if (Math.abs(dx) > Math.abs(dy)) {
                    line.setLine(x - len, y - slope * len, x + len, y + slope * len);
                } else {
                    line.setLine(x - len / slope, y - len, x + len / slope, y + len);
                }
                transform.setToIdentity();
                drawMe.addDrawShape(transform.createTransformedShape(line), null);
            } else {
                transform.setToIdentity();
                this.circle.setFrameFromCenter(center.x, center.y, (double)center.x + this.radius, (double)center.y + this.radius);
                drawMe.addDrawShape(transform.createTransformedShape(this.circle), null);
                transform.setToTranslation(points[0].x, points[0].y);
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                Shape mark = transform.createTransformedShape(this.marker);
                drawMe.addDrawShape(mark, null);
                this.hitShapes.add(mark);
                Shape crosshair = transform.createTransformedShape(this.crosshatch);
                drawMe.addDrawShape(crosshair, null);
            }
        }
        if (this.hitShapes.size() == 0) {
            this.hitShapes.add(emptyHitShape);
        }
        int i = 2;
        while (i < points.length) {
            transform.setToTranslation(points[i].x, points[i].y);
            if (scale > 1) {
                transform.scale(scale, scale);
            }
            if (points[i] != this.selectedPoint) {
                Shape mark = transform.createTransformedShape(this.marker);
                drawMe.addDrawShape(mark, null);
                if (i >= 2 + this.markedPointCount) {
                    drawMe.addFillShape(mark);
                }
            }
            this.hitShapes.add(transform.createTransformedShape(hitShape));
            ++i;
        }
        return drawMe;
    }

    public static Footprint getFootprint(String name) {
        for (CircleFitterFootprint footprint : footprints) {
            if (name != footprint.getName()) continue;
            try {
                return (CircleFitterFootprint)footprint.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }
}

