/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.CircleFitter;
import org.opensourcephysics.cabrillo.tracker.CircleFitterFootprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class CircleFitterStep
extends Step {
    protected static AffineTransform transform = new AffineTransform();
    protected static TPoint endPoint1 = new TPoint();
    protected static TPoint endPoint2 = new TPoint();
    protected static boolean doRefresh = true;
    protected CircleFitter circleFitter;
    protected DataPoint[][] dataPoints = new DataPoint[2][0];
    protected CenterPoint center;
    protected TPoint edge;
    protected double radius;
    protected Map<Integer, Shape> panelCircleHitShapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelCenterHitShapes = new HashMap<Integer, Shape>();
    protected ArrayList<Map<Integer, Shape>> panelPointHitShapes = new ArrayList();
    protected MultiShape selectedShape;

    public CircleFitterStep(CircleFitter track, int n) {
        super(track, n);
        this.circleFitter = track;
        this.center = new CenterPoint(0.0, 0.0);
        this.edge = new TPoint();
        this.points = new TPoint[]{this.center, this.edge};
        this.screenPoints = new Point[this.points.length];
    }

    public void setDataPoint(DataPoint p, int column, int row, boolean refreshAndPostEdit, boolean reduceArrayLengthIfNull) {
        if (row < 0 || column < 0 || column >= this.dataPoints.length) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        if (!this.circleFitter.isFixed() && refreshAndPostEdit) {
            this.circleFitter.keyFrames.add(this.n);
        }
        if (row >= this.dataPoints[column].length) {
            int len = this.dataPoints[column].length;
            DataPoint[] newPoints = new DataPoint[row + 1];
            System.arraycopy(this.dataPoints[column], 0, newPoints, 0, len);
            this.dataPoints[column] = newPoints;
        }
        this.dataPoints[column][row] = p;
        if (p == null && reduceArrayLengthIfNull) {
            DataPoint[] newPoints = new DataPoint[this.dataPoints[column].length - 1];
            System.arraycopy(this.dataPoints[column], 0, newPoints, 0, row);
            System.arraycopy(this.dataPoints[column], row + 1, newPoints, row, this.dataPoints[column].length - row - 1);
            this.dataPoints[column] = newPoints;
        }
        if (refreshAndPostEdit) {
            this.defaultIndex = this.dataPoints[0].length - 1;
            this.refreshCircle();
            this.circleFitter.invalidateData(this.circleFitter);
            this.circleFitter.firePropertyChange("dataPoint", null, this.circleFitter);
            if (this.circleFitter.tp != null) {
                this.circleFitter.tp.changed = true;
            }
            this.circleFitter.tp.refreshTrackBar();
            Undo.postStepEdit(this, control);
        }
    }

    public void addDataPoint(DataPoint p, boolean refreshAndPostEdit) {
        this.setDataPoint(p, 0, this.dataPoints[0].length, refreshAndPostEdit, p == null);
    }

    public void removeDataPoint(DataPoint p, boolean postUndoableEdit, boolean fireEvents) {
        if (p == null) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.dataPoints[0].length) {
            if (p == this.dataPoints[0][i]) {
                index = i;
                break;
            }
            ++i;
        }
        XMLControlElement control = new XMLControlElement(this);
        if (index > -1) {
            if (!this.circleFitter.isFixed() && !p.isAttached()) {
                this.circleFitter.keyFrames.add(this.n);
            }
            DataPoint[] newPoints = new DataPoint[this.dataPoints[0].length - 1];
            System.arraycopy(this.dataPoints[0], 0, newPoints, 0, index);
            System.arraycopy(this.dataPoints[0], index + 1, newPoints, index, this.dataPoints[0].length - index - 1);
            this.dataPoints[0] = newPoints;
        }
        this.refreshCircle();
        if (index > -1 && postUndoableEdit) {
            Undo.postStepEdit(this, control);
            if (this.circleFitter.tp != null) {
                this.circleFitter.tp.changed = true;
            }
        }
        if (this.n == this.circleFitter.tp.getFrameNumber()) {
            this.repaint();
            this.circleFitter.refreshFields(this.n);
        }
        this.circleFitter.invalidateData(fireEvents);
        if (fireEvents) {
            this.circleFitter.firePropertyChange("dataPoint", null, this.circleFitter);
        }
        this.circleFitter.tp.setSelectedPoint(null);
        this.circleFitter.tp.selectedSteps.clear();
        this.circleFitter.tp.refreshTrackBar();
        this.repaint();
    }

    public DataPoint getDataPoint(int column, int row) {
        if (row >= 0 && column >= 0 && column < this.dataPoints.length && this.dataPoints[column].length > row) {
            return this.dataPoints[column][row];
        }
        return null;
    }

    public ArrayList<DataPoint> getValidDataPoints() {
        ArrayList<DataPoint> validPoints = new ArrayList<DataPoint>();
        int col = 0;
        while (col < this.dataPoints.length) {
            DataPoint[] pts = this.dataPoints[col];
            int row = 0;
            while (row < pts.length) {
                if (pts[row] != null) {
                    validPoints.add(pts[row]);
                }
                ++row;
            }
            ++col;
        }
        return validPoints;
    }

    public boolean trimAttachedPointsToLength(int len) {
        boolean changed = false;
        if (len < this.dataPoints[1].length) {
            DataPoint[] newPoints = new DataPoint[len];
            System.arraycopy(this.dataPoints[1], 0, newPoints, 0, len);
            int i = len;
            while (i < this.dataPoints[1].length) {
                changed = changed || this.dataPoints[1][i] != null;
                ++i;
            }
            this.dataPoints[1] = newPoints;
        }
        return changed;
    }

    @Override
    public TPoint getDefaultPoint() {
        if (this.defaultIndex >= 0 && this.dataPoints[0].length > this.defaultIndex) {
            return this.dataPoints[0][this.defaultIndex];
        }
        return null;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        this.setHitRectCenter(xpix, ypix);
        Interactive hit = null;
        Shape hitShape = this.panelCircleHitShapes.get(trackerPanel.getID());
        if (this.isValidCircle() && hitShape != null && hitShape.intersects(hitRect)) {
            hit = this.edge;
        }
        hitShape = this.panelCenterHitShapes.get(trackerPanel.getID());
        if (this.isValidCircle() && hitShape != null && hitShape.intersects(hitRect)) {
            hit = this.center;
        }
        int i = 0;
        while (i < this.panelPointHitShapes.size()) {
            ArrayList<DataPoint> validPoints;
            Map<Integer, Shape> map = this.panelPointHitShapes.get(i);
            if (map != null && (hitShape = map.get(trackerPanel.getID())) != null && hitShape.intersects(hitRect) && i < (validPoints = this.getValidDataPoints()).size()) {
                hit = validPoints.get(i);
            }
            ++i;
        }
        if (hit != null && hit instanceof DataPoint && ((DataPoint)hit).isAttached()) {
            return null;
        }
        return hit;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Graphics2D g = (Graphics2D)_g;
        this.getMark(trackerPanel).draw(g, false);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        TPoint selection = null;
        if (mark == null) {
            selection = trackerPanel.getSelectedPoint();
            ArrayList<DataPoint> pts = this.getValidDataPoints();
            int dataCount = pts.size();
            if (this.screenPoints.length != this.points.length + dataCount) {
                this.screenPoints = new Point[this.points.length + dataCount];
            }
            Point p = null;
            int i = 0;
            while (i < this.points.length) {
                this.screenPoints[i] = this.points[i].getScreenPosition(trackerPanel);
                if (selection == this.points[i]) {
                    p = this.screenPoints[i];
                }
                ++i;
            }
            i = 0;
            while (i < dataCount) {
                DataPoint next = pts.get(i);
                this.screenPoints[i + this.points.length] = next.getScreenPosition(trackerPanel);
                if (selection == next) {
                    p = this.screenPoints[i + this.points.length];
                }
                ++i;
            }
            CircleFitterFootprint fitterFootprint = (CircleFitterFootprint)this.footprint;
            fitterFootprint.setSelectedPoint(p);
            fitterFootprint.setPixelRadius(this.radius * trackerPanel.getXPixPerUnit());
            fitterFootprint.setMarkedPointCount(this.dataPoints[0].length);
            mark = fitterFootprint.getMark(this.screenPoints);
            if (p != null) {
                final Color color = this.footprint.getColor();
                final Mark stepMark = mark;
                transform.setToTranslation(p.x, p.y);
                int scale = FontSizer.getIntegerFactor();
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                this.selectedShape = new MultiShape(transform.createTransformedShape(selectionShape)).andStroke(selectionStroke);
                mark = new Mark(){

                    @Override
                    public void draw(Graphics2D g, boolean highlighted) {
                        stepMark.draw(g, false);
                        Paint gpaint = g.getPaint();
                        g.setPaint(color);
                        CircleFitterStep.this.selectedShape.draw(g);
                        g.setPaint(gpaint);
                    }
                };
            }
            this.panelMarks.put(trackerPanel.getID(), mark);
            Shape[] shapes = this.footprint.getHitShapes();
            this.panelCenterHitShapes.put(trackerPanel.getID(), shapes[0]);
            if (shapes.length - 1 < this.panelPointHitShapes.size()) {
                this.panelPointHitShapes.clear();
            }
            int i2 = 1;
            while (i2 < shapes.length) {
                if (this.panelPointHitShapes.size() <= i2) {
                    HashMap newMap = new HashMap();
                    this.panelPointHitShapes.add(newMap);
                }
                Map<Integer, Shape> map = this.panelPointHitShapes.get(i2 - 1);
                map.put(trackerPanel.getID(), shapes[i2]);
                ++i2;
            }
        }
        return mark;
    }

    public double getWorldRadius() {
        int dataCount = this.getValidDataPoints().size();
        if (dataCount < 3 || this.circleFitter.tp == null) {
            return Double.NaN;
        }
        return this.radius / this.circleFitter.tp.getCoords().getScaleX(this.n);
    }

    public Point2D getWorldCenter() {
        int dataCount = this.getValidDataPoints().size();
        if (dataCount < 3 || Double.isInfinite(this.radius) || this.radius > 100000.0 || this.circleFitter.tp == null) {
            return null;
        }
        return this.center.getWorldPosition(this.circleFitter.tp);
    }

    public boolean isValidCircle() {
        int dataCount = this.getValidDataPoints().size();
        return dataCount > 2 && !Double.isInfinite(this.radius) && this.radius > 0.0 && this.radius < 100000.0;
    }

    public void refreshCircle() {
        boolean isVisible;
        double prevR = this.radius;
        double prevX = this.center.x;
        double prevY = this.center.y;
        ArrayList<DataPoint> pts = this.getValidDataPoints();
        int len = pts.size();
        TPoint p = null;
        switch (len) {
            case 0: {
                break;
            }
            case 1: {
                DataPoint p0 = pts.get(0);
                this.center.setLocation(p0);
                break;
            }
            case 2: {
                DataPoint p0 = pts.get(0);
                DataPoint p1 = pts.get(1);
                this.center.center(p0, p1);
                this.edge.setLocation(p0);
                break;
            }
            case 3: {
                DataPoint p0 = pts.get(0);
                DataPoint p1 = pts.get(1);
                DataPoint p2 = pts.get(2);
                this.refreshCircle(p0, p1, p2);
                if (this.circleFitter.tp != null) {
                    p = this.circleFitter.tp.getSelectedPoint();
                }
                this.edge.setLocation(p == p1 ? p1 : (p == p2 ? p2 : p0));
                break;
            }
            default: {
                DataPoint p0;
                this.refreshCircle(pts);
                if (Double.isInfinite(this.radius) || this.radius > 100000.0) {
                    if (this.circleFitter.tp != null) {
                        p = this.circleFitter.tp.getSelectedPoint();
                    }
                    p0 = pts.get(0);
                    DataPoint p1 = pts.get(1);
                    DataPoint p2 = pts.get(2);
                    this.edge.setLocation(p == p1 ? p1 : (p == p2 ? p2 : p0));
                    break;
                }
                this.edge.setLocation(this.center.x, this.center.y + this.radius);
            }
        }
        boolean bl = isVisible = this.circleFitter.tp != null && this.n == this.circleFitter.tp.getFrameNumber();
        if (this.radius != prevR || this.center.x != prevX || this.center.y != prevY) {
            if (isVisible) {
                this.repaint();
            } else {
                this.erase();
            }
        }
    }

    private void refreshCircle(TPoint p1, TPoint p2, TPoint p3) {
        double xDeltaA = p2.getX() - p1.getX();
        double yDeltaA = p2.getY() - p1.getY();
        double xDeltaB = p3.getX() - p2.getX();
        double yDeltaB = p3.getY() - p2.getY();
        double slopeA = yDeltaA / xDeltaA;
        double slopeB = yDeltaB / xDeltaB;
        double xMidA = (p2.getX() + p1.getX()) / 2.0;
        double yMidA = (p2.getY() + p1.getY()) / 2.0;
        double xMidB = (p3.getX() + p2.getX()) / 2.0;
        double yMidB = (p3.getY() + p2.getY()) / 2.0;
        if (xDeltaA == 0.0 && xDeltaB == 0.0 || slopeA == slopeB) {
            this.radius = Double.POSITIVE_INFINITY;
            return;
        }
        if (yDeltaA == 0.0) {
            this.center.x = xMidA;
            this.center.y = xDeltaB == 0.0 ? yMidB : yMidB + (xMidB - this.center.x) / slopeB;
        } else if (yDeltaB == 0.0) {
            this.center.x = xMidB;
            this.center.y = xDeltaA == 0.0 ? yMidA : yMidA + (xMidA - this.center.x) / slopeA;
        } else if (xDeltaA == 0.0) {
            this.center.y = yMidA;
            this.center.x = slopeB * (yMidB - this.center.y) + xMidB;
        } else if (xDeltaB == 0.0) {
            this.center.y = yMidB;
            this.center.x = slopeA * (yMidA - this.center.y) + xMidA;
        } else {
            this.center.x = (slopeA * slopeB * (yMidA - yMidB) - slopeA * xMidB + slopeB * xMidA) / (slopeB - slopeA);
            this.center.y = yMidA - (this.center.x - xMidA) / slopeA;
        }
        this.radius = this.center.distance(p1);
    }

    private void refreshCircle(ArrayList<DataPoint> pts) {
        double[] deltax = new double[pts.size() - 1];
        double[] deltay = new double[pts.size() - 1];
        double[] slope = new double[pts.size() - 1];
        DataPoint prev = null;
        boolean allDeltaXZero = true;
        boolean allSameSlope = true;
        int i = 0;
        while (i < pts.size()) {
            DataPoint p = pts.get(i);
            if (prev == null) {
                prev = p;
            } else {
                deltax[i - 1] = p.x - prev.x;
                deltay[i - 1] = p.y - prev.y;
                slope[i - 1] = deltay[i - 1] / deltax[i - 1];
                if (i > 1) {
                    allDeltaXZero = allDeltaXZero && deltax[i - 1] == deltax[i - 2];
                    allSameSlope = allSameSlope && slope[i - 1] == slope[i - 2];
                }
            }
            ++i;
        }
        if (allDeltaXZero || allSameSlope) {
            this.radius = Double.POSITIVE_INFINITY;
            return;
        }
        double sumx = 0.0;
        double sumy = 0.0;
        double sumx2 = 0.0;
        double sumy2 = 0.0;
        double sumx3 = 0.0;
        double sumy3 = 0.0;
        double sumxy = 0.0;
        double sumxy2 = 0.0;
        double sumx2y = 0.0;
        for (DataPoint p : pts) {
            double val = p.x;
            sumx += val;
            sumx2 += (val *= p.x);
            sumx3 += (val *= p.x);
            val = p.y;
            sumy += val;
            sumy2 += (val *= p.y);
            sumy3 += (val *= p.y);
            val = p.x * p.y;
            sumxy += val;
            sumxy2 += val * p.y;
            sumx2y += val * p.x;
        }
        double n = pts.size();
        double a = n * sumx2 - sumx * sumx;
        double b = n * sumxy - sumx * sumy;
        double c = n * sumy2 - sumy * sumy;
        double d = 0.5 * (n * sumxy2 - sumx * sumy2 + n * sumx3 - sumx * sumx2);
        double e = 0.5 * (n * sumx2y - sumy * sumx2 + n * sumy3 - sumy * sumy2);
        double denom = a * c - b * b;
        double x = (d * c - b * e) / denom;
        double y = (a * e - b * d) / denom;
        this.center.setLocation(x, y);
        double r = 0.0;
        for (DataPoint p : pts) {
            double dx = p.x - x;
            double dy = p.y - y;
            r += Math.sqrt(dx * dx + dy * dy);
        }
        this.radius = r / n;
    }

    @Override
    public Object clone() {
        CircleFitterStep step = (CircleFitterStep)super.clone();
        if (step != null) {
            TPoint[] tPointArray = step.points;
            CircleFitterStep circleFitterStep = step;
            circleFitterStep.getClass();
            step.center = circleFitterStep.new CenterPoint(this.center.x, this.center.y);
            tPointArray[0] = step.center;
            step.points[1] = step.edge = new TPoint(this.edge.getX(), this.edge.getY());
            step.panelCircleHitShapes = new HashMap<Integer, Shape>();
            step.panelPointHitShapes = new ArrayList();
            step.dataPoints = new DataPoint[2][0];
            step.dataPoints[0] = new DataPoint[this.dataPoints[0].length];
            int i = 0;
            while (i < this.dataPoints[0].length) {
                DataPoint p = this.dataPoints[0][i];
                DataPoint[] dataPointArray = step.dataPoints[0];
                CircleFitterStep circleFitterStep2 = step;
                circleFitterStep2.getClass();
                dataPointArray[i] = circleFitterStep2.new DataPoint(p.x, p.y);
                ++i;
            }
        }
        return step;
    }

    public void copy(CircleFitterStep step) {
        if (this.dataPoints[0].length != step.dataPoints[0].length) {
            this.dataPoints[0] = new DataPoint[step.dataPoints[0].length];
            int i = 0;
            while (i < step.dataPoints[0].length) {
                DataPoint dataPoint;
                DataPoint next = step.dataPoints[0][i];
                DataPoint[] dataPointArray = this.dataPoints[0];
                if (next == null) {
                    dataPoint = null;
                } else {
                    CircleFitterStep circleFitterStep = this;
                    circleFitterStep.getClass();
                    dataPoint = circleFitterStep.new DataPoint(next.x, next.y);
                }
                dataPointArray[i] = dataPoint;
                ++i;
            }
        } else {
            int i = 0;
            while (i < step.dataPoints[0].length) {
                if (this.dataPoints[0][i] != null && step.dataPoints[0][i] != null) {
                    this.dataPoints[0][i].setLocation(step.dataPoints[0][i]);
                }
                ++i;
            }
        }
        this.defaultIndex = this.dataPoints[0].length - 1;
        this.refreshCircle();
    }

    @Override
    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.dataPoints[0].length) {
            s = String.valueOf(s) + "\n" + i + ": " + this.dataPoints[0][i];
            ++i;
        }
        return "CircleFitterStep " + this.n + " [center (" + this.center.x + ", " + this.center.y + "), radius " + this.radius + "]" + s;
    }

    public static int getLength() {
        return 3;
    }

    @Override
    protected void dispose() {
        this.panelCenterHitShapes.clear();
        this.panelCircleHitShapes.clear();
        for (Map<Integer, Shape> shapes : this.panelPointHitShapes) {
            shapes.clear();
        }
        this.panelPointHitShapes.clear();
        super.dispose();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class CenterPoint
    extends TPoint {
        public CenterPoint(double x, double y) {
            super(x, y);
        }

        @Override
        public void setXY(double x, double y) {
        }
    }

    class DataPoint
    extends TPoint {
        public DataPoint(double x, double y) {
            super(x, y);
            this.setStepEditTrigger(true);
        }

        @Override
        public void setXY(double x, double y) {
            if (CircleFitterStep.this.getTrack().locked) {
                return;
            }
            if (CircleFitterStep.this.circleFitter.isFixed()) {
                int row = 0;
                int j = 0;
                while (j < CircleFitterStep.this.dataPoints[0].length) {
                    if (this == CircleFitterStep.this.dataPoints[0][j]) {
                        row = j;
                        break;
                    }
                    ++j;
                }
                CircleFitterStep keyStep = (CircleFitterStep)CircleFitterStep.this.circleFitter.steps.getStep(0);
                while (keyStep.dataPoints[0].length <= row) {
                    CircleFitterStep circleFitterStep = keyStep;
                    circleFitterStep.getClass();
                    keyStep.addDataPoint(circleFitterStep.new DataPoint(0.0, 0.0), false);
                }
                keyStep.dataPoints[0][row].setLocation(x, y);
                if (doRefresh) {
                    keyStep.refreshCircle();
                }
                if (doRefresh) {
                    CircleFitterStep.this.circleFitter.refreshStep(CircleFitterStep.this);
                }
            } else {
                this.setLocation(x, y);
                if (!this.isAttached()) {
                    CircleFitterStep.this.circleFitter.keyFrames.add(CircleFitterStep.this.n);
                }
                if (doRefresh) {
                    CircleFitterStep.this.refreshCircle();
                }
            }
            if (doRefresh) {
                CircleFitterStep.this.circleFitter.refreshFields(CircleFitterStep.this.n);
            }
            CircleFitterStep.this.circleFitter.dataValid = false;
            if (doRefresh) {
                CircleFitterStep.this.circleFitter.firePropertyChange("data", null, CircleFitterStep.this.circleFitter);
            }
            if (CircleFitterStep.this.circleFitter.tp != null) {
                CircleFitterStep.this.circleFitter.tp.changed = true;
            }
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            if (!adjusting && !this.isAdjusting()) {
                return;
            }
            super.setAdjusting(adjusting, e);
            TTrack m = CircleFitterStep.this.getTrack();
            if (!adjusting) {
                m.firePropertyChange("step", null, new Integer(CircleFitterStep.this.n));
            }
        }

        @Override
        public void setScreenPosition(int x, int y, VideoPanel vidPanel, InputEvent e) {
            if (this.isAttached()) {
                return;
            }
            this.setScreenPosition(x, y, vidPanel);
        }

        @Override
        public String toString() {
            return "DataPoint " + CircleFitterStep.this.n + ": " + super.toString();
        }

        public Step getAttachedStep() {
            TTrack track = CircleFitterStep.this.getTrack();
            Step ret = null;
            if (this.attachedTo != null && track.tp != null) {
                ArrayList<PointMass> masses = track.tp.getDrawablesTemp(PointMass.class);
                int i = 0;
                int n = masses.size();
                while (i < n) {
                    PointMass m = masses.get(i);
                    Step step = m.getStep(this.attachedTo, track.tp);
                    if (step != null) {
                        ret = step;
                        break;
                    }
                    ++i;
                }
                masses.clear();
            }
            return ret;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            CircleFitterStep step = (CircleFitterStep)obj;
            DataPoint[] pts = step.dataPoints[0];
            double[][] pointData = new double[pts.length][2];
            int i = 0;
            while (i < pts.length) {
                DataPoint next = pts[i];
                double[] position = new double[]{next.x, next.y};
                pointData[i] = position;
                ++i;
            }
            control.setValue("datapoints", pointData);
            if (step.circleFitter != null && !step.circleFitter.isFixed()) {
                control.setValue("iskey", step.circleFitter.keyFrames.contains(step.n));
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            double[] position;
            int i;
            DataPoint[] pts;
            double[][] pointData;
            int diff;
            CircleFitterStep step = (CircleFitterStep)obj;
            if (step.circleFitter != null && step.circleFitter.isFixed() && step.n != 0) {
                step = (CircleFitterStep)step.circleFitter.getStep(0);
            }
            if (step.circleFitter != null && !step.circleFitter.isFixed()) {
                boolean isKey = control.getBoolean("iskey");
                if (isKey) {
                    step.circleFitter.keyFrames.add(step.n);
                } else {
                    step.circleFitter.keyFrames.remove(step.n);
                }
            }
            if ((diff = (pointData = (double[][])control.getObject("datapoints")).length - (pts = step.dataPoints[0]).length) < 0) {
                i = 0;
                while (i < -diff) {
                    DataPoint p = pts[pts.length - 1];
                    step.removeDataPoint(p, false, false);
                    ++i;
                }
                pts = step.dataPoints[0];
            } else if (diff > 0) {
                i = 0;
                while (i < diff) {
                    position = pointData[pointData.length - 1 - i];
                    CircleFitterStep circleFitterStep = step;
                    circleFitterStep.getClass();
                    step.addDataPoint(circleFitterStep.new DataPoint(position[0], position[1]), false);
                    ++i;
                }
                pts = step.dataPoints[0];
            }
            i = 0;
            while (i < pointData.length) {
                position = pointData[i];
                pts[i].setLocation(position[0], position[1]);
                ++i;
            }
            step.refreshCircle();
            if (step.circleFitter != null) {
                final CircleFitterStep cstep = step;
                Runnable runner = new Runnable(){

                    @Override
                    public void run() {
                        cstep.circleFitter.invalidateData(null);
                    }
                };
                SwingUtilities.invokeLater(runner);
            }
            return obj;
        }
    }
}

