/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;

public class CircleFootprint
implements Footprint,
Cloneable {
    protected static float plainStrokeSize = 1.0f;
    protected static float boldStrokeSize = 2.0f;
    protected String name;
    protected Ellipse2D circle = new Ellipse2D.Double();
    protected Ellipse2D center = new Ellipse2D.Double();
    protected Shape highlight;
    protected Shape outline;
    protected Shape spot;
    protected AffineTransform transform = new AffineTransform();
    protected int alpha = 0;
    protected Color color = new Color(0, 0, 0, this.alpha);
    protected Color highlightColor = Color.black;
    protected Shape[] hitShapes = new Shape[1];
    protected BasicStroke baseHighlightStroke;
    protected BasicStroke baseOutlineStroke;
    protected BasicStroke highlightStroke;
    protected BasicStroke outlineStroke;
    protected boolean outlined = true;
    protected boolean spotted;
    protected CircleDialog dialog;
    protected int r;
    protected int prevRadius;
    protected float prevStrokeSize;
    protected boolean prevSpot;
    private static Collection<Footprint> footprints = new HashSet<Footprint>();
    private static final CircleFootprint CIRCLE = new CircleFootprint("CircleFootprint.Circle", 4);
    private static final CircleFootprint FILLED_CIRCLE;

    static {
        footprints.add(CIRCLE);
        FILLED_CIRCLE = new CircleFootprint("CircleFootprint.FilledCircle", 8);
        FILLED_CIRCLE.setSpotShown(true);
        FILLED_CIRCLE.setAlpha(102);
        footprints.add(FILLED_CIRCLE);
    }

    public CircleFootprint(String name, int radius) {
        this.name = name;
        this.setRadius(radius);
        this.setStroke(new BasicStroke(1.0f));
        this.center.setFrame(-1.0, -1.0, 2.0, 2.0);
    }

    protected Object clone() throws CloneNotSupportedException {
        CircleFootprint clone = (CircleFootprint)super.clone();
        clone.circle = new Ellipse2D.Double();
        return clone;
    }

    public static Footprint getFootprint(String name) {
        for (CircleFootprint circleFootprint : footprints) {
            if (name != circleFootprint.getName()) continue;
            try {
                CircleFootprint fp = (CircleFootprint)circleFootprint.clone();
                return fp;
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        int realRadius = this.r;
        this.setRadius(this.outlined ? 5 : 6);
        MultiShape shape = this.getShape(new Point[]{new Point()}, 1);
        MultiShape decor = null;
        if (this.spotted) {
            decor = new MultiShape(this.spot).andFill(true);
        }
        if (this.outlined) {
            if (decor == null) {
                decor = new MultiShape(this.outline);
            } else {
                decor.addDrawShape(this.outline, this.outlineStroke);
            }
        }
        ShapeIcon icon = new ShapeIcon(shape, decor, w, h);
        icon.setColor(this.color, this.highlightColor);
        this.setRadius(realRadius);
        return new ResizableIcon(icon);
    }

    @Override
    public Mark getMark(Point[] points) {
        final MultiShape shape = this.getShape(points, FontSizer.getIntegerFactor());
        final Shape outline = this.outline;
        final Shape highlight = this.highlight;
        final Shape spot = this.spot;
        return new Mark(){

            @Override
            public void draw(Graphics2D g, boolean highlighted) {
                Paint gpaint = g.getPaint();
                Stroke gstroke = g.getStroke();
                if (OSPRuntime.setRenderingHints) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g.setPaint(CircleFootprint.this.color);
                shape.draw(g);
                g.setPaint(CircleFootprint.this.highlightColor);
                if (CircleFootprint.this.spotted) {
                    g.fill(spot);
                }
                if (CircleFootprint.this.outlined) {
                    g.setStroke(CircleFootprint.this.outlineStroke);
                    g.draw(outline);
                }
                if (highlighted) {
                    g.setStroke(CircleFootprint.this.highlightStroke);
                    g.draw(highlight);
                }
                g.setPaint(gpaint);
                g.setStroke(gstroke);
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.baseOutlineStroke = stroke;
        this.baseHighlightStroke = new BasicStroke(stroke.getLineWidth() + 1.0f);
    }

    @Override
    public BasicStroke getStroke() {
        return null;
    }

    @Override
    public void setColor(Color color) {
        this.color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
        this.highlightColor = new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public Color getColor() {
        return this.highlightColor;
    }

    public void setRadius(int radius) {
        this.r = radius;
        this.circle.setFrame(-this.r, -this.r, 2 * this.r, 2 * this.r);
    }

    public void setOutlined(boolean outline) {
        this.outlined = outline;
    }

    public void setSpotShown(boolean drawSpot) {
        this.spotted = drawSpot;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.setColor(this.color);
    }

    public String getProperties() {
        String s = String.valueOf(this.r) + " ";
        if (this.outlined) {
            s = String.valueOf(s) + "outline ";
        }
        if (this.spotted) {
            s = String.valueOf(s) + "spot ";
        }
        if (this.baseOutlineStroke.getLineWidth() > plainStrokeSize) {
            s = String.valueOf(s) + "bold ";
        }
        return s;
    }

    public void setProperties(String props) {
        if (props == null) {
            return;
        }
        int n = props.indexOf(" ");
        String radius = props.substring(0, n);
        try {
            this.setRadius(Integer.parseInt(radius));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setOutlined(props.indexOf("outline") > -1);
        this.setSpotShown(props.indexOf("spot") > -1);
        float f = props.indexOf("bold") > -1 ? boldStrokeSize : plainStrokeSize;
        this.setStroke(new BasicStroke(f));
    }

    public void showProperties(TTrack track) {
        if (this.dialog == null) {
            this.dialog = new CircleDialog(track);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.dialog.getBounds().width) / 2;
            int y = (dim.height - this.dialog.getBounds().height) / 2;
            this.dialog.setLocation(x, y);
        }
        this.dialog.boldCheckbox.setSelected(this.baseOutlineStroke.getLineWidth() > plainStrokeSize);
        this.dialog.spotCheckbox.setSelected(this.spotted);
        this.dialog.spinner.setValue(this.r);
        this.prevSpot = this.spotted;
        this.prevStrokeSize = this.baseOutlineStroke.getLineWidth();
        this.prevRadius = this.r;
        this.dialog.setVisible(true);
    }

    public void showProperties(TFrame frame, ActionListener listener) {
        if (this.dialog == null) {
            this.dialog = new CircleDialog(frame, listener);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - this.dialog.getBounds().width) / 2;
            int y = (dim.height - this.dialog.getBounds().height) / 2;
            this.dialog.setLocation(x, y);
        }
        this.dialog.boldCheckbox.setSelected(this.baseOutlineStroke.getLineWidth() > plainStrokeSize);
        this.dialog.spotCheckbox.setSelected(this.spotted);
        this.dialog.spinner.setValue(this.r);
        this.prevSpot = this.spotted;
        this.prevStrokeSize = this.baseOutlineStroke.getLineWidth();
        this.prevRadius = this.r;
        this.dialog.setVisible(true);
    }

    @Override
    public MultiShape getShape(Point[] points, int scale) {
        Point p = points[0];
        this.transform.setToTranslation(p.x, p.y);
        if (scale > 1) {
            this.transform.scale(scale, scale);
        }
        Shape c = this.transform.createTransformedShape(this.circle);
        if (this.outlineStroke == null || this.outlineStroke.getLineWidth() != (float)scale * this.baseOutlineStroke.getLineWidth()) {
            this.outlineStroke = new BasicStroke((float)scale * this.baseOutlineStroke.getLineWidth());
            this.highlightStroke = new BasicStroke((float)scale * this.baseHighlightStroke.getLineWidth());
        }
        this.highlight = this.transform.createTransformedShape(this.circle);
        this.outline = this.transform.createTransformedShape(this.circle);
        this.hitShapes[0] = this.spot = this.transform.createTransformedShape(this.center);
        return new MultiShape(c).andFill(true);
    }

    private class CircleDialog
    extends JDialog {
        private Integer panelID;
        int trackID;
        JSpinner spinner;
        JLabel spinnerLabel;
        JButton okButton;
        JButton cancelButton;
        JCheckBox boldCheckbox;
        JCheckBox spotCheckbox;
        ActionListener actionListener;

        public CircleDialog(TTrack track) {
            this(track.tframe, null);
            this.trackID = track.getID();
            this.panelID = track.tp.getID();
        }

        public CircleDialog(TFrame frame, ActionListener listener) {
            super((Frame)frame, true);
            this.actionListener = listener;
            this.setTitle(TrackerRes.getString("CircleFootprint.Dialog.Title"));
            this.setResizable(false);
            this.setDefaultCloseOperation(1);
            this.createGUI();
            this.pack();
            this.okButton.requestFocusInWindow();
        }

        void createGUI() {
            JPanel contentPane = new JPanel(new BorderLayout());
            this.setContentPane(contentPane);
            JPanel upper = new JPanel();
            upper.setBorder(BorderFactory.createEtchedBorder());
            contentPane.add((Component)upper, "North");
            this.spinnerLabel = new JLabel(TrackerRes.getString("CircleFootprint.Dialog.Label.Radius"));
            this.spinnerLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            upper.add(this.spinnerLabel);
            this.spinner = new JSpinner(new SpinnerNumberModel(3, 3, 100, 1));
            JFormattedTextField tf = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
            tf.setEnabled(false);
            tf.setDisabledTextColor(Color.BLACK);
            ChangeListener listener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int radius = (Integer)CircleDialog.this.spinner.getValue();
                    if (radius == ((CircleDialog)CircleDialog.this).CircleFootprint.this.r) {
                        return;
                    }
                    CircleFootprint.this.setRadius(radius);
                    if (CircleDialog.this.panelID != null) {
                        TTrack track = TTrack.getTrack(CircleDialog.this.trackID);
                        track.tp.changed = true;
                        track.repaint();
                    } else if (CircleDialog.this.actionListener != null) {
                        CircleDialog.this.actionListener.actionPerformed(null);
                    }
                }
            };
            this.spinner.addChangeListener(listener);
            upper.add(this.spinner);
            this.boldCheckbox = new JCheckBox(TrackerRes.getString("CircleFootprint.Dialog.Checkbox.Bold"));
            this.boldCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
            this.boldCheckbox.setOpaque(false);
            this.boldCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    float f = CircleDialog.this.boldCheckbox.isSelected() ? boldStrokeSize : plainStrokeSize;
                    CircleFootprint.this.setStroke(new BasicStroke(f));
                    if (CircleDialog.this.panelID != null) {
                        TTrack track = TTrack.getTrack(CircleDialog.this.trackID);
                        track.tp.changed = true;
                        track.repaint();
                    } else if (CircleDialog.this.actionListener != null) {
                        CircleDialog.this.actionListener.actionPerformed(null);
                    }
                }
            });
            upper.add(this.boldCheckbox);
            this.spotCheckbox = new JCheckBox(TrackerRes.getString("CircleFootprint.Dialog.Checkbox.CenterSpot"));
            this.spotCheckbox.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.spotCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CircleFootprint.this.setSpotShown(CircleDialog.this.spotCheckbox.isSelected());
                    if (CircleDialog.this.panelID != null) {
                        TTrack track = TTrack.getTrack(CircleDialog.this.trackID);
                        track.tp.changed = true;
                        track.repaint();
                    } else if (CircleDialog.this.actionListener != null) {
                        CircleDialog.this.actionListener.actionPerformed(null);
                    }
                }
            });
            upper.add(this.spotCheckbox);
            JPanel lower = new JPanel();
            contentPane.add((Component)lower, "South");
            this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CircleDialog.this.setVisible(false);
                    if (CircleDialog.this.panelID != null) {
                        TTrack track = TTrack.getTrack(CircleDialog.this.trackID);
                        track.setFootprint(CircleFootprint.this.getName());
                    }
                }
            });
            lower.add(this.okButton);
            this.cancelButton = new JButton(TrackerRes.getString("Dialog.Button.Cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CircleFootprint.this.setSpotShown(((CircleDialog)CircleDialog.this).CircleFootprint.this.prevSpot);
                    CircleFootprint.this.setStroke(new BasicStroke(((CircleDialog)CircleDialog.this).CircleFootprint.this.prevStrokeSize));
                    CircleFootprint.this.setRadius(((CircleDialog)CircleDialog.this).CircleFootprint.this.prevRadius);
                    if (CircleDialog.this.panelID != null) {
                        TTrack track = TTrack.getTrack(CircleDialog.this.trackID);
                        track.repaint();
                    } else if (CircleDialog.this.actionListener != null) {
                        CircleDialog.this.actionListener.actionPerformed(null);
                    }
                    CircleDialog.this.setVisible(false);
                }
            });
            lower.add(this.cancelButton);
        }
    }
}

