/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.OSPRuntime;

class ClipboardListener
extends Thread
implements ClipboardOwner {
    private Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
    private TFrame frame;
    private boolean running = true;
    private Integer targetPanelID;

    public ClipboardListener(TFrame frame) {
        this.frame = frame;
    }

    @Override
    public void start() {
        super.start();
        Transferable contents = this.sysClip.getContents(this);
        this.processContents(contents);
    }

    @Override
    public void run() {
        Transferable trans = this.sysClip.getContents(this);
        this.takeOwnership(trans);
        while (this.running) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard c, Transferable t) {
        if (!this.running) {
            return;
        }
        boolean success = false;
        while (!success) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Transferable contents = this.sysClip.getContents(this);
                this.processContents(contents);
                success = true;
                this.takeOwnership(contents);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void processContents(TrackerPanel target) {
        this.targetPanelID = target.getID();
        this.processContents(this.sysClip.getContents(this));
    }

    public void processContents(Transferable t) {
        if (TrackerIO.dataCopiedToClipboard) {
            TrackerIO.dataCopiedToClipboard = false;
            return;
        }
        if (t == null) {
            return;
        }
        try {
            this.processContents((String)t.getTransferData(OSPRuntime.isJS ? DataFlavor.plainTextFlavor : DataFlavor.stringFlavor));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void processContents(String dataString) throws Exception {
        if (dataString != null) {
            TrackerPanel trackerPanel;
            if (this.targetPanelID == null) {
                trackerPanel = this.frame.getSelectedPanel();
            } else {
                trackerPanel = this.frame.getTrackerPanelForID(this.targetPanelID);
                this.targetPanelID = null;
            }
            if (trackerPanel == null) {
                return;
            }
            trackerPanel.doAutoPaste(dataString);
        }
    }

    public void takeOwnership(Transferable t) {
        this.sysClip.setContents(t, this);
    }

    public void end() {
        this.running = false;
    }
}

