/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.CoordAxesStep;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldGrid;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public class CoordAxes
extends TTrack {
    protected static final Icon gridOptionsIcon = Tracker.getResourceIcon("restore.gif", true);
    protected static final String[] dataVariables = new String[]{"x", "y", Tracker.THETA};
    protected static final String[] formatVariables = new String[]{"pixel", Tracker.THETA};
    protected static final Map<String, String[]> formatMap = new HashMap<String, String[]>();
    protected static final Map<String, String> formatDescriptionMap;
    protected static final ArrayList<String> allVariables;
    protected boolean notyetShown = true;
    protected JLabel originLabel;
    protected WorldGrid grid;
    protected JCheckBox gridCheckbox;
    protected TButton gridButton;
    protected Component gridSeparator;
    protected boolean gridVisible;

    static {
        formatMap.put("pixel", new String[]{"x", "y"});
        formatMap.put(Tracker.THETA, new String[]{Tracker.THETA});
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("CoordAxes.Origin.Label"));
        formatDescriptionMap.put(formatVariables[1], TrackerRes.getString("CoordAxes.Label.Angle"));
        allVariables = CoordAxes.createAllVariables(dataVariables, null);
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "CoordAxes";
    }

    @Override
    public String getVarDimsImpl(String variable) {
        return "P";
    }

    public CoordAxes() {
        super(2);
        this.defaultColors = new Color[]{new Color(200, 0, 200)};
        this.setName(TrackerRes.getString("CoordAxes.New.Name"));
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.BoldSimpleAxes"), PointShapeFootprint.getFootprint("Footprint.SimpleAxes")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.setViewable(false);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("CoordAxes.Hint");
        CoordAxesStep step = new CoordAxesStep(this, 0);
        step.setFootprint(this.getFootprint());
        this.steps.setStep(0, step);
        this.angleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CoordAxes.this.tp == null) {
                    return;
                }
                double theta = CoordAxes.this.angleField.getValue();
                int n = CoordAxes.this.tp.getFrameNumber();
                CoordAxesStep step = (CoordAxesStep)CoordAxes.this.getStep(n);
                TPoint origin = step.getOrigin();
                TPoint handle = step.getHandle();
                double d = origin.distance(handle);
                double x = origin.getX() + d * Math.cos(theta);
                double y = origin.getY() - d * Math.sin(theta);
                handle.setXY(x, y);
                CoordAxes.this.angleField.setValue(CoordAxes.this.tp.getCoords().getAngle(n));
                CoordAxes.this.angleField.requestFocusInWindow();
            }
        });
        this.angleField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (CoordAxes.this.tp == null) {
                    return;
                }
                double theta = CoordAxes.this.angleField.getValue();
                int n = CoordAxes.this.tp.getFrameNumber();
                CoordAxesStep step = (CoordAxesStep)CoordAxes.this.getStep(n);
                TPoint origin = step.getOrigin();
                TPoint handle = step.getHandle();
                double d = origin.distance(handle);
                double x = origin.getX() + d * Math.cos(theta);
                double y = origin.getY() - d * Math.sin(theta);
                handle.setXY(x, y);
                CoordAxes.this.angleField.setValue(CoordAxes.this.tp.getCoords().getAngle(n));
            }
        });
        this.originLabel = new JLabel();
        final AbstractAction setOriginAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CoordAxes.this.tp == null) {
                    return;
                }
                double x = CoordAxes.this.xField.getValue();
                double y = CoordAxes.this.yField.getValue();
                ImageCoordSystem coords = CoordAxes.this.tp.getCoords();
                int n = CoordAxes.this.tp.getFrameNumber();
                coords.setOriginXY(n, x, y);
                CoordAxes.this.xField.setValue(coords.getOriginX(n));
                CoordAxes.this.yField.setValue(coords.getOriginY(n));
                CoordAxesStep step = (CoordAxesStep)CoordAxes.this.getStep(n);
                TPoint handle = step.getHandle();
                if (handle == CoordAxes.this.tp.getSelectedPoint()) {
                    CoordAxes.this.tp.setSelectedPoint(null);
                    CoordAxes.this.tp.selectedSteps.clear();
                }
            }
        };
        this.xField.addActionListener(setOriginAction);
        this.yField.addActionListener(setOriginAction);
        this.xField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                setOriginAction.actionPerformed(null);
            }
        });
        this.yField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                setOriginAction.actionPerformed(null);
            }
        });
        this.grid = new WorldGrid();
        this.grid.setVisible(this.gridVisible);
        this.gridSeparator = Box.createRigidArea(new Dimension(4, 4));
        this.gridCheckbox = new JCheckBox();
        this.gridCheckbox.setBorder(BorderFactory.createEmptyBorder());
        this.gridCheckbox.setOpaque(false);
        this.gridCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordAxes.this.setGridVisible(CoordAxes.this.gridCheckbox.isSelected());
            }
        });
        this.gridButton = new TButton(gridOptionsIcon){

            @Override
            public Dimension getMaximumSize() {
                Dimension dim = super.getMaximumSize();
                dim.height = CoordAxes.this.tp.getTrackBar((boolean)true).toolbarComponentHeight;
                return dim;
            }

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem colorItem = new JMenuItem(TrackerRes.getString("CoordAxes.MenuItem.GridColor"));
                colorItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!(this).CoordAxes.this.grid.isVisible()) {
                            (this).CoordAxes.this.gridCheckbox.doClick(0);
                        }
                        Color color = (this).CoordAxes.this.grid.getColor();
                        OSPRuntime.chooseColor(color, TrackerRes.getString("CoordAxes.Dialog.GridColor.Title"), newColor -> {
                            if (newColor != color) {
                                (this).CoordAxes.this.grid.setColor((Color)newColor);
                                CoordAxes.this.repaintAll();
                            }
                        });
                    }
                });
                popup.add(colorItem);
                JMenuItem transparencyItem = new JMenuItem(TrackerRes.getString("CoordAxes.MenuItem.GridOpacity"));
                transparencyItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!(this).CoordAxes.this.grid.isVisible()) {
                            (this).CoordAxes.this.gridCheckbox.doClick(0);
                        }
                        int alpha = (this).CoordAxes.this.grid.getAlpha();
                        final JSlider slider = new JSlider(0, 255, alpha);
                        slider.setMaximum(255);
                        slider.setMinimum(0);
                        slider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
                        slider.addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent e) {
                                ((this).this).CoordAxes.this.grid.setAlpha(slider.getValue());
                                int i = 0;
                                while (i < ((this).this).CoordAxes.this.tp.andWorld.size()) {
                                    CoordAxes.this.panel(((this).this).CoordAxes.this.tp.andWorld.get(i)).repaint();
                                    ++i;
                                }
                            }
                        });
                        int response = JOptionPane.showConfirmDialog((this).CoordAxes.this.tp, slider, TrackerRes.getString("CoordAxes.Dialog.GridOpacity.Title"), 2, -1);
                        if (response == 2) {
                            (this).CoordAxes.this.grid.setAlpha(alpha);
                            int i = 0;
                            while (i < (this).CoordAxes.this.tp.andWorld.size()) {
                                CoordAxes.this.panel((this).CoordAxes.this.tp.andWorld.get(i)).repaint();
                                ++i;
                            }
                        }
                    }
                });
                popup.add(transparencyItem);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                return popup;
            }
        };
    }

    public TPoint getOrigin() {
        return ((CoordAxesStep)this.getStep(0)).getOrigin();
    }

    @Override
    public boolean isLocked() {
        boolean locked = super.isLocked();
        if (this.tp != null) {
            locked = locked || this.tp.getCoords().isLocked();
        }
        return locked;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.notyetShown = false;
            if (this.grid != null) {
                this.grid.setVisible(this.gridVisible);
            }
            if (this.tp != null && this.tp.autoTracker != null && this.tp.autoTracker.getTrack() == null) {
                this.tp.autoTracker.setTrack(this);
            }
        } else if (this.grid != null) {
            this.grid.setVisible(false);
        }
    }

    public void setGridVisible(boolean visible) {
        if (this.gridVisible == visible) {
            return;
        }
        this.gridVisible = visible;
        this.grid.setVisible(this.gridVisible);
        this.gridCheckbox.setSelected(this.gridVisible);
        if (this.tp != null) {
            this.repaintAll();
        }
    }

    @Override
    public void setTrailVisible(boolean visible) {
    }

    @Override
    public Step createStep(int n, double x, double y) {
        Step step = this.getStep(0);
        if (this.tp.getSelectedPoint() instanceof CoordAxesStep.Handle) {
            ((CoordAxesStep)step).getHandle().setXY(x, y);
        } else {
            ((CoordAxesStep)step).getOrigin().setXY(x, y);
        }
        return step;
    }

    @Override
    public Step deleteStep(int n) {
        return null;
    }

    @Override
    public Step getStep(int n) {
        Step step = this.steps.getStep(0);
        step.erase();
        return step;
    }

    @Override
    public int getStepLength() {
        return CoordAxesStep.getLength();
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    protected boolean isAutoTrackable(int pointIndex) {
        return true;
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        if (pointIndex == 0) {
            return TrackerRes.getString("CoordAxes.Origin.Name");
        }
        return TrackerRes.getString("CoordAxes.Handle.Name");
    }

    @Override
    public TPoint autoMarkAt(int n, double x, double y) {
        ImageCoordSystem coords = this.tp.getCoords();
        if (this.getTargetIndex() == 0) {
            if (coords.isFixedOrigin()) {
                coords.setFixedOrigin(false);
            }
            this.getOrigin().setXY(x, y);
        } else {
            if (coords.isFixedAngle()) {
                coords.setFixedAngle(false);
            }
            TPoint handle = ((CoordAxesStep)this.getStep(0)).getHandle();
            handle.setXY(x, y);
        }
        this.firePropertyChange("step", null, n);
        return this.getMarkedPoint(n, this.getTargetIndex());
    }

    @Override
    public TPoint getMarkedPoint(int n, int index) {
        if (index == 0) {
            return new OriginPoint(n);
        }
        TPoint handle = ((CoordAxesStep)this.getStep(0)).getHandle();
        return new AnglePoint(handle.getX(), handle.getY(), n);
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof TrackerPanel && this.isVisible() && this.isEnabled())) {
            return null;
        }
        ImageCoordSystem coords = ((TrackerPanel)panel).getCoords();
        if (coords instanceof ReferenceFrame) {
            return null;
        }
        Interactive ia = this.getStep(0).findInteractive(this.tp, xpix, ypix);
        if (ia == null) {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = TrackerRes.getString("CoordAxes.Hint");
            return null;
        }
        if (ia instanceof CoordAxesStep.Handle) {
            this.partName = TrackerRes.getString("CoordAxes.Handle.Name");
            this.hint = TrackerRes.getString("CoordAxes.Handle.Hint");
        } else {
            this.partName = TrackerRes.getString("CoordAxes.Origin.Name");
            this.hint = TrackerRes.getString("CoordAxes.Origin.Hint");
        }
        return ia;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.removeDeleteTrackItem(menu);
        this.lockedItem.setEnabled(!trackerPanel.getCoords().isLocked());
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        int n = trackerPanel.getFrameNumber();
        ImageCoordSystem coords = trackerPanel.getCoords();
        this.originLabel.setText(TrackerRes.getString("CoordAxes.Origin.Label"));
        this.xLabel.setText(dataVariables[0]);
        this.yLabel.setText(dataVariables[1]);
        this.xField.setToolTipText(TrackerRes.getString("CoordAxes.Origin.Field.Tooltip"));
        this.yField.setToolTipText(TrackerRes.getString("CoordAxes.Origin.Field.Tooltip"));
        this.gridCheckbox.setText(TrackerRes.getString("CoordAxes.Checkbox.Grid"));
        this.gridCheckbox.setToolTipText(TrackerRes.getString("CoordAxes.Checkbox.Grid.Tooltip"));
        this.gridButton.setToolTipText(TrackerRes.getString("CoordAxes.Button.Grid.Tooltip"));
        list.add(this.gridSeparator);
        list.add(this.gridCheckbox);
        list.add(this.gridButton);
        list.add(this.magSeparator);
        list.add(this.originLabel);
        list.add(this.xSeparator);
        list.add(this.xLabel);
        list.add(this.xField);
        list.add(this.ySeparator);
        list.add(this.yLabel);
        list.add(this.yField);
        this.xField.setValue(coords.getOriginX(n));
        this.yField.setValue(coords.getOriginY(n));
        this.angleLabel.setText(TrackerRes.getString("CoordAxes.Label.Angle"));
        list.add(this.stepSeparator);
        list.add(this.angleLabel);
        list.add(this.angleField);
        this.angleField.setValue(coords.getAngle(n));
        this.xField.setEnabled(!this.isLocked());
        this.yField.setEnabled(!this.isLocked());
        this.angleField.setEnabled(!this.isLocked());
        return list;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "stepnumber": {
                int n = this.tp.getFrameNumber();
                ImageCoordSystem coords = this.tp.getCoords();
                this.angleField.setValue(coords.getAngle(n));
                this.xField.setValue(coords.getOriginX(n));
                this.yField.setValue(coords.getOriginY(n));
                break;
            }
            case "transform": {
                if (this.tp.getSelectedTrack() == this) {
                    int n = this.tp.getFrameNumber();
                    ImageCoordSystem coords = this.tp.getCoords();
                    this.angleField.setValue(coords.getAngle(n));
                    this.xField.setValue(coords.getOriginX(n));
                    this.yField.setValue(coords.getOriginY(n));
                }
            }
            default: {
                super.propertyChange(e);
            }
        }
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        FontSizer.setFont(this.originLabel);
        FontSizer.setFont(this.gridCheckbox);
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        this.numberFields.clear();
        this.numberFields.put(dataVariables[0], new NumberField[]{this.xField});
        this.numberFields.put(dataVariables[1], new NumberField[]{this.yField});
        this.numberFields.put(dataVariables[2], new NumberField[]{this.angleField});
        return this.numberFields;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected class AnglePoint
    extends TPoint {
        int frameNum;

        public AnglePoint(double x, double y, int n) {
            super(x, y);
            this.frameNum = n;
        }

        public double getAngle() {
            return -CoordAxes.this.getOrigin().angle(this);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            XML.getLoader(TTrack.class).saveObject(control, obj);
            CoordAxes axes = (CoordAxes)obj;
            if (axes.gridVisible) {
                control.setValue("grid_visible", true);
            }
            if (axes.grid.isCustom()) {
                control.setValue("grid_alpha", axes.grid.getAlpha());
                control.setValue("grid_RGB", axes.grid.getColor().getRGB());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new CoordAxes();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            XML.getLoader(TTrack.class).loadObject(control, obj);
            CoordAxes axes = (CoordAxes)obj;
            axes.notyetShown = false;
            if (control.getPropertyNamesRaw().contains("grid_visible")) {
                axes.setGridVisible(control.getBoolean("grid_visible"));
            }
            if (control.getPropertyNamesRaw().contains("grid_alpha")) {
                axes.grid.setAlpha(control.getInt("grid_alpha"));
            }
            if (control.getPropertyNamesRaw().contains("grid_RGB")) {
                Color color = new Color(control.getInt("grid_RGB"));
                axes.grid.setColor(color);
            }
            return obj;
        }
    }

    protected class OriginPoint
    extends TPoint {
        int frameNum;

        OriginPoint(int n) {
            this.frameNum = n;
        }

        @Override
        public double getX() {
            ImageCoordSystem coords = CoordAxes.this.tp.getCoords();
            return coords.getOriginX(this.frameNum);
        }

        @Override
        public double getY() {
            ImageCoordSystem coords = CoordAxes.this.tp.getCoords();
            return coords.getOriginY(this.frameNum);
        }
    }
}

