/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class CoordAxesStep
extends Step {
    private Origin origin;
    private Handle handle;
    private boolean originEnabled = true;
    private boolean handleEnabled = true;
    private Map<Integer, Shape> panelHandleShapes = new HashMap<Integer, Shape>();
    private GeneralPath path = new GeneralPath();

    public CoordAxesStep(CoordAxes track, int n) {
        super(track, n);
        this.origin = new Origin();
        this.origin.setCoordsEditTrigger(true);
        this.handle = new Handle();
        this.handle.setCoordsEditTrigger(true);
        this.points = new TPoint[]{this.origin, this.handle};
        this.screenPoints = new Point[1];
    }

    public TPoint getOrigin() {
        return this.origin;
    }

    public TPoint getHandle() {
        return this.handle;
    }

    public void setOriginEnabled(boolean enabled) {
        this.originEnabled = enabled;
    }

    public boolean isOriginEnabled() {
        return this.originEnabled;
    }

    public void setHandleEnabled(boolean enabled) {
        this.handleEnabled = enabled;
    }

    public boolean isHandleEnabled() {
        return this.handleEnabled;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Shape hitShape;
        AutoTracker autoTracker;
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        this.setHitRectCenter(xpix, ypix);
        TTrack track = this.getTrack();
        AutoTracker autoTracker2 = autoTracker = track.tp == null ? null : track.tp.getAutoTracker(false);
        if (this.handleEnabled && (hitShape = this.panelHandleShapes.get(trackerPanel.getID())) != null && hitShape.intersects(hitRect)) {
            this.handle.setPositionOnLine(xpix, ypix, trackerPanel);
            return autoTracker != null && autoTracker.getTrack() == track && track.getTargetIndex() == 1 && autoTracker.isOnKeyFrame(track.tp) ? null : this.handle;
        }
        if (this.originEnabled && !track.isLocked() && super.findInteractive(panel, xpix, ypix) == this.origin) {
            return autoTracker != null && autoTracker.getTrack() == track && track.getTargetIndex() == 0 && autoTracker.isOnKeyFrame(track.tp) ? null : this.origin;
        }
        return null;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        AutoTracker autoTracker;
        TTrack track = this.getTrack();
        if (track.tp == panel && (autoTracker = track.tp.getAutoTracker(false)) != null && autoTracker.isInteracting(track)) {
            return;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Graphics2D g = (Graphics2D)_g;
        this.getMark(trackerPanel).draw(g, false);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        if (mark == null) {
            TPoint selection = trackerPanel.getSelectedPoint();
            ImageCoordSystem coords = trackerPanel.getCoords();
            int n = trackerPanel.getFrameNumber();
            TTrack track = this.getTrack();
            if (track.tp != null) {
                n = track.tp.getFrameNumber();
            }
            double x = coords.getOriginX(n);
            double y = coords.getOriginY(n);
            if (Double.isNaN(x) || Double.isNaN(y)) {
                x = trackerPanel.getImageWidth() / 2.0;
                y = trackerPanel.getImageHeight() / 2.0;
                coords.setOriginXY(n, x, y);
            }
            this.origin.setLocation(x, y);
            Point p0 = this.screenPoints[0] = this.origin.getScreenPosition(trackerPanel);
            MultiShape axesShape = this.footprint.getShape(this.screenPoints, FontSizer.getIntegerFactor());
            this.path.reset();
            this.path.moveTo(p0.x + 15, p0.y);
            this.path.lineTo(p0.x + 500, p0.y);
            Shape hitShape = this.path;
            if (trackerPanel.isDrawingInImageSpace()) {
                double angle = coords.getAngle(n);
                transform.setToRotation(-angle, p0.x, p0.y);
                axesShape = axesShape.transform(transform);
                hitShape = transform.createTransformedShape(hitShape);
            }
            this.panelHandleShapes.put(trackerPanel.getID(), hitShape);
            int scale = FontSizer.getIntegerFactor();
            Shape selectedShape = null;
            if (selection == this.origin) {
                transform.setToTranslation(p0.x, p0.y);
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                selectedShape = transform.createTransformedShape(selectionShape);
            } else if (selection == this.handle) {
                Point p1 = this.handle.getScreenPosition(trackerPanel);
                transform.setToTranslation(p1.x, p1.y);
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                selectedShape = transform.createTransformedShape(selectionShape);
            }
            final Color color = this.footprint.getColor();
            final MultiShape shape = selectedShape == null ? new MultiShape(axesShape).andFill(true) : new MultiShape(axesShape, selectedShape).andFill(true).andStroke(null, selectionStroke);
            final CoordAxes axes = (CoordAxes)track;
            final Mark gridMark = axes.grid.getMark(trackerPanel);
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.setPaint(color);
                    if (OSPRuntime.setRenderingHints) {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    if (axes.gridVisible) {
                        gridMark.draw(g2, false);
                    }
                    shape.draw(g2);
                    g2.dispose();
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
        }
        return mark;
    }

    @Override
    public int getPointIndex(TPoint p) {
        int i = super.getPointIndex(p);
        if (i == -1) {
            if (p instanceof CoordAxes.OriginPoint) {
                return 0;
            }
            if (p instanceof CoordAxes.AnglePoint) {
                return 1;
            }
        }
        return i;
    }

    @Override
    public Object clone() {
        CoordAxesStep step = (CoordAxesStep)super.clone();
        if (step != null) {
            step.panelHandleShapes = new HashMap<Integer, Shape>();
        }
        return step;
    }

    @Override
    public String toString() {
        return "CoordAxesStep " + this.n;
    }

    public static int getLength() {
        return 2;
    }

    @Override
    protected void dispose() {
        this.panelHandleShapes.clear();
        super.dispose();
    }

    class Handle
    extends TPoint {
        private double angleIncrement = 0.0;
        protected Point2D.Double p = new Point2D.Double();

        Handle() {
        }

        @Override
        public void setXY(double x, double y) {
            TTrack track = CoordAxesStep.this.getTrack();
            if (track.isLocked()) {
                return;
            }
            CoordAxes coordAxes = (CoordAxes)track;
            if (coordAxes.tp == null) {
                super.setXY(x, y);
                return;
            }
            if (this.angleIncrement >= Math.PI / 180) {
                this.p.setLocation(x, y);
                double d = CoordAxesStep.this.origin.distance(this.p);
                double theta = CoordAxesStep.this.origin.angle(this.p);
                int i = Math.round((float)(theta / this.angleIncrement));
                theta = (double)i * this.angleIncrement;
                x = CoordAxesStep.this.origin.getX() + d * Math.cos(theta);
                y = CoordAxesStep.this.origin.getY() + d * Math.sin(theta);
            }
            if (this.isAdjusting()) {
                this.prevX = x;
                this.prevY = y;
            }
            super.setXY(x, y);
            double cos = CoordAxesStep.this.origin.cos(this);
            double sin = CoordAxesStep.this.origin.sin(this);
            ImageCoordSystem coords = coordAxes.tp.getCoords();
            coords.setAdjusting(this.isAdjusting());
            int n = coordAxes.tp.getFrameNumber();
            coords.setCosineSine(n, cos, sin);
            coordAxes.angleField.setValue(coords.getAngle(n));
            this.angleIncrement = 0.0;
            if (this.isAdjusting()) {
                CoordAxesStep.this.repaint();
            }
        }

        @Override
        public void setScreenPosition(int x, int y, VideoPanel vidPanel, InputEvent e) {
            this.angleIncrement = e == null ? 0.0 : (e.isShiftDown() ? 0.08726646259971647 : 0.0);
            this.setScreenPosition(x, y, vidPanel);
        }

        @Override
        public void showCoordinates(VideoPanel vidPanel) {
            TrackerPanel trackerPanel;
            if (vidPanel instanceof TrackerPanel && this != (trackerPanel = (TrackerPanel)vidPanel).getSelectedPoint()) {
                this.setLocation(vidPanel.getMouseX(), vidPanel.getMouseY());
                Point2D p = this.getWorldPosition(vidPanel);
                p.setLocation(p.getX(), 0.0);
                int n = vidPanel.getFrameNumber();
                AffineTransform toImage = vidPanel.getCoords().getToImageTransform(n);
                toImage.transform(p, p);
                this.setLocation(p);
            }
            super.showCoordinates(vidPanel);
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            boolean wasAdjusting = this.isAdjusting();
            super.setAdjusting(adjusting, e);
            if (wasAdjusting && !adjusting && !Double.isNaN(this.prevX)) {
                if (e != null && e.getID() != 502) {
                    if (this.prevX == 0.0 && this.prevY == 0.0) {
                        this.angleIncrement = 0.3490658503988659;
                        this.setScreenPosition(e.getX(), e.getY(), CoordAxesStep.this.getTrack().tp);
                    }
                } else {
                    this.setXY(this.prevX, this.prevY);
                    TTrack track = CoordAxesStep.this.getTrack();
                    track.firePropertyChange("step", null, track.tp.getFrameNumber());
                }
            }
        }

        public void setPositionOnLine(int xScreen, int yScreen, TrackerPanel trackerPanel) {
            double d = 100.0;
            double theta = trackerPanel.getCoords().getAngle(trackerPanel.getFrameNumber());
            this.p.setLocation(((CoordAxesStep)CoordAxesStep.this).origin.x + d * Math.cos(theta), ((CoordAxesStep)CoordAxesStep.this).origin.y - d * Math.sin(theta));
            TPoint endPt = new TPoint(this.p);
            this.setPositionOnLine(xScreen, yScreen, trackerPanel, CoordAxesStep.this.origin, endPt);
            CoordAxesStep.this.repaint();
        }
    }

    class Origin
    extends TPoint {
        Origin() {
        }

        @Override
        public void setXY(double x, double y) {
            CoordAxes axes = (CoordAxes)CoordAxesStep.this.getTrack();
            if (axes.isLocked()) {
                return;
            }
            if (this.isAdjusting()) {
                this.prevX = x;
                this.prevY = y;
            }
            super.setXY(x, y);
            TrackerPanel panel = axes.tp;
            if (panel != null) {
                ImageCoordSystem coords = panel.getCoords();
                coords.setAdjusting(this.isAdjusting());
                int n = panel.getFrameNumber();
                coords.setOriginXY(n, x, y);
                axes.xField.setValue(coords.getOriginX(n));
                axes.yField.setValue(coords.getOriginY(n));
            }
            if (this.isAdjusting()) {
                CoordAxesStep.this.repaint();
            }
        }

        @Override
        public double getX() {
            return super.getX();
        }

        @Override
        public void setAdjusting(boolean adjusting, MouseEvent e) {
            boolean wasAdjusting = this.isAdjusting();
            if (wasAdjusting == adjusting) {
                return;
            }
            super.setAdjusting(adjusting, e);
            if (!wasAdjusting) {
                this.prevX = this.x;
                this.prevY = this.y;
            } else if (!Double.isNaN(this.prevX)) {
                this.setXY(this.prevX, this.prevY);
                TTrack track = CoordAxesStep.this.getTrack();
                track.firePropertyChange("step", null, track.tp.getFrameNumber());
            }
        }
    }
}

