/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.ModelBuilder;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.DataClip;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.numerics.Util;
import org.opensourcephysics.tools.FontSizer;

public class DataTrackClipControl
extends JPanel
implements PropertyChangeListener {
    static Color videoColor;
    static Color dataColor;
    static Color dataClipColor;
    static Color unavailableDataColor;
    static Color availableDataColor;
    static int graphicHeight;
    protected DataTrack dataTrack;
    protected DrawingPanel drawingPanel;
    protected JPanel spinnerPanel;
    protected Interactive mappingGraphic;
    protected JLabel videoInLabel;
    protected JLabel dataInLabel;
    protected JLabel dataClipLengthLabel;
    protected JLabel dataStrideLabel;
    protected JSpinner videoInSpinner;
    protected JSpinner dataInSpinner;
    protected JSpinner dataClipLengthSpinner;
    protected JSpinner dataStrideSpinner;
    protected boolean refreshing;
    protected boolean drawVideoClip = false;
    protected ParticleDataTrack particleDT;

    static {
        dataColor = videoColor = Color.WHITE;
        dataClipColor = new Color(51, 200, 51);
        availableDataColor = unavailableDataColor = new Color(51, 200, 51, 127);
        graphicHeight = 100;
    }

    public DataTrackClipControl(DataTrack model) {
        super(new BorderLayout());
        this.dataTrack = model;
        if (this.dataTrack instanceof ParticleDataTrack) {
            this.particleDT = (ParticleDataTrack)this.dataTrack;
            this.particleDT.addPropertyChangeListener("dataclip", this);
            this.particleDT.addPropertyChangeListener("videoclip", this);
        }
        this.createGUI();
        this.refreshSpinners();
        this.refreshGUI();
    }

    protected void createGUI() {
        this.videoInLabel = new JLabel();
        this.videoInLabel.setBorder(BorderFactory.createEmptyBorder());
        this.dataInLabel = new JLabel();
        this.dataInLabel.setBorder(BorderFactory.createEmptyBorder());
        this.dataClipLengthLabel = new JLabel();
        this.dataClipLengthLabel.setBorder(BorderFactory.createEmptyBorder());
        this.dataStrideLabel = new JLabel();
        this.dataStrideLabel.setBorder(BorderFactory.createEmptyBorder());
        this.videoInSpinner = new MySpinner(new SpinnerNumberModel(0, 0, 20, 1));
        this.videoInSpinner.addChangeListener(e -> {
            if (this.refreshing) {
                return;
            }
            VideoPanel vidPanel = this.dataTrack.getVideoPanel();
            if (vidPanel == null) {
                return;
            }
            VideoClip clip = vidPanel.getPlayer().getVideoClip();
            int cur = clip.frameToStep(this.dataTrack.getStartFrame());
            int in = (Integer)this.videoInSpinner.getValue();
            if (in == cur) {
                return;
            }
            this.dataTrack.setStartStep(in);
            TFrame.repaintT(this);
            this.videoInSpinner.requestFocusInWindow();
        });
        this.dataInSpinner = new MySpinner(new SpinnerNumberModel(0, 0, 20, 1));
        this.dataInSpinner.addChangeListener(e -> {
            if (this.refreshing) {
                return;
            }
            int in = (Integer)this.dataInSpinner.getValue();
            if (in == this.dataTrack.getDataClip().getStartIndex()) {
                return;
            }
            this.dataTrack.getDataClip().setStartIndex(in);
            this.dataInSpinner.setValue(this.dataTrack.getDataClip().getStartIndex());
            this.dataInSpinner.requestFocusInWindow();
            TFrame.repaintT(this);
        });
        this.dataClipLengthSpinner = new MySpinner(new SpinnerNumberModel(1, 1, 20, 1));
        this.dataClipLengthSpinner.addChangeListener(e -> {
            if (this.refreshing) {
                return;
            }
            int length = (Integer)this.dataClipLengthSpinner.getValue();
            if (length == this.dataTrack.getDataClip().getClipLength()) {
                return;
            }
            this.dataTrack.getDataClip().setClipLength(length);
            this.dataClipLengthSpinner.setValue(this.dataTrack.getDataClip().getClipLength());
            TFrame.repaintT(this);
            this.dataClipLengthSpinner.requestFocusInWindow();
            if (this.particleDT != null && this.particleDT.tp != null) {
                this.particleDT.tp.getModelBuilder().refreshSpinners();
            }
        });
        this.dataStrideSpinner = new MySpinner(new SpinnerNumberModel(1, 1, 10, 1));
        this.dataStrideSpinner.addChangeListener(e -> {
            if (this.refreshing) {
                return;
            }
            int n = (Integer)this.dataStrideSpinner.getValue();
            if (n == this.dataTrack.getDataClip().getStride()) {
                return;
            }
            this.dataTrack.getDataClip().setStride(n);
            this.dataStrideSpinner.setValue(this.dataTrack.getDataClip().getStride());
            TFrame.repaintT(this);
            this.dataStrideSpinner.requestFocusInWindow();
        });
        this.drawingPanel = new GraphicPanel();
        this.drawingPanel.setBorder(BorderFactory.createEtchedBorder());
        this.drawingPanel.addDrawable(new MappingGraphic());
        this.add((Component)this.drawingPanel, "Center");
        this.spinnerPanel = new JPanel(new GridLayout(1, 4));
        this.add((Component)this.spinnerPanel, "South");
        JPanel singleSpinnerPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        panel.add(this.videoInSpinner);
        singleSpinnerPanel.add((Component)panel, "North");
        panel = new JPanel();
        panel.add(this.videoInLabel);
        singleSpinnerPanel.add((Component)panel, "South");
        this.spinnerPanel.add(singleSpinnerPanel);
        singleSpinnerPanel = new JPanel(new BorderLayout());
        panel = new JPanel();
        panel.add(this.dataClipLengthSpinner);
        singleSpinnerPanel.add((Component)panel, "North");
        panel = new JPanel();
        panel.add(this.dataClipLengthLabel);
        singleSpinnerPanel.add((Component)panel, "South");
        this.spinnerPanel.add(singleSpinnerPanel);
        singleSpinnerPanel = new JPanel(new BorderLayout());
        panel = new JPanel();
        panel.add(this.dataInSpinner);
        singleSpinnerPanel.add((Component)panel, "North");
        panel = new JPanel();
        panel.add(this.dataInLabel);
        singleSpinnerPanel.add((Component)panel, "South");
        this.spinnerPanel.add(singleSpinnerPanel);
        singleSpinnerPanel = new JPanel(new BorderLayout());
        panel = new JPanel();
        panel.add(this.dataStrideSpinner);
        singleSpinnerPanel.add((Component)panel, "North");
        panel = new JPanel();
        panel.add(this.dataStrideLabel);
        singleSpinnerPanel.add((Component)panel, "South");
        this.spinnerPanel.add(singleSpinnerPanel);
    }

    protected void refreshSpinners() {
        VideoPanel vidPanel = this.dataTrack.getVideoPanel();
        if (vidPanel == null) {
            return;
        }
        DataClip dataClip = this.dataTrack.getDataClip();
        VideoClip videoClip = vidPanel.getPlayer().getVideoClip();
        int clipLength = dataClip.getClipLength();
        int dataLength = dataClip.getDataLength();
        int max = Math.max(0, dataLength - 1);
        Util.newSpinnerNumberModel(this.dataInSpinner, dataClip.getStartIndex(), 0, max, 1);
        max = Math.max(1, dataLength - 1);
        max = Math.max(max, dataClip.getStride());
        Util.newSpinnerNumberModel(this.dataStrideSpinner, dataClip.getStride(), 1, max, 1);
        if (videoClip != null) {
            int first = 0;
            int last = videoClip.getStepCount() - 1;
            int startStep = this.dataTrack.getStartStep();
            startStep = Math.max(startStep, first);
            startStep = Math.min(startStep, last);
            Util.newSpinnerNumberModel(this.videoInSpinner, startStep, first, last, 1);
        }
        max = Math.max(1, dataLength);
        Util.newSpinnerNumberModel(this.dataClipLengthSpinner, clipLength, 1, max, 1);
        Container c = this.getTopLevelAncestor();
        if (c instanceof ModelBuilder) {
            ((ModelBuilder)c).refreshSpinners();
        }
    }

    protected void refreshGUI() {
        this.setBorder(BorderFactory.createTitledBorder(TrackerRes.getString("DataTrackClipControl.Border.Title")));
        this.videoInLabel.setText(TrackerRes.getString("DataTrackClipControl.Label.VideoStart"));
        this.dataClipLengthLabel.setText(TrackerRes.getString("DataTrackClipControl.Label.FrameCount"));
        this.dataInLabel.setText(TrackerRes.getString("DataTrackClipControl.Label.DataStart"));
        this.dataStrideLabel.setText(TrackerRes.getString("DataTrackClipControl.Label.Stride"));
    }

    protected void addMouseListenerToAll(MouseListener listener) {
        this.addMouseListener(listener);
        this.drawingPanel.addMouseListener(listener);
        this.spinnerPanel.addMouseListener(listener);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        dim.height = this.getPreferredSize().height;
        return dim;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.refreshSpinners();
        TFrame.repaintT(this);
    }

    private int getLastDisplayedClipIndex() {
        int stepCount = this.dataTrack.getDataClip().getClipLength();
        VideoPanel vidPanel = this.dataTrack.getVideoPanel();
        if (vidPanel == null) {
            return stepCount;
        }
        VideoClip clip = vidPanel.getPlayer().getVideoClip();
        int last = clip.getLastFrameNumber();
        int i = stepCount - 1;
        while (i > 0) {
            int frame = this.dataTrack.getStartFrame() + i * clip.getStepSize();
            int index = this.dataTrack.getDataClip().stepToIndex(i);
            if (frame <= last && index < this.dataTrack.getDataClip().getDataLength()) {
                return index;
            }
            --i;
        }
        return this.dataTrack.getDataClip().stepToIndex(0);
    }

    public void setGraphic(Interactive graphic) {
        if (graphic == null) {
            return;
        }
        if (this.mappingGraphic != null) {
            this.drawingPanel.removeDrawable(this.mappingGraphic);
        }
        this.mappingGraphic = graphic;
        this.drawingPanel.addDrawable(this.mappingGraphic);
    }

    class GraphicPanel
    extends DrawingPanel {
        GraphicPanel() {
            this.removeMouseListener(this.mouseController);
            this.removeMouseMotionListener(this.mouseController);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            double mag = FontSizer.getFactor();
            dim.height = (int)(mag * (double)graphicHeight);
            return dim;
        }
    }

    class MappingGraphic
    implements Interactive {
        GeneralPath path = new GeneralPath();

        MappingGraphic() {
        }

        @Override
        public void draw(DrawingPanel panel, Graphics g) {
            int space;
            VideoPanel vidPanel = DataTrackClipControl.this.dataTrack.getVideoPanel();
            if (vidPanel == null) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            double mag = FontSizer.getFactor();
            int strokeWidth = (int)(8.0 * mag);
            g2.setStroke(new BasicStroke(strokeWidth, 0, 1));
            Rectangle rect = new Rectangle(DataTrackClipControl.this.drawingPanel.getSize());
            g2.setColor(new Color(200, 200, 200));
            g2.fill(rect);
            int yClipLine = (int)(30.0 * mag);
            int yDataLine = (int)(70.0 * mag);
            int yVideoFrame = yClipLine + 3 * g2.getFontMetrics().getHeight() / 4;
            g2.setColor(Color.DARK_GRAY);
            g2.setFont(DataTrackClipControl.this.videoInLabel.getFont());
            RenderingHints rh = g2.getRenderingHints();
            rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int largeGap = 10;
            int smallGap = 4;
            int fontDrop = g2.getFontMetrics().getHeight() / 4;
            String s = TrackerRes.getString("DataTrackClipControl.Label.Video");
            int labelSpace = g2.getFontMetrics().stringWidth(s);
            g2.drawString(s, largeGap, yClipLine + fontDrop);
            s = TrackerRes.getString("DataTrackClipControl.Label.Data");
            labelSpace = Math.max(labelSpace, g2.getFontMetrics().stringWidth(s));
            g2.drawString(s, largeGap, yDataLine + fontDrop);
            s = TrackerRes.getString("DataTrackClipControl.Label.Frame");
            labelSpace = Math.max(labelSpace, g2.getFontMetrics().stringWidth(s));
            g2.setFont(g2.getFont().deriveFont(0));
            g2.drawString(s, largeGap, yVideoFrame + fontDrop);
            labelSpace += 6;
            VideoClip videoClip = vidPanel.getPlayer().getVideoClip();
            DataClip dataClip = DataTrackClipControl.this.dataTrack.getDataClip();
            s = "0";
            int frontSpace = g2.getFontMetrics().stringWidth(s);
            s = String.valueOf(videoClip.getStepCount() - 1);
            int endSpace = g2.getFontMetrics().stringWidth(s);
            s = String.valueOf(dataClip.getDataLength() - 1);
            endSpace = Math.max(endSpace, g2.getFontMetrics().stringWidth(s));
            int videoClipFrames = videoClip.getStepCount();
            int dataClipFrames = dataClip.getDataLength();
            int maxFrames = Math.max(videoClipFrames, dataClipFrames);
            double maxLength = panel.getWidth() - labelSpace - frontSpace - endSpace - 3 * largeGap - 2 * smallGap;
            double lengthPerFrame = maxLength / (double)maxFrames;
            double lineLength = maxLength * (double)videoClipFrames / (double)maxFrames;
            double leftEnd = labelSpace + 2 * largeGap + frontSpace;
            double rightVideoEnd = leftEnd + lineLength;
            this.path.reset();
            this.path.moveTo(leftEnd, (double)yClipLine);
            this.path.lineTo(rightVideoEnd, (double)yClipLine);
            g2.setColor(videoColor);
            g2.draw(this.path);
            double fullClipLength = lengthPerFrame * (double)dataClip.getClipLength();
            int startStep = DataTrackClipControl.this.dataTrack.getStartStep();
            double videoStartClip = leftEnd + lengthPerFrame * (double)startStep;
            double videoEndClip = videoStartClip + fullClipLength;
            videoStartClip = Math.max(videoStartClip, leftEnd);
            videoEndClip = Math.min(videoEndClip, leftEnd + lineLength);
            this.path.reset();
            this.path.moveTo(videoStartClip, (double)yClipLine);
            this.path.lineTo(videoEndClip, (double)yClipLine);
            g2.setColor(unavailableDataColor);
            g2.draw(this.path);
            double clipLength = lengthPerFrame * (double)dataClip.getAvailableClipLength();
            videoEndClip = videoStartClip + clipLength;
            videoStartClip = Math.max(videoStartClip, leftEnd);
            videoEndClip = Math.min(videoEndClip, leftEnd + lineLength);
            clipLength = videoEndClip - videoStartClip;
            this.path.reset();
            this.path.moveTo(videoStartClip, (double)yClipLine);
            this.path.lineTo(videoEndClip, (double)yClipLine);
            g2.setColor(dataClipColor);
            g2.draw(this.path);
            lineLength = maxLength * (double)dataClipFrames / (double)maxFrames;
            double rightDataEnd = leftEnd + lineLength;
            this.path.reset();
            this.path.moveTo(leftEnd, (double)yDataLine);
            this.path.lineTo(rightDataEnd, (double)yDataLine);
            g2.setColor(dataColor);
            g2.draw(this.path);
            if (dataClip.getStride() > 1) {
                float frameWidth = Math.max(1.0f, (float)lengthPerFrame);
                g2.setStroke(new BasicStroke(strokeWidth, 0, 1, 8.0f, new float[]{frameWidth, frameWidth * (float)(dataClip.getStride() - 1)}, 0.0f));
            }
            double dataStartClip = leftEnd + lengthPerFrame * (double)dataClip.getStartIndex();
            double dataEndClip = dataStartClip + fullClipLength * (double)dataClip.getStride();
            dataEndClip = Math.min(dataEndClip, leftEnd + lineLength);
            this.path.reset();
            this.path.moveTo(dataStartClip, (double)yDataLine);
            this.path.lineTo(dataEndClip, (double)yDataLine);
            g2.setColor(availableDataColor);
            g2.draw(this.path);
            dataEndClip = dataStartClip + clipLength * (double)dataClip.getStride();
            this.path.reset();
            this.path.moveTo(dataStartClip, (double)yDataLine);
            this.path.lineTo(dataEndClip, (double)yDataLine);
            g2.setColor(dataClipColor);
            g2.draw(this.path);
            dataEndClip -= (double)(dataClip.getStride() - 1) * lengthPerFrame;
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(1.0f, 0, 1));
            this.path.reset();
            this.path.moveTo(dataStartClip, (double)(yDataLine - strokeWidth / 2));
            this.path.lineTo(videoStartClip, (double)(yClipLine + strokeWidth / 2));
            g2.draw(this.path);
            this.path.reset();
            this.path.moveTo(dataEndClip, (double)(yDataLine - strokeWidth / 2));
            this.path.lineTo(videoEndClip, (double)(yClipLine + strokeWidth / 2));
            g2.draw(this.path);
            g2.setFont(g2.getFont().deriveFont(1));
            int verticalOffset = fontDrop;
            s = "0";
            g2.drawString(s, (int)(leftEnd - (double)frontSpace - (double)smallGap), yDataLine + verticalOffset);
            g2.drawString(s, (int)(leftEnd - (double)frontSpace - (double)smallGap), yClipLine + verticalOffset);
            s = String.valueOf(dataClipFrames - 1);
            g2.drawString(s, (int)(rightDataEnd + (double)smallGap), yDataLine + verticalOffset);
            s = String.valueOf(videoClip.getStepCount() - 1);
            g2.drawString(s, (int)(rightVideoEnd + (double)smallGap), yClipLine + verticalOffset);
            g2.setFont(g2.getFont().deriveFont(0));
            s = String.valueOf(videoClip.getStartFrameNumber());
            frontSpace = g2.getFontMetrics().stringWidth(s);
            g2.drawString(s, (int)(leftEnd - (double)frontSpace - (double)smallGap), yVideoFrame + verticalOffset);
            s = String.valueOf(videoClip.getEndFrameNumber());
            g2.drawString(s, (int)(rightVideoEnd + (double)smallGap), yVideoFrame + verticalOffset);
            s = String.valueOf(DataTrackClipControl.this.dataTrack.getStartFrame());
            g2.drawString(s, (int)videoStartClip, yVideoFrame + verticalOffset);
            verticalOffset = -2 - strokeWidth / 2;
            g2.setFont(g2.getFont().deriveFont(1));
            s = String.valueOf(startStep);
            g2.drawString(s, (int)videoStartClip, yClipLine + verticalOffset);
            int n = startStep + dataClip.getAvailableClipLength() - 1;
            n = Math.min(n, videoClip.getStepCount() - 1);
            if (startStep != n) {
                s = String.valueOf(n);
                space = g2.getFontMetrics().stringWidth(s);
                g2.drawString(s, (int)(videoEndClip - (double)space), yClipLine + verticalOffset);
                s = String.valueOf(videoClip.stepToFrame(n));
                g2.setFont(g2.getFont().deriveFont(0));
                space = g2.getFontMetrics().stringWidth(s);
                verticalOffset = fontDrop;
                g2.drawString(s, (int)(videoEndClip - (double)space), yVideoFrame + verticalOffset);
            }
            verticalOffset = fontDrop + strokeWidth + 3;
            g2.setFont(g2.getFont().deriveFont(1));
            s = String.valueOf(DataTrackClipControl.this.dataTrack.getDataClip().getStartIndex());
            g2.drawString(s, (int)dataStartClip, yDataLine + verticalOffset);
            n = DataTrackClipControl.this.getLastDisplayedClipIndex();
            if (n - DataTrackClipControl.this.dataTrack.getDataClip().getStartIndex() > 0) {
                s = String.valueOf(n);
                space = g2.getFontMetrics().stringWidth(s);
                g2.drawString(s, (int)(dataEndClip - (double)space), yDataLine + verticalOffset);
            }
        }

        public Shape[] getHitShapes() {
            return null;
        }

        public Mark getMark(Point[] points) {
            return new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                }
            };
        }

        @Override
        public double getXMin() {
            return 0.0;
        }

        @Override
        public double getXMax() {
            return 100.0;
        }

        @Override
        public double getYMin() {
            return 0.0;
        }

        @Override
        public double getYMax() {
            return 100.0;
        }

        @Override
        public boolean isMeasured() {
            return true;
        }

        @Override
        public Interactive findInteractive(DrawingPanel panel, int _xpix, int _ypix) {
            return null;
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void setXY(double x, double y) {
        }

        @Override
        public void setX(double x) {
        }

        @Override
        public void setY(double y) {
        }

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }
    }

    class MySpinner
    extends JSpinner {
        public MySpinner(SpinnerModel model) {
            super(model);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            if (DataTrackClipControl.this.dataTrack instanceof ParticleDataTrack) {
                ParticleDataTrack pdt = (ParticleDataTrack)DataTrackClipControl.this.dataTrack;
                dim.height = pdt.tp.getModelBuilder().getSpinnerHeight();
            } else {
                dim.height += 6;
            }
            dim.width += 6;
            return dim;
        }
    }
}

