/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class DataTrackTimeControl
extends JPanel
implements PropertyChangeListener {
    protected DataTrack dataTrack;
    private JRadioButton videoButton;
    private JRadioButton dataButton;

    public DataTrackTimeControl(DataTrack track) {
        this.dataTrack = track;
        this.createGUI();
        this.refreshGUI();
    }

    protected void createGUI() {
        this.videoButton = new JRadioButton();
        this.videoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DataTrackTimeControl.this.setTimeSourceToDataTrack(false);
            }
        });
        this.dataButton = new JRadioButton();
        this.dataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DataTrackTimeControl.this.setTimeSourceToDataTrack(true);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.videoButton);
        group.add(this.dataButton);
        this.videoButton.setSelected(true);
        this.add(this.videoButton);
        this.add(this.dataButton);
    }

    protected void refreshGUI() {
        this.setBorder(BorderFactory.createTitledBorder(TrackerRes.getString("DataTrackTimeControl.Border.Title")));
        this.videoButton.setText(TrackerRes.getString("DataTrackTimeControl.Button.Video"));
        this.dataButton.setText(TrackerRes.getString("DataTrackTimeControl.Button.Data"));
        this.dataButton.setEnabled(this.dataTrack.isTimeDataAvailable());
        boolean dataSelected = ClipControl.isTimeSource(this.dataTrack);
        this.dataButton.setSelected(dataSelected);
        this.videoButton.setSelected(!dataSelected);
        FontSizer.setFonts(this.getBorder(), FontSizer.getLevel());
    }

    protected void setTimeSourceToDataTrack(boolean isTrackTimeSource) {
        if (this.dataTrack.getVideoPanel() == null) {
            return;
        }
        VideoPlayer player = this.dataTrack.getVideoPanel().getPlayer();
        player.getClipControl().setTimeSource(isTrackTimeSource ? this.dataTrack : null);
        player.refresh();
        if (this.dataTrack instanceof ParticleDataTrack) {
            ((ParticleDataTrack)this.dataTrack).refreshInitialTime();
        }
    }

    protected boolean isTimeSourceDataTrack() {
        if (this.dataTrack.getVideoPanel() == null) {
            return false;
        }
        VideoPlayer player = this.dataTrack.getVideoPanel().getPlayer();
        return player.getClipControl().getTimeSource() == this.dataTrack;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        dim.height = this.getPreferredSize().height;
        return dim;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.refreshGUI();
    }
}

