/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class DerivativeAlgorithmDialog
extends JDialog {
    protected TFrame frame;
    protected Integer panelID;
    protected ArrayList<PointMass> targetMasses = new ArrayList();
    protected JButton okButton;
    protected JButton cancelButton;
    JTextPane textPane;
    int[] types;
    JRadioButton[] buttons;
    TitledBorder choiceBorder;
    int prevAlgorithm;

    public DerivativeAlgorithmDialog(TrackerPanel panel) {
        super((Frame)panel.getTFrame(), true);
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.types = nArray;
        this.buttons = new JRadioButton[this.types.length];
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.createGUI();
        this.pack();
        this.okButton.requestFocusInWindow();
    }

    protected void setTargetMass(PointMass mass) {
        this.targetMasses.clear();
        this.targetMasses.add(mass);
        this.refreshGUI();
    }

    protected void setTargetMasses(ArrayList<PointMass> masses) {
        this.targetMasses.clear();
        this.targetMasses.addAll(masses);
        this.refreshGUI();
    }

    private void createGUI() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        this.textPane = new JTextPane();
        JScrollPane scroller = new JScrollPane(this.textPane);
        contentPane.add((Component)scroller, "Center");
        Box choicebar = Box.createHorizontalBox();
        this.choiceBorder = BorderFactory.createTitledBorder("");
        Border empty = BorderFactory.createEmptyBorder(3, 2, 3, 2);
        choicebar.setBorder(BorderFactory.createCompoundBorder(empty, this.choiceBorder));
        ButtonGroup group = new ButtonGroup();
        AbstractAction chooser = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = Integer.parseInt(e.getActionCommand());
                for (PointMass next : DerivativeAlgorithmDialog.this.targetMasses) {
                    next.setAlgorithm(i);
                }
                DerivativeAlgorithmDialog.this.refreshInfo(i);
            }
        };
        int i = 0;
        while (i < this.types.length) {
            int type = this.types[i];
            this.buttons[i] = new JRadioButton();
            this.buttons[i].setActionCommand(String.valueOf(type));
            this.buttons[i].addActionListener(chooser);
            group.add(this.buttons[i]);
            choicebar.add(this.buttons[i]);
            ++i;
        }
        contentPane.add((Component)choicebar, "North");
        this.okButton = new JButton();
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DerivativeAlgorithmDialog.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DerivativeAlgorithmDialog.this.revert();
                DerivativeAlgorithmDialog.this.setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel();
        buttonbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        contentPane.add((Component)buttonbar, "South");
        buttonbar.add(this.okButton);
        buttonbar.add(this.cancelButton);
        this.refreshGUI();
    }

    private void refreshGUI() {
        String target = this.targetMasses.size() == 1 ? this.targetMasses.get(0).getName() : TrackerRes.getString("AlgorithmDialog.TargetMasses.All");
        this.setTitle(String.valueOf(TrackerRes.getString("AlgorithmDialog.Title")) + ": " + target);
        this.choiceBorder.setTitle(TrackerRes.getString("AlgorithmDialog.TitledBorder.Choose"));
        this.okButton.setText(TrackerRes.getString("Dialog.Button.OK"));
        this.cancelButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
        int i = 0;
        while (i < this.types.length) {
            int type = this.types[i];
            String s = "";
            if (type == 0) {
                s = TrackerRes.getString("AlgorithmDialog.Button.FiniteDifference");
            } else if (type == 1) {
                s = TrackerRes.getString("AlgorithmDialog.Button.BounceDetect");
            } else if (type == 2) {
                s = TrackerRes.getString("AlgorithmDialog.Button.SmoothFiniteDifference");
            }
            this.buttons[i].setText(s);
            ++i;
        }
    }

    private void refreshInfo(int algorithm) {
        String s = "";
        if (algorithm == 0) {
            s = String.valueOf(TrackerRes.getString("AlgorithmDialog.FiniteDifference.Message1")) + "\n\n    " + TrackerRes.getString("AlgorithmDialog.FiniteDifference.Message2") + "\n\n    " + TrackerRes.getString("AlgorithmDialog.FiniteDifference.Message3");
        } else if (algorithm == 1) {
            String url = "http://gasstationwithoutpumps.wordpress.com/2011/11/08/tracker-video-analysis-tool-fixes/";
            s = String.valueOf(TrackerRes.getString("AlgorithmDialog.BounceDetect.Message1")) + " " + TrackerRes.getString("AlgorithmDialog.BounceDetect.Message2") + "\n\n" + url;
        } else if (algorithm == 2) {
            s = String.valueOf(TrackerRes.getString("AlgorithmDialog.SmoothFiniteDifference.Message1")) + "\n\n    " + TrackerRes.getString("AlgorithmDialog.SmoothFiniteDifference.Message2") + "\n\n    " + TrackerRes.getString("AlgorithmDialog.SmoothFiniteDifference.Message3");
        }
        this.textPane.setText(s);
    }

    private void initialize() {
        if (!this.targetMasses.isEmpty()) {
            PointMass p = this.targetMasses.get(0);
            this.prevAlgorithm = p.algorithm;
        }
        int i = 0;
        while (i < this.types.length) {
            int type = this.types[i];
            if (type == this.prevAlgorithm) {
                this.buttons[i].setSelected(true);
                this.refreshInfo(type);
                break;
            }
            ++i;
        }
    }

    private void revert() {
        for (PointMass next : this.targetMasses) {
            next.setAlgorithm(this.prevAlgorithm);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        this.initialize();
        super.setVisible(vis);
    }

    protected void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        FontSizer.setFonts(this.choiceBorder, level);
        int w = (int)(400.0 * (1.0 + (double)level * 0.5));
        int h = (int)(100.0 * (1.0 + (double)level * 0.35));
        this.textPane.setPreferredSize(new Dimension(w, h));
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    @Override
    public void dispose() {
        this.panelID = null;
        this.frame = null;
        super.dispose();
    }
}

