/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.display.ResizableIcon;

public class DoubleArrowFootprint
extends LineFootprint {
    protected int tipLength = 16;
    protected int tipWidth = 4;
    boolean openHead = true;
    protected BasicStroke headStroke = new BasicStroke();

    public DoubleArrowFootprint(String name) {
        super(name);
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        Point[] points = new Point[]{new Point(), new Point(w - 2, 2 - h)};
        MultiShape shape = this.getShape(points, false, 1);
        ShapeIcon icon = new ShapeIcon(shape, w, h);
        icon.setColor(this.color);
        return new ResizableIcon(icon);
    }

    public void setTipLength(int tipLength) {
        tipLength = Math.max(8, tipLength);
        this.tipWidth = tipLength / 4;
        this.tipLength = 4 * this.tipWidth;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke == null) {
            return;
        }
        super.setStroke(stroke);
        this.headStroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, null, stroke.getDashPhase());
    }

    public void setSolidHead(boolean solid) {
        this.openHead = !solid;
    }

    @Override
    public MultiShape getShape(Point[] points, int scale) {
        return this.getShape(points, true, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiShape getShape(Point[] points, boolean bothEnds, int scale) {
        float lineWidth;
        Point p1 = points[0];
        Point p2 = points[1];
        double theta = Math.atan2(p1.y - p2.y, p1.x - p2.x);
        this.transform.setToRotation(theta, p2.x, p2.y);
        this.transform.translate(p2.x, p2.y);
        float d = (float)p1.distance(p2);
        int tipL = this.tipLength * scale;
        if (bothEnds) {
            tipL = Math.min(tipL, Math.round(d / 2.0f - 3.0f));
        }
        tipL = Math.max(8, tipL);
        int tipW = Math.max(tipL / 4, 3);
        float f = (float)scale * this.baseStroke.getLineWidth();
        float f2 = lineWidth = f < (float)(tipL / 4) ? f : Math.max((float)(tipL / 4), 0.8f);
        if (this.stroke == null || this.stroke.getLineWidth() != lineWidth) {
            this.stroke = new BasicStroke(lineWidth, 0, 0, 8.0f, this.baseStroke.getDashArray(), this.baseStroke.getDashPhase());
            this.headStroke = new BasicStroke(lineWidth, 0, 0, 8.0f, null, this.stroke.getDashPhase());
            this.rotatorStroke = new BasicStroke(lineWidth, 0, 0, 8.0f, WIDE_DOTTED_LINE, this.stroke.getDashPhase());
        }
        GeneralPath generalPath = this.path;
        synchronized (generalPath) {
            this.path.reset();
            this.path.moveTo(d - 4.0f, 0.0f);
            this.path.lineTo(d - 6.0f, -2.0f);
            this.path.lineTo(d, 0.0f);
            this.path.lineTo(d - 6.0f, 2.0f);
            this.path.closePath();
            this.hitShapes[0] = this.transform.createTransformedShape(this.path);
            this.path.reset();
            this.path.moveTo(4.0f, 0.0f);
            this.path.lineTo(6.0f, -2.0f);
            this.path.lineTo(0.0f, 0.0f);
            this.path.lineTo(6.0f, 2.0f);
            this.path.closePath();
            this.hitShapes[1] = this.transform.createTransformedShape(this.path);
            float center = d / 2.0f;
            float l = d - (float)(2 * tipL);
            hitLine.setLine((double)center - 0.3 * (double)l, 0.0, (double)center + 0.3 * (double)l, 0.0);
            this.hitShapes[2] = this.transform.createTransformedShape(hitLine);
            hitLine.setLine((double)center + 0.35 * (double)l, 0.0, (double)center + 0.45 * (double)l, 0.0);
            this.hitShapes[3] = this.transform.createTransformedShape(hitLine);
            hitLine.setLine((double)center - 0.45 * (double)l, 0.0, (double)center - 0.35 * (double)l, 0.0);
            this.hitShapes[4] = this.transform.createTransformedShape(hitLine);
            float w = this.openHead ? lineWidth * 2.0f - 1.0f : 0.0f;
            this.path.reset();
            this.path.moveTo((float)tipL + w - (float)tipW, 0.5f * lineWidth);
            this.path.lineTo(bothEnds ? d - (float)tipL + (float)tipW : (d -= w), 0.5f * lineWidth);
            this.path.lineTo(bothEnds ? d - (float)tipL + (float)tipW : d, -0.5f * lineWidth);
            this.path.lineTo((float)tipL + w - (float)tipW, -0.5f * lineWidth);
            this.path.closePath();
            Shape shaft = this.transform.createTransformedShape(this.path);
            this.path.reset();
            this.path.moveTo(w + (float)tipL - (float)tipW, 0.0f);
            this.path.lineTo(w + (float)tipL, tipW);
            this.path.lineTo(w, 0.0f);
            this.path.lineTo(w + (float)tipL, -tipW);
            this.path.closePath();
            Shape end1 = this.transform.createTransformedShape(this.path);
            Shape end2 = null;
            if (bothEnds) {
                this.path.reset();
                this.path.moveTo(d - (float)tipL + (float)tipW, 0.0f);
                this.path.lineTo(d - (float)tipL, -tipW);
                this.path.lineTo(d, 0.0f);
                this.path.lineTo(d - (float)tipL, tipW);
                this.path.closePath();
                end2 = this.transform.createTransformedShape(this.path);
            }
            return end2 == null ? new MultiShape(shaft, end1).andFill(true, !this.openHead) : new MultiShape(shaft, end1, end2).andFill(true, !this.openHead, !this.openHead);
        }
    }
}

