/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.display.ResizableIcon;

public class DoubleCrosshairFootprint
extends LineFootprint {
    protected Shape targetShape;
    protected int size;
    protected Shape hitShape;

    public DoubleCrosshairFootprint(String name) {
        super(name);
        this.setCrosshairSize(4, 0);
    }

    public void setCrosshairSize(int out, int in) {
        this.size = out;
        this.path.reset();
        this.path.moveTo(-out, 0.0f);
        this.path.lineTo(-in, 0.0f);
        this.path.moveTo(out, 0.0f);
        this.path.lineTo(in, 0.0f);
        this.path.moveTo(0.0f, out);
        this.path.lineTo(0.0f, in);
        this.path.moveTo(0.0f, -out);
        this.path.lineTo(0.0f, -in);
        this.transform.setToIdentity();
        this.targetShape = this.transform.createTransformedShape(this.path);
        this.hitShape = new Rectangle(-this.size / 2, -this.size / 2, this.size, this.size);
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        Point[] points = new Point[]{new Point(), new Point(w - 2, 2 - h)};
        MultiShape shape = this.getShape(points, false, 1);
        ShapeIcon icon = new ShapeIcon(shape, w, h);
        icon.setColor(this.color);
        icon.setStroke(this.stroke);
        return new ResizableIcon(icon);
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke == null) {
            return;
        }
        this.baseStroke = stroke;
    }

    @Override
    public MultiShape getShape(Point[] points, int scale) {
        return this.getShape(points, true, scale);
    }

    private MultiShape getShape(Point[] points, boolean bothEnds, int scale) {
        Point p1 = points[0];
        Point p2 = points[1];
        float d = (float)p1.distance(p2);
        float center = d / 2.0f;
        float l = Math.max(d - (float)(scale * 2 * (this.size + 3)), (float)this.size);
        this.transform.setToTranslation(p1.x, p1.y);
        if (scale > 1) {
            this.transform.scale(scale, scale);
        }
        Shape target1 = this.transform.createTransformedShape(this.targetShape);
        this.hitShapes[0] = this.transform.createTransformedShape(this.hitShape);
        this.transform.setToTranslation(p2.x, p2.y);
        if (scale > 1) {
            this.transform.scale(scale, scale);
        }
        Shape target2 = this.transform.createTransformedShape(this.targetShape);
        this.hitShapes[1] = this.transform.createTransformedShape(this.hitShape);
        double theta = Math.atan2(p1.y - p2.y, p1.x - p2.x);
        if (Double.isNaN(theta)) {
            theta = 0.0;
        }
        this.transform.setToRotation(theta, p2.x, p2.y);
        this.transform.translate(p2.x, p2.y);
        hitLine.setLine((double)center - 0.3 * (double)l, 0.0, (double)center + 0.3 * (double)l, 0.0);
        this.hitShapes[2] = this.transform.createTransformedShape(hitLine);
        hitLine.setLine((double)center + 0.35 * (double)l, 0.0, (double)center + 0.45 * (double)l, 0.0);
        this.hitShapes[3] = this.transform.createTransformedShape(hitLine);
        hitLine.setLine((double)center - 0.45 * (double)l, 0.0, (double)center - 0.35 * (double)l, 0.0);
        this.hitShapes[4] = this.transform.createTransformedShape(hitLine);
        this.path.reset();
        this.path.moveTo(center - l / 2.0f, 0.0f);
        this.path.lineTo(center + l / 2.0f, 0.0f);
        Shape line = this.transform.createTransformedShape(this.path);
        if (this.stroke == null || this.stroke.getLineWidth() != (float)scale * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)scale * this.baseStroke.getLineWidth());
            this.rotatorStroke = new BasicStroke(this.stroke.getLineWidth(), 0, 0, 8.0f, WIDE_DOTTED_LINE, this.stroke.getDashPhase());
        }
        return bothEnds ? new MultiShape(line, target1, target2) : new MultiShape(line, target2);
    }
}

