/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.DynamicFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolver;
import org.opensourcephysics.numerics.RK4;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DynamicParticle
extends ParticleModel
implements ODE {
    protected ModelBooster modelBooster = new ModelBooster();
    protected NumberField cellNumberField;
    protected boolean inSystem;
    protected String boosterName;
    protected static final String[] cartVars = new String[]{"x", "vx", "y", "vy", "t"};
    protected double[] state = new double[5];
    protected double[] initialState = new double[5];
    protected ODESolver solver = new RK4(this);
    protected int iterationsPerStep = 10;
    protected DynamicSystem system;
    protected HashMap<Integer, double[]> frameStates = new HashMap();
    protected double[] temp = new double[5];

    protected String[] getBoostVars() {
        return cartVars;
    }

    public DynamicParticle() {
        this.initializeInitEditor();
        this.points = new Point2D.Double[]{new Point2D.Double()};
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        PointMass m;
        if (this.boosterName != null && panel instanceof TrackerPanel && (m = ((TrackerPanel)panel).getTrackByName(PointMass.class, this.boosterName)) != null) {
            this.setBooster(m);
            this.boosterName = null;
        }
        if (this.system == null && !this.inSystem) {
            super.draw(panel, _g);
        }
    }

    @Override
    public String getDisplayName() {
        String s = this.getName();
        if (this.system == null) {
            return s;
        }
        String in = TrackerRes.getString("DynamicParticle.System.In");
        return String.valueOf(s) + " (" + in + " " + this.system.getName() + ")";
    }

    @Override
    public void delete() {
        if (this.system != null) {
            String message = TrackerRes.getString("DynamicParticle.Dialog.Delete.Message");
            int response = JOptionPane.showConfirmDialog(this.tframe, message, TrackerRes.getString("DynamicParticle.Dialog.Delete.Title"), 2, 2);
            if (response == 0) {
                this.system.removeParticle(this);
            } else {
                return;
            }
        }
        super.delete();
    }

    @Override
    protected void refreshSteps(String why) {
        if (this.system == null) {
            super.refreshSteps(why);
        }
    }

    @Override
    public void reset() {
        if (this.system != null) {
            return;
        }
        this.resetState();
        double[] state = this.getState();
        this.t0 = state[state.length - 1];
        this.setTracePositions(state);
        if (this.tp != null) {
            this.erase();
            this.dt = this.tp.getPlayer().getMeanStepDuration() / (double)(1000 * tracePtsPerStep);
            this.dt /= (double)this.iterationsPerStep;
            this.solver.initialize(this.dt);
            ParticleModel[] models = this.getModels();
            VideoClip clip = this.tp.getPlayer().getVideoClip();
            int end = Math.min(this.getEndFrame(), clip.getLastFrameNumber());
            while (end > this.getStartFrame() && !clip.includesFrame(end)) {
                --end;
            }
            boolean emptySystem = false;
            if (this instanceof DynamicSystem) {
                DynamicSystem system = (DynamicSystem)this;
                boolean bl = emptySystem = system.particles.length == 0;
            }
            if (emptySystem || end == this.getStartFrame() && !clip.includesFrame(this.getStartFrame())) {
                int i = 0;
                while (i < models.length) {
                    models[i].steps.setLength(1);
                    models[i].steps.setStep(0, null);
                    int j = 0;
                    while (j < this.tp.andWorld.size()) {
                        Integer panelID = this.tp.andWorld.get(j);
                        models[i].getVArray(panelID).setLength(0);
                        models[i].getAArray(panelID).setLength(0);
                        ++j;
                    }
                    models[i].traceX = new double[0];
                    models[i].traceY = new double[0];
                    ++i;
                }
                this.fireStepsChanged();
                return;
            }
            int firstFrameInClip = this.getStartFrame();
            while (firstFrameInClip < end && !clip.includesFrame(firstFrameInClip)) {
                ++firstFrameInClip;
            }
            ImageCoordSystem coords = this.tp.getCoords();
            boolean useDefault = this.isUseDefaultReferenceFrame();
            while (useDefault && coords instanceof ReferenceFrame) {
                coords = ((ReferenceFrame)coords).getCoords();
            }
            int count = (firstFrameInClip - this.getStartFrame()) * tracePtsPerStep * this.iterationsPerStep / clip.getStepSize();
            int i = 0;
            while (i < count) {
                this.solver.step();
                ++i;
            }
            this.setTracePositions(this.getState());
            AffineTransform transform = coords.getToImageTransform(firstFrameInClip);
            int i2 = 0;
            while (i2 < models.length) {
                models[i2].setLastValidFrame(firstFrameInClip);
                models[i2].steps.setLength(firstFrameInClip + 1);
                PositionStep step = (PositionStep)models[i2].getStep(firstFrameInClip);
                int j = 0;
                while (j < models[i2].steps.array.length) {
                    if (j < firstFrameInClip) {
                        models[i2].steps.setStep(j, null);
                    } else if (step == null) {
                        step = new PositionStep(models[i2], firstFrameInClip, 0.0, 0.0);
                        step.setFootprint(models[i2].getFootprint());
                        models[i2].steps.setStep(firstFrameInClip, step);
                    }
                    ++j;
                }
                j = 0;
                while (j < this.tp.andWorld.size()) {
                    Integer panelID = this.tp.andWorld.get(j);
                    models[i2].getVArray(panelID).setLength(0);
                    models[i2].getAArray(panelID).setLength(0);
                    ++j;
                }
                transform.transform(this.points[i2], this.points[i2]);
                models[i2].traceX = new double[]{this.points[i2].getX()};
                models[i2].traceY = new double[]{this.points[i2].getY()};
                step.getPosition().setPosition(this.points[i2]);
                models[i2].firePropertyChange("step", null, firstFrameInClip);
                ++i2;
            }
        }
    }

    @Override
    public double[] getState() {
        if (this.system != null) {
            return this.system.getState(this);
        }
        return this.state;
    }

    @Override
    protected void saveState(int frameNumber) {
        this.frameStates.put(frameNumber, (double[])this.getState().clone());
    }

    @Override
    protected boolean restoreState(int frameNumber) {
        double[] savedState = this.frameStates.get(frameNumber);
        if (savedState != null) {
            System.arraycopy(savedState, 0, this.state, 0, this.state.length);
            return true;
        }
        return false;
    }

    @Override
    public void getRate(double[] state, double[] rate) {
        this.getXYForces(state, this.temp);
        rate[0] = state[1];
        rate[1] = this.temp[0] / this.getMass();
        rate[2] = state[3];
        rate[3] = this.temp[1] / this.getMass();
        rate[4] = 1.0;
    }

    public void setSolver(Class<?> solverClass) {
        Class[] c = new Class[]{ODE.class};
        Object[] o = new Object[]{this};
        try {
            Constructor<?> constructor = solverClass.getDeclaredConstructor(c);
            this.solver = (ODESolver)constructor.newInstance(o);
            this.reset();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public double[] getInitialState() {
        double[] init = this.getInitialValues();
        this.initialState[0] = init[1];
        this.initialState[1] = init[3];
        this.initialState[2] = init[2];
        this.initialState[3] = init[4];
        this.initialState[4] = init[0];
        return this.initialState;
    }

    @Override
    public int getStartFrame() {
        return this.system == null ? this.startFrame : this.system.getStartFrame();
    }

    @Override
    public void setStartFrame(int n) {
        if (this.system != null) {
            this.system.setStartFrame(n);
            this.system.refreshSystemParameters();
        } else {
            super.setStartFrame(n);
            if (this.modelBooster != null) {
                this.modelBooster.setBooster(this.modelBooster.booster);
            }
        }
    }

    @Override
    public int getEndFrame() {
        if (this.system != null) {
            return this.system.getEndFrame();
        }
        return this.endFrame;
    }

    @Override
    public void setEndFrame(int n) {
        if (this.system != null) {
            this.system.setEndFrame(n);
        } else {
            super.setEndFrame(n);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getPropertyName().equals("transform")) {
            this.boost();
        }
    }

    protected void getXYForces(double[] cartesianState, double[] ret) {
        UserFunction[] f = this.getFunctionEditor().getMainFunctions();
        f[0].clear();
        f[1].clear();
        ret[0] = f[0].evaluateMyVal(cartesianState);
        ret[1] = f[1].evaluateMyVal(cartesianState);
        f[0].clear();
        f[1].clear();
        nCalc += 2;
    }

    protected void resetState() {
        if (this.system != null) {
            this.system.resetState();
        } else {
            System.arraycopy(this.getInitialState(), 0, this.state, 0, this.state.length);
        }
    }

    protected void initializeInitEditor() {
        Parameter t = (Parameter)this.getInitEditor().getObject("t");
        Parameter x = new Parameter("x", "0.0");
        x.setNameEditable(false);
        x.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialX.Description"));
        Parameter y = new Parameter("y", "0.0");
        y.setNameEditable(false);
        y.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialY.Description"));
        Parameter vx = new Parameter("vx", "0.0");
        vx.setNameEditable(false);
        vx.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialVelocityX.Description"));
        Parameter vy = new Parameter("vy", "0.0");
        vy.setNameEditable(false);
        vy.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialVelocityY.Description"));
        this.getInitEditor().setParameters(new Parameter[]{t, x, y, vx, vy});
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionEditor = new UserFunctionEditor();
        this.functionPanel = new DynamicFunctionPanel(this.functionEditor, this);
        String[] funcVars = new String[]{"x", "vx", "y", "vy", "t"};
        UserFunction[] uf = new UserFunction[]{new UserFunction("fx", funcVars, TrackerRes.getString("DynamicParticle.ForceFunction.X.Description")), new UserFunction("fy", funcVars, TrackerRes.getString("DynamicParticle.ForceFunction.Y.Description"))};
        this.functionEditor.setMainFunctions(uf);
        this.createMassAndTimeParameters();
    }

    @Override
    protected boolean getNextTracePositions() {
        int i = 0;
        while (i < this.iterationsPerStep) {
            this.solver.step();
            ++i;
        }
        this.setTracePositions(this.getState());
        return true;
    }

    protected void setTracePositions(double[] state) {
        this.points[0].setLocation(state[0], state[2]);
    }

    protected double[] getBoostState(PointMass target, int frameNumber) {
        DatasetManager data = target.getData(this.tp);
        Dataset ds = data.getFrameDataset();
        double[] frames = ds.getYPoints();
        int i = 0;
        int n = frames.length;
        while (i < n) {
            if (frames[i] == (double)frameNumber) {
                this.temp[0] = data.get("x", i, 1);
                this.temp[1] = data.get("v_{x}", i, 1);
                this.temp[2] = data.get("y", i, 1);
                this.temp[3] = data.get("v_{y}", i, 1);
                this.temp[4] = data.getValueAt(i, 0);
                return this.temp;
            }
            ++i;
        }
        return null;
    }

    protected PointMass getBooster() {
        return this.modelBooster.booster;
    }

    protected void setBooster(PointMass booster) {
        this.modelBooster.setBooster(booster);
    }

    protected boolean isBoostedBy(PointMass target) {
        if (this.modelBooster == null || this.modelBooster.booster == null) {
            return false;
        }
        if (this.modelBooster.booster == target) {
            return true;
        }
        if (this.modelBooster.booster instanceof DynamicParticle) {
            DynamicParticle dp = (DynamicParticle)this.modelBooster.booster;
            return dp.isBoostedBy(target);
        }
        return false;
    }

    protected void boost() {
        if (this.modelBooster == null || this.modelBooster.booster == null) {
            return;
        }
        double[] state = this.getBoostState(this.modelBooster.booster, this.getStartFrame());
        if (state == null) {
            return;
        }
        Parameter[] params = this.getInitEditor().getParameters();
        String[] boostVars = this.getBoostVars();
        int i = 0;
        while (i < params.length) {
            Parameter param = params[i];
            String name = param.getName();
            int j = 0;
            while (j < 4) {
                if (name.equals(boostVars[j])) {
                    double value = state[j];
                    if (Double.isNaN(value)) break;
                    if (this.cellNumberField == null) {
                        this.cellNumberField = new NumberField(0);
                    }
                    this.cellNumberField.setFormatFor(value);
                    String val = this.cellNumberField.format(value);
                    Parameter newParam = params[i] = new Parameter(name, val);
                    newParam.setDescription(param.getDescription());
                    newParam.setNameEditable(false);
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.getInitEditor().setParameters(params);
        if (this.system != null) {
            this.system.refreshSystemParameters();
            this.system.setLastValidFrame(-1);
            this.system.refreshSteps("DP boost");
        } else {
            this.reset();
        }
        this.repaint();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    @Override
    public void dispose() {
        this.setBooster(null);
        this.modelBooster = null;
        super.dispose();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DynamicParticle p = (DynamicParticle)obj;
            XML.getLoader(ParticleModel.class).saveObject(control, obj);
            if (p.system != null) {
                control.setValue("in_system", true);
            }
            if (p.modelBooster != null && p.modelBooster.booster != null) {
                control.setValue("booster", p.modelBooster.booster.getName());
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new DynamicParticle();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            DynamicParticle p = (DynamicParticle)obj;
            try {
                XML.getLoader(ParticleModel.class).loadObject(control, obj);
                p.inSystem = control.getBoolean("in_system");
                p.boosterName = control.getString("booster");
            }
            catch (Exception ex) {
                String solver = control.getString("solver");
                if (solver != null) {
                    try {
                        Class<?> solverClass = Class.forName(solver);
                        p.setSolver(solverClass);
                    }
                    catch (Exception solverClass) {
                        // empty catch block
                    }
                }
                String t = control.getString("t0");
                p.getInitEditor().setExpression("t", t, false);
                String x = control.getString("x");
                p.getInitEditor().setExpression("x", x, false);
                String y = control.getString("y");
                p.getInitEditor().setExpression("y", y, false);
                String vx = control.getString("vx");
                p.getInitEditor().setExpression("vx", vx, false);
                String vy = control.getString("vy");
                p.getInitEditor().setExpression("vy", vy, false);
                String fx = control.getString("force x");
                p.getFunctionEditor().setExpression("fx", fx, false);
                String fy = control.getString("force y");
                p.getFunctionEditor().setExpression("fy", fy, false);
                p.reset();
            }
            return obj;
        }
    }

    class ModelBooster
    implements PropertyChangeListener {
        PointMass booster;
        boolean adjusting = false;

        ModelBooster() {
        }

        public void setBooster(PointMass pm) {
            if (this.booster != null) {
                this.booster.removeStepListener(this);
            }
            this.booster = pm;
            if (this.booster != null) {
                DynamicParticle.this.boost();
                this.booster.addStepListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (this.booster == null) {
                return;
            }
            String name = e.getPropertyName();
            if (name.equals("adjusting")) {
                this.adjusting = (Boolean)e.getNewValue();
                name = "steps";
            }
            if (this.adjusting) {
                return;
            }
            switch (name) {
                case "steps": {
                    if (!(this.booster instanceof ParticleModel)) break;
                    DatasetManager data = this.booster.getData(DynamicParticle.this.tp);
                    this.booster.refreshData(data, DynamicParticle.this.tp);
                    break;
                }
                default: {
                    return;
                }
                case "data": 
                case "step": 
            }
            DynamicParticle.this.boost();
        }
    }
}

