/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import org.opensourcephysics.cabrillo.tracker.DynamicFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DynamicParticlePolar
extends DynamicParticle {
    protected static final String[] polarVars = new String[]{"r", "vr", FunctionEditor.THETA, FunctionEditor.OMEGA, "t"};

    @Override
    protected String[] getBoostVars() {
        return polarVars;
    }

    @Override
    public double[] getInitialState() {
        double[] polar = this.getInitialValues();
        double cos = Math.cos(polar[2]);
        double sin = Math.sin(polar[2]);
        if (Math.abs(cos) < 1.0E-7) {
            cos = 0.0;
        }
        if (Math.abs(sin) < 1.0E-7) {
            sin = 0.0;
        }
        double romega = polar[1] * polar[4];
        this.initialState[0] = polar[1] * cos;
        this.initialState[1] = polar[3] * cos - romega * sin;
        this.initialState[2] = polar[1] * sin;
        this.initialState[3] = polar[3] * sin + romega * cos;
        this.initialState[4] = polar[0];
        return this.initialState;
    }

    @Override
    protected void getXYForces(double[] cartesianState, double[] ret) {
        UserFunction[] f = this.getFunctionEditor().getMainFunctions();
        ret = this.getPolarState(cartesianState, ret);
        double fr = f[0].evaluate(ret);
        double ftheta = f[1].evaluate(ret);
        double cos = Math.cos(ret[2]);
        double sin = Math.sin(ret[2]);
        ret[0] = fr * cos - ftheta * sin;
        ret[1] = fr * sin + ftheta * cos;
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionEditor = new UserFunctionEditor();
        this.functionPanel = new DynamicFunctionPanel(this.functionEditor, this);
        UserFunction[] uf = new UserFunction[]{new UserFunction("fr", polarVars, TrackerRes.getString("DynamicParticle.ForceFunction.R.Description")), new UserFunction("f" + FunctionEditor.THETA, polarVars, TrackerRes.getString("DynamicParticle.ForceFunction.Theta.Description"))};
        this.functionEditor.setMainFunctions(uf);
        this.createMassAndTimeParameters();
    }

    @Override
    protected void initializeInitEditor() {
        Parameter t = (Parameter)this.getInitEditor().getObject("t");
        Parameter r = new Parameter("r", "0.0");
        r.setNameEditable(false);
        r.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialR.Description"));
        Parameter th = new Parameter(FunctionEditor.THETA, "0.0");
        th.setNameEditable(false);
        th.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialTheta.Description"));
        Parameter v = new Parameter("vr", "0.0");
        v.setNameEditable(false);
        v.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialVelocityR.Description"));
        Parameter w = new Parameter(FunctionEditor.OMEGA, "0.0");
        w.setNameEditable(false);
        w.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialOmega.Description"));
        this.getInitEditor().setParameters(new Parameter[]{t, r, th, v, w});
    }

    protected double[] getPolarState(double[] state, double[] ret) {
        if (state == null) {
            return null;
        }
        double dx = state[0];
        double dy = state[2];
        double vx = state[1];
        double vy = state[3];
        double r = Math.sqrt(dx * dx + dy * dy);
        double v = Math.sqrt(vx * vx + vy * vy);
        double rang = Math.atan2(dy, dx);
        double vang = Math.atan2(vy, vx);
        double dang = vang - rang;
        ret[0] = r;
        ret[1] = r == 0.0 ? v : v * Math.cos(dang);
        ret[2] = r == 0.0 ? vang : rang;
        ret[3] = r == 0.0 ? 0.0 : v * Math.sin(dang) / r;
        ret[4] = state[4];
        return ret;
    }

    @Override
    protected double[] getBoostState(PointMass target, int frameNumber) {
        return this.getPolarState(super.getBoostState(target, frameNumber), this.temp);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DynamicParticle p = (DynamicParticle)obj;
            XML.getLoader(ParticleModel.class).saveObject(control, obj);
            if (p.system != null) {
                control.setValue("in_system", true);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new DynamicParticlePolar();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            DynamicParticle p = (DynamicParticle)obj;
            XML.getLoader(ParticleModel.class).loadObject(control, obj);
            p.inSystem = control.getBoolean("in_system");
            return obj;
        }
    }
}

