/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.DynamicFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicParticlePolar;
import org.opensourcephysics.cabrillo.tracker.DynamicSystemInspector;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DynamicSystem
extends DynamicParticlePolar {
    protected DynamicParticle[] particles = new DynamicParticle[0];
    protected ParticleModel[] models = new ParticleModel[0];
    protected double[] particleState = new double[5];
    protected DynamicSystemInspector systemInspector;
    protected JMenuItem systemInspectorItem;
    protected String[] particleNames = new String[0];
    protected TTrack.StepArray realSteps;
    protected TTrack.StepArray noSteps;
    protected int systemInspectorX = Integer.MIN_VALUE;
    protected int systemInspectorY;
    protected TreeMap<Integer, double[]> frameRelativeStates = new TreeMap();
    protected boolean refreshing = false;
    protected static final String[] dataVariables = new String[]{"t", "x", "y", "r", "$\\theta$_{r}", "v_{x}", "v_{y}", "v", "$\\theta$_{v}", "a_{x}", "a_{y}", "a", "$\\theta$_{a}", "$\\theta$", "$\\omega$", "$\\alpha$", "step", "frame", "p_{x}", "p_{y}", "p", "$\\theta$_{p}", "r_{rel}", "$\\theta$_{rel}", "vr_{rel}", "$\\omega$_{rel}"};
    private double[] temp = new double[2];

    public DynamicSystem() {
        this(new DynamicParticle[0]);
    }

    public DynamicSystem(DynamicParticle[] parts) {
        this.defaultColors = new Color[]{new Color(51, 204, 51)};
        this.massField.setMinValue(0.0);
        this.realSteps = this.steps;
        this.noSteps = new TTrack.StepArray(this);
        Parameter massParam = (Parameter)this.getParamEditor().getObject("m");
        massParam.setExpressionEditable(false);
        this.setName(TrackerRes.getString("DynamicSystem.New.Name"));
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.SolidDiamond"), PointShapeFootprint.getFootprint("Footprint.Spot"), PointShapeFootprint.getFootprint("Footprint.SolidTriangle"), PointShapeFootprint.getFootprint("Footprint.SolidCircle"), PointShapeFootprint.getFootprint("Footprint.BoldVerticalLine"), PointShapeFootprint.getFootprint("Footprint.BoldHorizontalLine"), PointShapeFootprint.getFootprint("Footprint.BoldPositionVector")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.locked = true;
        this.setParticles(parts);
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        if (!(panel instanceof TrackerPanel) || this.tp == null) {
            return;
        }
        if (!this.initialized) {
            this.initialize(this.tp);
        }
        this.getModelBuilder();
        if (this.systemInspectorX != Integer.MIN_VALUE && this.tframe != null) {
            this.getSystemInspector();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = Math.max(this.tframe.getLocation().x + this.systemInspectorX, 0);
            x = Math.min(x, dim.width - this.systemInspector.getWidth());
            int y = Math.max(this.tframe.getLocation().y + this.systemInspectorY, 0);
            y = Math.min(y, dim.height - this.systemInspector.getHeight());
            this.systemInspector.setLocation(x, y);
            this.systemInspectorX = Integer.MIN_VALUE;
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    DynamicSystem.this.systemInspector.setVisible(true);
                }
            };
            SwingUtilities.invokeLater(runner);
        }
        if (this.particles.length == 0) {
            return;
        }
        if (this.tp.getFrameNumber() > this.getLastValidFrame()) {
            this.refreshSteps("DyamSys draw");
        }
        ParticleModel[] particleModelArray = this.getModels();
        int n = particleModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParticleModel next = particleModelArray[n2];
            next.drawMe(panel, _g);
            ++n2;
        }
    }

    @Override
    public void initialize(TrackerPanel trackerPanel) {
        if (this.initialized) {
            return;
        }
        ArrayList<DynamicParticle> toAdd = new ArrayList<DynamicParticle>();
        ArrayList<DynamicParticle> parts = trackerPanel.getDrawablesTemp(DynamicParticle.class);
        int i = 0;
        while (i < this.particleNames.length) {
            for (DynamicParticle p : parts) {
                if (!p.getName().equals(this.particleNames[i])) continue;
                toAdd.add(p);
                this.particleNames[i] = null;
            }
            ++i;
        }
        parts.clear();
        this.setParticles(toAdd.toArray(new DynamicParticle[0]));
        boolean empty = true;
        String[] stringArray = this.particleNames;
        int n = this.particleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            empty &= name == null;
            ++n2;
        }
        if (empty) {
            this.initialized = true;
            this.particleNames = new String[0];
        }
    }

    @Override
    public String getDisplayName() {
        StringBuffer buf = new StringBuffer(this.getName());
        buf.append(" (");
        if (this.particles == null || this.particles.length == 0) {
            buf.append(TrackerRes.getString("DynamicSystem.Empty"));
        } else {
            int i = 0;
            while (i < this.particles.length) {
                if (i > 0) {
                    buf.append(" + ");
                }
                buf.append(this.particles[i].getName());
                ++i;
            }
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        this.systemInspectorItem = new JMenuItem(TrackerRes.getString("DynamicSystem.MenuItem.Inspector"));
        this.systemInspectorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicSystemInspector inspector = DynamicSystem.this.getSystemInspector();
                inspector.updateDisplay();
                inspector.setVisible(true);
            }
        });
        JMenu menu = super.getMenu(trackerPanel, menu0);
        menu.add((Component)this.systemInspectorItem, 1);
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        this.massField.setEnabled(false);
        return list;
    }

    @Override
    public double getMass() {
        this.mass = 0.0;
        if (this.particles == null) {
            return this.mass;
        }
        int i = 0;
        while (i < this.particles.length) {
            this.mass += this.particles[i].getMass();
            ++i;
        }
        return this.mass;
    }

    @Override
    public boolean isDependent() {
        return true;
    }

    public boolean addParticle(DynamicParticle particle) {
        if (this.particles.length == 2) {
            return false;
        }
        DynamicParticle[] dynamicParticleArray = this.particles;
        int n = this.particles.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicParticle next = dynamicParticleArray[n2];
            if (next == particle) {
                return false;
            }
            ++n2;
        }
        DynamicParticle[] newParticles = new DynamicParticle[this.particles.length + 1];
        System.arraycopy(this.particles, 0, newParticles, 0, this.particles.length);
        newParticles[this.particles.length] = particle;
        return this.setParticles(newParticles);
    }

    public boolean removeParticle(DynamicParticle particle) {
        if (this.particles.length == 1 && this.particles[0] == particle) {
            return this.setParticles(new DynamicParticle[0]);
        }
        if (this.particles.length == 2) {
            if (this.particles[0] == particle) {
                return this.setParticles(new DynamicParticle[]{this.particles[1]});
            }
            if (this.particles[1] == particle) {
                return this.setParticles(new DynamicParticle[]{this.particles[0]});
            }
        }
        return false;
    }

    public boolean setParticles(DynamicParticle[] newParticles) {
        if (newParticles == null || newParticles.length > 2) {
            return false;
        }
        DynamicParticle[] dynamicParticleArray = newParticles;
        int n = newParticles.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicParticle next = dynamicParticleArray[n2];
            if (next == null) {
                return false;
            }
            ++n2;
        }
        if (newParticles.length == 2) {
            DynamicParticle problem = null;
            if (newParticles[0].isBoostedBy(newParticles[1])) {
                problem = newParticles[0];
            } else if (newParticles[1].isBoostedBy(newParticles[0])) {
                problem = newParticles[1];
            }
            if (problem != null) {
                String message = String.valueOf(TrackerRes.getString("DynamicSystem.Dialog.RemoveBooster.Message1")) + "\n" + TrackerRes.getString("DynamicSystem.Dialog.RemoveBooster.Message2") + " " + problem.getName() + "\n" + TrackerRes.getString("DynamicSystem.Dialog.RemoveBooster.Message3");
                int response = JOptionPane.showConfirmDialog(this.tframe, message, TrackerRes.getString("DynamicSystem.Dialog.RemoveBooster.Title"), 2, 2);
                if (response == 0) {
                    problem.setBooster(null);
                } else {
                    return false;
                }
            }
        }
        dynamicParticleArray = this.particles;
        n = this.particles.length;
        int message = 0;
        while (message < n) {
            DynamicParticle particle = dynamicParticleArray[message];
            boolean cleanMe = true;
            DynamicParticle[] dynamicParticleArray2 = newParticles;
            int n3 = newParticles.length;
            int n4 = 0;
            while (n4 < n3) {
                DynamicParticle next = dynamicParticleArray2[n4];
                if (next == particle) {
                    cleanMe = false;
                }
                ++n4;
            }
            if (cleanMe) {
                particle.system = null;
                particle.inSystem = false;
                particle.refreshInitialTime();
                particle.removePropertyChangeListener("mass", this);
                particle.removeStepListener(this);
                particle.setLastValidFrame(-1);
                particle.repaint();
                if (this.systemInspector != null) {
                    particle.removeListenerNCF(this.systemInspector);
                }
            }
            ++message;
        }
        this.particles = new DynamicParticle[newParticles.length];
        System.arraycopy(newParticles, 0, this.particles, 0, newParticles.length);
        this.state = new double[this.particles.length * 4 + 1];
        this.initialState = new double[this.particles.length * 4 + 1];
        this.models = new ParticleModel[0];
        if (this.systemInspector != null && this.systemInspector.isVisible()) {
            this.systemInspector.updateDisplay();
        }
        int n5 = this.myPoint = this.particles.length;
        this.points = new Point2D.Double[n5 + 1];
        this.points[n5] = new Point2D.Double();
        int i = 0;
        while (i < n5) {
            this.points[i] = new Point2D.Double();
            this.particles[i].removePropertyChangeListener("mass", this);
            this.particles[i].removeStepListener(this);
            this.particles[i].addPropertyChangeListener("mass", this);
            this.particles[i].addStepListener(this);
            this.particles[i].system = this;
            this.particles[i].refreshInitialTime();
            if (this.systemInspector != null) {
                this.particles[i].removeListenerNCF(this.systemInspector);
                this.particles[i].addListenerNCF(this.systemInspector);
            }
            ++i;
        }
        this.refreshSystemParameters();
        if (this.modelBuilder != null) {
            this.modelBuilder.refreshDropdown(null);
        }
        if (n5 == 0 && this.steps != this.noSteps) {
            this.steps = this.noSteps;
            this.fireStepsChanged();
        } else if (n5 > 0 && this.steps != this.realSteps) {
            this.steps = this.realSteps;
            this.fireStepsChanged();
        }
        this.setLastValidFrame(-1);
        this.repaint();
        return true;
    }

    @Override
    public void delete() {
        this.setParticles(new DynamicParticle[0]);
        super.delete();
    }

    @Override
    public void getRate(double[] state, double[] rate) {
        rate[rate.length - 1] = 1.0;
        if (this.particles.length == 0) {
            return;
        }
        if (this.particles.length == 1) {
            double[] particleState = this.getState(this.particles[0]);
            this.particles[0].getXYForces(particleState, this.temp);
            double m = this.particles[0].getMass();
            rate[0] = state[1];
            rate[1] = this.temp[0] / m;
            rate[2] = state[3];
            rate[3] = this.temp[1] / m;
            return;
        }
        UserFunction[] f = this.getFunctionEditor().getMainFunctions();
        double[] polarState = this.getRelativePolarState(state);
        double cos = Math.cos(polarState[2]);
        double sin = Math.sin(polarState[2]);
        double fr = f[0].evaluate(polarState);
        double ftheta = f[1].evaluate(polarState);
        int i = 0;
        while (i < this.particles.length) {
            double[] particleState = this.getState(this.particles[i]);
            this.particles[i].getXYForces(particleState, this.temp);
            double m = this.particles[i].getMass();
            int sign = i == 0 ? 1 : -1;
            rate[4 * i] = state[4 * i + 1];
            rate[4 * i + 1] = (this.temp[0] + (double)sign * fr * cos - (double)sign * ftheta * sin) / m;
            rate[4 * i + 2] = state[4 * i + 3];
            rate[4 * i + 3] = (this.temp[1] + (double)sign * fr * sin + (double)sign * ftheta * cos) / m;
            ++i;
        }
    }

    @Override
    public double[] getInitialValues() {
        double[] state = null;
        if (this.initialState.length != this.particles.length * 4 + 1) {
            this.initialState = new double[this.particles.length * 4 + 1];
        }
        int i = 0;
        while (i < this.particles.length) {
            state = this.particles[i].getInitialState();
            System.arraycopy(state, 0, this.initialState, 4 * i, 4);
            ++i;
        }
        if (state != null) {
            this.initialState[this.initialState.length - 1] = state[state.length - 1];
        } else if (this.tp != null) {
            double t0 = this.tp.getPlayer().getVideoClip().getStartTime();
            this.initialState[this.initialState.length - 1] = t0 / 1000.0;
        }
        return this.initialState;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "transform": {
                PointMass track;
                ImageCoordSystem coords = this.tp.getCoords();
                if (coords instanceof ReferenceFrame && ((track = ((ReferenceFrame)coords).getOriginTrack()) == this || this.particles.length > 0 && track == this.particles[0] || this.particles.length > 1 && track == this.particles[1])) {
                    return;
                }
                this.setLastValidFrame(-1);
                this.refreshSteps("DynSys.property change transform ");
                break;
            }
            case "mass": 
            case "function": {
                super.propertyChange(e);
                this.refreshSystemParameters();
                if (this.tp == null) break;
                TFrame.repaintT(this.tp);
                break;
            }
            case "name": {
                super.propertyChange(e);
                this.refreshSystemParameters();
                break;
            }
            default: {
                super.propertyChange(e);
            }
        }
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        if (this.systemInspector != null) {
            FontSizer.setFonts(this.systemInspector, level);
            this.systemInspector.updateDisplay();
        }
    }

    public DynamicSystemInspector getSystemInspector() {
        if (this.systemInspector == null) {
            this.systemInspector = new DynamicSystemInspector(this);
            this.systemInspector.setLocation(200, 200);
            this.addListenerNCF(this.systemInspector);
        }
        return this.systemInspector;
    }

    @Override
    public double[] getInitialState() {
        return this.getInitialValues();
    }

    @Override
    protected void refreshData(DatasetManager data, TrackerPanel panel) {
        int i0;
        if (this.refreshDataLater || panel == null || data == null) {
            return;
        }
        int count = 25;
        Integer panelID = panel.getID();
        Object[] rotationData = this.getRotationData();
        double[] theta_data = (double[])rotationData[0];
        double[] omega_data = (double[])rotationData[1];
        double[] alpha_data = (double[])rotationData[2];
        VideoPlayer player = panel.getPlayer();
        VideoClip clip = player.getVideoClip();
        double dt = player.getMeanStepDuration() / 1000.0;
        ImageCoordSystem coords = panel.getCoords();
        Step[] stepArray = this.getSteps();
        int pt = 0;
        int len = stepArray.length;
        double[][] validData = new double[count + 1][len];
        this.dataFrames.clear();
        int i = 0;
        while (i < len) {
            if (stepArray[i] != null && clip.includesFrame(i)) {
                double[] relState;
                int stepNumber = clip.frameToStep(i);
                double t = player.getStepTime(stepNumber) / 1000.0;
                PositionStep.Position p = ((PositionStep)stepArray[i]).getPosition();
                Point2D wp = p.getWorldPosition(panel);
                validData[0][pt] = wp.getX();
                validData[1][pt] = wp.getY();
                validData[2][pt] = wp.distance(0.0, 0.0);
                validData[3][pt] = Math.atan2(wp.getY(), wp.getX());
                validData[12][pt] = theta_data[i];
                validData[13][pt] = omega_data[i] / dt;
                validData[14][pt] = alpha_data[i] / (dt * dt);
                validData[15][pt] = stepNumber;
                validData[16][pt] = i;
                VectorStep veloc = this.getVelocity(i, panelID);
                if (veloc == null) {
                    validData[4][pt] = Double.NaN;
                    validData[5][pt] = Double.NaN;
                    validData[6][pt] = Double.NaN;
                    validData[7][pt] = Double.NaN;
                    validData[17][pt] = Double.NaN;
                    validData[18][pt] = Double.NaN;
                    validData[19][pt] = Double.NaN;
                    validData[20][pt] = Double.NaN;
                } else {
                    double imageX = veloc.getXComponent();
                    double imageY = veloc.getYComponent();
                    double d = coords.imageToWorldXComponent(i, imageX, imageY) / dt;
                    validData[4][pt] = d;
                    double x = d;
                    double d2 = coords.imageToWorldYComponent(i, imageX, imageY) / dt;
                    validData[5][pt] = d2;
                    double y = d2;
                    double d3 = Math.sqrt(x * x + y * y);
                    validData[6][pt] = d3;
                    double r = d3;
                    double d4 = Math.atan2(y, x);
                    validData[7][pt] = d4;
                    double slope = d4;
                    double mass = this.getMass();
                    validData[17][pt] = mass * x;
                    validData[18][pt] = mass * y;
                    validData[19][pt] = mass * r;
                    validData[20][pt] = mass * slope;
                }
                VectorStep accel = this.getAcceleration(i, panelID);
                if (accel == null) {
                    validData[8][pt] = Double.NaN;
                    validData[9][pt] = Double.NaN;
                    validData[10][pt] = Double.NaN;
                    validData[11][pt] = Double.NaN;
                } else {
                    double imageX = accel.getXComponent();
                    double imageY = accel.getYComponent();
                    double d = coords.imageToWorldXComponent(i, imageX, imageY) / (dt * dt);
                    validData[8][pt] = d;
                    double x = d;
                    double d5 = coords.imageToWorldYComponent(i, imageX, imageY) / (dt * dt);
                    validData[9][pt] = d5;
                    double y = d5;
                    validData[10][pt] = Math.sqrt(x * x + y * y);
                    validData[11][pt] = Math.atan2(y, x);
                }
                if (this.particles.length == 2 && (relState = this.frameRelativeStates.get(i)) != null) {
                    validData[21][pt] = relState[0];
                    validData[22][pt] = relState[2];
                    validData[23][pt] = relState[1];
                    validData[24][pt] = relState[3];
                } else {
                    validData[21][pt] = Double.NaN;
                    validData[22][pt] = Double.NaN;
                    validData[23][pt] = Double.NaN;
                    validData[24][pt] = Double.NaN;
                }
                validData[count][pt] = t;
                this.dataFrames.add(i);
                ++pt;
            }
            ++i;
        }
        this.clearColumns(data, count, dataVariables, "PointMass.Data.Description.", validData, pt);
        int i2 = i0 = count - 3;
        while (i2 < count) {
            this.dataDescriptions[i2] = TrackerRes.getString("DynamicSystem.Data.Description." + (i2 - i0));
            ++i2;
        }
        Double m = this.getMass();
        String desc = TrackerRes.getString("ParticleModel.Parameter.Mass.Description");
        data.setConstant("m", m, m.toString(), desc);
    }

    @Override
    public void dispose() {
        int i = 0;
        while (i < this.particles.length) {
            this.particles[i].removePropertyChangeListener("mass", this);
            this.particles[i].removeStepListener(this);
            this.particles[i].system = null;
            ++i;
        }
        super.dispose();
        if (this.systemInspector != null) {
            this.systemInspector.dispose();
        }
    }

    @Override
    protected void refreshInitialTime() {
        super.refreshInitialTime();
        DynamicParticle[] dynamicParticleArray = this.particles;
        int n = this.particles.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicParticle next = dynamicParticleArray[n2];
            next.refreshInitialTime();
            ++n2;
        }
    }

    protected void refreshSystemParameters() {
        if (this.refreshing) {
            return;
        }
        this.refreshing = true;
        double[] polarState = this.particles.length == 2 ? this.getRelativePolarState(this.getInitialState()) : new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double zeroPosition = 1.0E-12;
        if (this.tp != null) {
            zeroPosition = 0.001 / this.tp.getCoords().getScaleX(0);
        }
        double zeroVelocity = 1.0E-11;
        if (this.tp != null) {
            zeroVelocity = 1000.0 * zeroPosition / this.tp.getPlayer().getMeanStepDuration();
        }
        double zeroAngle = 1.0E-5;
        double zeroOmega = 1.0E-4;
        if (this.tp != null) {
            zeroOmega = 1000.0 * zeroAngle / this.tp.getPlayer().getMeanStepDuration();
        }
        String relative = "_" + TrackerRes.getString("DynamicSystem.Parameter.Name.Relative");
        String particleNames = " ";
        if (this.particles.length > 0) {
            particleNames = String.valueOf(particleNames) + TrackerRes.getString("DynamicSystem.Parameter.Of") + " ";
            particleNames = String.valueOf(particleNames) + this.particles[0].getName() + " ";
            particleNames = String.valueOf(particleNames) + TrackerRes.getString("DynamicSystem.Parameter.RelativeTo") + " ";
            particleNames = String.valueOf(particleNames) + (this.particles.length > 1 ? this.particles[1].getName() : this.particles[0].getName());
        }
        String desc = TrackerRes.getString("DynamicSystem.Parameter.Mass.Description");
        this.getParamEditor().setExpression("m", String.valueOf(this.getMass()), false);
        this.getParamEditor().setDescription("m", desc);
        Parameter m1 = (Parameter)this.getParamEditor().getObject("m1");
        Parameter m2 = (Parameter)this.getParamEditor().getObject("m2");
        desc = TrackerRes.getString("DynamicSystem.Parameter.ParticleMass.Description");
        if (this.particles.length == 0) {
            if (m1 != null) {
                m1.setNameEditable(true);
                m1.setExpressionEditable(true);
                this.getParamEditor().removeObject(m1, false);
            }
            if (m2 != null) {
                m2.setNameEditable(true);
                m2.setExpressionEditable(true);
                this.getParamEditor().removeObject(m2, false);
            }
        } else {
            String value = FunctionEditor.format(this.particles[0].getMass(), 0.0);
            if (m1 == null) {
                m1 = this.createParameter("m1", value, String.valueOf(desc) + " " + this.particles[0].getName());
                this.getParamEditor().addObject(m1, 1, false, false);
            } else {
                this.getParamEditor().setExpression("m1", value, false);
            }
            if (this.particles.length > 1) {
                value = FunctionEditor.format(this.particles[1].getMass(), 0.0);
                if (m2 == null) {
                    m2 = this.createParameter("m2", value, String.valueOf(desc) + " " + this.particles[1].getName());
                    this.getParamEditor().addObject(m2, 2, false, false);
                } else {
                    this.getParamEditor().setExpression("m2", value, false);
                }
            } else if (m2 != null) {
                m2.setNameEditable(true);
                m2.setExpressionEditable(true);
                this.getParamEditor().removeObject(m2, false);
            }
        }
        DynamicParticle[] dynamicParticleArray = this.particles;
        int n = this.particles.length;
        int n2 = 0;
        while (n2 < n) {
            DynamicParticle particle = dynamicParticleArray[n2];
            if (particle.modelBooster != null) {
                particle.modelBooster.setBooster(particle.modelBooster.booster);
            }
            ++n2;
        }
        Parameter t = (Parameter)this.getInitEditor().getObject("t");
        String value = FunctionEditor.format(polarState[0], zeroPosition);
        desc = TrackerRes.getString("DynamicParticle.Parameter.InitialR.Description");
        Parameter r = this.createParameter("r" + relative, value, String.valueOf(desc) + particleNames);
        value = FunctionEditor.format(polarState[2], zeroAngle);
        desc = TrackerRes.getString("DynamicParticle.Parameter.InitialTheta.Description");
        Parameter theta = this.createParameter(String.valueOf(FunctionEditor.THETA) + relative, value, String.valueOf(desc) + particleNames);
        value = FunctionEditor.format(polarState[1], zeroVelocity);
        desc = TrackerRes.getString("DynamicParticle.Parameter.InitialVelocityR.Description");
        Parameter vr = this.createParameter("vr" + relative, value, String.valueOf(desc) + particleNames);
        value = FunctionEditor.format(polarState[3], zeroOmega);
        desc = TrackerRes.getString("DynamicParticle.Parameter.InitialOmega.Description");
        Parameter omega = this.createParameter(String.valueOf(FunctionEditor.OMEGA) + relative, value, String.valueOf(desc) + particleNames);
        this.getInitEditor().setParameters(new Parameter[]{t, r, theta, vr, omega});
        this.refreshing = false;
    }

    @Override
    protected void setTracePositions(double[] state) {
        int n = this.particles.length;
        if (n == 0) {
            return;
        }
        double mass = 0.0;
        double xcm = 0.0;
        double ycm = 0.0;
        int i = 0;
        while (i < n) {
            this.points[i].setLocation(state[4 * i], state[4 * i + 2]);
            double m = this.particles[i].getMass();
            mass += m;
            xcm += m * state[4 * i];
            ycm += m * state[4 * i + 2];
            ++i;
        }
        this.points[n].setLocation(xcm / mass, ycm / mass);
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionEditor = new UserFunctionEditor();
        this.functionPanel = new DynamicFunctionPanel(this.functionEditor, this);
        UserFunction[] uf = new UserFunction[2];
        String[] funcVars = new String[]{"r", "vr", FunctionEditor.THETA, FunctionEditor.OMEGA, "t"};
        String internal = TrackerRes.getString("DynamicSystem.Force.Name.Internal");
        uf[0] = new UserFunction("fr_" + internal, funcVars, TrackerRes.getString("DynamicSystem.ForceFunction.R.Description"));
        uf[1] = new UserFunction("f" + FunctionEditor.THETA + "_" + internal, funcVars, TrackerRes.getString("DynamicSystem.ForceFunction.Theta.Description"));
        this.functionEditor.setMainFunctions(uf);
        this.createMassAndTimeParameters();
    }

    protected double[] getSystemState(double[] state) {
        double mass = 0.0;
        int i = 0;
        while (i < this.particleState.length) {
            this.particleState[i] = 0.0;
            ++i;
        }
        this.particleState[4] = state[state.length - 1];
        if (this.particles.length > 0) {
            i = 0;
            while (i < this.particles.length) {
                double m = this.particles[i].getMass();
                mass += m;
                this.particleState[0] = this.particleState[0] + m * state[4 * i];
                this.particleState[1] = this.particleState[1] + m * state[4 * i + 1];
                this.particleState[2] = this.particleState[2] + m * state[4 * i + 2];
                this.particleState[3] = this.particleState[3] + m * state[4 * i + 3];
                ++i;
            }
            this.particleState[0] = this.particleState[0] / mass;
            this.particleState[1] = this.particleState[1] / mass;
            this.particleState[2] = this.particleState[2] / mass;
            this.particleState[3] = this.particleState[3] / mass;
        }
        return this.particleState;
    }

    protected double[] getState(DynamicParticle particle) {
        int i = 0;
        while (i < this.particles.length) {
            if (this.particles[i] == particle) {
                this.particleState[0] = this.state[4 * i];
                this.particleState[1] = this.state[4 * i + 1];
                this.particleState[2] = this.state[4 * i + 2];
                this.particleState[3] = this.state[4 * i + 3];
                this.particleState[4] = this.state[this.state.length - 1];
                return this.particleState;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected ParticleModel[] getModels() {
        if (this.models.length != this.particles.length + 1) {
            this.models = new ParticleModel[this.particles.length + 1];
            int i = 0;
            while (i < this.models.length - 1) {
                this.models[i] = this.particles[i];
                ++i;
            }
            this.models[this.models.length - 1] = this;
        }
        return this.models;
    }

    protected double[] getRelativePolarState(double[] state) {
        double[] polarState = new double[5];
        double dx = state[0] - state[4];
        double dy = state[2] - state[6];
        double vx = state[1] - state[5];
        double vy = state[3] - state[7];
        double r = Math.sqrt(dx * dx + dy * dy);
        double v = Math.sqrt(vx * vx + vy * vy);
        double rang = Math.atan2(dy, dx);
        double vang = Math.atan2(vy, vx);
        double dang = vang - rang;
        polarState[0] = r;
        polarState[1] = r == 0.0 ? v : v * Math.cos(dang);
        polarState[2] = r == 0.0 ? vang : rang;
        polarState[3] = r == 0.0 ? 0.0 : v * Math.sin(dang) / r;
        polarState[4] = state[8];
        double[] toSave = new double[polarState.length];
        System.arraycopy(polarState, 0, toSave, 0, polarState.length);
        int frameNum = this.tp.getFrameNumber();
        this.frameRelativeStates.put(frameNum, toSave);
        return polarState;
    }

    private Parameter createParameter(String name, String expression, String description) {
        Parameter p = new Parameter(name, expression);
        p.setExpressionEditable(false);
        p.setNameEditable(false);
        p.setDescription(description);
        return p;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            DynamicSystem system = (DynamicSystem)obj;
            if (system.particles.length > 0) {
                String[] names = new String[system.particles.length];
                int i = 0;
                while (i < names.length) {
                    names[i] = system.particles[i].getName();
                    ++i;
                }
                control.setValue("particles", names);
            }
            if (system.systemInspector != null && system.systemInspector.isVisible()) {
                Point p = system.systemInspector.getLocation();
                TFrame frame = system.tframe;
                control.setValue("system_inspector_x", p.x - frame.getLocation().x);
                control.setValue("system_inspector_y", p.y - frame.getLocation().y);
            }
            XML.getLoader(ParticleModel.class).saveObject(control, obj);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new DynamicSystem();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            XML.getLoader(ParticleModel.class).loadObject(control, obj);
            DynamicSystem system = (DynamicSystem)obj;
            String[] names = (String[])control.getObject("particles");
            if (names != null) {
                system.particleNames = names;
                system.initialized = false;
            }
            system.systemInspectorX = control.getInt("system_inspector_x");
            system.systemInspectorY = control.getInt("system_inspector_y");
            return obj;
        }
    }
}

