/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class DynamicSystemInspector
extends JDialog
implements PropertyChangeListener {
    protected TFrame frame;
    protected Integer panelID;
    protected DynamicSystem system;
    protected boolean isVisible;
    protected int particleCount;
    protected JButton closeButton;
    protected JButton helpButton;
    protected ActionListener changeParticleListener;
    protected JPanel[] particlePanels;
    protected JButton[] changeButtons;
    protected DynamicParticle[] selectedParticles;
    protected JLabel[] particleLabels;
    protected TButton[] particleButtons;
    protected JPanel[] labelPanels;
    protected DynamicParticle newParticle;
    protected TButton systemButton;
    protected MouseListener selectListener;

    public DynamicSystemInspector(DynamicSystem track) {
        super(JOptionPane.getFrameForComponent(track.tp), false);
        this.system = track;
        this.particleCount = 2;
        TrackerPanel panel = track.tp;
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        if (this.panelID != null) {
            panel.addPropertyChangeListener("track", this);
            if (this.frame != null) {
                this.frame.addPropertyChangeListener("tab", this);
            }
        }
        this.setResizable(false);
        this.createGUI();
        this.initialize();
    }

    public void initialize() {
        FontSizer.setFonts(this, FontSizer.getLevel());
        this.updateDisplay();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "tab": {
                if (this.panelID != null && ((TrackerPanel)e.getNewValue()).getID() == this.panelID) {
                    this.setVisible(this.isVisible);
                } else {
                    boolean vis = this.isVisible;
                    this.setVisible(false);
                    this.isVisible = vis;
                }
                return;
            }
            case "track": {
                if (!(e.getNewValue() instanceof DynamicParticle)) break;
                this.newParticle = (DynamicParticle)e.getNewValue();
            }
        }
        this.updateDisplay();
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        this.isVisible = vis;
    }

    @Override
    public void dispose() {
        if (this.panelID != null) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            trackerPanel.removePropertyChangeListener("track", this);
            ArrayList<DynamicParticle> list = trackerPanel.getDrawablesTemp(DynamicParticle.class);
            int i = 0;
            int ni = list.size();
            while (i < ni) {
                list.get(ni).removeListenerNCF(this);
                ++i;
            }
            list.clear();
            if (this.frame != null) {
                this.frame.removePropertyChangeListener("tab", this);
            }
            this.frame = null;
            this.panelID = null;
        }
        super.dispose();
    }

    private void createGUI() {
        this.changeParticleListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JButton button = (JButton)e.getSource();
                final int n = button == DynamicSystemInspector.this.changeButtons[0] ? 0 : 1;
                JPopupMenu popup = new JPopupMenu();
                boolean hasPopupItems = false;
                JMenu cloneMenu = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.Clone"));
                final TrackerPanel trackerPanel = DynamicSystemInspector.this.frame.getTrackerPanelForID(DynamicSystemInspector.this.panelID);
                ArrayList<DynamicParticle> list = trackerPanel.getDrawablesTemp(DynamicParticle.class);
                int i = 0;
                int ni = list.size();
                while (i < ni) {
                    DynamicParticle p = list.get(i);
                    if (!(p instanceof DynamicSystem)) {
                        JMenuItem cloneItem = new JMenuItem(p.getName(), p.getFootprint().getIcon(21, 16));
                        final String name = p.getName();
                        cloneItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                (this).DynamicSystemInspector.this.newParticle = null;
                                TActions.cloneAction(trackerPanel, name);
                                if ((this).DynamicSystemInspector.this.newParticle != null) {
                                    (this).DynamicSystemInspector.this.newParticle.getModelBuilder();
                                    (this).DynamicSystemInspector.this.selectedParticles[n] = (this).DynamicSystemInspector.this.newParticle;
                                    DynamicSystemInspector.this.updateSystem();
                                }
                            }
                        });
                        cloneMenu.add(cloneItem);
                        if (p != DynamicSystemInspector.this.selectedParticles[0] && p != DynamicSystemInspector.this.selectedParticles[1] && p.system == null) {
                            hasPopupItems = true;
                            final JMenuItem item = new JMenuItem(p.getName(), p.getFootprint().getIcon(21, 16)){

                                @Override
                                public Dimension getPreferredSize() {
                                    Dimension dim = super.getPreferredSize();
                                    int w = button.getPreferredSize().width - 2;
                                    dim.width = Math.max(w, dim.width);
                                    return dim;
                                }
                            };
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    (this).DynamicSystemInspector.this.selectedParticles[n] = DynamicSystemInspector.this.getParticle(item.getText());
                                    DynamicSystemInspector.this.updateSystem();
                                }
                            });
                            popup.add(item);
                        }
                    }
                    ++i;
                }
                list.clear();
                if (hasPopupItems) {
                    popup.addSeparator();
                }
                JMenu newMenu = new JMenu(TrackerRes.getString("TrackControl.Button.NewTrack")){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dim = super.getPreferredSize();
                        int w = button.getPreferredSize().width - 2;
                        dim.width = Math.max(w, dim.width);
                        return dim;
                    }
                };
                popup.add(newMenu);
                JMenuItem cartesianItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Cartesian"));
                cartesianItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).DynamicSystemInspector.this.newParticle = null;
                        TActions.dynamicParticleAction(trackerPanel);
                        if ((this).DynamicSystemInspector.this.newParticle != null) {
                            (this).DynamicSystemInspector.this.newParticle.getModelBuilder();
                            (this).DynamicSystemInspector.this.selectedParticles[n] = (this).DynamicSystemInspector.this.newParticle;
                            DynamicSystemInspector.this.updateSystem();
                        }
                    }
                });
                newMenu.add(cartesianItem);
                JMenuItem polarItem = new JMenuItem(TrackerRes.getString("TMenuBar.MenuItem.Polar"));
                polarItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).DynamicSystemInspector.this.newParticle = null;
                        TActions.dynamicParticlePolarAction(trackerPanel);
                        if ((this).DynamicSystemInspector.this.newParticle != null) {
                            (this).DynamicSystemInspector.this.newParticle.getModelBuilder();
                            (this).DynamicSystemInspector.this.selectedParticles[n] = (this).DynamicSystemInspector.this.newParticle;
                            DynamicSystemInspector.this.updateSystem();
                        }
                    }
                });
                newMenu.add(polarItem);
                if (cloneMenu.getItemCount() > 0) {
                    popup.add(cloneMenu);
                }
                JMenuItem noneItem = new JMenuItem(TrackerRes.getString("DynamicSystemInspector.ParticleName.None"));
                noneItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).DynamicSystemInspector.this.newParticle = null;
                        (this).DynamicSystemInspector.this.selectedParticles[n] = null;
                        DynamicSystemInspector.this.updateSystem();
                    }
                });
                popup.addSeparator();
                popup.add(noneItem);
                FontSizer.setFonts(popup, FontSizer.getLevel());
                popup.show(button, 0, button.getHeight());
            }
        };
        this.selectListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TButton button = (TButton)e.getSource();
                DynamicParticle track = DynamicSystemInspector.this.getParticle(button.getText());
                TrackerPanel trackerPanel = DynamicSystemInspector.this.frame.getTrackerPanelForID(DynamicSystemInspector.this.panelID);
                trackerPanel.setSelectedTrack(track);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DynamicSystemInspector.this.closeButton.requestFocusInWindow();
            }
        };
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        JPanel inspectorPanel = new JPanel(new GridLayout(1, 2));
        contentPane.add((Component)inspectorPanel, "Center");
        this.particlePanels = new JPanel[this.particleCount];
        this.changeButtons = new JButton[this.particleCount];
        this.particleLabels = new JLabel[this.particleCount];
        this.particleButtons = new TButton[this.particleCount];
        this.labelPanels = new JPanel[this.particleCount];
        int i = 0;
        while (i < this.particleCount) {
            this.particlePanels[i] = new JPanel(new BorderLayout());
            inspectorPanel.add(this.particlePanels[i]);
            this.changeButtons[i] = new JButton();
            this.changeButtons[i].addActionListener(this.changeParticleListener);
            this.particleLabels[i] = new JLabel(TrackerRes.getString("DynamicSystemInspector.ParticleName.None")){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.height = DynamicSystemInspector.this.systemButton.getPreferredSize().height;
                    return dim;
                }
            };
            this.particleLabels[i].setHorizontalAlignment(0);
            this.particleLabels[i].setAlignmentX(0.5f);
            this.particleButtons[i] = new TButton();
            this.particleButtons[i].setContentAreaFilled(false);
            this.particleButtons[i].addMouseListener(this.selectListener);
            this.particleButtons[i].setAlignmentX(0.5f);
            this.labelPanels[i] = new JPanel();
            this.labelPanels[i].setLayout(new BoxLayout(this.labelPanels[i], 1));
            this.labelPanels[i].add(this.particleLabels[i]);
            this.particlePanels[i].add((Component)this.labelPanels[i], "North");
            JPanel center = new JPanel();
            center.add(this.changeButtons[i]);
            this.particlePanels[i].add((Component)center, "Center");
            ++i;
        }
        this.systemButton = new TButton();
        this.systemButton.setText(this.system.getName());
        this.systemButton.setIcon(this.system.getFootprint().getIcon(21, 16));
        this.systemButton.setContentAreaFilled(false);
        this.systemButton.addMouseListener(this.selectListener);
        this.systemButton.setAlignmentX(0.5f);
        this.helpButton = new JButton();
        this.helpButton.setForeground(new Color(0, 0, 102));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicSystemInspector.this.frame.showHelp("system", 0);
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicSystemInspector.this.setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel();
        contentPane.add((Component)buttonbar, "South");
        buttonbar.add(this.helpButton);
        buttonbar.add(this.closeButton);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.systemButton);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 2, 0));
        contentPane.add((Component)panel, "North");
    }

    private void updateSystem() {
        if (this.selectedParticles[0] == null && this.selectedParticles[1] == null) {
            this.system.setParticles(new DynamicParticle[0]);
        } else if (this.selectedParticles[0] == null) {
            this.system.setParticles(new DynamicParticle[]{this.selectedParticles[1]});
        } else if (this.selectedParticles[1] == null) {
            this.system.setParticles(new DynamicParticle[]{this.selectedParticles[0]});
        } else {
            this.system.setParticles(this.selectedParticles);
        }
        if (this.newParticle == null) {
            this.newParticle = this.system;
        }
        this.system.getModelBuilder().setSelectedPanel(this.newParticle.getName());
        this.updateDisplay();
        this.setVisible(true);
    }

    private DynamicParticle getParticle(String name) {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        return trackerPanel.getTrackByName(DynamicParticle.class, name);
    }

    protected void updateDisplay() {
        this.setTitle(TrackerRes.getString("DynamicSystemInspector.Title"));
        this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        this.selectedParticles = new DynamicParticle[this.particleCount];
        this.systemButton.setText(this.system.getName());
        this.systemButton.setIcon(this.system.getFootprint().getIcon(21, 16));
        this.systemButton.setToolTipText(String.valueOf(TrackerRes.getString("TrackControl.Button.Properties.ToolTip")) + " " + this.system.getName());
        boolean empty = true;
        int i = 0;
        while (i < this.particleCount) {
            Border etched = BorderFactory.createEtchedBorder();
            TitledBorder title = BorderFactory.createTitledBorder(etched, String.valueOf(TrackerRes.getString("DynamicSystemInspector.Border.Title")) + " " + (i + 1));
            FontSizer.setFonts(title, FontSizer.getLevel());
            this.particlePanels[i].setBorder(title);
            this.changeButtons[i].setText(TrackerRes.getString("DynamicSystemInspector.Button.Change"));
            this.labelPanels[i].removeAll();
            if (this.system.particles.length > i && this.system.particles[i] != null) {
                empty = false;
                this.selectedParticles[i] = this.system.particles[i];
                this.particleButtons[i].setText(this.selectedParticles[i].getName());
                this.particleButtons[i].setIcon(this.selectedParticles[i].getFootprint().getIcon(21, 16));
                this.particleButtons[i].setToolTipText(String.valueOf(TrackerRes.getString("TrackControl.Button.Properties.ToolTip")) + " " + this.selectedParticles[i].getName());
                this.labelPanels[i].setLayout(new BoxLayout(this.labelPanels[i], 1));
                this.labelPanels[i].add(this.particleButtons[i]);
            } else {
                this.selectedParticles[i] = null;
                this.particleLabels[i].setText(TrackerRes.getString("DynamicSystemInspector.ParticleName.None"));
                this.labelPanels[i].setLayout(new BorderLayout());
                this.labelPanels[i].add(this.particleLabels[i]);
            }
            FontSizer.setFonts(this.labelPanels[i], FontSizer.getLevel());
            ++i;
        }
        this.changeButtons[this.particleCount - 1].setEnabled(!empty);
        this.changeButtons[0].requestFocusInWindow();
        this.pack();
        TFrame.repaintT(this);
    }
}

