/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javajs.async.AsyncDialog;
import javajs.async.AsyncFileChooser;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.CenterOfMass;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TableTView;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class ExportDataDialog
extends JDialog {
    protected static ExportDataDialog dataExporter;
    private static String fullPrecisionPattern;
    private static File lastSaved;
    private static Color buttonColor;
    private static HashMap<Integer, BitSet> selectedTracksBSMap;
    private static HashMap<Class<? extends TTrack>, ArrayList<String>> allColumnsMap;
    private static HashMap<Class<? extends TTrack>, BitSet> selectedColumnsBSMap;
    private static HashMap<Integer, Boolean> userHasSetDataMap;
    protected Integer panelID;
    private ArrayList<Integer> allTracks = new ArrayList();
    private TFrame frame;
    private JButton saveAsButton;
    private JButton closeButton;
    private JButton copyButton;
    private JComponent tracksPanel;
    private JComponent columnsPanel;
    private JComponent delimiterPanel;
    private JComponent formatPanel;
    private MyButton tracksButton;
    private MyButton columnsButton;
    private MyButton delimiterButton;
    private MyButton formatButton;
    private TracksDialog tracksDialog;
    private ColumnsDialog columnsDialog;
    private JPopupMenu popup;
    private NumberField.NumberFormatter defaultFormatter;
    private Class<? extends TTrack> trackType;
    private boolean asFormatted = true;
    private int firstTextColumnIndex = -1;
    private int firstSelectedTextColumnIndex = -1;
    private ActionListener checkboxListener = e -> this.showColumnsDialogAction(Integer.parseInt(e.getActionCommand()));

    static {
        fullPrecisionPattern = "0.000000E0";
        lastSaved = new File("");
        buttonColor = Color.WHITE;
    }

    public static ExportDataDialog getDialog(TrackerPanel panel) {
        if (dataExporter == null) {
            dataExporter = new ExportDataDialog(panel);
        } else {
            dataExporter.setTrackerPanel(panel);
            dataExporter.refreshGUI();
        }
        return dataExporter;
    }

    private ExportDataDialog(TrackerPanel panel) {
        super((Frame)panel.getTFrame(), true);
        this.frame = panel.getTFrame();
        this.setResizable(false);
        this.defaultFormatter = new NumberField.NumberFormatter(false);
        this.defaultFormatter.setSigFigs(4);
        this.createGUI();
        this.setTrackerPanel(panel);
        this.refreshGUI();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    private void createGUI() {
        this.popup = new JPopupMenu();
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        Box settingsPanel = Box.createVerticalBox();
        contentPane.add((Component)settingsPanel, "Center");
        JPanel upper = new JPanel(new GridLayout(1, 2));
        JPanel lower = new JPanel(new GridLayout(1, 2));
        this.tracksPanel = new JPanel(new GridLayout(0, 1));
        this.tracksButton = new MyButton();
        this.tracksButton.addActionListener(e -> this.showTracksDialogAction());
        this.tracksPanel.add(this.tracksButton);
        this.delimiterPanel = new JPanel(new GridLayout(0, 1));
        this.delimiterButton = new MyButton(this){

            @Override
            protected JPopupMenu getPopup() {
                return this.getDelimiterMenu();
            }
        };
        this.delimiterPanel.add(this.delimiterButton);
        this.columnsPanel = new JPanel(new GridLayout(0, 1));
        this.columnsButton = new MyButton();
        this.columnsButton.addActionListener(e -> this.showColumnsDialogAction(-1));
        this.columnsPanel.add(this.columnsButton);
        this.formatPanel = new JPanel(new GridLayout(0, 1));
        this.formatButton = new MyButton(this){

            @Override
            protected JPopupMenu getPopup() {
                return this.getFormatMenu();
            }
        };
        this.formatPanel.add(this.formatButton);
        settingsPanel.add(upper);
        settingsPanel.add(lower);
        upper.add(this.tracksPanel);
        upper.add(this.columnsPanel);
        lower.add(this.formatPanel);
        lower.add(this.delimiterPanel);
        this.saveAsButton = new JButton();
        this.saveAsButton.setForeground(new Color(0, 0, 102));
        this.saveAsButton.addActionListener(e -> this.saveAsAction());
        this.copyButton = new JButton();
        this.copyButton.setForeground(new Color(0, 0, 102));
        this.copyButton.addActionListener(e -> {
            String data = this.getDataString();
            if (data == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            OSPRuntime.copy(data, null);
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(e -> {
            this.allTracks.clear();
            this.setVisible(false);
        });
        JPanel buttonbar = new JPanel();
        contentPane.add((Component)buttonbar, "South");
        buttonbar.add(this.saveAsButton);
        buttonbar.add(this.copyButton);
        buttonbar.add(this.closeButton);
        allColumnsMap = new HashMap();
        userHasSetDataMap = new HashMap();
    }

    private void setTrackerPanel(TrackerPanel panel) {
        ArrayList<TTrack> newTracks = panel.getExportableTracks();
        if (newTracks.isEmpty()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.allTracks.clear();
        int i = 0;
        while (i < newTracks.size()) {
            TTrack next = newTracks.get(i);
            this.allTracks.add(next.getID());
            Class<? extends TTrack> type = this.getTrackType(next);
            ArrayList<String> allColumns = allColumnsMap.get(type);
            if (allColumns == null) {
                allColumns = new ArrayList();
                allColumnsMap.put(type, allColumns);
                ArrayList<Dataset> sets = next.getData(panel).getDatasetsRaw();
                int j = 0;
                while (j < sets.size()) {
                    Dataset dataset = sets.get(j);
                    allColumns.add(dataset.getYColumnName());
                    ++j;
                }
            }
            ArrayList<String> textColNames = next.getTextColumnNames();
            int m = 0;
            while (m < textColNames.size()) {
                if (!allColumns.contains(textColNames.get(m))) {
                    if (this.firstTextColumnIndex == -1) {
                        this.firstTextColumnIndex = allColumns.size();
                    }
                    allColumns.add(textColNames.get(m));
                }
                ++m;
            }
            ++i;
        }
        if (panel.getID() != this.panelID) {
            this.panelID = panel.getID();
            if (!userHasSetDataMap.containsKey(this.panelID)) {
                BitSet selectedTracksBS = this.getSelectedTracksBitSet(this.panelID);
                selectedTracksBS.clear();
                this.selectTrack(TTrack.getTrack(this.allTracks.get(0)), true);
            }
        }
        if (!userHasSetDataMap.containsKey(this.panelID)) {
            userHasSetDataMap.put(this.panelID, false);
        }
        if (!userHasSetDataMap.get(this.panelID).booleanValue()) {
            this.selectDefaultColumns(true);
        }
    }

    private void selectTrack(TTrack track, boolean selected) {
        BitSet selectedTracksBS = this.getSelectedTracksBitSet(this.panelID);
        selectedTracksBS.set(track.getID(), selected);
        if (selectedTracksBS.isEmpty()) {
            this.trackType = null;
        } else if (selectedTracksBS.cardinality() == 1) {
            track = TTrack.getTrack(selectedTracksBS.nextSetBit(0));
            this.trackType = this.getTrackType(track);
        } else if (this.trackType == CenterOfMass.class) {
            this.trackType = this.getTrackType(track);
        }
    }

    private void selectDefaultColumns(boolean selectTrack) {
        TViewChooser[] choosers = this.frame.getVisibleChoosers(this.panelID);
        int i = 0;
        while (i < choosers.length) {
            TableTView tView;
            TTrack track;
            TView view;
            if (choosers[i] != null && (view = choosers[i].getSelectedView()).getViewType() == 1 && (track = (tView = (TableTView)view).getSelectedTrack()) != null && this.getTrackType(track) == this.trackType) {
                if (selectTrack) {
                    BitSet selectedTracksBS = this.getSelectedTracksBitSet(this.panelID);
                    selectedTracksBS.clear();
                    this.selectTrack(track, true);
                }
                TableTrackView tableView = (TableTrackView)tView.getTrackView(track);
                String[] cols = tableView.getVisibleColumns();
                BitSet selectedColsBS = this.getSelectedColumnsBitSet(this.trackType);
                selectedColsBS.clear();
                ArrayList<String> allColumnNames = allColumnsMap.get(this.trackType);
                int j = 0;
                while (j < cols.length) {
                    String var = cols[j];
                    int k = 0;
                    while (k < allColumnNames.size()) {
                        if (allColumnNames.get(k).equals(var)) {
                            selectedColsBS.set(k);
                            break;
                        }
                        ++k;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
    }

    private BitSet getSelectedTracksBitSet(Integer panelID) {
        BitSet selected;
        if (selectedTracksBSMap == null) {
            selectedTracksBSMap = new HashMap();
        }
        if ((selected = selectedTracksBSMap.get(panelID)) == null) {
            selected = new BitSet();
            selectedTracksBSMap.put(panelID, selected);
        }
        return selected;
    }

    private BitSet getSelectedColumnsBitSet(Class<? extends TTrack> type) {
        BitSet namesBS;
        if (selectedColumnsBSMap == null) {
            selectedColumnsBSMap = new HashMap();
        }
        if ((namesBS = selectedColumnsBSMap.get(type)) == null) {
            namesBS = new BitSet();
            selectedColumnsBSMap.put(type, namesBS);
        }
        return namesBS;
    }

    private TTrack getFirstSelectedTrack() {
        BitSet selectedTracksBS = this.getSelectedTracksBitSet(this.panelID);
        return selectedTracksBS.isEmpty() ? null : TTrack.getTrack(selectedTracksBS.nextSetBit(0));
    }

    protected void setDelimiterAction(String delimName) {
        boolean isAdd = delimName.equals(TrackerRes.getString("ExportDataDialog.Delimiter.Add"));
        boolean isRemove = delimName.equals(TrackerRes.getString("ExportDataDialog.Delimiter.Remove"));
        String delimiter = TrackerIO.getDelimiter();
        if (isAdd) {
            String response = GUIUtils.showInputDialog(this, TrackerRes.getString("TableTrackView.Dialog.CustomDelimiter.Message"), TrackerRes.getString("TableTrackView.Dialog.CustomDelimiter.Title"), -1, delimiter);
            if (response != null && !"".equals(response.toString())) {
                String s = response.toString();
                TrackerIO.setDelimiter(s);
                TrackerIO.addCustomDelimiter(s);
            }
        } else if (isRemove) {
            Object[] choices = TrackerIO.customDelimiters.values().toArray(new String[1]);
            new AsyncDialog().showInputDialog(this, TrackerRes.getString("TableTrackView.Dialog.RemoveDelimiter.Message"), TrackerRes.getString("TableTrackView.Dialog.RemoveDelimiter.Title"), -1, null, choices, null, e -> {
                String s = e.getActionCommand();
                if (s != null) {
                    TrackerIO.removeCustomDelimiter(s);
                }
            });
        } else if (TrackerIO.getDelimiters().keySet().contains(delimName)) {
            TrackerIO.setDelimiter(TrackerIO.getDelimiters().get(delimName));
        } else if (TrackerIO.customDelimiters.keySet().contains(delimName)) {
            TrackerIO.setDelimiter((String)TrackerIO.customDelimiters.get(delimName));
        }
        this.refreshGUI();
    }

    private void setFormatAction(String format) {
        this.asFormatted = format.equals(TrackerRes.getString("TableTrackView.MenuItem.Formatted"));
        this.refreshGUI();
    }

    private String getPatternFromTable(String var) {
        TViewChooser[] choosers = this.frame.getVisibleChoosers(this.panelID);
        int i = 0;
        while (i < choosers.length) {
            TableTView tableTView;
            TTrack track;
            TView view;
            if (choosers[i] != null && (view = choosers[i].getSelectedView()).getViewType() == 1 && (track = (tableTView = (TableTView)view).getSelectedTrack()) != null) {
                TableTrackView trackView = (TableTrackView)tableTView.getTrackView(track);
                return trackView.getDataTable().getFormatPattern(var);
            }
            ++i;
        }
        return null;
    }

    private void showTracksDialogAction() {
        if (this.tracksDialog == null) {
            this.tracksDialog = new TracksDialog();
        }
        this.tracksDialog.refreshDisplay();
        FontSizer.setFonts(this.tracksDialog, FontSizer.getLevel());
        this.tracksDialog.pack();
        Point p = this.tracksButton.getLocationOnScreen();
        p.x -= this.tracksButton.getLocation().x;
        p.y += this.tracksButton.getHeight();
        this.tracksDialog.setLocation(p);
        this.tracksDialog.setVisible(true);
    }

    private void showColumnsDialogAction(int num) {
        if (num < 0) {
            if (this.columnsDialog == null) {
                this.columnsDialog = new ColumnsDialog();
            }
            this.columnsDialog.rebuild();
            FontSizer.setFonts(this.columnsDialog, FontSizer.getLevel());
            this.columnsDialog.pack();
            Point p = this.columnsButton.getLocationOnScreen();
            p.x -= this.columnsButton.getLocation().x;
            p.y += this.columnsButton.getHeight();
            this.columnsDialog.setLocation(p);
            this.columnsDialog.setVisible(true);
        } else {
            boolean add = this.columnsDialog.checkBoxes[num].isSelected();
            BitSet namesBS = this.getSelectedColumnsBitSet(this.trackType);
            namesBS.set(num, add);
            userHasSetDataMap.put(this.panelID, true);
            this.refreshGUI();
        }
    }

    private Class<? extends TTrack> getTrackType(TTrack track) {
        return PointMass.class.isAssignableFrom(track.getClass()) ? (track.getClass() == CenterOfMass.class || track.getClass() == DynamicSystem.class ? CenterOfMass.class : PointMass.class) : (Vector.class.isAssignableFrom(track.getClass()) ? Vector.class : track.getClass());
    }

    private void saveAsAction() {
        AsyncFileChooser chooser = TrackerIO.getChooser();
        chooser.setSelectedFile(lastSaved);
        File[] files = TrackerIO.getChooserFilesAsync(this.frame, "save data", null);
        if (files == null || files.length == 0) {
            return;
        }
        File file = files[0];
        if (XML.getExtension(file.getName()) == null) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".txt");
        }
        if (!VideoIO.canWrite(file)) {
            return;
        }
        String output = this.getDataString();
        if (output == null) {
            return;
        }
        this.write(file, output);
        lastSaved = file;
    }

    private String getDataString() {
        String pattern;
        StringBuffer buf = new StringBuffer();
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        BitSet selectedTracksBS = this.getSelectedTracksBitSet(this.panelID);
        if (selectedTracksBS.isEmpty()) {
            return null;
        }
        TTrack[] selectedTracks = new TTrack[selectedTracksBS.cardinality()];
        int n = 0;
        int k = selectedTracksBS.nextSetBit(0);
        while (k >= 0) {
            selectedTracks[n++] = TTrack.getTrack(k);
            k = selectedTracksBS.nextSetBit(k + 1);
        }
        ArrayList<String> allColumnNames = allColumnsMap.get(this.trackType);
        int datasetCount = allColumnNames.size();
        BitSet namesBS = this.getSelectedColumnsBitSet(this.trackType);
        String[] selectedColumnNames = new String[namesBS.cardinality()];
        n = 0;
        this.firstSelectedTextColumnIndex = -1;
        int k2 = namesBS.nextSetBit(0);
        while (k2 >= 0) {
            selectedColumnNames[n++] = allColumnNames.get(k2);
            if (this.firstTextColumnIndex > -1 && k2 >= this.firstTextColumnIndex && this.firstSelectedTextColumnIndex == -1) {
                this.firstSelectedTextColumnIndex = n - 1;
            }
            k2 = namesBS.nextSetBit(k2 + 1);
        }
        String xVar = null;
        int selectedTrackCount = selectedTracks.length;
        ArrayList[] selectedTrackData = new ArrayList[selectedTrackCount];
        n = 0;
        int i = 0;
        while (i < selectedTracks.length) {
            TTrack track = selectedTracks[i];
            selectedTrackData[i] = track.getData(panel).getDatasetsRaw();
            if (xVar == null) {
                xVar = ((Dataset)selectedTrackData[i].get(0)).getXColumnName();
            }
            ++i;
        }
        boolean isFrames = this.trackType != LineProfile.class;
        int frameIndex = isFrames ? -1 : 0;
        int i2 = 0;
        while (i2 < datasetCount) {
            if (allColumnNames.get(i2).equals("frame")) {
                frameIndex = i2;
                break;
            }
            ++i2;
        }
        if (frameIndex == -1) {
            return null;
        }
        int colsPerTrack = selectedColumnNames.length;
        double[][][] dataValues = new double[selectedTrackCount][colsPerTrack][];
        String[][][] textValues = new String[selectedTrackCount][colsPerTrack][];
        double[][] frameNumbers = new double[selectedTrackCount][];
        int i3 = 0;
        while (i3 < selectedTrackCount) {
            TTrack track = selectedTracks[i3];
            ArrayList datasets = selectedTrackData[i3];
            Dataset dataset = (Dataset)datasets.get(frameIndex);
            frameNumbers[i3] = this.getPoints(dataset, isFrames);
            int k3 = 0;
            while (k3 < selectedColumnNames.length) {
                block58: {
                    String colName = selectedColumnNames[k3];
                    int j = 0;
                    while (j < datasetCount) {
                        if (datasets.size() <= j) break;
                        dataset = (Dataset)datasets.get(j);
                        if (dataset.getYColumnName().equals(colName)) {
                            dataValues[i3][k3] = this.getPoints(dataset, true);
                            if (!this.frame.isAnglesInRadians() && (colName.startsWith(Tracker.THETA) || colName.startsWith(Tracker.OMEGA) || colName.startsWith(Tracker.ALPHA))) {
                                double[] angles = dataValues[i3][k3];
                                int m = 0;
                                while (m < angles.length) {
                                    int n2 = m++;
                                    angles[n2] = angles[n2] * 57.29577951308232;
                                }
                            }
                            break block58;
                        }
                        ++j;
                    }
                    ArrayList<String> textColNames = track.getTextColumnNames();
                    int m = 0;
                    while (m < textColNames.size()) {
                        if (textColNames.get(m).equals(colName)) {
                            textValues[i3][k3] = new String[frameNumbers[i3].length];
                            int a = 0;
                            while (a < frameNumbers[i3].length) {
                                textValues[i3][k3][a] = track.getTextColumnEntry(colName, (int)frameNumbers[i3][a]);
                                ++a;
                            }
                        }
                        ++m;
                    }
                }
                ++k3;
            }
            ++i3;
        }
        int min = Integer.MAX_VALUE;
        int max = -1;
        int i4 = 0;
        while (i4 < selectedTrackCount) {
            if (frameNumbers[i4].length != 0) {
                min = (int)Math.min((double)min, frameNumbers[i4][0]);
                max = (int)Math.max((double)max, frameNumbers[i4][frameNumbers[i4].length - 1]);
            }
            ++i4;
        }
        boolean hasData = max >= 0;
        int frameCount = hasData ? max - min + 1 : 0;
        int[][] indices = new int[selectedTrackCount][frameCount];
        String timePattern = null;
        String[][] patterns = new String[selectedTrackCount][colsPerTrack];
        DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance();
        nf.setDecimalFormatSymbols(OSPRuntime.getDecimalFormatSymbols());
        if (hasData) {
            int i5;
            int i6 = 0;
            while (i6 < selectedTrackCount) {
                Arrays.fill(indices[i6], -1);
                n = 0;
                int j = min;
                while (j <= max) {
                    if (frameNumbers[i6].length > 0 && frameNumbers[i6][n] == (double)j) {
                        indices[i6][j - min] = n++;
                        if (n >= frameNumbers[i6].length) break;
                    }
                    ++j;
                }
                ++i6;
            }
            TTrack track = null;
            int i7 = 0;
            while (i7 < selectedTracks.length) {
                if (selectedTracks[i7].getClass() == this.trackType) {
                    track = selectedTracks[i7];
                    break;
                }
                ++i7;
            }
            if (track == null) {
                track = selectedTracks[0];
            }
            TreeMap<String, String> defaultPatternMap = TTrack.getDefaultFormatPatterns(track.ttype);
            if (this.asFormatted) {
                i5 = 0;
                while (i5 < selectedTrackCount) {
                    track = selectedTracks[i5];
                    Map<String, NumberField[]> fieldMap = track.getNumberFields();
                    NumberField[] fields = fieldMap.get(xVar);
                    timePattern = fields != null && fields.length > 0 ? fields[0].getFixedPattern() : this.getPatternFromTable(xVar);
                    int j = 0;
                    while (j < colsPerTrack) {
                        String var = selectedColumnNames[j];
                        pattern = null;
                        if (var != null) {
                            fields = fieldMap.get(var);
                            String string = pattern = fields != null && fields.length > 0 ? fields[0].getFixedPattern() : this.getPatternFromTable(var);
                            if (pattern == null) {
                                pattern = (String)defaultPatternMap.get(var);
                            }
                        }
                        patterns[i5][j] = pattern;
                        ++j;
                    }
                    ++i5;
                }
            } else {
                timePattern = isFrames ? fullPrecisionPattern : "0";
                i5 = 0;
                while (i5 < selectedTrackCount) {
                    int j = 0;
                    while (j < colsPerTrack) {
                        String var = selectedColumnNames[j];
                        String pattern2 = (String)defaultPatternMap.get(var);
                        patterns[i5][j] = "0".equals(pattern2) ? pattern2 : "0.000000E0";
                        ++j;
                    }
                    ++i5;
                }
            }
        }
        if (selectedTrackCount > 1) {
            buf.append("#multi:");
            buf.append(XML.NEW_LINE);
        }
        buf.append(TrackerIO.getDelimiter());
        int i8 = 0;
        while (i8 < selectedTrackCount) {
            TTrack track = selectedTracks[i8];
            buf.append(track.getName());
            int j = 0;
            while (j < colsPerTrack) {
                if (!this.isUndefinedTextColumn(j, textValues[i8][j])) {
                    buf.append(TrackerIO.getDelimiter());
                }
                ++j;
            }
            ++i8;
        }
        buf.append(XML.NEW_LINE);
        buf.append(xVar);
        buf.append(TrackerIO.getDelimiter());
        i8 = 0;
        while (i8 < selectedTrackCount) {
            int j = 0;
            while (j < colsPerTrack) {
                if (selectedColumnNames[j] == null) {
                    buf.append(TrackerIO.getDelimiter());
                } else if (!this.isUndefinedTextColumn(j, textValues[i8][j])) {
                    buf.append(TeXParser.removeSubscripting(selectedColumnNames[j]));
                    buf.append(TrackerIO.getDelimiter());
                }
                ++j;
            }
            ++i8;
        }
        buf.append(XML.NEW_LINE);
        if (hasData) {
            VideoPlayer player = panel.getPlayer();
            int i9 = min;
            while (i9 <= max) {
                double value;
                double d = value = isFrames ? player.getFrameTime(i9) / 1000.0 : (double)i9;
                if (timePattern != null && !"".equals(timePattern)) {
                    nf.applyPattern(timePattern);
                    buf.append(nf.format(value));
                } else {
                    buf.append(this.defaultFormatter.getText(value));
                }
                int j = 0;
                while (j < selectedTrackCount) {
                    double[][] data = dataValues[j];
                    int k4 = 0;
                    while (k4 < colsPerTrack) {
                        if (!this.isUndefinedTextColumn(k4, textValues[j][k4])) {
                            buf.append(TrackerIO.getDelimiter());
                            if (indices[j][i9 - min] > -1) {
                                if (data[k4] == null) {
                                    String s;
                                    String[][] text = textValues[j];
                                    if (text[k4] != null && (s = text[k4][indices[j][i9 - min]]) != null && !s.equals("null")) {
                                        buf.append(s);
                                    }
                                } else {
                                    value = data[k4][indices[j][i9 - min]];
                                    if (!Double.isNaN(value)) {
                                        pattern = patterns[j][k4];
                                        if (pattern != null && !"".equals(pattern)) {
                                            nf.applyPattern(pattern);
                                            buf.append(nf.format(value));
                                        } else {
                                            buf.append(this.defaultFormatter.getText(value));
                                        }
                                    }
                                }
                            }
                        }
                        ++k4;
                    }
                    ++j;
                }
                buf.append(XML.NEW_LINE);
                ++i9;
            }
        }
        return buf.toString();
    }

    private boolean isUndefinedTextColumn(int col, String[] textEntries) {
        if (this.firstSelectedTextColumnIndex > -1 && col >= this.firstSelectedTextColumnIndex) {
            return textEntries == null;
        }
        return false;
    }

    private double[] getPoints(Dataset dataset, boolean isY) {
        double[] p = isY ? dataset.getYPointsRaw() : dataset.getXPointsRaw();
        return Arrays.copyOf(p, dataset.getIndex());
    }

    private JPopupMenu getDelimiterMenu() {
        boolean hasCustom;
        Object item;
        this.popup.removeAll();
        for (String key : TrackerIO.getDelimiters().keySet()) {
            item = new JMenuItem(key);
            ((AbstractButton)item).addActionListener(e -> this.setDelimiterAction(key));
            this.popup.add((JMenuItem)item);
        }
        boolean bl = hasCustom = !TrackerIO.customDelimiters.isEmpty();
        if (hasCustom) {
            this.popup.addSeparator();
            for (String key : TrackerIO.customDelimiters.keySet()) {
                JMenuItem item2 = new JMenuItem(key);
                item2.addActionListener(e -> this.setDelimiterAction(key));
                this.popup.add(item2);
            }
        }
        this.popup.addSeparator();
        String add = TrackerRes.getString("ExportDataDialog.Delimiter.Add");
        item = new JMenuItem(add);
        ((AbstractButton)item).addActionListener(e -> this.setDelimiterAction(add));
        this.popup.add((JMenuItem)item);
        if (hasCustom) {
            String rem = TrackerRes.getString("ExportDataDialog.Delimiter.Remove");
            item = new JMenuItem(rem);
            ((AbstractButton)item).addActionListener(e -> this.setDelimiterAction(rem));
            this.popup.add((JMenuItem)item);
        }
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        return this.popup;
    }

    private JPopupMenu getFormatMenu() {
        this.popup.removeAll();
        String form = TrackerRes.getString("TableTrackView.MenuItem.Formatted");
        String unform = TrackerRes.getString("TableTrackView.MenuItem.Unformatted");
        JMenuItem item = new JMenuItem(form);
        item.addActionListener(e -> this.setFormatAction(form));
        this.popup.add(item);
        item = new JMenuItem(unform);
        item.addActionListener(e -> this.setFormatAction(unform));
        this.popup.add(item);
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        return this.popup;
    }

    private void refreshGUI() {
        String s;
        String title = TrackerRes.getString("ExportDataDialog.Title");
        this.setTitle(title);
        title = TrackerRes.getString("Undo.Description.Tracks");
        Border space = BorderFactory.createEmptyBorder(0, 4, 6, 4);
        TitledBorder titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, FontSizer.getLevel());
        this.tracksPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        title = TrackerRes.getString("ExportDataDialog.Subtitle.Delimiter");
        titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, FontSizer.getLevel());
        this.delimiterPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        title = TrackerRes.getString("TableTrackView.Button.SelectTableData");
        titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, FontSizer.getLevel());
        this.columnsPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        title = TrackerRes.getString("ExportDataDialog.Subtitle.Format");
        titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, FontSizer.getLevel());
        this.formatPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        this.saveAsButton.setText(TrackerRes.getString("ExportVideoDialog.Button.SaveAs"));
        this.copyButton.setText(TrackerRes.getString("CircleFitter.MenuItem.CopyToClipboard.Text"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        BitSet selectedTracksBS = this.getSelectedTracksBitSet(this.panelID);
        TTrack track = this.getFirstSelectedTrack();
        String string = s = track == null ? "" : track.getName();
        if (selectedTracksBS.cardinality() > 1) {
            s = String.valueOf(s) + " + " + (selectedTracksBS.cardinality() - 1);
        }
        this.tracksButton.setText(s);
        s = "";
        int k = selectedTracksBS.nextSetBit(0);
        while (k >= 0) {
            s = String.valueOf(s) + TTrack.getTrack(k).getName() + ", ";
            k = selectedTracksBS.nextSetBit(k + 1);
        }
        int end = Math.min(s.length() - 2, 300);
        this.tracksButton.setToolTipText(s.length() > 1 ? s.substring(0, end) : null);
        String delim = TrackerIO.getDelimiter();
        for (String key : TrackerIO.getDelimiters().keySet()) {
            if (!delim.equals(TrackerIO.getDelimiters().get(key))) continue;
            this.delimiterButton.setText(key);
        }
        for (String key : TrackerIO.customDelimiters.keySet()) {
            if (!delim.equals(TrackerIO.customDelimiters.get(key))) continue;
            this.delimiterButton.setText(key);
        }
        this.delimiterButton.setToolTipText(this.delimiterButton.getText());
        String form = TrackerRes.getString("TableTrackView.MenuItem.Formatted");
        String unform = TrackerRes.getString("TableTrackView.MenuItem.Unformatted");
        this.formatButton.setText(this.asFormatted ? form : unform);
        this.formatButton.setToolTipText(this.formatButton.getText());
        s = "";
        if (track != null) {
            ArrayList<String> allColumnNames = allColumnsMap.get(this.trackType);
            s = track.getClass().getSimpleName().contains("LineProfile") ? "n" : "t";
            String xVar = s;
            BitSet selectedColsBS = this.getSelectedColumnsBitSet(this.trackType);
            int count = 0;
            int max = 2;
            int i = 0;
            while (i < allColumnNames.size()) {
                String name = allColumnNames.get(i);
                if (selectedColsBS.get(i) && ++count <= max) {
                    s = String.valueOf(s) + ", " + TeXParser.removeSubscripting(name);
                }
                ++i;
            }
            if (count > max) {
                s = String.valueOf(s) + " + " + (count - max);
            }
            String tooltip = xVar;
            int k2 = selectedColsBS.nextSetBit(0);
            while (k2 >= 0) {
                tooltip = String.valueOf(tooltip) + ", " + allColumnNames.get(k2);
                k2 = selectedColsBS.nextSetBit(k2 + 1);
            }
            this.columnsButton.setToolTipText(tooltip);
        }
        this.columnsButton.setText(s);
        FontSizer.setFonts(this, FontSizer.getLevel());
        this.pack();
    }

    private String write(File file, String content) {
        if (file.exists() && !file.canWrite()) {
            JOptionPane.showMessageDialog(this.frame, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
            return null;
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            Charset charset = Charset.forName("UTF-8");
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, charset));
            out.write(content);
            ((Writer)out).flush();
            ((Writer)out).close();
            if (file.exists()) {
                return XML.getAbsolutePath(file);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    protected void clear() {
        this.frame = null;
        this.panelID = null;
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }

    private class ColumnsDialog
    extends JDialog {
        private JPanel contentPane;
        private JCheckBox[] checkBoxes;
        private JPanel columnsPanel;
        private JButton okButton;
        private TitledBorder instructions;

        private ColumnsDialog() {
            super((Frame)ExportDataDialog.this.frame, true);
            this.createGUI();
        }

        private void createGUI() {
            this.columnsPanel = new JPanel();
            this.columnsPanel.setLayout(new GridLayout(0, 4));
            this.columnsPanel.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 4));
            JScrollPane columnsScroller = new JScrollPane(this.columnsPanel);
            Border etched = BorderFactory.createEtchedBorder();
            this.instructions = BorderFactory.createTitledBorder(etched, "");
            columnsScroller.setBorder(this.instructions);
            this.okButton = new JButton();
            this.okButton.addActionListener(e -> this.setVisible(false));
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.okButton);
            this.contentPane = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.height = (int)((double)dim.height * 1.1);
                    return dim;
                }
            };
            this.setContentPane(this.contentPane);
            this.contentPane.add((Component)columnsScroller, "Center");
            this.contentPane.add((Component)buttonPanel, "South");
        }

        private void refreshDisplay() {
            this.okButton.setText(TrackerRes.getString("Dialog.Button.OK"));
            this.setTitle(TrackerRes.getString("ExportDataDialog.ColumnsDialog.Title"));
            this.instructions.setTitle(TrackerRes.getString("ExportDataDialog.TracksDialog.Instructions"));
            ExportDataDialog.this.refreshGUI();
        }

        private void refreshCheckboxes() {
            ArrayList allColumnNames = (ArrayList)allColumnsMap.get(ExportDataDialog.this.trackType);
            if (this.checkBoxes == null || allColumnNames.size() != this.checkBoxes.length) {
                this.checkBoxes = new JCheckBox[allColumnNames.size()];
            }
            BitSet namesBS = ExportDataDialog.this.getSelectedColumnsBitSet(ExportDataDialog.this.trackType);
            this.columnsPanel.removeAll();
            int i = 0;
            while (i < allColumnNames.size()) {
                String name = (String)allColumnNames.get(i);
                if (this.checkBoxes[i] == null) {
                    this.checkBoxes[i] = new JCheckBox();
                    this.checkBoxes[i].setBackground(Color.white);
                    this.checkBoxes[i].setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 0));
                    this.checkBoxes[i].setActionCommand("" + i);
                    this.checkBoxes[i].addActionListener(ExportDataDialog.this.checkboxListener);
                    this.checkBoxes[i].setOpaque(false);
                }
                this.checkBoxes[i].setSelected(namesBS.get(i));
                this.checkBoxes[i].setName(name);
                this.checkBoxes[i].setText(TeXParser.removeSubscripting(name));
                this.columnsPanel.add(this.checkBoxes[i]);
                ++i;
            }
            this.refreshDisplay();
        }

        private void rebuild() {
            FontSizer.setFonts(this);
            this.setResizable(true);
            this.refreshCheckboxes();
            this.pack();
        }
    }

    class MyButton
    extends TButton {
        MyButton() {
            this.setIcon(TViewChooser.DOWN_ARROW_ICON);
            this.setHorizontalTextPosition(10);
            this.alwaysShowBorder(true);
            this.setBackground(buttonColor);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            int w = (int)(FontSizer.getFactor() * 100.0);
            dim.width = Math.max(w, dim.width);
            return dim;
        }
    }

    public class TracksDialog
    extends JDialog {
        private JButton okButton;
        private JButton selectAllButton;
        private JButton selectNoneButton;
        private JPanel checkboxPanel;
        private ActionListener checkboxListener;
        private TitledBorder instructions;
        private boolean allTracksSelected;

        public TracksDialog() {
            super((Frame)ExportDataDialog.this.frame, true);
            this.setResizable(false);
            this.createGUI();
            this.refreshDisplay();
            this.pack();
        }

        @Override
        public void setVisible(boolean vis) {
            BitSet selectedTracksBS = ExportDataDialog.this.getSelectedTracksBitSet(ExportDataDialog.this.panelID);
            if (vis) {
                this.refreshDisplay();
            } else if (selectedTracksBS.isEmpty()) {
                ExportDataDialog.this.selectTrack(TTrack.getTrack((Integer)ExportDataDialog.this.allTracks.get(0)), true);
                ExportDataDialog.this.refreshGUI();
            }
            super.setVisible(vis);
        }

        private void createGUI() {
            JPanel inspectorPanel = new JPanel(new BorderLayout());
            this.setContentPane(inspectorPanel);
            this.checkboxPanel = new JPanel(new GridLayout(0, 2));
            Border etched = BorderFactory.createEtchedBorder();
            this.instructions = BorderFactory.createTitledBorder(etched, "");
            this.checkboxPanel.setBorder(this.instructions);
            inspectorPanel.add((Component)this.checkboxPanel, "Center");
            this.checkboxListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int id = Integer.parseInt(e.getActionCommand());
                    TTrack track = TTrack.getTrack(id);
                    JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)e.getSource();
                    ExportDataDialog.this.selectTrack(track, checkbox.isSelected());
                    TracksDialog.this.refreshDisplay();
                    userHasSetDataMap.put(((TracksDialog)TracksDialog.this).ExportDataDialog.this.panelID, true);
                }
            };
            this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
            this.okButton.setForeground(new Color(0, 0, 102));
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TracksDialog.this.setVisible(false);
                }
            });
            this.selectAllButton = new JButton(TrackerRes.getString("PlotGuestDialog.Button.SelectAll.Text"));
            this.selectAllButton.setForeground(new Color(0, 0, 102));
            this.selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BitSet selectedTracksBS = ExportDataDialog.this.getSelectedTracksBitSet(((TracksDialog)TracksDialog.this).ExportDataDialog.this.panelID);
                    for (Integer id : ExportDataDialog.this.allTracks) {
                        TTrack track = TTrack.getTrack(id);
                        if (!ExportDataDialog.this.trackType.isAssignableFrom(ExportDataDialog.this.getTrackType(track)) && !ExportDataDialog.this.getTrackType(track).isAssignableFrom(ExportDataDialog.this.trackType)) continue;
                        selectedTracksBS.set(id);
                    }
                    TracksDialog.this.refreshDisplay();
                }
            });
            this.selectNoneButton = new JButton(TrackerRes.getString("PlotGuestDialog.Button.SelectNone.Text"));
            this.selectNoneButton.setForeground(new Color(0, 0, 102));
            this.selectNoneButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BitSet selectedTracksBS = ExportDataDialog.this.getSelectedTracksBitSet(((TracksDialog)TracksDialog.this).ExportDataDialog.this.panelID);
                    selectedTracksBS.clear();
                    ExportDataDialog.this.trackType = null;
                    TracksDialog.this.refreshDisplay();
                }
            });
            JPanel buttonbar = new JPanel();
            buttonbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
            inspectorPanel.add((Component)buttonbar, "South");
            buttonbar.add(this.selectAllButton);
            buttonbar.add(this.selectNoneButton);
            buttonbar.add(this.okButton);
        }

        protected void refreshDisplay() {
            this.setTitle(TrackerRes.getString("ExportDataDialog.TracksDialog.Title"));
            this.instructions.setTitle(TrackerRes.getString("ExportDataDialog.TracksDialog.Instructions"));
            int tracksPerRow = 3;
            int rows = 1 + ExportDataDialog.this.allTracks.size() / tracksPerRow;
            this.checkboxPanel.setLayout(new GridLayout(rows, 0));
            this.checkboxPanel.removeAll();
            BitSet selectedTracksBS = ExportDataDialog.this.getSelectedTracksBitSet(ExportDataDialog.this.panelID);
            this.allTracksSelected = !selectedTracksBS.isEmpty();
            int i = 0;
            while (i < ExportDataDialog.this.allTracks.size()) {
                TTrack next = TTrack.getTrack((Integer)ExportDataDialog.this.allTracks.get(i));
                JCheckBoxMenuItem checkbox = new JCheckBoxMenuItem(next.getName(), next.getFootprint().getIcon(21, 16));
                checkbox.setBorderPainted(false);
                boolean selected = selectedTracksBS.get(next.getID());
                checkbox.setSelected(selected);
                checkbox.setEnabled(ExportDataDialog.this.trackType == null || ExportDataDialog.this.trackType.isAssignableFrom(ExportDataDialog.this.getTrackType(next)) || ExportDataDialog.this.getTrackType(next).isAssignableFrom(ExportDataDialog.this.trackType));
                if (checkbox.isEnabled()) {
                    this.allTracksSelected = this.allTracksSelected && selected;
                }
                checkbox.setActionCommand(String.valueOf(next.getID()));
                checkbox.addActionListener(this.checkboxListener);
                this.checkboxPanel.add(checkbox);
                ++i;
            }
            this.okButton.setText(TrackerRes.getString("Dialog.Button.OK"));
            this.okButton.setEnabled(!selectedTracksBS.isEmpty());
            boolean isEnabled = !selectedTracksBS.isEmpty() && !this.allTracksSelected;
            Class type = ExportDataDialog.this.trackType == CenterOfMass.class ? PointMass.class : ExportDataDialog.this.trackType;
            this.selectAllButton.setText(String.valueOf(TrackerRes.getString("PlotGuestDialog.Button.SelectAll.Text")) + (ExportDataDialog.this.trackType != null ? " " + type.getSimpleName() : ""));
            this.selectAllButton.setEnabled(isEnabled);
            this.selectNoneButton.setText(TrackerRes.getString("PlotGuestDialog.Button.SelectNone.Text"));
            this.selectNoneButton.setEnabled(!selectedTracksBS.isEmpty());
            FontSizer.setFonts(this.checkboxPanel, FontSizer.getLevel());
            this.pack();
            TFrame.repaintT(this);
            ExportDataDialog.this.refreshGUI();
        }
    }
}

