/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.PlotTView;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.DeinterlaceFilter;
import org.opensourcephysics.media.core.ImageVideoRecorder;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.core.VideoRecorder;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.FontSizer;

public class ExportVideoDialog
extends JDialog {
    protected static final String PROPERTY_EXPORTVIDEO_VIDEOSAVED = "video_saved";
    protected static final String PROPERTY_EXPORTVIDEO_VIDEOCANCELED = "video_cancelled";
    protected TFrame frame;
    protected Integer panelID;
    protected JButton saveAsButton;
    protected JButton closeButton;
    protected JComponent sizePanel;
    protected JComponent viewPanel;
    protected JComponent contentPanel;
    protected JComponent formatPanel;
    protected JComboBox<String> formatDropdown;
    protected JComboBox<String> viewDropdown;
    protected JComboBox<String> sizeDropdown;
    protected JComboBox<String> contentDropdown;
    protected JLabel clipPropertiesLabel;
    protected AffineTransform transform = new AffineTransform();
    protected BufferedImage sizedImage;
    protected HashMap<Object, JComponent> views;
    protected HashMap<Object, Dimension> sizes;
    protected Dimension fullSize;
    protected boolean isRefreshing;
    protected int mainViewContentIndex;
    protected int worldViewContentIndex;
    protected String savedFilePath;
    protected PropertyChangeListener listener;
    protected boolean oddFirst = true;
    protected Object prevContentItem;
    protected static ExportVideoDialog videoExporter;

    public static ExportVideoDialog getVideoDialog(TrackerPanel panel) {
        TrackerIO.refreshVideoFormats();
        if (videoExporter == null) {
            videoExporter = new ExportVideoDialog(panel);
        }
        videoExporter.refreshFormatDropdown(VideoIO.getPreferredExportExtension());
        videoExporter.setTrackerPanel(panel);
        videoExporter.setFontLevel(FontSizer.getLevel());
        return videoExporter;
    }

    protected void setFormat(String format) {
        if (format != null) {
            this.formatDropdown.setSelectedItem(format);
            TrackerIO.selectedVideoFormat = format;
        }
    }

    public Object getFormat() {
        return this.formatDropdown.getSelectedItem();
    }

    protected String exportFullSizeVideo(String filePath, String trkPath) {
        if (this.frame.getTrackerPanelForID(this.panelID).getVideo() == null) {
            return null;
        }
        this.viewDropdown.setSelectedIndex(0);
        try {
            this.contentDropdown.setSelectedIndex(1);
        }
        catch (Exception e) {
            this.contentDropdown.setSelectedIndex(0);
        }
        this.sizeDropdown.setSelectedIndex(0);
        VideoType videoType = TrackerIO.videoFormats.get(this.formatDropdown.getSelectedItem());
        Dimension size = this.sizes.get(this.sizeDropdown.getSelectedItem());
        this.render(videoType, size, false, filePath, trkPath);
        return this.savedFilePath;
    }

    private ExportVideoDialog(TrackerPanel panel) {
        super((Frame)panel.getTFrame(), true);
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.setResizable(false);
        this.createGUI();
        this.refreshGUI();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    private void createGUI() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        Box settingsPanel = Box.createVerticalBox();
        contentPane.add((Component)settingsPanel, "Center");
        JPanel upper = new JPanel(new GridLayout(1, 2));
        JPanel lower = new JPanel(new GridLayout(1, 2));
        this.sizes = new HashMap();
        this.sizePanel = Box.createVerticalBox();
        this.sizeDropdown = new JComboBox();
        this.sizeDropdown.setName("ExportVideo.size");
        this.sizePanel.add(this.sizeDropdown);
        this.views = new HashMap();
        this.viewPanel = new JPanel(new GridLayout(0, 1));
        this.viewDropdown = new JComboBox();
        this.viewDropdown.setName("ExportVideo.view");
        this.viewPanel.add(this.viewDropdown);
        this.viewDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !ExportVideoDialog.this.isRefreshing) {
                    ExportVideoDialog.this.refreshDropdowns();
                }
            }
        });
        this.contentPanel = new JPanel(new GridLayout(0, 1));
        this.contentDropdown = new JComboBox();
        this.contentDropdown.setName("ExportVideo.content");
        this.contentPanel.add(this.contentDropdown);
        this.contentDropdown.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ExportVideoDialog.this.isRefreshing) {
                    return;
                }
                if (e.getStateChange() == 2) {
                    ExportVideoDialog.this.prevContentItem = e.getItem();
                }
                if (e.getStateChange() == 1) {
                    JComponent view = ExportVideoDialog.this.views.get(ExportVideoDialog.this.viewDropdown.getSelectedItem());
                    if (view == ExportVideoDialog.this.frame.getTrackerPanelForID(ExportVideoDialog.this.panelID)) {
                        ExportVideoDialog.this.mainViewContentIndex = ExportVideoDialog.this.contentDropdown.getSelectedIndex();
                    } else if (view instanceof WorldTView) {
                        ExportVideoDialog.this.worldViewContentIndex = ExportVideoDialog.this.contentDropdown.getSelectedIndex();
                    }
                    if (ExportVideoDialog.this.contentDropdown.getSelectedIndex() == 3) {
                        JRadioButton odd = new JRadioButton(TrackerRes.getString("ExportVideoDialog.Deinterlace.OddFirst"));
                        odd.setSelected(ExportVideoDialog.this.oddFirst);
                        JRadioButton even = new JRadioButton(TrackerRes.getString("ExportVideoDialog.Deinterlace.EvenFirst"));
                        even.setSelected(!ExportVideoDialog.this.oddFirst);
                        ButtonGroup group = new ButtonGroup();
                        group.add(odd);
                        group.add(even);
                        JPanel panel = new JPanel();
                        panel.add(odd);
                        panel.add(even);
                        int result = JOptionPane.showConfirmDialog(ExportVideoDialog.this, panel, TrackerRes.getString("ExportVideoDialog.Deinterlace.Dialog.Title"), 2, -1);
                        if (result == 2 && ExportVideoDialog.this.prevContentItem != null) {
                            ExportVideoDialog.this.contentDropdown.setSelectedItem(ExportVideoDialog.this.prevContentItem);
                            ExportVideoDialog.this.prevContentItem = null;
                            return;
                        }
                        ExportVideoDialog.this.oddFirst = odd.isSelected();
                    }
                    ExportVideoDialog.this.refreshDropdowns();
                }
            }
        });
        this.formatPanel = new JPanel(new GridLayout(0, 1));
        this.formatDropdown = new JComboBox();
        this.formatDropdown.setName("ExportVideo.format");
        this.formatDropdown.setMaximumRowCount(TrackerIO.videoFormatDescriptions.size());
        this.formatPanel.add(this.formatDropdown);
        settingsPanel.add(upper);
        settingsPanel.add(lower);
        upper.add(this.viewPanel);
        upper.add(this.contentPanel);
        lower.add(this.sizePanel);
        lower.add(this.formatPanel);
        this.saveAsButton = new JButton();
        this.saveAsButton.setForeground(new Color(0, 0, 102));
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VideoType format = TrackerIO.videoFormats.get(ExportVideoDialog.this.formatDropdown.getSelectedItem());
                Dimension size = ExportVideoDialog.this.sizes.get(ExportVideoDialog.this.sizeDropdown.getSelectedItem());
                ExportVideoDialog.this.render(format, size, !OSPRuntime.isJS, null, null);
                TrackerIO.selectedVideoFormat = (String)ExportVideoDialog.this.formatDropdown.getSelectedItem();
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportVideoDialog.this.setVisible(false);
            }
        });
        JPanel buttonbar = new JPanel();
        contentPane.add((Component)buttonbar, "South");
        buttonbar.add(this.saveAsButton);
        buttonbar.add(this.closeButton);
        this.clipPropertiesLabel = new JLabel();
        this.clipPropertiesLabel.setHorizontalAlignment(0);
        this.clipPropertiesLabel.setBorder(BorderFactory.createEmptyBorder(4, 8, 2, 8));
        contentPane.add((Component)this.clipPropertiesLabel, "North");
    }

    private void refreshGUI() {
        String stepsize;
        String startframe;
        String title = TrackerRes.getString("ExportVideoDialog.Title");
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        this.setTitle(title);
        VideoClip clip = panel.getPlayer().getClipControl().getVideoClip();
        String framecount = MediaRes.getString("Filter.Sum.Label.FrameCount").toLowerCase();
        if (framecount.endsWith(":")) {
            framecount = framecount.substring(0, framecount.length() - 1);
        }
        if ((startframe = MediaRes.getString("ClipInspector.Label.StartFrame").toLowerCase()).endsWith(":")) {
            startframe = startframe.substring(0, startframe.length() - 1);
        }
        if ((stepsize = MediaRes.getString("ClipInspector.Label.StepSize").toLowerCase()).endsWith(":")) {
            stepsize = stepsize.substring(0, stepsize.length() - 1);
        }
        title = String.valueOf(TrackerRes.getString("ExportVideoDialog.Label.ClipSettings")) + ": " + framecount + " " + clip.getStepCount() + ", " + startframe + " " + clip.getStartFrameNumber() + ", " + stepsize + " " + clip.getStepSize();
        this.clipPropertiesLabel.setText(title);
        title = TrackerRes.getString("ExportVideoDialog.Subtitle.Size");
        Border space = BorderFactory.createEmptyBorder(0, 4, 6, 4);
        TitledBorder titled = BorderFactory.createTitledBorder(title);
        int fontLevel = FontSizer.getLevel();
        FontSizer.setFonts(titled, fontLevel);
        this.sizePanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        title = TrackerRes.getString("ExportVideoDialog.Subtitle.View");
        titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, fontLevel);
        this.viewPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        title = TrackerRes.getString("ExportVideoDialog.Subtitle.Content");
        titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, fontLevel);
        this.contentPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        title = TrackerRes.getString("ExportVideoDialog.Subtitle.Format");
        titled = BorderFactory.createTitledBorder(title);
        FontSizer.setFonts(titled, fontLevel);
        this.formatPanel.setBorder(BorderFactory.createCompoundBorder(titled, space));
        this.saveAsButton.setText(TrackerRes.getString("ExportVideoDialog.Button.SaveAs"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
        Object selectedView = this.viewDropdown.getSelectedItem();
        this.viewDropdown.removeAllItems();
        String s = TrackerRes.getString("TFrame.View.Main");
        s = String.valueOf(s) + " (0)";
        this.views.put(s, panel);
        this.viewDropdown.addItem(s);
        TViewChooser[] choosers = this.frame.getVisibleChoosers(this.panelID);
        int i = 0;
        while (i < choosers.length) {
            if (choosers[i] != null) {
                String number = " (" + (i + 1) + ")";
                TView tview = choosers[i].getSelectedView();
                if (tview != null && tview.getViewType() == 2) {
                    s = String.valueOf(tview.getViewName()) + number;
                    WorldTView worldView = (WorldTView)tview;
                    this.views.put(s, worldView);
                    this.viewDropdown.addItem(s);
                } else if (tview != null && tview.getViewType() == 0) {
                    s = String.valueOf(tview.getViewName()) + number;
                    PlotTView plotView = (PlotTView)tview;
                    TTrack track = plotView.getSelectedTrack();
                    if (track != null) {
                        PlotTrackView trackView = (PlotTrackView)plotView.getTrackView(track);
                        this.views.put(s, trackView);
                        this.viewDropdown.addItem(s);
                    }
                }
            }
            ++i;
        }
        s = TrackerRes.getString("TMenuBar.MenuItem.CopyFrame");
        this.views.put(s, (JComponent)this.frame.getContentPane());
        this.viewDropdown.addItem(s);
        if (selectedView != null) {
            this.viewDropdown.setSelectedItem(selectedView);
        }
        this.pack();
        this.refreshDropdowns();
    }

    private void refreshDropdowns() {
        this.isRefreshing = true;
        JComponent view = this.views.get(this.viewDropdown.getSelectedItem());
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        Video video2 = panel.getVideo();
        String s = null;
        this.contentDropdown.removeAllItems();
        if (view == panel) {
            if (video2 != null) {
                s = TrackerRes.getString("ExportVideoDialog.Content.VideoAndGraphics");
                this.contentDropdown.addItem(s);
                s = TrackerRes.getString("ExportVideoDialog.Content.VideoOnly");
                this.contentDropdown.addItem(s);
            }
            s = TrackerRes.getString("ExportVideoDialog.Content.GraphicsOnly");
            this.contentDropdown.addItem(s);
            if (video2 != null) {
                if (panel.getPlayer().getClipControl().getVideoClip().getStepCount() > 1) {
                    s = TrackerRes.getString("ExportVideoDialog.Content.DeinterlacedVideo");
                    this.contentDropdown.addItem(s);
                }
                this.contentDropdown.setSelectedIndex(this.mainViewContentIndex);
            }
        } else if (view instanceof WorldTView) {
            if (video2 != null) {
                s = TrackerRes.getString("ExportVideoDialog.Content.VideoAndGraphics");
                this.contentDropdown.addItem(s);
            }
            s = TrackerRes.getString("ExportVideoDialog.Content.GraphicsOnly");
            this.contentDropdown.addItem(s);
            if (video2 != null) {
                this.contentDropdown.setSelectedIndex(this.worldViewContentIndex);
            }
        } else {
            s = TrackerRes.getString("ExportVideoDialog.Content.GraphicsOnly");
            this.contentDropdown.addItem(s);
        }
        Object selectedItem = this.sizeDropdown.getSelectedItem();
        this.sizeDropdown.removeAllItems();
        if (view == panel) {
            int contentIndex = this.contentDropdown.getSelectedIndex();
            if (contentIndex == 1 || contentIndex == 3) {
                Dimension d = panel.getVideo().getImageSize(true);
                int w = d.width;
                int h = d.height;
                this.fullSize = this.getAcceptedDimension(w, h);
                s = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
                s = String.valueOf(s) + " (" + TrackerRes.getString("ExportVideoDialog.VideoSize") + ")";
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, this.fullSize);
            } else {
                Rectangle bounds = panel.getMatBounds();
                this.fullSize = this.getAcceptedDimension(bounds.width, bounds.height);
                s = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
                s = String.valueOf(s) + " (" + TrackerRes.getString("ExportVideoDialog.MatSize") + ")";
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, this.fullSize);
            }
            Dimension dim = new Dimension(this.fullSize.width * 8 / 10, this.fullSize.height * 8 / 10);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            dim = new Dimension(this.fullSize.width * 3 / 4, this.fullSize.height * 3 / 4);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            dim = new Dimension(this.fullSize.width * 6 / 10, this.fullSize.height * 6 / 10);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            dim = new Dimension(this.fullSize.width / 2, this.fullSize.height / 2);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            dim = new Dimension(this.fullSize.width * 4 / 10, this.fullSize.height * 4 / 10);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            dim = new Dimension(this.fullSize.width * 3 / 8, this.fullSize.height * 3 / 8);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            dim = new Dimension(this.fullSize.width * 3 / 10, this.fullSize.height * 3 / 10);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            dim = new Dimension(this.fullSize.width / 4, this.fullSize.height / 4);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
            dim = new Dimension(this.fullSize.width * 2 / 10, this.fullSize.height * 2 / 10);
            if (this.isAcceptedDimension(dim.width, dim.height)) {
                s = String.valueOf(dim.width) + "x" + dim.height;
                this.sizeDropdown.addItem(s);
                this.sizes.put(s, dim);
            }
        } else if (view instanceof PlotTrackView) {
            Dimension dim = ((PlotTrackView)view).getPanelSize();
            this.fullSize = this.getAcceptedDimension(dim.width, dim.height);
            s = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
            this.sizeDropdown.addItem(s);
            this.sizes.put(s, this.fullSize);
        } else {
            Dimension dim = view.getSize();
            this.fullSize = this.getAcceptedDimension(dim.width, dim.height);
            s = String.valueOf(this.fullSize.width) + "x" + this.fullSize.height;
            this.sizeDropdown.addItem(s);
            this.sizes.put(s, this.fullSize);
        }
        if (this.sizes.keySet().contains(selectedItem)) {
            this.sizeDropdown.setSelectedItem(selectedItem);
        }
        this.isRefreshing = false;
    }

    public void refreshFormatDropdown(String preferredExtension) {
        String selected = TrackerIO.getVideoFormat(preferredExtension);
        this.formatDropdown.removeAllItems();
        for (String format : TrackerIO.videoFormatDescriptions) {
            this.formatDropdown.addItem(format);
        }
        if (selected != null) {
            this.setFormat(selected);
        }
    }

    public void setFontLevel(int level) {
        JComboBox[] dropdowns;
        FontSizer.setFonts(this, level);
        JComboBox[] jComboBoxArray = dropdowns = new JComboBox[]{this.formatDropdown, this.viewDropdown, this.sizeDropdown, this.contentDropdown};
        int n = dropdowns.length;
        int n2 = 0;
        while (n2 < n) {
            JComboBox cb;
            JComboBox next = cb = jComboBoxArray[n2];
            int n3 = next.getSelectedIndex();
            String[] items = new String[next.getItemCount()];
            int i = 0;
            while (i < items.length) {
                items[i] = (String)next.getItemAt(i);
                ++i;
            }
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(items);
            next.setModel(model);
            next.setSelectedIndex(n3);
            ++n2;
        }
        this.refreshGUI();
        this.pack();
    }

    public void setTrackerPanel(TrackerPanel panel) {
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.refreshGUI();
    }

    private Dimension getAcceptedDimension(int w, int h) {
        if (!this.isAcceptedDimension(w, h)) {
            while (w % 16 != 0) {
                ++w;
            }
            while (h % 16 != 0) {
                ++h;
            }
        }
        return new Dimension(w, h);
    }

    private boolean isAcceptedDimension(int w, int h) {
        if (w < 160 || h < 120) {
            return false;
        }
        if (w % 4 != 0 || h % 4 != 0) {
            return false;
        }
        if (1.0 * (double)h / (double)w == 0.75) {
            return true;
        }
        if (1.0 * (double)w / (double)h == 1.5) {
            return true;
        }
        if (16.0 * (double)h / (double)w == 9.0) {
            return true;
        }
        return w % 16 == 0 && h % 16 == 0;
    }

    private void setVideoVisible(boolean visible) {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.setVideoVisible(visible);
    }

    private void render(VideoType videoType, final Dimension size, final boolean showOpenDialog, String filePath, String trkPath) {
        Dimension full;
        PlotTrackView trackView;
        Dimension extent;
        this.setVisible(false);
        this.savedFilePath = null;
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        Video video2 = panel.getVideo();
        final boolean videoIsVisible = video2 != null && video2.isVisible();
        final double magnification = panel.getMagnification();
        JComponent view = this.views.get(this.viewDropdown.getSelectedItem());
        if (view == panel && this.contentDropdown.getSelectedIndex() != 1) {
            double zoom = size.getWidth() / this.fullSize.getWidth();
            if (zoom != magnification) {
                panel.setMagnification(zoom);
            }
            if (this.contentDropdown.getSelectedIndex() == 0) {
                this.setVideoVisible(true);
            } else if (this.contentDropdown.getSelectedIndex() == 2) {
                this.setVideoVisible(false);
            }
        } else if (view instanceof WorldTView) {
            this.setVideoVisible(this.contentDropdown.getSelectedIndex() == 0);
        } else if (view instanceof PlotTrackView && !(extent = (trackView = (PlotTrackView)view).getViewport().getExtentSize()).equals(full = trackView.getViewport().getView().getSize())) {
            JOptionPane.showMessageDialog(panel, TrackerRes.getString("ExportVideo.Dialog.HiddenPlots.Message"), TrackerRes.getString("ExportVideo.Dialog.HiddenPlots.Title"), 2);
            this.setVisible(true);
            return;
        }
        final VideoPlayer player = panel.getPlayer();
        player.stop();
        player.setEnabled(false);
        final ClipControl playControl = player.getClipControl();
        final VideoClip clip = playControl.getVideoClip();
        final int taskLength = clip.getStepCount() + 1;
        final VideoRecorder recorder = videoType.getRecorder();
        double duration = player.getMeanStepDuration();
        if (this.contentDropdown.getSelectedIndex() == 3) {
            duration /= 2.0;
        }
        recorder.setFrameDuration(duration);
        if (recorder instanceof ScratchVideoRecorder) {
            ScratchVideoRecorder svr = (ScratchVideoRecorder)recorder;
            String tabName = XML.stripExtension(panel.getTitle()).trim();
            String viewName = this.viewDropdown.getSelectedItem().toString().trim().toLowerCase();
            int n = viewName.indexOf(" ");
            if (n > -1) {
                viewName = viewName.substring(0, n);
            }
            svr.suggestFileName(String.valueOf(tabName) + "-" + viewName);
        }
        if (recorder instanceof ImageVideoRecorder) {
            ImageVideoRecorder ivr = (ImageVideoRecorder)recorder;
            ivr.setExpectedFrameCount(clip.getStepCount());
        }
        try {
            recorder.createVideo(filePath);
            this.savedFilePath = recorder.getFileName();
            if (this.savedFilePath == null) {
                panel.setMagnification(magnification);
                this.setVideoVisible(videoIsVisible);
                this.setVisible(true);
                player.setEnabled(true);
                recorder.reset();
                return;
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(panel, ex, "Exception error creating video", 2);
        }
        if (clip.getStepCount() == 1) {
            try {
                BufferedImage[] n = this.getNextImages(size);
                int viewName = n.length;
                int tabName = 0;
                while (tabName < viewName) {
                    BufferedImage image = n[tabName];
                    recorder.addFrame(image);
                    ++tabName;
                }
                this.savedFilePath = recorder.saveVideo();
                if (this.savedFilePath == null) {
                    recorder.reset();
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(panel, ex, "Exception error ading frame", 2);
            }
        } else {
            String description = XML.getName(recorder.getFileName());
            final ProgressMonitor monitor = new ProgressMonitor(this.frame, String.valueOf(TrackerRes.getString("TActions.SaveClipAs.ProgressMonitor.Message")) + " " + description, "", 0, taskLength);
            monitor.setMillisToPopup(2000);
            monitor.setProgress(1);
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    final int progress = (Integer)e.getNewValue() + 1;
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            boolean done;
                            boolean bl = done = playControl.getStepNumber() == clip.getStepCount() - 1;
                            if (!monitor.isCanceled()) {
                                monitor.setNote(String.format(String.valueOf(TrackerRes.getString("TActions.SaveClipAs.ProgressMonitor.Progress")) + " %d%%.\n", progress * 100 / taskLength));
                                monitor.setProgress(done ? progress + 1 : progress);
                            }
                            ExportVideoDialog.this.setProgress(monitor, playControl, player, recorder, videoIsVisible, clip, size, magnification, done, showOpenDialog);
                        }
                    };
                    EventQueue.invokeLater(runner);
                }
            };
            playControl.addPropertyChangeListener("stepnumber", this.listener);
            if (playControl.getStepNumber() == 0) {
                String message = String.format(String.valueOf(TrackerRes.getString("TActions.SaveClipAs.ProgressMonitor.Progress")) + " %d%%.\n", 100 / taskLength);
                monitor.setNote(message);
                TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
                trackerPanel.paintImmediately(trackerPanel.getBounds());
                try {
                    BufferedImage[] bufferedImageArray = this.getNextImages(size);
                    int n = bufferedImageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        BufferedImage image = bufferedImageArray[n2];
                        recorder.addFrame(image);
                        ++n2;
                    }
                    System.gc();
                    playControl.step();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(panel, ex, "Exception error adding image", 2);
                    monitor.close();
                    panel.setMagnification(magnification);
                    this.setVideoVisible(videoIsVisible);
                    player.setEnabled(true);
                    recorder.reset();
                    return;
                }
            } else {
                playControl.setStepNumber(0);
            }
        }
    }

    protected void setProgress(ProgressMonitor monitor, ClipControl playControl, VideoPlayer player, VideoRecorder recorder, boolean videoIsVisible, VideoClip clip, Dimension size, double magnification, boolean done, boolean showOpenDialog) {
        if (monitor.isCanceled()) {
            this.firePropertyChange(PROPERTY_EXPORTVIDEO_VIDEOCANCELED, null, null);
            monitor.close();
            playControl.removePropertyChangeListener("stepnumber", this.listener);
            this.frame.getTrackerPanelForID(this.panelID).setMagnification(magnification);
            this.setVideoVisible(videoIsVisible);
            player.setEnabled(true);
            recorder.reset();
            return;
        }
        if (done) {
            playControl.removePropertyChangeListener("stepnumber", this.listener);
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        try {
            BufferedImage[] bufferedImageArray = this.getNextImages(size);
            int n = bufferedImageArray.length;
            int n2 = 0;
            while (n2 < n) {
                BufferedImage image = bufferedImageArray[n2];
                recorder.addFrame(image);
                ++n2;
            }
            System.gc();
            if (done) {
                int response;
                VideoType videoType;
                this.savedFilePath = recorder.saveVideo();
                recorder.reset();
                trackerPanel.setMagnification(magnification);
                this.setVideoVisible(videoIsVisible);
                player.setEnabled(true);
                String imageExt = XML.getExtension(this.savedFilePath);
                if ("zip".equals(imageExt) && (videoType = TrackerIO.videoFormats.get(this.formatDropdown.getSelectedItem())) instanceof VideoIO.ZipImageVideoType) {
                    VideoIO.ZipImageVideoType zvt = (VideoIO.ZipImageVideoType)videoType;
                    imageExt = String.valueOf(imageExt) + " " + zvt.getImageExtension();
                }
                if (imageExt != null) {
                    VideoIO.setPreferredExportExtension(imageExt);
                }
                if (showOpenDialog && (response = JOptionPane.showConfirmDialog(this.frame, String.valueOf(TrackerRes.getString("ExportVideoDialog.Complete.Message1")) + " " + XML.getName(this.savedFilePath) + (recorder.getCodec() == null ? "" : " (codec=" + recorder.getCodec() + ")") + XML.NEW_LINE + TrackerRes.getString("ExportVideoDialog.Complete.Message2"), TrackerRes.getString("ExportVideoDialog.Complete.Title"), 0, 3)) == 0) {
                    this.frame.loadedFiles.remove(this.savedFilePath);
                    final File file = new File(this.savedFilePath);
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            TrackerIO.openFileFromDialog(file, ExportVideoDialog.this.frame, TrackerIO.NULL_RUNNABLE);
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                }
                this.firePropertyChange(PROPERTY_EXPORTVIDEO_VIDEOSAVED, null, this.savedFilePath);
            } else {
                playControl.step();
            }
        }
        catch (Exception ex) {
            this.savedFilePath = null;
            JOptionPane.showMessageDialog(trackerPanel, ex.toString(), "Exception saving video: ", 2);
            monitor.close();
            playControl.removePropertyChangeListener("stepnumber", this.listener);
            trackerPanel.setMagnification(magnification);
            this.setVideoVisible(videoIsVisible);
            player.setEnabled(true);
            recorder.reset();
            return;
        }
    }

    private BufferedImage[] getNextImages(Dimension size) {
        TrackerPanel trackerPanel;
        JComponent view = this.views.get(this.viewDropdown.getSelectedItem());
        if (view == (trackerPanel = this.frame.getTrackerPanelForID(this.panelID))) {
            if (this.contentDropdown.getSelectedIndex() == 1) {
                BufferedImage img = trackerPanel.getVideo().getImage();
                return new BufferedImage[]{this.getResizedImage(img, size)};
            }
            if (this.contentDropdown.getSelectedIndex() == 3) {
                boolean odd;
                DeinterlaceFilter filter = (DeinterlaceFilter)trackerPanel.getVideo().getFilterStack().getFilter(DeinterlaceFilter.class);
                if (filter == null) {
                    filter = new DeinterlaceFilter();
                    trackerPanel.getVideo().getFilterStack().addFilter(filter);
                }
                if ((odd = filter.isOdd()) != this.oddFirst) {
                    filter.setOdd(this.oddFirst);
                }
                BufferedImage img = trackerPanel.getVideo().getImage();
                BufferedImage img1 = this.getResizedCopy(img, size);
                filter.setOdd(!this.oddFirst);
                img = trackerPanel.getVideo().getImage();
                BufferedImage img2 = this.getResizedCopy(img, size);
                return new BufferedImage[]{img1, img2};
            }
            return new BufferedImage[]{this.getResizedImage(trackerPanel.getMattedImage(), size)};
        }
        if (view instanceof WorldTView) {
            WorldTView wtv = (WorldTView)view;
            Dimension dim = wtv.scrollPane.getViewport().getView().getSize();
            BufferedImage image = (BufferedImage)view.createImage(dim.width, dim.height);
            image = ((WorldTView)view).render(image);
            Rectangle rect = wtv.scrollPane.getViewport().getViewRect();
            return new BufferedImage[]{this.getClippedImage(image, rect)};
        }
        if (view instanceof PlotTrackView) {
            BufferedImage image = ((PlotTrackView)view).exportImage(size.width, size.height);
            return new BufferedImage[]{image};
        }
        BufferedImage image = (BufferedImage)view.createImage(size.width, size.height);
        Graphics2D g2 = image.createGraphics();
        view.paint(g2);
        g2.dispose();
        return new BufferedImage[]{image};
    }

    private BufferedImage getClippedImage(BufferedImage source, Rectangle rect) {
        if (rect.width == source.getWidth() && rect.height == source.getHeight()) {
            return source;
        }
        if (this.sizedImage == null || this.sizedImage.getWidth() != rect.width || this.sizedImage.getHeight() != rect.height) {
            this.sizedImage = new BufferedImage(rect.width, rect.height, source.getType());
        }
        BufferedImage img = source.getSubimage(rect.x, rect.y, rect.width, rect.height);
        Graphics2D g2 = this.sizedImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage((Image)img, 0, 0, null);
        g2.dispose();
        return this.sizedImage;
    }

    private BufferedImage getResizedImage(BufferedImage source, Dimension size) {
        if (size.width == source.getWidth() && size.height == source.getHeight()) {
            return source;
        }
        if (this.sizedImage == null || this.sizedImage.getWidth() != size.width || this.sizedImage.getHeight() != size.height) {
            this.sizedImage = new BufferedImage(size.width, size.height, source.getType());
        }
        Graphics2D g2 = this.sizedImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(source, 0, 0, size.width, size.height, 0, 0, source.getWidth(), source.getHeight(), null);
        g2.dispose();
        return this.sizedImage;
    }

    private BufferedImage getResizedCopy(BufferedImage source, Dimension size) {
        BufferedImage newImage = new BufferedImage(size.width, size.height, source.getType());
        Graphics2D g2 = newImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(source, 0, 0, size.width, size.height, 0, 0, source.getWidth(), source.getHeight(), null);
        g2.dispose();
        return newImage;
    }

    public void clear() {
        this.frame = null;
        this.panelID = null;
        this.views.clear();
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }
}

