/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.async.AsyncFileChooser;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CircleFitter;
import org.opensourcephysics.cabrillo.tracker.ExportVideoDialog;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.ThumbnailDialog;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.LaunchBuilder;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class ExportZipDialog
extends JDialog
implements PropertyChangeListener {
    private static final String EXPANDED = "expanded";
    private static Map<Integer, ExportZipDialog> zipDialogs;
    protected static String videoSubdirectory;
    protected static String htmlSubdirectory;
    protected static String imageSubdirectory;
    protected static Color labelColor;
    protected static String preferredExtension;
    protected static boolean trimToClip;
    protected static int maxLineLength;
    protected static int minWidth;
    protected ExportVideoDialog videoExporter;
    private TFrame frame;
    private Integer panelID;
    protected Icon openIcon;
    protected JPanel titlePanel;
    protected JPanel descriptionPanel;
    protected JPanel tabsPanel;
    protected JPanel videoPanel;
    protected JPanel metaPanel;
    protected JPanel thumbnailPanel;
    protected JPanel supportFilesPanel;
    protected JPanel advancedPanel;
    protected JPanel thumbnailImagePanel;
    protected Box titleTitleBox;
    protected Box descriptionTitleBox;
    protected Box tabsTitleBox;
    protected Box videoTitleBox;
    protected Box metaTitleBox;
    protected Box thumbTitleBox;
    protected Box supportFilesTitleBox;
    protected Box advancedTitleBox;
    protected Box metaFieldsBox;
    protected Box advancedFieldsBox;
    protected Box supportFilesBox;
    protected JLabel titleLabel;
    protected JLabel descriptionLabel;
    protected JLabel descriptionInfoLabel;
    protected JLabel tabsLabel;
    protected JLabel tabsInfoLabel;
    protected JLabel videoLabel;
    protected JLabel videoInfoLabel;
    protected JLabel metaLabel;
    protected JLabel metaInfoLabel;
    protected JLabel thumbLabel;
    protected JLabel thumbInfoLabel;
    protected JLabel supportFilesLabel;
    protected JLabel supportFilesInfoLabel;
    protected JLabel advancedLabel;
    protected JLabel advancedInfoLabel;
    protected JButton descriptionButton;
    protected JButton tabsButton;
    protected JButton videoButton;
    protected JButton metaButton;
    protected JButton thumbButton;
    protected JButton supportFilesButton;
    protected JButton advancedButton;
    protected JButton saveButton;
    protected JButton closeButton;
    protected JButton thumbnailButton;
    protected JButton loadHTMLButton;
    protected JButton helpButton;
    protected JComboBox<Object> formatDropdown;
    protected ArrayList<EntryField> tabTitleFields = new ArrayList();
    protected ArrayList<JCheckBox> tabCheckboxes = new ArrayList();
    protected JLabel authorLabel;
    protected JLabel contactLabel;
    protected JLabel keywordsLabel;
    protected JLabel thumbnailDisplay;
    protected JLabel urlLabel;
    protected JLabel htmlLabel;
    protected JCheckBox clipCheckbox;
    protected JCheckBox showThumbnailCheckbox;
    protected ArrayList<JLabel> labels = new ArrayList();
    protected EntryField titleField;
    protected EntryField authorField;
    protected EntryField contactField;
    protected EntryField keywordsField;
    protected EntryField urlField;
    protected EntryField htmlField;
    protected String targetName;
    protected String targetDirectory;
    protected String targetVideo;
    protected String targetExtension;
    protected JTextArea filelistPane;
    protected JTextArea descriptionPane;
    protected ArrayList<File> addedFiles = new ArrayList();
    protected ArrayList<String> fileNames = new ArrayList();
    protected JList<String> fileList;
    protected JButton addButton;
    protected JButton removeButton;
    protected DefaultListModel<String> fileListModel;
    protected FileFilter recentAddFilesFilter;
    protected VideoListener videoExportListener;
    protected XMLControl control;
    protected boolean addThumbnail = true;
    protected ArrayList<ParticleModel> badModels;
    protected String videoIOPreferredExtension;
    protected boolean isVisible;
    protected boolean isOpenInTracker;
    private Iterator<Export> exportIterator;
    private File lastTRZ = new File("");
    private String tempDir;

    static {
        TFrame.haveExportDialog = true;
        zipDialogs = new IdentityHashMap<Integer, ExportZipDialog>();
        videoSubdirectory = "videos";
        htmlSubdirectory = "html";
        imageSubdirectory = "images";
        labelColor = new Color(0, 0, 102);
        preferredExtension = "jpg";
        trimToClip = false;
        maxLineLength = 30;
        minWidth = 350;
    }

    protected static int setNewFrameNumbersCoord(VideoClip realClip, Object[] array, Map<Integer, Integer> newFrameNumbers) {
        newFrameNumbers.clear();
        int newFrameNum = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                if (i >= realClip.getEndFrameNumber()) break;
                newFrameNum = Math.max(realClip.frameToStep(i), 0);
                if (i > realClip.getStartFrameNumber() && !realClip.includesFrame(i)) {
                    ++newFrameNum;
                }
                newFrameNumbers.put(newFrameNum, i);
            }
            ++i;
        }
        return newFrameNum;
    }

    public static int setNewFrameNumbersPointVector(VideoClip realClip, Object[] array, Map<Integer, Integer> newFrameNumbers) {
        newFrameNumbers.clear();
        int newFrameNum = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null && realClip.includesFrame(i)) {
                newFrameNum = realClip.frameToStep(i);
                newFrameNumbers.put(newFrameNum, i);
            }
            ++i;
        }
        return newFrameNum;
    }

    public static int setNewFrameNumbersCalibration(VideoClip realClip, Object[] array, Map<Integer, Integer> newFrameNumbers) {
        newFrameNumbers.clear();
        int newFrameNum = 0;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                newFrameNum = realClip.frameToStep(i);
                newFrameNum = Math.max(0, newFrameNum);
                newFrameNumbers.put(newFrameNum, i);
            }
            ++i;
        }
        return newFrameNum;
    }

    public static int setNewFrameNumbersTape(VideoClip realClip, Object[] array, Map<Integer, Integer> newFrameNumbers) {
        newFrameNumbers.clear();
        int newFrameNum = 0;
        int nonNullIndex = 0;
        int i = 0;
        while (i <= realClip.getEndFrameNumber()) {
            if (i < array.length && array[i] != null) {
                nonNullIndex = i;
            }
            if (realClip.includesFrame(i)) {
                int n = realClip.frameToStep(i);
                if (nonNullIndex > -1) {
                    newFrameNumbers.put(n, nonNullIndex);
                    newFrameNum = n;
                    nonNullIndex = -1;
                } else if (i < array.length) {
                    newFrameNumbers.put(n, i);
                    newFrameNum = n;
                }
            }
            ++i;
        }
        return newFrameNum;
    }

    protected static void updateRange(VideoClip realClip, XMLControl trackControl, String start, String end) {
        int frameNum = trackControl.getInt(start);
        if (frameNum > 0) {
            int newStartFrameNum = realClip.frameToStep(frameNum);
            if (frameNum > realClip.getStartFrameNumber() && !realClip.includesFrame(frameNum)) {
                ++newStartFrameNum;
            }
            trackControl.setValue(start, newStartFrameNum);
        }
        if ((frameNum = trackControl.getInt(end)) > 0) {
            int newEndFrameNum = realClip.frameToStep(frameNum);
            trackControl.setValue(end, newEndFrameNum);
        }
    }

    protected void nextExport(ArrayList<File> zipList) {
        if (this.exportIterator != null && this.exportIterator.hasNext()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ((Export)ExportZipDialog.this.exportIterator.next()).export();
                }
            }).start();
            return;
        }
        this.exportIterator = null;
        this.addFiles(zipList);
        this.saveZip(zipList);
    }

    protected void exportCanceled() {
        this.exportIterator = null;
        OSPLog.debug("Export canceled");
    }

    public static synchronized ExportZipDialog getDialog(TrackerPanel panel) {
        ExportZipDialog dialog = zipDialogs.get(panel.getID());
        if (dialog == null) {
            File htmlFile;
            dialog = new ExportZipDialog(panel);
            zipDialogs.put(panel.getID(), dialog);
            dialog.setResizable(false);
            dialog.frame.addPropertyChangeListener("tab", dialog);
            dialog.setFontLevel(FontSizer.getLevel());
            dialog.control = new XMLControlElement(panel);
            dialog.addThumbnail = true;
            dialog.htmlField.setText(dialog.htmlField.getDefaultText());
            dialog.htmlField.setForeground(dialog.htmlField.getEmptyForeground());
            dialog.htmlField.setBackground(Color.white);
            if (panel.openedFromPath != null && TrackerIO.trzFileFilter.accept(htmlFile = new File(panel.openedFromPath))) {
                String baseName = XML.stripExtension(XML.getName(panel.openedFromPath));
                try {
                    ZipEntry nextEntry;
                    ZipInputStream zipFile = new ZipInputStream(new FileInputStream(panel.openedFromPath));
                    while ((nextEntry = zipFile.getNextEntry()) != null) {
                        String path;
                        File file;
                        System.out.println("EZD " + nextEntry);
                        String name = XML.forwardSlash(nextEntry.getName());
                        if (name.contains("/") && (nextEntry.isDirectory() || !name.contains("html/") || name.contains("_info.")) || name.contains("_thumbnail") || TrackerIO.trkFileFilter.accept(file = new File(path = String.valueOf(panel.openedFromPath) + "!/" + name)) || dialog.addedFiles.contains(file)) continue;
                        dialog.addedFiles.add(file);
                    }
                    dialog.refreshFileList();
                    dialog.refreshSupportFilesGUI();
                    zipFile.close();
                }
                catch (IOException zipFile) {
                    // empty catch block
                }
                String htmlPath = String.valueOf(panel.openedFromPath) + "!/html/" + baseName + "_info.html";
                htmlFile = new File(htmlPath);
                dialog.refreshFieldsFromHTML(htmlFile);
            }
            String currentTabTitle = "";
            int i = 0;
            while (i < dialog.frame.getTabCount()) {
                String next = dialog.frame.getTabTitle(i);
                if (dialog.frame.getTrackerPanelForTab(i) == panel) {
                    currentTabTitle = next;
                }
                ++i;
            }
            if ("".equals(dialog.titleField.getText())) {
                dialog.titleField.setText(XML.stripExtension(currentTabTitle));
            }
            dialog.titleField.requestFocusInWindow();
            dialog.refreshFormatDropdown();
        }
        return dialog;
    }

    public static boolean hasDialog(TrackerPanel panel) {
        return zipDialogs.get(panel.getID()) != null;
    }

    public void setFontLevel(int level) {
        FontSizer.setFonts(this, level);
        int n = this.formatDropdown.getSelectedIndex();
        Object[] items = new Object[this.formatDropdown.getItemCount()];
        int i = 0;
        while (i < items.length) {
            items[i] = this.formatDropdown.getItemAt(i);
            ++i;
        }
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(items);
        this.formatDropdown.setModel(model);
        this.formatDropdown.setSelectedItem(n);
        Font font = this.titleLabel.getFont();
        int w = 0;
        for (JLabel next : this.labels) {
            Rectangle2D rect = font.getStringBounds(String.valueOf(next.getText()) + " ", OSPRuntime.frc);
            w = Math.max(w, (int)rect.getWidth() + 1);
        }
        int h = this.titleField.getMinimumSize().height;
        Dimension labelSize = new Dimension(w, h);
        for (JLabel next : this.labels) {
            next.setPreferredSize(labelSize);
        }
        this.pack();
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.panelID == null) {
            return;
        }
        if (vis) {
            this.refreshGUI();
        }
        this.isVisible = vis;
        super.setVisible(vis);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = Math.max(dim.width, (int)((1.0 + (FontSizer.getFactor() - 1.0) * 0.6) * (double)minWidth));
        return dim;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("tab")) {
            TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
            if (!this.frame.isRemovingAll()) {
                if (e.getNewValue() == trackerPanel) {
                    this.setVisible(this.isVisible);
                    return;
                }
                if (e.getNewValue() == null && e.getOldValue() == trackerPanel) {
                    ExportZipDialog.clear(trackerPanel);
                    return;
                }
            }
            boolean vis = this.isVisible;
            this.setVisible(false);
            this.isVisible = vis;
        }
    }

    public static synchronized void clear(TrackerPanel panel) {
        ExportZipDialog dialog = zipDialogs.remove(panel.getID());
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.frame.removePropertyChangeListener("tab", dialog);
            dialog.panelID = null;
            dialog.frame = null;
        }
    }

    public static void setFontLevels(int level) {
        for (ExportZipDialog d : zipDialogs.values()) {
            d.setFontLevel(level);
        }
    }

    private ExportZipDialog(TrackerPanel panel) {
        super((Frame)panel.getTFrame(), false);
        this.frame = panel.getTFrame();
        this.panelID = panel.getID();
        this.createGUI();
        this.refreshGUI();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (dim.width - this.getBounds().width) / 2;
        int y = (dim.height - this.getBounds().height) / 2;
        this.setLocation(x, y);
    }

    private void createGUI() {
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        this.openIcon = Tracker.getResourceIcon("open.gif", true);
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color != null) {
            UIManager.put("ComboBox.disabledForeground", color);
        }
        this.videoExportListener = new VideoListener();
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        Border toolbarBorder = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        this.titlePanel = new JPanel(new BorderLayout());
        this.titleTitleBox = Box.createHorizontalBox();
        this.titleLabel = new JLabel();
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.titleTitleBox.add(this.titleLabel);
        this.titleField = new EntryField(30);
        Box space = Box.createHorizontalBox();
        space.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 4));
        space.add(this.titleField);
        this.titleTitleBox.add(space);
        this.titlePanel.add((Component)this.titleTitleBox, "North");
        this.descriptionPanel = new JPanel(new BorderLayout());
        this.descriptionTitleBox = Box.createHorizontalBox();
        this.descriptionLabel = new JLabel();
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.descriptionTitleBox.add(this.descriptionLabel);
        this.descriptionInfoLabel = new JLabel();
        this.descriptionInfoLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.descriptionInfoLabel.setFont(this.descriptionInfoLabel.getFont().deriveFont(0));
        this.descriptionTitleBox.add(this.descriptionInfoLabel);
        this.descriptionTitleBox.add(Box.createHorizontalGlue());
        this.descriptionButton = new TButton();
        this.descriptionButton.setToolTipText(TrackerRes.getString("ExportZipDialog.Button.Expand.Tooltip"));
        this.descriptionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ExportZipDialog.this.descriptionPanel.getName();
                ExportZipDialog.this.descriptionPanel.setName(name == null ? ExportZipDialog.EXPANDED : null);
                ExportZipDialog.this.refreshGUI();
                ExportZipDialog.this.descriptionButton.requestFocusInWindow();
            }
        });
        this.descriptionButton.setContentAreaFilled(false);
        this.descriptionTitleBox.add(this.descriptionButton);
        this.descriptionPanel.add((Component)this.descriptionTitleBox, "North");
        this.descriptionPane = new JTextArea();
        this.descriptionPane.setLineWrap(true);
        this.descriptionPane.setWrapStyleWord(true);
        this.descriptionPane.getDocument().putProperty("parent", this.descriptionPane);
        this.descriptionPane.getDocument().addDocumentListener(EntryField.documentListener);
        this.descriptionPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ExportZipDialog.this.descriptionPane.setBackground(Color.white);
                ExportZipDialog.this.refreshDescriptionGUI();
            }
        });
        this.tabsPanel = new JPanel(new BorderLayout());
        this.tabsTitleBox = Box.createHorizontalBox();
        this.tabsLabel = new JLabel();
        this.tabsLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.tabsTitleBox.add(this.tabsLabel);
        this.tabsInfoLabel = new JLabel();
        this.tabsInfoLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.tabsInfoLabel.setFont(this.tabsInfoLabel.getFont().deriveFont(0));
        this.tabsTitleBox.add(this.tabsInfoLabel);
        this.tabsTitleBox.add(Box.createHorizontalGlue());
        this.tabsButton = new TButton();
        this.tabsButton.setToolTipText(TrackerRes.getString("ExportZipDialog.Button.Expand.Tooltip"));
        this.tabsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ExportZipDialog.this.tabsPanel.getName();
                ExportZipDialog.this.tabsPanel.setName(name == null ? ExportZipDialog.EXPANDED : null);
                ExportZipDialog.this.refreshGUI();
                ExportZipDialog.this.tabsButton.requestFocusInWindow();
            }
        });
        this.tabsButton.setContentAreaFilled(false);
        this.tabsTitleBox.add(this.tabsButton);
        this.tabsPanel.add((Component)this.tabsTitleBox, "North");
        this.videoPanel = new JPanel(new BorderLayout());
        this.clipCheckbox = new JCheckBox();
        this.clipCheckbox.setSelected(trimToClip);
        this.clipCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.refreshVideosGUI();
                ExportZipDialog.this.clipCheckbox.requestFocusInWindow();
                trimToClip = ExportZipDialog.this.clipCheckbox.isSelected();
            }
        });
        this.formatDropdown = new JComboBox<Object>(TrackerIO.getVideoFormats()){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.height = ExportZipDialog.this.titleField.getPreferredSize().height;
                return dim;
            }
        };
        this.formatDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.refreshVideosGUI();
                ExportZipDialog.this.formatDropdown.requestFocusInWindow();
            }
        });
        this.formatDropdown.setRenderer(new FormatRenderer());
        this.videoTitleBox = Box.createHorizontalBox();
        this.videoLabel = new JLabel();
        this.videoLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.videoTitleBox.add(this.videoLabel);
        this.videoInfoLabel = new JLabel();
        this.videoInfoLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.videoInfoLabel.setFont(this.videoInfoLabel.getFont().deriveFont(0));
        this.videoTitleBox.add(this.videoInfoLabel);
        this.videoTitleBox.add(Box.createHorizontalGlue());
        this.videoButton = new TButton();
        this.videoButton.setToolTipText(TrackerRes.getString("ExportZipDialog.Button.Expand.Tooltip"));
        this.videoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ExportZipDialog.this.videoPanel.getName();
                ExportZipDialog.this.videoPanel.setName(name == null ? ExportZipDialog.EXPANDED : null);
                ExportZipDialog.this.refreshGUI();
                ExportZipDialog.this.videoButton.requestFocusInWindow();
            }
        });
        this.videoButton.setContentAreaFilled(false);
        this.videoTitleBox.add(this.videoButton);
        this.videoPanel.add((Component)this.videoTitleBox, "North");
        this.metaPanel = new JPanel(new BorderLayout());
        this.metaTitleBox = Box.createHorizontalBox();
        this.metaLabel = new JLabel();
        this.metaLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.metaTitleBox.add(this.metaLabel);
        this.metaInfoLabel = new JLabel();
        this.metaInfoLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.metaInfoLabel.setFont(this.metaInfoLabel.getFont().deriveFont(0));
        this.metaTitleBox.add(this.metaInfoLabel);
        this.metaTitleBox.add(Box.createHorizontalGlue());
        this.metaButton = new TButton();
        this.metaButton.setToolTipText(TrackerRes.getString("ExportZipDialog.Button.Expand.Tooltip"));
        this.metaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ExportZipDialog.this.metaPanel.getName();
                ExportZipDialog.this.metaPanel.setName(name == null ? ExportZipDialog.EXPANDED : null);
                ExportZipDialog.this.refreshGUI();
                ExportZipDialog.this.metaButton.requestFocusInWindow();
            }
        });
        this.metaButton.setContentAreaFilled(false);
        this.metaTitleBox.add(this.metaButton);
        this.thumbnailPanel = new JPanel(new BorderLayout());
        this.thumbTitleBox = Box.createHorizontalBox();
        this.thumbLabel = new JLabel();
        this.thumbLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.thumbTitleBox.add(this.thumbLabel);
        this.thumbInfoLabel = new JLabel();
        this.thumbInfoLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.thumbInfoLabel.setFont(this.thumbInfoLabel.getFont().deriveFont(0));
        this.thumbTitleBox.add(this.thumbInfoLabel);
        this.thumbTitleBox.add(Box.createHorizontalGlue());
        this.thumbButton = new TButton();
        this.thumbButton.setToolTipText(TrackerRes.getString("ExportZipDialog.Button.Expand.Tooltip"));
        this.thumbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ExportZipDialog.this.thumbnailPanel.getName();
                ExportZipDialog.this.thumbnailPanel.setName(name == null ? ExportZipDialog.EXPANDED : null);
                ExportZipDialog.this.refreshGUI();
                ExportZipDialog.this.thumbButton.requestFocusInWindow();
            }
        });
        this.thumbButton.setContentAreaFilled(false);
        this.thumbTitleBox.add(this.thumbButton);
        this.supportFilesPanel = new JPanel(new BorderLayout());
        this.supportFilesTitleBox = Box.createHorizontalBox();
        this.supportFilesLabel = new JLabel();
        this.supportFilesLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.supportFilesTitleBox.add(this.supportFilesLabel);
        this.supportFilesInfoLabel = new JLabel();
        this.supportFilesInfoLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.supportFilesInfoLabel.setFont(this.supportFilesInfoLabel.getFont().deriveFont(0));
        this.supportFilesTitleBox.add(this.supportFilesInfoLabel);
        this.supportFilesTitleBox.add(Box.createHorizontalGlue());
        this.supportFilesButton = new TButton();
        this.supportFilesButton.setToolTipText(TrackerRes.getString("ExportZipDialog.Button.Expand.Tooltip"));
        this.supportFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ExportZipDialog.this.supportFilesPanel.getName();
                ExportZipDialog.this.supportFilesPanel.setName(name == null ? ExportZipDialog.EXPANDED : null);
                ExportZipDialog.this.refreshGUI();
                ExportZipDialog.this.supportFilesButton.requestFocusInWindow();
            }
        });
        this.supportFilesButton.setContentAreaFilled(false);
        this.supportFilesTitleBox.add(this.supportFilesButton);
        this.fileListModel = new DefaultListModel();
        this.fileList = new JList<String>(this.fileListModel);
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ExportZipDialog.this.removeButton.setEnabled(ExportZipDialog.this.fileList.getSelectedValue() != null);
            }
        });
        this.addButton = new TButton(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.addButton.setContentAreaFilled(false);
        this.addButton.setForeground(labelColor);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final AsyncFileChooser chooser = TrackerIO.getChooser();
                chooser.setDialogTitle(TrackerRes.getString("ZipResourceDialog.FileChooser.AddFile.Title"));
                chooser.addChoosableFileFilter(LaunchBuilder.getPDFFilter());
                chooser.addChoosableFileFilter(LaunchBuilder.getHTMLFilter());
                if (ExportZipDialog.this.recentAddFilesFilter != null) {
                    chooser.setFileFilter(ExportZipDialog.this.recentAddFilesFilter);
                } else {
                    chooser.setFileFilter(LaunchBuilder.getPDFFilter());
                }
                TrackerIO.getChooserFilesAsync(ExportZipDialog.this.frame, "open any", new Function<File[], Void>(){

                    @Override
                    public Void apply(File[] files) {
                        (this).ExportZipDialog.this.recentAddFilesFilter = chooser.getFileFilter();
                        chooser.removeChoosableFileFilter(LaunchBuilder.getHTMLFilter());
                        chooser.removeChoosableFileFilter(LaunchBuilder.getPDFFilter());
                        if (files == null) {
                            return null;
                        }
                        if (!(this).ExportZipDialog.this.addedFiles.contains(files[0])) {
                            (this).ExportZipDialog.this.addedFiles.add(files[0]);
                            ExportZipDialog.this.refreshFileList();
                            ExportZipDialog.this.refreshSupportFilesGUI();
                        }
                        return null;
                    }
                });
            }
        });
        this.removeButton = new TButton();
        this.removeButton.setContentAreaFilled(false);
        this.removeButton.setForeground(labelColor);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ExportZipDialog.this.fileList.getSelectedValue();
                if (name != null) {
                    Iterator<File> it = ExportZipDialog.this.addedFiles.iterator();
                    while (it.hasNext()) {
                        File next = it.next();
                        if (!name.equals(next.getName())) continue;
                        it.remove();
                        break;
                    }
                    ExportZipDialog.this.refreshFileList();
                    ExportZipDialog.this.refreshSupportFilesGUI();
                }
            }
        });
        final Box buttonbox = Box.createVerticalBox();
        buttonbox.add((Component)this.addButton, "North");
        buttonbox.add((Component)this.removeButton, "South");
        JScrollPane scroller = new JScrollPane(this.fileList){

            @Override
            public Dimension getPreferredSize() {
                int h = buttonbox.getPreferredSize().height;
                return new Dimension(10, h);
            }
        };
        Box box = Box.createHorizontalBox();
        box.add(scroller);
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 4));
        this.supportFilesBox = Box.createHorizontalBox();
        this.supportFilesBox.add(buttonbox);
        this.supportFilesBox.add(box);
        this.advancedPanel = new JPanel(new BorderLayout());
        this.advancedTitleBox = Box.createHorizontalBox();
        this.advancedLabel = new JLabel();
        this.advancedLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.advancedTitleBox.add(this.advancedLabel);
        this.advancedInfoLabel = new JLabel();
        this.advancedInfoLabel.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.advancedInfoLabel.setFont(this.advancedInfoLabel.getFont().deriveFont(0));
        this.advancedTitleBox.add(this.advancedInfoLabel);
        this.advancedTitleBox.add(Box.createHorizontalGlue());
        this.advancedButton = new TButton();
        this.advancedButton.setToolTipText(TrackerRes.getString("ExportZipDialog.Button.Expand.Tooltip"));
        this.advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = ExportZipDialog.this.advancedPanel.getName();
                ExportZipDialog.this.advancedPanel.setName(name == null ? ExportZipDialog.EXPANDED : null);
                ExportZipDialog.this.refreshGUI();
                ExportZipDialog.this.advancedButton.requestFocusInWindow();
            }
        });
        this.advancedButton.setContentAreaFilled(false);
        this.advancedTitleBox.add(this.advancedButton);
        this.advancedPanel.add((Component)this.advancedTitleBox, "North");
        JPanel buttonbar = new JPanel();
        this.helpButton = new JButton();
        this.helpButton.setForeground(new Color(0, 0, 102));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.frame.showHelp("zip", 0);
            }
        });
        this.saveButton = new JButton();
        this.saveButton.setForeground(labelColor);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.saveZipAs();
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(labelColor);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.setVisible(false);
            }
        });
        buttonbar.add(this.helpButton);
        buttonbar.add(this.saveButton);
        buttonbar.add(this.closeButton);
        this.metaFieldsBox = Box.createVerticalBox();
        this.advancedFieldsBox = Box.createVerticalBox();
        this.htmlLabel = new JLabel();
        this.htmlField = new EntryField(30);
        this.htmlField.setAlignmentY(0.0f);
        this.htmlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.refreshAdvancedGUI();
                ExportZipDialog.this.htmlField.requestFocusInWindow();
            }
        });
        this.loadHTMLButton = new TButton(this.openIcon);
        this.loadHTMLButton.setContentAreaFilled(false);
        this.loadHTMLButton.setAlignmentY(0.0f);
        this.loadHTMLButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AsyncFileChooser chooser = TrackerIO.getChooser();
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setDialogTitle(TrackerRes.getString("ZipResourceDialog.FileChooser.OpenHTML.Title"));
                chooser.setFileFilter(LaunchBuilder.getHTMLFilter());
                File[] files = TrackerIO.getChooserFilesAsync(ExportZipDialog.this.frame, "open any", new Function<File[], Void>(){

                    @Override
                    public Void apply(File[] files) {
                        if (files == null) {
                            return null;
                        }
                        (this).ExportZipDialog.this.htmlField.setText(XML.getRelativePath(files[0].getPath()));
                        ExportZipDialog.this.refreshFieldsFromHTML(files[0]);
                        ExportZipDialog.this.refreshGUI();
                        return null;
                    }
                });
                chooser.removeChoosableFileFilter(LaunchBuilder.getHTMLFilter());
                if (files == null) {
                    return;
                }
            }
        });
        JToolBar htmlbar = new JToolBar();
        htmlbar.setBorder(toolbarBorder);
        htmlbar.setFloatable(false);
        htmlbar.setOpaque(false);
        htmlbar.add(this.htmlLabel);
        htmlbar.add(this.htmlField);
        htmlbar.add(this.loadHTMLButton);
        this.authorLabel = new JLabel();
        this.authorField = new EntryField(30);
        this.authorField.setText(panel.author);
        this.authorField.setBackground(Color.white);
        this.authorField.setAlignmentY(0.0f);
        this.authorField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.refreshMetadataGUI();
                ((ExportZipDialog)ExportZipDialog.this).frame.getTrackerPanelForID((Integer)((ExportZipDialog)ExportZipDialog.this).panelID).author = ExportZipDialog.this.authorField.getText().trim();
                ExportZipDialog.this.authorField.requestFocusInWindow();
            }
        });
        JToolBar authorbar = new JToolBar();
        authorbar.setBorder(toolbarBorder);
        authorbar.setFloatable(false);
        authorbar.setOpaque(false);
        authorbar.add(this.authorLabel);
        authorbar.add(this.authorField);
        this.contactLabel = new JLabel();
        this.contactField = new EntryField(30);
        this.contactField.setText(panel.contact);
        this.contactField.setBackground(Color.white);
        this.contactField.setAlignmentY(0.0f);
        this.contactField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.refreshMetadataGUI();
                ((ExportZipDialog)ExportZipDialog.this).frame.getTrackerPanelForID((Integer)((ExportZipDialog)ExportZipDialog.this).panelID).contact = ExportZipDialog.this.contactField.getText().trim();
                ExportZipDialog.this.contactField.requestFocusInWindow();
            }
        });
        JToolBar contactbar = new JToolBar();
        contactbar.setBorder(toolbarBorder);
        contactbar.setFloatable(false);
        contactbar.setOpaque(false);
        contactbar.add(this.contactLabel);
        contactbar.add(this.contactField);
        this.keywordsLabel = new JLabel();
        this.keywordsField = new EntryField(30);
        this.keywordsField.setAlignmentY(0.0f);
        this.keywordsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.refreshMetadataGUI();
                ExportZipDialog.this.keywordsField.requestFocusInWindow();
            }
        });
        JToolBar keywordsbar = new JToolBar();
        keywordsbar.setBorder(toolbarBorder);
        keywordsbar.setFloatable(false);
        keywordsbar.setOpaque(false);
        keywordsbar.add(this.keywordsLabel);
        keywordsbar.add(this.keywordsField);
        this.urlLabel = new JLabel();
        this.urlField = new EntryField(30);
        this.urlField.setAlignmentY(0.0f);
        this.urlField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportZipDialog.this.refreshAdvancedGUI();
                ExportZipDialog.this.urlField.requestFocusInWindow();
            }
        });
        JToolBar urlbar = new JToolBar();
        urlbar.setBorder(toolbarBorder);
        urlbar.setFloatable(false);
        urlbar.setOpaque(false);
        urlbar.add(this.urlLabel);
        urlbar.add(this.urlField);
        this.metaFieldsBox.add(authorbar);
        this.metaFieldsBox.add(contactbar);
        this.metaFieldsBox.add(keywordsbar);
        this.advancedFieldsBox.add(urlbar);
        this.advancedFieldsBox.add(htmlbar);
        this.thumbnailDisplay = new JLabel();
        Border line = BorderFactory.createLineBorder(Color.black);
        Border empty = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        this.thumbnailDisplay.setBorder(BorderFactory.createCompoundBorder(empty, line));
        this.thumbnailButton = new JButton();
        this.thumbnailButton.setForeground(labelColor);
        this.thumbnailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThumbnailDialog.getDialog(ExportZipDialog.this.frame.getTrackerPanelForID(ExportZipDialog.this.panelID), false).setVisible(true);
            }
        });
        this.thumbnailImagePanel = new JPanel();
        this.thumbnailImagePanel.add(this.thumbnailDisplay);
        this.showThumbnailCheckbox = new JCheckBox();
        this.showThumbnailCheckbox.setSelected(false);
        this.showThumbnailCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExportZipDialog.this.showThumbnailCheckbox.isSelected()) {
                    ExportZipDialog.this.refreshThumbnailImage();
                    ExportZipDialog.this.thumbnailPanel.add((Component)ExportZipDialog.this.thumbnailImagePanel, "South");
                } else {
                    ExportZipDialog.this.thumbnailPanel.remove(ExportZipDialog.this.thumbnailImagePanel);
                }
                ExportZipDialog.this.pack();
                TFrame.repaintT(ExportZipDialog.this);
            }
        });
        if (this.showThumbnailCheckbox.isSelected()) {
            this.thumbnailPanel.add((Component)this.thumbnailImagePanel, "South");
        }
        ThumbnailDialog dialog = ThumbnailDialog.getDialog(panel, false);
        dialog.addPropertyChangeListener("accepted", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ExportZipDialog.this.refreshThumbnailImage();
            }
        });
        JPanel northCenterPanel = new JPanel(new BorderLayout());
        JPanel northUpper = new JPanel(new BorderLayout());
        JPanel northLower = new JPanel(new BorderLayout());
        northCenterPanel.add((Component)northUpper, "North");
        northCenterPanel.add((Component)northLower, "South");
        JPanel southCenterPanel = new JPanel(new BorderLayout());
        JPanel southUpper = new JPanel(new BorderLayout());
        JPanel southLower = new JPanel(new BorderLayout());
        southCenterPanel.add((Component)southUpper, "North");
        southCenterPanel.add((Component)southLower, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)northCenterPanel, "North");
        centerPanel.add((Component)southCenterPanel, "Center");
        contentPane.add((Component)this.titlePanel, "North");
        contentPane.add((Component)centerPanel, "Center");
        contentPane.add((Component)buttonbar, "South");
        northUpper.add((Component)this.descriptionPanel, "North");
        northUpper.add((Component)this.tabsPanel, "South");
        northLower.add((Component)this.videoPanel, "North");
        northLower.add((Component)this.metaPanel, "South");
        southUpper.add((Component)this.thumbnailPanel, "North");
        southUpper.add((Component)this.supportFilesPanel, "South");
        southLower.add((Component)this.advancedPanel, "North");
        this.labels.add(this.authorLabel);
        this.labels.add(this.contactLabel);
        this.labels.add(this.keywordsLabel);
        this.labels.add(this.urlLabel);
        this.labels.add(this.htmlLabel);
        Border etch = BorderFactory.createEtchedBorder();
        this.titlePanel.setBorder(BorderFactory.createCompoundBorder(empty, etch));
        this.descriptionPanel.setBorder(BorderFactory.createCompoundBorder(empty, etch));
        this.tabsPanel.setBorder(BorderFactory.createCompoundBorder(empty, etch));
        this.videoPanel.setBorder(BorderFactory.createCompoundBorder(empty, etch));
        this.thumbnailPanel.setBorder(BorderFactory.createCompoundBorder(empty, etch));
        this.metaPanel.setBorder(BorderFactory.createCompoundBorder(empty, etch));
        this.supportFilesPanel.setBorder(BorderFactory.createCompoundBorder(empty, etch));
        this.advancedPanel.setBorder(BorderFactory.createCompoundBorder(empty, etch));
        MouseAdapter openCloseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String name;
                JComponent source = (JComponent)e.getSource();
                if (source == ExportZipDialog.this.descriptionLabel) {
                    source = ExportZipDialog.this.descriptionPanel;
                }
                source.setName((name = source.getName()) == null ? ExportZipDialog.EXPANDED : null);
                ExportZipDialog.this.refreshGUI();
                if (source == ExportZipDialog.this.descriptionPanel) {
                    ExportZipDialog.this.descriptionButton.requestFocusInWindow();
                }
                if (source == ExportZipDialog.this.tabsPanel) {
                    ExportZipDialog.this.tabsButton.requestFocusInWindow();
                }
                if (source == ExportZipDialog.this.videoPanel) {
                    ExportZipDialog.this.videoButton.requestFocusInWindow();
                }
                if (source == ExportZipDialog.this.metaPanel) {
                    ExportZipDialog.this.metaButton.requestFocusInWindow();
                }
                if (source == ExportZipDialog.this.thumbnailPanel) {
                    ExportZipDialog.this.thumbButton.requestFocusInWindow();
                }
                if (source == ExportZipDialog.this.supportFilesPanel) {
                    ExportZipDialog.this.supportFilesButton.requestFocusInWindow();
                }
                if (source == ExportZipDialog.this.advancedPanel) {
                    ExportZipDialog.this.advancedButton.requestFocusInWindow();
                }
            }
        };
        this.descriptionPanel.addMouseListener(openCloseListener);
        this.descriptionLabel.addMouseListener(openCloseListener);
        this.tabsPanel.addMouseListener(openCloseListener);
        this.videoPanel.addMouseListener(openCloseListener);
        this.thumbnailPanel.addMouseListener(openCloseListener);
        this.metaPanel.addMouseListener(openCloseListener);
        this.supportFilesPanel.addMouseListener(openCloseListener);
        this.advancedPanel.addMouseListener(openCloseListener);
    }

    private void refreshGUI() {
        String title = TrackerRes.getString("ZipResourceDialog.Title");
        this.setTitle(title);
        this.clipCheckbox.setText(TrackerRes.getString("ZipResourceDialog.Checkbox.TrimVideo"));
        this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
        this.saveButton.setText(String.valueOf(TrackerRes.getString("ExportZipDialog.Button.SaveZip.Text")) + "...");
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
        this.thumbnailButton.setText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Button.ThumbnailSettings")) + "...");
        this.showThumbnailCheckbox.setText(TrackerRes.getString("ZipResourceDialog.Checkbox.PreviewThumbnail"));
        this.addButton.setText(String.valueOf(TrackerRes.getString("Dialog.Button.Add")) + "...");
        this.removeButton.setText(TrackerRes.getString("Dialog.Button.Remove"));
        this.removeButton.setEnabled(this.fileList.getSelectedValue() != null);
        this.htmlLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.HTML"));
        this.titleLabel.setText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Label.Title")) + ":");
        this.descriptionLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.Description"));
        this.authorLabel.setText(TrackerRes.getString("PropertiesDialog.Label.Author"));
        this.contactLabel.setText(TrackerRes.getString("PropertiesDialog.Label.Contact"));
        this.keywordsLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.Keywords"));
        this.urlLabel.setText(TrackerRes.getString("ZipResourceDialog.Label.Link"));
        this.htmlLabel.setToolTipText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Tooltip.HTML")) + ": ");
        this.htmlField.setToolTipText(String.valueOf(TrackerRes.getString("ZipResourceDialog.Tooltip.HTML")) + ": ");
        this.titleLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Title"));
        this.titleField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Title"));
        this.descriptionLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Description"));
        this.descriptionPane.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Description"));
        this.authorLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Author"));
        this.authorField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Author"));
        this.contactLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Contact"));
        this.contactField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Contact"));
        this.keywordsLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Keywords"));
        this.keywordsField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Keywords"));
        this.urlLabel.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Link"));
        this.urlField.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.Link"));
        this.clipCheckbox.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.TrimVideo"));
        this.thumbnailButton.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.ThumbnailSettings"));
        this.loadHTMLButton.setToolTipText(TrackerRes.getString("ZipResourceDialog.Tooltip.LoadHTML"));
        Font font = this.titleLabel.getFont();
        int w = 0;
        for (JLabel next : this.labels) {
            FontSizer.setFonts(next, FontSizer.getLevel());
            Rectangle2D rect = font.getStringBounds(String.valueOf(next.getText()) + " ", OSPRuntime.frc);
            w = Math.max(w, (int)rect.getWidth() + 1);
        }
        int h = this.authorField.getMinimumSize().height;
        Dimension labelSize = new Dimension(w, h);
        for (JLabel next : this.labels) {
            next.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            next.setPreferredSize(labelSize);
            next.setHorizontalAlignment(11);
            next.setAlignmentY(0.0f);
        }
        String path = this.htmlField.getText().trim();
        Resource res = null;
        if (!path.equals(this.htmlField.getDefaultText()) && !path.equals("")) {
            res = ResourceLoader.getResource(path);
            this.htmlField.setForeground(res == null ? Color.red : EntryField.defaultForeground);
        }
        this.htmlField.setBackground(Color.white);
        path = this.urlField.getText().trim();
        if (!path.equals("")) {
            try {
                new URL(path);
                this.urlField.setForeground(EntryField.defaultForeground);
            }
            catch (MalformedURLException e) {
                this.urlField.setForeground(Color.red);
            }
        }
        this.urlField.setEnabled(res == null);
        this.urlLabel.setEnabled(res == null);
        this.descriptionPane.setEnabled(res == null);
        if (this.panelID != null) {
            this.refreshDescriptionGUI();
            this.refreshTabsGUI();
            this.refreshVideosGUI();
            this.refreshMetadataGUI();
            this.refreshThumbnailGUI();
            this.refreshSupportFilesGUI();
            this.refreshAdvancedGUI();
        }
        this.pack();
        TFrame.repaintT(this);
    }

    private void refreshThumbnailImage() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        ThumbnailDialog thumbnailDialog = ThumbnailDialog.getDialog(trackerPanel, false);
        BufferedImage image = thumbnailDialog.getThumbnail();
        this.thumbnailDisplay.setIcon(new ImageIcon(image));
        this.pack();
    }

    private void refreshDescriptionGUI() {
        String title = TrackerRes.getString("ZipResourceDialog.Label.Description");
        this.descriptionLabel.setText(String.valueOf(title) + ":");
        String info = this.descriptionPane.getText().trim();
        if ("".equals(info)) {
            info = TrackerRes.getString("ExportZipDialog.Border.Title.None");
        } else if (info.length() > maxLineLength) {
            info = String.valueOf(info.substring(0, maxLineLength)) + "...";
        }
        this.descriptionInfoLabel.setText(info);
        this.descriptionPanel.removeAll();
        this.descriptionPanel.add((Component)this.descriptionTitleBox, "North");
        if (this.descriptionPanel.getName() != null) {
            this.descriptionButton.setIcon(TViewChooser.MAXIMIZE_ICON);
            FontSizer.setFonts(this.descriptionPane, FontSizer.getLevel());
            JScrollPane scroller = new JScrollPane(this.descriptionPane){

                @Override
                public Dimension getPreferredSize() {
                    int w = super.getPreferredSize().width;
                    return new Dimension(w, 60);
                }
            };
            Box box = Box.createHorizontalBox();
            box.add(scroller);
            box.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.descriptionPanel.add((Component)box, "South");
        } else {
            this.descriptionButton.setIcon(TViewChooser.RESTORE_ICON);
        }
    }

    private void refreshTabsGUI() {
        String s;
        String title = TrackerRes.getString("ExportZipDialog.Border.Title.Tabs");
        this.tabsLabel.setText(String.valueOf(title) + ":");
        String currentTabTitle = null;
        int currentTabNumber = 0;
        ArrayList<String> currentTabs = new ArrayList<String>();
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        int i = 0;
        while (i < this.frame.getTabCount()) {
            String next = this.frame.getTabTitle(i);
            currentTabs.add(next);
            if (this.frame.getTrackerPanelForTab(i) == trackerPanel) {
                currentTabTitle = next;
                currentTabNumber = i;
            }
            ++i;
        }
        String equalsign = " =";
        if (this.tabCheckboxes.size() > currentTabs.size()) {
            ArrayList<JCheckBox> tempboxes = new ArrayList<JCheckBox>();
            ArrayList<EntryField> tempfields = new ArrayList<EntryField>();
            int i2 = 0;
            while (i2 < this.tabCheckboxes.size()) {
                s = this.tabCheckboxes.get(i2).getText();
                if (s.endsWith(" =")) {
                    s = s.substring(0, " =".length());
                }
                if (currentTabs.contains(s)) {
                    tempboxes.add(this.tabCheckboxes.get(i2));
                    tempfields.add(this.tabTitleFields.get(i2));
                }
                ++i2;
            }
            this.tabCheckboxes = tempboxes;
            this.tabTitleFields = tempfields;
        }
        if (this.tabCheckboxes.size() < currentTabs.size()) {
            int i3 = 0;
            while (i3 < this.tabCheckboxes.size()) {
                JCheckBox existing = this.tabCheckboxes.get(i3);
                if (!existing.getText().equals(String.valueOf((String)currentTabs.get(i3)) + " =")) {
                    EntryField field = this.tabTitleFields.get(i3);
                    s = XML.stripExtension((String)currentTabs.get(i3));
                    if (!s.equals(TrackerRes.getString("TrackerPanel.NewTab.Name"))) {
                        field.setText(s);
                    }
                    field.setBackground(Color.WHITE);
                }
                ++i3;
            }
            i3 = this.tabCheckboxes.size();
            while (i3 < this.frame.getTabCount()) {
                JCheckBox cb = new JCheckBox();
                cb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExportZipDialog.this.refreshGUI();
                        JCheckBox cb = (JCheckBox)e.getSource();
                        cb.requestFocusInWindow();
                    }
                });
                if (i3 == this.frame.getSelectedTab()) {
                    cb.setSelected(true);
                }
                this.tabCheckboxes.add(cb);
                EntryField field = new EntryField(){

                    @Override
                    public Dimension getMaximumSize() {
                        Dimension dim = super.getMaximumSize();
                        dim.height = ExportZipDialog.this.titleField.getPreferredSize().height;
                        return dim;
                    }
                };
                field.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExportZipDialog.this.refreshGUI();
                        EntryField field = (EntryField)e.getSource();
                        field.requestFocusInWindow();
                    }
                });
                s = XML.stripExtension((String)currentTabs.get(i3));
                if (!s.equals(TrackerRes.getString("TrackerPanel.NewTab.Name"))) {
                    field.setText(s);
                }
                this.tabTitleFields.add(field);
                field.setBackground(Color.WHITE);
                ++i3;
            }
        }
        this.tabsPanel.removeAll();
        this.tabsPanel.add((Component)this.tabsTitleBox, "North");
        Box stack = Box.createVerticalBox();
        int selectedCount = 0;
        int i4 = 0;
        while (i4 < this.frame.getTabCount()) {
            Box box = Box.createHorizontalBox();
            box.setBorder(BorderFactory.createEmptyBorder(2, 4, 0, 4));
            stack.add(box);
            JLabel label = new JLabel((String)currentTabs.get(i4));
            label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
            JCheckBox checkbox = this.tabCheckboxes.get(i4);
            checkbox.setEnabled(i4 != currentTabNumber);
            EntryField field = this.tabTitleFields.get(i4);
            field.setEnabled(checkbox.isSelected());
            box.add(checkbox);
            box.add(label);
            if (checkbox.isSelected()) {
                label.setText(String.valueOf(label.getText()) + " =");
                box.add(field);
            } else {
                box.add(Box.createHorizontalGlue());
            }
            if (checkbox.isSelected()) {
                ++selectedCount;
                String tabName = this.tabTitleFields.get(i4).getText().trim();
                if (tabName.length() == 0) {
                    tabName = (String)currentTabs.get(i4);
                }
            }
            ++i4;
        }
        String strippedTabTitle = XML.stripExtension(currentTabTitle);
        this.tabsInfoLabel.setText(selectedCount > 1 ? String.valueOf(strippedTabTitle) + " + " + (selectedCount - 1) : strippedTabTitle);
        if (this.tabsPanel.getName() != null) {
            this.tabsButton.setIcon(TViewChooser.MAXIMIZE_ICON);
            FontSizer.setFonts(stack, FontSizer.getLevel());
            this.tabsPanel.add((Component)stack, "South");
        } else {
            this.tabsButton.setIcon(TViewChooser.RESTORE_ICON);
        }
    }

    private void refreshVideosGUI() {
        String title = TrackerRes.getString("ZipResourceDialog.Border.Title.Video");
        this.videoLabel.setText(String.valueOf(title) + ":");
        String info = "";
        if (!this.clipCheckbox.isEnabled()) {
            info = TrackerRes.getString("ExportZipDialog.Border.Title.None");
        } else {
            VideoType format = TrackerIO.videoFormats.get(this.formatDropdown.getSelectedItem());
            if (format != null) {
                String ext = format.getDefaultExtension();
                info = this.clipCheckbox.isSelected() ? String.valueOf(TrackerRes.getString("ExportZipDialog.Border.Title.TrimToClip")) + " " + ext : TrackerRes.getString("ExportZipDialog.Border.Title.CopyOriginal");
            }
        }
        this.videoInfoLabel.setText(info);
        boolean hasVideo = this.frame.getTrackerPanelForID(this.panelID).getVideo() != null;
        int i = 0;
        while (i < this.frame.getTabCount()) {
            hasVideo = hasVideo || this.frame.getTrackerPanelForTab(i) != null && this.frame.getTrackerPanelForTab(i).getVideo() != null;
            ++i;
        }
        this.clipCheckbox.setEnabled(hasVideo);
        if (!hasVideo) {
            this.clipCheckbox.setSelected(false);
        }
        this.formatDropdown.setEnabled(this.clipCheckbox.isSelected());
        this.videoPanel.removeAll();
        this.videoPanel.add((Component)this.videoTitleBox, "North");
        if (this.videoPanel.getName() != null) {
            this.videoButton.setIcon(TViewChooser.MAXIMIZE_ICON);
            Box panel = Box.createHorizontalBox();
            panel.add(this.clipCheckbox);
            panel.add(this.formatDropdown);
            panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 4));
            FontSizer.setFonts(panel, FontSizer.getLevel());
            this.videoPanel.add((Component)panel, "South");
        } else {
            this.videoButton.setIcon(TViewChooser.RESTORE_ICON);
        }
    }

    private void refreshMetadataGUI() {
        String title = TrackerRes.getString("ExportZipDialog.Label.Metadata.Text");
        this.metaLabel.setText(String.valueOf(title) + ":");
        String info = "";
        if (this.authorField.getText().trim().length() > 0) {
            info = String.valueOf(info) + TrackerRes.getString("PropertiesDialog.Label.Author") + ", ";
        }
        if (this.contactField.getText().trim().length() > 0) {
            info = String.valueOf(info) + TrackerRes.getString("PropertiesDialog.Label.Contact") + ", ";
        }
        if (this.keywordsField.getText().trim().length() > 0) {
            info = String.valueOf(info) + TrackerRes.getString("ZipResourceDialog.Label.Keywords") + ", ";
        }
        info = info.length() == 0 ? TrackerRes.getString("ExportZipDialog.Border.Title.None") : info.substring(0, info.length() - 2);
        this.metaInfoLabel.setText(info);
        this.metaPanel.removeAll();
        this.metaPanel.add((Component)this.metaTitleBox, "North");
        if (this.metaPanel.getName() != null) {
            this.metaButton.setIcon(TViewChooser.MAXIMIZE_ICON);
            FontSizer.setFonts(this.metaFieldsBox, FontSizer.getLevel());
            this.metaPanel.add((Component)this.metaFieldsBox, "South");
        } else {
            this.metaButton.setIcon(TViewChooser.RESTORE_ICON);
        }
    }

    protected void refreshThumbnailGUI() {
        String title = TrackerRes.getString("ZipResourceDialog.Border.Title.Thumbnail");
        this.thumbLabel.setText(String.valueOf(title) + ":");
        Dimension dim = ThumbnailDialog.getDialog(this.frame.getTrackerPanelForID(this.panelID), false).getThumbnailSize();
        String info = String.valueOf(dim.width) + " x " + dim.height;
        this.thumbInfoLabel.setText(info);
        this.thumbnailPanel.removeAll();
        this.thumbnailPanel.add((Component)this.thumbTitleBox, "North");
        if (this.thumbnailPanel.getName() != null) {
            this.thumbButton.setIcon(TViewChooser.MAXIMIZE_ICON);
            JPanel panel = new JPanel();
            panel.add(this.thumbnailButton);
            panel.add(this.showThumbnailCheckbox);
            FontSizer.setFonts(panel, FontSizer.getLevel());
            this.thumbnailPanel.add((Component)panel, "Center");
            if (this.showThumbnailCheckbox.isSelected()) {
                this.refreshThumbnailImage();
                this.thumbnailPanel.add((Component)this.thumbnailImagePanel, "South");
            }
        } else {
            this.thumbButton.setIcon(TViewChooser.RESTORE_ICON);
        }
    }

    private void refreshSupportFilesGUI() {
        String title = TrackerRes.getString("ExportZipDialog.Border.Title.SupportFiles");
        this.supportFilesLabel.setText(String.valueOf(title) + ":");
        String info = String.valueOf(this.fileNames.size());
        if (this.fileNames.size() == 0) {
            info = TrackerRes.getString("ExportZipDialog.Border.Title.None");
        }
        this.supportFilesInfoLabel.setText(info);
        this.supportFilesPanel.removeAll();
        this.supportFilesPanel.add((Component)this.supportFilesTitleBox, "North");
        if (this.supportFilesPanel.getName() != null) {
            this.supportFilesButton.setIcon(TViewChooser.MAXIMIZE_ICON);
            FontSizer.setFonts(this.supportFilesBox, FontSizer.getLevel());
            this.supportFilesPanel.add((Component)this.supportFilesBox, "South");
        } else {
            this.supportFilesButton.setIcon(TViewChooser.RESTORE_ICON);
        }
    }

    private void refreshAdvancedGUI() {
        String title = TrackerRes.getString("ExportZipDialog.Label.Advanced.Text");
        this.advancedLabel.setText(String.valueOf(title) + ":");
        String info = "";
        if (this.urlField.getText().trim().length() > 0) {
            info = String.valueOf(info) + TrackerRes.getString("ZipResourceDialog.Label.Link") + ", ";
        }
        if (this.htmlField.getText().trim().length() > 0) {
            info = String.valueOf(info) + TrackerRes.getString("ZipResourceDialog.Label.HTML") + ", ";
        }
        info = info.length() == 0 ? TrackerRes.getString("ExportZipDialog.Border.Title.None") : info.substring(0, info.length() - 2);
        this.advancedInfoLabel.setText(info);
        this.advancedPanel.removeAll();
        this.advancedPanel.add((Component)this.advancedTitleBox, "North");
        if (this.advancedPanel.getName() != null) {
            this.advancedButton.setIcon(TViewChooser.MAXIMIZE_ICON);
            FontSizer.setFonts(this.advancedFieldsBox, FontSizer.getLevel());
            this.advancedPanel.add((Component)this.advancedFieldsBox, "South");
        } else {
            this.advancedButton.setIcon(TViewChooser.RESTORE_ICON);
        }
    }

    private void refreshFileList() {
        this.fileListModel.clear();
        this.fileNames.clear();
        for (File file : this.addedFiles) {
            this.fileNames.add(file.getName());
        }
        for (String string : this.fileNames) {
            this.fileListModel.addElement(string);
        }
    }

    private void refreshFormatDropdown() {
        TrackerIO.refreshVideoFormats();
        String selected = TrackerIO.getVideoFormat(preferredExtension);
        this.formatDropdown.removeAllItems();
        String zipped = MediaRes.getString("ZipImageVideoType.Description.Zipped");
        Object[] objectArray = TrackerIO.getVideoFormats();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object format = objectArray[n2];
            String desc = (String)format;
            if (!desc.startsWith(zipped)) {
                this.formatDropdown.addItem(format);
            }
            ++n2;
        }
        this.formatDropdown.setSelectedItem(selected);
    }

    private void refreshFieldsFromHTML(File htmlFile) {
        String html = ResourceLoader.getString(htmlFile.getAbsolutePath());
        if (html == null) {
            return;
        }
        String title = ResourceLoader.getTitleFromHTMLCode(html);
        if (title != null) {
            this.titleField.setText(title);
            this.titleField.setBackground(Color.white);
        }
        ArrayList<String[]> metadata = LibraryBrowser.getMetadataFromHTML(html);
        int i = metadata.size() - 1;
        while (i >= 0) {
            String[] next = metadata.get(i);
            String key = next[0];
            String value = next[1];
            if ("Author".toLowerCase().contains(key.toLowerCase())) {
                if ("".equals(this.authorField.getText().trim())) {
                    this.authorField.setText(value);
                    this.authorField.setBackground(Color.white);
                }
            } else if ("Contact".toLowerCase().contains(key.toLowerCase())) {
                if ("".equals(this.contactField.getText().trim())) {
                    this.contactField.setText(value);
                    this.contactField.setBackground(Color.white);
                }
            } else if ("Keywords".toLowerCase().contains(key.toLowerCase())) {
                this.keywordsField.setText(value);
                this.keywordsField.setBackground(Color.white);
            } else if ("description".contains(key.toLowerCase())) {
                this.descriptionPane.setText(value);
                this.descriptionPane.setBackground(Color.white);
            } else if ("url".contains(key.toLowerCase())) {
                this.urlField.setText(value);
                this.urlField.setBackground(Color.white);
            }
            --i;
        }
    }

    private void addVideosAndTRKs(ArrayList<File> zipList) {
        this.videoIOPreferredExtension = VideoIO.getPreferredExportExtension();
        int nTabs = 0;
        int i = 0;
        while (i < this.tabCheckboxes.size()) {
            if (this.tabCheckboxes.get(i).isSelected()) {
                ++nTabs;
            }
            ++i;
        }
        ArrayList<String> trkPaths = new ArrayList<String>();
        ArrayList<Export> exports = new ArrayList<Export>();
        int i2 = 0;
        while (i2 < this.tabCheckboxes.size()) {
            JCheckBox box = this.tabCheckboxes.get(i2);
            if (box.isSelected()) {
                String tabTitle;
                TrackerPanel panel = this.frame.getTrackerPanelForTab(i2);
                if (panel == null) {
                    return;
                }
                String string = tabTitle = i2 >= this.tabTitleFields.size() ? null : this.tabTitleFields.get(i2).getText().trim();
                if ("".equals(tabTitle) && nTabs == 1) {
                    tabTitle = this.titleField.getText().trim();
                }
                String trkPath = this.getTRKTarget(tabTitle, trkPaths);
                String originalPath = null;
                ExportVideoDialog exporter = null;
                String videoPath = null;
                Video vid = panel.getVideo();
                if (vid != null) {
                    originalPath = (String)vid.getProperty("absolutePath");
                    if (this.clipCheckbox.isSelected()) {
                        if (this.videoExporter == null) {
                            this.videoExporter = ExportVideoDialog.getVideoDialog(panel);
                        }
                        exporter = this.videoExporter;
                    } else if (originalPath != null) {
                        videoPath = String.valueOf(videoSubdirectory) + File.separator + XML.getName(originalPath);
                        String tempPath = String.valueOf(this.getTempDirectory()) + videoPath;
                        boolean videoexists = new File(tempPath).exists();
                        String[] imagePaths = VideoIO.getZippedImagePaths(originalPath);
                        if (imagePaths != null) {
                            videoexists = new File(imagePaths[0]).exists();
                        }
                        if (!videoexists) {
                            new File(String.valueOf(this.getTempDirectory()) + videoSubdirectory).mkdirs();
                            if (imagePaths != null) {
                                originalPath = imagePaths[0];
                                int k = 0;
                                while (k < imagePaths.length) {
                                    String vidPath = String.valueOf(videoSubdirectory) + File.separator + XML.getName(imagePaths[k]);
                                    tempPath = String.valueOf(this.getTempDirectory()) + vidPath;
                                    if (k == 0) {
                                        videoPath = tempPath;
                                    }
                                    if (!this.createTarget(imagePaths[k], new File(tempPath))) {
                                        return;
                                    }
                                    ++k;
                                }
                            } else if (!this.createTarget(originalPath, new File(tempPath))) {
                                return;
                            }
                        }
                    }
                }
                exports.add(new Export(zipList, tabTitle, originalPath, trkPath, videoPath, exporter, panel));
            }
            ++i2;
        }
        this.exportIterator = exports.iterator();
    }

    protected boolean createTarget(String path, File target) {
        if (this.copyOrExtractFile(path, target)) {
            return true;
        }
        JOptionPane.showMessageDialog(this, TrackerRes.getString("ZipResourceDialog.Dialog.ExportFailed.Message"), TrackerRes.getString("ZipResourceDialog.Dialog.ExportFailed.Title"), 0);
        return false;
    }

    private void addFiles(ArrayList<File> zipList) {
        for (File file : this.addedFiles) {
            String path = file.getAbsolutePath();
            boolean isHTML = XML.getExtension(path).startsWith("htm");
            if (isHTML) {
                this.copyAndAddHTMLPage(path, zipList);
                continue;
            }
            String dir = this.getTempDirectory();
            File targetFile = new File(dir, XML.getName(path));
            if (!this.copyOrExtractFile(path, targetFile)) continue;
            zipList.add(targetFile);
        }
    }

    protected void saveZipAs() {
        String description = this.descriptionPane.getText().trim();
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (!"".equals(description) && "".equals(trackerPanel.getDescription())) {
            trackerPanel.setDescription(description);
            trackerPanel.hideDescriptionWhenLoaded = true;
        }
        if (this.clipCheckbox.isSelected()) {
            this.badModels = this.getModelsNotInClips();
            if (!this.badModels.isEmpty()) {
                String names = "";
                for (ParticleModel next : this.badModels) {
                    if (!"".equals(names)) {
                        names = String.valueOf(names) + ", ";
                    }
                    names = String.valueOf(names) + "'" + next.getName() + "'";
                }
                int response = JOptionPane.showConfirmDialog(this.frame, String.valueOf(TrackerRes.getString("ZipResourceDialog.BadModels.Message1")) + "\n" + TrackerRes.getString("ZipResourceDialog.BadModels.Message2") + "\n" + TrackerRes.getString("ZipResourceDialog.BadModels.Message3") + "\n\n" + names + "\n\n" + TrackerRes.getString("ZipResourceDialog.BadModels.Question"), TrackerRes.getString("ZipResourceDialog.BadModels.Title"), 0, 2);
                if (response != 0) {
                    return;
                }
            }
        } else {
            Integer[] badImageVideoTabs = this.getTabsWithUnexportableImages();
            if (badImageVideoTabs.length > 0) {
                String names = "";
                Integer[] integerArray = badImageVideoTabs;
                int n = badImageVideoTabs.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer next = integerArray[n2];
                    if (!"".equals(names)) {
                        names = String.valueOf(names) + ", ";
                    }
                    names = String.valueOf(names) + "'" + this.frame.getTabTitle(next) + "'";
                    ++n2;
                }
                int response = JOptionPane.showConfirmDialog(this.frame, String.valueOf(TrackerRes.getString("ExportZipDialog.BadImageVideos.Message1")) + "\n" + TrackerRes.getString("ExportZipDialog.BadImageVideos.Message2") + "\n" + TrackerRes.getString("ExportZipDialog.BadImageVideos.Message3") + "\n\n" + names + "\n\n" + TrackerRes.getString("ExportZipDialog.BadImageVideos.Question"), TrackerRes.getString("ExportZipDialog.BadImageVideos.Title"), 0, 2);
                if (response != 0) {
                    return;
                }
            }
        }
        this.setVisible(false);
        final ArrayList<File> zipList = this.defineTarget();
        if (zipList == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExportZipDialog.this.saveZipAction(zipList);
            }
        }).start();
    }

    private void saveZip(ArrayList<File> zipList) {
        File target = new File(this.getZIPTarget());
        if (JarTool.compress(zipList, target, null)) {
            ResourceLoader.removeFromZipCache(target.getPath());
            this.openNewZip(target.getAbsolutePath());
            if (!OSPRuntime.isJS) {
                OSPRuntime.trigger(1000, e -> ResourceLoader.deleteFile(new File(this.getTempDirectory())));
            }
        }
    }

    private File writeHTMLInfo(String thumbPath, String redirectPath) {
        File htmlTarget = new File(this.getHTMLDirectory());
        htmlTarget.mkdirs();
        htmlTarget = new File(htmlTarget, String.valueOf(this.targetName) + "_info.html");
        thumbPath = XML.getPathRelativeTo(thumbPath, this.getHTMLDirectory());
        String title = this.titleField.getText().trim();
        String description = this.descriptionPane.getText().trim();
        String author = this.authorField.getText().trim();
        String contact = this.contactField.getText().trim();
        String keywords = this.keywordsField.getText().trim();
        String uri = this.urlField.getText().trim();
        TreeMap<String, String> metadata = new TreeMap<String, String>();
        if (!"".equals(author)) {
            metadata.put("author", author);
        }
        if (!"".equals(contact)) {
            metadata.put("contact", contact);
        }
        if (!"".equals(keywords)) {
            metadata.put("keywords", keywords);
        }
        if (!"".equals(description)) {
            metadata.put("description", description);
        }
        if (!"".equals(uri)) {
            metadata.put("URL", uri);
        }
        String htmlCode = LibraryResource.getHTMLCode(title, "Tracker", thumbPath, description, author, contact, uri, null, metadata);
        if (redirectPath != null) {
            String comment = "\n<!--redirect: " + redirectPath + "-->";
            int n = htmlCode.indexOf("<html>");
            htmlCode = String.valueOf(htmlCode.substring(0, n + 6)) + comment + htmlCode.substring(n + 6);
        }
        return this.writeFile(htmlCode, htmlTarget);
    }

    private File writeFile(String text, File target) {
        try {
            FileWriter fout = new FileWriter(target);
            fout.write(text);
            fout.close();
            return target;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void saveZipAction(ArrayList<File> zipList) {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        ThumbnailDialog dialog = ThumbnailDialog.getDialog(trackerPanel, false);
        String ext = dialog.getFormat();
        String thumbPath = String.valueOf(this.getTempDirectory()) + this.targetName + "_thumbnail." + ext;
        File thumbnail = dialog.saveThumbnail(thumbPath);
        if (thumbnail != null) {
            zipList.add(thumbnail);
            this.addHTMLInfo(thumbPath, zipList);
        }
        this.addVideosAndTRKs(zipList);
        this.nextExport(zipList);
    }

    private boolean copyOrExtractFile(String filePath, File targetFile) {
        String lowercase = filePath.toLowerCase();
        if (ResourceLoader.isHTTP(filePath)) {
            targetFile = ResourceLoader.download(filePath, targetFile, false);
        } else if (lowercase.contains("trz!") || lowercase.contains("jar!") || lowercase.contains("zip!")) {
            targetFile = ResourceLoader.extract(filePath, targetFile);
        } else {
            ResourceLoader.copyFile(new File(filePath), targetFile, 100000);
        }
        return targetFile.exists();
    }

    private boolean addHTMLInfo(String thumbPath, ArrayList<File> zipList) {
        boolean empty;
        File htmlTarget;
        Resource res = ResourceLoader.getResource(this.htmlField.getText().trim());
        if (res == null && !OSPRuntime.isJS) {
            File[] files = new File(this.targetDirectory).listFiles();
            boolean added = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File next = fileArray[n2];
                String name = XML.stripExtension(next.getName());
                String ext = XML.getExtension(next.getName());
                if (("html".equals(ext) || "htm".equals(ext)) && (name.equals(this.targetName) || name.equals(String.valueOf(this.targetName) + "_info"))) {
                    int response;
                    for (File file : this.addedFiles) {
                        boolean bl = added = added || file.getName().equals(next.getName());
                    }
                    if (!added && (response = JOptionPane.showConfirmDialog(this.frame, String.valueOf(TrackerRes.getString("ZipResourceDialog.AddHTMLInfo.Message1")) + " \"" + next.getName() + "\"\n" + TrackerRes.getString("ZipResourceDialog.AddHTMLInfo.Message2"), TrackerRes.getString("ZipResourceDialog.AddHTMLInfo.Title"), 0, 3)) == 0) {
                        res = ResourceLoader.getResource(next.getAbsolutePath());
                    }
                }
                ++n2;
            }
        }
        String redirect = null;
        if (res != null) {
            if (res.getFile() != null) {
                String html = res.getString();
                if (html != null && html.trim().startsWith("<!DOCTYPE html") && (htmlTarget = this.writeTempHTMLTarget(html, res)) != null) {
                    String path = this.copyAndAddHTMLPage(htmlTarget.getAbsolutePath(), zipList);
                    if (!htmlTarget.equals(res.getFile())) {
                        htmlTarget.delete();
                    }
                    return path != null;
                }
            } else {
                redirect = res.getAbsolutePath();
            }
        }
        if (empty = "".equals(this.titleField.getText().trim())) {
            this.titleField.setText(this.targetName);
        }
        htmlTarget = this.writeHTMLInfo(thumbPath, redirect);
        if (empty) {
            this.titleField.setText("");
            this.titleField.setBackground(Color.white);
        }
        if (htmlTarget == null) {
            return false;
        }
        if (!"".equals(htmlSubdirectory)) {
            htmlTarget = htmlTarget.getParentFile();
        }
        zipList.add(htmlTarget);
        return true;
    }

    private ArrayList<ParticleModel> getModelsNotInClips() {
        ArrayList<ParticleModel> allModels = new ArrayList<ParticleModel>();
        int i = 0;
        while (i < this.tabCheckboxes.size()) {
            TrackerPanel panel;
            JCheckBox box = this.tabCheckboxes.get(i);
            if (box.isSelected() && (panel = this.frame.getTrackerPanelForTab(i)) != null) {
                VideoClip clip = panel.getPlayer().getVideoClip();
                ArrayList<ParticleModel> models = panel.getDrawablesTemp(ParticleModel.class);
                Iterator<ParticleModel> it = models.iterator();
                while (it.hasNext()) {
                    ParticleModel model = it.next();
                    if (!clip.includesFrame(model.getStartFrame())) continue;
                    it.remove();
                }
                models.clear();
                allModels.addAll(models);
            }
            ++i;
        }
        return allModels;
    }

    private Integer[] getTabsWithUnexportableImages() {
        ArrayList<Integer> tabs = new ArrayList<Integer>();
        int i = 0;
        while (i < this.tabCheckboxes.size()) {
            Video video2;
            TrackerPanel panel;
            JCheckBox box = this.tabCheckboxes.get(i);
            if (box.isSelected() && (panel = this.frame.getTrackerPanelForTab(i)) != null && (video2 = panel.getVideo()) instanceof ImageVideo) {
                ImageVideo iv = (ImageVideo)video2;
                if (!iv.isFileBased() && !iv.saveInvalidImages()) {
                    tabs.add(i);
                } else {
                    String[] paths = iv.getValidPaths();
                    if (paths.length > 1) {
                        String imagePath = paths[0];
                        int k = 1;
                        while (k < paths.length) {
                            String next = ImageVideo.getNextImagePathInSequence(imagePath);
                            if (!paths[k].equals(next)) {
                                tabs.add(i);
                                break;
                            }
                            imagePath = paths[k];
                            ++k;
                        }
                    }
                }
            }
            ++i;
        }
        return tabs.toArray(new Integer[tabs.size()]);
    }

    private ArrayList<String> getHTMLPaths(XMLControl control) {
        ArrayList<String> pageViews = new ArrayList<String>();
        String xml = control.toXML();
        int j = xml.indexOf("PageTView$TabView");
        while (j > -1) {
            String text;
            Resource res;
            String s;
            if ((j = (xml = xml.substring(j + 17)).indexOf(s = "<property name=\"text\" type=\"string\">")) > -1 && (res = ResourceLoader.getResource(text = (xml = xml.substring(j + s.length())).substring(0, j = xml.indexOf("</property>")))) != null && res.getFile() != null) {
                pageViews.add(text);
            }
            j = xml.indexOf("PageTView$TabView");
        }
        return pageViews;
    }

    private ArrayList<String> getImagePaths(String html, String basePath, String pre, String post) {
        ArrayList<String> images = new ArrayList<String>();
        int j = html.indexOf(pre);
        while (j > -1) {
            String text;
            String path;
            Resource res;
            if ((j = (html = html.substring(j + pre.length())).indexOf(post)) > -1 && (res = ResourceLoader.getResource(path = XML.getResolvedPath(text = html.substring(0, j), basePath))) != null && res.getFile() != null) {
                images.add(text);
            }
            j = html.indexOf(pre);
        }
        return images;
    }

    private String copyAndAddHTMLPage(String htmlPath, ArrayList<File> zipList) {
        String html = null;
        Resource res = ResourceLoader.getResource(htmlPath);
        if (res != null) {
            html = res.getString();
        }
        if (html != null) {
            String css;
            String htmlBasePath = XML.getDirectoryPath(htmlPath);
            File htmlTarget = new File(this.getHTMLDirectory());
            htmlTarget.mkdirs();
            String pre = "<img src=\"";
            String post = "\"";
            ArrayList<String> imagePaths = this.getImagePaths(html, htmlBasePath, pre, post);
            if (!imagePaths.isEmpty()) {
                File imageDir = new File(this.getImageDirectory());
                imageDir.mkdirs();
                for (String next : imagePaths) {
                    String path = XML.getResolvedPath(next, htmlBasePath);
                    res = ResourceLoader.getResource(path);
                    File imageTarget = new File(imageDir, XML.getName(next));
                    if (res.getFile() != null) {
                        ResourceLoader.copyFile(res.getFile(), imageTarget);
                    }
                    path = XML.getPathRelativeTo(imageTarget.getAbsolutePath(), this.getHTMLDirectory());
                    html = this.substitutePathInText(html, next, path, pre, post);
                }
                zipList.add(imageDir);
            }
            if ((css = ResourceLoader.getStyleSheetFromHTMLCode(html)) != null && !ResourceLoader.isHTTP(css) && (res = ResourceLoader.getResource(XML.getResolvedPath(css, htmlBasePath))) != null) {
                String cssName = XML.getName(css);
                File cssTarget = new File(htmlTarget, XML.getName(cssName));
                ResourceLoader.copyFile(res.getFile(), cssTarget);
                html = this.substitutePathInText(html, css, cssName, "\"", "\"");
            }
            htmlTarget = new File(htmlTarget, XML.getName(htmlPath));
            try {
                FileWriter fout = new FileWriter(htmlTarget);
                fout.write(html);
                fout.close();
                String relPath = XML.getPathRelativeTo(htmlTarget.getAbsolutePath(), this.getTempDirectory());
                if (!"".equals(htmlSubdirectory)) {
                    htmlTarget = htmlTarget.getParentFile();
                }
                zipList.add(htmlTarget);
                return relPath;
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return null;
    }

    private String substitutePathInText(String text, String prevPath, String newPath, String pre, String post) {
        if (prevPath.equals(newPath)) {
            return text;
        }
        int i = text.indexOf(String.valueOf(pre) + prevPath + post);
        while (i > 0) {
            text = String.valueOf(text.substring(0, i + pre.length())) + newPath + text.substring(i + pre.length() + prevPath.length());
            i = text.indexOf(String.valueOf(pre) + prevPath + post);
        }
        return text;
    }

    private void openNewZip(final String path) {
        if (OSPRuntime.isJS) {
            return;
        }
        Runnable runner1 = new Runnable(){

            @Override
            public void run() {
                int response = JOptionPane.showConfirmDialog(ExportZipDialog.this.frame, String.valueOf(TrackerRes.getString("ZipResourceDialog.Complete.Message1")) + " \"" + XML.getName(path) + "\".\n" + TrackerRes.getString("ZipResourceDialog.Complete.Message2"), TrackerRes.getString("ZipResourceDialog.Complete.Title"), 0, 3);
                if (response == 0) {
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            ExportZipDialog.this.frame.doOpenExportedAndUpdateLibrary(path);
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                }
            }
        };
        SwingUtilities.invokeLater(runner1);
    }

    protected ArrayList<File> defineTarget() {
        File file;
        String[] reserved;
        if (this.lastTRZ == null || this.lastTRZ.getName().trim().length() < 2) {
            String tabtitle;
            String title = this.titleField.getText().trim();
            this.lastTRZ = !"".equals(title) ? new File(title) : (!"".equals(tabtitle = this.frame.getTabTitle(this.frame.getSelectedTab())) ? new File(tabtitle) : new File(""));
        }
        AsyncFileChooser chooser = TrackerIO.getChooser();
        chooser.setDialogTitle(TrackerRes.getString("ZipResourceDialog.FileChooser.SaveZip.Title"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(VideoIO.trzFileFilter);
        chooser.setFileFilter(VideoIO.trzFileFilter);
        chooser.setAccessory(null);
        chooser.setMultiSelectionEnabled(false);
        chooser.setSelectedFile(this.lastTRZ);
        int result = chooser.showSaveDialog(null);
        if (result != 0) {
            this.lastTRZ = new File("");
            chooser.setSelectedFile(this.lastTRZ);
            chooser.resetChoosableFileFilters();
            return null;
        }
        File chooserFile = this.lastTRZ = chooser.getSelectedFile();
        this.isOpenInTracker = false;
        if (!OSPRuntime.isJS && chooserFile.exists()) {
            int i = 0;
            while (i < this.frame.getTabCount()) {
                String path = this.frame.getTrackerPanelForTab((int)i).openedFromPath;
                if (path != null && path.equals(XML.forwardSlash(chooserFile.getPath()))) {
                    this.isOpenInTracker = true;
                }
                ++i;
            }
        }
        if (!TrackerIO.canWrite(chooserFile)) {
            return null;
        }
        chooser.resetChoosableFileFilters();
        this.targetName = XML.stripExtension(chooserFile.getName());
        String[] stringArray = reserved = new String[]{"/", "\\", "?", "<", ">", "\"", "|", ":", "*", "%"};
        int n = reserved.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (this.targetName.indexOf(next) > -1) {
                String list = "";
                int i = 1;
                while (i < reserved.length) {
                    list = String.valueOf(list) + "    " + reserved[i];
                    ++i;
                }
                JOptionPane.showMessageDialog(this.frame, String.valueOf(TrackerRes.getString("ZipResourceDialog.Dialog.BadFileName.Message")) + "\n" + list, TrackerRes.getString("ZipResourceDialog.Dialog.BadFileName.Title"), 2);
                return null;
            }
            ++n2;
        }
        this.targetDirectory = String.valueOf(chooserFile.getParent()) + "/";
        this.targetExtension = "trz";
        String ext = XML.getExtension(chooserFile.getName());
        if (!this.targetExtension.equals(ext) && !TrackerIO.canWrite(file = new File(String.valueOf(XML.stripExtension(chooserFile.getAbsolutePath())) + "." + this.targetExtension))) {
            return null;
        }
        this.targetVideo = null;
        return new ArrayList<File>(){

            @Override
            public boolean add(File f) {
                if (!this.contains(f)) {
                    super.add(f);
                }
                return true;
            }
        };
    }

    private String getTRKTarget(String tabTitle, ArrayList<String> existingTabTitles) {
        String path = null;
        String tempDir = this.getTempDirectory();
        path = tabTitle == null || "".equals(tabTitle.trim()) ? String.valueOf(tempDir) + this.targetName : String.valueOf(tempDir) + this.targetName + "_" + tabTitle;
        int append = 0;
        int len = path.length();
        while (existingTabTitles.contains(path)) {
            path = String.valueOf(path.substring(0, len)) + ++append;
        }
        existingTabTitles.add(path);
        return String.valueOf(path) + ".trk";
    }

    private String getVideoTarget(String trkName, String extension) {
        String vidDir = String.valueOf(this.getTempDirectory()) + videoSubdirectory;
        new File(vidDir).mkdirs();
        String videoName = String.valueOf(XML.stripExtension(trkName)) + "." + extension;
        return String.valueOf(vidDir) + File.separator + videoName;
    }

    private String getZIPTarget() {
        return String.valueOf(this.targetDirectory) + this.targetName + "." + this.targetExtension;
    }

    private String getHTMLDirectory() {
        return String.valueOf(this.getTempDirectory()) + htmlSubdirectory + "/";
    }

    private String getImageDirectory() {
        return String.valueOf(this.getTempDirectory()) + imageSubdirectory + "/";
    }

    private String getTempDirectory() {
        if (this.tempDir == null) {
            this.tempDir = String.valueOf(new File(System.getProperty("java.io.tmpdir"), "tracker" + new Random().nextInt()).toString()) + File.separator;
        }
        return this.tempDir;
    }

    private File writeTempHTMLTarget(String htmlCode, Resource res) {
        if (htmlCode == null || res.getFile() == null) {
            return null;
        }
        String title = ResourceLoader.getTitleFromHTMLCode(htmlCode);
        String newTitle = this.titleField.getText().trim();
        if (!"".equals(newTitle) && !newTitle.equals(title)) {
            title = "<title>" + title + "</title>";
            newTitle = "<title>" + newTitle + "</title>";
            htmlCode = htmlCode.replace(title, newTitle);
        }
        ArrayList<String[]> metadata = LibraryBrowser.getMetadataFromHTML(htmlCode);
        String[] stringArray = LibraryResource.META_TYPES;
        int n = LibraryResource.META_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String newValue = type.equals("Author") ? this.authorField.getText().trim() : (type.equals("Contact") ? this.contactField.getText().trim() : (type.equals("Keywords") ? this.keywordsField.getText().trim() : null));
            String prevValue = null;
            String key = null;
            boolean found = false;
            for (String[] next : metadata) {
                if (found) break;
                key = next[0];
                if (!type.toLowerCase().contains(key.toLowerCase())) continue;
                found = true;
                prevValue = next[1];
            }
            if (!found) {
                key = type.toLowerCase();
            }
            htmlCode = this.replaceMetadataInHTML(htmlCode, key, prevValue, newValue);
            ++n2;
        }
        File htmlTarget = res.getFile().getParentFile();
        htmlTarget = new File(htmlTarget, String.valueOf(this.targetName) + "_info.html");
        htmlTarget = this.writeFile(htmlCode, htmlTarget);
        return htmlTarget;
    }

    private String replaceMetadataInHTML(String htmlCode, String name, String prevValue, String newValue) {
        if (newValue == null || newValue.trim().equals("")) {
            return htmlCode;
        }
        if (prevValue == null) {
            int n = htmlCode.indexOf("<meta name=");
            if (n < 0) {
                n = htmlCode.indexOf("</head");
            }
            if (n > -1) {
                String newCode = "<meta name=\"" + name + "\" content=\"" + newValue + "\">\n";
                htmlCode = String.valueOf(htmlCode.substring(0, n)) + newCode + htmlCode.substring(n, htmlCode.length());
            }
        } else if (!"".equals(newValue) && !newValue.equals(prevValue)) {
            prevValue = "meta name=\"" + name + "\" content=\"" + prevValue + "\"";
            newValue = "meta name=\"" + name + "\" content=\"" + newValue + "\"";
            htmlCode = htmlCode.replace(prevValue, newValue);
        }
        return htmlCode;
    }

    public static void thumbnailDialogClosed(TrackerPanel trackerPanel) {
        ExportZipDialog d = ExportZipDialog.getDialog(trackerPanel);
        if (d.isVisible) {
            d.refreshThumbnailGUI();
        }
    }

    protected static class DocumentAdapter
    implements DocumentListener {
        protected DocumentAdapter() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.documentChanged(e);
        }

        public void documentChanged(DocumentEvent e) {
        }
    }

    protected static class EntryField
    extends JTextField {
        static Color defaultForeground = new JTextField().getForeground();
        static DocumentListener documentListener = new DocumentAdapter(){

            @Override
            public void documentChanged(DocumentEvent e) {
                JTextComponent field = (JTextComponent)e.getDocument().getProperty("parent");
                field.setBackground(Color.yellow);
                field.setForeground(defaultForeground);
            }
        };
        static FocusListener focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EntryField field = (EntryField)e.getSource();
                if (field.getDefaultText() != null && field.getText().equals(field.getDefaultText())) {
                    field.setText(null);
                    field.setForeground(defaultForeground);
                }
                field.setBackground(Color.white);
            }

            @Override
            public void focusLost(FocusEvent e) {
                boolean fire;
                EntryField field = (EntryField)e.getSource();
                boolean bl = fire = field.getBackground() == Color.yellow;
                if (field.getDefaultText() != null && "".equals(field.getText())) {
                    field.setText(field.getDefaultText());
                    field.setForeground(field.getEmptyForeground());
                } else {
                    field.setForeground(defaultForeground);
                }
                field.setBackground(Color.white);
                if (fire) {
                    field.fireActionPerformed();
                }
            }
        };
        static ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryField field = (EntryField)e.getSource();
                field.setBackground(Color.white);
                field.setForeground(defaultForeground);
            }
        };

        EntryField() {
            this.getDocument().putProperty("parent", this);
            this.addFocusListener(focusListener);
            this.addActionListener(actionListener);
            this.getDocument().addDocumentListener(documentListener);
        }

        EntryField(int width) {
            super(width);
            this.getDocument().putProperty("parent", this);
            this.addFocusListener(focusListener);
            this.addActionListener(actionListener);
            this.getDocument().addDocumentListener(documentListener);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = Math.max(dim.width, 25);
            dim.width = Math.min(dim.width, 100);
            dim.width += 4;
            return dim;
        }

        protected String getDefaultText() {
            return null;
        }

        protected Color getEmptyForeground() {
            return Color.gray;
        }
    }

    private class Export {
        private String name;
        private String originalVideoPath;
        private String videoTarget;
        private String trkPath;
        private int tabID;
        private ArrayList<File> zipList;
        private ExportVideoDialog exporter;
        private PropertyChangeListener listener;
        private String vidDir;

        protected Export(ArrayList<File> zipList, String name, String originalPath, String trkPath, String videoTarget, ExportVideoDialog exporter, TrackerPanel panel) {
            this.name = name;
            this.zipList = zipList;
            this.originalVideoPath = originalPath;
            this.videoTarget = videoTarget;
            this.trkPath = trkPath;
            this.exporter = exporter;
            this.tabID = panel.getID();
        }

        protected void export() {
            ImageVideo imageVid;
            String[] paths;
            int n;
            OSPRuntime.showStatus("Exporting  " + (this.name == null ? "tab" : this.name));
            this.vidDir = String.valueOf(ExportZipDialog.this.getTempDirectory()) + videoSubdirectory;
            if (this.exporter != null) {
                VideoIO.ZipImageVideoType zipType;
                VideoType vidType = TrackerIO.videoFormats.get(ExportZipDialog.this.formatDropdown.getSelectedItem());
                VideoIO.ZipImageVideoType zipImageVideoType = zipType = vidType instanceof VideoIO.ZipImageVideoType ? (VideoIO.ZipImageVideoType)vidType : null;
                if (zipType != null) {
                    vidType = zipType.getImageVideoType();
                }
                String extension = vidType.getDefaultExtension();
                this.videoTarget = ExportZipDialog.this.getVideoTarget(XML.getName(this.trkPath), extension);
                TrackerPanel trackerPanel = ExportZipDialog.this.frame.getTrackerPanelForID(this.tabID);
                this.exporter.setTrackerPanel(trackerPanel);
                this.exporter.setFormat((String)ExportZipDialog.this.formatDropdown.getSelectedItem());
                this.listener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        Export.this.videoTarget = null;
                        Export.this.exporter.removePropertyChangeListener("video_saved", Export.this.listener);
                        Export.this.exporter.removePropertyChangeListener("video_cancelled", Export.this.listener);
                        if (e.getPropertyName().equals("video_saved")) {
                            Export.this.videoTarget = e.getNewValue().toString();
                            Export.this.finalizeExport();
                        } else {
                            ExportZipDialog.this.exportCanceled();
                        }
                    }
                };
                this.exporter.addPropertyChangeListener("video_saved", this.listener);
                this.exporter.addPropertyChangeListener("video_cancelled", this.listener);
                this.exporter.exportFullSizeVideo(this.videoTarget, this.trkPath);
                return;
            }
            TrackerPanel panel = ExportZipDialog.this.frame.getTrackerPanelForID(this.tabID);
            Video vid = panel.getVideo();
            if (vid instanceof ImageVideo && (n = this.originalVideoPath.indexOf(XML.getName((paths = (imageVid = (ImageVideo)vid).getValidPaths())[0]))) > 0) {
                String base = this.originalVideoPath.substring(0, n);
                String[] stringArray = paths;
                int n2 = paths.length;
                int n3 = 0;
                while (n3 < n2) {
                    String path = stringArray[n3];
                    String name = XML.getName(path);
                    path = String.valueOf(base) + name;
                    String vidPath = String.valueOf(this.vidDir) + File.separator + name;
                    File target = new File(vidPath);
                    if (path.equals(this.originalVideoPath)) {
                        this.videoTarget = String.valueOf(videoSubdirectory) + File.separator + name;
                    } else if (!ExportZipDialog.this.createTarget(path, target)) {
                        return;
                    }
                    this.zipList.add(target);
                    ++n3;
                }
            }
            this.finalizeExport();
        }

        protected void finalizeExport() {
            XMLControl videoControl;
            if (this.videoTarget != null) {
                File vidFile = new File(this.videoTarget);
                File vidFileTemp = new File(ExportZipDialog.this.getTempDirectory(), this.videoTarget);
                if (vidFile.exists()) {
                    ResourceLoader.copyFile(vidFile, vidFileTemp);
                }
                if ((vidFile = vidFileTemp).exists()) {
                    this.zipList.add(vidFile);
                }
                if (!"".equals(videoSubdirectory)) {
                    File xmlFile = null;
                    File[] fileArray = new File(this.vidDir).listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File next = fileArray[n2];
                        if (next.getName().endsWith(".xml") && next.getName().startsWith(ExportZipDialog.this.targetName)) {
                            xmlFile = next;
                        }
                        if (!next.equals(vidFile) && !next.equals(xmlFile)) {
                            this.zipList.add(next);
                        }
                        ++n2;
                    }
                    if (xmlFile != null) {
                        xmlFile.delete();
                    }
                }
            }
            TrackerPanel panel = ExportZipDialog.this.frame.getTrackerPanelForID(this.tabID);
            XMLControlElement control = new XMLControlElement(panel);
            if (this.exporter != null) {
                this.modifyControlForClip(control);
            } else if (panel.getVideo() != null && (videoControl = control.getChildControl("videoclip").getChildControl("video")) != null) {
                String vidPath = XML.forwardSlash(this.videoTarget);
                videoControl.setValue("path", vidPath);
                videoControl.setValue("paths", null);
            }
            ArrayList htmlPaths = ExportZipDialog.this.getHTMLPaths(control);
            if (!htmlPaths.isEmpty()) {
                String xml = control.toXML();
                for (String nextHTMLPath : htmlPaths) {
                    String path = ExportZipDialog.this.copyAndAddHTMLPage(nextHTMLPath, this.zipList);
                    if (path == null) continue;
                    xml = ExportZipDialog.this.substitutePathInText(xml, nextHTMLPath, path, ">", "<");
                }
                control = new XMLControlElement(xml);
            }
            this.zipList.add(new File(control.write(this.trkPath)));
            ExportZipDialog.this.nextExport(this.zipList);
        }

        private void modifyControlForClip(XMLControl control) {
            TrackerPanel panel = ExportZipDialog.this.frame.getTrackerPanelForID(this.tabID);
            VideoPlayer player = panel.getPlayer();
            XMLControl clipXMLControl = control.getChildControl("videoclip");
            VideoClip realClip = player.getVideoClip();
            clipXMLControl.setValue("video_framecount", clipXMLControl.getInt("stepcount"));
            clipXMLControl.setValue("startframe", 0);
            clipXMLControl.setValue("stepsize", 1);
            if (this.videoTarget != null) {
                VideoType videoType = TrackerIO.videoFormats.get(ExportZipDialog.this.formatDropdown.getSelectedItem());
                String trkDir = ExportZipDialog.this.getTempDirectory();
                String relPath = XML.getPathRelativeTo(this.videoTarget, trkDir);
                XMLControl videoControl = videoType.getVideoControlForExportOnly(this.videoTarget, this.vidDir, clipXMLControl);
                if (videoControl != null) {
                    videoControl.setValue("path", relPath);
                    videoControl.setValue("filters", null);
                    if (videoType instanceof ImageVideoType) {
                        videoControl.setValue("paths", null);
                        videoControl.setValue("delta_t", player.getMeanStepDuration());
                    }
                }
            }
            XMLControl clipControlControl = control.getChildControl("clipcontrol");
            clipControlControl.setValue("delta_t", player.getMeanStepDuration());
            clipControlControl.setValue("frame", 0);
            XMLControl coordsControl = control.getChildControl("coords");
            Object[] array = (Object[])coordsControl.getObject("framedata");
            TreeMap<Integer, Integer> newFrameNumbers = new TreeMap<Integer, Integer>();
            int newFrameNum = ExportZipDialog.setNewFrameNumbersCoord(realClip, array, newFrameNumbers);
            ImageCoordSystem.FrameData[] newKeyFrames = new ImageCoordSystem.FrameData[newFrameNum + 1];
            for (Integer k : newFrameNumbers.keySet()) {
                newKeyFrames[k.intValue()] = (ImageCoordSystem.FrameData)array[(Integer)newFrameNumbers.get(k)];
            }
            coordsControl.setValue("framedata", newKeyFrames);
            if (!ExportZipDialog.this.badModels.isEmpty()) {
                ArrayList tracks = (ArrayList)ArrayList.class.cast(control.getObject("tracks"));
                Iterator it = tracks.iterator();
                while (it.hasNext()) {
                    TTrack track = (TTrack)it.next();
                    if (!ExportZipDialog.this.badModels.contains(track)) continue;
                    it.remove();
                }
                control.setValue("tracks", tracks);
            }
            for (XMLProperty next : control.getPropsRaw()) {
                XMLProperty prop = next;
                if (!prop.getPropertyName().equals("tracks")) continue;
                for (Object obj : prop.getPropertyContent()) {
                    XMLProperty item = (XMLProperty)obj;
                    XMLControl trackControl = (XMLControl)item.getPropertyContent().get(0);
                    Class<?> trackType = trackControl.getObjectClass();
                    if (PointMass.class.equals(trackType)) {
                        array = (Object[])trackControl.getObject("framedata");
                        newFrameNum = ExportZipDialog.setNewFrameNumbersPointVector(realClip, array, newFrameNumbers);
                        PointMass.FrameData[] newData = new PointMass.FrameData[newFrameNum + 1];
                        int[] keys = new int[newFrameNumbers.size()];
                        int index = 0;
                        for (Integer k : newFrameNumbers.keySet()) {
                            keys[index] = k;
                            newData[k.intValue()] = (PointMass.FrameData)array[(Integer)newFrameNumbers.get(k)];
                            ++index;
                        }
                        trackControl.setValue("framedata", newData);
                        trackControl.setValue("keyFrames", keys);
                        continue;
                    }
                    if (Vector.class.isAssignableFrom(trackType)) {
                        array = (Object[])trackControl.getObject("framedata");
                        newFrameNum = ExportZipDialog.setNewFrameNumbersPointVector(realClip, array, newFrameNumbers);
                        Vector.FrameData[] newKeys = new Vector.FrameData[newFrameNum + 1];
                        for (Integer k : newFrameNumbers.keySet()) {
                            newKeys[k.intValue()] = (Vector.FrameData)array[(Integer)newFrameNumbers.get(k)];
                            boolean bl = newKeys[k.intValue()].independent = newKeys[k.intValue()].xc != 0.0 || newKeys[k.intValue()].yc != 0.0;
                        }
                        trackControl.setValue("framedata", newKeys);
                        continue;
                    }
                    if (ParticleModel.class.isAssignableFrom(trackType)) {
                        ExportZipDialog.updateRange(realClip, trackControl, "start_frame", "end_frame");
                        continue;
                    }
                    if (Calibration.class.equals(trackType) || OffsetOrigin.class.equals(trackType)) {
                        array = (Object[])trackControl.getObject("world_coordinates");
                        newFrameNum = ExportZipDialog.setNewFrameNumbersCalibration(realClip, array, newFrameNumbers);
                        double[][] newKeys = new double[newFrameNum + 1][];
                        for (Integer k : newFrameNumbers.keySet()) {
                            newKeys[k.intValue()] = (double[])array[(Integer)newFrameNumbers.get(k)];
                        }
                        trackControl.setValue("world_coordinates", newKeys);
                        continue;
                    }
                    if (CircleFitter.class.equals(trackType)) {
                        ExportZipDialog.updateRange(realClip, trackControl, "absolute_start", "absolute_end");
                        array = (Object[])trackControl.getObject("framedata");
                        ArrayList<double[]> newKeyFrameData = new ArrayList<double[]>();
                        newFrameNumbers.clear();
                        newFrameNum = 0;
                        int i = 0;
                        while (i < array.length) {
                            double[] stepData;
                            int keyFrameNum;
                            if (array[i] != null && (newFrameNum = realClip.frameToStep(keyFrameNum = (int)(stepData = (double[])array[i])[0])) <= realClip.getLastFrameNumber() && newFrameNum >= realClip.getFirstFrameNumber()) {
                                stepData[0] = newFrameNum;
                                newKeyFrameData.add(stepData);
                            }
                            ++i;
                        }
                        double[][] newKeyData = (double[][])newKeyFrameData.toArray((T[])new double[newKeyFrameData.size()][]);
                        trackControl.setValue("framedata", newKeyData);
                        continue;
                    }
                    if (TapeMeasure.class.equals(trackType)) {
                        array = (Object[])trackControl.getObject("framedata");
                        if (array.length <= 0) continue;
                        newFrameNum = ExportZipDialog.setNewFrameNumbersTape(realClip, array, newFrameNumbers);
                        TapeMeasure.FrameData[] newKeys = new TapeMeasure.FrameData[newFrameNum + 1];
                        for (Integer k : newFrameNumbers.keySet()) {
                            newKeys[k.intValue()] = (TapeMeasure.FrameData)array[(Integer)newFrameNumbers.get(k)];
                        }
                        trackControl.setValue("framedata", newKeys);
                        continue;
                    }
                    if (!Protractor.class.equals(trackType)) continue;
                    array = (Object[])trackControl.getObject("framedata");
                    newFrameNumbers.clear();
                    newFrameNum = 0;
                    int nonNullIndex = 0;
                    int i = 0;
                    while (i < array.length) {
                        if (i > realClip.getEndFrameNumber()) break;
                        if (array[i] != null) {
                            nonNullIndex = i;
                        }
                        if (realClip.includesFrame(i)) {
                            newFrameNum = realClip.frameToStep(i);
                            if (nonNullIndex > -1) {
                                newFrameNumbers.put(newFrameNum, nonNullIndex);
                                nonNullIndex = -1;
                            } else {
                                newFrameNumbers.put(newFrameNum, i);
                            }
                        }
                        ++i;
                    }
                    double[][] newKeys = new double[newFrameNum + 1][];
                    for (Integer k : newFrameNumbers.keySet()) {
                        newKeys[k.intValue()] = (double[])array[(Integer)newFrameNumbers.get(k)];
                    }
                    trackControl.setValue("framedata", newKeys);
                }
            }
        }
    }

    class FormatRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        FormatRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 0));
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object val, int index, boolean selected, boolean hasFocus) {
            if (selected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (val != null && val instanceof String) {
                String s = (String)val;
                int i = s.indexOf("(");
                if (i > -1) {
                    s = s.substring(0, i - 1);
                }
                this.setText(s);
            }
            return this;
        }
    }

    protected class VideoListener
    implements PropertyChangeListener {
        ArrayList<File> target;
        ExportVideoDialog dialog;

        protected VideoListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("video_saved") && this.target != null) {
                ExportZipDialog.this.targetVideo = e.getNewValue().toString();
                preferredExtension = XML.getExtension(ExportZipDialog.this.targetVideo);
                VideoIO.setPreferredExportExtension(ExportZipDialog.this.videoIOPreferredExtension);
            }
            if (this.dialog != null) {
                this.dialog.removePropertyChangeListener("video_saved", ExportZipDialog.this.videoExportListener);
                this.dialog.removePropertyChangeListener("video_cancelled", ExportZipDialog.this.videoExportListener);
            }
        }

        void setTargetList(ArrayList<File> list) {
            this.target = list;
        }

        void setDialog(ExportVideoDialog evd) {
            this.dialog = evd;
        }
    }
}

