/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchNode;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.ResourceLoader;

public class HelpFinder {
    private static Map<String, Map<String, ArrayList<String>>> pages = new TreeMap<String, Map<String, ArrayList<String>>>();
    private static Map<String, String> pageNames = new TreeMap<String, String>();
    private static Map<String, String> anchorNames = new TreeMap<String, String>();
    private static Map<String, String> pagePaths = new TreeMap<String, String>();
    private static int contextPhraseLength = 120;
    private static int contextPhraseTrim = 15;
    private static int minimumSearchPhraseLength = 3;
    private static Color _RED = new Color(255, 160, 180);
    private static Launcher helpLauncher;
    private static LaunchPanel searchResultsTab;
    private static LaunchNode rootNode;
    private static JTextField searchField;
    private static JLabel searchLabel;
    private static JButton clearSearchButton;
    private static String css;

    static {
        searchField = new JTextField(12);
        HelpFinder.initialize();
    }

    protected static ArrayList<String[]> search(String searchPhrase, ArrayList<String> termsFound) {
        ArrayList<String[]> results = HelpFinder.search(searchPhrase);
        if (results.size() > 0) {
            termsFound.add(searchPhrase);
            return results;
        }
        String[] terms = searchPhrase.split(" ");
        if (terms.length < 2) {
            return results;
        }
        ArrayList allResults = new ArrayList();
        ArrayList<Object> termResults = new ArrayList();
        String[] stringArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            termResults = HelpFinder.search(term);
            allResults.add(termResults);
            ++n2;
        }
        ArrayList<String> contexts = new ArrayList<String>();
        block1: for (String[] next : termResults) {
            contexts.clear();
            String keyword = next[2];
            for (ArrayList arrayList : allResults) {
                boolean found = false;
                for (String[] result : arrayList) {
                    if (!keyword.equals(result[2])) continue;
                    found = true;
                    contexts.add(result[1]);
                    break;
                }
                if (!found) continue block1;
            }
            String string = HelpFinder.getMergedContext(contexts);
            results.add(new String[]{next[0], string, next[2]});
        }
        if (results.size() > 0) {
            String[] stringArray2 = terms;
            int n3 = terms.length;
            int n4 = 0;
            while (n4 < n3) {
                String term = stringArray2[n4];
                termsFound.add(term);
                ++n4;
            }
        }
        return results;
    }

    private static String getMergedContext(ArrayList<String> contexts) {
        ArrayList<String> phrases = new ArrayList<String>();
        ArrayList<String> cleanStarts = new ArrayList<String>();
        ArrayList<String> cleanEnds = new ArrayList<String>();
        for (String next : contexts) {
            if (!next.startsWith("...")) {
                cleanStarts.add(next.substring(0, Math.min(14, next.length())));
            }
            if (!next.endsWith("...")) {
                cleanEnds.add(next.substring(Math.max(0, next.length() - 14)));
            }
            next = next.replaceAll("\\.\\.\\.", "");
            if (phrases.isEmpty()) {
                phrases.add(next);
                continue;
            }
            boolean merged = false;
            ArrayList testing = new ArrayList(phrases);
            for (String context : testing) {
                if (context.contains(next)) {
                    merged = true;
                    break;
                }
                if (!next.contains(context)) continue;
                phrases.remove(context);
                phrases.add(next);
                merged = true;
                break;
            }
            if (!merged && next.length() > 15) {
                String toMatch = next.substring(0, 15);
                for (String context : testing) {
                    int n = context.indexOf(toMatch);
                    if (n <= 0) continue;
                    phrases.remove(context);
                    context = String.valueOf(context.substring(0, n)) + next;
                    phrases.add(context);
                    merged = true;
                    break;
                }
                if (!merged) {
                    int len = next.length();
                    toMatch = next.substring(len - 15, len);
                    for (String context : testing) {
                        int n = context.indexOf(toMatch);
                        if (n <= 0) continue;
                        phrases.remove(context);
                        context = String.valueOf(next) + context.substring(n + 15);
                        phrases.add(context);
                        merged = true;
                        break;
                    }
                }
            }
            if (merged) continue;
            phrases.add(next);
        }
        String context = "";
        boolean addEllipsis = true;
        for (String next : phrases) {
            if (!addEllipsis) {
                context = String.valueOf(context) + "\" | \"";
            }
            addEllipsis = true;
            for (String cleanStart : cleanStarts) {
                if (!next.startsWith(cleanStart)) continue;
                addEllipsis = false;
            }
            if (addEllipsis) {
                context = String.valueOf(context) + "...";
            }
            context = String.valueOf(context) + next;
            addEllipsis = true;
            for (String cleanEnd : cleanEnds) {
                if (!next.endsWith(cleanEnd)) continue;
                addEllipsis = false;
            }
        }
        if (addEllipsis) {
            context = String.valueOf(context) + "...";
        }
        return context.trim();
    }

    protected static Component[] getNavComponentsFor(Launcher launcher2) {
        helpLauncher = launcher2;
        searchLabel.setText(String.valueOf(TrackerRes.getString("HelpFinder.Label.SearchFor.Text")) + ":");
        searchLabel.setToolTipText(TrackerRes.getString("HelpFinder.Label.SearchFor.Tooltip"));
        searchField.setToolTipText(TrackerRes.getString("HelpFinder.Label.SearchFor.Tooltip"));
        clearSearchButton.setText(TrackerRes.getString("HelpFinder.Button.ClearResults.Text"));
        clearSearchButton.setToolTipText(TrackerRes.getString("HelpFinder.Button.ClearResults.Tooltip"));
        return new Component[]{searchLabel, searchField, Box.createHorizontalStrut(4), clearSearchButton, TToolBar.getSeparator()};
    }

    private static ArrayList<String[]> search(String searchPhrase) {
        searchPhrase = searchPhrase.toLowerCase();
        ArrayList<String> keywordsFound = new ArrayList<String>();
        ArrayList<String[]> results = new ArrayList<String[]>();
        block0: for (String pageKey : pageNames.keySet()) {
            String pageTitle = pageNames.get(pageKey);
            if (!pageTitle.toLowerCase().contains(searchPhrase)) continue;
            for (String anchor : anchorNames.keySet()) {
                String sectionTitle = anchorNames.get(anchor);
                if (sectionTitle == null || !sectionTitle.equals(pageTitle)) continue;
                Map<String, ArrayList<String>> anchors = pages.get(pageKey);
                ArrayList<String> lines = anchors.get(anchor);
                String line = lines != null && lines.size() > 0 ? (String)lines.get(0) : pageTitle;
                String context = HelpFinder.getContextPhrase(line, searchPhrase);
                String keyword = String.valueOf(pageKey) + "#" + anchor;
                String fullPath = String.valueOf(pagePaths.get(pageKey)) + "#" + anchor;
                String[] result = new String[]{pageTitle, context, fullPath};
                results.add(result);
                keywordsFound.add(keyword);
                continue block0;
            }
        }
        for (String anchor : anchorNames.keySet()) {
            String section = anchorNames.get(anchor);
            if (section == null || !section.toLowerCase().contains(searchPhrase)) continue;
            for (String pageKey : pages.keySet()) {
                Map<String, ArrayList<String>> anchors = pages.get(pageKey);
                for (String next : anchors.keySet()) {
                    String keyword;
                    if (!next.equals(anchor) || keywordsFound.contains(keyword = String.valueOf(pageKey) + "#" + anchor)) continue;
                    String pageName = pageNames.get(pageKey);
                    ArrayList<String> lines = anchors.get(anchor);
                    String line = lines != null && lines.size() > 0 ? lines.get(0) : pageName;
                    String context = HelpFinder.getContextPhrase(line, searchPhrase);
                    String name = String.valueOf(pageName) + ": " + section;
                    String fullPath = String.valueOf(pagePaths.get(pageKey)) + "#" + anchor;
                    String[] result = new String[]{name, context, fullPath};
                    results.add(result);
                    keywordsFound.add(keyword);
                }
            }
        }
        for (String pageKey : pages.keySet()) {
            Map<String, ArrayList<String>> anchors = pages.get(pageKey);
            for (String anchor : anchors.keySet()) {
                String keyword = String.valueOf(pageKey) + "#" + anchor;
                ArrayList<String> lines = anchors.get(anchor);
                for (String line : lines) {
                    int n;
                    if (keywordsFound.contains(keyword) || (n = line.toLowerCase().indexOf(searchPhrase)) <= -1) continue;
                    String phrase = HelpFinder.getContextPhrase(line, searchPhrase);
                    String name = pageNames.get(pageKey);
                    String section = anchorNames.get(anchor);
                    if (section != null && !section.equals(name)) {
                        name = String.valueOf(name) + ": " + section;
                    }
                    String fullPath = String.valueOf(pagePaths.get(pageKey)) + "#" + anchor;
                    String[] result = new String[]{name, phrase, fullPath};
                    results.add(result);
                    keywordsFound.add(keyword);
                }
            }
        }
        return results;
    }

    private static void initialize() {
        URL url = Tracker.getClassResource("resources/help/tracker_topics.xml");
        String xml = ResourceLoader.getString(url.toExternalForm());
        XMLControlElement control = new XMLControlElement(xml);
        ArrayList children = (ArrayList)control.getObject("child_nodes");
        for (LaunchNode next : children) {
            String pagekey = next.getKeywords();
            String name = next.getName();
            pageNames.put(pagekey, name);
            String path = next.getDisplayTab(0).getURL().toString();
            pagePaths.put(pagekey, path);
            if (css == null) {
                css = String.valueOf(XML.getDirectoryPath(path)) + "/help.css";
            }
            String html = ResourceLoader.getString(path);
            Map<String, ArrayList<String>> map = HelpFinder.getAnchors(html);
            pages.put(pagekey, map);
        }
        searchField = new JTextField(20){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension((int)(100.0 * FontSizer.getFactor()), clearSearchButton.getPreferredSize().height);
            }
        };
        searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    HelpFinder.doSearch();
                } else {
                    searchField.setBackground(Color.yellow);
                }
            }
        });
        searchLabel = new JLabel();
        searchLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        clearSearchButton = new JButton();
        clearSearchButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                helpLauncher.setSelectedTab(searchResultsTab);
                helpLauncher.removeSelectedTab();
                searchField.setText(null);
                clearSearchButton.setEnabled(false);
                searchResultsTab = null;
                rootNode = null;
            }
        });
        clearSearchButton.setEnabled(false);
    }

    protected static void doSearch() {
        String searchPhrase = HelpFinder.stripExtraSpace(searchField.getText(), " ");
        if (searchPhrase.length() >= minimumSearchPhraseLength) {
            ArrayList<String> found = new ArrayList<String>();
            ArrayList<String[]> results = HelpFinder.search(searchPhrase, found);
            if (results.size() == 0) {
                searchField.setBackground(_RED);
                return;
            }
            searchField.setBackground(Color.white);
            File file = HelpFinder.writeResultsFile(searchPhrase, results, found);
            if (file == null) {
                return;
            }
            LaunchNode node = new LaunchNode("\"" + searchPhrase + "\"");
            node.addDisplayTab(null, file.getAbsolutePath(), null);
            node.getDisplayTab(0).getURL();
            HelpFinder.displayResultsNode(node);
        }
    }

    private static void displayResultsNode(LaunchNode node) {
        if (rootNode == null) {
            rootNode = new LaunchNode(TrackerRes.getString("HelpFinder.SearchResults"));
        }
        if (searchResultsTab != null) {
            helpLauncher.setSelectedTab(searchResultsTab);
            helpLauncher.removeSelectedTab();
        }
        rootNode.add(node);
        ArrayList<LaunchNode> children = new ArrayList<LaunchNode>();
        int i = 0;
        while (i < rootNode.getChildCount()) {
            children.add((LaunchNode)rootNode.getChildAt(i));
            ++i;
        }
        File file = HelpFinder.writeSummaryFile(children);
        if (rootNode.getDisplayTabCount() > 0) {
            rootNode.removeDisplayTab(0);
        }
        rootNode.addDisplayTab(null, file.getAbsolutePath(), null);
        rootNode.getDisplayTab(0).getURL();
        helpLauncher.addTab(rootNode);
        searchResultsTab = helpLauncher.getSelectedTab();
        if (FontSizer.getLevel() > 0) {
            String newValue = "help" + FontSizer.getLevel() + ".css";
            searchResultsTab.getHTMLSubstitutionMap().put("help.css", newValue);
            helpLauncher.setFontLevel(FontSizer.getLevel());
            int i2 = 0;
            while (i2 < helpLauncher.getHTMLTabCount()) {
                Launcher.HTMLPane pane = helpLauncher.getHTMLTab(i2);
                pane.editorPane.getDocument().putProperty("stream", null);
                ++i2;
            }
        }
        searchResultsTab.setTreeSelectionPath(node);
        clearSearchButton.setEnabled(true);
    }

    private static Map<String, ArrayList<String>> getAnchors(String html) {
        html = HelpFinder.clean(html);
        TreeMap<String, ArrayList<String>> anchorMap = new TreeMap<String, ArrayList<String>>();
        String[] sections = html.split("<h1|<h3");
        int i = 1;
        while (i < sections.length) {
            block4: {
                int n;
                String s = sections[i];
                String[] anchorSplit = s.split("<a name=\"|<a id=\"");
                if (anchorSplit.length < 2) break block4;
                String name = anchorSplit[1];
                String anchor = name.substring(0, name.indexOf("\""));
                int m = (name = HelpFinder.stripTag(name, "</a")).indexOf(">");
                int n2 = n = m <= 0 ? -1 : Math.max(name.indexOf("</h3>"), name.indexOf("</h1>"));
                if (n > m) {
                    name = name.substring(m + 1, n);
                }
                if (Character.isDigit(name.charAt(0))) {
                    name = name.substring(name.indexOf(" ") + 1, name.length());
                }
                anchorNames.put(anchor, name);
                s = HelpFinder.stripTag(s, "<a href");
                s = HelpFinder.stripTag(s, "</a");
                String[] split = s.split("<p>");
                ArrayList<String> lines = new ArrayList<String>();
                int j = 1;
                while (j < split.length) {
                    block7: {
                        String p;
                        block6: {
                            block5: {
                                p = split[j];
                                n = p.indexOf("</p>");
                                if (n < 0) break block5;
                                if ((p = p.substring(0, n).trim()).length() != 0) break block6;
                                break block7;
                            }
                            System.out.println("no ending </p> in " + p);
                            System.out.println("found in section: " + s);
                        }
                        lines.add(HelpFinder.stripExtraSpace(p, " "));
                    }
                    ++j;
                }
                anchorMap.put(anchor, lines);
            }
            ++i;
        }
        return anchorMap;
    }

    private static String clean(String text) {
        text = text.replaceAll("<h5>", "<p>");
        text = text.replaceAll("</h5>", "</p>");
        text = text.replaceAll("<blockquote>", "<p>");
        text = text.replaceAll("</blockquote>", "</p>");
        text = text.replaceAll("<li>", "<p>");
        text = text.replaceAll("</li>", "</p>");
        text = text.replaceAll("<p align=\"center\">", "<p>");
        text = text.replaceAll("&gt;", ">");
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("<br>", " ");
        text = text.replaceAll("&quot;", "\"");
        text = HelpFinder.stripTag(text, "<img");
        text = HelpFinder.stripTag(text, "<b");
        text = HelpFinder.stripTag(text, "</b");
        text = HelpFinder.stripTag(text, "<em");
        text = HelpFinder.stripTag(text, "</em");
        text = HelpFinder.stripTag(text, "<strong");
        text = HelpFinder.stripTag(text, "</strong");
        text = HelpFinder.stripTag(text, "<ol");
        text = HelpFinder.stripTag(text, "</ol");
        text = HelpFinder.stripTag(text, "<ul");
        text = HelpFinder.stripTag(text, "</ul");
        return text;
    }

    private static String getContextPhrase(String line, String searchPhrase) {
        int n = line.toLowerCase().indexOf(searchPhrase);
        if (n > -1) {
            int start = Math.max(0, n - contextPhraseLength);
            int end = Math.min(line.length(), n + searchPhrase.length() + contextPhraseLength);
            String phrase = line.substring(start, end);
            start = phrase.toLowerCase().indexOf(searchPhrase);
            end = start + searchPhrase.length();
            n = phrase.indexOf(" ");
            if (n > -1 && n < start - contextPhraseLength + contextPhraseTrim) {
                phrase = "..." + phrase.substring(n + 1);
            }
            start = phrase.toLowerCase().indexOf(searchPhrase);
            end = start + searchPhrase.length();
            n = phrase.lastIndexOf(" ");
            if (n > end + contextPhraseLength - contextPhraseTrim) {
                phrase = String.valueOf(phrase.substring(0, n)) + "...";
            }
            return phrase;
        }
        String phrase = line.substring(0, Math.min(line.length(), 2 * contextPhraseLength + contextPhraseTrim));
        n = phrase.lastIndexOf(" ");
        if (n > contextPhraseLength) {
            phrase = String.valueOf(phrase.substring(0, n)) + "...";
        }
        return phrase;
    }

    private static String stripTag(String text, String tag) {
        int i;
        while ((i = text.indexOf(tag)) > 0) {
            String later = text.substring(i);
            text = text.substring(0, i);
            int j = later.indexOf(">");
            if (j < 0) break;
            text = String.valueOf(text) + later.substring(j + 1);
        }
        return text;
    }

    private static String stripExtraSpace(String text, String space) {
        text = text.trim();
        String extraSpace = " " + space;
        while (text.indexOf(extraSpace) >= 0) {
            text = text.replaceAll(extraSpace, space);
        }
        return text;
    }

    private static File writeResultsFile(String searchPhrase, ArrayList<String[]> results, ArrayList<String> termsFound) {
        String htmlCode = HelpFinder.getResultsHTMLCode(searchPhrase, results, termsFound);
        String fileName = "search" + results.hashCode() + ".tmp";
        ArrayList<String> paths = OSPRuntime.getDefaultSearchPaths();
        for (String path : paths) {
            File target = new File(path, fileName);
            if ((target = HelpFinder.writeFile(htmlCode, target)) == null) continue;
            target.deleteOnExit();
            return target;
        }
        String pathlist = "";
        for (String path : paths) {
            pathlist = String.valueOf(pathlist) + "\n" + path + ",";
        }
        pathlist = pathlist.substring(0, pathlist.length() - 1);
        JOptionPane.showMessageDialog(searchField.getTopLevelAncestor(), String.valueOf(TrackerRes.getString("HelpFinder.Dialog.UnableToWrite.Text")) + pathlist, TrackerRes.getString("HelpFinder.Dialog.UnableToWrite.Title"), 0);
        return null;
    }

    private static File writeSummaryFile(ArrayList<LaunchNode> resultNodes) {
        String htmlCode = HelpFinder.getSummaryHTMLCode(resultNodes);
        String fileName = "search_summary.tmp";
        ArrayList<String> paths = OSPRuntime.getDefaultSearchPaths();
        for (String path : paths) {
            File target = new File(path, fileName);
            if ((target = HelpFinder.writeFile(htmlCode, target)) == null) continue;
            target.deleteOnExit();
            return target;
        }
        return null;
    }

    private static File writeFile(String text, File target) {
        try {
            FileWriter fout = new FileWriter(target);
            fout.write(text);
            fout.close();
            return target;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getResultsHTMLCode(String searchPhrase, ArrayList<String[]> searchResults, ArrayList<String> termsToHighlight) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        buffer.append("\n  <html>");
        buffer.append("\n    <head>");
        buffer.append("\n" + HelpFinder.getStyleSheetCode());
        buffer.append("\n      <meta http-equiv=\"content-type\" content=\"text/html;charset=iso-8859-1\">");
        buffer.append("\n    </head>\n");
        buffer.append("\n    <body>");
        buffer.append("\n    <h2>" + TrackerRes.getString("HelpFinder.ResultsFor") + " \"" + searchPhrase + "\"</h2>");
        for (String[] next : searchResults) {
            buffer.append(HelpFinder.getResultsHTMLBody(next, termsToHighlight));
        }
        buffer.append("\n    </body>");
        buffer.append("\n  </html>");
        return buffer.toString();
    }

    private static String getSummaryHTMLCode(ArrayList<LaunchNode> resultNodes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        buffer.append("\n  <html>");
        buffer.append("\n    <head>");
        buffer.append("\n" + HelpFinder.getStyleSheetCode());
        buffer.append("\n      <meta http-equiv=\"content-type\" content=\"text/html;charset=iso-8859-1\">");
        buffer.append("\n    </head>\n");
        buffer.append("\n    <body>");
        buffer.append("\n    <h2>" + TrackerRes.getString("HelpFinder.ResultsFor") + ":</h2>");
        buffer.append(HelpFinder.getSummaryHTMLBody(resultNodes));
        buffer.append("\n    </body>");
        buffer.append("\n  </html>");
        return buffer.toString();
    }

    private static String getResultsHTMLBody(String[] result, ArrayList<String> highlightTerms) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<p><a href=\"" + result[2] + "\"><strong>" + result[0] + "</strong></a>");
        String context = result[1];
        for (String term : highlightTerms) {
            context = HelpFinder.addHighlights(context, term);
        }
        buffer.append(" \"" + context + "\"</p>");
        return buffer.toString();
    }

    private static String getSummaryHTMLBody(ArrayList<LaunchNode> resultNodes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<blockquote>");
        for (LaunchNode next : resultNodes) {
            buffer.append("<h4><a href=\"" + next.getDisplayTab(0).getURL() + "\">" + next + "</a></h4>");
        }
        buffer.append("</blockquote>");
        return buffer.toString();
    }

    private static String getStyleSheetCode() {
        return "<link href=\"" + css + "\" rel=\"stylesheet\" type=\"text/css\">";
    }

    private static String addHighlights(String text, String highlight) {
        highlight = highlight.toLowerCase();
        StringBuffer output = new StringBuffer();
        int n = text.toLowerCase().indexOf(highlight);
        while (n > -1) {
            output.append(text.substring(0, n));
            String term = text.substring(n, n + highlight.length());
            text = text.substring(n + highlight.length());
            output.append("<strong>" + term + "</strong>");
            n = text.toLowerCase().indexOf(highlight);
        }
        output.append(text);
        return output.toString();
    }
}

