/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.ProtractorStep;
import org.opensourcephysics.cabrillo.tracker.Ruler;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeStep;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public abstract class InputTrack
extends TTrack {
    protected NumberField inputField = this.createInputField();
    protected MouseListener editListener;
    protected boolean editing;
    protected boolean fixedPosition = true;
    protected Ruler ruler;
    protected JCheckBox rulerCheckbox;

    protected abstract boolean checkKeyFrame();

    protected abstract NumberField createInputField();

    protected abstract void endEditing(Step var1, String var2);

    protected abstract Rectangle getLayoutBounds(Step var1);

    protected abstract void refreshStep(Step var1);

    protected abstract void setInputValue(Step var1);

    public InputTrack(int type) {
        super(type);
        this.inputField.setBorder(null);
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputTrack.this.stopEditing();
            }
        });
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                InputTrack.this.inputField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                InputTrack.this.stopEditing();
            }
        });
        this.editListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                InputTrack.this.stopEditing();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                InputTrack.this.mouseClickedAction(e.getPoint());
            }
        };
        this.rulerCheckbox = new JCheckBox();
        this.rulerCheckbox.setBorder(BorderFactory.createEmptyBorder());
        this.rulerCheckbox.setOpaque(false);
        this.rulerCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InputTrack.this.getRuler().setVisible(InputTrack.this.rulerCheckbox.isSelected());
                InputTrack.this.repaint();
            }
        });
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removeMouseListener(this.editListener);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addMouseListener(this.editListener);
        }
    }

    @Override
    public void setFootprint(String name) {
        super.setFootprint(name);
        if (this.ruler != null && this.ruler.isVisible()) {
            this.ruler.setStrokeWidth(this.footprint.getStroke().getLineWidth());
        }
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        if (this.ruler != null) {
            this.ruler.setColor(this.getColor());
        }
    }

    @Override
    public Step getStep(TPoint point, TrackerPanel trackerPanel) {
        if (point == null) {
            return null;
        }
        Step step = super.getStep(point, trackerPanel);
        if (step == null && this.ruler != null && this.ruler.isVisible() && point == this.ruler.getHandle()) {
            step = this.getStep(trackerPanel.getFrameNumber());
        }
        return step;
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        FontSizer.setFont(this.rulerCheckbox);
    }

    protected Ruler getRuler() {
        return null;
    }

    protected void setEditAction(Step step, Point pt, String rawText) {
        if (this.editing) {
            this.tp.setSelectedTrack(this);
            FontSizer.setFonts(this.inputField, FontSizer.getLevel());
            this.inputField.setForeground(this.footprint.getColor());
            this.inputField.setValue(this.magField.getValue());
            Dimension d = this.inputField.getPreferredSize();
            Rectangle bounds = this.getLayoutBounds(step);
            int wid = Math.max(40, bounds.width + 7);
            this.inputField.setBounds(bounds.x - 2, bounds.y - 5, wid, d.height);
            this.tp.add(this.inputField);
            Border space = BorderFactory.createEmptyBorder(0, 1, 1, 0);
            Color color = this.getFootprint().getColor();
            Border line = BorderFactory.createLineBorder(color);
            this.inputField.setBorder(BorderFactory.createCompoundBorder(line, space));
            this.setInputValue(step);
            this.inputField.requestFocus();
        } else {
            this.endEditing(step, rawText);
            this.tp.remove(this.inputField);
            this.invalidateData(null);
            TFrame.repaintT(this.tp);
            this.tp.refreshTrackBar();
        }
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    @Override
    protected void setFixedPosition(boolean fixed) {
        if (this.fixedPosition == fixed) {
            return;
        }
        if (this.tp == null) {
            return;
        }
        this.tp.changed = true;
        XMLControlElement control = new XMLControlElement(this);
        if (!fixed) {
            this.fixedPosition = false;
            return;
        }
        int n = this.tp.getFrameNumber();
        this.steps = new TTrack.StepArray(this, this.getStep(n));
        this.erase();
        this.fixedPosition = true;
        this.keyFrames.clear();
        this.keyFrames.add(0);
        Undo.postTrackEdit(this, control);
        this.dataValid = false;
        this.firePropertyChange("steps", null, null);
        this.erase();
        TFrame.repaintT(this.tp);
    }

    @Override
    public void setTrailVisible(boolean visible) {
    }

    @Override
    public Step deleteStep(int n) {
        return null;
    }

    protected Step getKeyStep(Step step) {
        int key = 0;
        if (!this.isFixedPosition()) {
            Iterator iterator = this.keyFrames.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i > step.n) continue;
                key = i;
            }
        }
        return super.getStep(key);
    }

    @Override
    public Step getStep(int n) {
        Step step = this.steps.getStep(n);
        this.refreshStep(step);
        return step;
    }

    protected void setEditing(boolean edit, Step target, final Point pt) {
        this.editing = edit;
        final String rawText = this.inputField.getText();
        if (this.checkKeyFrame()) {
            if (!this.isFixedPosition()) {
                this.keyFrames.add(target.n);
            }
            target = this.getKeyStep(target);
        }
        final Step step = target;
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                InputTrack.this.setEditAction(step, pt, rawText);
            }
        };
        EventQueue.invokeLater(runner);
    }

    protected void stopEditing() {
        if (this.editing) {
            this.setEditing(false, this.getStep(this.tp.getFrameNumber()), null);
        }
    }

    protected void mouseClickedAction(Point pt) {
        if (this.isLocked()) {
            return;
        }
        int n = this.tp.getFrameNumber();
        if (this.ttype == 8) {
            TapeStep step = (TapeStep)this.getStep(n);
            if (step == null) {
                return;
            }
            Rectangle bounds = step.panelLayoutBounds.get(this.tp.getID());
            if (bounds != null && bounds.contains(pt)) {
                if (this.isFullyAttached()) {
                    this.tp.setSelectedTrack(this);
                    return;
                }
                this.setEditing(true, step, pt);
            }
        } else if (this.ttype == 6) {
            ProtractorStep step = (ProtractorStep)this.getStep(n);
            if (step == null) {
                return;
            }
            Rectangle bounds = step.panelLayoutBounds.get(this.tp.getID());
            if (bounds != null && bounds.contains(pt)) {
                if (this.isFullyAttached()) {
                    this.tp.setSelectedTrack(this);
                    return;
                }
                this.setEditing(true, step, pt);
            }
        }
    }

    protected void setMagValue() {
        this.inputField.setValue(this.magField.getValue());
        int n = this.tp.getFrameNumber();
        Step tape = this.getStep(n);
        if (tape != null) {
            tape.repaint();
        }
    }

    @Override
    protected int getAttachmentLength() {
        return this.getFootprintLength();
    }

    @Override
    protected boolean isAutoTrackable(int pointIndex) {
        return this.isAutoTrackable() && pointIndex < this.getAttachmentLength();
    }
}

