/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import org.opensourcephysics.cabrillo.tracker.ArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.DoubleArrowFootprint;
import org.opensourcephysics.cabrillo.tracker.DoubleCrosshairFootprint;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.OutlineFootprint;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.tools.FontSizer;

public class LineFootprint
implements Footprint,
Cloneable {
    private static Shape arrowhead;
    private static Arc2D arc;
    protected static Line2D hitLine;
    protected String name;
    protected MultiShape highlight;
    protected AffineTransform transform = new AffineTransform();
    protected BasicStroke baseStroke = new BasicStroke();
    protected BasicStroke stroke;
    protected Color color = Color.black;
    protected GeneralPath path = new GeneralPath();
    protected Line2D line = new Line2D.Double();
    protected Shape[] hitShapes = new Shape[5];
    protected BasicStroke rotatorStroke;
    private static Collection<LineFootprint> footprints;
    public static final float[] DASHED_LINE;
    public static final float[] DOTTED_LINE;
    public static final float[] WIDE_DOTTED_LINE;
    private static final LineFootprint LINE;
    private static final LineFootprint BOLD_LINE;
    private static final LineFootprint OUTLINE;
    private static final LineFootprint BOLD_OUTLINE;
    private static final LineFootprint DOUBLE_ARROW;
    private static final LineFootprint BOLD_DOUBLE_ARROW;
    private static final ArrowFootprint ARROW;
    private static final ArrowFootprint BOLD_ARROW;
    private static final ArrowFootprint BIG_ARROW;
    private static final ArrowFootprint DASH_ARROW;
    private static final ArrowFootprint BOLD_DASH_ARROW;
    private static final ArrowFootprint BIG_DASH_ARROW;
    private static final DoubleCrosshairFootprint DOUBLE_TARGET;
    private static final DoubleCrosshairFootprint BOLD_DOUBLE_TARGET;

    static {
        arc = new Arc2D.Double(0);
        hitLine = new Line2D.Double();
        GeneralPath path = new GeneralPath();
        path.moveTo(-6.0f, 3.0f);
        path.lineTo(0.0f, 0.0f);
        path.lineTo(-6.0f, -3.0f);
        arrowhead = path;
        footprints = new HashSet<LineFootprint>();
        DASHED_LINE = new float[]{10.0f, 4.0f};
        DOTTED_LINE = new float[]{2.0f, 1.0f};
        WIDE_DOTTED_LINE = new float[]{2.0f, 6.0f};
        LINE = new LineFootprint("Footprint.Line");
        footprints.add(LINE);
        BOLD_LINE = new LineFootprint("Footprint.BoldLine");
        BOLD_LINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_LINE);
        OUTLINE = new OutlineFootprint("Footprint.Outline");
        footprints.add(OUTLINE);
        BOLD_OUTLINE = new OutlineFootprint("Footprint.BoldOutline");
        BOLD_OUTLINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_OUTLINE);
        DOUBLE_ARROW = new DoubleArrowFootprint("Footprint.DoubleArrow");
        footprints.add(DOUBLE_ARROW);
        BOLD_DOUBLE_ARROW = new DoubleArrowFootprint("Footprint.BoldDoubleArrow");
        BOLD_DOUBLE_ARROW.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_DOUBLE_ARROW);
        ARROW = new ArrowFootprint("Footprint.Arrow");
        footprints.add(ARROW);
        BOLD_ARROW = new ArrowFootprint("Footprint.BoldArrow");
        BOLD_ARROW.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_ARROW);
        BIG_ARROW = new ArrowFootprint("Footprint.BigArrow");
        BIG_ARROW.setStroke(new BasicStroke(4.0f));
        BIG_ARROW.setTipLength(32);
        footprints.add(BIG_ARROW);
        DASH_ARROW = new ArrowFootprint("Footprint.DashArrow");
        DASH_ARROW.setDashArray(DASHED_LINE);
        footprints.add(DASH_ARROW);
        BOLD_DASH_ARROW = new ArrowFootprint("Footprint.BoldDashArrow");
        BOLD_DASH_ARROW.setStroke(new BasicStroke(2.0f));
        BOLD_DASH_ARROW.setDashArray(DASHED_LINE);
        footprints.add(BOLD_DASH_ARROW);
        BIG_DASH_ARROW = new ArrowFootprint("Footprint.BigDashArrow");
        BIG_DASH_ARROW.setStroke(new BasicStroke(4.0f));
        BIG_DASH_ARROW.setDashArray(DASHED_LINE);
        BIG_DASH_ARROW.setTipLength(32);
        footprints.add(BIG_DASH_ARROW);
        DOUBLE_TARGET = new DoubleCrosshairFootprint("Footprint.DoubleTarget");
        footprints.add(DOUBLE_TARGET);
        BOLD_DOUBLE_TARGET = new DoubleCrosshairFootprint("Footprint.BoldDoubleTarget");
        BOLD_DOUBLE_TARGET.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_DOUBLE_TARGET);
    }

    public LineFootprint(String name) {
        this.name = name;
    }

    public static Footprint getFootprint(String name) {
        return LineFootprint.getFootprint(footprints, name);
    }

    protected static Footprint getFootprint(Collection<LineFootprint> footprints, String name) {
        for (LineFootprint footprint : footprints) {
            if (name != footprint.getName()) continue;
            try {
                return (LineFootprint)footprint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public ResizableIcon getIcon(int w, int h) {
        Point[] points = new Point[]{new Point(), new Point(w - 2, 2 - h)};
        MultiShape shape = this.getShape(points, 1);
        ShapeIcon icon = new ShapeIcon(shape, w, h);
        icon.setColor(this.color);
        icon.setStroke(this.stroke);
        return new ResizableIcon(icon);
    }

    @Override
    public Mark getMark(Point[] points) {
        final MultiShape shape = this.getShape(points, FontSizer.getIntegerFactor());
        final MultiShape hilite = this.getHighlightShape();
        return new Mark(){

            @Override
            public void draw(Graphics2D g, boolean highlighted) {
                Color gcolor = g.getColor();
                Stroke gstroke = g.getStroke();
                g.setColor(LineFootprint.this.color);
                g.setStroke(LineFootprint.this.stroke);
                if (OSPRuntime.setRenderingHints) {
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                shape.draw(g);
                if (highlighted && hilite != null) {
                    hilite.draw(g);
                }
                g.setColor(gcolor);
                g.setStroke(gstroke);
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes;
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        if (stroke == null) {
            return;
        }
        this.baseStroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 8.0f, stroke.getDashArray(), stroke.getDashPhase());
    }

    @Override
    public BasicStroke getStroke() {
        return this.baseStroke;
    }

    public void setDashArray(float[] dashArray) {
        this.baseStroke = new BasicStroke(this.baseStroke.getLineWidth(), 0, 0, 8.0f, dashArray, this.baseStroke.getDashPhase());
    }

    public void setLineWidth(double w) {
        this.baseStroke = new BasicStroke((float)w, 0, 0, 8.0f, this.baseStroke.getDashArray(), this.baseStroke.getDashPhase());
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiShape getShape(Point[] points, int scale) {
        this.checkStrokes();
        float lineWidth = this.stroke.getLineWidth();
        Point p1 = points[0];
        Point p2 = points[1];
        double theta = Math.atan2(p1.y - p2.y, p1.x - p2.x);
        this.transform.setToRotation(theta, p2.x, p2.y);
        this.transform.translate(p2.x, p2.y);
        double d = p1.distance(p2);
        this.hitShapes[0] = new Rectangle(p1.x - 1, p1.y - 1, 2, 2);
        this.hitShapes[1] = new Rectangle(p2.x - 1, p2.y - 1, 2, 2);
        this.line.setLine(p1, p2);
        double center = d / 2.0;
        hitLine.setLine(center - 0.3 * d, 0.0, center + 0.3 * d, 0.0);
        this.hitShapes[2] = this.transform.createTransformedShape(hitLine);
        hitLine.setLine(center + 0.35 * d, 0.0, center + 0.45 * d, 0.0);
        this.hitShapes[3] = this.transform.createTransformedShape(hitLine);
        hitLine.setLine(center - 0.45 * d, 0.0, center - 0.35 * d, 0.0);
        this.hitShapes[4] = this.transform.createTransformedShape(hitLine);
        GeneralPath generalPath = this.path;
        synchronized (generalPath) {
            this.path.reset();
            this.path.moveTo(0.0, 0.5 * (double)lineWidth);
            this.path.lineTo(d, 0.5 * (double)lineWidth);
            this.path.lineTo(d, -0.5 * (double)lineWidth);
            this.path.lineTo(0.0, -0.5 * (double)lineWidth);
            this.path.closePath();
        }
        return new MultiShape(this.transform.createTransformedShape(this.path)).andFill(true);
    }

    public MultiShape getHighlightShape() {
        if (this.highlight != null) {
            return new MultiShape(this.highlight);
        }
        return null;
    }

    public MultiShape getRotatorShape(Point center, Point anchor, Point rotator) {
        if (rotator == null) {
            int scale = FontSizer.getIntegerFactor();
            double r = 15 * scale;
            double ang = 50.0;
            double arrowAngleOffset = 10.0;
            double d = center.distance(anchor);
            double sin = (double)(-(anchor.y - center.y)) / d;
            double cos = (double)(anchor.x - center.x) / d;
            double theta = 180.0 * Math.atan2(sin, cos) / Math.PI;
            arc.setArcByCenter((double)anchor.x - r * cos, (double)anchor.y + r * sin, r, theta - ang, 2.0 * ang, 0);
            MultiShape toDraw = new MultiShape(arc).andStroke(this.stroke);
            Point2D pt = arc.getEndPoint();
            double rotationAngle = Math.PI * (theta + ang - arrowAngleOffset) / 180.0 + 1.5707963267948966;
            this.transform.setToRotation(-rotationAngle, pt.getX(), pt.getY());
            this.transform.translate(pt.getX(), pt.getY());
            if (scale > 1) {
                this.transform.scale(scale, scale);
            }
            toDraw.addDrawShape(this.transform.createTransformedShape(arrowhead), this.stroke);
            pt = arc.getStartPoint();
            rotationAngle = Math.PI * (theta - ang + arrowAngleOffset) / 180.0 - 1.5707963267948966;
            this.transform.setToRotation(-rotationAngle, pt.getX(), pt.getY());
            this.transform.translate(pt.getX(), pt.getY());
            if (scale > 1) {
                this.transform.scale(scale, scale);
            }
            toDraw.addDrawShape(this.transform.createTransformedShape(arrowhead), this.stroke);
            return toDraw;
        }
        if (rotator.distanceSq(center) > anchor.distanceSq(center)) {
            Line2D.Double line = new Line2D.Double(anchor.x, anchor.y, rotator.x, rotator.y);
            return new MultiShape(line).andStroke(this.rotatorStroke);
        }
        return null;
    }

    protected void checkStrokes() {
        int scale = FontSizer.getIntegerFactor();
        if (this.stroke == null || this.stroke.getLineWidth() != (float)scale * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)scale * this.baseStroke.getLineWidth());
            this.rotatorStroke = new BasicStroke(this.stroke.getLineWidth(), 0, 0, 8.0f, WIDE_DOTTED_LINE, this.stroke.getDashPhase());
        }
    }
}

