/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javajs.async.AsyncDialog;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.LineProfileStep;
import org.opensourcephysics.cabrillo.tracker.MarkingRequired;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class LineProfile
extends TTrack
implements MarkingRequired {
    public static final int MAX_SPREAD = 100;
    protected static final String[] dataVariables = new String[]{"n", "x", "y", "R", "G", "B", "luma", "pixels"};
    protected static final String[] fieldVariables = new String[0];
    protected static final String[] formatVariables = new String[]{"t", "xy", "RGB", "luma"};
    protected static final Map<String, String[]> formatMap = new HashMap<String, String[]>();
    protected static final Map<String, String> formatDescriptionMap;
    protected static final ArrayList<String> allVariables;
    protected boolean fixedLine = true;
    protected JCheckBoxMenuItem fixedLineItem;
    protected JMenu orientationMenu;
    protected JMenuItem horizOrientationItem;
    protected JMenuItem xaxisOrientationItem;
    protected int spread = 0;
    protected JLabel spreadLabel;
    protected IntegerField spreadField;
    protected boolean isHorizontal = true;
    protected boolean loading;
    protected boolean showTimeData = false;
    protected int datasetIndex = -1;
    protected JLabel unmarkedLabel;
    private boolean updating;

    static {
        formatMap.put("t", new String[]{"t"});
        formatMap.put("xy", new String[]{"x", "y"});
        formatMap.put("RGB", new String[]{"R", "G", "B"});
        formatMap.put("luma", new String[]{"luma"});
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("PointMass.Data.Description.0"));
        formatDescriptionMap.put(formatVariables[1], TrackerRes.getString("PointMass.Position.Name"));
        formatDescriptionMap.put(formatVariables[2], TrackerRes.getString("LineProfile.Description.RGB"));
        formatDescriptionMap.put(formatVariables[3], TrackerRes.getString("LineProfile.Data.Brightness"));
        allVariables = LineProfile.createAllVariables(dataVariables, null);
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "LineProfile";
    }

    @Override
    public String getVarDimsImpl(String variable) {
        String[] vars = dataVariables;
        String[] names = formatVariables;
        if (vars[0].equals(variable) || vars[7].equals(variable)) {
            return "I";
        }
        if (names[0].equals(variable) || vars[1].equals(variable) || vars[2].equals(variable)) {
            return "L";
        }
        if (names[1].equals(variable) || names[2].equals(variable) || vars[3].equals(variable) || vars[4].equals(variable) || vars[5].equals(variable) || vars[6].equals(variable)) {
            return "C";
        }
        return null;
    }

    public LineProfile() {
        super(3);
        this.defaultColors = new Color[]{Color.magenta};
        this.setName(TrackerRes.getString("LineProfile.New.Name"));
        this.setProperty("highlights", "false");
        this.setProperty("xVarPlot0", dataVariables[1]);
        this.setProperty("yVarPlot0", dataVariables[6]);
        this.setProperty("pointsPlot0", "false");
        this.setProperty("yMinPlot0", 0.0);
        this.setProperty("yMaxPlot0", 255.0);
        this.setProperty("tableVar0", "0");
        this.setProperty("tableVar1", "1");
        this.setProperty("tableVar2", "5");
        this.setFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.Outline"), LineFootprint.getFootprint("Footprint.BoldOutline")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("LineProfile.Unmarked.Hint");
        this.spreadLabel = new JLabel();
        Border empty = BorderFactory.createEmptyBorder(0, 4, 0, 2);
        this.spreadLabel.setBorder(empty);
        this.spreadField = new IntegerField(3);
        this.spreadField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineProfile.this.setSpread(LineProfile.this.spreadField.getIntValue());
                LineProfile.this.spreadField.setIntValue(LineProfile.this.getSpread());
                LineProfile.this.spreadField.selectAll();
                LineProfile.this.spreadField.requestFocusInWindow();
                LineProfile.this.firePropertyChange("data", null, LineProfile.this);
            }
        });
        this.spreadField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                LineProfile.this.spreadField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                LineProfile.this.setSpread(LineProfile.this.spreadField.getIntValue());
                LineProfile.this.spreadField.setIntValue(LineProfile.this.getSpread());
                LineProfile.this.firePropertyChange("data", null, LineProfile.this);
            }
        });
        this.spreadField.setBorder(this.fieldBorder);
        this.spreadField.addMouseListener(this.formatMouseListener);
        this.fixedLineItem = new JCheckBoxMenuItem(TrackerRes.getString("LineProfile.MenuItem.Fixed"));
        this.fixedLineItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                LineProfile.this.setFixed(LineProfile.this.fixedLineItem.isSelected());
            }
        });
        this.orientationMenu = new JMenu(TrackerRes.getString("LineProfile.Menu.Orientation"));
        ButtonGroup group = new ButtonGroup();
        this.horizOrientationItem = new JRadioButtonMenuItem(TrackerRes.getString("LineProfile.MenuItem.Horizontal"));
        this.horizOrientationItem.setSelected(true);
        this.horizOrientationItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (LineProfile.this.tp == null) {
                    return;
                }
                XMLControlElement control = new XMLControlElement(LineProfile.this);
                LineProfile.this.isHorizontal = LineProfile.this.horizOrientationItem.isSelected();
                if (!LineProfile.this.steps.isEmpty()) {
                    int n = LineProfile.this.tp.getFrameNumber();
                    LineProfileStep step = (LineProfileStep)LineProfile.this.steps.getStep(n);
                    LineProfile.this.refreshStep(step);
                    TFrame.repaintT(LineProfile.this.tp);
                    if (!LineProfile.this.loading) {
                        Undo.postTrackEdit(LineProfile.this, control);
                    }
                }
                LineProfile.this.tp.getToolBar(true).refresh("LineProfile");
                LineProfile.this.invalidateData(null);
            }
        });
        this.orientationMenu.add(this.horizOrientationItem);
        group.add(this.horizOrientationItem);
        this.xaxisOrientationItem = new JRadioButtonMenuItem(TrackerRes.getString("LineProfile.MenuItem.XAxis"));
        this.orientationMenu.add(this.xaxisOrientationItem);
        group.add(this.xaxisOrientationItem);
        this.unmarkedLabel = new JLabel();
        this.unmarkedLabel.setForeground(Color.red.darker());
    }

    public void setFixed(boolean fixed) {
        if (fixed == this.fixedLine) {
            return;
        }
        ArrayList<TableTrackView> tableViews = this.getTableViews();
        if (this.fixedLine && !fixed) {
            boolean hasTimeView = false;
            int i = 0;
            while (i < tableViews.size()) {
                hasTimeView = hasTimeView || tableViews.get((int)i).myDatasetIndex > -1;
                ++i;
            }
            if (hasTimeView) {
                boolean[] ok = new boolean[]{true};
                new AsyncDialog().showConfirmDialog(null, String.valueOf(TrackerRes.getString("TableTrackView.Dialog.TimeDataUnsupported.Message1")) + "\n" + TrackerRes.getString("TableTrackView.Dialog.TimeDataUnsupported.Message2"), TrackerRes.getString("TableTrackView.Dialog.TimeDataUnsupported.Title"), 0, ev -> {
                    int sel = ev.getID();
                    switch (sel) {
                        case 0: {
                            int i = 0;
                            while (i < tableViews.size()) {
                                if (((TableTrackView)arrayList.get((int)i)).myDatasetIndex > -1) {
                                    ((TableTrackView)arrayList.get((int)i)).multiframeCheckbox.doClick(0);
                                }
                                ++i;
                            }
                            break;
                        }
                        case 1: {
                            blArray[0] = false;
                        }
                    }
                });
                if (!ok[0]) {
                    return;
                }
            }
        }
        if (this.steps.isEmpty()) {
            this.fixedLine = fixed;
        } else {
            XMLControlElement control = new XMLControlElement(this);
            this.fixedLine = fixed;
            if (this.tp != null) {
                this.tp.changed = true;
                int n = this.tp.getFrameNumber();
                Step step = this.getStep(n);
                if (step != null) {
                    this.steps = new TTrack.StepArray(this, this.getStep(n));
                    TFrame.repaintT(this.tp);
                }
            }
            if (fixed) {
                this.keyFrames.clear();
                this.keyFrames.add(0);
            }
            if (!this.loading) {
                Undo.postTrackEdit(this, control);
            }
            this.repaint();
        }
        int i = 0;
        while (i < tableViews.size()) {
            tableViews.get(i).refreshGUI();
            ++i;
        }
    }

    public boolean isFixed() {
        return this.fixedLine;
    }

    public void setSpread(int spread) {
        if (this.isLocked() || this.spread == spread) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        spread = Math.max(spread, 0);
        this.spread = Math.min(spread, 100);
        if (!this.loading) {
            Undo.postTrackEdit(this, control);
        }
        this.clearStepData();
        this.repaint();
        this.invalidateData(Boolean.FALSE);
        if (this.tp != null) {
            this.firePropertyChange("step", null, this.tp.getFrameNumber());
        }
    }

    public int getSpread() {
        return this.spread;
    }

    @Override
    public boolean isMarkByDefault() {
        return this.requiresMarking() || super.isMarkByDefault();
    }

    @Override
    public boolean requiresMarking() {
        return this.getStep(0) == null;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        super.draw(panel, _g);
    }

    @Override
    public void setTrailVisible(boolean visible) {
    }

    @Override
    public Step createStep(int n, double x, double y) {
        return this.createStep(n, x, y, x, y);
    }

    public Step createStep(int n, double x1, double y1, double x2, double y2) {
        if (this.isLocked()) {
            return null;
        }
        int frame = this.isFixed() ? 0 : n;
        LineProfileStep step = (LineProfileStep)this.steps.getStep(frame);
        if (step == null) {
            this.keyFrames.add(0);
            double xx = x2;
            double yy = y2;
            if (x1 == x2 && y1 == y2) {
                if (this.tp != null) {
                    double theta = -this.tp.getCoords().getAngle(n);
                    if (this.isHorizontal) {
                        theta = 0.0;
                    }
                    xx = x1 + 50.0 * Math.cos(theta);
                    yy = y1 + 50.0 * Math.sin(theta);
                } else {
                    xx = x1 + 50.0;
                }
            }
            step = new LineProfileStep(this, 0, x1, y1, xx, yy);
            step.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, step);
            if (x1 == x2 && y1 == y2) {
                step = (LineProfileStep)this.getStep(frame);
                step.getLineEnd1().setLocation(x2, y2);
                if (this.tp != null) {
                    step = (LineProfileStep)this.getStep(n);
                    step.getLineEnd0().setTrackEditTrigger(false);
                    this.tp.setSelectedPoint(step.getDefaultPoint());
                }
            }
        } else {
            this.keyFrames.add(frame);
            step.getLineEnd0().setLocation(x1, y1);
            step.getLineEnd1().setLocation(x2, y2);
        }
        return this.getStep(n);
    }

    @Override
    public Step deleteStep(int n) {
        return null;
    }

    @Override
    public Step getStep(int n) {
        LineProfileStep step = (LineProfileStep)this.steps.getStep(n);
        this.refreshStep(step);
        return step;
    }

    @Override
    public boolean isStepComplete(int n) {
        return this.getStep(n) != null;
    }

    @Override
    public int getStepLength() {
        return LineProfileStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 2;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof TrackerPanel) || !this.isVisible() || this.isLocked()) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Interactive ia = null;
        int n = trackerPanel.getFrameNumber();
        Step step = this.getStep(n);
        if (step != null && trackerPanel.getPlayer().getVideoClip().includesFrame(n)) {
            ia = step.findInteractive(trackerPanel, xpix, ypix);
        }
        if (ia == null) {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = step == null ? TrackerRes.getString("LineProfile.Unmarked.Hint") : TrackerRes.getString("LineProfile.Hint");
            if (trackerPanel.getVideo() == null) {
                this.hint = String.valueOf(this.hint) + ", " + TrackerRes.getString("TTrack.ImportVideo.Hint");
            }
            return null;
        }
        if (ia instanceof LineProfileStep.LineEnd) {
            this.partName = TrackerRes.getString("LineProfile.End.Name");
            this.hint = TrackerRes.getString("LineProfile.End.Hint");
        } else if (ia instanceof LineProfileStep.Handle) {
            this.partName = TrackerRes.getString("LineProfile.Handle.Name");
            this.hint = TrackerRes.getString("LineProfile.Handle.Hint");
        }
        return ia;
    }

    @Override
    protected void refreshData(DatasetManager data, TrackerPanel trackerPanel) {
        double[][] validData;
        if (this.refreshDataLater || trackerPanel == null || data == null) {
            return;
        }
        if (this.isMultipleFrames()) {
            this.refreshMultiFrameData(data, trackerPanel);
            return;
        }
        int count = 7;
        Video video2 = trackerPanel.getVideo();
        if (video2 == null || !video2.isVisible()) {
            validData = new double[count + 1][0];
        } else {
            LineProfileStep step = (LineProfileStep)this.getStep(trackerPanel.getPlayer().getFrameNumber());
            if (step == null || (validData = step.getProfileData(trackerPanel)) == null) {
                if (step != null) {
                    LineProfile.delayedUpdate(trackerPanel, this, video2);
                }
                validData = new double[count + 1][0];
            }
        }
        this.clearColumns(data, count, dataVariables, "LineProfile.Data.Description.", validData, validData[0].length);
    }

    private static void delayedUpdate(TrackerPanel panel, LineProfile profile, Video video2) {
        if (!profile.updating) {
            profile.updating = true;
            SwingUtilities.invokeLater(() -> {
                video2.invalidateVideoAndFilter();
                profile.invalidateData(null);
                panel.refreshTrackData(0);
                lineProfile.updating = false;
            });
        }
    }

    @Override
    protected void clearColumns(DatasetManager data, int count, String[] dataVariables, String desc, double[][] validData, int len) {
        int i;
        int i2;
        String v0 = dataVariables[0];
        if (data.getDataset(0).getColumnName(0).equals(v0) && data.getDataset(0).getColumnName(1).equals(dataVariables[1]) && data.getDatasetsRaw().size() == count) {
            i2 = 0;
            while (i2 < count) {
                data.clear(i2);
                ++i2;
            }
        } else {
            int n = data.getDatasetsRaw().size();
            i = n - 1;
            while (i >= count) {
                if (data.getDataset(i).getClass() == Dataset.class) {
                    data.removeDataset(i);
                }
                --i;
            }
            i = 0;
            while (i < count) {
                data.clear(i);
                if (data.getDataset(i).getClass() == Dataset.class) {
                    data.setXYColumnNames(i, v0, dataVariables[i + 1]);
                }
                ++i;
            }
        }
        this.dataDescriptions = new String[count + 1];
        if (this.isMultipleFrames()) {
            this.dataDescriptions[0] = TrackerRes.getString(String.valueOf(desc) + "0");
            i2 = 1;
            while (i2 <= count) {
                this.dataDescriptions[i2] = TrackerRes.getString(String.valueOf(desc) + (this.datasetIndex + 1));
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 <= count) {
                this.dataDescriptions[i2] = TrackerRes.getString(String.valueOf(desc) + i2);
                ++i2;
            }
        }
        if (validData != null) {
            double[] t = validData[count];
            i = 0;
            while (i < count) {
                data.getDataset(i).append(t, validData[i], len);
                ++i;
            }
        }
    }

    private void refreshMultiFrameData(DatasetManager data, TrackerPanel trackerPanel) {
        double[][] validData;
        int count = 0;
        ArrayList<double[]> collectedData = new ArrayList<double[]>();
        ArrayList<Double> times = new ArrayList<Double>();
        ArrayList<Integer> frames = new ArrayList<Integer>();
        String[] varNames = new String[]{"n", "empty"};
        if (trackerPanel.getVideo() == null || !trackerPanel.getVideo().isVisible()) {
            validData = new double[count + 1][0];
        } else {
            VideoPlayer player = trackerPanel.getPlayer();
            VideoClip clip = player.getVideoClip();
            Step[] stepArray = this.getSteps();
            if (stepArray.length < trackerPanel.getFrameNumber()) {
                this.steps.setLength(trackerPanel.getFrameNumber() + 1);
                stepArray = this.getSteps();
            }
            int k = 0;
            int i = 0;
            while (i < stepArray.length) {
                double[][] next;
                LineProfileStep step = (LineProfileStep)stepArray[i];
                if (step != null && clip.includesFrame(step.n) && (next = step.getProfileData(trackerPanel)) != null && next.length > this.datasetIndex) {
                    collectedData.add(next[this.datasetIndex]);
                    if (k == 0) {
                        k = next[0].length;
                        count = next[this.datasetIndex].length;
                    } else {
                        count = Math.max(count, next[this.datasetIndex].length);
                    }
                    int stepNumber = clip.frameToStep(i);
                    double t = player.getStepTime(stepNumber) / 1000.0;
                    times.add(t);
                    frames.add(i);
                }
                ++i;
            }
            if (collectedData.size() > 0) {
                double[][] orig = (double[][])collectedData.toArray((T[])new double[collectedData.size()][count]);
                int rows = count;
                int cols = orig.length;
                validData = new double[cols + 1][rows];
                varNames = new String[cols + 1];
                varNames[0] = "n";
                int col = 0;
                while (col < cols) {
                    varNames[col + 1] = String.valueOf(dataVariables[this.datasetIndex + 1]) + "_{ " + frames.get(col) + "}";
                    int row = 0;
                    while (row < rows) {
                        double d = validData[col][row] = row < orig[col].length ? orig[col][row] : Double.NaN;
                        if (col == 0) {
                            validData[cols][row] = row;
                        }
                        ++row;
                    }
                    ++col;
                }
                count = cols;
            } else {
                validData = new double[count + 1][0];
            }
        }
        this.clearColumns(data, count, varNames, "LineProfile.Data.Description.", validData, validData[0].length);
    }

    @Override
    public DatasetManager getData(TrackerPanel panel, int datasetIndex) {
        this.setDatasetIndex(datasetIndex);
        return this.getData(panel);
    }

    protected void setDatasetIndex(int index) {
        if (index == this.datasetIndex) {
            return;
        }
        this.datasetIndex = index;
        this.invalidateData(Boolean.FALSE);
    }

    protected boolean isMultipleFrames() {
        return this.datasetIndex >= 0;
    }

    protected void clearStepData() {
        Step[] steps = this.getSteps();
        int i = 0;
        while (i < steps.length) {
            LineProfileStep step = (LineProfileStep)steps[i];
            if (step != null) {
                step.clearData();
            }
            ++i;
        }
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.fixedLineItem.setText(TrackerRes.getString("LineProfile.MenuItem.Fixed"));
        this.fixedLineItem.setSelected(this.isFixed());
        menu.remove(this.deleteTrackItem);
        TMenuBar.checkAddMenuSep(menu);
        menu.add(this.orientationMenu);
        menu.addSeparator();
        menu.add(this.fixedLineItem);
        if (trackerPanel.isEnabled("track.delete")) {
            TMenuBar.checkAddMenuSep(menu);
            menu.add(this.deleteTrackItem);
        }
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        this.spreadLabel.setText(TrackerRes.getString("LineProfile.Label.Spread"));
        list.add(this.spreadLabel);
        this.spreadField.setIntValue(this.getSpread());
        this.spreadField.setEnabled(!this.isLocked());
        list.add(this.spreadField);
        if (this.getStep(0) == null) {
            list.add(this.stepSeparator);
            this.unmarkedLabel.setText(TrackerRes.getString("LineProfile.Unmarked.Hint"));
            list.add(this.unmarkedLabel);
        }
        return list;
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        Object[] objectsToSize = new Object[]{this.unmarkedLabel, this.spreadLabel};
        FontSizer.setFonts(objectsToSize, level);
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("image", this);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("image", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        block17: {
            if (this.tp == null) break block17;
            switch (e.getPropertyName()) {
                case "stepnumber": {
                    this.invalidateData(Boolean.FALSE);
                    break;
                }
                case "image": {
                    this.clearStepData();
                    this.invalidateData(Boolean.FALSE);
                    this.firePropertyChange(e);
                    break;
                }
                case "transform": {
                    if (this.steps.isEmpty()) break;
                    int n = this.tp.getFrameNumber();
                    LineProfileStep step = (LineProfileStep)this.steps.getStep(n);
                    if (e.getNewValue() == null) {
                        int i = 0;
                        while (i < this.getSteps().length) {
                            if (this.getSteps()[i] != null) {
                                ((LineProfileStep)this.getSteps()[i]).clearData();
                            }
                            ++i;
                        }
                    } else {
                        step.clearData();
                    }
                    this.refreshStep(step);
                }
            }
        }
        super.propertyChange(e);
    }

    @Override
    public String toString() {
        return TrackerRes.getString("LineProfile.Name");
    }

    protected void refreshStep(LineProfileStep step) {
        boolean different;
        if (step == null) {
            return;
        }
        int key = 0;
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i > step.n) continue;
            key = i;
        }
        LineProfileStep keyStep = (LineProfileStep)this.steps.getStep(key);
        boolean bl = different = keyStep.getLineEnd0().getX() != step.getLineEnd0().getX() || keyStep.getLineEnd0().getY() != step.getLineEnd0().getY() || keyStep.getLineEnd1().getX() != step.getLineEnd1().getX() || keyStep.getLineEnd1().getY() != step.getLineEnd1().getY();
        if (different) {
            step.getLineEnd0().setLocation(keyStep.getLineEnd0());
            step.getLineEnd1().setLocation(keyStep.getLineEnd1());
            step.getHandle().setLocation(keyStep.getHandle());
            step.erase();
        }
        step.getLineEnd0().setTrackEditTrigger(true);
        step.rotate();
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private static class FrameData {
        double[] data = new double[4];

        FrameData() {
        }

        FrameData(LineProfileStep step) {
            this.data[0] = step.getLineEnd0().x;
            this.data[1] = step.getLineEnd0().y;
            this.data[2] = step.getLineEnd1().x;
            this.data[3] = step.getLineEnd1().y;
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            control.setValue("x1", data.data[0]);
            control.setValue("y1", data.data[1]);
            control.setValue("x2", data.data[2]);
            control.setValue("y2", data.data[3]);
        }

        @Override
        public Object createObject(XMLControl control) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            FrameData data = (FrameData)obj;
            if (control.getPropertyNamesRaw().contains("x1")) {
                data.data[0] = control.getDouble("x1");
                data.data[1] = control.getDouble("y1");
                data.data[2] = control.getDouble("x2");
                data.data[3] = control.getDouble("y2");
            }
            return obj;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            LineProfile profile = (LineProfile)obj;
            XML.getLoader(TTrack.class).saveObject(control, obj);
            control.setValue("spread", profile.getSpread());
            control.setValue("fixed", profile.isFixed());
            Step[] steps = profile.getSteps();
            int count = steps.length;
            if (profile.isFixed()) {
                count = 1;
            }
            FrameData[] data = new FrameData[count];
            int n = 0;
            while (n < count) {
                if (steps[n] != null && profile.keyFrames.contains(n)) {
                    data[n] = new FrameData((LineProfileStep)steps[n]);
                }
                ++n;
            }
            control.setValue("framedata", data);
            control.setValue("horizontal", profile.isHorizontal);
        }

        @Override
        public Object createObject(XMLControl control) {
            LineProfile profile = new LineProfile();
            return profile;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            LineProfile profile = (LineProfile)obj;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            boolean locked = profile.isLocked();
            profile.setLocked(false);
            profile.loading = true;
            if (control.getPropertyNamesRaw().contains("horizontal")) {
                profile.isHorizontal = control.getBoolean("horizontal");
            } else {
                boolean bl = profile.isHorizontal = !control.getBoolean("rotates");
            }
            if (profile.isHorizontal) {
                profile.horizOrientationItem.setSelected(true);
            } else {
                profile.xaxisOrientationItem.setSelected(true);
            }
            int i = control.getInt("spread");
            if (i != Integer.MIN_VALUE) {
                profile.setSpread(i);
            }
            if (control.getPropertyNamesRaw().contains("fixed")) {
                profile.fixedLine = control.getBoolean("fixed");
            }
            profile.keyFrames.clear();
            FrameData[] data = (FrameData[])control.getObject("framedata");
            if (data != null && data.length > 0) {
                if (profile.fixedLine && data[0] != null) {
                    profile.createStep(0, data[0].data[0], data[0].data[1], data[0].data[2], data[0].data[3]);
                } else {
                    int n = 0;
                    while (n < data.length) {
                        if (data[n] != null) {
                            profile.createStep(n, data[n].data[0], data[n].data[1], data[n].data[2], data[n].data[3]);
                        }
                        ++n;
                    }
                }
            }
            profile.spreadField.setIntValue(profile.getSpread());
            profile.setLocked(locked);
            profile.loading = false;
            profile.repaint();
            return obj;
        }
    }
}

