/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineProfile;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MultiShape;
import org.opensourcephysics.cabrillo.tracker.OutlineFootprint;
import org.opensourcephysics.cabrillo.tracker.RGBRegion;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class LineProfileStep
extends Step {
    static TPoint center = new TPoint();
    protected TPoint lineEnd0;
    protected TPoint lineEnd1;
    protected Handle handle;
    protected boolean endsEnabled = true;
    protected Map<Integer, Shape> panelEnd0Shapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelEnd1Shapes = new HashMap<Integer, Shape>();
    protected Map<Integer, Shape> panelShaftShapes = new HashMap<Integer, Shape>();
    protected LineProfile line;
    protected Corner[][] corners;
    protected GridIntersection[] endX;
    protected GridIntersection[] endY;
    protected GridIntersection[][] sweepX;
    protected GridIntersection[][] sweepY;
    protected TreeSet<Intersection> sorter = new TreeSet();
    protected ArrayList<GridVertex> vertices = new ArrayList();
    private double sin;
    private double cos;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private TreeSet<GridSegment> xSegments = new TreeSet();
    private TreeSet<GridSegment> ySegments = new TreeSet();
    private int leadingIndex;
    private Intersection[] polygon = new Intersection[8];
    private Point polyLoc = new Point();
    private double[] quadAreas = new double[4];
    private double[][] profileData;

    public LineProfileStep(LineProfile track, int n, double x1, double y1, double x2, double y2) {
        super(track, n);
        this.line = track;
        this.lineEnd0 = new LineEnd(x1, y1);
        this.lineEnd0.setTrackEditTrigger(false);
        this.lineEnd1 = new LineEnd(x2, y2);
        this.handle = new Handle((x1 + x2) / 2.0, (y1 + y2) / 2.0);
        this.points = new TPoint[]{this.lineEnd0, this.lineEnd1, this.handle};
        this.screenPoints = new Point[LineProfileStep.getLength()];
        this.corners = new Corner[2][2];
        this.endX = new GridIntersection[2];
        this.endY = new GridIntersection[2];
        int i = 0;
        while (i < 2) {
            this.corners[0][i] = new Corner();
            this.corners[1][i] = new Corner();
            this.endX[i] = new GridIntersection(0.0, 0.0, true);
            this.endY[i] = new GridIntersection(0.0, 0.0, false);
            ++i;
        }
    }

    public TPoint getLineEnd0() {
        return this.lineEnd0;
    }

    public TPoint getLineEnd1() {
        return this.lineEnd1;
    }

    public TPoint getHandle() {
        return this.handle;
    }

    public void setEndsEnabled(boolean enabled) {
        this.endsEnabled = enabled;
    }

    public boolean isEndsEnabled() {
        return this.endsEnabled;
    }

    @Override
    public void setFootprint(Footprint footprint) {
        if (footprint.getLength() >= 2) {
            super.setFootprint(footprint);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        Shape hitShape;
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        this.setHitRectCenter(xpix, ypix);
        if (this.endsEnabled) {
            hitShape = this.panelEnd0Shapes.get(trackerPanel.getID());
            if (hitShape != null && hitShape.intersects(hitRect)) {
                return this.lineEnd0;
            }
            hitShape = this.panelEnd1Shapes.get(trackerPanel.getID());
            if (hitShape != null && hitShape.intersects(hitRect)) {
                return this.lineEnd1;
            }
        }
        if ((hitShape = this.panelShaftShapes.get(trackerPanel.getID())) != null && hitShape.intersects(hitRect)) {
            return this.handle;
        }
        return null;
    }

    @Override
    public void draw(DrawingPanel panel, Graphics _g) {
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Graphics2D g = (Graphics2D)_g;
        this.getMark(trackerPanel).draw(g, false);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        TPoint selection = null;
        if (mark == null) {
            if (this.footprint instanceof OutlineFootprint) {
                OutlineFootprint outline = (OutlineFootprint)this.footprint;
                LineProfile profile = (LineProfile)this.getTrack();
                int spread = profile.getSpread();
                double factor = trackerPanel.getXPixPerUnit();
                if (!trackerPanel.isDrawingInImageSpace()) {
                    int n = trackerPanel.getFrameNumber();
                    factor /= trackerPanel.getCoords().getScaleX(n);
                }
                int i = (int)(factor * (0.5 + (double)spread));
                outline.setSpread(i);
            }
            selection = trackerPanel.getSelectedPoint();
            int pointNumber = 0;
            Point p = null;
            Shape s = null;
            int i = 0;
            while (i < this.points.length) {
                this.screenPoints[i] = this.points[i].getScreenPosition(trackerPanel);
                if (selection == this.points[i]) {
                    p = this.screenPoints[i];
                    pointNumber = i;
                }
                ++i;
            }
            mark = this.footprint.getMark(this.screenPoints);
            if (p != null) {
                transform.setToTranslation(p.x, p.y);
                int scale = FontSizer.getIntegerFactor();
                if (scale > 1) {
                    transform.scale(scale, scale);
                }
                s = transform.createTransformedShape(selectionShape);
                final Color color = this.footprint.getColor();
                final Mark stepMark = mark;
                final MultiShape selectedShape = new MultiShape(s).andStroke(selectionStroke);
                mark = new Mark(){

                    @Override
                    public void draw(Graphics2D g, boolean highlighted) {
                        stepMark.draw(g, false);
                        Paint gpaint = g.getPaint();
                        g.setPaint(color);
                        selectedShape.draw(g);
                        g.setPaint(gpaint);
                    }
                };
            }
            this.panelMarks.put(trackerPanel.getID(), mark);
            Shape[] shapes = this.footprint.getHitShapes();
            this.panelEnd0Shapes.put(trackerPanel.getID(), shapes[0]);
            this.panelEnd1Shapes.put(trackerPanel.getID(), shapes[1]);
            if (s != null && pointNumber == 2) {
                this.panelShaftShapes.put(trackerPanel.getID(), s);
            } else {
                this.panelShaftShapes.put(trackerPanel.getID(), shapes[2]);
            }
        }
        return mark;
    }

    @Override
    public Object clone() {
        LineProfileStep step = (LineProfileStep)super.clone();
        if (step != null) {
            step.profileData = null;
            TPoint[] tPointArray = step.points;
            LineProfileStep lineProfileStep = step;
            lineProfileStep.getClass();
            tPointArray[0] = step.lineEnd0 = lineProfileStep.new LineEnd(this.lineEnd0.getX(), this.lineEnd0.getY());
            TPoint[] tPointArray2 = step.points;
            LineProfileStep lineProfileStep2 = step;
            lineProfileStep2.getClass();
            tPointArray2[1] = step.lineEnd1 = lineProfileStep2.new LineEnd(this.lineEnd1.getX(), this.lineEnd1.getY());
            TPoint[] tPointArray3 = step.points;
            LineProfileStep lineProfileStep3 = step;
            lineProfileStep3.getClass();
            step.handle = lineProfileStep3.new Handle(this.handle.getX(), this.handle.getY());
            tPointArray3[2] = step.handle;
            step.panelEnd0Shapes = new HashMap<Integer, Shape>();
            step.panelEnd1Shapes = new HashMap<Integer, Shape>();
            step.panelShaftShapes = new HashMap<Integer, Shape>();
            step.endX = new GridIntersection[2];
            step.endY = new GridIntersection[2];
            int i = 0;
            while (i < 2) {
                step.endX[i] = new GridIntersection(0.0, 0.0, true);
                step.endY[i] = new GridIntersection(0.0, 0.0, false);
                ++i;
            }
        }
        return step;
    }

    @Override
    public String toString() {
        return "LineProfileStep " + this.n + " [" + format.format(this.lineEnd0.x) + ", " + format.format(this.lineEnd0.y) + ", " + format.format(this.lineEnd1.x) + ", " + format.format(this.lineEnd1.y) + "]";
    }

    public double[][] getProfileData(TrackerPanel trackerPanel) {
        if (this.n != trackerPanel.getFrameNumber() || this.profileData != null) {
            return this.profileData;
        }
        this.profileData = trackerPanel.getVideo() == null ? null : (((LineProfile)this.getTrack()).isHorizontal || Math.abs(Math.sin(trackerPanel.getCoords().getAngle(trackerPanel.getFrameNumber()))) < 1.0E-5 ? this.getHorizontalProfileData(trackerPanel) : this.getTiltedProfileData(trackerPanel));
        return this.profileData;
    }

    protected void rotate() {
        double theta;
        double theta_step;
        if (this.line.tp == null) {
            return;
        }
        double theta_x = this.line.tp.getCoords().getAngle(this.n);
        if (this.line.isHorizontal) {
            theta_x = 0.0;
        }
        if ((theta_step = this.lineEnd0.angle(this.lineEnd1)) > 1.5707963267948966 || theta_step < -1.5707963267948966) {
            theta_step = this.lineEnd1.angle(this.lineEnd0);
        }
        if (Math.abs(theta = theta_x + theta_step) > 1.0E-7) {
            center.center(this.lineEnd0, this.lineEnd1);
            AffineTransform transform = AffineTransform.getRotateInstance(-theta, LineProfileStep.center.x, LineProfileStep.center.y);
            transform.transform(this.lineEnd0, this.lineEnd0);
            transform.transform(this.lineEnd1, this.lineEnd1);
            this.erase();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private double[][] getTiltedProfileData(TrackerPanel trackerPanel) {
        double length = this.lineEnd0.distance(this.lineEnd1);
        if (length < 1.0) {
            return null;
        }
        BufferedImage image = trackerPanel.getVideo().getImage();
        if (image == null || image.getType() != 1) {
            return null;
        }
        Rectangle bounds = new Rectangle(image.getWidth(), image.getHeight());
        if (trackerPanel.getVideo().getTypeName().equals("Image")) {
            ImageVideo iVid = (ImageVideo)trackerPanel.getVideo();
            bounds = new Rectangle(iVid.getRGBSize().width, iVid.getRGBSize().height);
        }
        int width = 1 + 2 * this.line.getSpread();
        int len = (int)Math.floor(length);
        double theta = this.lineEnd0.angle(this.lineEnd1);
        this.cos = Math.cos(theta);
        this.sin = Math.sin(theta);
        double dx = (double)width * this.sin / 2.0;
        double dy = (double)width * this.cos / 2.0;
        this.corners[0][0].x = this.lineEnd0.x - dx;
        this.corners[0][0].y = this.lineEnd0.y + dy;
        this.corners[0][1].x = this.lineEnd0.x + dx;
        this.corners[0][1].y = this.lineEnd0.y - dy;
        while (!(len <= 0 || bounds.contains(this.corners[0][0]) && bounds.contains(this.corners[0][1]))) {
            --len;
            this.corners[0][0].x += this.cos;
            this.corners[0][0].y += this.sin;
            this.corners[0][1].x += this.cos;
            this.corners[0][1].y += this.sin;
        }
        this.corners[1][0].x = this.lineEnd1.x - dx;
        this.corners[1][0].y = this.lineEnd1.y + dy;
        this.corners[1][1].x = this.lineEnd1.x + dx;
        this.corners[1][1].y = this.lineEnd1.y - dy;
        while (!(len <= 0 || bounds.contains(this.corners[1][0]) && bounds.contains(this.corners[1][1]))) {
            --len;
            this.corners[1][0].x -= this.cos;
            this.corners[1][0].y -= this.sin;
            this.corners[1][1].x -= this.cos;
            this.corners[1][1].y -= this.sin;
        }
        if (len < 1) {
            return null;
        }
        this.xMin = this.xMax = this.corners[0][0].x;
        this.yMin = this.yMax = this.corners[0][0].y;
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < 2) {
                this.xMin = Math.min(this.xMin, this.corners[i][j].x);
                this.yMin = Math.min(this.yMin, this.corners[i][j].y);
                this.xMax = Math.max(this.xMax, this.corners[i][j].x);
                this.yMax = Math.max(this.yMax, this.corners[i][j].y);
                ++j;
            }
            ++i;
        }
        double[][] values = new double[8][len];
        int pixXMin = (int)Math.floor(this.xMin);
        int pixYMin = (int)Math.floor(this.yMin);
        int pixXMax = (int)Math.ceil(this.xMax);
        int pixYMax = (int)Math.ceil(this.yMax);
        int w = pixXMax - pixXMin;
        int h = pixYMax - pixYMin;
        int[] pixels = new int[w * h];
        if (this.sweepX == null || this.sweepX[0].length < width) {
            this.sweepX = new GridIntersection[2][width];
            this.sweepY = new GridIntersection[2][width];
            int i2 = 0;
            while (i2 < width) {
                this.sweepX[0][i2] = new GridIntersection(0.0, 0.0, true);
                this.sweepX[1][i2] = new GridIntersection(0.0, 0.0, true);
                this.sweepY[0][i2] = new GridIntersection(0.0, 0.0, false);
                this.sweepY[1][i2] = new GridIntersection(0.0, 0.0, false);
                ++i2;
            }
        }
        this.leadingIndex = 0;
        this.findLeadingIntersections();
        Point2D.Double imagePixel = new Point2D.Double();
        Point2D.Double worldPixel = new Point2D.Double();
        try {
            int n = trackerPanel.getFrameNumber();
            AffineTransform at = trackerPanel.getCoords().getToWorldTransform(n);
            image.getRaster().getDataElements(pixXMin, pixYMin, w, h, pixels);
            int i3 = 0;
            while (i3 < len) {
                double a;
                int row;
                int column;
                Corner end0 = this.corners[this.leadingIndex][0];
                Corner end1 = this.corners[this.leadingIndex][1];
                this.leadingIndex = this.leadingIndex == 0 ? 1 : 0;
                this.corners[this.leadingIndex][0].x = end0.x + this.cos;
                this.corners[this.leadingIndex][0].y = end0.y + this.sin;
                this.corners[this.leadingIndex][1].x = end1.x + this.cos;
                this.corners[this.leadingIndex][1].y = end1.y + this.sin;
                this.xMin = this.xMax = this.corners[0][0].x;
                this.yMin = this.yMax = this.corners[0][0].y;
                int k = 0;
                while (k < 2) {
                    int j = 0;
                    while (j < 2) {
                        this.xMin = Math.min(this.xMin, this.corners[k][j].x);
                        this.yMin = Math.min(this.yMin, this.corners[k][j].y);
                        this.xMax = Math.max(this.xMax, this.corners[k][j].x);
                        this.yMax = Math.max(this.yMax, this.corners[k][j].y);
                        ++j;
                    }
                    ++k;
                }
                ((Point2D)imagePixel).setLocation((this.xMax + this.xMin) / 2.0, (this.yMax + this.yMin) / 2.0);
                at.transform(imagePixel, worldPixel);
                values[0][i3] = ((Point2D)worldPixel).getX();
                values[1][i3] = ((Point2D)worldPixel).getY();
                int minCol = (int)Math.floor(this.xMin);
                int minRow = (int)Math.floor(this.yMin);
                int colCount = (int)Math.ceil(this.xMax) - minCol;
                int rowCount = (int)Math.ceil(this.yMax) - minRow;
                double[][] areas = new double[colCount][rowCount];
                this.findLeadingIntersections();
                this.findEndIntersections();
                this.findGridSegments();
                this.findGridVertices();
                double area = 0.0;
                double red = 0.0;
                double green = 0.0;
                double blue = 0.0;
                if (!this.vertices.isEmpty()) {
                    for (GridVertex next : this.vertices) {
                        column = (int)next.x - minCol;
                        row = (int)next.y - minRow;
                        this.quadAreas[0] = areas[column][row];
                        this.quadAreas[1] = column > 0 ? areas[column - 1][row] : 1.0;
                        this.quadAreas[2] = row > 0 && column > 0 ? areas[column - 1][row - 1] : 1.0;
                        this.quadAreas[3] = row > 0 ? areas[column][row - 1] : 1.0;
                        this.getAreas(next, this.quadAreas);
                        areas[column][row] = this.quadAreas[0];
                        if (column > 0) {
                            areas[column - 1][row] = this.quadAreas[1];
                        }
                        if (row <= 0) continue;
                        areas[column][row - 1] = this.quadAreas[3];
                        if (column <= 0) continue;
                        areas[column - 1][row - 1] = this.quadAreas[2];
                    }
                } else {
                    GridSegment seg = this.xSegments.iterator().next();
                    a = this.getArea(seg.lower, seg.higher);
                    column = this.polyLoc.x - minCol;
                    row = this.polyLoc.y - minRow;
                    if (a > 0.0) {
                        areas[column][row] = a;
                    }
                    a = this.getArea(seg.higher, seg.lower);
                    column = this.polyLoc.x - minCol;
                    row = this.polyLoc.y - minRow;
                    if (a > 0.0) {
                        areas[column][row] = a;
                    }
                }
                int j = 0;
                while (j < 2) {
                    int k2 = 0;
                    while (k2 < 2) {
                        a = this.getArea(this.corners[j][k2]);
                        column = this.polyLoc.x - minCol;
                        row = this.polyLoc.y - minRow;
                        if (a > 0.0) {
                            areas[column][row] = a;
                        }
                        ++k2;
                    }
                    ++j;
                }
                int ro = 0;
                while (ro < areas[0].length) {
                    int col = 0;
                    while (col < areas.length) {
                        int pixCol = col + minCol - pixXMin;
                        int pixRow = ro + minRow - pixYMin;
                        int pixIndex = pixCol + pixRow * w;
                        int pixel = pixels[pixIndex];
                        int r = pixel >> 16 & 0xFF;
                        int g = pixel >> 8 & 0xFF;
                        int b = pixel & 0xFF;
                        a = areas[col][ro];
                        red += a * (double)r;
                        green += a * (double)g;
                        blue += a * (double)b;
                        area += a;
                        ++col;
                    }
                    ++ro;
                }
                if (area == 0.0) {
                    return null;
                }
                values[2][i3] = red /= area;
                values[3][i3] = green /= area;
                values[4][i3] = blue /= area;
                values[5][i3] = RGBRegion.getLuma(red, green, blue);
                values[6][i3] = width;
                values[7][i3] = i3;
                ++i3;
            }
            return values;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void findLeadingIntersections() {
        this.sorter.clear();
        this.sorter.add(this.corners[this.leadingIndex][0]);
        this.sorter.add(this.corners[this.leadingIndex][1]);
        Iterator<Intersection> it = this.sorter.iterator();
        Corner minXCorner = (Corner)it.next();
        Corner maxXCorner = (Corner)it.next();
        minXCorner.lowerX = null;
        maxXCorner.higherX = null;
        double slope = -this.cos / this.sin;
        double y0 = this.corners[this.leadingIndex][0].y - slope * this.corners[this.leadingIndex][0].x;
        int n = 0;
        int i = (int)Math.ceil(minXCorner.x);
        while (i <= (int)Math.floor(maxXCorner.x)) {
            double y = slope * (double)i + y0;
            this.sweepX[this.leadingIndex][n].setLocation(i, y);
            this.sorter.add(this.sweepX[this.leadingIndex][n]);
            ++n;
            ++i;
        }
        while (n < this.sweepX[this.leadingIndex].length) {
            this.sweepX[this.leadingIndex][n].setLocation(Double.NaN, Double.NaN);
            ++n;
        }
        double ymin = Math.min(minXCorner.y, maxXCorner.y);
        double ymax = Math.max(minXCorner.y, maxXCorner.y);
        n = 0;
        int i2 = (int)Math.ceil(ymin);
        while (i2 <= (int)Math.floor(ymax)) {
            double x = ((double)i2 - y0) / slope;
            this.sweepY[this.leadingIndex][n].setLocation(x, i2);
            this.sorter.add(this.sweepY[this.leadingIndex][n]);
            ++n;
            ++i2;
        }
        while (n < this.sweepY[this.leadingIndex].length) {
            this.sweepY[this.leadingIndex][n].setLocation(Double.NaN, Double.NaN);
            ++n;
        }
        it = this.sorter.iterator();
        Intersection prev = null;
        while (it.hasNext()) {
            Intersection next = it.next();
            if (prev != null) {
                prev.higherX = next;
                next.lowerX = prev;
            }
            prev = next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void findGridSegments() {
        double val;
        this.xSegments.clear();
        this.sorter.clear();
        int i = 0;
        while (i < 2) {
            if (!Double.isNaN(this.endX[i].x)) {
                this.sorter.add(this.endX[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.sweepX[0].length) {
            int j = 0;
            while (j < 2) {
                if (!Double.isNaN(this.sweepX[j][i].x)) {
                    this.sorter.add(this.sweepX[j][i]);
                }
                ++j;
            }
            ++i;
        }
        GridIntersection end0 = null;
        for (GridIntersection gridIntersection : this.sorter) {
            if (end0 == null) {
                end0 = gridIntersection;
                continue;
            }
            this.xSegments.add(new GridSegment(gridIntersection, end0));
            end0 = null;
        }
        this.ySegments.clear();
        this.sorter.clear();
        int i2 = 0;
        while (i2 < 2) {
            if (!Double.isNaN(this.endY[i2].y)) {
                double d = this.endY[i2].y;
                this.endY[i2].setLocation(d, this.endY[i2].x);
                this.sorter.add(this.endY[i2]);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.sweepY[0].length) {
            void var3_10;
            boolean bl = false;
            while (var3_10 < 2) {
                if (!Double.isNaN(this.sweepY[var3_10][i3].y)) {
                    val = this.sweepY[var3_10][i3].y;
                    this.sweepY[var3_10][i3].setLocation(val, this.sweepY[var3_10][i3].x);
                    this.sorter.add(this.sweepY[var3_10][i3]);
                }
                ++var3_10;
            }
            ++i3;
        }
        end0 = null;
        for (GridIntersection gridIntersection : this.sorter) {
            val = gridIntersection.y;
            gridIntersection.setLocation(val, gridIntersection.x);
            if (end0 == null) {
                end0 = gridIntersection;
                continue;
            }
            this.ySegments.add(new GridSegment(gridIntersection, end0));
            end0 = null;
        }
    }

    private void findGridVertices() {
        this.vertices.clear();
        block0: for (GridSegment nextX : this.xSegments) {
            for (GridSegment nextY : this.ySegments) {
                if (nextY.higher.x < nextX.value) continue;
                if (nextY.lower.x > nextX.value) continue block0;
                if (!(nextX.lower.y < nextY.value) || !(nextX.higher.y > nextY.value)) continue;
                this.vertices.add(new GridVertex(nextX, nextY));
            }
        }
        Collections.sort(this.vertices);
        Iterator<GridVertex> it = this.vertices.iterator();
        GridVertex prev = null;
        while (it.hasNext()) {
            GridVertex next = it.next();
            if (prev != null && prev.distance(next) == 1.0) {
                GridSegment segment;
                if (prev.x == next.x) {
                    next.isVertical = true;
                    prev.isVertical = true;
                    if (next.y - prev.y > 0.0) {
                        segment = new GridSegment(prev.vert.lower, next);
                        prev.setVerticalSegment(segment);
                        segment = new GridSegment(next.vert.higher, prev);
                        next.setVerticalSegment(segment);
                    } else {
                        segment = new GridSegment(prev.vert.higher, next);
                        prev.setVerticalSegment(segment);
                        segment = new GridSegment(next.vert.lower, prev);
                        next.setVerticalSegment(segment);
                    }
                } else {
                    next.isVertical = false;
                    prev.isVertical = false;
                    segment = new GridSegment(prev.horz.lower, next);
                    prev.setHorizontalSegment(segment);
                    segment = new GridSegment(next.horz.higher, prev);
                    next.setHorizontalSegment(segment);
                }
            }
            prev = next;
        }
    }

    private void findEndIntersections() {
        int trailingIndex = this.leadingIndex == 0 ? 1 : 0;
        int j = 0;
        while (j < 2) {
            double larger;
            this.sorter.clear();
            this.sorter.add(this.corners[0][j]);
            this.sorter.add(this.corners[1][j]);
            double intercept = this.corners[trailingIndex][j].y - this.sin * this.corners[trailingIndex][j].x / this.cos;
            double grid = this.cos > 0.0 ? Math.ceil(this.corners[trailingIndex][j].x) : Math.ceil(this.corners[this.leadingIndex][j].x);
            double d = larger = this.cos > 0.0 ? this.corners[this.leadingIndex][j].x : this.corners[trailingIndex][j].x;
            if (grid < larger) {
                double y = this.sin * grid / this.cos + intercept;
                this.endX[j].setLocation(grid, y);
                this.sorter.add(this.endX[j]);
            } else {
                this.endX[j].setLocation(Double.NaN, Double.NaN);
            }
            grid = this.sin > 0.0 ? Math.ceil(this.corners[trailingIndex][j].y) : Math.ceil(this.corners[this.leadingIndex][j].y);
            double d2 = larger = this.sin > 0.0 ? this.corners[this.leadingIndex][j].y : this.corners[trailingIndex][j].y;
            if (grid < larger) {
                double x = (grid - intercept) * this.cos / this.sin;
                this.endY[j].setLocation(x, grid);
                this.sorter.add(this.endY[j]);
            } else {
                this.endY[j].setLocation(Double.NaN, Double.NaN);
            }
            Iterator<Intersection> it = this.sorter.iterator();
            Intersection prev = null;
            while (it.hasNext()) {
                Intersection next = it.next();
                if (prev != null) {
                    Corner corner;
                    if (prev instanceof Corner) {
                        corner = (Corner)prev;
                        corner.end = next;
                        if (corner.higherX == null || Double.isNaN(corner.higherX.x)) {
                            corner.higherX = next;
                        }
                    } else {
                        prev.higherX = next;
                    }
                    if (next instanceof Corner) {
                        corner = (Corner)next;
                        corner.end = prev;
                        if (corner.lowerX == null || Double.isNaN(corner.lowerX.x)) {
                            corner.lowerX = prev;
                        }
                    } else {
                        next.lowerX = prev;
                    }
                }
                prev = next;
            }
            ++j;
        }
    }

    private Intersection getNext(Intersection current, Intersection prev) {
        Intersection next = null;
        if (current instanceof GridVertex) {
            GridVertex vertex = (GridVertex)current;
            if (prev == vertex.horz.lower) {
                return vertex.vert.higher;
            }
            if (prev == vertex.horz.higher) {
                return vertex.vert.lower;
            }
            if (prev == vertex.vert.lower) {
                return vertex.horz.lower;
            }
            next = vertex.horz.higher;
        }
        if (current instanceof Corner) {
            Corner corner = (Corner)current;
            if (prev.compareTo(corner.end) == 0) {
                if (corner.higherX != null && !Double.isNaN(corner.higherX.x) && corner.higherX.compareTo(corner) > 0) {
                    next = corner.higherX;
                } else if (corner.lowerX != null && !Double.isNaN(corner.lowerX.x) && corner.lowerX.compareTo(corner) < 0) {
                    next = corner.lowerX;
                }
            } else {
                next = corner.end;
            }
        }
        if (next == null && current instanceof GridIntersection) {
            GridIntersection grid = (GridIntersection)current;
            if (prev == grid.segment.vertex) {
                GridVertex vertex = (GridVertex)prev;
                next = grid == vertex.vert.higher ? grid.lowerX : (grid == vertex.vert.lower ? grid.higherX : (grid == vertex.horz.higher ? (grid.higherX.y > grid.y ? grid.higherX : grid.lowerX) : (grid.higherX.y < grid.y ? grid.higherX : grid.lowerX)));
            } else {
                next = grid.segment.vertex == null ? (prev == grid.segment.lower ? (grid.isVertical ? grid.lowerX : (grid.higherX.y > grid.y ? grid.higherX : grid.lowerX)) : (prev == grid.segment.higher ? (grid.isVertical ? grid.higherX : (grid.higherX.y < grid.y ? grid.higherX : grid.lowerX)) : (grid == grid.segment.higher ? grid.segment.lower : grid.segment.higher))) : grid.segment.vertex;
            }
        }
        if (next == null) {
            return null;
        }
        double thetaPrev = Math.atan2(current.getY() - prev.getY(), current.getX() - prev.getX());
        double thetaNext = Math.atan2(next.getY() - current.getY(), next.getX() - current.getX());
        double delta = thetaNext - thetaPrev;
        if (delta > 0.0 && delta < Math.PI || delta < -Math.PI) {
            return next;
        }
        return null;
    }

    private double[] getAreas(GridVertex vertex, double[] knownValues) {
        int i = 0;
        while (i < 4) {
            double area = knownValues[i];
            if (area == 0.0) {
                knownValues[i] = this.getArea(vertex, i);
            }
            ++i;
        }
        return knownValues;
    }

    private double getArea(GridVertex vertex, int quadrant) {
        GridIntersection current = vertex.horz.higher;
        switch (quadrant) {
            case 1: {
                current = vertex.vert.higher;
                break;
            }
            case 2: {
                current = vertex.horz.lower;
                break;
            }
            case 3: {
                current = vertex.vert.lower;
            }
        }
        return this.getArea((Intersection)vertex, current);
    }

    private double getArea(Corner corner) {
        double a = this.getArea(corner, corner.end);
        if (a == 0.0) {
            this.getArea(corner.end, corner);
        }
        return a > 0.0 ? a : this.getArea(corner.end, corner);
    }

    private double getArea(Intersection start, Intersection next) {
        this.polygon[0] = start;
        Intersection prev = start;
        int n = 1;
        while (next != null && next != start) {
            this.polygon[n++] = next;
            Intersection ondeck = this.getNext(next, prev);
            prev = next;
            next = ondeck;
        }
        double area = 0.0;
        int col = (int)this.polygon[0].x;
        int row = (int)this.polygon[0].y;
        boolean noCorner = true;
        int i = 0;
        while (i < n) {
            int below = i - 1 < 0 ? n - 1 : i - 1;
            int above = i + 1 > n - 1 ? 0 : i + 1;
            area += this.polygon[i].x * (this.polygon[above].y - this.polygon[below].y);
            if (this.polygon[i] instanceof Corner) {
                Corner corner = (Corner)this.polygon[i];
                col = (int)corner.x;
                row = (int)corner.y;
                noCorner = false;
            }
            if (noCorner) {
                col = Math.min(col, (int)this.polygon[i].x);
                row = Math.min(row, (int)this.polygon[i].y);
            }
            ++i;
        }
        this.polyLoc.setLocation(col, row);
        return area /= 2.0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double[][] getHorizontalProfileData(TrackerPanel trackerPanel) {
        int length;
        Video vid = trackerPanel.getVideo();
        if (vid == null) {
            return null;
        }
        BufferedImage image = trackerPanel.getVideo().getImage();
        int spread = this.line.getSpread();
        int x0 = Math.min((int)this.lineEnd0.getX(), (int)this.lineEnd1.getX());
        x0 = Math.max(x0, 0);
        int x1 = Math.max((int)this.lineEnd0.getX(), (int)this.lineEnd1.getX());
        int w = (int)trackerPanel.getImageWidth();
        if (vid.getTypeName().equals("Image")) {
            ImageVideo iVid = (ImageVideo)vid;
            w = iVid.getRGBSize().width;
        }
        if ((length = (x1 = Math.min(x1, w)) - x0) <= 0) {
            return null;
        }
        int width = 1 + 2 * spread;
        int npix = length * width;
        int[] pixels = new int[npix];
        int[] r = new int[width];
        int[] g = new int[width];
        int[] b = new int[width];
        double[][] values = new double[8][length];
        Point2D.Double imagePixel = new Point2D.Double();
        Point2D.Double worldPixel = new Point2D.Double();
        if (image == null) return values;
        if (image.getType() != 1) return values;
        try {
            int y = (int)this.lineEnd0.getY();
            int y0 = y - spread;
            int n = trackerPanel.getFrameNumber();
            AffineTransform at = trackerPanel.getCoords().getToWorldTransform(n);
            image.getRGB(0, 0);
            image.getRaster().getDataElements(x0, y0, length, width, pixels);
            boolean isOK = false;
            int i = 0;
            while (i < npix) {
                if (pixels[i] != 0) {
                    isOK = true;
                    break;
                }
                ++i;
            }
            if (!isOK) {
                System.err.println("LineProfileStep image failed");
                image.getRaster().getDataElements(x0, y0, length, width, pixels);
                return null;
            }
            i = 0;
            while (i < length) {
                int j = 0;
                while (j < width) {
                    ((Point2D)imagePixel).setLocation((double)(x0 + i) + 0.5, (double)y + 0.5);
                    if (vid.getTypeName().equals("Image")) {
                        ImageVideo iVid = (ImageVideo)vid;
                        int wid = iVid.getRGBSize().width;
                        int ht = iVid.getRGBSize().height;
                        if ((double)wid < ((Point2D)imagePixel).getX()) return null;
                        if ((double)ht < ((Point2D)imagePixel).getY()) {
                            return null;
                        }
                    }
                    if (j == spread) {
                        at.transform(imagePixel, worldPixel);
                        values[0][i] = ((Point2D)worldPixel).getX();
                        values[1][i] = ((Point2D)worldPixel).getY();
                    }
                    int pixel = pixels[i + j * length];
                    r[j] = pixel >> 16 & 0xFF;
                    g[j] = pixel >> 8 & 0xFF;
                    b[j] = pixel & 0xFF;
                    ++j;
                }
                double rMean = 0.0;
                double gMean = 0.0;
                double bMean = 0.0;
                double total = 0.0;
                int j2 = 0;
                while (j2 < r.length) {
                    rMean += (double)r[j2];
                    gMean += (double)g[j2];
                    bMean += (double)b[j2];
                    total += 1.0;
                    ++j2;
                }
                values[2][i] = rMean /= total;
                values[3][i] = gMean /= total;
                values[4][i] = bMean /= total;
                values[5][i] = RGBRegion.getLuma(rMean, gMean, bMean);
                values[6][i] = total;
                values[7][i] = i;
                ++i;
            }
            return values;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static int getLength() {
        return 3;
    }

    public void clearData() {
        this.profileData = null;
    }

    class Corner
    extends Intersection {
        Intersection end;

        Corner() {
            super(0.0, 0.0);
        }
    }

    class GridIntersection
    extends Intersection {
        boolean isVertical;
        GridSegment segment;

        GridIntersection(double x, double y, boolean vert) {
            super(x, y);
            this.isVertical = vert;
        }
    }

    class GridSegment
    implements Comparable<GridSegment> {
        double value;
        GridIntersection lower;
        GridIntersection higher;
        GridVertex vertex;

        GridSegment(GridIntersection end0, GridIntersection end1) {
            boolean vert = end0.isVertical;
            if (vert) {
                this.value = end0.x;
                boolean end0Smaller = end0.y < end1.y;
                this.lower = end0Smaller ? end0 : end1;
                this.higher = end0Smaller ? end1 : end0;
            } else {
                this.value = end0.y;
                boolean end0Smaller = end0.x < end1.x;
                this.lower = end0Smaller ? end0 : end1;
                this.higher = end0Smaller ? end1 : end0;
            }
            this.lower.segment = this;
            this.higher.segment = this;
        }

        @Override
        public int compareTo(GridSegment other) {
            if (this.lower.isVertical) {
                return (int)(this.value - other.value);
            }
            double dx = this.lower.x - other.lower.x;
            return dx == 0.0 ? 0 : (dx > 0.0 ? 1 : -1);
        }
    }

    class GridVertex
    extends GridIntersection {
        GridSegment vert;
        GridSegment horz;

        GridVertex(GridSegment xSegment, GridSegment ySegment) {
            super(xSegment.value, ySegment.value, true);
            this.setVerticalSegment(xSegment);
            this.setHorizontalSegment(ySegment);
        }

        void setVerticalSegment(GridSegment segment) {
            this.vert = segment;
            this.vert.vertex = this;
        }

        void setHorizontalSegment(GridSegment segment) {
            this.horz = segment;
            this.horz.vertex = this;
        }
    }

    class Handle
    extends Step.Handle {
        public Handle(double x, double y) {
            super(x, y);
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double x, double y) {
            TTrack track = LineProfileStep.this.getTrack();
            if (track.isLocked()) {
                return;
            }
            if (!LineProfileStep.this.line.isFixed()) {
                LineProfileStep.this.line.keyFrames.add(LineProfileStep.this.n);
            }
            double dx = x - this.getX();
            double dy = y - this.getY();
            if (LineProfileStep.this.line.isFixed()) {
                LineProfileStep step = (LineProfileStep)LineProfileStep.this.line.steps.getStep(0);
                step.lineEnd0.setLocation(LineProfileStep.this.lineEnd0.getX() + dx, LineProfileStep.this.lineEnd0.getY() + dy);
                step.lineEnd1.setLocation(LineProfileStep.this.lineEnd1.getX() + dx, LineProfileStep.this.lineEnd1.getY() + dy);
                step.handle.setLocation(x, y);
                step.erase();
                LineProfileStep.this.line.refreshStep(LineProfileStep.this);
            } else {
                LineProfileStep.this.lineEnd0.setLocation(LineProfileStep.this.lineEnd0.getX() + dx, LineProfileStep.this.lineEnd0.getY() + dy);
                LineProfileStep.this.lineEnd1.setLocation(LineProfileStep.this.lineEnd1.getX() + dx, LineProfileStep.this.lineEnd1.getY() + dy);
                this.setLocation(x, y);
                LineProfileStep.this.line.keyFrames.add(LineProfileStep.this.n);
            }
            LineProfileStep.this.line.clearStepData();
            LineProfileStep.this.repaint();
            track.firePropertyChange("step", null, LineProfileStep.this.n);
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return LineProfileStep.this.n;
        }

        @Override
        public void setPositionOnLine(int xScreen, int yScreen, TrackerPanel trackerPanel) {
            this.setPositionOnLine(xScreen, yScreen, trackerPanel, LineProfileStep.this.lineEnd0, LineProfileStep.this.lineEnd1);
            LineProfileStep.this.repaint();
        }
    }

    class Intersection
    extends Point2D.Double
    implements Comparable<Intersection> {
        Intersection lowerX;
        Intersection higherX;

        Intersection(double x, double y) {
            super(x, y);
        }

        @Override
        public int compareTo(Intersection other) {
            double dx = this.x - other.x;
            if (dx == 0.0) {
                double dy = this.y - other.y;
                if (LineProfileStep.this.cos / LineProfileStep.this.sin < 0.0) {
                    return dy == 0.0 ? 0 : (dy > 0.0 ? 1 : -1);
                }
                return dy == 0.0 ? 0 : (dy < 0.0 ? 1 : -1);
            }
            return dx > 0.0 ? 1 : -1;
        }
    }

    class LineEnd
    extends TPoint {
        public LineEnd(double x, double y) {
            super(x, y);
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double x, double y) {
            TTrack track = LineProfileStep.this.getTrack();
            if (track.isLocked()) {
                return;
            }
            if (track.tp == null) {
                super.setXY(x, y);
                return;
            }
            double dx = x - this.getX();
            double dy = y - this.getY();
            double hyp = Math.sqrt(dx * dx + dy * dy);
            double theta1 = -track.tp.getCoords().getAngle(LineProfileStep.this.n);
            LineProfile profile = (LineProfile)LineProfileStep.this.getTrack();
            if (profile.isHorizontal) {
                theta1 = 0.0;
            }
            double theta2 = Math.atan2(dy, dx);
            double theta = theta1 - theta2;
            double d = hyp * Math.cos(theta);
            dx = d * Math.cos(theta1);
            dy = d * Math.sin(theta1);
            if (LineProfileStep.this.line.isFixed()) {
                LineProfileStep step = (LineProfileStep)LineProfileStep.this.line.steps.getStep(0);
                TPoint target = this == LineProfileStep.this.lineEnd0 ? step.lineEnd0 : step.lineEnd1;
                target.setLocation(this.getX() + dx, this.getY() + dy);
                step.erase();
                LineProfileStep.this.line.refreshStep(LineProfileStep.this);
            } else {
                this.setLocation(this.getX() + dx, this.getY() + dy);
                LineProfileStep.this.line.keyFrames.add(LineProfileStep.this.n);
            }
            LineProfileStep.this.line.clearStepData();
            LineProfileStep.this.repaint();
            track.firePropertyChange("step", null, LineProfileStep.this.n);
        }

        @Override
        public int getFrameNumber(VideoPanel vidPanel) {
            return LineProfileStep.this.n;
        }
    }
}

