/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.ZoomTView;

public class MainTView
extends ZoomTView {
    private JToolBar playerBar;

    public MainTView(TrackerPanel panel) {
        super(panel);
        TTrackBar tbar = panel.getTrackBar(true);
        if (tbar != null) {
            this.add((Component)tbar, "North");
        }
        this.playerBar = new JToolBar();
        this.add((Component)this.playerBar, "South");
        this.playerBar.setFloatable(false);
        panel.getPlayer().setBorder(null);
        panel.setPlayerVisible(false);
        this.playerBar.add(panel.getPlayer());
    }

    @Override
    protected boolean doResized() {
        if (!super.doResized()) {
            return false;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        TToolBar tbar = trackerPanel.getToolBar(false);
        if (tbar != null) {
            tbar.refreshZoomButton();
        }
        trackerPanel.eraseAll();
        return true;
    }

    @Override
    JPopupMenu getPopupMenu() {
        if (!Tracker.allowMenuRefresh) {
            return null;
        }
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        if (Tracker.isZoomInCursor(trackerPanel.getCursor()) || Tracker.isZoomOutCursor(trackerPanel.getCursor())) {
            return null;
        }
        return trackerPanel.updateMainPopup();
    }

    public JToolBar getPlayerBar() {
        return this.playerBar;
    }

    @Override
    public void dispose() {
        super.dispose();
        Container frame = this.playerBar.getTopLevelAncestor();
        if (frame instanceof JDialog) {
            frame.removeAll();
            ((JDialog)frame).dispose();
        }
        this.playerBar.removeAll();
        this.playerBar = null;
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.Video");
    }

    @Override
    public Icon getViewIcon() {
        return Tracker.getResourceIcon("video_on.gif", true);
    }

    @Override
    public int getViewType() {
        return 4;
    }
}

