/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.ModelFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrackFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class ModelBuilder
extends FunctionTool {
    private TFrame frame;
    private Integer panelID;
    private JLabel startFrameLabel;
    private JLabel endFrameLabel;
    private JLabel boosterLabel;
    private ModelFrameSpinner startFrameSpinner;
    private ModelFrameSpinner endFrameSpinner;
    private JComboBox<FunctionTool.FTObject> boosterDropdown;
    private JComboBox<String> solverDropdown;
    private ComponentListener myFollower;
    protected boolean refreshingLayout;
    private boolean repaintDelayed;
    private static String[] solverClassNames = new String[]{"org.opensourcephysics.numerics.RK4", "org.opensourcephysics.numerics.Euler", "org.opensourcephysics.numerics.Ralston2"};

    protected ModelBuilder(TrackerPanel trackerPanel) {
        super(trackerPanel, false, true);
        this.setVisible(false);
        this.repaintDelayed = true;
        this.setMinimumSize(new Dimension(400, 600));
        this.frame = trackerPanel.getTFrame();
        this.panelID = trackerPanel.getID();
        if (this.frame != null) {
            this.myFollower = this.frame.addFollower(this, null);
        }
        this.setFontLevel(FontSizer.getLevel());
        this.addPropertyChangeListener("panel", trackerPanel);
        this.repaintDelayed = false;
    }

    @Override
    protected void createGUI() {
        if (this.haveGUI()) {
            return;
        }
        super.createGUI();
        this.createToolbarComponents();
        this.setToolbarComponents(new Component[]{this.startFrameLabel, this.startFrameSpinner, this.endFrameLabel, this.endFrameSpinner, this.boosterLabel, this.boosterDropdown});
    }

    protected void createToolbarComponents() {
        this.startFrameLabel = new JLabel();
        this.startFrameLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.endFrameLabel = new JLabel();
        this.endFrameLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 2));
        final TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        int first = trackerPanel.getPlayer().getVideoClip().getFirstFrameNumber();
        int last = trackerPanel.getPlayer().getVideoClip().getLastFrameNumber();
        this.startFrameSpinner = new ModelFrameSpinner(new SpinnerNumberModel(first, first, last, 1));
        this.endFrameSpinner = new ModelFrameSpinner(new SpinnerNumberModel(last, first, last, 1));
        this.boosterLabel = new JLabel();
        this.boosterLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 2));
        this.boosterDropdown = new JComboBox();
        this.boosterDropdown.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.boosterDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ModelBuilder.this.boosterDropdown.isEnabled()) {
                    return;
                }
                FunctionPanel panel = ModelBuilder.this.getSelectedPanel();
                if (panel != null) {
                    ParticleModel part = ((ModelFunctionPanel)panel).model;
                    if (!(part instanceof DynamicParticle)) {
                        return;
                    }
                    DynamicParticle model = (DynamicParticle)part;
                    FunctionTool.FTObject item = (FunctionTool.FTObject)ModelBuilder.this.boosterDropdown.getSelectedItem();
                    if (item != null) {
                        PointMass pm;
                        Step step;
                        PointMass target = (PointMass)item.track;
                        model.setBooster(target);
                        if (target != null && (step = trackerPanel.getSelectedStep()) != null && step instanceof PositionStep && (pm = (PointMass)step.getTrack()) == target) {
                            model.setStartFrame(step.getFrameNumber());
                        }
                    }
                }
            }
        });
        FunctionTool.DropdownRenderer renderer = new FunctionTool.DropdownRenderer(this);
        this.boosterDropdown.setRenderer(renderer);
        this.refreshBoosterDropdown();
        String[] solverShortNames = new String[solverClassNames.length];
        int i = 0;
        while (i < solverShortNames.length) {
            int n = "org.opensourcephysics.numerics.".length();
            solverShortNames[i] = solverClassNames[i].substring(n);
            ++i;
        }
        this.solverDropdown = new JComboBox<String>(solverShortNames);
        this.solverDropdown.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.solverDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ModelBuilder.this.solverDropdown.isEnabled() || ModelBuilder.this.solverDropdown.getSelectedIndex() < 0) {
                    return;
                }
                ModelFunctionPanel modelpanel = (ModelFunctionPanel)ModelBuilder.this.getSelectedPanel();
                String solver = solverClassNames[ModelBuilder.this.solverDropdown.getSelectedIndex()];
                if (solver != null && modelpanel.model instanceof DynamicParticle) {
                    DynamicParticle dyna = (DynamicParticle)modelpanel.model;
                    try {
                        Class<?> solverClass = Class.forName(solver);
                        dyna.setSolver(solverClass);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        trackerPanel.addPropertyChangeListener("track", this);
        this.setHelpAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModelBuilder.this.frame != null) {
                    ModelFunctionPanel panel = (ModelFunctionPanel)ModelBuilder.this.getSelectedPanel();
                    if (panel instanceof ParticleDataTrackFunctionPanel) {
                        ModelBuilder.this.frame.showHelp("datatrack", 0);
                    } else if (panel.model instanceof DynamicSystem) {
                        ModelBuilder.this.frame.showHelp("system", 0);
                    } else {
                        ModelBuilder.this.frame.showHelp("particle", 0);
                    }
                }
            }
        });
    }

    @Override
    protected void setTitles() {
        TTrack track;
        this.dropdownTipText = TrackerRes.getString("TrackerPanel.ModelBuilder.Spinner.Tooltip");
        String title = TrackerRes.getString("TrackerPanel.ModelBuilder.Title");
        FunctionPanel panel = this.getSelectedPanel();
        if (panel != null && (track = this.frame.getTrackerPanelForID(this.panelID).getTrack(panel.getName())) != null) {
            String type = track.getClass().getSimpleName();
            title = String.valueOf(title) + ": " + TrackerRes.getString(String.valueOf(type) + ".Builder.Title");
        }
        this.titleText = title;
    }

    @Override
    protected void refreshGUI() {
        if (!this.haveGUI()) {
            return;
        }
        super.refreshGUI();
        if (this.boosterDropdown != null) {
            this.boosterDropdown.setToolTipText(TrackerRes.getString("TrackerPanel.Dropdown.Booster.Tooltip"));
            this.boosterLabel.setText(TrackerRes.getString("TrackerPanel.Label.Booster"));
            this.startFrameLabel.setText(TrackerRes.getString("TrackerPanel.Label.ModelStart"));
            this.endFrameLabel.setText(TrackerRes.getString("TrackerPanel.Label.ModelEnd"));
            this.startFrameSpinner.setToolTipText(TrackerRes.getString("TrackerPanel.Spinner.ModelStart.Tooltip"));
            this.endFrameSpinner.setToolTipText(TrackerRes.getString("TrackerPanel.Spinner.ModelEnd.Tooltip"));
            this.refreshBoosterDropdown();
        }
        this.setTitles();
    }

    @Override
    public void setVisible(boolean vis) {
        if (vis == this.isVisible() || this.repaintDelayed) {
            return;
        }
        this.repaintDelayed = true;
        super.setVisible(vis);
        this.repaintDelayed = false;
        if (vis) {
            this.repaint();
        }
        this.frame.getTrackerPanelForID((Integer)this.panelID).isModelBuilderVisible = vis;
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        this.refreshBoosterDropdown();
        this.refreshLayoutAsync();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("track")) {
            this.refreshBoosterDropdown();
            this.refreshLayoutAsync();
        } else {
            super.propertyChange(e);
        }
    }

    public TrackerPanel getTrackerPanel() {
        return this.frame.getTrackerPanelForID(this.panelID);
    }

    protected void refreshLayoutAsync() {
        if (this.refreshingLayout) {
            return;
        }
        this.refreshingLayout = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelBuilder.this.refreshingLayout = false;
                ModelBuilder.this.refreshGUI();
                ModelBuilder.this.validate();
                Dimension dim = ModelBuilder.this.getSize();
                dim.width = Math.max(dim.width, ModelBuilder.this.getToolbar().getMinimumSize().width);
                int height = Toolkit.getDefaultToolkit().getScreenSize().height;
                dim.height = height = Math.min((int)(0.9 * (double)height), (int)(550.0 * (1.0 + (double)ModelBuilder.this.fontLevel / 4.0)));
                ModelBuilder.this.setSize(dim);
            }
        });
    }

    protected void refreshSpinners() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        int last = trackerPanel.getPlayer().getVideoClip().getLastFrameNumber();
        int first = trackerPanel.getPlayer().getVideoClip().getFirstFrameNumber();
        FunctionPanel panel = this.getSelectedPanel();
        this.startFrameSpinner.setEnabled(panel != null);
        this.endFrameSpinner.setEnabled(panel != null);
        this.startFrameLabel.setEnabled(panel != null);
        this.endFrameLabel.setEnabled(panel != null);
        int end = last;
        ParticleModel model = null;
        if (panel != null) {
            model = ((ModelFunctionPanel)panel).model;
            end = Math.min(last, model.getEndFrame());
        }
        ((SpinnerNumberModel)this.startFrameSpinner.getModel()).setMaximum(Integer.valueOf(last));
        ((SpinnerNumberModel)this.endFrameSpinner.getModel()).setMaximum(Integer.valueOf(last));
        ((SpinnerNumberModel)this.startFrameSpinner.getModel()).setMinimum(Integer.valueOf(first));
        ((SpinnerNumberModel)this.endFrameSpinner.getModel()).setMinimum(Integer.valueOf(first));
        if (model != null) {
            this.startFrameSpinner.setValue(model.getStartFrame());
            this.endFrameSpinner.setValue(end);
        } else {
            this.startFrameSpinner.setValue(first);
            this.endFrameSpinner.setValue(last);
        }
        this.validate();
    }

    @Override
    public void checkGUI() {
        if (this.haveGUI()) {
            return;
        }
        super.checkGUI();
    }

    /*
     * Exception decompiling
     */
    protected void refreshBoosterDropdown() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void syncParameters(Parameter param) {
        if (param == null || !param.isSynced()) {
            return;
        }
        Set<String> panelnames = this.getPanelNames();
        block0: for (String name : panelnames) {
            FunctionPanel panel = this.getPanel(name);
            if (panel instanceof ParticleDataTrackFunctionPanel) continue;
            ParamEditor editor = panel.getParamEditor();
            List<FunctionEditor.FObject> objects = editor.getObjects();
            int i = 0;
            while (i < objects.size()) {
                Parameter next = (Parameter)objects.get(i);
                if (next.getName().equals(param.getName())) {
                    if (next.equals(param)) continue block0;
                    if (next.isSynced()) {
                        editor.setExpression(next.getName(), param.getExpression(), true);
                    }
                }
                ++i;
            }
        }
    }

    protected void setSpinnerStartFrame(Object frameNumber) {
        this.startFrameSpinner.setValue(frameNumber);
    }

    protected void setSpinnerEndFrame(Object frameNumber) {
        this.endFrameSpinner.setValue(frameNumber);
    }

    protected int getSpinnerHeight() {
        return this.startFrameSpinner.getHeight();
    }

    @Override
    public void dispose() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        trackerPanel.removePropertyChangeListener("track", this);
        ToolsRes.removePropertyChangeListener("locale", this);
        this.removePropertyChangeListener("panel", trackerPanel);
        for (String key : this.trackFunctionPanels.keySet()) {
            FunctionPanel next = (FunctionPanel)this.trackFunctionPanels.get(key);
            next.setFunctionTool(null);
        }
        this.clearPanels();
        this.selectedPanel = null;
        trackerPanel.modelBuilder = null;
        if (this.frame != null) {
            this.frame.removeComponentListener(this.myFollower);
        }
        this.myFollower = null;
        this.panelID = null;
        this.frame = null;
        super.dispose();
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    @Override
    public void repaint(long a, int b, int c, int d, int e) {
        if (this.repaintDelayed) {
            return;
        }
        super.repaint(a, b, c, d, e);
    }

    class ModelFrameSpinner
    extends JSpinner {
        Integer prevMax;
        SpinnerNumberModel spinModel;

        ModelFrameSpinner(SpinnerNumberModel model) {
            super(model);
            this.spinModel = model;
            this.prevMax = (Integer)this.spinModel.getMaximum();
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ModelFunctionPanel panel = (ModelFunctionPanel)ModelBuilder.this.getSelectedPanel();
                    if (panel == null || panel.model == null || panel.model.refreshing) {
                        return;
                    }
                    if (ModelFrameSpinner.this.prevMax != ModelFrameSpinner.this.spinModel.getMaximum()) {
                        ModelFrameSpinner.this.prevMax = (Integer)ModelFrameSpinner.this.spinModel.getMaximum();
                        return;
                    }
                    int n = (Integer)ModelFrameSpinner.this.getValue();
                    if (ModelFrameSpinner.this == ModelBuilder.this.startFrameSpinner) {
                        panel.model.setStartFrame(n);
                    } else {
                        panel.model.setEndFrame(n);
                    }
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            dim.width += (int)(FontSizer.getFactor() * 4.0);
            return dim;
        }
    }
}

