/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.ModelBuilder;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.InitialValueEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public abstract class ModelFunctionPanel
extends FunctionPanel {
    InitialValueEditor initEditor;
    ParticleModel model;

    public ModelFunctionPanel(UserFunctionEditor editor, ParticleModel track) {
        super(editor);
        this.model = track;
        this.setName(track.getName("model"));
    }

    @Override
    protected void init() {
        super.init();
        this.initEditor = new InitialValueEditor(this.getParamEditor());
        this.initEditor.addPropertyChangeListener(this);
        this.paramEditor.addPropertyChangeListener(this.initEditor);
        this.functionEditor.addPropertyChangeListener(this.initEditor);
        this.initEditor.addPropertyChangeListener(this.paramEditor);
        this.initEditor.addPropertyChangeListener(this.functionEditor);
        FunctionEditor[] editors = new FunctionEditor[]{this.functionEditor, this.initEditor};
        this.paramEditor.setFunctionEditors(editors);
    }

    @Override
    public void checkGUI() {
        if (this.haveGUI()) {
            return;
        }
        super.checkGUI();
        this.initEditor.checkGUI();
        this.paramEditor.checkGUI();
        this.functionEditor.checkGUI();
    }

    @Override
    protected void createGUI() {
        super.createGUI();
        this.box.add((Component)this.initEditor, 1);
        if (this.haveGUI()) {
            this.getParamEditor().setSyncing(true);
        }
    }

    @Override
    protected void refreshGUI() {
        if (!this.haveGUI()) {
            return;
        }
        super.refreshGUI();
        this.initEditor.refreshGUI();
    }

    @Override
    public String getLabel() {
        return TrackerRes.getString("ModelFunctionPanel.Label");
    }

    @Override
    public String getDisplayName() {
        if (this.model != null) {
            return this.model.getDisplayName();
        }
        return super.getDisplayName();
    }

    public UserFunctionEditor getUserFunctionEditor() {
        return (UserFunctionEditor)this.functionEditor;
    }

    public InitialValueEditor getInitEditor() {
        return this.initEditor;
    }

    @Override
    public Icon getIcon() {
        if (this.model != null) {
            return this.model.getIcon(21, 16, "model");
        }
        return null;
    }

    @Override
    protected void refreshFunctions() {
        if (this.paramEditor != null) {
            UserFunction[] functions = ((UserFunctionEditor)this.functionEditor).getMainFunctions();
            int i = 0;
            while (i < functions.length) {
                functions[i].setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                ++i;
            }
            functions = ((UserFunctionEditor)this.functionEditor).getSupportFunctions();
            i = 0;
            while (i < functions.length) {
                functions[i].setParameters(this.paramEditor.getNames(), this.paramEditor.getValues(), this.paramEditor.getDescriptions());
                ++i;
            }
        }
        this.initEditor.evaluateAll();
        this.functionEditor.evaluateAll();
    }

    @Override
    protected void clearSelection() {
        super.clearSelection();
        if (this.initEditor != null) {
            this.initEditor.getTable().clearSelection();
        }
    }

    @Override
    protected void dispose() {
        if (this.paramEditor == null) {
            return;
        }
        this.initEditor.removePropertyChangeListener(this);
        this.paramEditor.removePropertyChangeListener(this.initEditor);
        this.functionEditor.removePropertyChangeListener(this.initEditor);
        this.initEditor.removePropertyChangeListener(this.paramEditor);
        this.initEditor.removePropertyChangeListener(this.functionEditor);
        this.initEditor.setFunctionPanel(null);
        this.initEditor.setFunctionEditors(null);
        this.paramEditor.setFunctionEditors(null);
        this.model = null;
        super.dispose();
    }

    @Override
    protected void tabToNext(FunctionEditor editor) {
        if (editor == this.paramEditor) {
            this.initEditor.getTable().requestFocusInWindow();
        } else {
            super.tabToNext(editor);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        switch (e.getPropertyName()) {
            case "synced": {
                if (this.functionTool == null) break;
                ModelBuilder builder = (ModelBuilder)this.functionTool;
                builder.syncParameters((Parameter)e.getNewValue());
                break;
            }
            case "edit": {
                String paramName;
                Parameter param;
                if (e.getSource() != this.paramEditor) break;
                this.initEditor.getTable().selectOnFocus = false;
                if (this.functionTool == null || (param = (Parameter)this.paramEditor.getObject(paramName = (String)e.getOldValue())) == null || !param.isSynced() || !(e.getNewValue() instanceof FunctionEditor.DefaultEdit)) break;
                FunctionEditor.DefaultEdit edit = (FunctionEditor.DefaultEdit)e.getNewValue();
                if (edit.getEditType() == 3) {
                    ModelBuilder builder = (ModelBuilder)this.functionTool;
                    builder.syncParameters(param);
                    break;
                }
                if (edit.getEditType() != 2) break;
                param.setSynced(false);
                break;
            }
            case "angles_in_radians": {
                if (this.model.tp == null) break;
                this.model.tframe.setAnglesInRadians((Boolean)e.getNewValue());
            }
        }
    }

    @Override
    protected boolean hasInvalidExpressions() {
        return super.hasInvalidExpressions() || this.initEditor.containsInvalidExpressions();
    }
}

