/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.HashSet;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.MultiShape;

public class MultiLineFootprint
extends LineFootprint {
    protected boolean closed;
    private static Collection<LineFootprint> footprints = new HashSet<LineFootprint>();
    private static final MultiLineFootprint MULTILINE = new MultiLineFootprint("Footprint.MultiLine");
    private static final MultiLineFootprint BOLD_MULTILINE;

    static {
        footprints.add(MULTILINE);
        BOLD_MULTILINE = new MultiLineFootprint("Footprint.BoldMultiLine");
        BOLD_MULTILINE.setStroke(new BasicStroke(2.0f));
        footprints.add(BOLD_MULTILINE);
    }

    public MultiLineFootprint(String name) {
        super(name);
        this.hitShapes = new Shape[0];
    }

    public static MultiLineFootprint getFootprint(String name) {
        return (MultiLineFootprint)MultiLineFootprint.getFootprint(footprints, name);
    }

    @Override
    public int getLength() {
        return 1;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public MultiShape getShape(Point[] points, int scale) {
        if (this.stroke == null || this.stroke.getLineWidth() != (float)scale * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)scale * this.baseStroke.getLineWidth());
        }
        MultiShape drawShape = new MultiShape(new Shape[0]);
        int i = 0;
        while (i < points.length - 1) {
            Point p1 = points[i];
            Point p2 = points[i + 1];
            if (p1 != null && p2 != null) {
                this.line.setLine(p1, p2);
                drawShape.addDrawShape((Line2D)this.line.clone(), null);
            }
            ++i;
        }
        if (this.closed && points.length > 2 && points[0] != null && points[points.length - 1] != null) {
            this.line.setLine(points[points.length - 1], points[0]);
            drawShape.addDrawShape((Line2D)this.line.clone(), null);
        }
        return drawShape;
    }
}

