/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.TPoint;

public class MultiPositionStep
extends PositionStep {
    ParticleDataTrack dataTrack;

    public MultiPositionStep(ParticleDataTrack track, int n, double x, double y) {
        super(track, n, x, y);
        this.dataTrack = track;
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.panelMarks.get(trackerPanel.getID());
        if (mark == null) {
            Mark aMark = null;
            if (this.dataTrack.modelFootprintVisible) {
                ArrayList<ParticleDataTrack> tracks = this.dataTrack.morePoints;
                int n = tracks.size() + 1;
                Point[] screenPoints = new Point[n];
                int fn = this.getFrameNumber();
                screenPoints[0] = MultiPositionStep.getScreenPoint(trackerPanel, fn, this.dataTrack);
                int i = 1;
                while (i < n) {
                    screenPoints[i] = MultiPositionStep.getScreenPoint(trackerPanel, fn, tracks.get(i - 1));
                    ++i;
                }
                aMark = this.dataTrack.getModelFootprint().getMark(screenPoints);
            }
            final Mark modelMark = aMark;
            final Mark positionMark = super.getMark(trackerPanel);
            mark = new Mark(){

                @Override
                public void draw(Graphics2D g, boolean highlighted) {
                    if (!MultiPositionStep.this.valid) {
                        return;
                    }
                    if (modelMark != null) {
                        modelMark.draw(g, highlighted);
                    }
                    positionMark.draw(g, highlighted);
                }
            };
            this.panelMarks.put(trackerPanel.getID(), mark);
        }
        return mark;
    }

    private static Point getScreenPoint(TrackerPanel panel, int n, ParticleDataTrack next) {
        Step step = next.getStep(n);
        TPoint p = step == null ? null : step.getPoints()[0];
        return p == null || Double.isNaN(p.x) || Double.isNaN(p.y) ? null : p.getScreenPosition(panel);
    }

    @Override
    public Object clone() {
        MultiPositionStep step = (MultiPositionStep)super.clone();
        return step;
    }

    @Override
    public String toString() {
        return "MultiPositionStep " + this.n + " [" + format.format(this.p.x) + ", " + format.format(this.p.y) + "]";
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            PositionStep step = (PositionStep)obj;
            control.setValue("x", step.p.x);
            control.setValue("y", step.p.y);
        }

        @Override
        public Object createObject(XMLControl control) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            PositionStep step = (PositionStep)obj;
            double x = control.getDouble("x");
            double y = control.getDouble("y");
            step.p.setXY(x, y);
            return obj;
        }
    }
}

