/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.BitSet;

class MultiShape
implements Shape {
    private Shape[] shapes;
    private BitSet bsFills = new BitSet();
    private Stroke[] strokes;

    public MultiShape(Shape ... shapes) {
        this.shapes = shapes;
    }

    public MultiShape andFill(boolean ... fills) {
        int i = 0;
        while (i < fills.length) {
            if (fills[i]) {
                this.bsFills.set(i);
            }
            ++i;
        }
        return this;
    }

    public MultiShape andStroke(Stroke ... strokes) {
        this.strokes = strokes;
        return this;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle r = this.shapes[0].getBounds();
        int i = this.shapes.length;
        while (--i >= 1) {
            r = r.union(this.shapes[i].getBounds());
        }
        return r;
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D r = this.shapes[0].getBounds();
        int i = this.shapes.length;
        while (--i >= 1) {
            r = ((Rectangle2D)r).createUnion(this.shapes[i].getBounds());
        }
        return r;
    }

    @Override
    public boolean contains(double x, double y) {
        int i = this.shapes.length;
        while (--i >= 0) {
            if (!this.shapes[i].contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        int i = this.shapes.length;
        while (--i >= 0) {
            if (!this.shapes[i].contains(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        int i = this.shapes.length;
        while (--i >= 0) {
            if (!this.shapes[i].intersects(x, y, w, h)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        int i = this.shapes.length;
        while (--i >= 0) {
            if (!this.shapes[i].intersects(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        int i = this.shapes.length;
        while (--i >= 0) {
            if (!this.shapes[i].contains(x, y, w, h)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        int i = this.shapes.length;
        while (--i >= 0) {
            if (!this.shapes[i].contains(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.shapes[0].getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.shapes[0].getPathIterator(at, flatness);
    }

    public void draw(Graphics2D g) {
        int i = this.shapes.length;
        while (--i >= 0) {
            if (this.shapes[i] instanceof MultiShape) {
                ((MultiShape)this.shapes[i]).draw(g);
                continue;
            }
            if (this.bsFills.get(i)) {
                g.fill(this.shapes[i]);
                continue;
            }
            if (this.strokes != null && i < this.strokes.length && this.strokes[i] != null) {
                Stroke gstroke = g.getStroke();
                g.setStroke(this.strokes[i]);
                g.draw(this.shapes[i]);
                g.setStroke(gstroke);
                continue;
            }
            g.draw(this.shapes[i]);
        }
    }

    public MultiShape transform(AffineTransform transform) {
        Shape[] transformedShapes = new Shape[this.shapes.length];
        int i = 0;
        while (i < this.shapes.length) {
            transformedShapes[i] = this.shapes[i] instanceof MultiShape ? ((MultiShape)this.shapes[i]).transform(transform) : transform.createTransformedShape(this.shapes[i]);
            ++i;
        }
        MultiShape shape = new MultiShape(transformedShapes);
        shape.bsFills = (BitSet)this.bsFills.clone();
        if (this.strokes != null) {
            shape.andStroke(this.strokes);
        }
        return shape;
    }

    public MultiShape addDrawShape(Shape shape, Stroke stroke) {
        if (shape != null) {
            int newLength = this.shapes.length + 1;
            this.shapes = Arrays.copyOf(this.shapes, newLength);
            this.shapes[newLength - 1] = shape;
            if (stroke != null) {
                this.strokes = this.strokes != null ? Arrays.copyOf(this.strokes, newLength) : new Stroke[newLength];
                this.strokes[newLength - 1] = stroke;
            }
        }
        return this;
    }

    public MultiShape addFillShape(Shape shape) {
        if (shape != null) {
            int newLength = this.shapes.length;
            this.bsFills.set(newLength++);
            this.shapes = Arrays.copyOf(this.shapes, newLength);
            this.shapes[newLength - 1] = shape;
        }
        return this;
    }
}

