/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackRenderer;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.tools.FontSizer;

public class NumberFormatDialog
extends JDialog {
    protected static String noPattern = TrackerRes.getString("NumberFormatSetter.NoPattern");
    protected static String mixedPattern = TrackerRes.getString("NumberFormatSetter.MixedPattern");
    private static Dimension scrollerDimension = new Dimension(200, 60);
    private Integer panelID;
    private TFrame frame;
    int trackID = -1;
    JButton closeButton;
    JButton helpButton;
    JButton revertButton;
    JComboBox<Object> trackDropdown;
    JLabel patternLabel;
    JLabel sampleLabel;
    JTextField patternField;
    NumberField sampleField;
    DecimalFormat testFormat;
    String[] displayedNames = new String[0];
    Map<String, String> realNames = new HashMap<String, String>();
    Map<TTrack, TreeMap<String, String>> prevTrackPatterns = new HashMap<TTrack, TreeMap<String, String>>();
    JPanel variablePanel;
    JPanel applyToPanel;
    JPanel unitsPanel;
    JPanel decimalSeparatorPanel;
    JList<String> variableList = new JList();
    JScrollPane variableScroller;
    JRadioButton trackOnlyButton;
    JRadioButton trackTypeButton;
    JRadioButton dimensionButton;
    JRadioButton defaultDecimalButton;
    JRadioButton periodDecimalButton;
    JRadioButton commaDecimalButton;
    String prevPattern;
    String prevDecimalSeparator;
    TitledBorder variablesBorder;
    TitledBorder applyToBorder;
    TitledBorder decimalSeparatorBorder;
    boolean formatsChanged;
    boolean prevAnglesInRadians;
    Map<Integer, String[]> trackSelectedVariables = new TreeMap<Integer, String[]>();

    protected static NumberFormatDialog getNumberFormatDialog(TrackerPanel trackerPanel, TTrack track, String[] selectedNames) {
        NumberFormatDialog dialog = trackerPanel.numberFormatDialog;
        if (dialog == null) {
            trackerPanel.numberFormatDialog = dialog = new NumberFormatDialog(trackerPanel.getTFrame(), trackerPanel.getID());
            dialog.setFontLevel(FontSizer.getLevel());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - dialog.getBounds().width) / 2;
            int y = (dim.height - dialog.getBounds().height) / 2;
            dialog.setLocation(x, y);
        }
        dialog.savePrevious();
        if (selectedNames != null) {
            HashSet<String> namesToSelect = new HashSet<String>();
            ArrayList<String> displayNames = NumberFormatDialog.getDisplayNames(track);
            Map<String, String[]> map = track.getFormatMap();
            String[] stringArray = selectedNames;
            int n = selectedNames.length;
            int n2 = 0;
            while (n2 < n) {
                String var = stringArray[n2];
                int k = var.indexOf("_{ ");
                if (k > 0) {
                    var = var.substring(0, k);
                }
                namesToSelect.add(NumberFormatDialog.getDisplayName(var, displayNames, map));
                ++n2;
            }
            selectedNames = namesToSelect.toArray(new String[0]);
        }
        if (track == null) {
            ArrayList<TTrack> tracks = trackerPanel.getUserTracks();
            if (tracks.size() > 0) {
                track = tracks.get(0);
            } else {
                tracks = trackerPanel.getTracksTemp();
                if (tracks.size() > 0) {
                    track = tracks.get(0);
                }
                trackerPanel.clearTemp();
            }
        }
        if (track != null) {
            dialog.trackSelectedVariables.put(track.getID(), selectedNames);
        }
        dialog.setTrack(track);
        dialog.setFontLevel(FontSizer.getLevel());
        return dialog;
    }

    private NumberFormatDialog(TFrame frame, Integer panelID) {
        super((Frame)frame, true);
        this.frame = frame;
        this.panelID = panelID;
        this.createGUI();
        this.refreshGUI();
    }

    public void finalize() {
        OSPLog.finalized(this);
    }

    private void setVariables(final TTrack track, ArrayList<String> names, String[] selected) {
        if (selected != null) {
            TreeSet<String> select = new TreeSet<String>();
            String[] stringArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                if (next != null && next.startsWith(Tracker.THETA)) {
                    next = Tracker.THETA;
                }
                select.add(next);
                ++n2;
            }
            selected = select.toArray(new String[select.size()]);
        }
        this.displayedNames = new String[names.size()];
        this.realNames.clear();
        int len = 5;
        for (String s : names) {
            s = TeXParser.removeSubscripting(s);
            len = Math.max(len, s.length());
        }
        int i = 0;
        while (i < names.size()) {
            String s = TeXParser.removeSubscripting(names.get(i));
            this.displayedNames[i] = "   " + s;
            int j = 0;
            while (j < len + 1 - s.length()) {
                int n = i;
                this.displayedNames[n] = String.valueOf(this.displayedNames[n]) + " ";
                ++j;
            }
            this.realNames.put(this.displayedNames[i], names.get(i));
            if (selected != null) {
                j = 0;
                while (j < selected.length) {
                    if (selected[j] != null && selected[j].equals(names.get(i))) {
                        selected[j] = this.displayedNames[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.variableList = new JList<String>(this.displayedNames);
        this.variableList.setLayoutOrientation(2);
        this.variableList.setVisibleRowCount(-1);
        this.variableList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int[] indices = NumberFormatDialog.this.variableList.getSelectedIndices();
                    NumberFormatDialog.this.showNumberFormatAndSample(indices);
                    String[] vars = NumberFormatDialog.this.getSelectedVariables(indices);
                    NumberFormatDialog.this.trackSelectedVariables.put(NumberFormatDialog.this.trackID, vars);
                    NumberFormatDialog.this.refreshGUI();
                }
            }
        });
        this.variableList.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = NumberFormatDialog.this.variableList.locationToIndex(e.getPoint());
                if (index == -1) {
                    return;
                }
                String displayedName = NumberFormatDialog.this.variableList.getModel().getElementAt(index);
                String name = NumberFormatDialog.this.realNames.get(displayedName);
                String desc = track.getFormatDescMap().get(name);
                NumberFormatDialog.this.variableList.setToolTipText(desc == null ? name : desc);
            }
        });
        this.variableScroller.setViewportView(this.variableList);
        FontSizer.setFonts(this.variableList, FontSizer.getLevel());
        int[] indices = null;
        if (selected != null) {
            indices = new int[selected.length];
            int j = 0;
            while (j < indices.length) {
                int i2 = 0;
                while (i2 < this.displayedNames.length) {
                    if (this.displayedNames[i2].equals(selected[j])) {
                        indices[j] = i2;
                        break;
                    }
                    ++i2;
                }
                ++j;
            }
            this.variableList.setSelectedIndices(indices);
        } else {
            this.showNumberFormatAndSample(indices);
        }
        this.refreshGUI();
    }

    private void applyPattern(String pattern) {
        if (pattern.equals(this.prevPattern)) {
            return;
        }
        if (pattern.indexOf(noPattern) > -1) {
            pattern = "";
        }
        if ((pattern = pattern.replaceAll(",", ".")).length() > 1 && (noPattern.startsWith(pattern) || mixedPattern.startsWith(pattern))) {
            pattern = "";
        }
        if ((pattern = pattern.replaceAll("e", "E")).indexOf("E") != pattern.lastIndexOf("E")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (pattern.equals("E")) {
            pattern = "0E0";
        } else if (pattern.equals("0E") || pattern.equals("E0")) {
            pattern = this.prevPattern.length() > pattern.length() ? "0" : "0E0";
        } else if (pattern.contains("0.E")) {
            pattern = this.prevPattern.length() > pattern.length() ? pattern.replaceAll("0.E", "0E") : pattern.replaceAll("0.E", "0.0E");
        }
        if (pattern.contains("E") && pattern.endsWith("0.")) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (pattern.endsWith("0E")) {
            pattern = this.prevPattern.length() > pattern.length() ? pattern.substring(0, pattern.length() - 1) : String.valueOf(pattern.substring(0, pattern.length() - 1)) + "E0";
        }
        boolean validPattern = true;
        try {
            pattern = pattern.replaceAll("0E", "0e");
            pattern = pattern.replaceAll("E0", "e0");
            this.testFormat.applyPattern(pattern);
            pattern = pattern.replaceAll("0e", "0E");
            pattern = pattern.replaceAll("e0", "E0");
        }
        catch (Exception ex) {
            validPattern = false;
        }
        if (validPattern) {
            try {
                int[] indices = this.variableList.getSelectedIndices();
                Object[] selected = new Object[indices.length];
                int j = 0;
                while (j < indices.length) {
                    selected[j] = this.displayedNames[indices[j]];
                    ++j;
                }
                Object[] objectArray = selected;
                int n = selected.length;
                int n2 = 0;
                while (n2 < n) {
                    Object displayedName = objectArray[n2];
                    String name = this.realNames.get(displayedName.toString());
                    this.setFormatPattern(name, pattern);
                    ++n2;
                }
                this.patternField.setText(pattern);
                this.prevPattern = pattern;
            }
            catch (Exception ex) {
                this.patternField.setText(this.prevPattern);
            }
        } else {
            this.patternField.setText(this.prevPattern);
        }
        TTrack track = TTrack.getTrack(this.trackID);
        if (track == null) {
            this.showNumberFormatAndSample(pattern, false);
        } else {
            this.showNumberFormatAndSample(this.variableList.getSelectedIndices());
        }
    }

    private String[] getCurrentDimensions() {
        TTrack track = TTrack.getTrack(this.trackID);
        if (track == null) {
            return new String[0];
        }
        TreeSet<String> dimensions = new TreeSet<String>();
        int[] indices = this.variableList.getSelectedIndices();
        Object[] selected = new Object[indices.length];
        int j = 0;
        while (j < indices.length) {
            selected[j] = this.displayedNames[indices[j]];
            ++j;
        }
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object displayedName = objectArray[n2];
            String name = this.realNames.get(displayedName.toString());
            String dim = TTrack.getVariableDimensions(track, name);
            if (dim != null) {
                dimensions.add(dim);
            }
            ++n2;
        }
        return dimensions.toArray(new String[dimensions.size()]);
    }

    private static ArrayList<String> getDisplayNames(TTrack track) {
        if (track == null || track.tp == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> names = new ArrayList<String>();
        String[] vars = track.getFormatVariables();
        if (vars.length > 0) {
            String[] stringArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!"I".equals(TTrack.getVariableDimensions(track, name))) {
                    names.add(name);
                }
                ++n2;
            }
            DatasetManager data = track.getData(track.tp);
            int i = 0;
            int n3 = data.getDatasetsRaw().size();
            while (i < n3) {
                Dataset dataset = data.getDataset(i);
                if (dataset instanceof DataFunction) {
                    names.add(dataset.getYColumnName());
                }
                ++i;
            }
        }
        return names;
    }

    private static String getDisplayName(String var, ArrayList<String> displayNames, Map<String, String[]> map) {
        if (displayNames.contains(var)) {
            return var;
        }
        for (String name : map.keySet()) {
            String[] vars = map.get(name);
            if (!NumberFormatDialog.has(vars, var)) continue;
            return name;
        }
        return var;
    }

    private static boolean has(String[] a, String v) {
        int i = a.length;
        while (--i >= 0) {
            if (!a[i].equals(v)) continue;
            return true;
        }
        return false;
    }

    private void setTrack(TTrack track) {
        if (track == null) {
            this.showNumberFormatAndSample("", false);
            this.refreshGUI();
            return;
        }
        this.trackID = track.getID();
        ArrayList<String> names = NumberFormatDialog.getDisplayNames(track);
        String[] selected = this.trackSelectedVariables.get(this.trackID);
        this.setVariables(track, names, selected == null ? new String[]{} : selected);
    }

    private void savePrevious() {
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        TTrack.savePatterns(trackerPanel);
        this.prevTrackPatterns.clear();
        TrackerPanel panel = this.frame.getTrackerPanelForID(this.panelID);
        for (TTrack next : panel.getTracksTemp()) {
            TreeMap<String, String> patterns = new TreeMap<String, String>();
            for (String name : TTrack.getAllVariables(next.ttype)) {
                patterns.put(name, next.getVarFormatPattern(name));
            }
            this.prevTrackPatterns.put(next, patterns);
        }
        panel.clearTemp();
        this.prevAnglesInRadians = this.frame.isAnglesInRadians();
        this.prevDecimalSeparator = OSPRuntime.getPreferredDecimalSeparator();
        this.formatsChanged = false;
    }

    private void setFormatPattern(String displayName, String pattern) {
        boolean wasChanged = this.formatsChanged;
        TTrack track = TTrack.getTrack(this.trackID);
        if (this.dimensionButton.isSelected()) {
            String dimensions = TTrack.getVariableDimensions(track, displayName);
            BitSet known = new BitSet();
            if (dimensions != null) {
                ArrayList<TTrack> tracks = track.tp.getTracksTemp();
                for (TTrack t : tracks) {
                    if (known.get(t.ttype)) continue;
                    known.set(t.ttype);
                    TreeMap<String, String> patterns = track.tp.getFormatPatterns(t.ttype);
                    for (String nextName : patterns.keySet()) {
                        if (!dimensions.equals(TTrack.getVariableDimensions(t, nextName)) || pattern.equals(patterns.get(nextName))) continue;
                        patterns.put(nextName, pattern);
                        this.formatsChanged = true;
                    }
                }
                for (TTrack t : tracks) {
                    boolean trackChanged = false;
                    for (String nextDisplayName : NumberFormatDialog.getDisplayNames(track)) {
                        if (!dimensions.equals(TTrack.getVariableDimensions(track, nextDisplayName)) || !t.setFormatPattern(nextDisplayName, pattern)) continue;
                        trackChanged = true;
                    }
                    if (!trackChanged) continue;
                    this.formatsChanged = true;
                }
                TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
                trackerPanel.clearTemp();
            } else {
                if (track.setFormatPattern(displayName, pattern)) {
                    this.formatsChanged = true;
                }
                ArrayList<TTrack> tracks = track.tp.getTracks();
                for (TTrack t : tracks) {
                    for (String var : NumberFormatDialog.getDisplayNames(t)) {
                        if (!var.equals(displayName) || TTrack.getVariableDimensions(t, displayName) != null || !t.setFormatPattern(displayName, pattern)) continue;
                        this.formatsChanged = true;
                    }
                }
            }
        } else if (this.trackTypeButton.isSelected()) {
            String trackType = track.getBaseType();
            ArrayList<TTrack> tracks = track.tp.getTracks();
            for (TTrack t : tracks) {
                if (t.getBaseType() != trackType || !t.setFormatPattern(displayName, pattern)) continue;
                this.formatsChanged = true;
            }
            TreeMap<String, String> patterns = track.tp.getFormatPatterns(track.ttype);
            patterns.put(displayName, pattern);
        } else if (track.setFormatPattern(displayName, pattern)) {
            this.formatsChanged = true;
        }
        if (!wasChanged && this.formatsChanged) {
            this.refreshGUI();
        }
        if (this.formatsChanged) {
            track.firePropertyChange("format", null, null);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void setFontLevel(int level) {
        FontSizer.setFonts(this, FontSizer.getLevel());
        double f = FontSizer.getFactor();
        Dimension dim = new Dimension((int)((double)NumberFormatDialog.scrollerDimension.width * f), (int)((double)NumberFormatDialog.scrollerDimension.height * f));
        this.variableScroller.setPreferredSize(dim);
        this.refreshDropdown();
        this.pack();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.testFormat = (DecimalFormat)NumberFormat.getNumberInstance();
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberFormatDialog.this.setVisible(false);
            }
        });
        this.revertButton = new JButton();
        AbstractAction resetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TTrack track = TTrack.getTrack(NumberFormatDialog.this.trackID);
                TrackerPanel trackerPanel = NumberFormatDialog.this.frame.getTrackerPanelForID(NumberFormatDialog.this.panelID);
                TTrack.restorePatterns(trackerPanel);
                ArrayList<TTrack> tracks = track.tp.getTracks();
                for (TTrack next : tracks) {
                    TreeMap<String, String> patterns = NumberFormatDialog.this.prevTrackPatterns.get(next);
                    if (patterns == null) continue;
                    boolean fireEvent = false;
                    ArrayList<String> names = TTrack.getAllVariables(next.ttype);
                    for (String name : names) {
                        boolean bl = fireEvent = next.setFormatPattern(name, patterns.get(name)) || fireEvent;
                        if (!fireEvent) continue;
                        next.firePropertyChange("data", null, null);
                    }
                }
                OSPRuntime.setPreferredDecimalSeparator(NumberFormatDialog.this.prevDecimalSeparator);
                track.tframe.setAnglesInRadians(NumberFormatDialog.this.prevAnglesInRadians);
                NumberFormatDialog.this.showNumberFormatAndSample(NumberFormatDialog.this.variableList.getSelectedIndices());
                NumberFormatDialog.this.prevPattern = "";
                NumberFormatDialog.this.formatsChanged = false;
                NumberFormatDialog.this.refreshGUI();
            }
        };
        this.revertButton.addActionListener(resetAction);
        this.helpButton = new JButton();
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tab = "      ";
                String nl = System.getProperty("line.separator", "/n");
                JOptionPane.showMessageDialog(NumberFormatDialog.this, String.valueOf(DisplayRes.getString("DataTable.NumberFormat.Help.Message1")) + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message2") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message3") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message4") + nl + tab + DisplayRes.getString("DataTable.NumberFormat.Help.Message5") + nl + nl + DisplayRes.getString("DataTable.NumberFormat.Help.Message6") + " PI." + nl + nl + TrackerRes.getString("NumberFormatSetter.Help.Dimensions.1") + nl + tab + TrackerRes.getString("NumberFormatSetter.Help.Dimensions.2") + nl + tab + TrackerRes.getString("NumberFormatSetter.Help.Dimensions.3") + nl + tab + TrackerRes.getString("NumberFormatSetter.Help.Dimensions.4") + nl + tab + TrackerRes.getString("NumberFormatSetter.Help.Dimensions.5") + nl + tab + TrackerRes.getString("NumberFormatSetter.Help.Dimensions.6") + nl + tab + TrackerRes.getString("NumberFormatSetter.Help.Dimensions.7") + nl + tab + TrackerRes.getString("NumberFormatSetter.Help.Dimensions.8") + nl, DisplayRes.getString("DataTable.NumberFormat.Help.Title"), 1);
            }
        });
        this.trackDropdown = new JComboBox<Object>(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                --dim.height;
                return dim;
            }
        };
        this.trackDropdown.setRenderer(new TrackRenderer());
        this.trackDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrackerPanel trackerPanel;
                TTrack t;
                if ("refresh".equals(NumberFormatDialog.this.trackDropdown.getName())) {
                    return;
                }
                Object[] item = (Object[])NumberFormatDialog.this.trackDropdown.getSelectedItem();
                if (item != null && (t = (trackerPanel = NumberFormatDialog.this.frame.getTrackerPanelForID(NumberFormatDialog.this.panelID)).getTrackByName(TTrack.class, (String)item[1])) != null) {
                    NumberFormatDialog.this.setTrack(t);
                    NumberFormatDialog.this.refreshGUI();
                }
            }
        });
        this.patternLabel = new JLabel();
        this.sampleLabel = new JLabel();
        this.patternField = new JTextField(6);
        this.patternField.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberFormatDialog.this.applyPattern(NumberFormatDialog.this.patternField.getText());
            }
        });
        this.patternField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                boolean revert;
                boolean bl = revert = e.getKeyCode() != 10 && e.getKeyCode() != 48 && e.getKeyCode() != 69 && e.getKeyCode() != 39 && e.getKeyCode() != 37 && e.getKeyCode() != 8 && e.getKeyCode() != 127 && e.getKeyCode() != 46 && e.getKeyCode() != 44;
                if (e.getKeyCode() == 10) {
                    NumberFormatDialog.this.patternField.setBackground(Color.white);
                    if (TTrack.getTrack(NumberFormatDialog.this.trackID) != null) {
                        NumberFormatDialog.this.showNumberFormatAndSample(NumberFormatDialog.this.variableList.getSelectedIndices());
                    } else {
                        NumberFormatDialog.this.showNumberFormatAndSample(NumberFormatDialog.this.patternField.getText(), false);
                    }
                } else {
                    NumberFormatDialog.this.patternField.setBackground(Color.yellow);
                    Runnable runner = new Runnable(){

                        @Override
                        public void run() {
                            if (revert) {
                                (this).NumberFormatDialog.this.patternField.setText((this).NumberFormatDialog.this.prevPattern);
                            }
                            NumberFormatDialog.this.applyPattern((this).NumberFormatDialog.this.patternField.getText());
                        }
                    };
                    SwingUtilities.invokeLater(runner);
                }
            }
        });
        this.patternField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (NumberFormatDialog.this.patternField.getBackground() == Color.yellow) {
                    NumberFormatDialog.this.patternField.setBackground(Color.white);
                    NumberFormatDialog.this.patternField.getAction().actionPerformed(null);
                }
            }
        });
        this.sampleField = new NumberField(6);
        this.sampleField.setEditable(false);
        this.variableScroller = new JScrollPane();
        this.variableScroller.setPreferredSize(scrollerDimension);
        this.trackOnlyButton = new JRadioButton();
        this.trackTypeButton = new JRadioButton();
        this.dimensionButton = new JRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.trackOnlyButton);
        group.add(this.trackTypeButton);
        group.add(this.dimensionButton);
        this.trackOnlyButton.setSelected(true);
        AbstractAction decimalSeparatorAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String separator = NumberFormatDialog.this.periodDecimalButton.isSelected() ? String.valueOf('.') : (NumberFormatDialog.this.commaDecimalButton.isSelected() ? String.valueOf(',') : null);
                OSPRuntime.setPreferredDecimalSeparator(separator);
                NumberFormatDialog.this.sampleField.refreshDecimalSeparators(true);
                NumberFormatDialog.this.showNumberFormatAndSample(NumberFormatDialog.this.variableList.getSelectedIndices());
                TrackerPanel trackerPanel = NumberFormatDialog.this.frame.getTrackerPanelForID(NumberFormatDialog.this.panelID);
                trackerPanel.refreshDecimalSeparators();
                if (NumberFormatDialog.this.prevDecimalSeparator != null && !NumberFormatDialog.this.prevDecimalSeparator.equals(separator) || separator != null && !separator.equals(NumberFormatDialog.this.prevDecimalSeparator)) {
                    NumberFormatDialog.this.formatsChanged = true;
                }
                NumberFormatDialog.this.refreshGUI();
            }
        };
        this.defaultDecimalButton = new JRadioButton();
        this.defaultDecimalButton.addActionListener(decimalSeparatorAction);
        this.periodDecimalButton = new JRadioButton();
        this.periodDecimalButton.addActionListener(decimalSeparatorAction);
        this.commaDecimalButton = new JRadioButton();
        this.commaDecimalButton.addActionListener(decimalSeparatorAction);
        group = new ButtonGroup();
        group.add(this.defaultDecimalButton);
        group.add(this.periodDecimalButton);
        group.add(this.commaDecimalButton);
        this.variablesBorder = BorderFactory.createTitledBorder(TrackerRes.getString("NumberFormatSetter.ApplyToVariables.Text"));
        this.applyToBorder = BorderFactory.createTitledBorder(TrackerRes.getString("NumberFormatSetter.TitledBorder.ApplyTo.Text"));
        this.decimalSeparatorBorder = BorderFactory.createTitledBorder(TrackerRes.getString("NumberFormatSetter.TitledBorder.DecimalSeparator.Text"));
        JPanel formatPanel = new JPanel(new GridLayout());
        JPanel patternPanel = new JPanel();
        patternPanel.add(this.patternLabel);
        patternPanel.add(this.patternField);
        formatPanel.add(patternPanel);
        JPanel samplePanel = new JPanel();
        samplePanel.add(this.sampleLabel);
        samplePanel.add(this.sampleField);
        formatPanel.add(samplePanel);
        this.add((Component)formatPanel, "North");
        this.variablePanel = new JPanel(new BorderLayout());
        this.variablePanel.setBorder(this.variablesBorder);
        JPanel dropdownPanel = new JPanel();
        dropdownPanel.add(this.trackDropdown);
        this.variablePanel.add((Component)dropdownPanel, "North");
        this.variablePanel.add((Component)this.variableScroller, "Center");
        this.add((Component)this.variablePanel, "Center");
        JPanel south = new JPanel(new BorderLayout());
        this.add((Component)south, "South");
        this.applyToPanel = new JPanel();
        this.applyToPanel.setBorder(this.applyToBorder);
        Box box = Box.createVerticalBox();
        box.add(this.trackOnlyButton);
        box.add(this.trackTypeButton);
        box.add(this.dimensionButton);
        this.applyToPanel.add(box);
        south.add((Component)this.applyToPanel, "North");
        this.decimalSeparatorPanel = new JPanel();
        this.decimalSeparatorPanel.setBorder(this.decimalSeparatorBorder);
        this.decimalSeparatorPanel.add(this.defaultDecimalButton);
        this.decimalSeparatorPanel.add(this.commaDecimalButton);
        this.decimalSeparatorPanel.add(this.periodDecimalButton);
        south.add((Component)this.decimalSeparatorPanel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.helpButton);
        buttonPanel.add(this.revertButton);
        buttonPanel.add(this.closeButton);
        south.add((Component)buttonPanel, "South");
        this.pack();
    }

    private void refreshGUI() {
        Object dim;
        this.setTitle(TrackerRes.getString("NumberFormatSetter.Title"));
        noPattern = TrackerRes.getString("NumberFormatSetter.NoPattern");
        mixedPattern = TrackerRes.getString("NumberFormatSetter.MixedPattern");
        this.closeButton.setText(DisplayRes.getString("GUIUtils.Ok"));
        this.revertButton.setText(TrackerRes.getString("NumberFormatSetter.Button.Revert"));
        this.revertButton.setEnabled(this.formatsChanged);
        this.helpButton.setText(DisplayRes.getString("GUIUtils.Help"));
        this.patternLabel.setText(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Format"));
        this.sampleLabel.setText(DisplayRes.getString("DataTable.NumberFormat.Dialog.Label.Sample"));
        this.defaultDecimalButton.setText(TrackerRes.getString("NumberFormatSetter.Button.DecimalSeparator.Default"));
        this.periodDecimalButton.setText(TrackerRes.getString("NumberFormatSetter.Button.DecimalSeparator.Period"));
        this.commaDecimalButton.setText(TrackerRes.getString("NumberFormatSetter.Button.DecimalSeparator.Comma"));
        this.defaultDecimalButton.setSelected(OSPRuntime.getPreferredDecimalSeparator() == null);
        this.periodDecimalButton.setSelected(String.valueOf('.').equals(OSPRuntime.getPreferredDecimalSeparator()));
        this.commaDecimalButton.setSelected(String.valueOf(',').equals(OSPRuntime.getPreferredDecimalSeparator()));
        TTrack track = TTrack.getTrack(this.trackID);
        this.refreshDropdown();
        String trackName = track == null ? "" : track.getName();
        String trackType = track == null ? null : NumberFormatDialog.getTrackType(track);
        String trackTypeName = trackType == null ? "" : trackType;
        String s = TrackerRes.getString("NumberFormatSetter.Button.ApplyToTrackOnly.Text");
        this.trackOnlyButton.setText(String.valueOf(s) + (track == null ? "" : " (" + trackName + ")"));
        s = TrackerRes.getString("NumberFormatSetter.Button.ApplyToTrackType.Text");
        this.trackTypeButton.setText(String.valueOf(s) + " " + trackTypeName);
        s = TrackerRes.getString("NumberFormatSetter.Button.ApplyToDimension.Text");
        String[] dimensions = this.getCurrentDimensions();
        if (dimensions.length == 0) {
            this.dimensionButton.setText(s);
        } else if (dimensions.length == 1 && !"".equals(dimensions[0])) {
            this.dimensionButton.setText(String.valueOf(s) + " \"" + dimensions[0] + "\"");
        } else {
            dim = dimensions[0];
            int i = 1;
            while (i < dimensions.length) {
                if ((String.valueOf(dim) + ", " + dimensions[i]).length() > 7) {
                    dim = String.valueOf(dim) + ", " + TrackerRes.getString("NumberFormatSetter.DimensionList.More");
                    break;
                }
                dim = String.valueOf(dim) + ", " + dimensions[i];
                ++i;
            }
            this.dimensionButton.setText(String.valueOf(s) + " " + (String)dim);
        }
        this.trackOnlyButton.setEnabled(track != null);
        this.trackTypeButton.setEnabled(track != null);
        this.dimensionButton.setEnabled(track != null);
        this.variablesBorder.setTitle(TrackerRes.getString("NumberFormatSetter.ApplyToVariables.Text"));
        this.applyToBorder.setTitle(TrackerRes.getString("NumberFormatSetter.TitledBorder.ApplyTo.Text"));
        this.decimalSeparatorBorder.setTitle(TrackerRes.getString("NumberFormatSetter.TitledBorder.DecimalSeparator.Text"));
        dim = this.getSize();
        if (((Dimension)dim).width > this.getMinimumSize().width) {
            this.setSize((Dimension)dim);
        } else {
            this.pack();
        }
    }

    private void refreshDropdown() {
        Object[] toSelect = null;
        this.trackDropdown.setName("refresh");
        this.trackDropdown.removeAllItems();
        TTrack track = TTrack.getTrack(this.trackID);
        TrackerPanel trackerPanel = this.frame.getTrackerPanelForID(this.panelID);
        for (TTrack next : trackerPanel.getTracksTemp()) {
            ResizableIcon icon = next.getFootprint().getIcon(21, 16);
            Object[] item = new Object[]{icon, next.getName()};
            this.trackDropdown.addItem(item);
            if (next != track) continue;
            toSelect = item;
        }
        trackerPanel.clearTemp();
        if (toSelect == null) {
            Object[] objectArray = new Object[2];
            objectArray[1] = "           ";
            Object[] emptyItem = objectArray;
            this.trackDropdown.insertItemAt(emptyItem, 0);
            toSelect = emptyItem;
        }
        this.trackDropdown.setSelectedItem(toSelect);
        this.trackDropdown.setName(null);
    }

    private void showNumberFormatAndSample(int[] selectedIndices) {
        TTrack track = TTrack.getTrack(this.trackID);
        if (selectedIndices == null || selectedIndices.length == 0) {
            this.showNumberFormatAndSample("", false);
        } else if (selectedIndices.length == 1) {
            String name = this.realNames.get(this.displayedNames[selectedIndices[0]]);
            String pattern = track.getVarFormatPattern(name);
            boolean degrees = name.startsWith(Tracker.THETA) && !track.tframe.isAnglesInRadians();
            this.showNumberFormatAndSample(pattern, degrees);
        } else {
            String name = this.realNames.get(this.displayedNames[selectedIndices[0]]);
            boolean degrees = name.startsWith(Tracker.THETA) && !track.tframe.isAnglesInRadians();
            String pattern = track.getVarFormatPattern(name);
            if (degrees && (pattern == null || "".equals(pattern))) {
                pattern = "0.0";
            }
            int i = 1;
            while (i < selectedIndices.length) {
                name = this.realNames.get(this.displayedNames[selectedIndices[i]]);
                degrees = degrees && name.startsWith(Tracker.THETA);
                String selectedPattern = track.getVarFormatPattern(name);
                if (degrees && (selectedPattern == null || "".equals(selectedPattern))) {
                    selectedPattern = "0.0";
                }
                if (!pattern.equals(selectedPattern)) {
                    pattern = null;
                    break;
                }
                ++i;
            }
            if (degrees && "0.0".equals(pattern)) {
                pattern = "";
            }
            this.showNumberFormatAndSample(pattern, degrees);
        }
    }

    private String[] getSelectedVariables(int[] selectedIndices) {
        if (selectedIndices == null) {
            return new String[0];
        }
        String[] selectedNames = new String[selectedIndices.length];
        int i = 0;
        while (i < selectedIndices.length) {
            selectedNames[i] = this.realNames.get(this.displayedNames[selectedIndices[i]]);
            ++i;
        }
        return selectedNames;
    }

    private void showNumberFormatAndSample(String pattern, boolean degrees) {
        boolean none;
        if (pattern == null) {
            this.sampleField.setText("");
            this.patternField.setText(mixedPattern);
            return;
        }
        boolean bl = none = pattern.equals("") || pattern.equals(noPattern);
        this.sampleField.setFixedPattern(!none ? pattern : (degrees ? "0.0" : null));
        this.sampleField.setUnits(degrees ? "\u00b0" : null);
        this.sampleField.setValue(degrees ? 180.0 : Math.PI);
        if (this.patternField.getBackground().equals(Color.WHITE)) {
            this.patternField.setText(none ? noPattern : pattern);
        }
    }

    protected static String getTrackType(TTrack track) {
        return track.getBaseType();
    }

    @Override
    public void dispose() {
        this.clear();
        super.dispose();
    }

    public void clear() {
        this.setVisible(false);
        this.frame = null;
        this.panelID = null;
    }
}

