/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.MarkingRequired;
import org.opensourcephysics.cabrillo.tracker.OffsetOriginStep;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.FontSizer;

public class OffsetOrigin
extends TTrack
implements MarkingRequired {
    protected static final String[] dataVariables = new String[]{"x", "y"};
    protected static final String[] formatVariables = new String[]{"xy"};
    protected static final Map<String, String[]> formatMap = new HashMap<String, String[]>();
    protected static final Map<String, String> formatDescriptionMap;
    protected static final ArrayList<String> allVariables;
    private Component separator;
    protected boolean fixedCoordinates = true;
    protected JCheckBoxMenuItem fixedCoordinatesItem;
    protected JLabel unmarkedLabel;

    static {
        formatMap.put("xy", dataVariables);
        formatDescriptionMap = new HashMap<String, String>();
        formatDescriptionMap.put(formatVariables[0], TrackerRes.getString("PointMass.Position.Name"));
        allVariables = OffsetOrigin.createAllVariables(dataVariables, null);
    }

    @Override
    public Map<String, String[]> getFormatMap() {
        return formatMap;
    }

    @Override
    public String[] getFormatVariables() {
        return formatVariables;
    }

    @Override
    public Map<String, String> getFormatDescMap() {
        return formatDescriptionMap;
    }

    @Override
    public String getBaseType() {
        return "OffsetOrigin";
    }

    @Override
    public String getVarDimsImpl(String variable) {
        return "L";
    }

    public OffsetOrigin() {
        super(4);
        this.defaultColors = new Color[]{Color.cyan, Color.magenta, Color.yellow.darker()};
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.BoldCrosshair"), PointShapeFootprint.getFootprint("Footprint.Crosshair")});
        this.defaultFootprint = this.getFootprint();
        this.setName(TrackerRes.getString("OffsetOrigin.New.Name"));
        this.setColor(this.defaultColors[0]);
        this.viewable = false;
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("OffsetOrigin.Unmarked.Hint");
        this.keyFrames.add(0);
        this.createGUI();
    }

    @Override
    public Step createStep(int n, double x, double y) {
        if (this.isLocked()) {
            return null;
        }
        OffsetOriginStep step = (OffsetOriginStep)this.getStep(n);
        if (step == null) {
            step = new OffsetOriginStep(this, n, x, y);
            step.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, step);
            this.firePropertyChange("step", null, new Integer(n));
        } else if (this.tp != null) {
            XMLControlElement currentState = new XMLControlElement(this);
            OffsetOriginStep.Position p = step.getPosition();
            p.setLocation(x, y);
            Point2D pt = p.getWorldPosition(this.tp);
            step.worldX = pt.getX();
            step.worldY = pt.getY();
            this.keyFrames.add(n);
            Undo.postTrackEdit(this, currentState);
        }
        return step;
    }

    @Override
    public TPoint autoMarkAt(int n, double x, double y) {
        OffsetOriginStep step = (OffsetOriginStep)this.getStep(n);
        ImageCoordSystem coords = this.tp.getCoords();
        coords.setFixedOrigin(false);
        if (step == null) {
            step = (OffsetOriginStep)this.createStep(n, x, y);
            if (step != null) {
                return step.getPoints()[0];
            }
        } else {
            TPoint p = step.getPoints()[0];
            if (p != null) {
                Mark mark = (Mark)step.panelMarks.get(this.tp.getID());
                if (mark == null) {
                    double xx = coords.worldToImageX(n, step.worldX, step.worldY);
                    double yy = coords.worldToImageY(n, step.worldX, step.worldY);
                    p.setLocation(xx, yy);
                }
                p.setAdjusting(true, null);
                p.setXY(x, y);
                p.setAdjusting(false, null);
                this.firePropertyChange("step", null, n);
                return p;
            }
        }
        return null;
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    public boolean isFixedCoordinates() {
        return this.fixedCoordinates;
    }

    public void setFixedCoordinates(boolean fixed) {
        if (this.fixedCoordinates == fixed) {
            return;
        }
        XMLControlElement control = new XMLControlElement(this);
        if (this.tp != null) {
            this.tp.changed = true;
            int n = this.tp.getFrameNumber();
            this.steps = new TTrack.StepArray(this, this.getStep(n));
            TFrame.repaintT(this.tp);
        }
        if (fixed) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
        }
        this.fixedCoordinates = fixed;
        Undo.postTrackEdit(this, control);
    }

    @Override
    public Step getStep(int n) {
        if (this.tp != null) {
            int frameCount = this.tp.getPlayer().getVideoClip().getFrameCount();
            if (this.getSteps().length < frameCount) {
                this.steps.setLength(frameCount);
            }
        }
        OffsetOriginStep step = (OffsetOriginStep)this.steps.getStep(n);
        this.refreshStep(step);
        return step;
    }

    @Override
    public boolean isLocked() {
        boolean locked = super.isLocked();
        if (this.tp != null) {
            locked = locked || this.tp.getCoords().isLocked();
        }
        return locked;
    }

    @Override
    public void setTrailVisible(boolean visible) {
    }

    @Override
    public int getStepLength() {
        return OffsetOriginStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    @Override
    public Interactive findInteractive(DrawingPanel panel, int xpix, int ypix) {
        if (!(panel instanceof TrackerPanel && this.isVisible() && this.isEnabled())) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)panel;
        Interactive ia = null;
        Step step = this.getStep(trackerPanel.getFrameNumber());
        if (step != null) {
            ia = step.findInteractive(trackerPanel, xpix, ypix);
        }
        if (ia != null) {
            this.partName = TrackerRes.getString("OffsetOrigin.Position.Name");
            this.hint = TrackerRes.getString("OffsetOrigin.Position.Hint");
        } else {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = TrackerRes.getString("OffsetOrigin.Unmarked.Hint");
        }
        return ia;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel, JMenu menu0) {
        JMenu menu = super.getMenu(trackerPanel, menu0);
        if (menu0 == null) {
            return menu;
        }
        this.lockedItem.setEnabled(!trackerPanel.getCoords().isLocked());
        this.removeDeleteTrackItem(menu);
        this.fixedCoordinatesItem.setText(TrackerRes.getString("OffsetOrigin.MenuItem.Fixed"));
        this.fixedCoordinatesItem.setSelected(this.isFixedCoordinates());
        menu.add(this.fixedCoordinatesItem);
        menu.addSeparator();
        menu.add(this.deleteTrackItem);
        return menu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> list = super.getToolbarTrackComponents(trackerPanel);
        int n = trackerPanel.getFrameNumber();
        Step step = this.getStep(n);
        list.add(this.stepSeparator);
        if (step == null) {
            this.unmarkedLabel.setText(TrackerRes.getString("TTrack.Label.Unmarked"));
            list.add(this.unmarkedLabel);
        } else {
            this.stepLabel.setText(TrackerRes.getString("TTrack.Label.Step"));
            VideoClip clip = trackerPanel.getPlayer().getVideoClip();
            n = clip.frameToStep(n);
            this.stepValueLabel.setText(String.valueOf(n) + ":");
            list.add(this.stepLabel);
            list.add(this.stepValueLabel);
            list.add(this.tSeparator);
            this.xLabel.setText(dataVariables[0]);
            this.yLabel.setText(dataVariables[1]);
            this.xField.setUnits(trackerPanel.getUnits(this, dataVariables[0]));
            this.yField.setUnits(trackerPanel.getUnits(this, dataVariables[1]));
            boolean locked = trackerPanel.getCoords().isLocked() || super.isLocked();
            this.xField.setEnabled(!locked);
            this.yField.setEnabled(!locked);
            this.displayWorldCoordinates();
            list.add(this.xLabel);
            list.add(this.xField);
            list.add(this.separator);
            list.add(this.yLabel);
            list.add(this.yField);
        }
        return list;
    }

    @Override
    public void setTrackerPanel(TrackerPanel panel) {
        if (this.tp != null) {
            this.tp.removePropertyChangeListener("locked", this);
        }
        super.setTrackerPanel(panel);
        if (this.tp != null) {
            this.tp.addPropertyChangeListener("locked", this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "stepnumber": {
                if (this.tp.getSelectedTrack() == this) {
                    this.displayWorldCoordinates();
                    this.stepValueLabel.setText(e.getNewValue() + ":");
                }
                return;
            }
            case "locked": {
                this.xField.setEnabled(!this.isLocked());
                this.yField.setEnabled(!this.isLocked());
                return;
            }
        }
        super.propertyChange(e);
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        this.xField.setEnabled(!this.isLocked());
        this.yField.setEnabled(!this.isLocked());
    }

    @Override
    public void setFontLevel(int level) {
        super.setFontLevel(level);
        Object[] objectsToSize = new Object[]{this.unmarkedLabel, this.fixedCoordinatesItem};
        FontSizer.setFonts(objectsToSize, level);
    }

    @Override
    public boolean isMarkByDefault() {
        return this.requiresMarking() || super.isMarkByDefault();
    }

    @Override
    public boolean requiresMarking() {
        return this.getStep(0) == null;
    }

    @Override
    public String toString() {
        return TrackerRes.getString("OffsetOrigin.Name");
    }

    @Override
    public Map<String, NumberField[]> getNumberFields() {
        this.numberFields.clear();
        this.numberFields.put(dataVariables[0], new NumberField[]{this.xField});
        this.numberFields.put(dataVariables[1], new NumberField[]{this.yField});
        return this.numberFields;
    }

    @Override
    protected String getTargetDescription(int pointIndex) {
        return TrackerRes.getString("OffsetOrigin.Position.Name");
    }

    protected void refreshStep(OffsetOriginStep step) {
        boolean different;
        if (step == null) {
            return;
        }
        int key = 0;
        Iterator iterator = this.keyFrames.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i > step.n) continue;
            key = i;
        }
        OffsetOriginStep keyStep = (OffsetOriginStep)this.steps.getStep(key);
        boolean bl = different = keyStep.worldX != step.worldX || keyStep.worldY != step.worldY;
        if (different) {
            step.worldX = keyStep.worldX;
            step.worldY = keyStep.worldY;
        }
        step.erase();
    }

    private void setWorldCoordinatesFromFields() {
        boolean different;
        if (this.tp == null) {
            return;
        }
        OffsetOriginStep step = (OffsetOriginStep)this.getStep(this.tp.getFrameNumber());
        boolean bl = different = step.worldX != this.xField.getValue() || step.worldY != this.yField.getValue();
        if (different) {
            XMLControlElement trackControl = new XMLControlElement(this);
            XMLControlElement coordsControl = new XMLControlElement(this.tp.getCoords());
            step.setWorldXY(this.xField.getValue(), this.yField.getValue());
            step.getPosition().showCoordinates(this.tp);
            Undo.postTrackAndCoordsEdit(this, trackControl, coordsControl);
        }
    }

    private void displayWorldCoordinates() {
        int n = this.tp == null ? 0 : this.tp.getFrameNumber();
        OffsetOriginStep step = (OffsetOriginStep)this.getStep(n);
        if (step == null) {
            this.xField.setText(null);
            this.yField.setText(null);
        } else {
            this.xField.setValue(step.worldX);
            this.yField.setValue(step.worldY);
        }
    }

    private void createGUI() {
        this.unmarkedLabel = new JLabel();
        this.unmarkedLabel.setForeground(Color.red.darker());
        this.fixedCoordinatesItem = new JCheckBoxMenuItem(TrackerRes.getString("OffsetOrigin.MenuItem.Fixed"));
        this.fixedCoordinatesItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OffsetOrigin.this.setFixedCoordinates(OffsetOrigin.this.fixedCoordinatesItem.isSelected());
            }
        });
        ActionListener xyAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OffsetOrigin.this.setWorldCoordinatesFromFields();
                ((NumberField)e.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter xyFocusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                OffsetOrigin.this.setWorldCoordinatesFromFields();
            }
        };
        this.xField.addActionListener(xyAction);
        this.xField.addFocusListener(xyFocusListener);
        this.yField.addActionListener(xyAction);
        this.yField.addFocusListener(xyFocusListener);
        this.separator = Box.createRigidArea(new Dimension(4, 4));
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl control, Object obj) {
            OffsetOrigin offset = (OffsetOrigin)obj;
            XML.getLoader(TTrack.class).saveObject(control, obj);
            control.setValue("fixed_coordinates", offset.isFixedCoordinates());
            if (!offset.steps.isEmpty()) {
                Step[] steps = offset.getSteps();
                double[][] stepData = new double[steps.length][];
                int i = 0;
                while (i < steps.length) {
                    if (steps[i] != null && offset.keyFrames.contains(i)) {
                        OffsetOriginStep step = (OffsetOriginStep)steps[i];
                        stepData[i] = new double[]{step.worldX, step.worldY};
                        if (!control.getPropertyNamesRaw().contains("worldX")) {
                            control.setValue("worldX", step.worldX);
                            control.setValue("worldY", step.worldY);
                        }
                    }
                    ++i;
                }
                control.setValue("world_coordinates", stepData);
            }
        }

        @Override
        public Object createObject(XMLControl control) {
            return new OffsetOrigin();
        }

        @Override
        public Object loadObject(XMLControl control, Object obj) {
            OffsetOrigin offset = (OffsetOrigin)obj;
            XML.getLoader(TTrack.class).loadObject(control, obj);
            boolean locked = offset.isLocked();
            offset.setLocked(false);
            if (control.getPropertyNamesRaw().contains("fixed_coordinates")) {
                offset.fixedCoordinates = control.getBoolean("fixed_coordinates");
            }
            offset.keyFrames.clear();
            if (offset.steps.isEmpty()) {
                offset.createStep(0, 0.0, 0.0);
            }
            offset.keyFrames.clear();
            double[][] stepData = (double[][])control.getObject("world_coordinates");
            if (stepData != null) {
                int i = 0;
                while (i < stepData.length) {
                    if (stepData[i] != null) {
                        OffsetOriginStep step = (OffsetOriginStep)offset.getStep(i);
                        step.worldX = stepData[i][0];
                        step.worldY = stepData[i][1];
                        offset.keyFrames.add(i);
                    }
                    ++i;
                }
            } else {
                OffsetOriginStep step = (OffsetOriginStep)offset.getStep(0);
                step.worldX = control.getDouble("worldX");
                step.worldY = control.getDouble("worldY");
                offset.keyFrames.add(0);
            }
            offset.setLocked(locked);
            offset.displayWorldCoordinates();
            return obj;
        }
    }
}

